<?php

/**
 * DocumentModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class CertificaterequestModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getEmployeeCertificate($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM EmployeeCertificate WHERE OrganizationId = ? and EmployeeId = ? and OriginalDocSts = 1" ;
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array($orgid ,$mid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->CertificateTypeId;
				$res['document'] = $this->getName($row->CertificateTypeId, "CertificateMaster");
				$res['documentnumber'] = $row->CertificateNumber;
				$res['vsts'] = false;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = CERTIFICATE_REQUEST_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
		try{
			//$id=Utils::decode5t($id);
			$sql = "SELECT * FROM CertificateReleaseMaster WHERE Id = :id";
			$query = $this->db->prepare($sql);			
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = $row->Id;
					$res['employeeid'] = (int)$row->EmployeeId;
					$res['employee'] = $this->getName($row->EmployeeId,'EmployeeMaster');
					$res['reason'] = $row->Remarks;
					$res['address'] = $row->Address_to;
					$res['approverid'] =$this->getName( $row->ApproverId,'EmployeeMaster');
					$res['appsts'] = ($row->ApproverSts==0)?3:$row->ApproverSts;
					$res['requestdocid'] = $row->RequestDocId;
					$res['addressto'] = $row->Address_to;
					
					
					$docs= ($row->RequestDocId=="")?"0":$row->RequestDocId;
					$sql1 = "SELECT * FROM CertificateLetter where Id in ( ".$docs." ) and  OrganizationId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $orgid ));
					while($row1 = $query1->fetch())
					{
						$res1 = array();
						$res1['id'] = $row1->Id;
						$res1['name'] = $row1->Name;
						$res['docs'][] = $res1;
					}
					$data[] = $res;
				}
			} else {
			   $status =false;
			   $errorMsg = CERTIFICATE_REQUEST_MODULE_GETDETAIL_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
	 public function Approve($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		
		try{
			$docid =  $request[2];
			$sql = "UPDATE CertificateApproval SET LeaveStatus =?, ApprovalDate =?, ApproverComment=? WHERE CertificateId =? AND ApproverId=? and OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[3], $mdate, $request[4], $docid, $mid, $orgid));
			$count =  $query->rowCount();		
			
			if ($count >= 1) {
			   $status =true;
			   
			   if($request[3]==2){
					$successMsg = CERTIFICATE_REQUEST_APPROVED;
					
					$sql1 = "select * from CertificateApproval WHERE CertificateId = ? and LeaveStatus<>2 and OrganizationId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $docid, $orgid));
					if($query1->rowCount()==0)
					{
						$sql2 = "UPDATE CertificateReleaseMaster SET ApproverSts =? WHERE Id =? ";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array(2, $docid));
					}
					$docid = explode(",",$request[2]);
					for($i=0; $i<count($docid); $i++)
					{
						$sql = "UPDATE EmployeeCertificate SET ReleaseSts=? where Id=?";
						$query = $this->db->prepare($sql);
						$query->execute(array(1, $docid[$i]));
						
					}
					
			   }else{
				$successMsg = CERTIFICATE_REQUEST_REJECTED;
				$sql2 = "UPDATE CertificateReleaseMaster SET ApproverSts =? WHERE Id =? ";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array(1, $docid));
			   }
			  
			} else {
			   $status =false;
			   $errorMsg = CERTIFICATE_REQUEST_MODULE_UPDATION_FAILED;
			}
		}catch(Exception $e) {
			$status =false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
    /**
     * Setter for a CertificateReleaseMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
  

	public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		//$rdate = isset($request[2])?Utils::getDateformat($request[2]):;
		$id=$request[5];
			$sql = "UPDATE CertificateReleaseMaster SET  Remarks =?, Address_to=?, RequestDocId= ?, LastModifiedDate=?, LastModifiedById=? where Id=?";
			$query = $this->db->prepare($sql);
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute(array( $request[2],$request[6],$request[3],  $mdate, $mid, $id));			
				$count =  $query->rowCount();
				
			
			if ($count == 1) {
				///////Activity Log History File//////////
				$empId=Utils::getName($id,'CertificateReleaseMaster','EmployeeId',$this->db);
				$empname=Utils::getEmployeeName($empId,$this->db);
				$docId=Utils::getName($request[3],'CertificateLetter','Name',$this->db);
				$msg="<b>$empname</b> updated the <b>$docId</b> certificate request";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Self Service", $msg, $orgid));
			   $status =true;
			   $successMsg = CERTIFICATE_REQUEST_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = CERTIFICATE_REQUEST_MODULE_UPDATION_FAILED;
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a CertificateReleaseMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$sql1= "select * from CertificateReleaseMaster where EmployeeId=? and RequestDocId=? and OrganizationId=?";
		$query1= $this->db->prepare($sql1);
		$query1->execute(array($request[4],$request[3],$orgid));
		$count1=$query1->rowCount();
		if($count1>=1){
			 $status =false;
			 $errorMsg="Already send request";
		}else{
			$sql = "INSERT INTO CertificateReleaseMaster (EmployeeId,  Remarks,Address_to, RequestDocId, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (? ,? , ?, ?, ?, ?, ?, ?, ?, ?)";
			
			try{
				$query = $this->db->prepare($sql);
				$query->execute(array($request[4], $request[2],$request[5],$request[3], $orgid, $mdate, $mid, $mdate, $mid, $mid));
			
				$count =  $query->rowCount();		
			
				
				if ($count == 1) {	
					///////Activity Log History File//////////
					$empname=Utils::getEmployeeName($request[4],$this->db);
					$docId=Utils::getName($request[3],'CertificateLetter','Name',$this->db);
					$msg="<b>$empname</b> request for the <b>$docId</b> certificate ";
					$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
					$query = $this->db->prepare($sql);
					$query->execute(array($mid, "Self Service", $msg, $orgid));				
				   $status =true;
				   $successMsg = CERTIFICATE_REQUEST_MODULE_CREATION_SUCCESS;
				   $leaveid = $this->db->lastInsertId();
				  
					$senior = Utils::getSeniorId($request[4], $this->db);
					if($senior!=0)
					{
						$sql = "INSERT INTO CertificateApproval (  CertificateId, ApproverId, LeaveStatus, CreatedDate,  OrganizationId) VALUES (?, ?, ?, ?, ?)";
						$query = $this->db->prepare($sql);
						$query->execute(array($leaveid, $senior, 3, $mdate, $orgid));
						$empname=Utils::getEmployeeName($request[4],$this->db);
						$seniorname=Utils::getEmployeeName($senior,$this->db);
						$senioremail=Utils::getName($senior,'EmployeeMaster','CompanyEmail',$this->db);
						$title="Certificate request";
						$msg="<table>
								<tr><td>Hello $seniorname,</td></tr>
								<tr><td>$empname has requested for certificate release. Kindly approve the request.</td></tr>
								<tr><td>Thanks</td></tr>
						</table>";
						Utils::sendMail($senioremail,"UBIHRM",$title,$msg);
						
					}
				} else {
				   $status =false;
				   $errorMsg = CERTIFICATE_REQUEST_MODULE_CREATION_FAILED;
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "DELETE FROM CertificateReleaseMaster WHERE Id = :id ";
		
		try{
			
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = CERTIFICATE_REQUEST_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = CERTIFICATE_REQUEST_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				if($table == 'EmployeeMaster')
				{
					$name = $row->FirstName.' '.$row->LastName;
				}
				else{
					$name = $row->Name;
				}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getCertificateName($ids)
	{
		$name ="";
		$orgid = $_SESSION['ubihrm_org_id'];
		$sql = "SELECT Name FROM CertificateMaster WHERE Id in ($ids) and OrganizationId=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid ));
			while($row = $query->fetch())
			{
				if($name == '')
				{
					$name = $row->Name;
				}
				else{
					$name .= ", ".$row->Name;
				}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getCertificate($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$docid = $row->CertificateTypeId;
				$sql1 = "SELECT * FROM CertificateMaster WHERE Id = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $docid ));
				if($row1= $query1->fetch())
				{
					$name=$row1->Name;
				}
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	
	
	public function getTableData($editper,$viewper)
	{
		$sTable = 'CertificateReleaseMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId','ReleaseFrom'  ,'ReleaseTo','ApproveDate','RequestDocId' ,'ApproverId', 'ApproverSts', 'Id');
		$empid = $_SESSION['ubihrm_user_id'];
		$sLimit = "";
		$app="";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		 /*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$userid=$_SESSION['ubihrm_user_id'];
		$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid";
		}else{
			$sWhere = " WHERE (EmployeeId in ($ids) AND OrganizationId= $orgid) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
					$id=Utils::encode5t($aRow->Id);
					$edit = '<a rel="tooltip" title="Edit" href="'.URL.'employee/editdocumentrequest/'.$id.'" ><i class="fa fa-edit"></i></a>';
					$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
								
					$row[] =$edit.'&nbsp;&nbsp;|&nbsp;&nbsp;'.$delete ;
				}
				
				else if($aColumns[$i]=="ReleaseFrom" || $aColumns[$i]=="ReleaseTo" || $aColumns[$i]=="ApproveDate"){
					if($aRow->{$aColumns[$i]} == '0000-00-00'){
						$row[] ="";
					}else{
						$row[] =Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}	
				elseif($aColumns[$i]=="EmployeeId"){
					$id=Utils::encode5t($aRow->Id);
					$row[] ='<a rel="tooltip"  href="'.URL.'employee/viewdocumentrequest/'.$id.'/1" > '.$this->getName($aRow->{$aColumns[$i]},'EmployeeMaster').'</a>';
				}					
				elseif($aColumns[$i]=="ApproverSts"){
					$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="RequestDocId"){
					$row[] = $this->getCertificateName($aRow->{$aColumns[$i]});
				}				
				elseif($aColumns[$i]=="ApproverId")
				{
					if($aRow->ApproverSts == 2){
						$name = $this->getName($aRow->{$aColumns[$i]},'EmployeeMaster');
					}else{
						$name="";
					}
					
					$row[] = $name;
				}
				else{
				$row[] = $aRow->{$aColumns[$i]};
				}		
			}	
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		
		$sTable = 'CertificateReleaseMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		$aColumns = array( 'EmployeeId','ReleaseFrom'  ,'ReleaseTo','ApproveDate','RequestDocId' ,'ApproverId', 'ApproverSts', 'Id');
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{	
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			isset($sOrder) ? $sOrder : ''; 
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}else{
			$sOrder = "ORDER BY ApproveDate desc";
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		//$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = "";
		
		$sWhere = " WHERE OrganizationId= $orgid AND Id IN (SELECT CertificateId FROM CertificateApproval Where ApproverId=$userid)";
			//Where ApproverId=$userid 
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		
		/* Individual column filtering */
		
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		
		$sQuery = "
		 SELECT SQL_CALC_FOUND_ROWS   ".str_replace(" , ", " ", implode(", ", $aColumns))."  
		FROM   $sTable 
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
										
					$edit =""; $delete="";
					if($aRow->ApproverSts==3 ){
						$id=Utils::encode5t($aRow->{$aColumns[$i]});
						$edit = '<a rel="tooltip" title="Require Approval" href="'.URL.'employee/editdocumentapproval/'.$id.'" class="text-green"><i class="fa fa-thumbs-up"></i></a>';
					}
					
					$row[] =$edit;
					
				}
				elseif($aColumns[$i]=="ApproverSts"){
                    
					$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
                 }
				 elseif($aColumns[$i]=="EmployeeId"){
                    $id=Utils::encode5t($aRow->Id);
					$row[] = '<a rel="tooltip" title="View Request" href="'.URL.'employee/viewdocumentapproval/'.$id.'/1" >'.Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db).'</a>';
                 }
				elseif($aColumns[$i]=="ApproveDate" || $aColumns[$i]=="ReleaseFrom" || $aColumns[$i]=="ReleaseTo"){
					if(($aRow->{$aColumns[$i]})=="0000-00-00")
					{
						$row[]="-";
					}else{
						$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				elseif($aColumns[$i]=="RequestDocId"){
					$row[] = $this->getCertificateName($aRow->{$aColumns[$i]});
				}				
				elseif($aColumns[$i]=="ApproverId")
				{
					if($aRow->ApproverSts == 2){
						$name = $this->getName($aRow->{$aColumns[$i]},'EmployeeMaster');
					}else{
						$name="";
					}
					
					$row[] = $name;
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getAllApprover($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$orgid = $request[1];
		$documentid = $request[2];
		
		$s1="SELECT * from CertificateApproval WHERE OrganizationId=? and CertificateId = ?";
		$query = $this->db->prepare($s1);
		$query->execute(array($orgid, $documentid));
		while($row = $query->fetch())
		{
			$res = array();
			$res['id'] = $row->Id;
			$res['name'] = Utils::getEmployeeName($row->ApproverId, $this->db);
			$res['sts'] = $row->LeaveStatus;
			$res['comment'] = $row->ApproverComment;
			$res['approvaldate'] = Utils::datetimeformatter($row->ApprovalDate);
			$data[] = $res;
			
			$successMsg=""; $status=true;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
}

