<?php

/**
 * SalaryapprovalModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class CertificateapprovalModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM CertificateApproval WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = DOCUMENT_REQUEST_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getCertificate($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
			
		
        $sql = "SELECT * FROM CertificateReleaseMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id; 
				$res['sts'] = $row->ApproverSts;      
				$res['empid'] = $row->EmployeeId; 
				$res['addressto'] = $row->Address_to;				
				$res['employeeid'] 	= Utils::getEmployeeName($row->EmployeeId, $this->db);
				$res['reason'] 	= $row->Remarks;
				$requestdoc	= isset($row->RequestDocId)?explode(',',$row->RequestDocId):0;
				for($i=0;$i<count($requestdoc);$i++)
				{
					$sql1 = "SELECT * FROM CertificateLetter WHERE Id = :id";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array(':id' => $requestdoc[$i] ));
					while($row1 = $query1->fetch())
					{
						
						$res['name'] = $row1->Name;
						$templateid = $row1->TemplateId;
						$sql2 = "SELECT * FROM TemplateMaster WHERE Id = :id";
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array(':id' => $templateid ));
						while($row2 = $query2->fetch())
						{
							$res['desc']=$row2->Message;
						}
					
					}
				
				}
				
				$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $row->EmployeeId ));
				while($r = $query1->fetch())
				{
					$res['division'] 	= Utils::getName($r->Division, 'DivisionMaster', 'Name', $this->db);
					$res['department'] 	= Utils::getName($r->Department, 'DepartmentMaster', 'Name', $this->db);
					$res['designation'] 	= Utils::getName($r->Designation, 'DesignationMaster', 'Name', $this->db);
					$res['reportingto'] 	= Utils::getEmployeeName($r->ReportingTo,  $this->db);
				}
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = "";
        } else {
           $status =false;
		   $errorMsg = CERTIFICATE_REQUEST_MODULE_GETALL;
        }
		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
			
		
        $sql = "SELECT * FROM CertificateReleaseMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			while($row = $query->fetch())
			{
				$res = array();
				$res['sts'] 		= $row->ApproverSts;      
				$res['employeeid'] 	= Utils::getEmployeeName($row->EmployeeId, $this->db);
				$res['reason'] 	= $row->Remarks;
				$res['addressto'] = $row->Address_to;
				$requestdoc	= isset($row->RequestDocId)?explode(',',$row->RequestDocId):0;
				for($i=0;$i<count($requestdoc);$i++)
				{
					$sql1 = "SELECT * FROM CertificateLetter WHERE Id = :id";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array(':id' => $requestdoc[$i] ));
					while($row1 = $query1->fetch())
					{
						$res1 = array();
						$res1['id'] = $row1->Id;
						$res1['name'] = $row1->Name;
						$res['docs'][] = $res1;
						
					}
				
				}
				
				$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $row->EmployeeId ));
				while($r = $query1->fetch())
				{
					$res['division'] 	= Utils::getName($r->Division, 'DivisionMaster', 'Name', $this->db);
					$res['department'] 	= Utils::getName($r->Department, 'DepartmentMaster', 'Name', $this->db);
					$res['designation'] 	= Utils::getName($r->Designation, 'DesignationMaster', 'Name', $this->db);
				}
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = "";
        } else {
           $status =false;
		   $errorMsg = CERTIFICATE_REQUEST_MODULE_GETALL;
        }
		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
   
	 public function Approve($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		
		$sql = "UPDATE CertificateApproval SET LeaveStatus =?, ApprovalDate =?, ApproverComment=? WHERE CertificateId =? AND ApproverId=? and OrganizationId=?";
		try{
			$query = $this->db->prepare($sql);
			$query->execute(array($request[3], $mdate, $request[4], $request[2], $mid, $orgid));
			$count =  $query->rowCount();		
			
        if ($count >= 1) {
           $status =true;
		   if($request[3]==2){
				$successMsg = CERTIFICATE_REQUEST_APPROVED;
				$sql1 = "select * from CertificateApproval WHERE CertificateId = ? and LeaveStatus<>2 and OrganizationId=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $request[2], $orgid));
				if($query1->rowCount()==0)
				{
					$sql2 = "UPDATE CertificateReleaseMaster SET ApproverSts =?,ApproveDate=?,ApproverId=?,LastModifiedDate=?,LastModifiedById=? WHERE Id =? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array(2, $mdate , $mid ,$mdate,$mid, $request[2]));
				}
				
		   }else{
					$sql2 = "UPDATE CertificateReleaseMaster SET ApproverSts =?,ApproveDate=?,ApproverId=?,LastModifiedDate=?,LastModifiedById=? WHERE Id =? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array(1, $mdate , $mid ,$mdate ,$mid, $request[2]));
			$successMsg = CERTIFICATE_REQUEST_REJECTED;
		   }
		  
        } else {
           $status =false;
		   $errorMsg = CERTIFICATE_REQUEST_MODULE_GETDETAIL_FAILED;
        }
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
  
   
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		
		
		try{
			$sql = "DELETE FROM CertificateApproval WHERE CertificateId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			$sql = "DELETE FROM CertificateReleaseMaster WHERE Id = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = CERTIFICATE_REQUEST_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = CERTIFICATE_REQUEST_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getApproverSts($id,$userid)
	{
		$name =false;
		$sql = "SELECT * FROM CertificateApproval WHERE CertificateId = ? and ApproverId=? and LeaveStatus=3";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id,$userid ));
			while($row = $query->fetch())
			{
				$name=true;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		
		$sTable = 'CertificateReleaseMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		$aColumns = array( 'EmployeeId','RequestDocId','ApproveDate','ApproverId', 'ApproverSts','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{	
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			isset($sOrder) ? $sOrder : ''; 
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}else{
			$sOrder = "ORDER BY  CreatedDate desc";
		}
		
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = "";
		
		$sWhere = " WHERE OrganizationId= $orgid AND Id IN (SELECT CertificateId FROM CertificateApproval Where ApproverId=$userid )";
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		
		/* Individual column filtering */
		
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		
		$sQuery = "
		 SELECT SQL_CALC_FOUND_ROWS   ".str_replace(" , ", " ", implode(", ", $aColumns))."  
		FROM   $sTable 
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$encodeid = Utils::encode5t($aRow->Id);					
					$edit =""; $delete="";
					$sts=$this->getApproverSts($aRow->Id,$userid);
					if($sts && $aRow->ApproverSts==3){			
						
						$edit = '<a rel="tooltip" title="Require Approval" href="'.URL.'employee/editcertificateapproval/'.$encodeid.'" class="text-green"><i class="fa fa-thumbs-up"></i></a>';
					}
					
					
					$row[] =$edit;
					
				}
				elseif($aColumns[$i]=="ApproverSts"){
                    
					$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
                 }
				 elseif($aColumns[$i]=="RequestDocId"){
                    
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'CertificateLetter','Name',$this->db);
                 }
				 elseif($aColumns[$i]=="ApproverId"){
                    
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
                 }
				 elseif($aColumns[$i]=="EmployeeId"){
                    $encodeid = Utils::encode5t($aRow->Id);
					$row[] = '<a rel="tooltip" title="View Details" href="'.URL.'employee/viewcertificateapproval/'.$encodeid.'/1" >'.Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db).'</a>';
                 }
				elseif($aColumns[$i]=="ApproveDate" ){
					if($aRow->{$aColumns[$i]} == "0000-00-00 00:00:00"){
						$row[] = "-";
					}else{
						$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getReleaseTable($editper, $deleteper)
	{
		
		$sTable = 'CertificateReleaseMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		$aColumns = array( 'EmployeeId','RequestDocId','ApproveDate','ApproverId', 'ApproverSts','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{	
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			isset($sOrder) ? $sOrder : ''; 
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}else{
			$sOrder = "ORDER BY  CreatedDate desc";
		}
		
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = "";
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE OrganizationId= $orgid AND ApproverSts<>3";
		}else{
			$sWhere = " WHERE OrganizationId= $orgid AND ApproverSts<>3 and EmployeeId in ($ids)";
		}	
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="EmployeeId"){
				$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		
		/* Individual column filtering */
		
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		
		$sQuery = "
		 SELECT SQL_CALC_FOUND_ROWS   ".str_replace(" , ", " ", implode(", ", $aColumns))."  
		FROM   $sTable 
		$sWhere 
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$encodeid = Utils::encode5t($aRow->Id);					
					$edit =""; $delete="";
					
					if($aRow->ApproverSts==2 && $hrsts==1){			
						
						$edit = '<a rel="tooltip" title="Issue Certificate" href="'.URL.'employee/sendcertificateapproval/'.$encodeid.'" class="text-green"><i class="fa fa-envelope"></i></a>&nbsp;&nbsp;|&nbsp;&nbsp;';
						
					}
					if($hrsts==1 || $sts==1){	
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}
					$row[] =$edit.$delete;
					
				}
				elseif($aColumns[$i]=="ApproverSts"){
                    
					$row[] = Utils::getleavetype($aRow->{$aColumns[$i]});
                 }
				 elseif($aColumns[$i]=="RequestDocId"){
                    
					$row[] = Utils::getName($aRow->{$aColumns[$i]},'CertificateLetter','Name',$this->db);
                 }
				 elseif($aColumns[$i]=="ApproverId"){
                    
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
                 }
				 elseif($aColumns[$i]=="EmployeeId"){
                   // $encodeid = Utils::encode5t($aRow->Id);
					//$row[] = '<a rel="tooltip" title="View Details" href="'.URL.'employee/viewcertificateapproval/'.$encodeid.'/1" >'.Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db).'</a>';
					$row[] = Utils::getEmployeeName($aRow->{$aColumns[$i]}, $this->db);
                 }
				elseif($aColumns[$i]=="ApproveDate" ){
					if($aRow->{$aColumns[$i]} == "0000-00-00 00:00:00"){
						$row[] = "-";
					}else{
						$row[] =  Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	
	public function getAllApprover($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$orgid = $request[1];
		$leaveid = $request[2];
		
		try{
			$s1="SELECT * from CertificateApproval WHERE OrganizationId=? and CertificateId = ? and LeaveStatus<>3";
			$query = $this->db->prepare($s1);
			$query->execute(array($orgid, $leaveid));
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = Utils::getEmployeeName($row->ApproverId, $this->db);
				$res['sts'] = $row->LeaveStatus;
				$res['comment'] = $row->ApproverComment;
				$res['approvaldate'] = Utils::datetimeformatter($row->ApprovalDate);
				$data[] = $res;
				
				$successMsg=""; $status=true;
			}
		}
		catch(Exception $d){
			$errorMsg=$e->getMessage();
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
}
