<?php

/**
 * AttendanceModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class AttendanceModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

	/**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAllByCondition($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$cond= "";
			
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$arr = array();
			$arr[0] = $orgid;
			$arr[1] = $orgid;
			$sWhere ="";
		//$ids =$this->getReportingIds($mid);
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = "  ";
		}else{
			$sWhere = " and ReportingTo=$mid ";
		}
		
		$aColumns = array('Department', 'Designation', 'Shift', 'Division','Id');
			
		$sWhere .= " and ";
		$index=2;
			for ( $i=0 ; $i<count($request)-2 ; $i++ )
			{
				if($request[$i+2]!=0){
					$sWhere .= $aColumns[$i]." = ?  and ";
					$arr[$index++] = $request[$i+2];
				}
			}
			
			$sWhere = substr_replace( $sWhere, "", -4 );
			
		$sts=1;	
		$date = $_POST['atdate'];
		
		$date = Utils::getDateformat( $date );
		
		////////  FIND OUT THE HOLIDAY ON THE DAY OF ATTENDANCE  ///////////////////////
		
		$holidaycount=0;
		$sql = "SELECT  Id FROM HolidayMaster WHERE OrganizationId = ?  and ('$date' between DateFrom and DateTo)";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array($orgid));
			$holidaycount =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//////////////////////////////////////////////////////////////////////////////
		
		///////// FETCH ALL RECORD OF ALL EMPLOYEE FOR THE DAY OF ATTENDANCE  ////////////////////////
		
			$sql = "SELECT Id, EmployeeCode, FirstName, LastName, Shift FROM EmployeeMaster WHERE OrganizationId = ? and Is_Delete=0 and (DOL='0000-00-00' OR DOL>='$date') and DOJ<='$date' and Id not in (select EmployeeId from SeveranceMaster where OrganizationId=? and EffectDate<='$date') and Id not in (select EmployeeId from AttendanceMaster where AttendanceDate='$date' and OrganizationId = $orgid)".$sWhere." Order by Shift, FirstName, LastName";
			$query = $this->db->prepare($sql);
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
				$query->execute($arr);
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
				

				///////////	 FIND OUT THE ANY LEAVE ON THE DAY OF ATTENDANCE FOR THE EMPLOYEE  //////////////////////
					$leavecount=0;
					$sqlleave = "SELECT  Id FROM EmployeeLeave WHERE OrganizationId = ? and EmployeeId = ? and LeaveStatus=2 and ('$date' between LeaveFrom and LeaveTo)";
					$queryleave = $this->db->prepare($sqlleave);
					try{
						$queryleave->execute(array($orgid, $row->Id));
						$leavecount =  $queryleave->rowCount();
					}catch(Exception $e) {
						$errorMsg = 'Message: ' .$e->getMessage();
					}
				/////////////////////////////////////////////////////////////////////////////////////////////////////
				
					
						
				
					//////////////  FIND OUT THE WEEK OFF AND HALF DAY ON THE DAY OF ATTENDANCE FOR AN EMPLOYEE /////////
						$empid=$row->Id;
						$weekofflg=false;$halfflg=false;
						$weekno=Utils::weekOfMonth($date);
						$dayofdate= 1 + date("w", strtotime($date));
						$sql2 = "SELECT WeekOff FROM ShiftMasterChild where ShiftId=(select shift from EmployeeMaster where Id=$empid) and Day=$dayofdate";
						//Utils::Trace($sql2." Date used - ".$leavefrom." day of month -  ".$dayofdate." week of month - ".$weekno);
						$query2 = $this->db->prepare($sql2);
						$query2->execute(array());
						$week="";
						if($row2 = $query2->fetch()){
							$week=$row2->WeekOff;
						}
						$weekarr=explode(",",$week);
						if($query2->rowCount()>0){
							if($weekarr[$weekno-1]==1){
								$weekofflg=true; 
							}else if($weekarr[$weekno-1]==2){
								$halfflg=true;  
							}
						}
						
						/* $temp = explode(',', $day);
						for($s=0; $s<count($temp); $s++)
						{	
							$d = (int)$temp[$s];
							if($d==3){
								if($weekday==$s+1){  ////// CONDITION CHECKING FOR TODAY IS WEEK OFF OR NOT
									$weekofflg=true; 
								}
							}elseif($d==2){
								if($weekday==$s+1){ ////// CONDITION CHECKING FOR TODAY IS HALF DAY OR NOT
									$halfflg=true;  
								}
							}
						} */
					/////////////////////////////////////////////////////////////////////////////////////////////////////		
					//// status 1 for present, 2 for absent, 3 for weekoff, 4 for halfday,
					////	5 for holiday, 6 for leave
						$sts=1;
						if($holidaycount>0){
							$sts=5;
						}
						if($halfflg){
							$sts=4;
						}
						if($weekofflg){
							$sts=3;
						}
						if($leavecount>0){
							$sts=6;
						}
							$res = array();
							$res['id'] = $row->Id;
							$res['empcode'] = $row->EmployeeCode;
							$res['empname'] = ucwords(strtolower($row->FirstName." ".$row->LastName));
							$res['timein'] = "00:00";
							$res['timeout'] = "00:00";
							$res['shifttimein'] = "00:00";
							$res['shifttimeout'] = "00:00";
							$res['shifttimeinbreak'] = "00:00";
							$res['shifttimeoutbreak'] = "00:00";
							$res['totaltime'] = "00:00";
							$res['overtime'] = "00:00";
							$res['sts'] = $sts;
							$res['shift'] = $row->Shift;
							
							//if(($weekofflg) || ($holidaycount>0) || $leavecount>0){
							//}else{
							$sql1 = "SELECT TimeIn, TimeOut, TimeInBreak, TimeOutBreak, TIME_FORMAT(TIMEDIFF( TIME_FORMAT(TIMEDIFF(TimeOut, TimeIn),'%H:%i'),TIME_FORMAT(TIMEDIFF(TimeOutBreak, TimeInBreak),'%H:%i')),'%H:%i') as totaltime FROM ShiftMaster WHERE Id = ? ";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array($row->Shift));
							while($row1 = $query1->fetch())
							{
								$res['totaltime'] = $row1->totaltime;
								
								$res['timein'] = $row1->TimeIn;
								
								$res['shifttimein'] = $row1->TimeIn;
								
								$res['shifttimeinbreak'] = $row1->TimeInBreak;
								$res['shifttimeoutbreak'] = $row1->TimeOutBreak;
								//////////// if half day then time should change to half day
								if($halfflg){
									$res['timeout'] = $row1->TimeInBreak;
									$res['shifttimeout'] = $row1->TimeInBreak;
								}else{
									$res['timeout'] = $row1->TimeOut;
									$res['shifttimeout'] = $row1->TimeOut;
								}
							}
							if(($weekofflg) || ($holidaycount>0) || $leavecount>0){
							
								$res['timein'] = "00:00";
								$res['timeout'] = "00:00";
								$res['totaltime'] = "00:00";
								$res['overtime'] = "00:00";
							}
							//}
							$data[] = $res;
						//}
					
				}
				
				/*if(count($data)==0){
					$status=false;
					$errorMsg = "All Employee having weekoff on this day";
				}*/
			}else{
				$status=false;
				$errorMsg = ATTENDANCE_MODULE_FILTER;
			}
		/*}else{
				$status=false;
				$errorMsg = "Holiday found";
			}*/
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM AttendanceMaster WHERE OrganizationId = :id ";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['empid'] = $row->EmployeeId;
				$res['atdate'] = $row->AttendanceDate;
				$res['timein'] = date("H:i", strtotime($row->TimeIn));
				$res['timeout'] = date("H:i", strtotime($row->TimeOut));
				$res['sts'] = $row->AttendanceStatus;
				$res['shiftid'] = $row->ShiftId;				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = ATTENDANCE_MODULE_GETALL;
		}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		
        $sql = "SELECT am.Id as id, EmployeeId, AttendanceDate, am.TimeIn, am.TimeOut, AttendanceStatus, ShiftId, sm.TimeIn as shifttimein, sm.TimeOut as shifttimeout,sm.TimeInBreak as shiftbreakin ,sm.TimeOutBreak as shiftbreakout FROM AttendanceMaster am, ShiftMaster sm WHERE am.ShiftId=sm.Id and am.Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->id;
				$res['empcode'] = $this->getEmployeeCode($row->EmployeeId);
				$res['empname'] = $this->getName($row->EmployeeId);
				$res['empid'] = $row->EmployeeId;
				$res['atdate'] =  Utils::dateformatter($row->AttendanceDate);
				$res['timein'] = $row->TimeIn;
				$res['timeout'] = $row->TimeOut;
				$res['sts'] = (int)$row->AttendanceStatus;
				$res['shiftid'] = $row->ShiftId;
				/*if($row->AttendanceStatus>=3 && $row->AttendanceStatus<=6){
					$res['shifttimein'] = "00:00";
					$res['shifttimeout'] = "00:00";
					$res['shifttimeinbreak'] = "00:00";
					$res['shifttimeoutbreak'] = "00:00";
				}else{
					$res['shifttimein'] = $row->shifttimein;
					$res['shifttimeout'] = $row->shifttimeout;
					$res['shifttimeinbreak'] = $row->shiftbreakin;
					$res['shifttimeoutbreak'] = $row->shiftbreakout;
				}*/
				$res['shifttimein'] = $row->shifttimein;
				$res['shifttimeout'] = $row->shifttimeout;
				$res['shifttimeinbreak'] = $row->shiftbreakin;
				$res['shifttimeoutbreak'] = $row->shiftbreakout;
				$res['totaltime'] = "00:00";
				$res['overtime'] = "00:00";
				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = ATTENDANCE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = ATTENDANCE_MODULE_GETDETAIL_FAILED;
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['curdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a AttendanceMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$res = json_decode($request[2], true); 
		
		for($i=0; $i<count($res); $i++)
		{
			$sql = "UPDATE AttendanceMaster SET AttendanceStatus=?, TimeIn=?, TimeOut=?, Overtime=?, LastModifiedDate=?, LastModifiedById=? where Id=?";
			$query = $this->db->prepare($sql);
			
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				if($res[$i]['sts']==2){
					$query->execute(array($res[$i]['sts'], '00:00:00', '00:00:00', '00:00:00', $mdate, $mid, $request[3]));	
					$attendancelog="AttendanceId: ".$request[3]." | TimeIn: '00:00:00' | TimeOut: '00:00:00' | AttendanceStatus: ".$res[$i]['sts']." | Device: ' UBIHRM- Update()->AttendanceModel' | ModifiedBy: ".$mid;
					Utils::TraceAttendance($attendancelog);
					$title="Absent - Unauthorized ";
					$name =Utils::getEmployeeName($res[$i]['id'],$this->db);
					$msg=$name." is Absent without any information";
					$hrarr=Utils::getHR($orgid,$this->db);
					for($j=0;$j<count($hrarr);$j++){
						$sql1 = "INSERT INTO GenerateNotification (  EmployeeId, Title, Message, NotifyDate, OrganizationId) VALUES (?, ?, ?, ?, ?)";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array( $hrarr[$j],$title,$msg,$mdate,$orgid ));	
					}
					
				}else{
					if($res[$i]['timein']=="00:00:00")
						$res[$i]['timein']="00:01:00";
					if($res[$i]['timeout']=="00:00:00")
						$res[$i]['timeout']="00:01:00";
					$query->execute(array($res[$i]['sts'], $res[$i]['timein'], $res[$i]['timeout'], $res[$i]['overtime'], $mdate, $mid, $request[3]));
					
					$attendancelog="AttendanceId: ".$request[3]." | TimeIn: '".$res[$i]['timein']."' | TimeOut: '".$res[$i]['timeout']."' | AttendanceStatus: ".$res[$i]['sts']." | Device: ' UBIHRM- Update()->AttendanceModel' | ModifiedBy: ".$mid;
					Utils::TraceAttendance($attendancelog);					
				}
				
				$name =$res[$i]['empname'];
				$msg="<b>$name</b> Attendance has been updated | TimeIn: <b>'".$res[$i]['timein']."'</b> | UpdatedTimeOut: <b>'".$res[$i]['timeout']."'</b> | UpdatedAttendanceStatus:<b>".Utils::getattendancetype($res[$i]['sts'])."</b>";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Attendance", $msg, $orgid));
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		if ($count == 1) {
		
           $status =true;
		   $successMsg = ATTENDANCE_MODULE_UPDATION_SUCCESS;
		  
		  ////////////////// THIS MESSAGE IS FOR UBITECH SOLUTIONS, FOR UPDATING THE ATTENDANCE/////////////
		   
		  if($orgid==10)
			     $successMsg = "Mail sent successfully to Namrata bhansali, for updating attendance";
        } else {
           $status =false;
		   $errorMsg = ATTENDANCE_MODULE_UPDATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a ShiftMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
		$mdate = date("Y-m-d H:i:s");
		$res = json_decode($request[2], true); 
		$skip=0;
		try{
		for($i=0; $i<count($res); $i++)
		{
			$count +=1;
			$sql1 = "Select EmployeeId from AttendanceMaster WHERE EmployeeId=? and AttendanceDate=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($res[$i]['id'],  Utils::getDateformat($request[3])));
			$count1 =  $query1->rowCount();				
			if($count1==0)
			{			
				if($res[$i]['sts']==2)
				{
					$sql = "INSERT INTO AttendanceMaster ( EmployeeId, AttendanceDate, AttendanceStatus, ShiftId, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, device) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";		
					$query = $this->db->prepare($sql);
					$query->execute(array($res[$i]['id'], Utils::getDateformat( $request[3]), $res[$i]['sts'], $res[$i]['shift'], $orgid, $mdate, $mid, $mdate, $mid, $mid,'Manager'));
					$attendancelog="EmployeeId: ".$request[3]." | TimeIn: '00:00:00' | TimeOut: '00:00:00' | AttendanceStatus: ".$res[$i]['sts']." | Device: ' UBIHRM- Create()->AttendanceModel' | ModifiedBy: ".$mid;
					Utils::TraceAttendance($attendancelog);
					if(Utils::getDateformat( $request[3])==date("Y-m-d"))
					{
						$title="Absent - Unauthorized ";
						$name =Utils::getEmployeeName($res[$i]['id'],$this->db);
						$msg=$name." is Absent today without any information";
						$hrarr=Utils::getHR($orgid,$this->db);
						for($j=0;$j<count($hrarr);$j++){
							$sql1 = "INSERT INTO GenerateNotification (  EmployeeId, Title, Message, NotifyDate, OrganizationId) VALUES (?, ?, ?, ?, ?)";
							$query1 = $this->db->prepare($sql1);
							$query1->execute(array( $hrarr[$j],$title,$msg,$mdate,$orgid ));	
						}
					}
					
				}else{
					$sql = "INSERT INTO AttendanceMaster ( EmployeeId, AttendanceDate, AttendanceStatus, TimeIn, TimeOut, Overtime, ShiftId, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId,device) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";		
					$query = $this->db->prepare($sql);
					if($res[$i]['timein']=="00:00:00")
						$res[$i]['timein']="00:01:00";
					if($res[$i]['timeout']=="00:00:00")
						$res[$i]['timeout']="00:01:00";
					$query->execute(array($res[$i]['id'], Utils::getDateformat( $request[3]), $res[$i]['sts'], $res[$i]['timein'], $res[$i]['timeout'], $res[$i]['overtime'], $res[$i]['shift'], $orgid, $mdate, $mid, $mdate, $mid, $mid,'Manager'));
					
					$attendancelog=$sql." EmployeeId: ".$res[$i]['id']." | TimeIn: '".$res[$i]['timein']."' | TimeOut: '".$res[$i]['timeout']."' | AttendanceStatus: ".$res[$i]['sts']." | Device: ' UBIHRM- Create()->AttendanceModel' | ModifiedBy: ".$mid;
					Utils::TraceAttendance($attendancelog);				
					
				}				
				/////notification if an employee get late 3rd time in a month////
				$temp=date("Y-m-01",strtotime(Utils::getDateformat( $request[3])));
				$temp1=Utils::getDateformat( $request[3]);
				$con=0;
				$shifttimein = $this->getShiftTime($res[$i]['shift'],"TimeInGrace");
				$sql1="select TimeIn from AttendanceMaster where EmployeeId=? and AttendanceDate between '$temp' and '$temp1'";
				$query1=$this->db->prepare($sql1);
				$query1->execute(array($res[$i]['id']));
				while($r=$query1->fetch()){
					if(strtotime($r->TimeIn) > strtotime($shifttimein))
					{
						$con++;
					}
				}	
				
				if($con>=3)
				{
					$name=Utils::getEmployeeName($res[$i]['id'],$this->db);
					$countinwords=$this->getNumberinWords($con);
					$title="$countinwords ($con) instances of late reporting this month ";
					$adate=$request[3];
					$amonth=date("F",strtotime(Utils::getDateformat($request[3])));
					$con1=$con."th";
					if($con==3)
						$con1=$con."rd";
					$msg= "$name has reported late for the $con1 time on $adate in $amonth ";
					$hrarr=Utils::getHR($orgid,$this->db);
					$empids=implode(',',$hrarr);
					$sqln="select Id from NotificationMaster where Name=? and Message=? and EmployeeIds=? and OrganizationId=?";
					$queryn=$this->db->prepare($sqln);
					$queryn->execute(array($title, $msg, $empids, $orgid));
					if($queryn->rowCount()==0){
						$sql1="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($title, $msg, $empids, $orgid, $mdate, $mid, $mdate, $mid, $mid, $mdate, date("Y-m-d", strtotime(date("Y-m-d")." , +1 days ")), 2,2));
					}
				}
				
				$name =$res[$i]['empname'];
				$msg="<b>$name</b> Attendance  has been added | TimeIn: <b>'".$res[$i]['timein']."'</b> | TimeOut: <b>'".$res[$i]['timeout']."'</b> | AttendanceStatus:<b>".Utils::getattendancetype($res[$i]['sts'])."</b>";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Attendance", $msg, $orgid));
				
					$count +=  $query->rowCount();
			}else{
				$skip++;
			}
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
        if ($count >0) {
			$count = $count-count($res);
			
			   $status =true;
			   $successMsg = $count." ".ATTENDANCE_MODULE_CREATION_SUCCESS;
			if($skip>0){
				$successMsg .= $skip." ".ATTENDANCE_MODULE_RECORDSKIP;
			}
        } else {
           $status =false;
		   $errorMsg = ATTENDANCE_MODULE_CREATION_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    /* public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sql = "DELETE FROM AttendanceMaster WHERE Id in ($did) ";
		Utils::TraceAttendance($sql." (by delete() ubihrm AttendanceModel)");				
		try{			
			$query = $this->db->prepare($sql);
			$query->execute();		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
			$empid=Utils::getName($did,'AttendanceMaster','EmployeeId',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Attendance  of $empname has been deleted  ";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Attendance", $msg, $orgid));
           $status =true;
		   $successMsg = ATTENDANCE_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = ATTENDANCE_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    } */
	public function Delete($did)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");		
		//$empcode=0;		
		$orgid=$_SESSION['ubihrm_org_id'];
		$mid=$_SESSION['ubihrm_user_id'];
		try{
			$sql = "Select EmployeeId FROM AttendanceMaster WHERE Id = :id and Is_Delete='0'";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$empcode=$row->EmployeeId;
			} 
			$sql = "update AttendanceMaster set Is_Delete=1, Deleted_Date=? where Id =? ";
			$query = $this->db->prepare($sql);
			$query->execute(array($mdate, $did));
			$count =  $query->rowCount();
	
        if ($count == 1) {
			$empid=Utils::getName($did,'AttendanceMaster','EmployeeId',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Attendance  of $empname has been deleted  ";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Attendance", $msg, $orgid));
           $status =true;
		   $successMsg = ATTENDANCE_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = ATTENDANCE_MODULE_DELETE_FAILED;
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		//$this->db = null;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function restoreAttendance($did)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");		
		//$empcode=0;		
		$orgid=$_SESSION['ubihrm_org_id'];
		$mid=$_SESSION['ubihrm_user_id'];
		try{
			$sql = "Select EmployeeId FROM AttendanceMaster WHERE Id = :id and Is_Delete='1'";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$empcode=$row->EmployeeId;
			} 
			$sql = "update AttendanceMaster set Is_Delete='0', Deleted_Date=? where Id =? ";
			$query = $this->db->prepare($sql);
			$query->execute(array($mdate, $did));
			$count =  $query->rowCount();
	
        if ($count == 1) {
			$empid=Utils::getName($did,'AttendanceMaster','EmployeeId',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Attendance  of $empname has been deleted  ";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Attendance", $msg, $orgid));
           $status =true;
		   $successMsg = "Attendance Restored Successfully";
        }else {
           $status =false;
		   $errorMsg = "Failed to Restored Attendance";
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		//$this->db = null;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function perDelationAttendance($did)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sql = "DELETE FROM AttendanceMaster WHERE Id in ($did) ";
		Utils::TraceAttendance($sql." (by delete() ubihrm AttendanceModel)");				
		try{			
			$query = $this->db->prepare($sql);
			$query->execute();		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
			$empid=Utils::getName($did,'AttendanceMaster','EmployeeId',$this->db);
			$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$msg="Attendance  of $empname has been deleted  ";
			$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($mid, "Attendance", $msg, $orgid));
           $status =true;
		   $successMsg = ATTENDANCE_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = ATTENDANCE_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function delBulkAttendance()
    {
	 	$count =0;
        $did = $_POST['checklist'];
        foreach($did as $id){
    		$sql = "DELETE FROM AttendanceMaster WHERE Id =$id";
			Utils::TraceAttendance($sql." (by deleteblk() ubihrm AttendanceModel)");	
    		 try{			
			$query = $this->db->prepare($sql);
			$query->execute();		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
        }
		
	
		 if ($count == 1) {
		 	$_SESSION["feedback_positive"][] = ATTENDANCE_MODULE_DELETE_SUCCESS;
            return true;
        }else {
		   $_SESSION["feedback_negative"][] = ATTENDANCE_MODULE_DELETE_FAILED;
		   return false;
        }
        // default return
        return false;
	}
	public function getName($id)
	{
		$name ="";
		$sql = "SELECT * FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->FirstName. " " .$row->LastName;
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	public function getEmployeeCode($id)
	{
		$name ="";
		$sql = "SELECT EmployeeCode FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->EmployeeCode;
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	
	public function getEmployeeId($code)
	{
		$name ="";
		$orgid=$_SESSION["ubihrm_org_id"];
		$sql = "SELECT Id FROM EmployeeMaster WHERE EmployeeCode = :id and OrganizationId=:org";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $code , ':org' => $orgid ));
			while($row = $query->fetch())
			{
				$name = $row->Id;
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	
	public function getShift($id)
	{
		$name =" ";
		$sql = "SELECT Name FROM ShiftMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
				
			}
		}catch(Exception $e) {
			
		}
		
		return $name;
	}
	public function getShiftId($id)
	{
		$name =" ";
		$sql = "SELECT Shift FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Shift;
				
			}
		}catch(Exception $e) {
			
		}
		
		return $name;
	}
	
	public function getShiftTime($id,$field)
	{
		$name =" ";
		$sql = "SELECT $field FROM ShiftMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->$field;
				
			}
		}catch(Exception $e) {
			
		}
		
		return $name;
	}
	
	public function getOvertime($timein,$timeout,$id)
	{
		$name =" ";
		$sql = "SELECT * FROM ShiftMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$stime1 = strtotime(date("1980-01-01 ".$row->TimeIn)); 
				$stime2 = strtotime(date("1980-01-01 ".$row->TimeOut)); 
				$time1 = strtotime(date("1980-01-01 ".$timein)); 
				$time2 = strtotime(date("1980-01-01 ".$timeout));  
				$totaltime = ($time2 - $time1);
				$stotaltime = ($stime2 - $stime1) ;
				
				
				$overtime =($totaltime-$stotaltime);
				$overtime =($overtime/60);
				
				if($overtime>0)
				{					
					$name = date('H:i', mktime(0,$overtime));
				}	
				
				
			}
		}catch(Exception $e) {
			
		}
		
		return $name;
	}
	
	public function getTotaltime($timein,$timeout)
	{
		$name =" ";
		
		try{
			$time1 = strtotime(date("1980-01-01 ".$timein)); 
				$time2 = strtotime(date("1980-01-01 ".$timeout));  
			
			$totaltime = ($time2 - $time1);
			$totaltime =($totaltime/60);
				
			if($totaltime>0)
			{					
				$name = date('H:i', mktime(0,$totaltime));
			}	
		}catch(Exception $e) {
			
		}
		
		return $name;
	}
	
	public function getDataTable($editper, $deleteper,$atttype)
	{
		$sTable = 'AttendanceMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		//$aColumns = array( 'EmployeeId','EmployeeId','AttendanceDate', 'TimeIn', 'TimeOut', 'Overtime','ShiftId','AttendanceStatus','CheckInLoc','EntryImage','CheckOutLoc','ExitImage', 'Id');
		$aColumns = array( 'EmployeeId','EmployeeId','AttendanceDate','device','TimeIn','CheckInLoc','CheckInLoc','EntryImage','TimeOut','CheckOutLoc','CheckOutLoc','ExitImage','Overtime','ShiftId','EmployeeId','TimeinIp','TimeoutIp', 'Overtime', 'AttendanceStatus','remarks', 'Id');
		/*$sql1 = "select Id, WorkingDays from EmployeeMaster";
		$query1 = $this->db->prepare($sql1);
		$query1->execute();
		while($row = $query1->fetch())
		{
			$str  = str_replace("0","3",$row->WorkingDays);
			$sql2 ="Update EmployeeMaster set WorkingDays=? where Id=?";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($str, $row->Id));
		}*/
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' ) {
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )	{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )	{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )	{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" ) {
				$sOrder = "";
			}
		}
		$date = date("Y-m-d");
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$type="";
		if($atttype==1)
		$type=""	;
		else if($atttype==2)
		$type="AND AttendanceStatus IN (1,4,8)"	;		
		//else if($atttype==3)
		//$type="AND AttendanceStatus =2"	;
		else if($atttype==4)
		$type="AND TimeIn > (select TimeInGrace from ShiftMaster where Id=ShiftId )and TimeIn!='00:00' and AttendanceStatus IN (1,4,8)";
		else if($atttype==5)
		$type="AND TimeOut < (select TimeOutGrace from ShiftMaster where Id=ShiftId )and TimeOut!='00:00' and AttendanceStatus IN (1,4,8)";
		else if($atttype==6)
		$type="AND device ='Auto Time Out' and (TimeIn=TimeOut or TimeOut='00:00:00') ";
		else if($atttype==7)
		$type="AND EmployeeId<>LastModifiedById and LastModifiedById<>0 ";
		else if($atttype==9)
		$type="AND AttendanceStatus =2"	;	
	
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and Is_Delete<>1 $type and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		else{
			$ids = $this->getReportingIds($userid);
			$sWhere = " Where EmployeeId in ($ids) AND OrganizationId = $orgid and Is_Delete='0' $type  and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0 ) ";
		}
		if ( $_GET['sSearch'] != "" ) {
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				/* if($aColumns[$i]=="Id"){
				continue;
				} */
				if($aColumns[$i]=="EmployeeId" && $i>0){
					$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==0){
					$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where EmployeeCode LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		$flg=true;
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				$flg=false;
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				//Utils::getDateformat(
				if($i==2){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}
				elseif($i==1){
				
					$sWhere .= $aColumns[$i]." IN (Select Id from EmployeeMaster Where ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		if($flg)
		{
			$sWhere .= " AND AttendanceDate=Curdate() ";
		}
				
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			$areaId= Utils::getName($aRow->Id, 'AttendanceMaster','areaId',$this->db);
			$lati=Utils::getName($aRow->Id, 'AttendanceMaster','latit_in',$this->db);
			$longit=Utils::getName($aRow->Id, 'AttendanceMaster','longi_in',$this->db);
			$lat_lang = Utils::getName($areaId,'Geo_Settings','Lat_Long',$this->db);
			$radius = Utils::getName($areaId,'Geo_Settings','Radius',$this->db);
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					 $edit =""; $delete="";$remark="";$punchlocation="";
					  if($editper){
						$remarks= str_replace("'","`", Utils::getName($aRow->Id, 'AttendanceMaster','remarks',$this->db));
						$remark = '<a rel="tooltip" title="Remarks" onclick="angular.element(this).scope().showremarks(\''.$aRow->Id.'\',\''.$remarks.'\')" href="#"><i class="fa fa-pencil"></i></a>';
					  }
					  if($editper){
						$punchlocation = '<a rel="tooltip" title="Punch Location" href="'.URL.'attendance/punchlocation/'.Utils::encode5t($aRow->EmployeeId).'/'.Utils::encode5t($aRow->AttendanceDate).'" ><i class="fa fa-map-marker"></i></a>&nbsp;|&nbsp;';
					}
					 if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'attendance/editattendance/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					} 
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}			
					$row[] =$punchlocation."".$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete."&nbsp;&nbsp;|&nbsp;&nbsp;".$remark;
				}  
				elseif($aColumns[$i]=="AttendanceDate" )
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}/* elseif($aColumns[$i]=="LastModifiedDate")
				{
					$row[] = Utils::datetimeformatter($aRow->{$aColumns[$i]});
					
				} */
				elseif($aColumns[$i]=="TimeIn" || $aColumns[$i]=="TimeOut")
				{
					if($aRow->{$aColumns[$i]} == '00:00:00' && $aRow->AttendanceStatus==1){
						$row[] = ' ';
					}else{
						$row[] = Utils::timeformatter($aRow->{$aColumns[$i]});
					}
					
				}elseif($aColumns[$i]=="EmployeeId" && $i==1)
				{
					$row[] = $this->getName($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==0)
				{
					$row[] = $this->getEmployeeCode($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==14)
				{
					$empid=Utils::getName($aRow->{$aColumns[$i]}, 'EmployeeMaster','Id',$this->db);
					$divisionid=Utils::getName($empid, 'EmployeeMaster','Division',$this->db);
					$row[] = Utils::getName($divisionid, 'DivisionMaster','Name',$this->db);
				}
				/* elseif($aColumns[$i]=="LastModifiedById" )
				{
					$row[] = $this->getName($aRow->{$aColumns[$i]});
				} */
				elseif($aColumns[$i]=="ShiftId")
				{
					$row[] = $this->getShift($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="AttendanceStatus")
				{
					$row[] = Utils::getattendancetype($aRow->{$aColumns[$i]});
				}
				
				elseif($aColumns[$i]=="Overtime" && $i==17)
				{
				/*	$str="-";
					if( $aRow->TimeIn != '00:00:00' && $aRow->TimeOut != '00:00:00'){
						$str =$this->getTotaltime($aRow->TimeIn,$aRow->TimeOut);
					}
					$row[] = $str; */
					$str="-";
					if( $aRow->{$aColumns[$i]} != '00:00:00'){
						$str = $aRow->{$aColumns[$i]};
					}
					$row[] = $str;
				}
				elseif($aColumns[$i]=="Overtime" && $i==12)
				{
					$str="-";
					if( $aRow->TimeIn != '00:00:00' && $aRow->TimeOut != '00:00:00'){
						$str =$this->getTotaltime($aRow->TimeIn,$aRow->TimeOut);
					}
					$row[] = $str;
					
				}
				elseif($aColumns[$i]=="CheckInLoc" && $i==5)
				{
					$str="-";
					$str = '<a href="http://maps.google.com/?q='.$lati.','.$longit.'" target="_blank" title="Check In Location">'.str_replace(',',', ',$aRow->{$aColumns[$i]}).'</a>';
					$row[] = $str;
				}
				elseif($aColumns[$i]=="CheckInLoc" && $i==6)
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != ''){
						
						if($areaId !=0){
							
							$arr1 = explode(",",$lat_lang);
							$positionlin ="";
							if(count($arr1)>1){
								$a=floatval($arr1[0]);
								$b=floatval($arr1[1]);
								$d1 = $this->distance($a,$b, $lati, $longit, "K");
								if($d1 <= $radius)
								{
									$positionlin = "<div title='Attendance marked from the assigned area' class='text-center' style='width: 136px;background-color:#076507c2;color:white;font-size: 12px;'>Within the Location</div>";
								}
								else
								{
									$positionlin="<div title='Attendance marked from outside the assigned area' class='text-center' style='width: 142px;background-color:#8e1111a6;;color:white;font-size: 12px;'>Outside the Location</div>";
								}
							}
							$str = $positionlin;
						}
						
					}
					$row[] = $str;
				}
				elseif($aColumns[$i]=="CheckOutLoc" && $i==10)
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != ''){
						
						$positionout="";
						if($areaId !=0){
							
							$arr1 = explode(",",$lat_lang);
							if(count($arr1)>1){
								$a=floatval($arr1[0]);
								$b=floatval($arr1[1]);
								$d2 = $this->distance($a,$b, $lati, $longit, "K");
								if($d2 <= $radius)
								{
									$positionout = "<div title='Attendance marked from the assigned area' class='text-center' style='width: 136px;background-color:#076507c2;color:white;font-size: 12px;'>Within the Location</div>";
								}
								else
								{
									$positionout ="<div title='Attendance marked from outside the assigned area' class='text-center' style='width: 142px;background-color:#8e1111a6;;color:white;font-size: 12px;'>Outside the Location</div>";
								}
							}
							$str = $positionout;
							
						}
						
					}
					$row[] = $str;
				}elseif($aColumns[$i]=="CheckOutLoc" && $i==9)
				{
					$str="-";
					$str = '<a href="http://maps.google.com/?q='.$lati.','.$longit.'" target="_blank" title="Check In Location">'.str_replace(',',', ',$aRow->{$aColumns[$i]}).'</a>';
					$row[] = $str;
				}
				elseif($aColumns[$i]=="EntryImage")
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != ''){
						$src = $aRow->{$aColumns[$i]};
						$str='<img src="'.$src.'" onclick="angular.element(this).scope().showimg(\''.$aRow->Id.'\',\''.$src.'\')"  height="80px" width="80px" />';
						
					}
					$row[] = $str;
				}elseif($aColumns[$i]=="ExitImage")
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != ''){
						$src = $aRow->{$aColumns[$i]};
						Utils::Trace($src);
						$str='<img src="'.$src.'" height="80px" onclick="angular.element(this).scope().showimg(\''.$aRow->Id.'\',\''.$src.'\')" width="80px" />';
					}
					$row[] = $str;
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getAbsentDataTable($editper, $deleteper,$atttype)
	{
		$sTable = 'EmployeeMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		//$aColumns = array( 'EmployeeId','EmployeeId','AttendanceDate', 'TimeIn', 'TimeOut', 'Overtime','ShiftId','AttendanceStatus','CheckInLoc','EntryImage','CheckOutLoc','ExitImage', 'Id');
		
		$aColumns = array('EmployeeCode','FirstName','CurrentEmailId','CurrentContactNumber','Department','Designation','Division','Location','Shift');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$date = date("Y-m-d");
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
	
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and Is_Delete=0 and (DOL='0000-00-00' or DOL>curdate()) and Id not in (select EmployeeId from AttendanceMaster where AttendanceDate='$date' and OrganizationId = $orgid ) and (Shift in (select Id from ShiftMaster where TimeInGrace <CURTIME()))";
		}
		else{
			$ids = $this->getReportingIds($userid);
			$sWhere = " Where EmployeeId in ($ids) AND OrganizationId = $orgid and Is_Delete='0' and (DOL='0000-00-00' or DOL>curdate()) and  Id not in (select EmployeeId from AttendanceMaster where AttendanceDate='$date' and OrganizationId = $orgid )and (Shift in (select Id from ShiftMaster where TimeInGrace <CURTIME())) ";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				
				if($aColumns[$i]=="FirstName"){
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR  MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR  LastName LIKE '%".( $_GET['sSearch'] )."%' OR ";
				} 
				elseif($aColumns[$i]=="CurrentEmailId" || $aColumns[$i]=="CurrentContactNumber"){
					$sWhere .= $aColumns[$i]." LIKE '%".Utils::encode5t( $_GET['sSearch'] )."%' OR ";
				}
				/* elseif($aColumns[$i]=="CurrentContactNumber"){
					$sWhere .= $aColumns[$i]." LIKE '%".Utils::encode5t( $_GET['sSearch'] )."%' OR ";
				} */else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		//$flg=false;
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= "  ";
				}
				//$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		/* if($flg)
		{
			$sWhere .= " AND AttendanceDate=Curdate() ";
		} */
				
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				 
				if($aColumns[$i]=="EmployeeCode")
				{
					$row[] = $aRow->{$aColumns[$i]};
				}/* elseif($aColumns[$i]=="LastModifiedDate")
				{
					$row[] = Utils::datetimeformatter($aRow->{$aColumns[$i]});
					
				} */
				elseif($aColumns[$i]=="Division" || $aColumns[$i]=="Location" || $aColumns[$i]=="Department" || $aColumns[$i]=="Designation" || $aColumns[$i]=="Grade" || $aColumns[$i]=="Shift" || $aColumns[$i]=="Nationality" ){
											
					$row[] =Utils::getName( $aRow->{$aColumns[$i]}, $aColumns[$i].'Master', "Name", $this->db);
				}
				elseif($aColumns[$i]=="CurrentContactNumber"){
					$row[] =Utils::decode5t($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="CurrentEmailId" || $aColumns[$i]=="PersonalNo"){
					$row[] =Utils::decode5t($aRow->{$aColumns[$i]});
				}
				
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getAttendanceDeleted($editper, $deleteper)
	{
		$sTable = 'AttendanceMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		//$aColumns = array( 'EmployeeId','EmployeeId','AttendanceDate', 'TimeIn', 'TimeOut', 'Overtime','ShiftId','AttendanceStatus','CheckInLoc','EntryImage','CheckOutLoc','ExitImage', 'Id');
		
		$aColumns = array('EmployeeId','EmployeeId','AttendanceDate','device','TimeIn','CheckInLoc','EntryImage','TimeOut','CheckOutLoc','ExitImage','Overtime', 'AttendanceStatus', 'device','TimeinIp','TimeoutIp', 'Overtime', 'ShiftId','timeoutdate','remarks', 'Id');
		
		/*$sql1 = "select Id, WorkingDays from EmployeeMaster";
		$query1 = $this->db->prepare($sql1);
		$query1->execute();
		while($row = $query1->fetch())
		{
			$str  = str_replace("0","3",$row->WorkingDays);
			$sql2 ="Update EmployeeMaster set WorkingDays=? where Id=?";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($str, $row->Id));
		}*/
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' ) {
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )	{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )	{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )	{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" ) {
				$sOrder = "";
			}
		}
		$date = date("Y-m-d");
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and Is_Delete='1' and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		else{
			$ids = $this->getReportingIds($userid);
			$sWhere = " Where EmployeeId in ($ids) AND OrganizationId = $orgid and Is_Delete='1' and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0 ) ";
		}
		if ( $_GET['sSearch'] != "" ) {
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				/* if($aColumns[$i]=="Id"){
				continue;
				} */
				if($aColumns[$i]=="EmployeeId" && $i==1){
					$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}elseif($aColumns[$i]=="EmployeeId" && $i==0){
					$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where EmployeeCode LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		$flg=true;
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				$flg=false;
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				//Utils::getDateformat(
				if($i==2){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}
				elseif($i==1){
				
					$sWhere .= $aColumns[$i]." IN (Select Id from EmployeeMaster Where ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		if($flg)
		{
			$sWhere .= " AND AttendanceDate=Curdate() ";
		}
				
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					 $restoreAttn ="";$delete="";
					if($deleteper){
						$restoreAttn ='<a rel="tooltip"  title="Restore Attendance Detail" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#attnRestore" href="#" ><i class="fa fa-undo"></i></a>';
						
					}else{
						$restoreAttn = '<a href="#" rel="tooltip" title="No permission to restore"><i class="fa fa-undo"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Permanent Delete Attendance" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#attnPerDeletion" href="#" ><i class="fa fa-trash"></i></a>';
						
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}					
					$row[] =$restoreAttn."&nbsp;|&nbsp;".$delete;
				}  
				else if($aColumns[$i]=="AttendanceDate" )
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}/* elseif($aColumns[$i]=="LastModifiedDate")
				{
					$row[] = Utils::datetimeformatter($aRow->{$aColumns[$i]});
					
				} */
				elseif($aColumns[$i]=="TimeIn" || $aColumns[$i]=="TimeOut")
				{
					if($aRow->{$aColumns[$i]} == '00:00:00' && $aRow->AttendanceStatus==1){
						$row[] = '00:00';
					}else{
						$row[] = Utils::timeformatter($aRow->{$aColumns[$i]});
					}
					
				}elseif($aColumns[$i]=="EmployeeId" && $i==1)
				{
					$row[] = $this->getName($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==0)
				{
					$row[] = $this->getEmployeeCode($aRow->{$aColumns[$i]});
				}
				/* elseif($aColumns[$i]=="LastModifiedById" )
				{
					$row[] = $this->getName($aRow->{$aColumns[$i]});
				} */
				elseif($aColumns[$i]=="ShiftId")
				{
					$row[] = $this->getShift($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="AttendanceStatus")
				{
					$row[] = Utils::getattendancetype($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="Overtime" && $i==10)
				{
				/*	$str="-";
					if( $aRow->{$aColumns[$i]} != '00:00:00'){
						$str = $aRow->{$aColumns[$i]};
					}
					$row[] = $str;  */
					$str="-";
					if( $aRow->TimeIn != '00:00:00' && $aRow->TimeOut != '00:00:00'){
						$str =$this->getTotaltime($aRow->TimeIn,$aRow->TimeOut,$aRow->ShiftId,Utils::dateformatter($aRow->AttendanceDate),Utils::dateformatter($aRow->timeoutdate));
					}
					$row[] = $str;
				}
				elseif($aColumns[$i]=="Overtime" && $i==15)
				{
				/*	$str="-";
					if( $aRow->TimeIn != '00:00:00' && $aRow->TimeOut != '00:00:00'){
						$str =$this->getTotaltime($aRow->TimeIn,$aRow->TimeOut);
					}
					$row[] = $str; */
					$str="-";
					if( $aRow->{$aColumns[$i]} != '00:00:00'){
						$str = $aRow->{$aColumns[$i]};
					}
					$row[] = $str;
					/* $str="-";
					if( $aRow->TimeIn != '00:00:00' && $aRow->TimeOut != '00:00:00'){
						$str =$this->getOvertime($aRow->TimeIn,$aRow->TimeOut,$aRow->ShiftId);
					}
					$row[] = $str; */
				}
				elseif($aColumns[$i]=="CheckInLoc")
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != ''){
						$lati=Utils::getName($aRow->Id, 'AttendanceMaster','latit_in',$this->db);
						$longit=Utils::getName($aRow->Id, 'AttendanceMaster','longi_in',$this->db);
						$str = '<a href="http://maps.google.com/?q='.$lati.','.$longit.'" target="_blank" title="Check In Location">'.str_replace(',',', ',$aRow->{$aColumns[$i]}).'</a>';//str_replace(',',', ',$aRow->{$aColumns[$i]});
						
					}
					$row[] = $str;
				}
				elseif($aColumns[$i]=="CheckOutLoc")
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != ''){
						$lati=Utils::getName($aRow->Id, 'AttendanceMaster','latit_out',$this->db);
						$logiti=Utils::getName($aRow->Id, 'AttendanceMaster','longi_out',$this->db);
						$str = '<a href="http://maps.google.com/?q='.$lati.','.$logiti.'" target="_blank" title="Check Out Location">'.str_replace(',',', ',$aRow->{$aColumns[$i]}).'</a>';//str_replace(',',', ',$aRow->{$aColumns[$i]});
					}
					$row[] = $str;
				}elseif($aColumns[$i]=="EntryImage")
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != ''){
						$src = $aRow->{$aColumns[$i]};
						$str='<img src="'.$src.'" onclick="angular.element(this).scope().showimg(\''.$aRow->Id.'\',\''.$src.'\')"  height="80px" width="80px" />';
						
					}
					$row[] = $str;
				}elseif($aColumns[$i]=="ExitImage")
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != ''){
						$src = $aRow->{$aColumns[$i]};
						Utils::Trace($src);
						$str='<img src="'.$src.'" height="80px" onclick="angular.element(this).scope().showimg(\''.$aRow->Id.'\',\''.$src.'\')" width="80px" />';
					}
					$row[] = $str;
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getPunchLocationDataTable($editper, $deleteper,$EmployeeId,$AttendanceDate)
	{
		$Empid=Utils::decode5t($EmployeeId);
		$AttendanceDate=Utils::decode5t($AttendanceDate);
		$sTable = 'checkin_master';
		$sIndexColumn = "id";
		$userid = $_SESSION['ubihrm_user_id'];
		//$aColumns = array( 'EmployeeId','EmployeeId','AttendanceDate', 'TimeIn', 'TimeOut', 'Overtime','ShiftId','AttendanceStatus','CheckInLoc','EntryImage','CheckOutLoc','ExitImage', 'Id');
		$aColumns = array( 'id','EmployeeId','client_name','date','checkin_img' ,'time', 'location','checkout_img','time_out','location_out',  'description');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' ) {
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )	{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )	{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )	{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" ) {
				$sOrder = "";
			}
		}
		$date = date("Y-m-d");
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$whr="";
		if($Empid != "" && $AttendanceDate != "")
			$whr=" and EmployeeId=$Empid and date ='$AttendanceDate'";	
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0 ) $whr";
		}
		else{
			$ids = $this->getReportingIds($userid);
			$sWhere = " Where EmployeeId in ($ids) AND OrganizationId = $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0 ) $whr ";
		}
		if ( $_GET['sSearch'] != "" ) {
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				/* if($aColumns[$i]=="Id"){
				continue;
				} */
				if($aColumns[$i]=="EmployeeId" && $i>0){
					$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		$flg=true;
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				$flg=false;
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				//Utils::getDateformat(
				if($i==3){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}
				elseif($i==2){
				
					//$sWhere .= $aColumns[$i]." IN (Select Id from EmployeeMaster Where ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
				
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="time" || $aColumns[$i]=="time_out")
				{
					if($aRow->{$aColumns[$i]} == '00:00:00'){
						$row[] = '00:00';
					}else{
						$row[] = Utils::timeformatter($aRow->{$aColumns[$i]});
					}
					
				}else if($aColumns[$i]=="date" )
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}elseif($aColumns[$i]=="EmployeeId")
				{
					$row[] = $this->getName($aRow->{$aColumns[$i]});
				}elseif($aColumns[$i]=="checkin_img" || $aColumns[$i]=="checkout_img")
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != ''){
						$src = $aRow->{$aColumns[$i]};
						$str='<img src="'.$src.'" height="80px"  width="80px" />';
					}
					$row[] = $str;
				}elseif($aColumns[$i]=="location" || $aColumns[$i]=="location_out")
				{
					$str="-";$positionout="";
					if( $aRow->{$aColumns[$i]} != ''){
						$lati=Utils::getName($aRow->id, 'checkin_master','latit',$this->db);
						$logiti=Utils::getName($aRow->id, 'checkin_master','longi',$this->db);
						if($aColumns[$i]=="location_out"){
							$lati=Utils::getName($aRow->id, 'checkin_master','latit_out',$this->db);
							$logiti=Utils::getName($aRow->id, 'checkin_master','longi_out',$this->db);
						}	
						$str = '<a href="http://maps.google.com/?q='.$lati.','.$logiti.'" target="_blank" title=" Location">'.str_replace(',',', ',$aRow->{$aColumns[$i]}).'</a>';
						
					}
					$row[] = $str;
				}else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getPunchLocationDataTableBak9march2019($editper, $deleteper,$EmployeeId,$AttendanceDate)
	{
		$Empid=Utils::decode5t($EmployeeId);
		$AttendanceDate=Utils::decode5t($AttendanceDate);
		$sTable = 'checkin_master';
		$sIndexColumn = "id";
		$userid = $_SESSION['ubihrm_user_id'];
		//$aColumns = array( 'EmployeeId','EmployeeId','AttendanceDate', 'TimeIn', 'TimeOut', 'Overtime','ShiftId','AttendanceStatus','CheckInLoc','EntryImage','CheckOutLoc','ExitImage', 'Id');
		$aColumns = array( 'EmployeeId','date','time','time_out','client_name', 'location', 'description');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' ) {
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )	{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )	{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )	{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" ) {
				$sOrder = "";
			}
		}
		$date = date("Y-m-d");
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		
		$whr="";
		if($Empid != "" && $AttendanceDate != "")
			$whr=" and EmployeeId=$Empid and date ='$AttendanceDate'";
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0 ) $whr";
		}
		else{
			$ids = $this->getReportingIds($userid);
			$sWhere = " Where EmployeeId in ($ids) AND OrganizationId = $orgid and EmployeeId in (select Id from EmployeeMaster where Is_Delete=0 ) $whr";
		}
		if ( $_GET['sSearch'] != "" ) {
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				/* if($aColumns[$i]=="Id"){
				continue;
				} */
				if($aColumns[$i]=="EmployeeId" && $i==0){
					$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		$flg=true;
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				$flg=false;
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				//Utils::getDateformat(
				if($i==1){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}
				elseif($i==2){
				
					$sWhere .= $aColumns[$i]." IN (Select Id from EmployeeMaster Where ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
				
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="time" || $aColumns[$i]=="time_out" )
				{
					if($aRow->{$aColumns[$i]} == '00:00:00'){
						$row[] = '00:00';
					}else{
						$row[] = Utils::timeformatter($aRow->{$aColumns[$i]});
					}
					
				}else if($aColumns[$i]=="date" )
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}elseif($aColumns[$i]=="EmployeeId")
				{
					$row[] = $this->getName($aRow->{$aColumns[$i]});
				}else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	//////////Save Remarks ///////////////
	public function SaveRemarks()
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$attendanceid=isset($_POST['attendanceid'])?$_POST['attendanceid']:"";
		$remark=isset($_POST['remark'])?$_POST['remark']:"";
		$orgid=$_SESSION['ubihrm_org_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sql = "update  AttendanceMaster set remarks=? WHERE Id =? ";	
		try{			
			$query = $this->db->prepare($sql);
			$query->execute(array($remark , $attendanceid));		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = "Remark updated successfully";
        }else {
           $status =false;
		   $errorMsg = ATTENDANCE_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function getDataTabledelete($editper, $deleteper)
	{
		$sTable = 'AttendanceMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		//$aColumns = array( 'EmployeeId','EmployeeId','AttendanceDate', 'TimeIn', 'TimeOut', 'Overtime','ShiftId','AttendanceStatus','CheckInLoc','EntryImage','CheckOutLoc','ExitImage', 'Id');
		$aColumns = array('Id','EmployeeId','EmployeeId','AttendanceDate',  'ShiftId','TimeIn','TimeOut','AttendanceStatus');
		/*$sql1 = "select Id, WorkingDays from EmployeeMaster";
		$query1 = $this->db->prepare($sql1);
		$query1->execute();
		while($row = $query1->fetch())
		{
			$str  = str_replace("0","3",$row->WorkingDays);
			$sql2 ="Update EmployeeMaster set WorkingDays=? where Id=?";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array($str, $row->Id));
		}*/
		
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$date = date("Y-m-d");
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid AND EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		else{
			$ids = $this->getReportingIds($userid);
			$sWhere = " Where EmployeeId in ($ids) AND OrganizationId = $orgid AND EmployeeId in (select Id from EmployeeMaster where Is_Delete=0)";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id" && $i>0){
				continue;
				}
				if($aColumns[$i]=="EmployeeId" && $i>1){
					$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==1){
					$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where EmployeeCode LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		$flg=true;
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				$flg=false;
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				//Utils::getDateformat(
				if($i==3){
					$sWhere .= " (".$aColumns[$i]." between ".($_GET['sSearch_'.$i]).") ";
				}
				elseif($i==2){
				
					$sWhere .= $aColumns[$i]." IN (Select Id from EmployeeMaster Where ".($_GET['sSearch_'.$i]).") ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		if($flg)
		{
			$sWhere .= " AND AttendanceDate=Curdate() ";
		}
				
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				
				if($aColumns[$i]=="Id" && $i>0)
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'attendance/editattendance/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				elseif($aColumns[$i]=="Id" && $i==0)
				{
					$check ="";
					$check = '<input type="checkbox" class="checkbox" value="'.$aRow->{$aColumns[$i]}.'" name="checklist[]" >';
					$row[] =$check;
				}
				elseif($aColumns[$i]=="AttendanceDate")
				{
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
					
				}elseif($aColumns[$i]=="LastModifiedDate")
				{
					$row[] = Utils::datetimeformatter($aRow->{$aColumns[$i]});
					
				}elseif($aColumns[$i]=="TimeIn" || $aColumns[$i]=="TimeOut")
				{
					if($aRow->{$aColumns[$i]} == '00:00:00' && $aRow->AttendanceStatus==1){
						$row[] = '00:00';
					}else{
						$row[] = Utils::timeformatter($aRow->{$aColumns[$i]});
					}
					
				}elseif($aColumns[$i]=="EmployeeId" && $i>1)
				{
					$row[] = $this->getName($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="EmployeeId" && $i==1)
				{
					$row[] = $this->getEmployeeCode($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="ShiftId")
				{
					$row[] = $this->getShift($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="AttendanceStatus")
				{
					$row[] = Utils::getattendancetype($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="Overtime")
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != '00:00:00'){
						$str = $aRow->{$aColumns[$i]};
					}
					$row[] = $str;
				}
				elseif($aColumns[$i]=="CheckInLoc")
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != ''){
						
						$str = str_replace(',',', ',$aRow->{$aColumns[$i]});
					}
					$row[] = $str;
				}
				elseif($aColumns[$i]=="CheckOutLoc")
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != ''){
						$str = str_replace(',',', ',$aRow->{$aColumns[$i]});
					}
					$row[] = $str;
				}elseif($aColumns[$i]=="EntryImage")
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != ''){
						$src = $aRow->{$aColumns[$i]};
						$str='<img src="'.URL."public/uploads/attendance/".$src.'" height="80px" width="80px" />';
						
					}
					$row[] = $str;
				}elseif($aColumns[$i]=="ExitImage")
				{
					$str="-";
					if( $aRow->{$aColumns[$i]} != ''){
						$src = $aRow->{$aColumns[$i]};
						$str='<img src="'.URL."public/uploads/attendance/".$src.'" height="80px" width="80px" />';
					}
					$row[] = $str;
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	/////////////////////////import attendance//////////////
	
	public function getFileHeaders($request)
	{	
			$result = array();
			$count=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$file_name = "";
			
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION); 
				
				$storage_name="attendance.$ext";
				if (file_exists($storage_name))
				{ unlink($storage_name); 
				} 
				$file_size =$_FILES['file0']['size'];
				$file_tmp =$_FILES['file0']['tmp_name'];
				$file_type=$_FILES['file0']['type'];   
				$location="public/uploads/$orgid/";
				if(!is_dir($location))
				{
					mkdir($location,0777);
				}	
				if($file_size > 2097152){
				$errors[]='File size must be less than 2 MB';
				}	
				
				if(empty($errors)==true){
				
					move_uploaded_file($file_tmp, $location.$storage_name );
					chmod($location.$storage_name, 0755);
					
				}else{
					print_r($errors);
				}
			}		
		//$actual_date = "candidate_details_".$_REQUEST['org_id'];
		//$org_id = isset($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
		//$fileName=isset ($_REQUEST['fileName'])	? $_REQUEST['fileName'] : '';
		$ext = pathinfo($file_name, PATHINFO_EXTENSION);
		if ($ext=='csv'){
		
			$fp = $location.$storage_name;
			
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
				$row = 1;
				$ind=1;
				$arrData 		= array();
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
					if($row == 1)
					{
						for($i = 0 ; $i<count($data);$i++)
						{
							
							$record 	= array();				
							
							$record['head_name'] = $data[$i];
							//$record['name'] = '';
							//$record['type'] = '';
							//$record['data_label'] = '';
							$record['rows'] = $count;
							$record['column_index'] = $count;
							$record['sts'] = true;
							$count++;
							
							$arrData[] = $record;			
						}
									
						$row++;
						
					}
				}
				
				
				if ($count >= 1) {
				   $status =true;
				   
				} 
				else {
				   $status =false;
				   $errorMsg = ATTENDANCE_MODULE_CREATION_FAILED;
				}
				$result["data"] =$arrData;
				$result['status']=$status;
				$result['successMsg']=$successMsg;
				$result['errorMsg']=$errorMsg;
				return $result;
			}
		} elseif($ext=='TXT' || $ext=='txt')
		{
			$list=array();
			//$list[0]=['Status','Date','Time','Employee Code',''];
			$fp = $location.$storage_name;
			$fileObj = fopen( $fp, "rt" );
			while ( ( $line = fgets( $fileObj ) ) ) // by default this will read one line at a time
			{
				//  If you need to do anything to transform this data to CSV format, convert each line here.
				$line = preg_replace('/\s\s+/', ' ', $line);
				$line = str_replace("'", "", $line);
				$row=explode(' ', $line);
				$list[]=$row;
				
			}
			
			$fp = fopen($location.'attendance.csv', 'w');

			foreach ($list as $fields) {
				fputcsv($fp, $fields);
			}

			fclose($fp);
			
			$fp1 = 'public/uploads/test.csv';
			
		
			if (($handle = fopen($fp1, "r")) !== FALSE) 
			{
				$row = 1;
				$ind=1;
				$arrData 		= array();
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
					if($row == 1)
					{
						for($i = 0 ; $i<count($data);$i++)
						{
							
							$record 	= array();				
							
							$record['head_name'] = $data[$i];
							
							$record['rows'] = $count;
							$record['column_index'] = $count;
							$record['sts'] = true;
							$count++;
							
							$arrData[] = $record;			
						}
									
						$row++;
						
					}
				}
				
				
				if ($count >= 1) {
				   $status =true;
				   
				} 
				else {
				   $status =false;
				   $errorMsg = ATTENDANCE_MODULE_CREATION_FAILED;
				}
				$result["data"] =$arrData;
				$result['status']=$status;
				$result['successMsg']=$successMsg;
				$result['errorMsg']=$errorMsg;
				return $result;
			}
		
		}
		else if (strpos('xls',$ext)!==false || strpos('xlsx',$ext)!==false){
			require_once  LIBS_PATH.'ExcelClasses/PHPExcel/IOFactory.php';
			if ($ext=='xls'){
				$objReader = PHPExcel_IOFactory::createReader('Excel5');
			}else if($ext=='xlsx'){
				$objReader = PHPExcel_IOFactory::createReader('Excel2007');
			}
			 $objReader->setReadDataOnly(true); $objPHPExcel = $objReader->load($location.$file_name.".".$ext);
			 $objWorksheet = $objPHPExcel->getActiveSheet(); 
			 foreach ($objWorksheet->getRowIterator() as $row) 
			 {
				 $cellIterator = $row->getCellIterator(); 
				 $cellIterator->setIterateOnlyExistingCells(false); 
				 $count = 0;
					$record 						= array();				
					$record['head_name'] = "None";
					$record['name'] = '';
					$record['type'] = '';
					$record['data_label'] = '';
					$record['rows'] = $count;
					$record['h_count'] = $count;
					$record['sts'] = true;
					$arrData[] = $record;
					
				 foreach ($cellIterator as $cell) 
				 {
					
					$record 						= array();				
							
					$record['head_name'] = $cell->getValue();
					$record['name'] = '';
					$record['type'] = '';
					$record['data_label'] = '';
					$record['rows'] = $count;
					$record['h_count'] = $count;
					$record['sts'] = true;
					$count++;
					$arrData[] = $record;
				 } 
				 
				  array_pop($arrData);
				 break;
			 }
				/*$result = generateXML("candidates","candidate",$arrData);
				$sql ="select * from licence_master lm, org_licence_history org where lm.lnctypeid=org.lnctypeid and org.org_id=$org_id order by lncid desc";
				$dbq =query($sql);
				$limit=0;
				if(getRowCount($dbq)>=1)
				{
					$row = fetch($dbq);
					if ($row['lnc_name']=='Basic'){
						$limit=400;
					}else if ($row['lnc_name']=='Professional'){
						$limit=3000;
					} else if ($row['lnc_name']=='Plus'){
						$limit=30000;
					}  
				}
				
				$sql1 ="select count(*) as occupied from candidate_master  where org_id=$org_id";
				$dbq1 =query($sql1);
				$occupied=0;
				if(getRowCount($dbq1)>=1)
				{
					$row1 = fetch($dbq1);
					$occupied=$row1['occupied'];
				}
			    $available=$limit-$occupied;
				//$available=500;
				$result.="<max_row>".$objWorksheet->getHighestRow()."</max_row><available>$available</available>";*/
				return $result;
		}
	}
	
	//////////////////////////////////
	
  public function insertFileHeaders($request)
    {
		$result = array();
		$count=0; $count1=0;  $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$emp = $request[2];
		$atdate = $request[3];
		$timein = $request[4];
		$timeout = $request[5];
		$attsts = $request[6];
		$file_name = "attendance.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
			$i=0;	
			
		try{	
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0){
							$timeout1="00:00:00";  $overtime="";
							//$emp=preg_replace('/"/','',$data[$emp]);
							$empid=$this->getEmployeeId($data[$emp]);
							$adate=Utils::getDateformat($data[$atdate]);
							$timein1="";
							$timeout="";
							if($empid){
								$shift = $this->getShiftId($empid);
								//$timeout1 = $this->getShiftTime($shift,"TimeOut");
								$sql = "SELECT Id FROM AttendanceMaster WHERE AttendanceDate = ? AND EmployeeId =?";
								$query = $this->db->prepare($sql);
								$query->execute(array($adate,$empid ));
								$count =  $query->rowCount();
								if ($count >= 1) {
									//echo "SELECT TimeIn FROM AttendanceMaster WHERE AttendanceDate = '$adate' AND EmployeeId =$empid and TimeIn <> '".$data[$timein]."' and TimeOut = '00:00:00' AND AttendanceStatus in (1,4) ";
									$sql1 = "SELECT TimeIn FROM AttendanceMaster WHERE AttendanceDate = ? AND EmployeeId =? and TimeIn <> ? and TimeOut = '00:00:00' AND AttendanceStatus in (1,4)";
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($adate,$empid,$data[$timein]));
									if ($r=$query1->fetch()) {
										if($data[$timein]=="00:00:00" || $data[$timein]=="0:00:00" || $data[$timein]=="00:00")
										$data[$timein] = "00:01:01";
										$overtime=$this->getOvertime($r->TimeIn,$data[$timein],$shift);
										$sql2="UPDATE AttendanceMaster set TimeOut=?,Overtime=? where EmployeeId =? and AttendanceDate=? ";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$timein] ,$overtime, $empid, $adate ));
										
										$attendancelog=$sql2." ".$data[$timein] ." ".$overtime." ".$empid." ".$adate." | Device: import If";
										Utils::TraceAttendance($attendancelog);
									}else{
										$query = $this->db->prepare("delete from AttendanceMaster where EmployeeId=? and AttendanceDate=?");
										$query->execute(array($empid, $adate));
										$attendancelog="delete attendance $emp $adate";
										Utils::TraceAttendance($attendancelog);
										$sql = "INSERT INTO AttendanceMaster ( EmployeeId, AttendanceDate, AttendanceStatus,ShiftId, TimeIn,   OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, TimeOut, device) VALUES (?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";	
											
										if($data[$timein]=="00:00:00" || $data[$timein]=="0:00:00" || $data[$timein]=="00:00")
											$data[$timein] = "00:01:01";
										$timein1=$data[$timein];
										$timeout="00:00:00";
										if($data[$attsts] == 4)
										{
											$timeout=$data[$timein];
											$timein1="00:00:00";
										}
										//$overtime=$this->getOvertime($data[$timein],$timeout1,$shift);
										$query = $this->db->prepare($sql);
										$query->execute(array($empid, $adate, 1,$shift, $timein1 ,  $orgid, $mdate, $mid, $mdate, $mid, $mid, $timeout,"Biometrics"));
										
										$attendancelog=$sql." ".$empid ." ".$adate." ".$shift." ".$timein1." ".$orgid. " ".$mdate." ". $mid." ". $mdate." ". $mid." ".$mid." ".$timeout." ".$overtime." | Device: import If insert";
										Utils::TraceAttendance($attendancelog);
										$count1+=$query->rowCount();
									}
								}
								else{
									// SQL Query to insert data into DataBase
									$sql = "INSERT INTO AttendanceMaster ( EmployeeId, AttendanceDate, AttendanceStatus,ShiftId, TimeIn,   OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, TimeOut, device) VALUES (?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";		
									
									if($data[$timein]=="00:00:00" || $data[$timein]=="0:00:00" || $data[$timein]=="00:00")
										$data[$timein] = "00:01:01";
									///////////CHECKING THE STATUS FROM FILE/////////I FOR TIMEIN 4 FOR TIMEOUT////////
									$timein1=$data[$timein];
									$timeout="00:00:00";
									if($data[$attsts] == 4)
									{
										$timeout=$data[$timein];
										$timein1="00:00:00";
									}
									//$overtime=$this->getOvertime($data[$timein],$timeout1,$shift);
									$query = $this->db->prepare($sql);
									$query->execute(array($empid, $adate, 1,$shift, $timein1 ,  $orgid, $mdate, $mid, $mdate, $mid, $mid, $timeout,"Biometrics"));
									
									$attendancelog=$sql." ".$empid ." ".$adate." ".$shift." ".$timein1." ".$orgid. " ".$mdate." ". $mid." ". $mdate." ". $mid." ".$mid." ".$timeout." ".$overtime." | Device: import Else insert";
										Utils::TraceAttendance($attendancelog);
									$count1+=$query->rowCount();
									$name="";
									/* if(($data[$attsts] == 2) && ($adate == date('Y-m-d')))
									{
										$title="Absent - Unauthorized ";
										$name =Utils::getEmployeeName($empid,$this->db);
										$msg=$name." is Absent today without any information";
										$hrarr=Utils::getHR($orgid,$this->db);
										for($i=0;$i<count($hrarr);$i++){
											$sql1 = "INSERT INTO GenerateNotification (  EmployeeId, Title, Message, NotifyDate, OrganizationId) VALUES (?, ?, ?, ?, ?)";
											$query1 = $this->db->prepare($sql1);
											$query1->execute(array( $hrarr[$i],$title,$msg,$mdate,$orgid ));	
										}
									} */
									
								}
								/////notification if an employee get late 3rd time in a month////
								$temp=date("Y-m-01",strtotime($adate));
								$con=0;
								$shifttimein = $this->getShiftTime($shift,"TimeInGrace");
								$sql1="select TimeIn from AttendanceMaster where EmployeeId=? and AttendanceDate between '$temp' and '$adate'";
								$query1=$this->db->prepare($sql1);
								$query1->execute(array($empid));
								while($r=$query1->fetch()){
									if(strtotime($r->TimeIn) > strtotime($shifttimein))
									{
										$con++;
									}
								}	
								
								if($con>=3)
								{
									$name=Utils::getEmployeeName($empid,$this->db);
									$countinwords=$this->getNumberinWords($con);
									$title="$countinwords ($con) instances of late reporting this month ";
									$adate1=$data[$atdate];
									$amonth=date("F",strtotime(Utils::getDateformat($adate1)));
									$con1=$con."th";
									if($con==3)
										$con1=$con."rd";
									$msg= "$name has reported late for the $con1 time on $adate1 in $amonth ";
									$hrarr=Utils::getHR($orgid,$this->db);
									$empids=implode(',',$hrarr);
									$sqln="select Id from NotificationMaster where Name=? and Message=? and EmployeeIds=? and OrganizationId=?";
									$queryn=$this->db->prepare($sqln);
									$queryn->execute(array($title, $msg, $empids, $orgid));
									if($queryn->rowCount()==0){
										$sql1="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($title, $msg, $empids, $orgid, $mdate, $mid, $mdate, $mid, $mid, $mdate, date("Y-m-d", strtotime(date("Y-m-d")." , +1 days ")), 2,2));
									}
								}
							}	
					}							
						$i++;
				}
			}		
		
		if ($count1 == 0) {
			$status =false;
			$errorMsg = ATTENDANCE_MODULE_MARKEDALREADY;
		}else{
			$status =true;
			$successMsg = $count1.' '.ATTENDANCE_MODULE_IMPORT;
		} 
	}catch(Exception $e) {
		$errorMsg = 'Message: ' .$e->getMessage();
	}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
  public function insertFileHeadersBak($request)
    {
		$result = array();
		$count=0; $count1=0;  $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$emp = $request[2];
		$atdate = $request[3];
		$timein = $request[4];
		$timeout = $request[5];
		$attsts = $request[6];
		$file_name = "attendance.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
			$i=0;	
			
		try{	
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0){
							$timeout1="00:00:00";  $overtime="";
							//$emp=preg_replace('/"/','',$data[$emp]);
							$empid=$this->getEmployeeId($data[$emp]);
							$adate=Utils::getDateformat($data[$atdate]);
							if($empid){
								$shift = $this->getShiftId($empid);
								//$timeout1 = $this->getShiftTime($shift,"TimeOut");
								$sql = "SELECT Id FROM AttendanceMaster WHERE AttendanceDate = ? AND EmployeeId =?";
								$query = $this->db->prepare($sql);
								$query->execute(array($adate,$empid ));
								$count =  $query->rowCount();
								if ($count >= 1) {
									$sql1 = "SELECT TimeIn FROM AttendanceMaster WHERE AttendanceDate = ? AND EmployeeId =? and TimeOut=? and TimeIn <> ?";
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($adate,$empid,$timeout1,$data[$timein] ));
									if ($r=$query1->fetch()) {
										$overtime=$this->getOvertime($r->TimeIn,$data[$timein],$shift);
										
										if($data[$timein]=="00:00:00" || $data[$timein]=="0:00:00" || $data[$timein]=="00:00")
										$data[$timein] = "00:01:01";
										$sql2="UPDATE AttendanceMaster set TimeOut=?,Overtime=? where EmployeeId =? and AttendanceDate=? ";
										$query2 = $this->db->prepare($sql2);
										$query2->execute(array($data[$timein] ,$overtime, $empid, $adate ));
										
										$attendancelog=$sql2." ".$data[$timein] ." ".$overtime." ".$empid." ".$adate." | Device: insertFileHeaders AttendanceModel hrm";
										Utils::TraceAttendance($attendancelog);
									}else{
										$query = $this->db->prepare("delete from AttendanceMaster where EmployeeId=? and AttendanceDate=?");
										$query->execute(array($empid, $adate));
										$sql = "INSERT INTO AttendanceMaster ( EmployeeId, AttendanceDate, AttendanceStatus,ShiftId, TimeIn,   OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, TimeOut, device) VALUES (?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";		
										if($data[$timein]=="00:00:00" || $data[$timein]=="0:00:00" || $data[$timein]=="00:00")
											$data[$timein] = "00:01:01";
										//$overtime=$this->getOvertime($data[$timein],$timeout1,$shift);
										$query = $this->db->prepare($sql);
										$query->execute(array($empid, $adate, $data[$attsts],$shift, $data[$timein] ,  $orgid, $mdate, $mid, $mdate, $mid, $mid, $timeout1,"Biometrics"));
										$count1+=$query->rowCount();
									}
								}
								else{
									// SQL Query to insert data into DataBase
									$sql = "INSERT INTO AttendanceMaster ( EmployeeId, AttendanceDate, AttendanceStatus,ShiftId, TimeIn,   OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, TimeOut, device) VALUES (?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";		
									
									if($data[$timein]=="00:00:00" || $data[$timein]=="0:00:00" || $data[$timein]=="00:00")
										$data[$timein] = "00:01:01";
									//$overtime=$this->getOvertime($data[$timein],$timeout1,$shift);
									$query = $this->db->prepare($sql);
									$query->execute(array($empid, $adate, $data[$attsts],$shift, $data[$timein] ,  $orgid, $mdate, $mid, $mdate, $mid, $mid, $timeout1,"Biometrics"));
									
									$attendancelog=$sql." ".$empid ." ".$adate." ".$data[$attsts]." ".$shift." ".$data[$timein]." ".$orgid. " ".$mdate." ". $mid." ". $mdate." ". $mid." ".$mid." ".$timeout1." ".$overtime." | Device: insertFileHeaders AttendanceModel hrm";
										Utils::TraceAttendance($attendancelog);
									$count1+=$query->rowCount();
									$name="";
									if(($data[$attsts] == 2) && ($adate == date('Y-m-d')))
									{
										$title="Absent - Unauthorized ";
										$name =Utils::getEmployeeName($empid,$this->db);
										$msg=$name." is Absent today without any information";
										$hrarr=Utils::getHR($orgid,$this->db);
										for($i=0;$i<count($hrarr);$i++){
											$sql1 = "INSERT INTO GenerateNotification (  EmployeeId, Title, Message, NotifyDate, OrganizationId) VALUES (?, ?, ?, ?, ?)";
											$query1 = $this->db->prepare($sql1);
											$query1->execute(array( $hrarr[$i],$title,$msg,$mdate,$orgid ));	
										}
									}
									
								}
								/////notification if an employee get late 3rd time in a month////
								$temp=date("Y-m-01",strtotime($adate));
								$con=0;
								$shifttimein = $this->getShiftTime($shift,"TimeInGrace");
								$sql1="select TimeIn from AttendanceMaster where EmployeeId=? and AttendanceDate between '$temp' and '$adate'";
								$query1=$this->db->prepare($sql1);
								$query1->execute(array($empid));
								while($r=$query1->fetch()){
									if(strtotime($r->TimeIn) > strtotime($shifttimein))
									{
										$con++;
									}
								}	
								
								if($con>=3)
								{
									$name=Utils::getEmployeeName($empid,$this->db);
									$countinwords=$this->getNumberinWords($con);
									$title="$countinwords ($con) instances of late reporting this month ";
									$adate1=$data[$atdate];
									$amonth=date("F",strtotime(Utils::getDateformat($adate1)));
									$con1=$con."th";
									if($con==3)
										$con1=$con."rd";
									$msg= "$name has reported late for the $con1 time on $adate1 in $amonth ";
									$hrarr=Utils::getHR($orgid,$this->db);
									$empids=implode(',',$hrarr);
									$sqln="select Id from NotificationMaster where Name=? and Message=? and EmployeeIds=? and OrganizationId=?";
									$queryn=$this->db->prepare($sqln);
									$queryn->execute(array($title, $msg, $empids, $orgid));
									if($queryn->rowCount()==0){
										$sql1="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, EndDate, NotificationPriority,NotificationType) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
										$query1 = $this->db->prepare($sql1);
										$query1->execute(array($title, $msg, $empids, $orgid, $mdate, $mid, $mdate, $mid, $mid, $mdate, date("Y-m-d", strtotime(date("Y-m-d")." , +1 days ")), 2,2));
									}
								}
							}	
					}							
						$i++;
				}
			}		
		
		if ($count1 == 0) {
			$status =false;
			$errorMsg = ATTENDANCE_MODULE_MARKEDALREADY;
		}else{
			$status =true;
			$successMsg = $count1.' '.ATTENDANCE_MODULE_IMPORT;
		} 
	}catch(Exception $e) {
		$errorMsg = 'Message: ' .$e->getMessage();
	}		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
  
  public function getReportingIds($empid)
	{
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$ids = "0";
		
		$parentid=$empid;
		if($parentid!="0" && $parentid!="")
		{
			while($parentid!="")
			{
				$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and ReportingTo in ( $parentid ) and Is_Delete=0";
				
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($orgid));
				$parentid="";
				while($row1 = $query1->fetch())
				{
					if($parentid==""){
						$parentid = $row1->Id;
					}else{
						$parentid .= ", ".$row1->Id;
					}
					if($ids==""){
						$ids = $row1->Id;
					}else{
						$ids .= ",".$row1->Id;
					}
					
				}
				
			}
		}
			return $ids;
	}
	
	public function htmltopdf($rportid){
		///////to convert html to pdf///////
//	$url = "http://192.168.0.200/UBIHRM/attendance/viewreport/".Utils::encode5t($rportid)."";
	//$url = "http://newdemo.ubihrm.com/attendance/viewreport/".Utils::encode5t($rportid)."";
	$internal_url = "http://newdemo.ubihrm.com/attendance/reports/viewreport.php";
	$my_html = file_get_contents($internal_url);
	//echo $url ;
		 require(LIBS_PATH."phpToPDF.php");
		 $pdf_options = array(
          "source_type" => 'html',
         "source" => $my_html,
		  "action" => 'view',
		// "source" => "http://newdemo.ubihrm.com/attendance/viewreport/".Utils::encode5t($rportid)."",
		   "save_directory" => '',
		   "file_name" => 'offerletter.pdf',
         );
		phptopdf($pdf_options); 
		//echo ("<a href='public/report/offerletter.pdf'>Download Your PDF</a>");
		//End Code to generate PDF file
			}

	public function getNumberinWords($con)
	{
		$name =" ";
		$list1  = array('','One','Two','Three','Four','Five','Six','Seven',
            'Eight','Nine','Ten','Eleven','Twelve','Thirteen','Fourteen',
            'Fifteen','Sixteen','Seventeen','Eighteen','Nineteen','Twenty','Twenty one','Twenty two','Twenty three','Twenty four','Twenty five','Twenty six','Twenty seven','Twenty eight','Twenty nine','Thirty','Thirty one');
		$name=$list1[$con];
		return $name;
	}
			
	/**
   * Saving Weekly Off for an Organization 
	*/
    public function saveWeeklyOff($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$mdate = date("Y-m-d H:i:s");
		$SundayArr = json_decode($request[2], true); 
		$MondayArr = json_decode($request[3], true); 
		$TuesdayArr = json_decode($request[4], true); 
		$WednesdayArr = json_decode($request[5], true); 
		$ThursdayArr = json_decode($request[6], true); 
		$FridayArr = json_decode($request[7], true); 
		$SaturdayArr = json_decode($request[8], true); 
		
		try{
			$sunday="";
			$monday="";
			$tuesday="";
			$wednesday="";
			$thursday="";
			$friday="";
			$saturday="";
			for($i=0; $i<=4; $i++)
			{
				if($sunday=="")
					$sunday=$SundayArr[$i]['week'];
				else
					$sunday.=",".$SundayArr[$i]['week'];
				
				if($monday=="")
					$monday=$MondayArr[$i]['week'];
				else
					$monday.=",".$MondayArr[$i]['week'];
				
				if($tuesday=="")
					$tuesday=$TuesdayArr[$i]['week'];
				else
					$tuesday.=",".$TuesdayArr[$i]['week'];
				
				if($wednesday=="")
					$wednesday=$WednesdayArr[$i]['week'];
				else
					$wednesday.=",".$WednesdayArr[$i]['week'];
				
				if($thursday=="")
					$thursday=$ThursdayArr[$i]['week'];
				else
					$thursday.=",".$ThursdayArr[$i]['week'];
				
				if($friday=="")
					$friday=$FridayArr[$i]['week'];
				else
					$friday.=",".$FridayArr[$i]['week'];
				
				if($saturday=="")
					$saturday=$SaturdayArr[$i]['week'];
				else
					$saturday.=",".$SaturdayArr[$i]['week'];
			}
			$sql1 = "Select * from WeekOffMaster WHERE OrganizationId=?";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($orgid));
			$count1 =  $query1->rowCount();				
			if($count1==0)
			{		
					$count=0;		
					$sql = "INSERT INTO WeekOffMaster ( Day, WeekOff, OrganizationId, ModifiedBy, ModifiedDate) VALUES (?, ?, ?, ?, ?),(?, ?, ?, ?, ?),(?, ?, ?, ?, ?),(?, ?, ?, ?, ?),(?, ?, ?, ?, ?),(?, ?, ?, ?, ?),(?, ?, ?, ?, ?)";		
					$query = $this->db->prepare($sql);
					$query->execute(array('1',$sunday,$orgid,$mid, $mdate,'2',$monday,$orgid,$mid, $mdate,'3',$tuesday,$orgid,$mid, $mdate,'4',$wednesday,$orgid,$mid, $mdate,'5',$thursday,$orgid,$mid, $mdate,'6',$friday,$orgid,$mid, $mdate,'7',$saturday,$orgid,$mid, $mdate));
					$count =  $query->rowCount();
					
			}else{
					$count=0;		
					$sql = "update WeekOffMaster set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($sunday,$mid,$mdate,$orgid,'1'));
					$count +=  $query->rowCount();
					
					$sql = "update WeekOffMaster set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($monday,$mid,$mdate,$orgid,'2'));
					$count +=  $query->rowCount();
					
					$sql = "update WeekOffMaster set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($tuesday,$mid,$mdate,$orgid,'3'));
					$count +=  $query->rowCount();
					
					$sql = "update WeekOffMaster set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($wednesday,$mid,$mdate,$orgid,'4'));
					$count +=  $query->rowCount();
					
					$sql = "update WeekOffMaster set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($thursday,$mid,$mdate,$orgid,'5'));
					$count +=  $query->rowCount();
					
					$sql = "update WeekOffMaster set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($friday,$mid,$mdate,$orgid,'6'));
					$count +=  $query->rowCount();
					
					$sql = "update WeekOffMaster set WeekOff=?, ModifiedBy=?, ModifiedDate=? where OrganizationId=? and Day=?";		
					$query = $this->db->prepare($sql);
					$query->execute(array($saturday,$mid,$mdate,$orgid,'7'));
					$count +=  $query->rowCount();
			}
		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
        if ($count >0) {
			   $status =true;
			   $successMsg = "Weekly Off is Updated Successfully";
		} else {
           $status =false;
		   $errorMsg = "Weekly Off is not updated";
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
			
			
	/**
     * Get method for fetching the records of weeklyoff
     * @return array an array with several objects (the results)
     */
    public function getOrganizationWeekOff($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM WeekOffMaster WHERE OrganizationId = :id ";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['Day'] = $row->Day;
				$res['WeekOff'] = $row->WeekOff;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = ATTENDANCE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getGeolocation($editper, $deleteper)
	{
			$sTable = 'Geo_Settings';
		$sIndexColumn = "Id";
		$aColumns = array( 'Name', 'Lat_Long', 'Location', 'Radius','Status','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];	
		if($sts==1 || $hrsts==1){
			$sWhere = "WHERE OrganizationId= $orgid ";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";$assignGeo;
					if($editper){
						//$edit = '<a rel="tooltip" title="Edit" href="'.URL.'attendance/editgeofence/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" data-target="#myModal"><i class="fa fa-edit"></i></a>';
						$edit = '<a rel="tooltip" title="Edit" href="#"><i class="fa fa-edit" onclick="angular.element(this).scope().getGeoDetail(\''.$aRow->Id .'\',\''.$aRow->Name . '\',\''.$aRow->Status .'\',\''.number_format((float)$aRow->Radius, 2, '.', '') . '\')"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().deleteGeoDetail(\''.$aRow->Id .'\',\''.$aRow->Name . '\')"  href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}
					if($editper){
						$assignGeo = '<a rel="tooltip" title="Assign To" href="#"><i class="fa fa-tasks" onclick="angular.element(this).scope().assignGeo(\''.$aRow->Id .'\')"></i></a>';
					}else{
						$assignGeo = '<a href="#" rel="tooltip" title="No permission to assign location"><i class="fa fa-tasks"></i></a>';
					}					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete."&nbsp;&nbsp;|&nbsp;&nbsp;".$assignGeo;;
				}
				elseif($aColumns[$i]=="Location"){
					$row[] = '<a href="http://maps.google.com/?q='.$aRow->Lat_Long .'" target="_blank" title="Click to see location on map">'.$aRow->{$aColumns[$i]}.'</a>';
				}
				
				elseif($aColumns[$i]=="Radius"){
					$row[] = number_format((float)$aRow->{$aColumns[$i]}, 2, '.', '');
				}
				elseif($aColumns[$i]=="Status"){
					//$row[] = Utils::getattendancetype($aRow->{$aColumns[$i]});
					$status=$aRow->{$aColumns[$i]};
					if($status==1){
					$row[] = "<span class='label label-success'>Active</span>";
					}
					else{
						$row[] = "<span class='label label-danger'>Inactive</span>";
					}
				}
				
				else
				{
					/* if($i==0){
					$row[] = '<a rel="tooltip" title="View" href="'.URL.'attendance/viewshift/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
					}
					else{
					$row[] = $aRow->{$aColumns[$i]};
					} */
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
		}
		
		public function getLocationById($addper,$editper,$id) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		$sql = "SELECT * FROM Geo_Settings WHERE OrganizationId =?  and Id = ?";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array($orgid,$shiftid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['empfname'] = $row->FirstName;
				$res['emplname'] = $row->LastName;
				
				$res['sts']=0;
				
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function saveGeolocation()
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		
	 	$id =  isset($_REQUEST['id'])?$_REQUEST['id']:0;
	 	$name =  isset($_REQUEST['name'])?$_REQUEST['name']:'';
		$location =  isset($_REQUEST['location'])?$_REQUEST['location']:'';
		$latlong =  isset($_REQUEST['latlong'])?$_REQUEST['latlong']:'';
		$radius =  isset($_REQUEST['radius'])?$_REQUEST['radius']:0;
		$status = isset($_REQUEST['sts'])?$_REQUEST['sts']:'';
		$pregeoname=Utils::getName($id,'Geo_Settings','Name',$this->db);


		if($id != 0)
		{
			$sql1 = "SELECT Id from Geo_Settings where Id != ? AND Name = ? AND OrganizationId= ? ";
			$query1 = $this->db->prepare($sql1);
			$query1->execute(array($id,$name,$orgid));
			$count =  $query1->rowCount();
			if($count>0){
				$status =false;
				$errorMsg = "Geo-center name is already exist";
			}
			else{
				$sql = "UPDATE Geo_Settings SET Name=?,Status=?,Radius=? WHERE Id = ? AND OrganizationId= ? ";
				try{		
					$query = $this->db->prepare($sql);
					$query->execute(array($name,$status,$radius ,$id,$orgid));		
					$count1 =  $query->rowCount();
					if($count1>0){
						$status =true;
						$successMsg = "Geo-center updated successfully";
					}
					else{
						$status =false;
						$errorMsg = "No change found";
					}

				/////////////////////////Activity log////////////////////////////
				$msg="Geo-center details has been updated from <b>$pregeoname</b> to <b>$name</b>.";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Attendance Setting", $msg, $orgid));					
			
				}catch(Exception $e){
					$errorMsg = 'Message: ' .$e->getMessage();
				}
			}
					
		}
		else
		{
			$count=0;
			$query="select Id from Geo_Settings where Name=? and OrganizationId=?";
			try	{			
				$query = $this->db->prepare($query);
				$query->execute(array($name,$orgid));		
				$count =  $query->rowCount();
				if($count>0)
				 {
					$status= false; 
					$errorMsg= "Geo-Center name already exist"; 
				 }
				 else{
					$sql="INSERT INTO  Geo_Settings (`OrganizationId`,`Lat_Long`,`Location`,`Radius`,`Name`) VALUES (?,?,?,?,?)";
					$query = $this->db->prepare($sql);
					$query->execute(array($orgid,$latlong,$location,$radius,$name));
					$count =  $query->rowCount();
					if($count)
					{
					$status= true; 
					$successMsg= "Geo-Center inserted successfully"; 
					}
					else
					{
					$status= false; 
					$errorMsg= "There is some problem when insert a location"; 
					}
				 }
				 
				 /////////////////////////Activity log////////////////////////////
				$msg="<b>$name</b> geo centre has been added.";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Attendance Setting", $msg, $orgid));
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			 
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
			
		// default return
		return $result;
    }
	public function updateGeolocation()
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		
		$id =  isset($_REQUEST['id'])?$_REQUEST['id']:'';
	 	$name =  isset($_REQUEST['name'])?$_REQUEST['name']:'';
		$status = isset($_REQUEST['sts'])?$_REQUEST['sts']:'';
		$sql1 = "SELECT Id from Geo_Settings where Id != ? AND Name = ? ";
		$query1 = $this->db->prepare($sql1);
		$query1->execute(array($id,$name));
		$count =  $query1->rowCount();
		if($count>0){
			$status =false;
			$errorMsg = "Location name is already exist";
		}
		else{
		$sql = "UPDATE Geo_Settings SET Name=?,Status=? WHERE Id = ? AND OrganizationId= ? ";
		try{		
			$query = $this->db->prepare($sql);
			$query->execute(array($name,$status,$id,$orgid));		
			$count1 =  $query->rowCount();
			if($count1>0){
				$status =true;
				$successMsg = "Location updated successfully";
			}
			else{
				$status =false;
				$errorMsg = "There is some problem when update a location";
			}
			
		}catch(Exception $e){
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
			
		// default return
		return $result;
    }
	public function deleteGeofenceDetail($did)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");	
		$orgid=$_SESSION['ubihrm_org_id'];
		$mid=$_SESSION['ubihrm_user_id'];
		$did=$did;
		try{
			//$sql = "Select EmployeeId FROM AttendanceMaster WHERE Id = :id and Is_Delete='0'";
			//$query->execute(array(':id' => $did));
			$count=0;
			$sql = "select Id from EmployeeMaster where EmployeeMaster.area_assigned=? and OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($did,$orgid));
			while($row=$query->fetch())
			{
				$empid=$row->Id;
			} 
			$count =  $query->rowCount();
	
        if ($count == 0) {
			$sql = "DELETE FROM `Geo_Settings` where id=? and OrganizationId=?";
			$query = $this->db->prepare($sql);
			$query->execute(array($did,$orgid));
           $status =true;
		   $successMsg = "Geo-Center deleted successfully";
        }else {							
			//$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
			$status =false;
			$errorMsg = "This Geo-Center is currently assigned to ' $count ' employee(s).'";
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		//$this->db = null;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function assignGeo($request) {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$geoid = $request[2];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;

		$sql = "SELECT * FROM EmployeeMaster WHERE Is_Delete =0 and OrganizationId =?  and area_assigned!=? and (DOL='0000-00-00' or DOL>curdate()) order by FirstName";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array($orgid,$geoid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['empfname'] = $row->FirstName;
				$res['emplname'] = $row->LastName;
				
				$res['sts']=0;
				
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function SaveEmpGeoList($request) {
        $result = array();
        $count=0; $errorMsg=""; $successMsg=""; $status=false;$count1=0;
        $data = array();
        $mdate=date('Y-m-d H:i:s');
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$geoid = $request[2];	
        try{
            $geoemplistarr = json_decode($_POST['geoemplist'], true);
            for($i=0; $i<count($geoemplistarr); $i++)
            {
				//print_r($geoemplistarr);
               // if($geoemplistarr[$i]['sts']==1){
                if(isset($geoemplistarr[$i]['selected']) && $geoemplistarr[$i]['selected']== true){
					//print_r($geoemplistarr);
					$empid = $geoemplistarr[$i]['id'];
					$sql = " update EmployeeMaster set area_assigned=? ,  LastModifiedDate=?  where Id=?";
					$query = $this->db->prepare($sql);
					$query->execute(array($geoid,$mdate, $empid));
					$count=$query->rowCount();
                }
            }
          
    
            if($count>=1)
            {
                $status=true;
                $successMsg="Geo-Center assigned successfully";
            }
            else{
                $status=false;
                $errorMsg="Failed to assign location";;
            }
        }catch(Exception $e){
            $status = false;
            $errorMsg =$e->getMessage();
        }
        
        $result["data"] =$data;
        $result['status']=$status;
        $result['successMsg']=$successMsg;
        $result['errorMsg']=$errorMsg;
        
        return $result;
    }
	public function getallgeocenter($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$ids=Utils::getReportingIds($mid,$this->db);
		$sWhere = " and Id in (select area_assigned FROM EmployeeMaster where Id in ($ids))";	
		if($sts==1 || $hrsts==1){
			$sWhere = " ";
		}
        $sql = "SELECT Id,Name FROM Geo_Settings WHERE OrganizationId = :id $sWhere order by Name";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = "No record found.";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getOutsideAtt($request){
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$date  = date("Y-m-d");
		$val=isset($_REQUEST['val'])?$_REQUEST['val']:0;
		$date1 = isset($_REQUEST['attdate'])?$_REQUEST['attdate']:date("Y-m-d");
		if($date1=="")
			$date1=$date;
		$swhr="and A.AttendanceDate='".$date1."'";
		if($val==1) //monthly
			$swhr="and YEAR(A.AttendanceDate) = YEAR(CURRENT_DATE()) AND 
		  MONTH(A.AttendanceDate) = MONTH(CURRENT_DATE())";
		if($val==2) //weekly
			$swhr="and WEEKOFYEAR(A.AttendanceDate)=WEEKOFYEAR(NOW())";
		if($val==3) //daily
			$swhr="and A.AttendanceDate='".$date."'";
			
		
		$sql = "SELECT A.Id, A.EmployeeId, E.FirstName, E.LastName,E.EmployeeCode, A.AttendanceDate as date, A.AttendanceStatus, A.TimeIn, A.TimeOut, A.ShiftId, A.Overtime,A.EntryImage, A.ExitImage,A.latit_in,A.longi_in,A.longi_out,A.latit_out, A.checkInLoc, A.CheckOutLoc,A.areaId, G.Lat_Long, G.Radius FROM AttendanceMaster A, Geo_Settings G, EmployeeMaster E WHERE A.OrganizationId=".$orgid." and G.OrganizationId = ".$orgid." and E.OrganizationId = ".$orgid." $swhr and A.TimeIn!='00:00' and A.areaId!=0 and G.Id=A.areaId and E.Id= A.EmployeeId AND E.Is_Delete = 0 order by A.AttendanceDate Desc";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute();
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res1=array();
				$res1['Name']=$row->FirstName." ".$row->LastName;	
				$res1['code']=$row->EmployeeCode;	
				$res1['date']=Utils::dateformatter($row->date);	
				//print_r($res1['Name']);
				$res1['ti']=substr($row->TimeIn,0,-3);
				$res1['to']=substr($row->TimeOut,0,-3);
				$res1['positionlin']="";
				$res1['positionout']="";
				$res1['latit_in']=$row->latit_in;
				$res1['latit_out']=$row->latit_out;
				$lat_lang = $row->Lat_Long;
				$radius = $row->Radius;
				$arr1 = explode(",",$lat_lang);
				if(count($arr1)>1)
				{
						$a=floatval($arr1[0]);
						$b=floatval($arr1[1]);
						$d1 = $this->distance($a,$b, $row->latit_in, $row->longi_in, "K");
						
						$d2 = $this->distance($a,$b, $row->latit_out, $row->longi_out, "K");
					if($row->latit_in!='0.0' && $row->latit_in!='0'){
						if($d1 <= $radius){
							$res1['positionlin'] = '';
						}else{
							$res1['positionlin'] =' - Outside the Location';
						}
					}
					if($row->latit_out!='0.0' && $row->latit_out!='0'){
						if($d2 <= $radius){
							$res1['positionout'] = '';
						}else{
							$res1['positionout'] =' - Outside the Location';
						}
					}
				}
				$res1['asts']=0;
				if($res1['positionout']!='' || $res1['positionlin']!=''){
					$res1['asts']=1;
					if($res1['positionout']=='' && $res1['to']!='00:00')
						$res1['positionout']=' - Within the location';
					if($res1['positionlin']=='')
						$res1['positionlin']=' - Within the location';
					
				}
				
				
				$data[] = $res1;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$dateview=Utils::dateformatter($date1);
		if($val==1)
			$dateview=date("F Y", strtotime($date));
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['dateview']=$dateview;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
		
	}
	public function geocenterempbydiv($request){
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$divisionid = $request[2];	//DIVISION ID CONTAINS IN ARRAY SECOND VALUE;
		$geoid = $request[3];	//geocenter ID CONTAINS IN ARRAY SECOND VALUE;
		$sql = "SELECT * FROM EmployeeMaster WHERE Is_Delete =0 and OrganizationId =?  and Division=? and area_assigned!=? and (DOL='0000-00-00' or DOL>curdate()) order by FirstName";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array($orgid,$divisionid,$geoid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['empfname'] = $row->FirstName;
				$res['emplname'] = $row->LastName;
				
				$res['sts']=0;
				
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
		
	}
	public function distance($lat1, $lon1, $lat2, $lon2, $unit) {
		$theta = $lon1 - $lon2;
		$dist = sin(deg2rad((float)$lat1)) * sin(deg2rad((float) $lat2)) +  cos(deg2rad((float) $lat1)) * cos(deg2rad((float) $lat2)) * cos(deg2rad((float) $theta));
		$dist = acos($dist);
		$dist = rad2deg($dist);
		$miles = $dist * 60 * 1.1515;
		$unit = strtoupper($unit);
		
		if ($unit == "K") {
			return ($miles * 1.609344);
		}else if ($unit == "N"){
			return ($miles * 0.8684);
		}else {
			return $miles;
		}
	}		
}
