<?php

/**
 * VisaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class AssessmentobjectivedubaiModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM AssessmentObjective WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = OBJECTIVE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM AssessmentObjective WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['desig'] = (int)$row->DesignationId;
				$res['period'] = $row->Period;
				$res['threshholdscore'] = (int)$row->ThreshholdScore;
				$res['achievingamt'] =(int) $row->AchievingAmount;
				$res['variablepaysts'] =(int) $row->VariablePaySts;
				
				$res['desiglevel'] = isset($row->DesignationLevel)?explode(',',$row->DesignationLevel):"";
				$objective=array();
				$results=array();
				$overachieve=array();
				$sql1 = "SELECT * FROM AssessmentObjectiveChild WHERE AssessmentObjectiveId = :id and VisibleSts=1";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row1 = $query1->fetch())
				{
					$res1=array();
					$res1['id'] = $row1->Id;
					$res1['quadrant'] = $row1->QuadrantId;
					$res1['objective'] = $row1->Objective;
					$res1['weightage'] = (int)$row1->Weightage;
					$objective[]=$res1;
				}
				$sql1 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row1 = $query1->fetch())
				{
					$res1=array();
					$res1['id'] = $row1->Id;
					$res1['minmarks'] = (int)$row1->MinMarks;
					$res1['maxmarks'] = (int)$row1->MaxMarks;
					$res1['result'] = $row1->Result;
					$res1['rating'] =(int) $row1->Rating;
					$res1['amt'] =(int) $row1->VariablePayAmt;
					
					$results[]=$res1;
				}
				$sql1 = "SELECT * FROM PerformanceOverAchieve WHERE AssessmentObjectiveId = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row1 = $query1->fetch())
				{
					$res1=array();
					$res1['id'] = $row1->Id;
					$res1['minmarks'] = (int)$row1->MinMarks;
					$res1['maxmarks'] = (int)$row1->MaxMarks;
					$res1['amount'] = (int)$row1->Amount;
					
					$overachieve[]=$res1;
				}
				$res['objective']=$objective;
				$res['result']=$results;
				$res['overachieve']=$overachieve;
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = OBJECTIVE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = OBJECTIVE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    /**
     * Setter for a AssessmentObjective (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
		$desiglevel="";
        $temp=$request[5];
		for($i=0;$i<count($temp);$i++){
			if($desiglevel == ""){
				$desiglevel =$temp[$i]['desiglevel'];
			}
			else{
				$desiglevel .=",". $temp[$i]['desiglevel'];
			}
		}
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM AssessmentObjective WHERE Id != ? and DesignationId = ?  and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[4], $request[2], $orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=OBJECTIVE_MODULE_UPDATION_DUPLICATE;
		}else{
		
			$sql = "UPDATE AssessmentObjective SET DesignationId=?,Period =?, DesignationLevel=?, LastModifiedDate=?, LastModifiedById=? , ThreshholdScore = ?,  	AchievingAmount = ? , VariablePaySts =? where Id=?";
			$query = $this->db->prepare($sql);
			
			try{
				
				$query->execute(array($request[2],$request[3], $desiglevel,  $mdate, $mid, $request[6], $request[7],$request[8],$request[4] ));

			
			// INSERTING AND UPDATING OBJECTIVE CHILD IF PASSED AS AN JSON
			$objective = json_decode($_POST['objective'], true); 
			$objectiveid="0";
			for($i=0; $i<count($objective); $i++){
				$objectiveid .= ",".$objective[$i]['id'];
			}
			$sqlobjective = " UPDATE AssessmentObjectiveChild SET VisibleSts=0 WHERE AssessmentObjectiveId=? AND Id NOT IN ($objectiveid)";
			$queryobjective = $this->db->prepare($sqlobjective);
			$queryobjective->execute(array( $request[4]));
			
			for($i=0; $i<count($objective); $i++)
			{
				if($objective[$i]['quadrant']!="" && $objective[$i]['objective']!=""){
					$record = array();
					$record[0] = $request[4];
					$record[1] = $objective[$i]['quadrant'];
					$record[2] = $objective[$i]['objective'];
					$record[3] = $objective[$i]['weightage'];
					$record[4] = $orgid;
					$record[5] = $mdate;
					$record[6] = $mid;
					$record[7] = $mdate;
					$record[8] = $mid;
					$record[9] = $mid;
					$id = $objective[$i]['id'];
					
					if($id){
						$sqlobjective = " UPDATE AssessmentObjectiveChild SET AssessmentObjectiveId=?, QuadrantId=?, Objective=?, Weightage=?, LastModifiedDate=?, LastModifiedById=? ,OrganizationId= ? where Id=?";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute(array($request[4],$objective[$i]['quadrant'],$objective[$i]['objective'],$objective[$i]['weightage'],$mdate,$mid,$orgid,  $id));
					}else{
						$sqlobjective = " INSERT INTO AssessmentObjectiveChild (AssessmentObjectiveId, QuadrantId, Objective, Weightage, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId) values (?,?,?,?,?,?,?,?,?,?)";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute($record);
					}
					
				}
			}

			// INSERTING AND UPDATING ASSESSMENT RESULT IF PASSED AS AN JSON
			$aresult = json_decode($_POST['result'], true); 
			$aresultid="0";
			for($i=0; $i<count($aresult); $i++){
				$aresultid .= ",".$aresult[$i]['id'];
			}
			$sqlaresult = " DELETE FROM AssessmentResult WHERE AssessmentObjectiveId=? AND Id NOT IN ($aresultid)";
			$queryaresult = $this->db->prepare($sqlaresult);
			$queryaresult->execute(array( $request[4]));
			
			for($i=0; $i<count($aresult); $i++)
			{
				if(  $aresult[$i]['result']!=""){
					$record = array();
					$record[0] = $request[4];
					$record[1] = $aresult[$i]['minmarks'];
					$record[2] = $aresult[$i]['maxmarks'];
					$record[3] = $aresult[$i]['result'];
					$record[4] = $aresult[$i]['rating'];
					$record[5] = 0; //$aresult[$i]['amt'];
					$id = $aresult[$i]['id'];
					
					if($id){
						$sqlaresult = " UPDATE AssessmentResult SET AssessmentObjectiveId=?, MinMarks=?,MaxMarks=?, Result=?,Rating=?,VariablePayAmt=? where Id=?";
						$queryaresult = $this->db->prepare($sqlaresult);
						$queryaresult->execute(array($request[4],$aresult[$i]['minmarks'],$aresult[$i]['maxmarks'],$aresult[$i]['result'],$aresult[$i]['rating'], $aresult[$i]['amt'], $id));
					}else{
						$sqlaresult = " INSERT INTO AssessmentResult ( AssessmentObjectiveId, MinMarks,MaxMarks, Result,Rating,VariablePayAmt) values (?,?,?,?,?,?)";
						$queryaresult = $this->db->prepare($sqlaresult);
						$queryaresult->execute($record);
					}
					
				}
			}		
			
			// INSERTING AND UPDATING OVER ACHIEVING ASSESSMENT RESULT IF PASSED AS AN JSON
			$overachieve = json_decode($_POST['overachieve'], true); 
			//print_r($overachieve);
			$aresultid="0";
			for($i=0; $i<count($overachieve); $i++){
				$aresultid .= ",".$overachieve[$i]['id'];
			}
			$sqlaresult = " DELETE FROM PerformanceOverAchieve WHERE AssessmentObjectiveId=? AND Id NOT IN ($aresultid)";
			$queryaresult = $this->db->prepare($sqlaresult);
			$queryaresult->execute(array( $request[4]));
			
			for($i=0; $i<count($overachieve); $i++)
			{
				if(  $overachieve[$i]['amount']!="" ){
					$record = array();
					$record[0] = $request[4];
					$record[1] = $overachieve[$i]['minmarks'];
					$record[2] = $overachieve[$i]['maxmarks'];
					$record[3] = isset($overachieve[$i]['amount'])?$overachieve[$i]['amount']:0;
					
					$id = $overachieve[$i]['id'];
					
					if($id){
						$sqlaresult = " UPDATE PerformanceOverAchieve SET AssessmentObjectiveId=?, MinMarks=?,MaxMarks=?, Amount=? where Id=?";
						$queryaresult = $this->db->prepare($sqlaresult);
						$queryaresult->execute(array($request[4],$overachieve[$i]['minmarks'],$overachieve[$i]['maxmarks'],$overachieve[$i]['amount'],$id));
					}else{
						$sqlaresult = " INSERT INTO PerformanceOverAchieve ( AssessmentObjectiveId, MinMarks,MaxMarks, Amount) values (?,?,?,?)";
						$queryaresult = $this->db->prepare($sqlaresult);
						$queryaresult->execute($record);
					}
					
				}
			}
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			    $status =true;
			    $successMsg = OBJECTIVE_MODULE_UPDATION_SUCCESS;
			    $sql3 = "SELECT Id FROM EmployeeMaster WHERE Designation = ? and OrganizationId = ? ";
				$query3 = $this->db->prepare($sql3);
				$query3->execute(array( $request[2],$orgid ));
				while($r=$query3->fetch()){
					
					$sql1="UPDATE EmployeeAssessment set DesignationLevel = ?  WHERE EmployeeId=? AND AssessmentSts=0";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($desiglevel,$r->Id));
					
				}	
			
			} else {
			   $status =false;
			   $errorMsg = OBJECTIVE_MODULE_UPDATION_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		$this->db = null;
        // default return
        return $result;
    }

   
    /**
     * Setter for a AssessmentObjective (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
        $desiglevel="";
        $temp=$request[4];
		for($i=0;$i<count($temp);$i++){
			if($desiglevel == ""){
				$desiglevel =$temp[$i]['desiglevel'];
			}
			else{
				$desiglevel .=",". $temp[$i]['desiglevel'];
			}
		}
		$mdate = date("Y-m-d H:i:s");
		
		$sql1 = "SELECT * FROM AssessmentObjective WHERE DesignationId = ? and OrganizationId=?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($request[2],$orgid));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=OBJECTIVE_MODULE_UPDATION_DUPLICATE;
		}else{
		
			$sql = "INSERT INTO AssessmentObjective (DesignationId , Period ,  DesignationLevel, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId , ThreshholdScore , AchievingAmount, VariablePaySts) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],$request[3], $desiglevel, $orgid, $mdate, $mid, $mdate, $mid, $mid,$request[5],$request[6], $request[7]));
				$aid=$this->db->lastInsertId();
					// INSERTING OBJECTIVE CHILD IF PASSED AS AN JSON
				$objective = json_decode($_POST['objective'], true); 
				for($i=0; $i<count($objective); $i++)
				{
					if($objective[$i]['quadrant']!="" && $objective[$i]['objective']!=""){
						$record = array();
						$record[0] = $aid;
						$record[1] = $objective[$i]['quadrant'];
						$record[2] = $objective[$i]['objective'];
						$record[3] = $objective[$i]['weightage'];
						$record[4] = $orgid;
						$record[5] = $mdate;
						$record[6] = $mid;
						$record[7] = $mdate;
						$record[8] = $mid;
						$record[9] = $mid;
						
						$sqlobjective = " INSERT INTO AssessmentObjectiveChild (AssessmentObjectiveId, QuadrantId, Objective, Weightage, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId) values (?,?,?,?,?,?,?,?,?,?)";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute($record);
					}
				}
				
				// INSERTING ASSESSMENT RESULT IF PASSED AS AN JSON
			$aresult = json_decode($_POST['result'], true); 
						
			for($i=0; $i<count($aresult); $i++)
			{
				if(  $aresult[$i]['result']!=""){
					$record = array();
					$record[0] = $aid;
					$record[1] = $aresult[$i]['minmarks'];
					$record[2] = $aresult[$i]['maxmarks'];
					$record[3] = $aresult[$i]['result'];
					$record[4] = $aresult[$i]['rating'];
					$record[5] = isset($aresult[$i]['amt'])?$aresult[$i]['amt']:0;
									
					$sqlaresult = " INSERT INTO AssessmentResult ( AssessmentObjectiveId, MinMarks,MaxMarks, Result,Rating,VariablePayAmt) values (?,?,?,?,?,?)";
					$queryaresult = $this->db->prepare($sqlaresult);
					$queryaresult->execute($record);
					
					
				}
			}	

			// INSERTING AND UPDATING OVER ACHIEVING ASSESSMENT RESULT IF PASSED AS AN JSON
			$overachieve = json_decode($_POST['overachieve'], true); 
			
			for($i=0; $i<count($overachieve); $i++)
			{
				if(  $overachieve[$i]['amount']!="" ||  $overachieve[$i]['minmarks']!="" ||  $overachieve[$i]['maxmarks']!=""){
					$record = array();
					$record[0] = $aid;
					$record[1] = $overachieve[$i]['minmarks'];
					$record[2] = $overachieve[$i]['maxmarks'];
					$record[3] = isset($overachieve[$i]['amount'])?$overachieve[$i]['amount']:0;
					
					$sqlaresult = " INSERT INTO PerformanceOverAchieve ( AssessmentObjectiveId, MinMarks,MaxMarks, Amount) values (?,?,?,?)";
					$queryaresult = $this->db->prepare($sqlaresult);
					$queryaresult->execute($record);
				}
			}	
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = OBJECTIVE_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = OBJECTIVE_MODULE_CREATION_FAILED;
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		try{
			$sql = "Select * from AssessmentObjective WHERE Id = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch()){
				$aid=$row->DesignationId;
				$sql2 = "Select * from EmployeeMaster WHERE Designation = :id ";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array(':id' => $aid));	
				while($row2=$query2->fetch()){
					$eid=$row2->Id;
					$sql3 = "Select * from EmployeeAssessment WHERE EmployeeId = :id ";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array(':id' => $eid));	
					while($row3=$query3->fetch()){
						$count1++;
					}
				}
				if($count1>=1){
					$status =false;
					$errorMsg = OBJECTIVE_MODULE_DELETE_EXIST;
				
				}else{
						$sql1 = "DELETE FROM AssessmentObjective WHERE Id = :id ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array(':id' => $did));
						
						$sql1 = "DELETE FROM AssessmentObjectiveChild WHERE AssessmentObjectiveId = :id ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array(':id' => $did));
					
						$count =  $query1->rowCount();		
					
					
					if ($count == 1) {
					   $status =true;
					   $successMsg = OBJECTIVE_MODULE_DELETE_SUCCESS;
					}else {
					   $status =false;
					   $errorMsg = OBJECTIVE_MODULE_DELETE_FAILED;
					}
				}
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function getSeniorDesigs($desig)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $level=1;
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$ids = "0";
		$res = array();
		$res['id'] = $desig;
		$res['name'] = $this->getName($desig,'DesignationMaster');
		$res['level'] = $level;
		$data[] = $res;
		$parentid=$desig;
		try{
			if($parentid!="0" && $parentid!="")
			{
				while($parentid!="")
				{
					
					$sql1 = "SELECT * FROM DesignationMaster WHERE OrganizationId = ? and Id in ( $parentid ) ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($orgid));
					$count=$query1->rowCount();
					$parentid="";
					
					while($row1 = $query1->fetch())
					{
						$level++;
						if($parentid==""){
							$parentid = $row1->RoleId;
						}else{
							$parentid .= ", ".$row1->RoleId;
						}
						if($row1->RoleId != 0){
							$res = array();
							$res['id'] = $row1->RoleId;
							$res['name'] = $this->getName($row1->RoleId,'DesignationMaster');
							$res['level'] = $level;
							
							$data[] = $res;
							
						}
					
					}
				
				}
			}
		}catch(Exception $e){
			$status =false;
		   $errorMsg = $e->getMessage();
		}
		if ($count >= 1) {
           $status =true;
		   $successMsg = DESIGNATION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = DESIGNATION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
		
			
	}
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'AssessmentObjective';
		$sIndexColumn = "Id";
		$aColumns = array( 'DesignationId','Period' , 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = "WHERE OrganizationId= $orgid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and  (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="DesignationId"){
				$sWhere .= "(DesignationId in ( select Id from DesignationMaster where Name "." LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'performancedubai/editobjective/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}				
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				else if($aColumns[$i]=="DesignationId")
				{
					$row[] = '<a href="'.URL.'performancedubai/viewobjective/'.Utils::encode5t($aRow->Id).'/1">'.$this->getName($aRow->{$aColumns[$i]},'DesignationMaster').'</a>';
					
				}
				else if($aColumns[$i]=="Period")
				{
					if($aRow->{$aColumns[$i]} == 1){
						$row[] ='Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 2){
						$row[] ='Half-Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 3){
						$row[] ='Quarterly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 4){
						$row[] ='Monthly' ;
					}
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
