<?php

/**
 * VisaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class AssessmentdubaiModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM AssessmentObjective WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = ASSESSMENT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getDetail($empid,$id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $score =0;$aid=0;
		$desig=0;
		//$objective = json_decode($_POST['results'], true); 
			try{
			$sql2 = "SELECT Designation FROM EmployeeMaster WHERE Id = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $empid ));
			while($row1 = $query2->fetch())
			{
				$desig=$row1->Designation;
			}
			
			$sql2 = "SELECT Id FROM AssessmentObjective WHERE DesignationId = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $desig ));
			while($row1 = $query2->fetch())
			{
				$aid=$row1->Id;
			}
			$sql3 = "SELECT DISTINCT Level FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? ORDER BY Level desc";
			$query3 = $this->db->prepare($sql3);
			$query3->execute(array( $id ));
			while($row3 = $query3->fetch())
			{
				$score=0;
				$level=$row3->Level;
				$sql4 = "SELECT Score,DesignationLevel,ObjectiveId FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? and Level=?";
				$query4 = $this->db->prepare($sql4);
				$query4->execute(array( $id,$level ));
				$cchild=$query4->rowCount();
				while($row4 = $query4->fetch())
				{
					$avgscore=0;
					$weightage=self::getWeightage($row4->ObjectiveId);
					if($row4->Score != 0)
						$avgscore=($row4->Score/$weightage) * 100;
						//$avgscore=$weightage * ($row4->Score/100);
					$score=$score+$avgscore;
					$desigl=$row4->DesignationLevel;
				}
				$score=round(($score/$cchild),2); ///////// if assessment have 4 objective then it should be devided by 4 
				
				if($score>0){	
					$sql2 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $aid ));
					if($score > 100)
						$score=100;
					while($row1 = $query2->fetch())
					{
						$min=$row1->MinMarks;
						$max=$row1->MaxMarks;
						//echo "min $min </br> max $max </br> score $score";
						if(($score >= $min) && ($score <= $max))
						{
							$res=array();
							$res['score']=$score;
							$res['comments']=$row1->Result;
							$res['rating']=$row1->Rating;	
							$res['level']=$level;	
							//$res['approvedby']=Utils::getName($desigl,'DesignationMaster','Name',$this->db);
							$empid1 = $this->getAssessmentEmployee($id, $desigl);
							$res['approvedby'] = Utils::getEmployeeName($empid1, $this->db);
							$res['approverid'] = $empid1;
							$data[ ]=$res;
						}
									
					}
				}
						
			}
					
			$status=true;
			$successMsg=$count." record found";
			$count =  $query2->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}	
        			
		return $data;
    }
	
     public function getAllEmployeeAtDesignation($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$desigid = $request[2];
		
		$sts=$_SESSION['ubihrm_user_sts'];
		$sWhere = "";
		if(!$sts){
			$ids = Utils::getReportingIds($mid, $this->db);
			$sWhere = " and Id in ($ids)";
		}
		
        $sql = "SELECT Id, EmployeeCode, FirstName, MiddleName, LastName FROM EmployeeMaster WHERE OrganizationId = ? and Designation = ? $sWhere  ORDER BY FirstName, MiddleName, LastName ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid, $desigid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ".ucwords(strtolower($row->FirstName." ".$row->MiddleName." ".$row->LastName));
				
				$data[] = $res;
			}
        }else{
			$status=false;
			//$successMsg = ASSESSMENT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	 public function getAllEmployeeDesignation($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		
		$sts=$_SESSION['ubihrm_user_sts'];
		$sWhere = "";
		if(!$sts){
			$sql = "SELECT Designation FROM EmployeeMaster WHERE OrganizationId = ? and Id = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $mid ));
			$row = $query->fetch();
			$ids = Utils::getJuniorDesigs($row->Designation, $this->db);
			$sWhere = " and Id in ($ids)";
		}
		
        $sql = "SELECT Id, Name FROM DesignationMaster WHERE OrganizationId = ? $sWhere";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=false;
			//$successMsg = ASSESSMENT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getassessmentDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false; $empid=0; $desigid=0;
		$data = array(); $color = "";  $data=array();	$data1=array(); $data2=array();
		$provision=0;
		$mid=$request[0];
		$orgid=$request[1];
		
		$mdate = date("Y-m-d H:i:s");
		$assessmentid=Utils::decode5t($request[2]);
		//////get assessment details of employee/////////
		$sqle = "SELECT * FROM EmployeeAssessment WHERE Id =?";
		$querye = $this->db->prepare($sqle);
		$querye->execute(array( $assessmentid ));
		while($r1=$querye->fetch()){
			
			$empid=$r1->EmployeeId;
			$achievements=$r1->Achievements;
			$issues=$r1->Issues;
			$potentials=$r1->Potentials;
			$variablepay=$r1->VariablePay;
			$description=$r1->Description;
			$fromdate=$r1->FromDate;
			$todate=$r1->ToDate;
			$period=(int)$r1->AssessmentType;
			$desiglevel = $r1->DesignationLevel;
		}
		$provision=0;
		////////details of employee//////////
		$sql = "SELECT EmployeeCode,FirstName,LastName,Division,Department,Designation FROM EmployeeMaster WHERE Id = ? and OrganizationId = ? ";
        $query = $this->db->prepare($sql);
		$query->execute(array( $empid,$orgid ));
		if($r=$query->fetch()){
			$desigid=$r->Designation;
			
			$empname = $r->EmployeeCode." - ". ucwords(strtolower($r->FirstName." ".$r->LastName));
			$empdiv = Utils::getName($r->Division,"DivisionMaster", "Name", $this->db);
			$empdept = Utils::getName($r->Department,"DepartmentMaster", "Name", $this->db);
			$empdesig = Utils::getName($r->Designation,"DesignationMaster", "Name", $this->db);
			
		}
		///////get objective of employee designation/////////
        $sql = "SELECT DISTINCT ObjectiveId FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = :id";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $assessmentid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			while($rowo = $query->fetch())
			{
				$id = $rowo->ObjectiveId;
				
				//////get quadrant details and results of perticular designation/////////////
				$sql1 = "SELECT * FROM AssessmentObjectiveChild WHERE Id = :id order by QuadrantId";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row = $query1->fetch())
				{
					$qid=$row->QuadrantId;
					$aid=$row->AssessmentObjectiveId;
					$sqlc = "SELECT Color FROM Quadrants WHERE Id = ? ";
					$queryc = $this->db->prepare($sqlc);
					$queryc->execute(array( $qid ));
					if($rowc = $queryc->fetch()){
						$color = $rowc->Color;
					}
					$res=array();
					$oid=$res['id'] = $row->Id;
					$res['quadrantcolor'] = $color;
					$res['quadrant'] = Utils::getName($qid,'Quadrants','Name',$this->db);
					$res['objective'] = $row->Objective;
					$weightage=$res['weightage'] = (int)$row->Weightage;
						
						//$res['rating'] = 0;
					
						$highrating=0;
						
						$sql3 = "SELECT MAX(Rating) as rate FROM AssessmentResult WHERE AssessmentObjectiveId = ? ";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array( $aid ));
						while($row3 = $query3->fetch())
						{
							$highrating=$row3->rate;		
						}
						$res['highrating'] = $highrating;
						
						$sql3 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? ";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array( $aid ));
						$ratearr=array();
						while($row3 = $query3->fetch())
						{
							$rate1=array();
							$rate1['rate']=$row3->Rating;		
							$rate1['min']=$row3->MinMarks;		
							$rate1['max']=$row3->MaxMarks;
							$ratearr[]=$rate1;							
						}
						$res['ratingarr'] = $ratearr;
						
						
						//////for assessment result of employee/////
						
							$results=array();
							$s1=0;
							if($highrating>0)
							$s1=($weightage/$highrating);
							$sql3 = "SELECT * FROM EmployeeAssessmentChild WHERE  EmployeeAssessmentId= ? and ObjectiveId = ? ORDER BY Level desc";
							$query3 = $this->db->prepare($sql3);
							$query3->execute(array($assessmentid ,$oid));
							while($row3=$query3->fetch()){
							if($row3->Score != 0){
								$res1 = array();
								$res1['objectiveid'] = $row3->ObjectiveId;
								$score1=$res1['score'] = (int)$row3->Score;
								//echo "objective score $score1";
								$s=$s1;
								$rate=0;
								$i=0;
								$actualscore=($score1/$weightage)*100;
								$res1['score'] = $actualscore;
								/* for($j=$highrating;$i<=$weightage;$j--){
									if(($score1>=$i) && ($score1<=$s))
									{
										$rate=$j;
										if($i>=$weightage)
										{
											$rate=1;
										}
										break;
									}
									
									$i=$s;
									$s=$i+$s1;
								} */
								$ratearray=$res['ratingarr'];
								for( $j=0;$j<count($ratearray);$j++){
								
									if((($actualscore)>=$ratearray[$j]['min']) && (($actualscore)<=$ratearray[$j]['max']))
									{
										$rate=$ratearray[$j]['rate'];
										//echo "rate  $rate";
										break;
									}
								
								}
								
								/////////if given score is more than 100% then rating should be 1///////
								if($actualscore>100)
									$rate=1;
								$res1['rating'] = $rate;
								$res1['comments'] = $row3->Comments;
								$res1['level'] = $row3->Level;
								$res1['Desiglevel'] = Utils::getName($row3->DesignationLevel,'DesignationMaster','Name',$this->db);			
								
								$results[]=$res1;
								}
							}
							
						
						$res['results']=$results;	
						$data[] = $res;
						
					
				
				
				}
			
			}
			/////designation of logged in employee///////////
				$sql1="SELECT Designation From EmployeeMaster where Id =? and OrganizationId=? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($mid,$orgid));
				if($row1=$query1->fetch())
				{
					$approvardesig=$row1->Designation;
				}
				
					$res2=array();
					
					$res2['employeeid'] = $empid;
					$res2['name'] = $empname;
					$res2['empdivision'] = $empdiv;
					$res2['empdepartment'] = $empdept;
					$res2['empdesignation'] = $empdesig;
					$res2['designationid'] = $desigid;
					$res2['loginempdesig'] = $approvardesig;
										
					if($period == 1){
						$res2['assessmentype']='Yearly' ;
					}
					elseif($period == 2){
						$res2['assessmentype']='Half-Yearly' ;
					}
					elseif($period == 3){
						$res2['assessmentype'] ='Quarterly' ;
					}
					elseif($period == 4){
						$res2['assessmentype'] ='Monthly' ;
						//$variablepay=$this->getEmployeeVariablepay($empid,$fromdate,$todate);
					}
					$res2['typeid']=$period ;
					$res2['achievements']=$achievements ;
					$res2['issues']=$issues ;
					$res2['potentials']=$potentials ;
					$res2['variablepay']=$this->getEmployeeVariablepay($assessmentid, $desigid);;
					$res2['desc']=$description ;
					$res2['desiglevel'] = $desiglevel;
					$res2['fromdate']= Utils::dateformatter($fromdate);
					$res2['todate']= Utils::dateformatter($todate);
					$data1[]=$res2;			
        }
		$filepath="";
		if($empid){
			$code= $this->getCode($empid);
			$doc1="$code";
			$dir="public/uploads/$orgid/assessment";
			$filename=$code.'_'.$fromdate;
			$filename1="";
			if (is_dir($dir)) {
				if ($dh = opendir($dir)) {
					while (($file = readdir($dh)) != false) {
						$filename1=$file;
						$ext = pathinfo($filename, PATHINFO_EXTENSION);
						if($filename1=="$filename.$ext")
						{
							$filepath=URL."public/uploads/$orgid/assessment/$filename1";
						}
					}
					closedir($dh);
				}
			}
		}
		if ($count >= 1) {
           $status =true;
		   $successMsg = ASSESSMENT_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = ASSESSMENT_MODULE_GETDETAIL_FAILED;
        }
		
		$result["data1"] =$data1;
		$result["data"] =$data;
		$result["filepath"] =$filepath;
		//////generate overall result////////
		$result["data2"] =$this->getDetail($empid,$assessmentid);
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
   
   
    /**
     * Setter for a EmployeeAssessment (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $mdate = date("Y-m-d H:i:s"); $level=0;
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		if($request[5] == 4){
			$request[4]=$request[3];	
		}	
		
        $aid=Utils::decode5t($request[8]);	
		try{
		
				
				$sql1="UPDATE EmployeeAssessment set Achievements = ?, Issues=?, Potentials=?, VariablePay=?, Description=?  WHERE Id=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($request[6],$request[7],$request[9],$request[10],$request[11],$aid));
				$count +=  $query1->rowCount();
				$approvardesig=0; $approvarname="";
				$sql1="SELECT Designation,FirstName From EmployeeMaster where Id =? and OrganizationId=? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($mid,$orgid));
				if($row1=$query1->fetch())
					{
						$approvardesig=$row1->Designation;
						$approvarname=$row1->FirstName;
					}
						// INSERTING ASSESSMENT CHILD IF PASSED AS AN JSON
					$objective = json_decode($_POST['assessmentarr'], true); 
					for($i=0; $i<count($objective); $i++)
					{
						if($objective[$i]['id']!="" && $objective[$i]['score'] !="" ){
							$com=isset($objective[$i]['comments'])?	$objective[$i]['comments']:"";				
							$sqlobjective = " Update EmployeeAssessmentChild Set Score=?, Comments=? where  EmployeeAssessmentId=? and ObjectiveId=? and DesignationLevel=?";
							$queryobjective = $this->db->prepare($sqlobjective);
							$queryobjective->execute(array($objective[$i]['score'],$com,$aid,$objective[$i]['id'],$approvardesig));
							$count +=  $queryobjective->rowCount();	
							
						}
					}
				
					$sql1="UPDATE EmployeeAssessmentApproval set AssessmentSts = ?  WHERE EmployeeAssessmentId=? AND DesignationId=?";
				    $query1 = $this->db->prepare($sql1);
				    $query1->execute(array(1,$aid,$approvardesig));
					
					/////////Send mail of agree disagree will go to employee whenever any assessor assess the performance///////////////
					
					$empid=Utils::getName($aid,"EmployeeAssessment", "EmployeeId", $this->db);
					if($empid != $mid){
						$from=Utils::getName($aid,"EmployeeAssessment", "FromDate", $this->db);
						$to=Utils::getName($aid,"EmployeeAssessment", "ToDate", $this->db);
						$period=Utils::dateformatter($from)." - ".Utils::dateformatter($to);
						$empmailencode=Utils::getName($empid,'EmployeeMaster','CompanyEmail',$this->db);
						$empname=Utils::getName($empid,'EmployeeMaster','FirstName',$this->db);
						$empmail=Utils::decode5t($empmailencode);
						if($empmail != ""){
							$title="$approvarname has assessed your performance";
							
							$assessmentresult=$this->getDetail($empid,$aid);
							$rating="";
							for($i=0;$i<count($assessmentresult);$i++)
							{
								if($assessmentresult[$i]['approverid'] == $mid)
								{
									$rating=$assessmentresult[$i]['rating'];
								}	
							}	
							$msg="<html><p>Hi $empname,</p><p>Your Performance Review for ($period) has been completed by $approvarname. You have been assessed with an overall rating of $rating. </p>";
							$msg.="<table width='600px'>";
							for($i=0;$i<count($assessmentresult);$i++)
							{
								if($assessmentresult[$i]['approverid'] == $mid)
								{
									$msg.="<tr><td>Score(%)</td><td>".$assessmentresult[$i]['score']."</td></tr>
									<tr><td>Rating</td><td>".$assessmentresult[$i]['rating']."</td></tr>
									<tr><td>Description</td><td>".$assessmentresult[$i]['comments']."</td></tr>
									";
								}	
							}
							if($request[6]!="")
								$msg.="<tr><td>Other Substantial Achievements</td><td>".$request[6]."</td></tr>";
							if($request[7]!="")
								$msg.="<tr><td>Significant Issues</td><td>".$request[7]."</td></tr>";
							if($request[9]!="")
								$msg.="<tr><td>Comments on Potential</td><td>".$request[9]."</td></tr>";
							$approvelink=URL."approvalbymail/viewapproveassessmentapproval/$empid/$orgid/$aid/2";
							$rejectlink=URL."approvalbymail/viewapproveassessmentapproval/$empid/$orgid/$aid/1";
							
							$msg.="<table>
									<tr><td><br/><br/>
										<a href='$approvelink'   style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: green;
										-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px green; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Agree</a>
										&nbsp;&nbsp;
										&nbsp;&nbsp;
										<a href='$rejectlink'  style='text-decoration:none;padding: 10px 15px; background: #ffffff; color: brown;
										-webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px; border: solid 1px brown; text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.4); -webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); -moz-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2); box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);'>Disagree </a>
										<br/><br/>
										</td>															
										</tr>
									</table>";
							$msg.="</table>";
							$msg.="</html>";
							$title1="$empname agrees with your review";
							$msg1=" $empname agrees with your review of the performance for ($period)";
							Utils::sendMail("monika@ubitechsolutions.com",$empname,$title1,$msg1);
							Utils::sendMail("monika@ubitechsolutions.com",$approvarname,$title,$msg);
							Utils::sendMail("anita@ubitechsolutions.com",$approvarname,$title,$msg);
							
						}
					}
					
					$sql1 = "SELECT AssessmentSts FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ? and AssessmentSts=0";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $aid ));
					if($query1->rowcount()==0){
						$sql1="UPDATE EmployeeAssessment set AssessmentSts = ?  WHERE Id=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array(1,$aid));
						//////////////IF THERE IS VARIABLE PAY FOR ANY EMPLOYEE IN THE END OF ASSESSMENT THEN IT WILL SIT INTO VARIABLE PAY TABLE////
						$sql1="SELECT * from EmployeeAssessment WHERE Id=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($aid));
						while($r1=$query1->fetch())
						{
							$variablepay=$r1->VariablePay;
							if($variablepay>0)
							{
								//////////IF ASSESSMENT DURATION IS MONTHLY THE VARIABLE PAY WILL SAVE ON THAT PERTICULAR MONTH OTHERWISE SAVE IN CURRENT MONTH OF GENERATE SALARY////////
								$empid=$r1->EmployeeId;
								$month="";
								
								$month=self::getSalaryMonth($request);
								
								///////FIND OUT IF THERE IS ALREADY ENTRY OF VARIABLE PAY IN DATATBASE////
								$sqlv="SELECT Id from EmployeeIncentive where EmployeeId=? and ApplyDate=? and OrganizationId=?";
								$queryv=$this->db->prepare($sqlv);
								$queryv->execute(array($empid,$month,$orgid));
								if($queryv->rowCount())
								{
									$rv=$queryv->fetch();
									$incid=$rv->Id;
									$sqlv="UPDATE EmployeeIncentive set IncentiveAmount=? , Description=?, LastModifiedDate=? where Id=?";
									$queryv=$this->db->prepare($sqlv);
									$queryv->execute(array($variablepay,$request[11],$mdate, $incid ));
								}else{
									$sqlv="INSERT into EmployeeIncentive ( EmployeeId, Description, IncentiveAmount, ApplyDate, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId) values (?, ?, ?, ?, ?, ?, ? ,? ,? ,?)";
									$queryv=$this->db->prepare($sqlv);
									$queryv->execute(array($empid,$request[11],$variablepay,$month,$orgid,$mdate, $mid, $mdate, $mid, $mid ));
								}
							}
						}
					}
					
				
			}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}		
			if ($count >= 1) {
			   $status =true;
			   $successMsg = ASSESSMENT_MODULE_CREATION_SUCCESS;
			  
			} else {
			   $status =false;
			   $errorMsg = ASSESSMENT_MODULE_CREATION_FAILED;
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			
				$sql = "DELETE FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = :id ";
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
				$sql = "DELETE FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = :id ";
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
				$sql = "DELETE FROM EmployeeAssessment WHERE Id = :id ";
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
			
			
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = ASSESSMENT_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = ASSESSMENT_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	public function getDesignation($id, $tablename)
	{
		$name ="";
		$sql = "SELECT Designation FROM $tablename WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Designation;
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	public function getEmployeeAssessmentPending($assessid)
	{
		$level = 0;
		$sql1 = "SELECT EmployeeId, AssessmentSts FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ?";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $assessid  ));
				while( $row = $query1->fetch())
				{
					$level++;
					if($row->AssessmentSts==0)
					break;
				}
			}catch(Exception $e) {
			}
		return $level;
	}
	public function getEmployeeAssessy($assessid, $empid)
	{
		$flg = false;

		$employee=0;
		$sql1 = "SELECT EmployeeId, AssessmentSts FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ?";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $assessid  ));
				while( $row = $query1->fetch())
				{
					if($row->AssessmentSts==0){
						$employee=$row->EmployeeId;
						break;
					}
				}
				if($employee ==  $empid){
					$flg = true;
				}
			}catch(Exception $e) {
			}
		return $flg;
	}
	public function getEmployeeAssessmentRunning($assessid)
	{
		$flg =false;
		$sql1 = "SELECT EmployeeId FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ?  and AssessmentSts=1";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $assessid  ));
				if($query1->rowCount()>0)
				{
					$flg =true;
				}
			}catch(Exception $e) {
				
				}
		return $flg;
	}
	public function getAssessmentEmployee($assessid, $desigid)
	{
		$name ="0";
		$sql = "SELECT EmployeeId FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ? and DesignationId=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $assessid, $desigid  ));
			while($row = $query->fetch())
			{
				$name = $row->EmployeeId;
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	
	public function getassessmentId()
	{
		$empid=$_SESSION['ubihrm_user_id'];	
		$name ="0";
		$sql = "SELECT Id FROM EmployeeAssessment WHERE EmployeeId=?  Order by Id desc limit 1";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $empid));
			while($row = $query->fetch())
			{
				$name = $row->Id;
			}
		}catch(Exception $e) {
			
			}
		$name = Utils::encode5t($name);
		return $name;
	}
	
	public function getAssessmentTopLevelScore($assessid)
	{
		$totalscore = 0;
		$sql = "SELECT sum(Score) as totalscore FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? and Level in (select Max(Level) From EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? )";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $assessid, $assessid  ));
			while($row = $query->fetch())
			{
				$totalscore = $row->totalscore;
			}
		}catch(Exception $e) {
			
			}
		
		return $totalscore;
	}
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'EmployeeAssessment';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId','EmployeeId','AssessmentType' ,'FromDate','ToDate',  'DesignationLevel',  'AssessmentSts','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere ="";
		$adsts=$_SESSION['ubihrm_user_sts'];
		//$desigid=$this->getDesignation($userid,'EmployeeMaster');
		//$sWhere = " Where Id in (select EmployeeAssessmentId from (select * from EmployeeAssessmentApproval where  AssessmentSts = 0 Group by EmployeeAssessmentId) s where EmployeeId=$userid) AND OrganizationId= $orgid AND AssessmentSts = 0 AND EmployeeId<>$userid";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($adsts==1 || $hrsts==1){
			$sWhere = " Where OrganizationId= $orgid AND EmployeeId<>$userid";
		}else{
			$ids = Utils::getReportingIds($userid, $this->db);
			$sWhere = " Where OrganizationId= $orgid AND EmployeeId<>$userid and EmployeeId in ($ids) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if( $i==0){
					$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				
				
				else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				if($aColumns[$i]=="EmployeeId" && $i==1){
					$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where  Designation LIKE '%".($_GET['sSearch_'.$i])."%'))  ";
				}else{
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$aid=Utils::encode5t($aRow->Id);
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					
						$edit =""; $delete=""; $edit1="";
						if($aRow->AssessmentSts==0){
							if($editper){
								$sts = $this->getEmployeeAssessy($aRow->Id, $userid);
								if($sts){
									$edit = '<a rel="tooltip" title="Assessment" href="'.URL.'performancedubai/editassessment/'.$aid.'" ><i class="fa fa-font"></i></a>';
								}
							}else{
								$edit = '<a href="#" rel="tooltip" title="No permission to assess"><i class="fa fa-font"></i></a>';
							}
						
						}
						if($adsts==1 || $hrsts==1){
							$edit1 = '<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm2" href="#" ><i class="fa fa-trash"></i></a>';
						}	
						
						$row[] =$edit.' &nbsp;&nbsp; '.$edit1 ;
					
					
				}
				else if($aColumns[$i]=="AssessmentType")
				{
					
					if($aRow->{$aColumns[$i]} == 1){
						$row[] ='Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 2){
						$row[] ='Half-Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 3){
						$row[] ='Quarterly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 4){
						$row[] ='Monthly' ;
					}
					else{
						$row[] ="" ;
					}
				}
				else if($aColumns[$i]=="AssessmentSts")
				{
					$img = "<img src='".URL."public/dist/img/Red-icon.png' rel='tooltip' title='Not Started'/>";
					if($aRow->{$aColumns[$i]}==1){
						$img="<img src='".URL."public/dist/img/Green-icon.png' rel='tooltip' title='Assessment completed'/>";
					}else{
						$sts = $this->getEmployeeAssessmentRunning($aRow->Id);
						if($sts){
							$img = "<img src='".URL."public/dist/img/Yellow-icon.png' rel='tooltip' title='Assessment in progress'/>";
						}
					}
					$row[]= $img;
				}
				else if($aColumns[$i]=="EmployeeId" && $i==0)
				{
					$row[]='<a rel="tooltip" title="View" href="'.URL.'performancedubai/viewassessment/'.Utils::encode5t($aRow->Id).'/1" >'.Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster", "FirstName", $this->db).' '.Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster", "LastName", $this->db).'</a>' ;
				}
				else if($aColumns[$i]=="EmployeeId" && $i==1)
				{
					$desig=Utils::getName($aRow->EmployeeId,'EmployeeMaster','Designation',$this->db);
					$row[]=Utils::getName($desig,'DesignationMaster','Name',$this->db);
				}
				else if($aColumns[$i]=="DesignationLevel")
				{
					$row[]='Level '.$this->getEmployeeAssessmentPending($aRow->Id) ;
				}
				else if($aColumns[$i]=="FromDate" || $aColumns[$i]=="ToDate")
				{
					if($aRow->{$aColumns[$i]} == '0000-00-00'){
						$row[]="";
					}else{
						$row[]=Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getAssessmentresultTable($editper, $deleteper)
	{
		$sTable = 'EmployeeAssessment';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId', 'AssessmentType' , 'FromDate', 'ToDate', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		if($sts==1){
			$sWhere = " Where OrganizationId=$orgid and (Id in (select EmployeeAssessmentId from EmployeeAssessmentApproval where AssessmentSts = 1)) and AssessmentSts = 1";
		}
		else{
			$sWhere = " Where (Id in (select EmployeeAssessmentId from EmployeeAssessmentApproval where EmployeeId = $userid and AssessmentSts = 1) and AssessmentSts = 1 AND OrganizationId= $orgid and  EmployeeId<>$userid) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and  (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					$row[] = $this->getAssessmentTopLevelScore($aRow->Id)."%";
				}
				else if($aColumns[$i]=="AssessmentType")
				{
					
					if($aRow->{$aColumns[$i]} == 1){
						$row[] ='Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 2){
						$row[] ='Half-Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 3){
						$row[] ='Quarterly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 4){
						$row[] ='Monthly' ;
					}
					else{
						$row[] ="" ;
					}
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					$row[]='<a rel="tooltip" title="View" href="'.URL.'performancedubai/viewassessmentresult/'.Utils::encode5t($aRow->Id).'/1" >'.Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster", "FirstName", $this->db).' '.Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster", "LastName", $this->db).'</a>' ;
				}
				
				else if($aColumns[$i]=="FromDate" || $aColumns[$i]=="ToDate")
				{
					if($aRow->{$aColumns[$i]} == '0000-00-00'){
						$row[]="";
					}else{
						$row[]=Utils::dateformatter($aRow->{$aColumns[$i]});
					}
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getComparisionData($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); 
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid   ="0";
		$temparr = $request[2];
		$fromdate= Utils::getDateformat($request[3]);
		$todate  = Utils::getDateformat($request[4]);
		if(is_array($temparr)){
			$empid   = implode(',',$temparr);
		}
		try{
			$name ="0";
			$sql = "SELECT sum(Score) as totalscore, EmployeeId, AssessmentType, FromDate, ToDate FROM  EmployeeAssessment E, EmployeeAssessmentChild EC where E.Id=EC.EmployeeAssessmentId and OrganizationId=? and EmployeeId=? and FromDate>=? and ToDate<=? and AssessmentSts=1  and Level=3 group by EmployeeId";
			$query = $this->db->prepare($sql);
			$query->execute(array($orgid, $empid, $fromdate, $todate));
			if($query->rowCount()>0){
			 $status=true;
				while($row = $query->fetch())
				{
					$res = array();
					$res['total'] = $row->totalscore;
					//$str =((AssessmentType==4)?"Monthly":((AssessmentType==3)?"Quaterly":((AssessmentType==2)?"Half Yearly":"Yearly")));
					$date = Utils::dateformatter($row->FromDate)." - ".Utils::dateformatter($row->ToDate);
					$res['name'] = $date;//Utils::getEmployeeName($row->EmployeeId, $this->db);
					$data[]= $res;
				}
			}else{
				$status = false;
				$errorMsg = "No record found";
			}
		}catch(Exception $e) {
			$errorMsg = $e->getMessage(); 
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
	}
	public function getCode($id)
	{
		$empcode ="";
		$sql = "SELECT EmployeeCode FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$empcode =  $row->EmployeeCode;;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	//////////employee incentive////////
	////////////////////////getting weightage of objective///
	
	public function getWeightage($id)
	{
		$empcode =0;
		$sql = "SELECT Weightage FROM AssessmentObjectiveChild WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$empcode =  $row->Weightage;;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	public function getEmployeeVariablepay($assessmentid,$desigid)
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$amount =0;
		$sql = "SELECT * FROM AssessmentObjective WHERE DesignationId=? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($desigid));
			while($row = $query->fetch())
			{
				$objid =	$row->Id;
				$score=0; $approvedid=0;
				
				///////////GETTING LAST GIVEN ASSESSMENT FROM THE ASSESSMENTS/////////////////
				$sql1 = "SELECT * FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId=? and AssessmentSts=1";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($assessmentid));
				while($row1 = $query1->fetch())
				{
					$approvedid=$row1->DesignationId;
				}	
				
				$sql1 = "SELECT * FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId=? and Score<>0 and DesignationLevel=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($assessmentid, $approvedid));
				while($row1 = $query1->fetch())
				{
					$score=$score+$row1->Score;
				}	
				
				$sql2 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId =? and ? BETWEEN MinMarks and MaxMarks ";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array($objid, $score ));
				while($row2 = $query2->fetch())
				{
					$amount=$row2->VariablePayAmt;
				}	
					
				
			}
		}catch(Exception $e) {
			
		}
		return $amount;
	}
	//////////////////////////////uploading document of employee assessment/////////////////////////////
	public function uploadDocument($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid = $request[2];
		$assdate = Utils::getDateformat($_POST['assess_date']);
		$empcode=$this->getCode($empid);
		$new_name="";
		$dir="public/uploads/$orgid/assessment";
		$filename=$empcode.'_'.$assdate;
		if (! is_dir($dir)) {
			mkdir($dir);
			chmod($dir,0755);
			
		}
		
		//$dir="public/uploads/$orgid";
		$filename1="";
		
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename1=$file;
								$ext1 = end((explode(".", $filename1)));
								if($filename1=="$filename.$ext1")
								{
									unlink("public/uploads/$orgid/assessment/$filename1");
								}
							}
						closedir($dh);
						}
					}
					$new_name="$filename.$ext";
					$file_size =$_FILES['file0']['size'];
					$file_tmp =$_FILES['file0']['tmp_name'];
					$file_type=$_FILES['file0']['type'];   
					$location="public/uploads/$orgid/assessment/";
					if($file_size > 2097152){
						$errors[]='File size must be less than 2 MB';
					}	
					
					if(empty($errors)==true){
					
						move_uploaded_file($file_tmp, $location.$new_name);
						
					}
					else{
						print_r($errors);
					}
							
			}
			
			
			   $status =true;
			   $successMsg = EMPLOYEE_MODULE_PROFILEIMAGE;
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
	
	}
	
	public function getSalaryMonth($request)
	{
		$result = array();
		$month = "";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT DATE_ADD(salarymonth, INTERVAL 1 Month) as SalaryMonth FROM SalaryGenerateMonth WHERE OrganizationId = ? order by Id desc limit 1";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['salarymonth'] = Utils::dateformatter($row->SalaryMonth);	
$res['salarymonth1'] = $row->SalaryMonth;	
				$month = $row->SalaryMonth;					
				$data[] = $res;
			}
        }else{
			$sql = "SELECT StartDate FROM FiscalMaster WHERE OrganizationId = ? and FiscalSts=1 order by Id desc limit 1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid ));
			while($row = $query->fetch())
			{
				$res = array();
				$res['salarymonth'] = Utils::dateformatter($row->StartDate);	
				$res['salarymonth1'] = $row->StartDate;	
				$month = $row->StartDate;						
				$data[] = $res;
			}
			$status=true;
			$errorMsg="No Record found";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		//return $result;
		return $month;
	}
}
