<?php

/**
 * VisaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class AssessmentModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM AssessmentObjective WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = ASSESSMENT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getDetail($empid,$id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $score =0;$aid=0;
		
		//$objective = json_decode($_POST['results'], true); 
			try{
			$sql2 = "SELECT Designation FROM EmployeeMaster WHERE Id = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $empid ));
			while($row1 = $query2->fetch())
			{
				$desig=$row1->Designation;
			}
			
			$sql2 = "SELECT Id FROM AssessmentObjective WHERE DesignationId = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $desig ));
			while($row1 = $query2->fetch())
			{
				$aid=$row1->Id;
			}
			$sql3 = "SELECT DISTINCT Level FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? ORDER BY Level";
			$query3 = $this->db->prepare($sql3);
			$query3->execute(array( $id ));
			
			while($row3 = $query3->fetch())
			{
				$score=0;
				$level=$row3->Level;
				$sql4 = "SELECT Score,DesignationLevel,ObjectiveId FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? and Level=?";
				$query4 = $this->db->prepare($sql4);
				$query4->execute(array( $id,$level ));
				while($row4 = $query4->fetch())
				{
					$avgscore=0;
					$weightage=self::getWeightage($row4->ObjectiveId);
					if($row4->Score != 0)
						$avgscore=$weightage * ($row4->Score/100);
					$score=$score+$avgscore;
					$score=round($score);
					$desigl=$row4->DesignationLevel;
				}
				if($score>0){	
					$sql2 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $aid ));
					if($score > 100)
						$score=100;
					while($row1 = $query2->fetch())
					{
						$min=$row1->MinMarks;
						$max=$row1->MaxMarks;
						//echo "min $min </br> max $max </br> score $score";
						if(($score >= $min) && ($score <= $max))
						{
							$res=array();
							$res['score']=$score;
							$res['comments']=$row1->Result;
							$res['rating']=$row1->Rating;	
							$res['level']=$level;	
							//$res['approvedby']=Utils::getName($desigl,'DesignationMaster','Name',$this->db);
							$empid1 = $this->getAssessmentEmployee($id, $desigl);
							$res['approvedby'] = Utils::getEmployeeName($empid1, $this->db);
							$data[ ]=$res;
						}
									
					}
				}
						
			}
					
			$status=true;
			$successMsg=$count." record found";
			$count =  $query2->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}	
        			
		return $data;
    }
	
     public function getAllEmployeeAtDesignation($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$desigid = $request[2];
		
		$sts=$_SESSION['ubihrm_user_sts'];
		$sWhere = "";
		if(!$sts){
			$ids = Utils::getReportingIds($mid, $this->db);
			$sWhere = " and Id in ($ids)";
		}
		
        $sql = "SELECT Id, EmployeeCode, FirstName, MiddleName, LastName FROM EmployeeMaster WHERE OrganizationId = ? and Designation = ? $sWhere  ORDER BY FirstName, MiddleName, LastName ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid, $desigid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ".ucwords(strtolower($row->FirstName." ".$row->MiddleName." ".$row->LastName));
				
				$data[] = $res;
			}
        }else{
			$status=false;
			//$successMsg = ASSESSMENT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	 public function getAllEmployeeDesignation($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		
		$sts=$_SESSION['ubihrm_user_sts'];
		$sWhere = "";
		if(!$sts){
			$sql = "SELECT Designation FROM EmployeeMaster WHERE OrganizationId = ? and Id = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid, $mid ));
			$row = $query->fetch();
			$ids = Utils::getJuniorDesigs($row->Designation, $this->db);
			$sWhere = " and Id in ($ids)";
		}
		
        $sql = "SELECT Id, Name FROM DesignationMaster WHERE OrganizationId = ? $sWhere";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->Name;
				
				$data[] = $res;
			}
        }else{
			$status=false;
			//$successMsg = ASSESSMENT_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getassessmentDetail($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false; $empid=0; $desigid=0;
		$data = array(); $kpalist = array();  $kpilist = array(); $color = "";  $data=array();	$data1=array(); $data2=array();
		$provision=0;
		$mid=$request[0];
		$orgid=$request[1];
		$totalmarks=0;
		$totalmarksobtained=0;
		$maxlevel=0;
		$mdate = date("Y-m-d H:i:s");
		$assessmentid=Utils::decode5t($request[2]);
		//////get assessment details of employee/////////
		$sqle = "SELECT * FROM EmployeeAssessment WHERE Id =?";
		$querye = $this->db->prepare($sqle);
		$querye->execute(array( $assessmentid ));
		while($r1=$querye->fetch()){
			$empid=$r1->EmployeeId;
			$TotalMarks=$r1->TotalMarks;
			$ObtainedMarks=$r1->ObtainedMarks;
			$Rating=$r1->Rating;
			$Result=$r1->Result;
			$description=$r1->Description;
			$improvements=$r1->improvements;
			$fromdate=$r1->FromDate;
			$todate=$r1->ToDate;
			$period=(int)$r1->AssessmentType;
			$desiglevel = $r1->DesignationLevel;
		}
		$provision=0;
		$totweightage=0;
		////////details of employee//////////
		$sql = "SELECT EmployeeCode,FirstName,LastName,Division,Department,Designation FROM EmployeeMaster WHERE Id = ? and OrganizationId = ? ";
        $query = $this->db->prepare($sql);
		$query->execute(array( $empid,$orgid ));
		if($r=$query->fetch()){
			$desigid=$r->Designation;
			$empname = $r->EmployeeCode." - ". ucwords(strtolower($r->FirstName." ".$r->LastName));
			$empdiv = Utils::getName($r->Division,"DivisionMaster", "Name", $this->db);
			$empdept = Utils::getName($r->Department,"DepartmentMaster", "Name", $this->db);
			$empdesig = Utils::getName($r->Designation,"DesignationMaster", "Name", $this->db);
		}
		
		//////get higher level of approval/////
		$sqll = "SELECT max(Level) as maxlevel FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = :id and AssessmentSts=1";
        $queryl = $this->db->prepare($sqll);
		try{
			$queryl->execute(array(':id' => $assessmentid ));
			$countl =  $queryl->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$rowl = $queryl->fetch();
		$mlevel=$maxlevel=$rowl->maxlevel;
		if($maxlevel=="")
			$maxlevel=1; //if there is no assessment happen	\
		
		$totweightage=$this->getEmpAssessmentWeightage($assessmentid,$maxlevel);
		///////get objective of employee designation/////////
        $sql = "SELECT ObjectiveId,Score FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = :id and Level= :level";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $assessmentid ,':level' => $maxlevel));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($rowo = $query->fetch())
			{
				$id = $rowo->ObjectiveId;
				//////get quadrant details and results of perticular designation/////////////
				$sql1 = "SELECT * FROM AssessmentObjectiveChild WHERE Id = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row = $query1->fetch())
				{
					$lscorearr=array();
					//$toplevel=$maxlevel;
					$aid=$row->AssessmentObjectiveId;
					$res=array();
					$oid=$res['id'] = $row->Id;
					$res['score'] = (int)$rowo->Score;
					//$res['level'] = $maxlevel;
					
					for($i=1;$i<$mlevel;$i++){
						$scorearr1=array();
						$scorearr1['score'] = $this->getAssessmentMarksByLevel($assessmentid,$i,$id);
						$scorearr1['val'] = 1;
						$lscorearr[]=$scorearr1;
						//$toplevel--;
					}
					if($mlevel>0){
					$scorearr1=array();
					$scorearr1['score'] = (int)$rowo->Score;
					$scorearr1['val'] = 0;
					$lscorearr[]=$scorearr1; 
					}
					$res['score1']=$lscorearr;
					$res['objective'] = $row->Objective;
					$res['quadrantid'] = $row->QuadrantId;
					$res['quadrantname'] = Utils::getName($res['quadrantid'],'Quadrants','Name',$this->db);
					$res['quadrantcolor'] = Utils::getName($res['quadrantid'],'Quadrants','Color',$this->db);
					$weightage=$res['weightage'] = (int)$row->Weightage;
					$res['weightageper'] = round(((int)$row->Weightage/$totweightage)*100).'%';
					
					$totalmarks=$totalmarks+$row->Weightage;
					$totalmarksobtained=$totalmarksobtained+$res['score'];
					$highrating=0;
						
						$sql3 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? ";
						$query3 =$this->db->prepare($sql3);
						$query3->execute(array($aid));
						$ratearr=array();
						while($row3 = $query3->fetch())
						{
							$rate1=array();
							$rate1['rate']=$row3->Rating;		
							$rate1['min']=$row3->MinMarks;		
							$rate1['max']=$row3->MaxMarks;
							$rate1['result']=$row3->Result;
							$ratearr[]=$rate1;
						}
						$res['ratingarr'] = $ratearr;
						//$res['kpalist'] = $kpalist;
						//////for assessment result of employee/////
							$results=array();
							/* $s1=0;
							if($highrating>0)
							$s1=($weightage/$highrating); */
							$sql3 = "SELECT * FROM EmployeeAssessmentChild WHERE  EmployeeAssessmentId= ? and ObjectiveId = ? ORDER BY Level desc";
							$query3 = $this->db->prepare($sql3);
							$query3->execute(array($assessmentid ,$oid));
							while($row3=$query3->fetch()){
							if($row3->Score != 0){
								$res1 = array();
								$res1['objectiveid'] = $row3->ObjectiveId;
								// $score1=$res1['score'] = (int)$row3->Score;
								/////////if given score is more than 100% then rating should be 1///////
								$res1['level'] = $row3->Level;
								$res1['Desiglevel'] = Utils::getName($row3->DesignationLevel,'DesignationMaster','Name',$this->db);	
								$results[]=$res1;
								}
							}
						$res['results']=$results;	
						$data[] = $res;
				}
			}
			/////designation of logged in employee///////////
				$sql1="SELECT Designation From EmployeeMaster where Id =? and OrganizationId=? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($mid,$orgid));
				if($row1=$query1->fetch())
				{
					$approvardesig=$row1->Designation;
				}
					$res2=array();
					$res2['employeeid'] = $empid;
					$res2['name'] = $empname;
					$res2['empdivision'] = $empdiv;
					$res1['Rating'] = $Rating;
					$res2['TotalMarks'] = $totalmarks;
					$res2['ObtainedMarks'] = $totalmarksobtained;
					$res2['Result'] = $Result;
					$res2['empdepartment'] = $empdept;
					$res2['empdesignation'] = $empdesig;
					$res2['designationid'] = $desigid;
					$res2['loginempdesig'] = $approvardesig;
					if($period == 1){
						$res2['assessmentype']='Yearly' ;
					}
					elseif($period == 2){
						$res2['assessmentype']='Half-Yearly' ;
					}
					elseif($period == 3){
						$res2['assessmentype'] ='Quarterly' ;
					}
					elseif($period == 4){
						$res2['assessmentype'] ='Monthly' ;
					}
					$res2['typeid']=$period ;
					$res2['desc']=$description ;
					$res2['improvements']=$improvements ;
					$res2['desiglevel'] = $desiglevel;
					$res2['fromdate']= Utils::dateformatter($fromdate);
					$res2['todate']= Utils::dateformatter($todate);
					$data1[]=$res2;	
					$scorearr=array();
					$scorearr=self::getRatingArray($empid,$assessmentid);
					$data2[]=$scorearr;	
					$quadscorearr=array();
					$quadscorearr=self::getKPARatingArray($empid,$assessmentid);
					$data2[]=$quadscorearr;					
        }
		if ($count >= 1) {	
           $status =true;
		   $successMsg = ASSESSMENT_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = ASSESSMENT_MODULE_GETDETAIL_FAILED;
        }
		
		$result["data1"] =$data1;
		$result["data"] =$data;
		$result["data2"] =$data2;
		$result["levelarr"] =$mlevel;
		//$result["filepath"] =$filepath;
		//$result["totalmarks"] =$totalmarks;
		//////generate overall result////////
		//$result["data2"] =$this->getDetail($empid,$assessmentid);
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	
	public function getassessmentDetail1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false; $empid=0; $desigid=0;
		$data = array(); $color = "";  $data=array();	$data1=array(); $data2=array();
		$provision=0;
		$mid=$request[0];
		$orgid=$request[1];
		$totalmarks=0;
		$totalmarksobtained=0;
		$mdate = date("Y-m-d H:i:s");
		$assessmentid=Utils::decode5t($request[2]);
		//////get assessment details of employee/////////
		$sqle = "SELECT * FROM EmployeeAssessment WHERE Id =?";
		$querye = $this->db->prepare($sqle);
		$querye->execute(array( $assessmentid ));
		while($r1=$querye->fetch()){
			
			$empid=$r1->EmployeeId;
			$achievements=$r1->Achievements;
			$issues=$r1->Issues;
			$potentials=$r1->Potentials;
			$variablepay=$r1->VariablePay;
			$description=$r1->Description;
			$fromdate=$r1->FromDate;
			$todate=$r1->ToDate;
			$period=(int)$r1->AssessmentType;
			$desiglevel = $r1->DesignationLevel;
		}
		$provision=0;
		////////details of employee//////////
		$sql = "SELECT EmployeeCode,FirstName,LastName,Division,Department,Designation FROM EmployeeMaster WHERE Id = ? and OrganizationId = ? ";
        $query = $this->db->prepare($sql);
		$query->execute(array( $empid,$orgid ));
		if($r=$query->fetch()){
			$desigid=$r->Designation;
			
			$empname = $r->EmployeeCode." - ". ucwords(strtolower($r->FirstName." ".$r->LastName));
			$empdiv = Utils::getName($r->Division,"DivisionMaster", "Name", $this->db);
			$empdept = Utils::getName($r->Department,"DepartmentMaster", "Name", $this->db);
			$empdesig = Utils::getName($r->Designation,"DesignationMaster", "Name", $this->db);
			
		}
		///////get objective of employee designation/////////
        $sql = "SELECT DISTINCT ObjectiveId,Score FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = :id";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $assessmentid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($rowo = $query->fetch())
			{
				$id = $rowo->ObjectiveId;
				
				//////get quadrant details and results of perticular designation/////////////
				$sql1 = "SELECT * FROM AssessmentObjectiveChild WHERE Id = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row = $query1->fetch())
				{
					$qid=$row->QuadrantId;
					$aid=$row->AssessmentObjectiveId;
					/* $sqlc = "SELECT Color FROM Quadrants WHERE Id = ? ";
					$queryc = $this->db->prepare($sqlc);
					$queryc->execute(array( $qid ));
					if($rowc = $queryc->fetch()){
						$color = $rowc->Color;
					} */
					$res=array();
					 $oid=$res['id'] = $row->Id;
					$res['quadrantcolor'] = $color;
					$res['quadrant'] = Utils::getName($qid,'Quadrants','Name',$this->db); 
					$res['score'] = $rowo->Score;
					$res['objective'] = $row->Objective;
					$weightage=$res['weightage'] = (int)$row->Weightage;
						
						//$res['rating'] = 0;
					$totalmarks=$totalmarks+$row->Weightage;
						$highrating=0;
						
						$sql3 = "SELECT MAX(Rating) as rate FROM AssessmentResult WHERE AssessmentObjectiveId = ? ";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array( $aid ));
						while($row3 = $query3->fetch())
						{
							$highrating=$row3->rate;		
						}
						$res['highrating'] = $highrating;
						
						$sql3 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? ";
						$query3 = $this->db->prepare($sql3);
						$query3->execute(array( $aid ));
						$ratearr=array();
						while($row3 = $query3->fetch())
						{
							$rate1=array();
							$rate1['rate']=$row3->Rating;		
							$rate1['min']=$row3->MinMarks;		
							$rate1['max']=$row3->MaxMarks;
							$rate1['result']=$row3->Result;
							$ratearr[]=$rate1;							
						}
						$res['ratingarr'] = $ratearr;
						
						
						//////for assessment result of employee/////
						
							$results=array();
							$s1=0;
							if($highrating>0)
							$s1=($weightage/$highrating);
							$sql3 = "SELECT * FROM EmployeeAssessmentChild WHERE  EmployeeAssessmentId= ? and ObjectiveId = ? ORDER BY Level desc";
							$query3 = $this->db->prepare($sql3);
							$query3->execute(array($assessmentid ,$oid));
							while($row3=$query3->fetch()){
							if($row3->Score != 0){
								$res1 = array();
								$res1['objectiveid'] = $row3->ObjectiveId;
								$score1=$res1['score'] = (int)$row3->Score;
								$s=$s1;
								$rate=0;
								$i=0;
								
								/* for($j=$highrating;$i<=$weightage;$j--){
									if(($score1>=$i) && ($score1<=$s))
									{
										$rate=$j;
										if($i>=$weightage)
										{
											$rate=1;
										}
										break;
									}
									
									$i=$s;
									$s=$i+$s1;
								} */
								$ratearray=$res['ratingarr'];
								for( $j=0;$j<count($ratearray);$j++){
								
									if((($score1)>=$ratearray[$j]['min']) && (($score1)<=$ratearray[$j]['max']))
									{
										$rate=$ratearray[$j]['rate'];
										
										break;
									}
								
								}
								/////////if given score is more than 100% then rating should be 1///////
								if($score1>100)
									$rate=1;
								$res1['rating'] = $rate;
								$res1['comments'] = $row3->Comments;
								$res1['level'] = $row3->Level;
								$res1['Desiglevel'] = Utils::getName($row3->DesignationLevel,'DesignationMaster','Name',$this->db);			
								
								$results[]=$res1;
								}
							}
							
						
						$res['results']=$results;	
						$data[] = $res;
						
					
				
				
				}
			
			}
			/////designation of logged in employee///////////
				$sql1="SELECT Designation From EmployeeMaster where Id =? and OrganizationId=? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($mid,$orgid));
				if($row1=$query1->fetch())
				{
					$approvardesig=$row1->Designation;
				}
				
					$res2=array();
					
					$res2['employeeid'] = $empid;
					$res2['name'] = $empname;
					$res2['empdivision'] = $empdiv;
					$res2['empdepartment'] = $empdept;
					$res2['empdesignation'] = $empdesig;
					$res2['designationid'] = $desigid;
					$res2['loginempdesig'] = $approvardesig;
										
					if($period == 1){
						$res2['assessmentype']='Yearly' ;
					}
					elseif($period == 2){
						$res2['assessmentype']='Half-Yearly' ;
					}
					elseif($period == 3){
						$res2['assessmentype'] ='Quarterly' ;
					}
					elseif($period == 4){
						$res2['assessmentype'] ='Monthly' ;
						//$variablepay=$this->getEmployeeVariablepay($empid,$fromdate,$todate);
					}
					$res2['typeid']=$period ;
					$res2['achievements']=$achievements ;
					$res2['issues']=$issues ;
					$res2['potentials']=$potentials ;
					$res2['variablepay']=$variablepay ;
					$res2['desc']=$description ;
					$res2['desiglevel'] = $desiglevel;
					$res2['fromdate']= Utils::dateformatter($fromdate);
					$res2['todate']= Utils::dateformatter($todate);
					$data1[]=$res2;			
        }
		$filepath="";
		if($empid){
			$code= $this->getCode($empid);
			$doc1="$code";
			$dir="public/uploads/$orgid/assessment";
			$filename=$code.'_'.$fromdate;
			$filename1="";
			if (is_dir($dir)) {
				if ($dh = opendir($dir)) {
					while (($file = readdir($dh)) != false) {
						$filename1=$file;
						$ext = end((explode(".", $filename1)));
						if($filename1=="$filename.$ext")
						{
							$filepath=URL."public/uploads/$orgid/assessment/$filename1";
						}
					}
					closedir($dh);
				}
			}
		}
		if ($count >= 1) {
           $status =true;
		   $successMsg = ASSESSMENT_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = ASSESSMENT_MODULE_GETDETAIL_FAILED;
        }
		
		$result["data1"] =$data1;
		$result["data"] =$data;
		$result["filepath"] =$filepath;
		$result["totalmarks"] =$totalmarks;
		//////generate overall result////////
		$result["data2"] =$this->getDetail($empid,$assessmentid);
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
   
   
    /**
     * Setter for a EmployeeAssessment (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
	 
	 public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $mdate = date("Y-m-d H:i:s"); $level=0;
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		if($request[5] == 4){
			$request[4]=$request[3];	
		}	
		
        $aid=Utils::decode5t($request[8]);	
		try{
				$sql1="UPDATE EmployeeAssessment set TotalMarks=?, ObtainedMarks=?, Rating=?, Result=?, Description=?, improvements=?  WHERE Id=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($request[6],$request[7],$request[9],$request[10],$request[11],$request[12],$aid));
				$count +=  $query1->rowCount();
				
				$sql1="SELECT Designation From EmployeeMaster where Id =? and OrganizationId=? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($mid,$orgid));
				if($row1=$query1->fetch())
					{
						$approvardesig=$row1->Designation;
					}
					// INSERTING ASSESSMENT CHILD IF PASSED AS AN JSON
					$objective = json_decode($_POST['assessmentarr'], true);
							
					for($i=0; $i<count($objective); $i++)
					{
						if($objective[$i]['id']!="" && $objective[$i]['score'] !="" ){
										
								$sqlobjective = " Update EmployeeAssessmentChild Set Score=? where  EmployeeAssessmentId=? and ObjectiveId=? and DesignationLevel=?";
								$queryobjective = $this->db->prepare($sqlobjective);
								$queryobjective->execute(array($objective[$i]['score'],$aid,$objective[$i]['id'],$approvardesig));
								$count +=  $queryobjective->rowCount();	
							
						}
					}
				
					$sql1="UPDATE EmployeeAssessmentApproval set AssessmentSts = ?  WHERE EmployeeAssessmentId=? AND DesignationId=?";
				    $query1 = $this->db->prepare($sql1);
				    $query1->execute(array(1,$aid,$approvardesig));
					
					
					$sql1 = "SELECT AssessmentSts FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ? and AssessmentSts=0";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $aid ));
					if($query1->rowcount()==0){
						$sql1="UPDATE EmployeeAssessment set AssessmentSts = ?  WHERE Id=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array(1,$aid));
					}
					
				
			}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}		
			if ($count >= 1) {
			   $status =true;
			   $successMsg = ASSESSMENT_MODULE_CREATION_SUCCESS;
			  
			} else {
			   $status =false;
			   $errorMsg = ASSESSMENT_MODULE_CREATION_FAILED;
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
	 
	 
    public function Create1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $mdate = date("Y-m-d H:i:s"); $level=0;
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		if($request[5] == 4){
			$request[4]=$request[3];	
		}	
		
        $aid=Utils::decode5t($request[8]);	
		try{
				$sql1="UPDATE EmployeeAssessment set Achievements = ?, Issues=?, Potentials=?, VariablePay=?, Description=?  WHERE Id=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($request[6],$request[7],$request[9],$request[10],$request[11],$aid));
				$count +=  $query1->rowCount();
				
				$sql1="SELECT Designation From EmployeeMaster where Id =? and OrganizationId=? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($mid,$orgid));
				if($row1=$query1->fetch())
					{
						$approvardesig=$row1->Designation;
					}
					// INSERTING ASSESSMENT CHILD IF PASSED AS AN JSON
					$objective = json_decode($_POST['assessmentarr'], true); 
					for($i=0; $i<count($objective); $i++)
					{
						if($objective[$i]['id']!="" && $objective[$i]['score'] !="" ){
								$com=isset($objective[$i]['comments'])?	$objective[$i]['comments']:"";				
								$sqlobjective = " Update EmployeeAssessmentChild Set Score=?, Comments=? where  EmployeeAssessmentId=? and ObjectiveId=? and DesignationLevel=?";
								$queryobjective = $this->db->prepare($sqlobjective);
								$queryobjective->execute(array($objective[$i]['score'],$com,$aid,$objective[$i]['id'],$approvardesig));
								$count +=  $queryobjective->rowCount();	
							
						}
					}
				
					$sql1="UPDATE EmployeeAssessmentApproval set AssessmentSts = ?  WHERE EmployeeAssessmentId=? AND DesignationId=?";
				    $query1 = $this->db->prepare($sql1);
				    $query1->execute(array(1,$aid,$approvardesig));
					
					
					$sql1 = "SELECT AssessmentSts FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ? and AssessmentSts=0";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array( $aid ));
					if($query1->rowcount()==0){
						$sql1="UPDATE EmployeeAssessment set AssessmentSts = ?  WHERE Id=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array(1,$aid));
						//////////////IF THERE IS VARIABLE PAY FOR ANY EMPLOYEE IN THE END OF ASSESSMENT THEN IT WILL SIT INTO VARIABLE PAY TABLE////
						$sql1="SELECT * from EmployeeAssessment WHERE Id=?";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($aid));
						while($r1=$query1->fetch())
						{
							$variablepay=$r1->VariablePay;
							if($variablepay>0)
							{
								//////////IF ASSESSMENT DURATION IS MONTHLY THE VARIABLE PAY WILL SAVE ON THAT PERTICULAR MONTH OTHERWISE SAVE IN CURRENT MONTH OF GENERATE SALARY////////
								$empid=$r1->EmployeeId;
								$month="";
								
								$month=self::getSalaryMonth($request);
								
								/* ///////FIND OUT IF THERE IS ALREADY ENTRY OF VARIABLE PAY IN DATATBASE////
								$sqlv="SELECT Id from EmployeeIncentive where EmployeeId=? and ApplyDate=? and OrganizationId=?";
								$queryv=$this->db->prepare($sqlv);
								$queryv->execute(array($empid,$month,$orgid));
								if($queryv->rowCount())
								{
									$rv=$queryv->fetch();
									$incid=$rv->Id;
									$sqlv="UPDATE EmployeeIncentive set IncentiveAmount=? , Description=?, LastModifiedDate=? where Id=?";
									$queryv=$this->db->prepare($sqlv);
									$queryv->execute(array($variablepay,$request[11],$mdate, $incid ));
								}else{ */
									$sqlv="INSERT into EmployeeIncentive ( EmployeeId, Description, IncentiveAmount, ApplyDate, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId) values (?, ?, ?, ?, ?, ?, ? ,? ,? ,?)";
									$queryv=$this->db->prepare($sqlv);
									$queryv->execute(array($empid,$request[11],$variablepay,$month,$orgid,$mdate, $mid, $mdate, $mid, $mid ));
								//}
							}
						}
					}
					
				
			}catch(Exception $e) {
					$errorMsg = 'Message: ' .$e->getMessage();
				}		
			if ($count >= 1) {
			   $status =true;
			   $successMsg = ASSESSMENT_MODULE_CREATION_SUCCESS;
			  
			} else {
			   $status =false;
			   $errorMsg = ASSESSMENT_MODULE_CREATION_FAILED;
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		$orgid=$_SESSION['ubihrm_org_id'];
		try{
			
				$sql = "DELETE FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = :id ";
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
				$sql = "DELETE FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = :id ";
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
				$sql = "DELETE FROM EmployeeAssessment WHERE Id = :id ";
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
			
			
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = ASSESSMENT_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = ASSESSMENT_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	public function getDesignation($id, $tablename)
	{
		$name ="";
		$sql = "SELECT Designation FROM $tablename WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Designation;
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	public function getEmployeeAssessmentPending($assessid)
	{
		$level = 0;
		$sql1 = "SELECT EmployeeId, AssessmentSts FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ?";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $assessid  ));
				while( $row = $query1->fetch())
				{
					$level++;
					if($row->AssessmentSts==0)
					break;
				}
			}catch(Exception $e) {
			}
		return $level;
	}
	public function getEmployeeAssessy($assessid, $empid)
	{
		$flg = false;

		$employee=0;
		$sql1 = "SELECT EmployeeId, AssessmentSts FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ?";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $assessid  ));
				while( $row = $query1->fetch())
				{
					if($row->AssessmentSts==0){
						$employee=$row->EmployeeId;
						break;
					}
				}
				if($employee ==  $empid){
					$flg = true;
				}
			}catch(Exception $e) {
			}
		return $flg;
	}
	public function getEmployeeAssessmentRunning($assessid)
	{
		$flg =false;
		$sql1 = "SELECT EmployeeId FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ?  and AssessmentSts=1";
			$query1 = $this->db->prepare($sql1);
			try{
				$query1->execute(array( $assessid  ));
				if($query1->rowCount()>0)
				{
					$flg =true;
				}
			}catch(Exception $e) {
				
				}
		return $flg;
	}
	public function getAssessmentEmployee($assessid, $desigid)
	{
		$name ="0";
		$sql = "SELECT EmployeeId FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = ? and DesignationId=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $assessid, $desigid  ));
			while($row = $query->fetch())
			{
				$name = $row->EmployeeId;
			}
		}catch(Exception $e) {
			
			}
		
		return $name;
	}
	
	public function getAssessmentTopLevelScore($assessid)
	{
		$totalscore = 0;
		$sql = "SELECT sum(Score) as totalscore FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? and Level in (select Max(Level) From EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? )";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $assessid, $assessid  ));
			while($row = $query->fetch())
			{
				$totalscore = $row->totalscore;
			}
		}catch(Exception $e) {
			
			}
		
		return $totalscore;
	}
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'EmployeeAssessment';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId','EmployeeId','AssessmentType' ,'FromDate','ToDate',  'DesignationLevel','DesignationLevel',  'AssessmentSts','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere ="";
		$adsts=$_SESSION['ubihrm_user_sts'];
		//$desigid=$this->getDesignation($userid,'EmployeeMaster');
		//$sWhere = " Where Id in (select EmployeeAssessmentId from (select * from EmployeeAssessmentApproval where  AssessmentSts = 0 Group by EmployeeAssessmentId) s where EmployeeId=$userid) AND OrganizationId= $orgid AND AssessmentSts = 0 AND EmployeeId<>$userid";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($adsts==1 || $hrsts==1){
			$sWhere = " Where OrganizationId= $orgid AND EmployeeId<>$userid";
		}else{
			$ids = Utils::getReportingIds($userid, $this->db);
			$sWhere = " Where OrganizationId= $orgid AND EmployeeId<>$userid and EmployeeId in ($ids) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " And (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if( $i==0){
					$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where FirstName LIKE '%".( $_GET['sSearch'] )."%' OR MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR LastName LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				
				
				else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				if($aColumns[$i]=="EmployeeId" && $i==1){
					$sWhere .= " (EmployeeId in ( select Id from EmployeeMaster where  Designation LIKE '%".($_GET['sSearch_'.$i])."%'))  ";
				}else{
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
				}
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$aid=Utils::encode5t($aRow->Id);
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
						$edit =""; $delete=""; $edit1="";
						if($aRow->AssessmentSts==0){
							if($editper){
								$sts = $this->getEmployeeAssessy($aRow->Id, $userid);
								if($sts){
									$edit = '<a rel="tooltip" title="Assessment" href="'.URL.'performance/editassessment/'.$aid.'" ><i class="fa fa-thumbs-up "></i></a>';
								}
							}else{
								$edit = '<a href="#" rel="tooltip" title="No permission to assess"><i class="fa fa-thumbs-up "></i></a>';
							}
						
						}
						if($adsts==1 || $hrsts==1){
							$edit1 = '<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
						}	
						
						$row[] =$edit.' &nbsp;&nbsp; '.$edit1 ;
					
					
				}
				else if($aColumns[$i]=="AssessmentType")
				{
					
					if($aRow->{$aColumns[$i]} == 1){
						$row[] ='Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 2){
						$row[] ='Half-Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 3){
						$row[] ='Quarterly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 4){
						$row[] ='Monthly' ;
					}
					else{
						$row[] ="" ;
					}
				}
				else if($aColumns[$i]=="AssessmentSts")
				{
					$img = "<img src='".URL."public/dist/img/Red-icon.png' rel='tooltip' title='Not Started'/>";
					if($aRow->{$aColumns[$i]}==1){
						$img="<img src='".URL."public/dist/img/Green-icon.png' rel='tooltip' title='Assessment completed'/>";
					}else{
						$sts = $this->getEmployeeAssessmentRunning($aRow->Id);
						if($sts){
							$img = "<img src='".URL."public/dist/img/Yellow-icon.png' rel='tooltip' title='Assessment in progress'/>";
						}
					}
					$row[]= $img;
				}
				else if($aColumns[$i]=="EmployeeId" && $i==0)
				{
					$row[]='<a rel="tooltip" title="View" href="'.URL.'performance/viewassessment/'.Utils::encode5t($aRow->Id).'/1" >'.Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster", "FirstName", $this->db).' '.Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster", "LastName", $this->db).'</a>' ;
				}
				else if($aColumns[$i]=="EmployeeId" && $i==1)
				{
					$desig=Utils::getName($aRow->EmployeeId,'EmployeeMaster','Designation',$this->db);
					$row[]=Utils::getName($desig,'DesignationMaster','Name',$this->db);
				}
				else if($aColumns[$i]=="DesignationLevel" && $i==5)
				{
					$row[]='Level '.$this->getEmployeeAssessmentPending($aRow->Id) ;
				}
				else if($aColumns[$i]=="DesignationLevel" && $i==6)
				{
					$approver="";
					if($aRow->AssessmentSts!=1){
					$sts = $this->getEmployeeAssessmentPending($aRow->Id) ;
					$sts=$sts-1;
					$desig=explode(',',$aRow->{$aColumns[$i]});
					if($sts>=0)
					$approver=self::getAssessmentEmployee($aRow->Id,$desig[$sts]);
					$row[]=Utils::getEmployeeName($approver,$this->db);
					}
					else{
						$row[]="";
					}
				}
				
				else if($aColumns[$i]=="FromDate" || $aColumns[$i]=="ToDate")
				{
					if($aRow->{$aColumns[$i]} == '0000-00-00'){
						$row[]="";
					}else{
						$row[]=date('M Y', strtotime($aRow->{$aColumns[$i]}));
					}
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getAssessmentresultTable($editper, $deleteper)
	{
		$sTable = 'EmployeeAssessment';
		$sIndexColumn = "Id";
		$aColumns = array( 'EmployeeId', 'AssessmentType' , 'FromDate', 'TotalMarks','ObtainedMarks',  'Id','Rating','Result');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		if($sts==1){
			$sWhere = " Where OrganizationId=$orgid and (Id in (select EmployeeAssessmentId from EmployeeAssessmentApproval where AssessmentSts = 1)) and AssessmentSts = 1";
		}
		else{
			$sWhere = " Where (Id in (select EmployeeAssessmentId from EmployeeAssessmentApproval where EmployeeId = $userid and AssessmentSts = 1) and AssessmentSts = 1 AND OrganizationId= $orgid and  EmployeeId<>$userid) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and  (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					$row[] = round((($aRow->ObtainedMarks * 100)/$aRow->TotalMarks),2)."%";
				}
				else if($aColumns[$i]=="AssessmentType")
				{
					
					if($aRow->{$aColumns[$i]} == 1){
						$row[] ='Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 2){
						$row[] ='Half-Yearly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 3){
						$row[] ='Quarterly' ;
					}
					elseif($aRow->{$aColumns[$i]} == 4){
						$row[] ='Monthly' ;
					}
					else{
						$row[] ="" ;
					}
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					$row[]='<a rel="tooltip" title="View" href="'.URL.'performance/viewassessment/'.Utils::encode5t($aRow->Id).'/2" >'.Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster", "FirstName", $this->db).' '.Utils::getName($aRow->{$aColumns[$i]},"EmployeeMaster", "LastName", $this->db).'</a>' ;
				}
				else if($aColumns[$i]=="FromDate")
				{
					if($aRow->{$aColumns[$i]} == '0000-00-00'){
						$row[]="";
					}else{
						$row[]=self::getAssessmentDuration($aRow->Id);
					}
				}
				else if($aColumns[$i]=="Rating")
				{
					$rating=$aRow->Rating;
					$r="";
					if($rating!=0 && $rating!=""){
					while($rating>0){
					$r =$r.'<i class="fa fa-star" style="color: rgba(234, 181, 28, 1);"></i>';
					$rating--;
					}
					}
					$row[]=$r;
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getAllEmployees()
	{
		$sTable = 'EmployeeMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'FirstName', 'Designation' ,'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$userid = $_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		if($sts==1){
			$sWhere = " Where OrganizationId=$orgid ";
		}
		else{
			$sWhere = " Where OrganizationId= $orgid and  Id<>$userid) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and  (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					$row[] =  '<a rel="tooltip" title="View Assessment" href="'.URL.'performance/viewoverallassessment/'.$aRow->Id.'" ><i class="fa fa-eye "></i></a>';
				}
				else if($aColumns[$i]=="Designation")
				{
					$row[] =Utils::getName($aRow->{$aColumns[$i]},'DesignationMaster','Name',$this->db);
					
				}
				
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	public function getComparisionData($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); 
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid   ="0";
		$temparr = $request[2];
		$fromdate= Utils::getDateformat($request[3]);
		$todate  = Utils::getDateformat($request[4]);
		
		if(is_array($temparr)){
			$empid   = implode(',',$temparr);
		}
		try{
			$name ="0";
			$sql = "SELECT sum(Score) as totalscore, EmployeeId, AssessmentType, FromDate, ToDate FROM  EmployeeAssessment E, EmployeeAssessmentChild EC where E.Id=EC.EmployeeAssessmentId and OrganizationId=? and EmployeeId=? and FromDate>=? and ToDate<=? and AssessmentSts=1  and Level=3 group by EmployeeId";
			$query = $this->db->prepare($sql);
		
			$query->execute(array($orgid, $empid, $fromdate, $todate));
			if($query->rowCount()>0){
			 $status=true;
				while($row = $query->fetch())
				{
					$res = array();
					$res['total'] = $row->totalscore;
					//$str =((AssessmentType==4)?"Monthly":((AssessmentType==3)?"Quaterly":((AssessmentType==2)?"Half Yearly":"Yearly")));
					$date = Utils::dateformatter($row->FromDate)." - ".Utils::dateformatter($row->ToDate);
					$res['name'] = $date;//Utils::getEmployeeName($row->EmployeeId, $this->db);
					$data[]= $res;
				}
			}else{
				$status = false;
				$errorMsg = "No record found";
			}
		}catch(Exception $e) {
			$errorMsg = $e->getMessage(); 
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
	}
	public function getCode($id)
	{
		$empcode ="";
		$sql = "SELECT EmployeeCode FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$empcode =  $row->EmployeeCode;;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	//////////employee incentive////////
	////////////////////////getting weightage of objective///
	
	public function getWeightage($id)
	{
		$empcode =0;
		$sql = "SELECT Weightage FROM AssessmentObjectiveChild WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$empcode =  $row->Weightage;;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	public function getEmployeeVariablepay($empid, $from,$to)
	{
		$orgid = $_SESSION['ubihrm_org_id'];
		$result =0;
		$sql = "SELECT IncentiveAmount FROM EmployeeIncentive WHERE OrganizationId=? and EmployeeId = ? and ApplyDate between ? and ?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid, $empid, $from,$to));
			while($row = $query->fetch())
			{
				$result = $row->IncentiveAmount;
			}
		}catch(Exception $e) {
			
		}
		return $result;
	}
	//////////////////////////////uploading document of employee assessment/////////////////////////////
	public function uploadDocument($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid = $request[2];
		$assdate = Utils::getDateformat($_POST['assess_date']);
		$empcode=$this->getCode($empid);
		$new_name="";
		$dir="public/uploads/$orgid/assessment";
		$filename=$empcode.'_'.$assdate;
		if (! is_dir($dir)) {
			mkdir($dir);
			chmod($dir,0755);
			
		}
		
		//$dir="public/uploads/$orgid";
		$filename1="";
		
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename1=$file;
								$ext1 = end((explode(".", $filename1)));
								if($filename1=="$filename.$ext1")
								{
									unlink("public/uploads/$orgid/assessment/$filename1");
								}
							}
						closedir($dh);
						}
					}
					$new_name="$filename.$ext";
					$file_size =$_FILES['file0']['size'];
					$file_tmp =$_FILES['file0']['tmp_name'];
					$file_type=$_FILES['file0']['type'];   
					$location="public/uploads/$orgid/assessment/";
					if($file_size > 2097152){
						$errors[]='File size must be less than 2 MB';
					}	
					
					if(empty($errors)==true){
					
						move_uploaded_file($file_tmp, $location.$new_name);
						
					}
					else{
						print_r($errors);
					}
							
			}
			
			
			   $status =true;
			   $successMsg = EMPLOYEE_MODULE_PROFILEIMAGE;
			
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
	
	}
	
	public function getSalaryMonth($request)
	{
		$result = array();
		$month = "";
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT DATE_ADD(salarymonth, INTERVAL 1 Month) as SalaryMonth FROM SalaryGenerateMonth WHERE OrganizationId = ? order by Id desc limit 1";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array( $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['salarymonth'] = Utils::dateformatter($row->SalaryMonth);	
$res['salarymonth1'] = $row->SalaryMonth;	
				$month = $row->SalaryMonth;					
				$data[] = $res;
			}
        }else{
			$sql = "SELECT StartDate FROM FiscalMaster WHERE OrganizationId = ? and FiscalSts=1 order by Id desc limit 1";
			$query = $this->db->prepare($sql);
			$query->execute(array( $orgid ));
			while($row = $query->fetch())
			{
				$res = array();
				$res['salarymonth'] = Utils::dateformatter($row->StartDate);	
				$res['salarymonth1'] = $row->StartDate;	
				$month = $row->StartDate;						
				$data[] = $res;
			}
			$status=true;
			$errorMsg="No Record found";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		//return $result;
		return $month;
	}
	public function getRatingArray($empid,$id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $score =0;$aid=0;$includedesg="";
		
		//$objective = json_decode($_POST['results'], true); 
			try{
			$sql2 = "SELECT Designation FROM EmployeeMaster WHERE Id = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $empid ));
			while($row1 = $query2->fetch())
			{
				$desig=$row1->Designation;
			}
			
			$sql2 = "SELECT Id, IncludeDesg FROM AssessmentObjective WHERE DesignationId = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $desig ));
			while($row1 = $query2->fetch())
			{
				$aid=$row1->Id;
				$includedesg=$row1->IncludeDesg;
			}
			$includedesg=($includedesg!='')?explode(",",$includedesg):'';
			$sql3 = "SELECT DISTINCT Level FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? ORDER BY Level asc";
			$query3 = $this->db->prepare($sql3);
			$query3->execute(array( $id ));
			while($row3 = $query3->fetch())
			{
				$score=0;
				$weightage=0;
				$score1=0;
				$level=$row3->Level;
				$sql4 = "SELECT Score,DesignationLevel,ObjectiveId FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? and Level=?";
				$query4 = $this->db->prepare($sql4);
				$query4->execute(array( $id,$level ));
				while($row4 = $query4->fetch())
				{
					$avgscore=0;
					$weightage=$weightage+self::getWeightage($row4->ObjectiveId);
					/* if($row4->Score != 0)
						$avgscore=$row4->Score * ($weightage/100); */
					$score1=$score1+$row4->Score;
					
					$desigl=$row4->DesignationLevel;
				}
				$score=($score1*100)/$weightage;
				if($score>0){	
					$sql2 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $aid ));
					if($score > 100)
						$score=100;
					while($row1 = $query2->fetch())
					{
						$min=$row1->MinMarks;
						$max=$row1->MaxMarks;
						//echo "min $min </br> max $max </br> score $score";
						if(($score >= $min) && ($score <= $max))
						{
							$res=array();
							$res['score']=round($score,2);
							$res['marks']=$score1;
							$res['comments']=$row1->Result;
							$res['rating']=$row1->Rating;	
							$res['level']=$level;	
							$res['includedesg']=$includedesg[$level-1];	
							//$res['approvedby']=Utils::getName($desigl,'DesignationMaster','Name',$this->db);
							$empid1 = $this->getAssessmentEmployee($id, $desigl);
							$res['approver'] = Utils::getEmployeeName($empid1, $this->db);
							$data[ ]=$res;
						}
									
					}
				}
						
			}
					
			$status=true;
			$successMsg=$count." record found";
			$count =  $query2->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}	
        			
		return $data;
    }
	public function getKPARatingArray($empid,$id)
    {
		$result = array();
		$weightage=0;
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $score =0;$aid=0;
		$orgid=$_SESSION['ubihrm_org_id'];
		//$objective = json_decode($_POST['results'], true); 
			try{
			$sql2 = "SELECT Designation FROM EmployeeMaster WHERE Id = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $empid ));
			while($row1 = $query2->fetch())
			{
				$desig=$row1->Designation;
			}
			
			$sql2 = "SELECT Id FROM AssessmentObjective WHERE DesignationId = ? ";
			$query2 = $this->db->prepare($sql2);
			$query2->execute(array( $desig ));
			while($row1 = $query2->fetch())
			{
				$aid=$row1->Id;
			}
			$totalweightage=Utils::getName($id,'EmployeeAssessment','TotalMarks',$this->db);
			$sqlquad = "SELECT Id,Name FROM Quadrants WHERE OrganizationId = ? AND Id IN (Select QuadrantId from AssessmentObjectiveChild where AssessmentObjectiveId =$aid) ORDER BY Name asc";
			$queryquad = $this->db->prepare($sqlquad);
			$queryquad->execute(array($orgid));
			while($rowquad = $queryquad->fetch())
			{
			$qid=$rowquad->Id;
			$quadarrdata=array();
			$quadarrdata['quadname']=$rowquad->Name;
			$sql3 = "SELECT DISTINCT Level FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? ORDER BY Level asc";
			$query3 = $this->db->prepare($sql3);
			$query3->execute(array( $id ));
			$quadarrdata1=array();
			while($row3 = $query3->fetch())
			{
				$score=0;
				$weightage=0;
				$score1=0;
				$level=$row3->Level;
				$sql4 = "SELECT Score,DesignationLevel,ObjectiveId FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = ? and Level=? and ObjectiveId in (select Id from AssessmentObjectiveChild where QuadrantId = $qid)";
				$query4 = $this->db->prepare($sql4);
				$query4->execute(array( $id,$level ));
				while($row4 = $query4->fetch())
				{
					$avgscore=0;
					$weightage=$weightage+self::getWeightage($row4->ObjectiveId);
					/* if($row4->Score != 0)
						$avgscore=$row4->Score * ($weightage/100); */
					$score1=$score1+$row4->Score;
					$desigl=$row4->DesignationLevel;
				}
				if($weightage)
				$score=($score1*100)/$weightage;
				if($score>0){	
					$sql2 = "SELECT * FROM AssessmentResult WHERE AssessmentObjectiveId = ? ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $aid ));
					if($score > 100)
						$score=100;
					while($row1 = $query2->fetch())
					{
						$min=$row1->MinMarks;
						$max=$row1->MaxMarks;
						//echo "min $min </br> max $max </br> score $score";
						if(($score >= $min) && ($score <= $max))
						{
							$res=array();
							$res['score']=round($score,2)."%";
							$res['marks']=$score1;
							if($totalweightage)
							$res['weighperc']=round(($score1 *100)/$totalweightage)."%";
							$res['weightage']=$weightage;
							$res['comments']=$row1->Result;
							$res['rating']=$row1->Rating;	
							$res['level']=$level;	
							//$res['approvedby']=Utils::getName($desigl,'DesignationMaster','Name',$this->db);
							$empid1 = $this->getAssessmentEmployee($id, $desigl);
							$res['approver'] = Utils::getEmployeeName($empid1, $this->db);
							$quadarrdata1[]=$res;
						}
									
					}
				}
								
			}
			$quadarrdata['levelscore']=$quadarrdata1;	
			if($totalweightage)
			$quadarrdata['quadpart']=round(($weightage *100)/$totalweightage)."%";	
		else
			$quadarrdata['quadpart']=0;	
			$data[]=$quadarrdata;
			}	
						
			$status=true;
			$successMsg=$count." record found";
			$count =  $query2->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}	
        			
		return $data;
    }
							
						
						
						
public function getAssessmentDuration($id)
	{
		$empcode ="";
		$sql = "SELECT FromDate,ToDate FROM EmployeeAssessment WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				if($row->ToDate!='0000-00-00'){
				$empcode =  date('M Y',strtotime($row->FromDate))."-".date('M Y',strtotime($row->ToDate));
				}
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	public function getAssessmentMarksByLevel($assessmentid, $maxlevel, $objid)
	{
		$name ="0";
		$sql = "SELECT Score FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = :id and Level= :level and ObjectiveId = :objid";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $assessmentid ,':level' => $maxlevel,':objid' => $objid));
			$count =  $query->rowCount();
			$rowo = $query->fetch();
			$name=(int)$rowo->Score;
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		return $name;
	}
	public function getEmpAssessmentWeightage($assessmentid, $maxlevel)
	{
		$weightage =0;
		//to get total weightage//
		 $sqlweigh = "Select Weightage from AssessmentObjectiveChild where Id in(SELECT ObjectiveId FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = :id and Level= :level)";
        $queryweigh = $this->db->prepare($sqlweigh);
		try{
			$queryweigh->execute(array(':id' => $assessmentid ,':level' => $maxlevel));
			while($rowweigh = $queryweigh->fetch())
			{
			$weightage=$weightage + $rowweigh->Weightage;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		return $weightage;
	}
	
}
				