<?php

/**
 * ApprovalModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class ApprovalModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of GRADE
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM ApprovalProcess WHERE OrganizationId = :id";
        $query = $this->db->prepare($sql);
		try{
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['type'] = $row->ProcessType;
				$res['period'] = $row->EscalationPeriod;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg=APPROVALPROCESS_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getSeniorDesigids($desig)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$parentid=Utils::getSeniorDesigs($desig,$this->db);
		if($parentid == 0){
			$status=true;
			$res = array();
			$res['id'] ="";
			$res['name'] = "No parent designation found";
			$data[] = $res;	
		}else{
			$sql = "SELECT * FROM DesignationMaster WHERE Id in ($parentid) ORDER BY FIELD (Id,$parentid);";
			$query = $this->db->prepare($sql);
			try{
				$query->execute();
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				$level=1;
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = (int)$row->Id;
					$res['name'] = $row->Name;
					$res['level'] = $level;
					$res['parent'] = Utils::getName($row->RoleId,'DesignationMaster','Name',$this->db);
					
					$data[] = $res;
					$level++;
				}
			}else{
				$status=true;
				$successMsg=APPROVALPROCESS_MODULE_GETALL;
			}
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$id=Utils::decode5t($id);
        $sql = "SELECT * FROM ApprovalProcess WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['type'] = $row->ProcessType;
				$res['desig'] = $row->Designation;
				$res['hrapproval'] = $row->HrStatus;
				$res['period'] = $row->EscalationPeriod;
				$res['cirteria'] = explode(',',$row->RuleCriteria);				
				$res['sts'] = $row->HrStatus;				
				$res['approvalupto'] = (int)$row->Approvalupto;				
				$data[] = $res;
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = APPROVALPROCESS_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=APPROVALPROCESS_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    
    /**
     * Setter for a ApprovalProcess (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];
		$HR=0;		
		if($request[7]=="true"){
			$HR=1;
		}
		$sql1 = "SELECT * FROM ApprovalProcess WHERE OrganizationId=? and Id != ? and ProcessType=? AND Designation = ?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array($orgid, Utils::decode5t($request[6]), $request[2], $request[5]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=APPROVALPROCESS_MODULE_UPDATION_DUPLICATE;
		}else{
			
			$criteria1 = json_decode($request[4], true); 
			$temp= array();
			for($i=0; $i<count($criteria1); $i++)
			{
				$temp[] = $criteria1[$i]['benefit'];
			}
			$criteria = implode(",",$temp);
			
			$sql = "UPDATE ApprovalProcess SET ProcessType=?, EscalationPeriod = ?,  RuleCriteria = ?, Designation=?, LastModifiedDate = ?, LastModifiedById = ?,HrStatus=?, Approvalupto=? where Id = ?";
		
			$query = $this->db->prepare($sql);
			
			try{
				$query->execute(array($request[2], $request[3], $criteria, $request[5], $mdate, $mid,$HR,$request[8], Utils::decode5t($request[6]) ));			
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
				///////Activity Log History File//////////
				$approvalname=Utils::getApprovalName($request[2]);
				$desiName=Utils::getName($request[5],'DesignationMaster','Name',$this->db);
				$msg="<b>$approvalname</b> Approval  for <b>$desiName</b> has been updated.";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Organization Approval", $msg, $orgid));
			   $status =true;
			   $successMsg = APPROVALPROCESS_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=APPROVALPROCESS_MODULE_UPDATION_FAILED;
			}
		
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a ApprovalProcess (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        $gradid=0;
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$HR=0;		
		if($request[6]=="true"){
			$HR=1;
		}		
		$sql1 = "SELECT * FROM ApprovalProcess WHERE OrganizationId=? and ProcessType=? AND Designation = ?";
        $query1 = $this->db->prepare($sql1);
		try{
			$query1->execute(array( $orgid, $request[2], $request[5]));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			$status =false;
			 $errorMsg=APPROVALPROCESS_MODULE_CREATION_DUPLICATE;
		}else{
			
			
			$sql = "INSERT INTO ApprovalProcess (ProcessType, EscalationPeriod,  RuleCriteria, Designation, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById,HrStatus,Approvalupto) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)";
			$criteria1 = json_decode($request[4], true); 
			$temp= array();
			for($i=0; $i<count($criteria1); $i++)
			{
				$temp[] = $criteria1[$i]['benefit'];
			}
			$criteria = implode(",",$temp);
			try{								
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2], $request[3], $criteria, $request[5], $orgid, $mdate, $mid, $mdate, $mid,$HR, $request[7]));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
				///////Activity Log History File//////////
				$approvalname=Utils::getApprovalName($request[2]);
				$desiName=Utils::getName($request[5],'DesignationMaster','Name',$this->db);
				$msg="<b>$approvalname</b> Approval  for <b>$desiName</b> has been created.";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Organization Approval", $msg, $orgid));
			   $status =true;
			   $successMsg = APPROVALPROCESS_MODULE_CREATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg=APPROVALPROCESS_MODULE_CREATION_FAILED;
			}
		
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific APPROVALPROCESS
     * @param  $did contains APPROVALPROCESS id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mdate = date("Y-m-d H:i:s");
		$approvalid=Utils::getName($did,'ApprovalProcess','ProcessType',$this->db);
		$approvalname=Utils::getApprovalName($approvalid);
		$desiId=Utils::getName($did,'ApprovalProcess','Designation',$this->db);
		$desiName=Utils::getName($desiId,'DesignationMaster','Name',$this->db);
		$mid=$_SESSION['ubihrm_user_id'];
		$orgid=$_SESSION['ubihrm_org_id'];
		
			$sql = "DELETE FROM ApprovalProcess WHERE Id = :id ";		
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array(':id' => $did));
			
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
				///////Activity Log History File//////////
				$msg="<b>$approvalname</b> Approval  for <b>$desiName</b> has been deleted.";
				$sql = "INSERT INTO ActivityHistoryMaster ( LastModifiedById, Module, ActionPerformed,  OrganizationId) VALUES (?, ?, ?, ?)";
				$query = $this->db->prepare($sql);
				$query->execute(array($mid, "Organization Approval", $msg, $orgid));
			   $status =true;
			   $successMsg = APPROVALPROCESS_MODULE_DELETE_SUCCESS;
			}else {
			   $status =false;
			   $errorMsg=APPROVALPROCESS_MODULE_DELETE_FAILED;
			}
		
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function getName($id, $table)
	{
		$name ="";
		$sql = "SELECT Name FROM $table WHERE Id = ?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'ApprovalProcess';
		$sIndexColumn = "Id";
		$aColumns = array( 'Designation', 'ProcessType','EscalationPeriod', 'Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY   ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = "WHERE OrganizationId= $orgid ";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= "AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="Designation"){
					$sWhere .= " (Designation in ( select Id from DesignationMaster where Name LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			//$row[] = ++$index;
			
			$countRec=0;
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{   
					$edit =""; $delete="";
					if($editper){
						$edit = '<a rel="tooltip"  title="Edit" href="'.URL.'setup/editapproval/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}
					
					$row[] =$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete ;
				}
				elseif($aColumns[$i]=="Designation"){
					if($aRow->Designation==0){
						$row[]="ALL";
					}else{
						$row[] = $this->getName($aRow->{$aColumns[$i]}, "DesignationMaster");
					}
				}
				elseif($aColumns[$i]=="ProcessType"){
					if($aRow->{$aColumns[$i]}==1)
						$row[] ="Leave";
					elseif($aRow->{$aColumns[$i]}==2)
						$row[] ="Personal Loan";
					elseif($aRow->{$aColumns[$i]}==3)
						$row[] ="Document Request";
					elseif($aRow->{$aColumns[$i]}==4)
						$row[] ="Resignation";
					elseif($aRow->{$aColumns[$i]}==5)
						$row[] ="Termination";
					elseif($aRow->{$aColumns[$i]}==6)
						$row[] ="Personnel Requisition";	
					elseif($aRow->{$aColumns[$i]}==7)
						$row[] ="Claims";	
					elseif($aRow->{$aColumns[$i]}==8)
						$row[] ="Time Off";
					elseif($aRow->{$aColumns[$i]}==9)
						$row[] ="Promotion/Demotion";
					elseif($aRow->{$aColumns[$i]}==10)
						$row[] ="Transfer/Redesignation";
					elseif($aRow->{$aColumns[$i]}==11)
						$row[] ="Salary Advance";
					elseif($aRow->{$aColumns[$i]}==0)
						$row[] ="ALL";
						
					//$row[] = ($aRow->{$aColumns[$i]}==1)?"Leave":(($aRow->{$aColumns[$i]}==2)?"Personal Loan ":(($aRow->{$aColumns[$i]}==3)?"Document Request":($aRow->{$aColumns[$i]}==7)?"Claims ":($aRow->{$aColumns[$i]}==6)?"Personnel Requisition ":"Resignation"));
				}
				elseif($aColumns[$i]=="EscalationPeriod"){
					$row[] = $aRow->{$aColumns[$i]}." Day(s)";
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
			$index++;
		}		
		return  $output ;
	}
}
