<?php

/**
 * Class Utils
 */
class Utils
{
	
	////////// hex = &#x62f;&#x2e;&#x625;
	public static $currency_info = array(
		'AED'=>array('name' => 'United Arab Emirates Dirham', 'symbol'=>'?.?', 'hex'=>'AED'),
		'ANG'=>array('name' => 'NL Antillian Guilder', 'symbol'=>'', 'hex'=>''),
		'ARS'=>array('name' => 'Argentine Peso', 'symbol'=>'$', 'hex'=>'ARS'),
		'AUD'=>array('name' => 'Australian Dollar', 'symbol'=>'$', 'hex'=>'AUD'),
		'BRL'=>array('name' => 'Brazilian Real', 'symbol'=>'R$', 'hex'=>'BRL'),
		'BSD'=>array('name' => 'Bahamian Dollar', 'symbol'=>'B$', 'hex'=>'BSD'),
		'CAD'=>array('name' => 'Canadian Dollar', 'symbol'=>'$', 'hex'=>'CAD'),
		'CHF'=>array('name' => 'Swiss Franc', 'symbol'=>'CHF', 'hex'=>'CHF'),
		'CLP'=>array('name' => 'Chilean Peso', 'symbol'=>'$', 'hex'=>'CLP'),
		'CNY'=>array('name' => 'Chinese Yuan Renminbi', 'symbol'=>'', 'hex'=>'CNY'),
		'COP'=>array('name' => 'Colombian Peso', 'symbol'=>'$', 'hex'=>'COP'),
		'CZK'=>array('name' => 'Czech Koruna', 'symbol'=>'Kc', 'hex'=>'CZK'),
		'DKK'=>array('name' => 'Denmark Krone', 'symbol'=>'kr', 'hex'=>'DKK'),
		'EUR'=>array('name' => 'Euro', 'symbol'=>'', 'hex'=>'EUR'),
		'FJD'=>array('name' => 'Fiji Dollar', 'symbol'=>'$', 'hex'=>'FJD'),
		'GBP'=>array('name' => 'British Pound', 'symbol'=>'', 'hex'=>'GBP'),
		'GHS'=>array('name' => 'Ghanaian New Cedi', 'symbol'=>'GH?', 'hex'=>'GHS'),
		'GTQ'=>array('name' => 'Guatemalan Quetzal', 'symbol'=>'Q', 'hex'=>'GTQ'),
		'HKD'=>array('name' => 'Hong Kong Dollar', 'symbol'=>'$', 'hex'=>'HKD'),
		'HNL'=>array('name' => 'Honduran Lempira', 'symbol'=>'L', 'hex'=>'HNL'),
		'HRK'=>array('name' => 'Croatian Kuna', 'symbol'=>'kn', 'hex'=>'HRK'),
		'HUF'=>array('name' => 'Hungarian Forint', 'symbol'=>'Ft', 'hex'=>'HUF'),
		'IDR'=>array('name' => 'Indonesian Rupiah', 'symbol'=>'Rp', 'hex'=>'IDR'),
		'ILS'=>array('name' => 'Israeli New Shekel', 'symbol'=>'?', 'hex'=>'ILS'),
		'INR'=>array('name' => 'Indian Rupee', 'symbol'=>'Rs', 'hex'=>'INR'),
		'ISK'=>array('name' => 'Iceland Krona', 'symbol'=>'kr', 'hex'=>'ISK'),
		'JMD'=>array('name' => 'Jamaican Dollar', 'symbol'=>'J$', 'hex'=>'JMD'),
		'JPY'=>array('name' => 'Japanese Yen', 'symbol'=>'', 'hex'=>'JPY'),
		'KRW'=>array('name' => 'South-Korean Won', 'symbol'=>'?', 'hex'=>'KRW'),
		'LKR'=>array('name' => 'Sri Lanka Rupee', 'symbol'=>'Rs', 'hex'=>'LKR'),
		'MAD'=>array('name' => 'Moroccan Dirham', 'symbol'=>'.?.?', 'hex'=>'MAD'),
		'MMK'=>array('name' => 'Myanmar Kyat', 'symbol'=>'K', 'hex'=>'K'),
		'MXN'=>array('name' => 'Mexican Peso', 'symbol'=>'$', 'hex'=>'MXN'),
		'MYR'=>array('name' => 'Malaysian Ringgit', 'symbol'=>'RM', 'hex'=>'MYR'),
		'NOK'=>array('name' => 'Norwegian Kroner', 'symbol'=>'kr', 'hex'=>'NOK'),
		'NZD'=>array('name' => 'New Zealand Dollar', 'symbol'=>'$', 'hex'=>'NZD'),
		'PAB'=>array('name' => 'Panamanian Balboa', 'symbol'=>'B/.', 'hex'=>'PAB'),
		'PEN'=>array('name' => 'Peruvian Nuevo Sol', 'symbol'=>'S/.', 'hex'=>'PEN'),
		'PHP'=>array('name' => 'Philippine Peso', 'symbol'=>'?', 'hex'=>'PHP'),
		//'PKR'=>array('name' => 'Pakistan Rupee', 'symbol'=>'?', 'hex'=>'&#x20a8;'),
		'PKR'=>array('name' => 'Pakistan Rupee', 'symbol'=>'?', 'hex'=>'PKR'),
		'PLN'=>array('name' => 'Polish Zloty', 'symbol'=>'zl', 'hex'=>'PLN'),
		'RON'=>array('name' => 'Romanian New Lei', 'symbol'=>'lei', 'hex'=>'lei'),
		'RSD'=>array('name' => 'Serbian Dinar', 'symbol'=>'RSD', 'hex'=>'RSD'),
		'RUB'=>array('name' => 'Russian Rouble', 'symbol'=>'???', 'hex'=>'RUB'),
		'SEK'=>array('name' => 'Sweden Krona', 'symbol'=>'kr', 'hex'=>'SEK'),
		'SGD'=>array('name' => 'Singapore Dollar', 'symbol'=>'$', 'hex'=>'SGD'),
		'THB'=>array('name' => 'Thai Baht', 'symbol'=>'?', 'hex'=>'THB'),
		'TND'=>array('name' => 'Tunisian Dinar', 'symbol'=>'DT', 'hex'=>'DT'),
		'TRY'=>array('name' => 'Turkish Lira', 'symbol'=>'	TRY', 'hex'=>'TRY'),
		'TTD'=>array('name' => 'Trinidad/Tobago Dollar', 'symbol'=>'$', 'hex'=>'TTD'),
		'TWD'=>array('name' => 'Taiwan Dollar', 'symbol'=>'NT$', 'hex'=>'NT$'),
		'USD'=>array('name' => 'US Dollar', 'symbol'=>'$', 'hex'=>'USD'),
		'VEF'=>array('name' => 'Venezuelan Bolivar Fuerte', 'symbol'=>'Bs', 'hex'=>'VEF'),
		'VND'=>array('name' => 'Vietnamese Dong', 'symbol'=>'?', 'hex'=>'VND'),
		'XAF'=>array('name' => 'CFA Franc BEAC', 'symbol'=>'FCFA', 'hex'=>'FCFA'),
		'XCD'=>array('name' => 'East Caribbean Dollar', 'symbol'=>'$', 'hex'=>'XCD'),
		'XPF'=>array('name' => 'CFP Franc', 'symbol'=>'F', 'hex'=>'F'),
		'ZAR'=>array('name' => 'South African Rand', 'symbol'=>'R', 'hex'=>'ZAR'),
		'SAR'=>array('name' => 'Saudi Riyal', 'symbol'=>'R', 'hex'=>'SAR'),
		'QAR'=>array('name' => 'Riyal', 'symbol'=>'R', 'hex'=>'QAR')
	);
	public static function getApprovalName($approvalId){
		$approvalname="";
		if($approvalId==1)
			$approvalname ="Leave";
		elseif($approvalId==2)
			$approvalname ="Personal Loan";
		elseif($approvalId==3)
			$approvalname ="Document Request";
		elseif($approvalId==4)
			$approvalname ="Resignation";
		elseif($approvalId==5)
			$approvalname ="Termination";
		elseif($approvalId==6)
			$approvalname ="Personnel Requisition";	
		elseif($approvalId==7)
			$approvalname ="Claims";	
		elseif($approvalId==8)
			$approvalname ="Time Off";
		return $approvalname;
	}
    public static function numberformatter($val,$symbol="")
    {
		//$code =$_SESSION['ubihrm_currencycode'];
		//$symbol = Utils::getCurrencySymbolHex($code);
		$fomat = number_format($val,2,'.',',');
		return $symbol."&nbsp;".$fomat;
    }
	
	public static function getleavetype($val)
    {
		$status = "info"; $label="Pending";                 
		if($val==1){ $status = "danger"; $label="Rejected";  }
		elseif($val==2){ $status = "success"; $label="Approved";  }
		elseif($val==4){ $status = "warning"; $label="Cancel";  }	
		elseif($val==5){ $status = "info"; $label="Withdraw";  }			
		elseif($val==6){ $status = "success"; $label="Issued";  }			
		return '<span class="label label-'.$status.'">'.$label.'</span>';
	
    }
    
    public static function gettimeofftype($val)
    {
		$status = "info"; $label="pending";                 
		if($val==1){ $status = "danger"; $label="Rejected";  }
		elseif($val==3){ $status = "info"; $label="Pending";  }
		elseif($val==2){ $status = "success"; $label="Approved";  }
		elseif($val==4){ $status = "warning"; $label="Cancel";  }	
		elseif($val==5){ $status = "info"; $label="Withdraw";  }			
		elseif($val==6){ $status = "success"; $label="Issued";  }			
		return '<span class="label label-'.$status.'">'.$label.'</span>';
	
    }
	
	public static function getgrievancetype($val)
    {
		$status = "info"; $label="Pending";                 
		if($val==1){ $status = "danger"; $label="Dismissed";  }
		elseif($val==2){ $status = "success"; $label="Resolved";  }
		elseif($val==3){ $status = "warning"; $label="Unsolved";  }	
		elseif($val==4){ $status = "info"; $label="Forwarded";  }			
		return '<span class="label label-'.$status.'">'.$label.'</span>';
    }
	
	public static function getattendancetype($val)
    {
		$status = "info"; $label="On leave";                 
		if($val==1){ $status = "primary"; $label="Present";  }
		elseif($val==2){ $status = "danger"; $label="Absent - unauthorized";  }
		elseif($val==3){ $status = "warning"; $label="Weekly Off";  }	
		elseif($val==4){ $status = "default"; $label="Half Day";  }
		elseif($val==5){ $status = "success"; $label="Public Holiday";  }		
		return '<span class="label label-'.$status.'">'.$label.'</span>';
    }
	
	public static function getcurrency()
    {
		$code =$_SESSION['ubihrm_currencycode'];
		return Utils::getCurrencySymbolHex($code);
    }
	
	public static function getDivisioncurrency($divid,$db)
    {
		$code="";
		$sql1 = "SELECT c.CurrencyCode as code FROM DivisionMaster d, CurrencyMaster c WHERE d.CurrencyId=c.Id and d.Id =? ";
		$query1 = $db->prepare($sql1);
		$query1->execute(array($divid));
		$count=$query1->rowCount();
		$currencyid=0;
		while($row1 = $query1->fetch())
		{
			$code=$row1->code;
		}
		
		return Utils::getCurrencySymbolHex($code);
    }
	
	public static function getDateformat($date,$format='')
	{	
	
		if($format!='')
		{
			$format ='dd-mm-yyyy';
			$format ='dd/mm/yyyy';
		}
		else
		{	
			$format = $_SESSION['ubihrm_dateformate1'];
		}
		
			
		$changedate=$date;
		if($changedate==""){
			return $changedate;
		}
		else{
			//echo $date;
			if($format=='dd/mm/yyyy' || $format=="mm/dd/yyyy" || $format=="yyyy/mm/dd" ){
				$temp = explode('/', $date);
				
				if($format=="dd/mm/yyyy"){
					$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
				}elseif($format=="mm/dd/yyyy"){
					$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
				}elseif($format=="yyyy/mm/dd"){
					$changedate=$temp[0]."-".$temp[1]."-".$temp[2];
				}
			}else if($format=='dd-mm-yyyy' || $format=="mm-dd-yyyy" || $format=="yyyy-mm-dd"){
				$temp = explode('-', $date);
				if($format=="dd-mm-yyyy"){
					$changedate=$temp[2]."-".$temp[1]."-".$temp[0];
				}elseif($format=="mm-dd-yyyy"){
					$changedate=$temp[2]."-".$temp[0]."-".$temp[1];
				}else{
					$changedate=$date;
				}
			}
			return $changedate;
		}
	}
	public static function getDateTimeformat($date)
	{	
		$format = $_SESSION['ubihrm_datetimeformate'];
		$changedate=$date;
		if($changedate==""){
			return $changedate;
		}
		else{
			if($format=="dd/mm/yyyy h:i" || $format=="mm/dd/yyyy h:i" || $format=="yyyy/mm/dd h:i"){
				$temp1 = explode(' ', $date);
				
				$temp = explode('/', $temp1[0]);
				if($format=="dd/mm/yyyy h:i"){
					$changedate=$temp[2]."-".$temp[1]."-".$temp[0]." ".$temp1[1];
				}elseif($format=="mm/dd/yyyy h:i"){
					$changedate=$temp[2]."-".$temp[0]."-".$temp[1]." ".$temp1[1];
				}elseif($format=="yyyy/mm/dd h:i"){
					$changedate=$temp[0]."-".$temp[1]."-".$temp[2]." ".$temp1[1];
				}
			}elseif($format=="dd-mm-yyyy h:i" || $format=="mm-dd-yyyy h:i" || $format=="yyyy-mm-dd h:i"){
				$temp1 = explode(' ', $date);
				
				$temp = explode('-', $temp1[0]);
				if($format=="dd-mm-yyyy"){
					$changedate=$temp[2]."-".$temp[1]."-".$temp[0]." ".$temp1[1];
				}elseif($format=="mm-dd-yyyy"){
					$changedate=$temp[2]."-".$temp[0]."-".$temp[1]." ".$temp1[1];
				}else{
					$changedate=$date;
				}
			}
			return $changedate;
		}
	}
	public static function datetimeformatter($val)
    {
		$result = "-";
		if($val!="0000-00-00 00:00:00" && $val!="")
			$result = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate']." ".$_SESSION['ubihrm_timeformate'],strtotime($val)):$val;
		return $result;
    }
	public static function timeformatter($val)
    {
		$result = "-";
		if($val!="00:00:00" && $val!="")
			$result = isset($_SESSION['ubihrm_timeformate'])?date($_SESSION['ubihrm_timeformate'],strtotime($val)):$val;
			
		return $result;
    }
	public static function dateformatter($val)
    {
		$result = "-";
		if($val!="0000-00-00" && $val!="")
			$result = isset($_SESSION['ubihrm_dateformate'])?date($_SESSION['ubihrm_dateformate'],strtotime($val)):$val;
		return $result;
    }
	
	public static function monthdateformatter($val)
    {
		$result = "-";
		if(($val!="0000-00-00") && ($val!="0000-00-00 00:00:00"))
		{
			$result = date("F Y",strtotime($val));
		}
		return $result;
    }

	//Return Currency Symbol in HEX
	public static function getCurrencySymbolHex($currency_code){
		if (!empty(Utils::$currency_info[$currency_code]['hex']))
			return (string) Utils::$currency_info[$currency_code]['hex'];
		else
			return '';
	}
	
	public static function encode5t($str)
	{
	  for($i=0; $i<5;$i++)
	  {
	    $str=strrev(base64_encode($str)); //apply base64 first and then reverse the string
	  }
	  return $str;
	}
	
	public static function decode5t($str)
	{
	  for($i=0; $i<5;$i++)
	  {
	    $str=base64_decode(strrev($str)); //apply base64 first and then reverse the string}
	  }
	  return $str;
	}
	
	public static function getEmployeeName($id, $db)
	{
		$name ="";
		$sql = "SELECT FirstName, MiddleName, LastName FROM EmployeeMaster WHERE Id = :id";
        $query = $db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = ucwords(strtolower($row->FirstName. " " .$row->MiddleName. " " .$row->LastName));
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
		
	public static function getName($id, $table, $column, $db)
	{
		$name ="";
		$sql = "SELECT $column FROM $table WHERE Id = :id";
        $query = $db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->$column;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public static function getTotalEmp($orgid,$db)
	{
		$name =1;
		$total =0;
		$maxemp=Utils::getName($orgid, 'Organization', 'NoOfEmp', $db);
		//Utils::Trace("Orgid".$orgid);
		$sql = "SELECT count(*) as total FROM EmployeeMaster WHERE OrganizationId = :id AND (DOL=0000-00-00 and Is_Delete!=2)";
        $query = $db->prepare($sql);
		try{
			$query->execute(array(':id' => $orgid ));
			while($row = $query->fetch())
			{
				$total = $row->total;
				//Utils::Trace("Total Employee ". $total);
			}
			if($maxemp <  $total)
			{
				$name =0;
			}
		}catch(Exception $e) {
			
		}
		//Utils::Trace($name);
		return $name;
	}
	public static function getOtherName($id, $type, $db)
	{
		$name ="";
		$sql = "SELECT DisplayName FROM OtherMaster WHERE ActualValue = ? and OtherType = ? ";
        $query = $db->prepare($sql);
		try{
			$query->execute(array( $id, $type ));
			while($row = $query->fetch())
			{
				$name = $row->DisplayName;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	// Gratuity Calculation= [ (Basic Pay + D.A) x 15 days x No. of years of service ] / 26
	// =((((Total No. of Days working)/365)*7)*((Basic Salary)/30))
	public static function getEmployeeGratuity($empid, $type, $db, $lastdate='')
    {
	
		$result = array(); $ctc=0; $payday=0; $totalyear=0; $totaldays=0;
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$date = "";
		$orgid = $_SESSION['ubihrm_org_id'];
		$lastdate = ($lastdate=="") ? date("Y-m-d") : $lastdate;
		
		
        $sql = "SELECT FirstName,Id, Grade, EmployeeCTC, PayPattern, TIMESTAMPDIFF(Day, DOJ, '$lastdate')/365 as totalyear, TIMESTAMPDIFF(Day, DOJ, '$lastdate') as totaldays,  Division, DOJ FROM EmployeeMaster WHERE OrganizationId = ? AND Id=? ";
        $query = $db->prepare($sql);
		try{
			
			$query->execute(array( $orgid, $empid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$emptotal = 0;
				$res = array();
				$res['id'] = $row->Id;
				$ctc = $row->EmployeeCTC;
			
				$doj = $row->DOJ;
				$yearstime=strtotime($lastdate)-strtotime($doj);
				//$years=date
				
				$countryid =  Utils::getName($row->Division, "DivisionMaster", "CountryId", $db);
				$country =   Utils::getName($countryid, "CountryMaster", "Name", $db);
				$totalyear=$row->totalyear;
				
				$totaldays=$row->totaldays; ////// plus one will add starting day
				$totalyear=$totaldays/365; ////////////////////Finding Years//////////////////
				//	echo $row->FirstName." - ".$totaldays." ".$totalyear."<br>";
				$basicsalary = Utils::getEmployeeBasicSalary($empid, $db);
				
				// =((((Total No. of Days working)/365)*7)*((Basic Salary)/30))
				//////// GRATUITY FOR RESIGNED EMPLOYEE  ///////////////
				if($type==1){
					/////////////////// FOR UAE /////////////////////
					if($country == "United Arab Emirates"){
						if($totalyear>= 1 && $totalyear < 3)
						{
							$emptotal  += ((($totaldays/365)*7)*($basicsalary/30));
							
						}else if($totalyear>= 3 && $totalyear < 5)
						{
							$emptotal  += ((($totaldays/365)*14)*($basicsalary/30));
						}/* else if($totalyear>= 5)
						{
							
							$onedaysal=$basicsalary/30;
							$threeyramt=$emptotal  += (($basicsalary/30)*7*3);  ////////////////7 DAYS SALARY
							$twoyramt=$emptotal  += (($basicsalary/30)*14*2);  //////////////// 14 DAYS SALARY
							$restyears=$totalyear-5;
							$rem=$emptotal  += (($basicsalary/30)*30*$restyears);  ////////////////30 DAYS SALARY
						} */
						else if($totalyear> 5)
						{
							/* $fiveyeardays = 5*365;
							$restofthedays = $totaldays-$fiveyeardays;
							$emptotal  += ((($fiveyeardays/365)*21)*($basicsalary/30));
							$emptotal  += ((($restofthedays/365)*30)*($basicsalary/30)); */
							$onedaysal=$basicsalary/30;
							$restyears=$totalyear-5;
							$fiveyramt=$emptotal  += (($basicsalary/30)*21*5);  ////////////////21 DAYS SALARY
							$rem=$emptotal  += (($basicsalary/30)*30*$restyears);  ////////////////30 DAYS SALARY
							/* echo $ctc." ctc<br>";
							echo $onedaysal." onedaysal<br>";
							echo $totalyear." total year<br>";
							echo $restyears." rest year<br>";
							echo $fiveyramt." fiveyr amt<br>";
							echo $rem." rem <br>"; */
						}
					}elseif($country == "Saudi Arabia"){
						///////////////// KSA  RESIGNATION ///////////////////////
						if($totalyear>= 2 && $totalyear < 5)
						{
							$emptotal  += ((($totaldays/365)*5)*($ctc/30));
							
						}else if($totalyear>= 5 && $totalyear < 10)
						{
							$emptotal  += ((($totaldays/365)*20)*($ctc/30));
						}
						else if($totalyear>= 10)
						{
							/* $fiveyeardays = 5*365;
							$tenyeardays = 10*365;
							$restofthedays = $totaldays-$tenyeardays;
							$emptotal  += ((($fiveyeardays/365)*10)*($ctc/30));
							$emptotal  += ((($fiveyeardays/365)*20)*($ctc/30));
							$emptotal  += ((($restofthedays/365)*30)*($ctc/30)); */
							
							$fiveyramt=$emptotal  += (($ctc/30)*5*5);  //////////////// 10 DAYS SALARY
							$fiveyramt=$emptotal  += (($ctc/30)*20*5);  //////////////// 20 DAYS SALARY
							$restyears=$totalyear-10;
							$rem=$emptotal  += (($ctc/30)*30*$restyears);  //////////////// 30 DAYS SALARY
						}
						
					}elseif($country == "Kuwait"){
						///////////////// Kuwait  RESIGNATION ///////////////////////
						if($totalyear>= 3 && $totalyear < 5)
						{
							$emptotal  += ((($totaldays/365)*7.5)*($ctc/30));
						}else if($totalyear>= 5 && $totalyear < 10)
						{
							$emptotal  += ((($totaldays/365)*20)*($ctc/30));
						}else if($totalyear>= 10)
						{
							/* $fiveyeardays = 5*365;
							$tenyeardays = 10*365;
							$restofthedays = $totaldays-$tenyeardays;
							$emptotal  += ((($fiveyeardays/365)*7.5)*($ctc/30));
							$emptotal  += ((($fiveyeardays/365)*20)*($ctc/30));
							$emptotal  += ((($restofthedays/365)*30)*($ctc/30)); */
							
							$fiveyramt=$emptotal  += (($ctc/30)*7.5*5);  //////////////// 7.5 DAYS SALARY
							$fiveyramt=$emptotal  += (($ctc/30)*20*5);  //////////////// 20 DAYS SALARY
							$restyears=$totalyear-10;
							$rem=$emptotal  += (($ctc/30)*30*$restyears);  //////////////// 30 DAYS SALARY
						}
						
					}
					elseif($country == "Qatar"){
						///////////////// Kuwait  RESIGNATION ///////////////////////
						/* if($totalyear>= 1 && $totalyear < 5)
						{
							$emptotal  += ((($totaldays/365)*21)*($basicsalary/30));
						}else if($totalyear>= 5 && $totalyear < 10)
						{
							$emptotal  += ((($totaldays/365)*28)*($basicsalary/30));
						}else if($totalyear>= 10)
						{
							/* $fiveyeardays = 5*365;
							$tenyeardays = 10*365;
							$restofthedays = $totaldays-$tenyeardays;
							$emptotal  += ((($fiveyeardays/365)*21)*($ctc/30));
							$emptotal  += ((($fiveyeardays/365)*28)*($ctc/30));
							$emptotal  += ((($restofthedays/365)*35)*($ctc/30)); */
							
							/* $fiveyramt=$emptotal  += (($basicsalary/30)*21*5);  //////////////// 21 DAYS SALARY
							$fiveyramt=$emptotal  += (($basicsalary/30)*28*5);  //////////////// 28 DAYS SALARY
							$restyears=$totalyear-10;
							$rem=$emptotal  += (($basicsalary/30)*35*$restyears);  //////////////// 30 DAYS SALARY 
							
						} */
						if($totalyear > 1){
							$emptotal  += (($basicsalary/30)*21*$totalyear);  ////////////////21 DAYS SALARY
						}
						
					}
				//////// GRATUITY FOR TERMINATED EMPLOYEE   ////////////////
				}else{
					if($country == "United Arab Emirates"){
						if($totalyear>= 1 && $totalyear <= 5)
						{
							$emptotal  += ((($totaldays/365)*21)*($basicsalary/30));
						}else if($totalyear> 5)
						{
							/* $fiveyeardays = 5*365;
							$restofthedays = $totaldays-$fiveyeardays;
							$emptotal  += ((($fiveyeardays/365)*21)*($basicsalary/30));
							$emptotal  += ((($restofthedays/365)*30)*($basicsalary/30)); */
							$onedaysal=$basicsalary/30;
							$restyears=$totalyear-5;
							$fiveyramt=$emptotal  += (($basicsalary/30)*21*5);  ////////////////21 DAYS SALARY
							$rem=$emptotal  += (($basicsalary/30)*30*$restyears);  ////////////////30 DAYS SALARY
							/* echo $ctc." ctc<br>";
							echo $onedaysal." onedaysal<br>";
							echo $totalyear." total year<br>";
							echo $restyears." rest year<br>";
							echo $fiveyramt." fiveyr amt<br>";
							echo $rem." rem <br>"; */
						}
					}elseif($country == "Saudi Arabia"){
						///////////////// KSA ///////////////////////
						if($totalyear>= 1 && $totalyear <= 5)
						{
							$emptotal  += ((($totaldays/365)*15)*($ctc/30));
						}else if($totalyear> 5)
						{
							/* $fiveyeardays = 5*365;
							$restofthedays = $totaldays-$fiveyeardays;
							$emptotal  += ((($fiveyeardays/365)*15)*($ctc/30));
							$emptotal  += ((($restofthedays/365)*30)*($ctc/30));
							 */
							$restyears=$totalyear-5;
							$emptotal  += (($ctc/30)*15*5);  ////////////////15 DAYS SALARY
							$emptotal  += (($ctc/30)*30*$restyears);  ////////////////30 DAYS SALARY
						}
						
					}elseif($country == "Kuwait"){
						///////////////// Kuwait ///////////////////////
						if($totalyear>= 1 && $totalyear <= 5)
						{
							$emptotal  += ((($totaldays/365)*15)*($ctc/30));
						}else if($totalyear> 5)
						{
							/* $fiveyeardays = 5*365;
							$restofthedays = $totaldays-$fiveyeardays;
							$emptotal  += ((($fiveyeardays/365)*15)*($ctc/30));
							$emptotal  += ((($restofthedays/365)*30)*($ctc/30)); */
							
							$restyears=$totalyear-5;
							$emptotal  += (($ctc/30)*15*5);  ////////////////15 DAYS SALARY
							$emptotal  += (($ctc/30)*30*$restyears);  ////////////////30 DAYS SALARY
						}
					}
					elseif($country == "Qatar"){
						/* ///////////////// Qatar /////////////////////// */
						/* if($totalyear>= 1 && $totalyear <= 5)
						{
							$emptotal  += ((($totaldays/365)*21)*($basicsalary/30));
						}else if($totalyear> 5)
						{
							//$fiveyeardays = 5*365;
							// $restofthedays = $totaldays-$fiveyeardays;
							// $emptotal  += ((($fiveyeardays/365)*21)*($basicsalary/30));
							// $emptotal  += ((($restofthedays/365)*30)*($basicsalary/30));
							$restyears=$totalyear-5;
							$emptotal  += (($basicsalary/30)*21*5);  ////////////////21 DAYS SALARY
							$emptotal  += (($basicsalary/30)*30*$restyears);  ////////////////30 DAYS SALARY
							
						} */
						
						if($totalyear > 1){
							$emptotal  += (($basicsalary/30)*21*$totalyear);  ////////////////21 DAYS SALARY
						}
							
					}
				}
				
			/*	
///////////////////// FIND OUT THE GRATUITY TERM FOR THE EMPLOYEE ////////////////////////////
				$sql1 = "SELECT PayableDays, MaxExp, MinExp, GratuityYear, GratuityDays FROM GratuityMaster gm, GratuityChild gc WHERE gm.Id=gc.GratuityId and OrganizationId = ? AND  MinExp < ? and IF(MaxExp = 0, 100, MaxExp)>=? and EmployeeStatusId = $type and OrganizationId = ?";
				$query1 = $db->prepare($sql1);
				$query1->execute(array($orgid, $totalyear, $totalyear, $orgid));
				if($query1->rowCount()>0)
				{
					$flg=1;$days=0;$payd=0;
					$year=0;$payday=0;$i=0;
					while($row1 = $query1->fetch())
					{						
						
						if($totalyear >= $row1->GratuityYear){
							$payday=$row1->GratuityDays;
							$year=$row1->GratuityYear;
							$i++;
							$days += 365;
							$emptotal  +=($payday*$basicsalary/30);
						}
						
					}
					
					for( ;$i<round($totalyear,0); $i++)
					{
						$days += 365;
						$emptotal  +=($payday*$basicsalary/30);
					}
					if($totaldays>$days){
						$days = $totaldays-$days;
						$emptotal  += (($days/365)*$payday*$basicsalary/30);
					}
					//$emptotal  =$days;
				}
				*/

			}
        }
		
		return round($emptotal,2);
    }
	public static function getEmployeeGratuityNoExp($empid, $type, $db, $lastdate='')
    {
	
		$result = array(); $ctc=0; $payday=0; $totalyear=0; $totaldays=0;
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$date = "";
		$orgid = $_SESSION['ubihrm_org_id'];
		$lastdate = ($lastdate=="") ? date("Y-m-d") : $lastdate;
		
		
        $sql = "SELECT FirstName,Id, Grade, EmployeeCTC, PayPattern, TIMESTAMPDIFF(Day, DOJ, '$lastdate')/365 as totalyear, TIMESTAMPDIFF(Day, DOJ, '$lastdate') as totaldays,  Division, DOJ FROM EmployeeMaster WHERE OrganizationId = ? AND Id=? ";
        $query = $db->prepare($sql);
		try{
			
			$query->execute(array( $orgid, $empid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$emptotal = 0;
				$res = array();
				$res['id'] = $row->Id;
				$ctc = $row->EmployeeCTC;
			
				$doj = $row->DOJ;
				$yearstime=strtotime($lastdate)-strtotime($doj);
				//$years=date
				
				$countryid =  Utils::getName($row->Division, "DivisionMaster", "CountryId", $db);
				$country =   Utils::getName($countryid, "CountryMaster", "Name", $db);
				$totalyear=$row->totalyear;
				
				$totaldays=$row->totaldays; ////// plus one will add starting day
				$totalyear=$totaldays/365; ////////////////////Finding Years//////////////////
				//	echo $row->FirstName." - ".$totaldays." ".$totalyear."<br>";
				$basicsalary = Utils::getEmployeeBasicSalary($empid, $db);
				
				// =((((Total No. of Days working)/365)*7)*((Basic Salary)/30))
				//////// GRATUITY FOR RESIGNED EMPLOYEE  ///////////////
				if($type==1){
					/////////////////// FOR UAE /////////////////////
					if($country == "United Arab Emirates"){
						if($totalyear>= 0 && $totalyear < 3)
						{
							$emptotal  += ((($totaldays/365)*7)*($basicsalary/30));
							
						}else if($totalyear>= 3 && $totalyear < 5)
						{
							$emptotal  += ((($totaldays/365)*14)*($basicsalary/30));
						}/* else if($totalyear>= 5)
						{
							
							$onedaysal=$basicsalary/30;
							$threeyramt=$emptotal  += (($basicsalary/30)*7*3);  ////////////////7 DAYS SALARY
							$twoyramt=$emptotal  += (($basicsalary/30)*14*2);  //////////////// 14 DAYS SALARY
							$restyears=$totalyear-5;
							$rem=$emptotal  += (($basicsalary/30)*30*$restyears);  ////////////////30 DAYS SALARY
						} */
						else if($totalyear> 5)
						{
							/* $fiveyeardays = 5*365;
							$restofthedays = $totaldays-$fiveyeardays;
							$emptotal  += ((($fiveyeardays/365)*21)*($basicsalary/30));
							$emptotal  += ((($restofthedays/365)*30)*($basicsalary/30)); */
							$onedaysal=$basicsalary/30;
							$restyears=$totalyear-5;
							$fiveyramt=$emptotal  += (($basicsalary/30)*21*5);  ////////////////21 DAYS SALARY
							$rem=$emptotal  += (($basicsalary/30)*30*$restyears);  ////////////////30 DAYS SALARY
							/* echo $ctc." ctc<br>";
							echo $onedaysal." onedaysal<br>";
							echo $totalyear." total year<br>";
							echo $restyears." rest year<br>";
							echo $fiveyramt." fiveyr amt<br>";
							echo $rem." rem <br>"; */
						}
					}elseif($country == "Saudi Arabia"){
						///////////////// KSA  RESIGNATION ///////////////////////
						if($totalyear>= 0 && $totalyear < 5)
						{
							$emptotal  += ((($totaldays/365)*5)*($ctc/30));
							
						}else if($totalyear>= 5 && $totalyear < 10)
						{
							$emptotal  += ((($totaldays/365)*20)*($ctc/30));
						}
						else if($totalyear>= 10)
						{
							/* $fiveyeardays = 5*365;
							$tenyeardays = 10*365;
							$restofthedays = $totaldays-$tenyeardays;
							$emptotal  += ((($fiveyeardays/365)*10)*($ctc/30));
							$emptotal  += ((($fiveyeardays/365)*20)*($ctc/30));
							$emptotal  += ((($restofthedays/365)*30)*($ctc/30)); */
							
							$fiveyramt=$emptotal  += (($ctc/30)*5*5);  //////////////// 10 DAYS SALARY
							$fiveyramt=$emptotal  += (($ctc/30)*20*5);  //////////////// 20 DAYS SALARY
							$restyears=$totalyear-10;
							$rem=$emptotal  += (($ctc/30)*30*$restyears);  //////////////// 30 DAYS SALARY
						}
						
					}elseif($country == "Kuwait"){
						///////////////// Kuwait  RESIGNATION ///////////////////////
						if($totalyear>= 0 && $totalyear < 5)
						{
							$emptotal  += ((($totaldays/365)*7.5)*($ctc/30));
						}else if($totalyear>= 5 && $totalyear < 10)
						{
							$emptotal  += ((($totaldays/365)*20)*($ctc/30));
						}else if($totalyear>= 10)
						{
							/* $fiveyeardays = 5*365;
							$tenyeardays = 10*365;
							$restofthedays = $totaldays-$tenyeardays;
							$emptotal  += ((($fiveyeardays/365)*7.5)*($ctc/30));
							$emptotal  += ((($fiveyeardays/365)*20)*($ctc/30));
							$emptotal  += ((($restofthedays/365)*30)*($ctc/30)); */
							
							$fiveyramt=$emptotal  += (($ctc/30)*7.5*5);  //////////////// 7.5 DAYS SALARY
							$fiveyramt=$emptotal  += (($ctc/30)*20*5);  //////////////// 20 DAYS SALARY
							$restyears=$totalyear-10;
							$rem=$emptotal  += (($ctc/30)*30*$restyears);  //////////////// 30 DAYS SALARY
						}
						
					}
					elseif($country == "Qatar"){
						///////////////// Kuwait  RESIGNATION ///////////////////////
						/* if($totalyear>= 1 && $totalyear < 5)
						{
							$emptotal  += ((($totaldays/365)*21)*($basicsalary/30));
						}else if($totalyear>= 5 && $totalyear < 10)
						{
							$emptotal  += ((($totaldays/365)*28)*($basicsalary/30));
						}else if($totalyear>= 10)
						{
							/* $fiveyeardays = 5*365;
							$tenyeardays = 10*365;
							$restofthedays = $totaldays-$tenyeardays;
							$emptotal  += ((($fiveyeardays/365)*21)*($ctc/30));
							$emptotal  += ((($fiveyeardays/365)*28)*($ctc/30));
							$emptotal  += ((($restofthedays/365)*35)*($ctc/30)); */
							
							/* $fiveyramt=$emptotal  += (($basicsalary/30)*21*5);  //////////////// 21 DAYS SALARY
							$fiveyramt=$emptotal  += (($basicsalary/30)*28*5);  //////////////// 28 DAYS SALARY
							$restyears=$totalyear-10;
							$rem=$emptotal  += (($basicsalary/30)*35*$restyears);  //////////////// 30 DAYS SALARY 
							
						} */
						if($totalyear > 0){
							$emptotal  += (($basicsalary/30)*21*$totalyear);  ////////////////21 DAYS SALARY
						}
						
					}
				//////// GRATUITY FOR TERMINATED EMPLOYEE   ////////////////
				}else{
					if($country == "United Arab Emirates"){
						if($totalyear>= 0 && $totalyear <= 5)
						{
							$emptotal  += ((($totaldays/365)*21)*($basicsalary/30));
						}else if($totalyear> 5)
						{
							/* $fiveyeardays = 5*365;
							$restofthedays = $totaldays-$fiveyeardays;
							$emptotal  += ((($fiveyeardays/365)*21)*($basicsalary/30));
							$emptotal  += ((($restofthedays/365)*30)*($basicsalary/30)); */
							$onedaysal=$basicsalary/30;
							$restyears=$totalyear-5;
							$fiveyramt=$emptotal  += (($basicsalary/30)*21*5);  ////////////////21 DAYS SALARY
							$rem=$emptotal  += (($basicsalary/30)*30*$restyears);  ////////////////30 DAYS SALARY
							/* echo $ctc." ctc<br>";
							echo $onedaysal." onedaysal<br>";
							echo $totalyear." total year<br>";
							echo $restyears." rest year<br>";
							echo $fiveyramt." fiveyr amt<br>";
							echo $rem." rem <br>"; */
						}
					}elseif($country == "Saudi Arabia"){
						///////////////// KSA ///////////////////////
						if($totalyear>= 0 && $totalyear <= 5)
						{
							$emptotal  += ((($totaldays/365)*15)*($ctc/30));
						}else if($totalyear> 5)
						{
							/* $fiveyeardays = 5*365;
							$restofthedays = $totaldays-$fiveyeardays;
							$emptotal  += ((($fiveyeardays/365)*15)*($ctc/30));
							$emptotal  += ((($restofthedays/365)*30)*($ctc/30));
							 */
							$restyears=$totalyear-5;
							$emptotal  += (($ctc/30)*15*5);  ////////////////15 DAYS SALARY
							$emptotal  += (($ctc/30)*30*$restyears);  ////////////////30 DAYS SALARY
						}
						
					}elseif($country == "Kuwait"){
						///////////////// Kuwait ///////////////////////
						if($totalyear>= 0 && $totalyear <= 5)
						{
							$emptotal  += ((($totaldays/365)*15)*($ctc/30));
						}else if($totalyear> 5)
						{
							/* $fiveyeardays = 5*365;
							$restofthedays = $totaldays-$fiveyeardays;
							$emptotal  += ((($fiveyeardays/365)*15)*($ctc/30));
							$emptotal  += ((($restofthedays/365)*30)*($ctc/30)); */
							
							$restyears=$totalyear-5;
							$emptotal  += (($ctc/30)*15*5);  ////////////////15 DAYS SALARY
							$emptotal  += (($ctc/30)*30*$restyears);  ////////////////30 DAYS SALARY
						}
					}
					elseif($country == "Qatar"){
						/* ///////////////// Qatar /////////////////////// */
						/* if($totalyear>= 1 && $totalyear <= 5)
						{
							$emptotal  += ((($totaldays/365)*21)*($basicsalary/30));
						}else if($totalyear> 5)
						{
							//$fiveyeardays = 5*365;
							// $restofthedays = $totaldays-$fiveyeardays;
							// $emptotal  += ((($fiveyeardays/365)*21)*($basicsalary/30));
							// $emptotal  += ((($restofthedays/365)*30)*($basicsalary/30));
							$restyears=$totalyear-5;
							$emptotal  += (($basicsalary/30)*21*5);  ////////////////21 DAYS SALARY
							$emptotal  += (($basicsalary/30)*30*$restyears);  ////////////////30 DAYS SALARY
							
						} */
						
						if($totalyear >0){
							$emptotal  += (($basicsalary/30)*21*$totalyear);  ////////////////21 DAYS SALARY
						}
							
					}
				}
				
			/*	
///////////////////// FIND OUT THE GRATUITY TERM FOR THE EMPLOYEE ////////////////////////////
				$sql1 = "SELECT PayableDays, MaxExp, MinExp, GratuityYear, GratuityDays FROM GratuityMaster gm, GratuityChild gc WHERE gm.Id=gc.GratuityId and OrganizationId = ? AND  MinExp < ? and IF(MaxExp = 0, 100, MaxExp)>=? and EmployeeStatusId = $type and OrganizationId = ?";
				$query1 = $db->prepare($sql1);
				$query1->execute(array($orgid, $totalyear, $totalyear, $orgid));
				if($query1->rowCount()>0)
				{
					$flg=1;$days=0;$payd=0;
					$year=0;$payday=0;$i=0;
					while($row1 = $query1->fetch())
					{						
						
						if($totalyear >= $row1->GratuityYear){
							$payday=$row1->GratuityDays;
							$year=$row1->GratuityYear;
							$i++;
							$days += 365;
							$emptotal  +=($payday*$basicsalary/30);
						}
						
					}
					
					for( ;$i<round($totalyear,0); $i++)
					{
						$days += 365;
						$emptotal  +=($payday*$basicsalary/30);
					}
					if($totaldays>$days){
						$days = $totaldays-$days;
						$emptotal  += (($days/365)*$payday*$basicsalary/30);
					}
					//$emptotal  =$days;
				}
				*/

			}
        }
		
		return round($emptotal,2);
    }
	
	public static function getEmployeeBasicSalary($empid, $db)
    {
		$basicsalary =0;
		$result = array(); 
		$count=0; 
		$orgid = $_SESSION['ubihrm_org_id'];
		
        $sql = "SELECT HeadAmount FROM EmployeeSalaryDetails WHERE OrganizationId = ? AND EmployeeId = ? and HeadId in (select Id from SalaryHead where (Name like '%Basic%'  or Name like '%Base%') and HeadType=4 and OrganizationId = ?)";
        $query = $db->prepare($sql);
		try{
			
			$query->execute(array( $orgid, $empid ,$orgid));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			while($row = $query->fetch())
			{
				$basicsalary = $row->HeadAmount;
			}
        }
		
		return $basicsalary;
    }
	
/* 	public static function getReportingIds($empid, $db, $orgid='')
	{
		if($orgid==''){
		    $orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		}
		$ids = 0;
		
		$parentid=$empid;
		if($parentid!="0" && $parentid!="")
		{
			while($parentid!="")
			{
				$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and ReportingTo in ( $parentid ) and  DOL='0000-00-00' ";
				
				$query1 = $db->prepare($sql1);
				$query1->execute(array($orgid));
				$parentid="";
				while($row1 = $query1->fetch())
				{
					if($parentid==""){
						$parentid = $row1->Id;
					}else{
						$parentid .= ", ".$row1->Id;
					}
					if($ids==""){
						$ids = $row1->Id;
					}else{
						$ids .= ",".$row1->Id;
					}
					
				}
				
			}
		}
			return $ids;
	} */
	
	public static function getReportingIds($empid, $db, $orgid='')
	{
		if($orgid==''){
		    $orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		}
		$ids = 0;

		if($_SESSION['ubihrm_profiletype']==2)
		{
			if($_SESSION['ubihrm_dataaccess']==1)
			{
				$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and DOL='0000-00-00' ";
				
				$query1 = $db->prepare($sql1);
				$query1->execute(array($orgid));
				$parentid="";
				while($row1 = $query1->fetch())
				{
					if($parentid==""){
						$parentid = $row1->Id;
					}else{
						$parentid .= ", ".$row1->Id;
					}
					if($ids==""){
						$ids = $row1->Id;
					}else{
						$ids .= ",".$row1->Id;
					}
					
				}
			}else{
				$parentid=$empid;
				if($parentid!="0" && $parentid!="")
				{
					while($parentid!="")
					{
						$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and ReportingTo in ( $parentid ) and  DOL='0000-00-00' ";
						
						$query1 = $db->prepare($sql1);
						$query1->execute(array($orgid));
						$parentid="";
						while($row1 = $query1->fetch())
						{
							if($parentid==""){
								$parentid = $row1->Id;
							}else{
								$parentid .= ", ".$row1->Id;
							}
							if($ids==""){
								$ids = $row1->Id;
							}else{
								$ids .= ",".$row1->Id;
							}
							
						}
						
					}
				}
			}
		}
		else{
			$parentid=$empid;
			if($parentid!="0" && $parentid!="")
			{
				while($parentid!="")
				{
					$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and ReportingTo in ( $parentid ) and  DOL='0000-00-00' ";
					
					$query1 = $db->prepare($sql1);
					$query1->execute(array($orgid));
					$parentid="";
					while($row1 = $query1->fetch())
					{
						if($parentid==""){
							$parentid = $row1->Id;
						}else{
							$parentid .= ", ".$row1->Id;
						}
						if($ids==""){
							$ids = $row1->Id;
						}else{
							$ids .= ",".$row1->Id;
						}
						
					}
					
				}
			}
		}
		return $ids;
	}

	public static function getExReportingIds($empid, $db)
	{
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$ids = 0;
		
		$parentid=$empid;
		if($parentid!="0" && $parentid!="")
		{
			while($parentid!="")
			{
				$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and ReportingTo in ( $parentid ) and  DOL<>'0000-00-00' ";
				
				$query1 = $db->prepare($sql1);
				$query1->execute(array($orgid));
				$parentid="";
				while($row1 = $query1->fetch())
				{
					if($parentid==""){
						$parentid = $row1->Id;
					}else{
						$parentid .= ", ".$row1->Id;
					}
					if($ids==""){
						$ids = $row1->Id;
					}else{
						$ids .= ",".$row1->Id;
					}
					
				}
				
			}
		}
			return $ids;
	}
	
	public static function getSeniorIds($empid, $db)
	{
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$ids = "0";
		
		$parentid=$empid;
		if($parentid!="0" && $parentid!="")
		{
			while($parentid!="")
			{
				$sql1 = "SELECT ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and Id in ( $parentid ) and  DOL='0000-00-00' ";
				
				$query1 = $db->prepare($sql1);
				$query1->execute(array($orgid));
				$parentid="";
				while($row1 = $query1->fetch())
				{
					if($parentid==""){
						$parentid = $row1->ReportingTo;
					}else{
						$parentid .= ", ".$row1->ReportingTo;
					}
					if($ids==""){
						$ids = $row1->ReportingTo;
					}else{
						$ids .= ",".$row1->ReportingTo;
					}
					
				}
				
			}
		}
		//print_r($ids);
			return $ids;
	}
	
	
	public static function getSeniorId($empid, $db)
	{
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$id = "0";
		
		$parentid=$empid;
		if($parentid!="0" && $parentid!="")
		{
				$sql1 = "SELECT ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and Id in ( $parentid ) and  DOL='0000-00-00' ";
				
				$query1 = $db->prepare($sql1);
				$query1->execute(array($orgid));
				$parentid="";
				while($row1 = $query1->fetch())
				{
				$id = $row1->ReportingTo;
					
				}
				
			
		}
			return $id;
	}
	
	public static function getApprovalLevelEmp($empid, $processtype, $db)
	{
		//processtype 0 for ALL, 1 for leave, 2 for salary advance, 3 for document request, 4 for resignation, 5 for termination
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$id = "0";
		//$seniorid=0;
		$designation=0;$gethrID=0;
		$gethrID=Utils::getHRApproval($orgid, $db);
		if($empid!="0" && $empid!="")
		{
			$sql = "SELECT ReportingTo, Designation FROM EmployeeMaster WHERE OrganizationId = ? and Id = ? ";
			$query = $db->prepare($sql);
			$query->execute(array($orgid, $empid));
			while($row = $query->fetch())
			{
				$seniorid = $row->ReportingTo;
				$designation = $row->Designation;
			}
			
			if($seniorid!=0 && $designation !=0)
			{
				/////Designation=0 & ProcessType = 0 if approval not set ////////////////
				$sql = "SELECT RuleCriteria, Designation,HrStatus, Approvalupto FROM ApprovalProcess WHERE OrganizationId = ? and (Designation = ? or Designation=0)  and (ProcessType = ? or ProcessType = 0 ) order by `Designation`,`ProcessType`  desc limit 1";
				$query = $db->prepare($sql);
				$query->execute(array($orgid, $designation, $processtype));
				if($query->rowCount()>0)
				{
					$row = $query->fetch();
					$rule = $row->RuleCriteria;
					$sts = $row->HrStatus;
					$Approvalupto = $row->Approvalupto;
					$Approvalupto1=($Approvalupto-1);
					$reportingto = Utils::getSeniorIds($empid, $db);
					
					$seniorid = "";
					if($rule !=""){
						$sql = "SELECT Id, Designation FROM EmployeeMaster WHERE OrganizationId = ? and DOL='0000-00-00' and Designation in ( $rule )  and Id in ( $reportingto ) order by FIELD(Designation, $rule)";
						///////////sts=0 for all the designation and employee,if sts=1 then hierarchy employee will come//////
						//if($sts==0)
						//$sql = "SELECT Id, Designation FROM EmployeeMaster WHERE OrganizationId = ? and DOL='0000-00-00' and Designation in ( $rule )";
						$query = $db->prepare($sql);
						$query->execute(array($orgid));
						while($row = $query->fetch())
						{
							if($seniorid=="")
							$seniorid = $row->Id;
							else
							$seniorid .= ",".$row->Id;
							
						}
					}if($rule ==""){
						$str = ltrim($reportingto, '0,');
						//$number = rtrim($str, "0");
						//print_r($number);
						$senioridcount=$str;
						$seniorarr = explode(",", $senioridcount);
						/////For Set ApprovalUpto /////////
						//print_r($seniorarr);
						for($j=0;$j<count($seniorarr);$j++){
							
							
								if($seniorid=="")
								$seniorid = $seniorarr[$j];
								else
								$seniorid .= ",".$seniorarr[$j];
							
							if($j==$Approvalupto1){
							break;
							}
						}
					}
					/////End For Set ApprovalUpto /////////
					//print_r($seniorid);
					if($sts!=0){
						
						$temp1 = explode(",", $seniorid);
						for($i=0;$i<count($temp1);$i++)
						{
							if($temp1[$i] == $gethrID){
								unset($temp1[$i]);
							}
						}
						$seniorid.=','.$gethrID;
					}else{
						$seniorid;	
					}
				
				}
			}
		}
		$seniorids=explode(',',$seniorid);
		if(count($seniorids) ==1 && $processtype==1)
		$seniorid.=','.$gethrID;
			
			return $seniorid;
	}
	
	public static function getFiscalId($month, $db)
	{
		$id =0;
		$orgid=$_SESSION['ubihrm_org_id'];
		$sql = "SELECT Id FROM FiscalMaster WHERE OrganizationId=$orgid and ( '$month' between StartDate and EndDate)";
        $query = $db->prepare($sql);
		try{
			$query->execute();
			while($row = $query->fetch())
			{
				$id = $row->Id;
			}
		}catch(Exception $e) {
			
		}
		return $id;
	}
	
	public static function getFiscalIdForApp($orgid, $month, $db)
	{
		$id =0;
		//$orgid=$_SESSION['ubihrm_org_id'];
		 $sql = "SELECT Id FROM FiscalMaster WHERE OrganizationId='$orgid' and ('$month' between StartDate and EndDate)";
		//$sql = "SELECT Id FROM FiscalMaster WHERE OrganizationId=$orgid and ( '$month' between StartDate and EndDate) and FiscalSts=1";
        $query = $db->prepare($sql);
		try{
			$query->execute();
			while($row = $query->fetch())
			{
				$id = $row->Id;
			}
		}catch(Exception $e) {
			
		}
		
		return $id;
	}
	
	public static function getSeniorDesigs($desig,$db)
	{
		
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$ids = "0";
		
		
		$parentid=$desig;
		try{
			if($parentid!="0" && $parentid!="")
			{
				while($parentid!="")
				{
					
					$sql1 = "SELECT RoleId FROM DesignationMaster WHERE OrganizationId = ? and Id in ( $parentid ) ";
					$query1 = $db->prepare($sql1);
					$query1->execute(array($orgid));
					$count=$query1->rowCount();
					$parentid="";
					while($row1 = $query1->fetch())
					{
						if($parentid==""){
							$parentid = $row1->RoleId;
						}else{
							$parentid .= ", ".$row1->RoleId;
						}
						if($ids == "0"){
							$ids = $row1->RoleId;
						}else{
							$ids .= ", ".$row1->RoleId;
						}
					
					}
				}
			}
		}catch(Exception $e){
			
		   $errorMsg = $e->getMessage();
		}
		
		return $ids;
			
	}
	
	public static function getJuniorDesigs($desig,$db)
	{
		
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$ids = "0";
		
		
		$parentid=$desig;
		try{
			if($parentid!="0" && $parentid!="")
			{
				while($parentid!="")
				{
					
					$sql1 = "SELECT Id FROM DesignationMaster WHERE OrganizationId = ? and RoleId in ( $parentid ) ";
					$query1 = $db->prepare($sql1);
					$query1->execute(array($orgid));
					$count=$query1->rowCount();
					$parentid="";
					while($row1 = $query1->fetch())
					{
						if($parentid==""){
							$parentid = $row1->Id;
						}else{
							$parentid .= ", ".$row1->Id;
						}
						if($ids == "0"){
							$ids = $row1->Id;
						}else{
							$ids .= ", ".$row1->Id;
						}
					
					}
				}
			}
		}catch(Exception $e){
			
		   $errorMsg = $e->getMessage();
		}
		
		return $ids;
			
	}
	
	public static function getShiftIdByEmpID($empid, $db)
	{
		$name ="";
		$sql = "SELECT Id FROM `ShiftMaster` where id=(SELECT Shift FROM `EmployeeMaster` where id=$empid)";
	//	Utils::Trace('utils--->'.$sql);
        $query = $db->prepare($sql);
		try{
			$query->execute(array( ));
			while($row = $query->fetch())
			{
				$name = $row->Id;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	////////////////  FETCHING ANNUAL LEAVE FOR EMPLOYEE  //////////////
	public static function getannualleaves($empid,$db)
	{
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		
		$division=0;$department=0; $designation=0; $grade=0; $gender=0; $marital=0; $workingdays=0;
		$divisionflg=false;$departmentflg=false; $designationflg=false; $gradeflg=false; $genderflg=false; $maritalflg=false; $annualleave=0; $halfdays=0;
		
		$sql="select * from EmployeeMaster where OrganizationId=? and Id=?";
		$query = $db->prepare($sql);
		$query->execute(array($orgid,$empid));
		while($row=$query->fetch()){
			$division=$row->Division;
			$department=$row->Department; 
			$designation=$row->Designation; 
			$grade=$row->Grade; 
			$gender=$row->Gender; 
			$marital=$row->MaritalStatus;
			$workingdays=substr_count($row->WorkingDays, '1');
			$halfdays=	substr_count($row->WorkingDays, '2');
			$workingdays=$workingdays+($halfdays * 0.5);	
			$workingdays=Utils::averageWorkingDayWeek($row->Shift,$db);
			
			$sqlleave = "SELECT * FROM LeaveMaster WHERE  OrganizationId = ? and LeaveApply <= CURDATE()  and AnnualLeaveSts=1 ";
			$queryleave = $db->prepare($sqlleave);
			$queryleave->execute(array($orgid));
			$count1 =  $queryleave->rowCount();
			if($count1>=1)
				{
					while($rowleave = $queryleave->fetch())
					{
						$anniversaryyearsts=$rowleave->CarryForward;////if 1 then its calendar/anniversary leave other wise week days/annual leave///
						$divisionflg=true;
						$departmentflg=true; 
						$designationflg=true; 
						$gradeflg=true; 
						$genderflg=true; $maritalflg=true;
						$empflg=false;
						
						$employeeusedleave=0;
						$gradearr=($rowleave->GradeId!=0)?explode(",",$rowleave->GradeId):0;
						
						if($rowleave->LeaveUsableSts==1){
							if($rowleave->DivisionId>0){
								if($rowleave->DivisionId==$division){
									$divisionflg=true;
								}else{$divisionflg=false;}
							}
							if($rowleave->DepartmentIds>0){
								if($rowleave->DepartmentIds==$department){
									$departmentflg=true; 
								}else{$departmentflg=false; }
							}
							if($rowleave->DesignationIds>0){
								if($rowleave->DesignationIds==$designation){
									$designationflg=true; 
								}else{$designationflg=false; }
							}
							if($rowleave->GenderId>0){
								if($rowleave->GenderId==$gender){
									$genderflg=true;
								}else{$genderflg=false;}
							}
							if($rowleave->MaritalId>0){
								if($rowleave->MaritalId==$marital){
									$maritalflg=true;
								}else{$maritalflg=false;}
							}
							
							if($rowleave->GradeId>0){
								/// added by ruchi
								
								if( $gradearr ==0)
									{ //echo "if";
										$gradeflg=true;	
									}elseif( in_array($grade, $gradearr ) ){
										//echo "elseif";
										$gradeflg=true;
									}else{
										//echo "else";
										$gradeflg=false;
									}
								
								
								/// end here
								/* if($rowleave->GradeId==$grade){
									$gradeflg=true; 
								}else{$gradeflg=false; } */
							}
						}elseif($rowleave->LeaveUsableSts==2){
							$divisionflg=false;
							$departmentflg=false; 
							$designationflg=false; 
							$gradeflg=false; 
							$genderflg=false; $maritalflg=false;
							
							if($rowleave->EmployeeIds!="")
							{
								$temp = explode(",", $rowleave->EmployeeIds);
								for($i=0; $i<count($temp); $i++)
								{
									if($empid==$temp[$i]){
										$empflg=true;
										$divisionflg=true;
										$departmentflg=true; 
										$designationflg=true; 
										$gradeflg=true; 
										$genderflg=true; $maritalflg=true;
										break;
									}
									
								}
							}
							
						}
						
						if($divisionflg && $departmentflg && $designationflg && $gradeflg && $genderflg && $maritalflg)
						{							
							
							if($anniversaryyearsts!=1)
							{
								
								if($rowleave->WorkingDays==$workingdays)
								{
									
									$annualleave =(int) $rowleave->LeaveDays;
									
								}
							}else{
								
                                
								$annualleave = (int)$rowleave->LeaveDays;
								
							}
							if($empflg==true)	
								break;
							
						}
					}
					
				}
				
		}	
		
		return $annualleave;
			
			
			
	}
	
	public static function getEmployeeStatus($sts)
	{
		$empsts = 1;   /////////// 1 FOR RESIGNATION 2 FOR TERMINATION /////////////////////////
		if($sts==1){
			return "Resigned"; 
		}else if($sts==2){
			return "Terminated";
		}else {
			return "Absconded";
		}
	}
	public static function sendMail1($to, $fname, $subject, $msg)
	{
		include(LIBS_PATH."PhpMailer/class.phpmailer.php");
		$hostName = "smtp.gmail.com";
		$portName = "587";
		$userName = "harish@ubitechsolutions.com";
		$password = "ubipass2015";
		$fromName = $fname;
		$smtpAuth = true;
		
		$mail = new PHPMailer();
		$mail->IsSMTP();
		$mail->CharSet="UTF-8";
		$mail->Host = $hostName;
		$mail->Port = $portName;
		$mail->Username = $userName;
		$mail->Password = $password;
		$mail->SMTPAuth = $smtpAuth;
		//$to = "support@ubitechsolutions.com";
		$mail->From = $userName;
		$mail->FromName = $fromName;
		$mail->AddAddress($to);
		$mail->AddCC('monika@ubitechsolutions.com');
		$mail->AddReplyTo($userName,'Information');
		
		$mail->IsHTML(true);
		$mail->Subject = $subject;
		$mail->AltBody = $msg;
		$mail->Body = $msg;
		
		if(!$mail->Send()) 
		{
			echo "mail not send";
		}else{
			echo "mail send";
		}
	}
	public static function sendMail($to,$fname,$subject,$msg,$file="",$userName="",$password="")
	{
		if($userName == "")
		{
			$userName=isset($_SESSION['ubihrm_smtpuser'])?$_SESSION['ubihrm_smtpuser']:"ubihrmsupport@ubitechsolutions.com";
		}
			
		// Instantiate a new PHPMailer 
		$mail = new PHPMailer;

		// Tell PHPMailer to use SMTP
		$mail->isSMTP();

		// Replace sender@example.com with your "From" address. 
		// This address must be verified with Amazon SES.
		$mail->setFrom("$userName", $fname);

		// Replace recipient@example.com with a "To" address. If your account 
		// is still in the sandbox, this address must be verified.
		// Also note that you can include several addAddress() lines to send
		// email to multiple recipients.
		$mail->addAddress($to);

		// Replace smtp_username with your Amazon SES SMTP user name.
	//	$mail->Username = 'AKIAINHTNV5UDYHKLUHA';
	//	$mail->Username = 'AKIAXILXCVAKZT55EWO5';
	//	$mail->Username = 'AKIAXILXCVAK6LZ2UKGE';
		$mail->Username = 'AKIAXILXCVAK355GUCDN';

		// Replace smtp_password with your Amazon SES SMTP password.
	//	$mail->Password = 'Aj3bqCkDsPYRWH6impKmMeRXbyspo0yP3/MC1F8j1b4K';
	//	$mail->Password = 'WqwpYpBYftHUPFjJQfYJD/5Yen/5iyPYBxhuXJ5g';
	//	$mail->Password = 'BLCSjcuA3C/7CKRU8b/1DSSwF2mpo6l72jjJ2uMarjjs';
		$mail->Password = 'BKM+DWPLDAJIRsF2un1s8CM55sZ0Ejd/GNwjYDjt8/6C';

		// Specify a configuration set. If you do not want to use a configuration
		// set, comment or remove the next line.
		//$mail->addCustomHeader('X-SES-CONFIGURATION-SET', 'ConfigSet');

		// If you're using Amazon SES in a region other than US West (Oregon), 
		// replace email-smtp.us-west-2.amazonaws.com with the Amazon SES SMTP  
		// endpoint in the appropriate region.
		$mail->Host = 'email-smtp.us-west-2.amazonaws.com';

		// The subject line of the email
		$mail->Subject = $subject;

		// The HTML-formatted body of the email
		$mail->Body = $msg;

		// Tells PHPMailer to use SMTP authentication
		$mail->SMTPAuth = true;

		// Enable TLS encryption over port 587
		$mail->SMTPSecure = 'tls';
		$mail->Port = 587;

		// Tells PHPMailer to send HTML-formatted email
		$mail->isHTML(true);
		
		if($file!="")
		$mail->AddAttachment($file);
		// The alternative email body; this is only displayed when a recipient
		// opens the email in a non-HTML email client. The \r\n represents a 
		// line break.
		//$mail->AltBody = "Email Test\r\nThis email was sent through the Amazon SES SMTP interface using the PHPMailer class.";

		if(!$mail->send()) {
		//echo "Email not sent. " , $mail->ErrorInfo , PHP_EOL;
		$err=$mail->ErrorInfo;
		Utils::Trace($err);
		return false;
		} else {
			Utils::Trace("Mail sent");
		//echo "Email sent!" , PHP_EOL;
		return true;
		}
		
		
	}
	public static function sendMailBak30nov($to,$fname,$subject,$msg,$file="")
	{
		$url = "https://ubipublication.com/UBIHRMNEW/updatefields/sendMailAWS";
                    $ch  = curl_init($url);
                    $arr = array(
                        'to' => $to,
                        'fname' => $fname,
                        'subject' => $subject,
                        'msg' => $msg,
                        'file' => $file
                    );
                    
                    $payload = json_encode($arr);
                    
                    //$arrval = str_replace("\\","",$arrval);
                    Utils::Trace($payload);
                    //attach encoded JSON string to the POST fields
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                    
                    //set the content type to application/json
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        'Content-Type:application/json'
                    ));
                    
                    //return response instead of outputting
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    
                    //execute the POST request
                    $result = curl_exec($ch);
                    Utils::Trace("Result:  ".$result);
                    //close cURL resource
                    curl_close($ch);
					return true;
		/* //include(LIBS_PATH."PhpMailer/class.phpmailer.php"); 
		$hostName = "mail.ubihrm.com";
		$portName = "465";
		$userName = "noreply@ubihrm.com";//$email;
		$password = 'Ubipass@2018#';
		$fromName = $fname;
		$smtpAuth = 'true';
		$mail = new PHPMailer;
		//Enable SMTP debugging. 
		$mail->SMTPDebug = 0;
		//Set PHPMailer to use SMTP.
		$mail->isSMTP();
		//Set SMTP host name                          
		$mail->Host = $hostName;
		//Set this to true if SMTP host requires authentication to send email
		$mail->SMTPAuth = true;
		//Provide username and password     
		$mail->Username = $userName;
		$mail->Password = $password;
		//If SMTP requires TLS encryption then set it
		$mail->SMTPSecure = "ssl";
		//Set TCP port to connect to 
		$mail->Port = 465;
		$mail->From = $userName;  
		$mail->FromName = $fromName;
		//$to="namratamittal@ubitechsolutions.com";
		$mail->addAddress($to);
		//$mail->AddBCC('monika@ubitechsolutions.com');
		$mail->isHTML(true);
		if($file!="")
			$mail->AddAttachment($file);
		$mail->Subject = $subject;
		$mail->Body = $msg;
		$mail->AltBody = "This is the plain text version of the email content";
	//	$to='monika@ubitechsolutions.com';
		
		
		if(!$mail->Send()) 
		{ 
			$err="mail not send";
			$err=$mail->ErrorInfo;
			Utils::Trace($err);
			if($file!="")
			{
			 //$file_size = filesize($file);

				$content = file_get_contents( $file);
				$content = chunk_split(base64_encode($content));
				$uid = md5(uniqid(time()));
				$name = basename($file);
				Utils::Trace($file);
				// header
				$header = "From: ".$fname." <noreply@ubihrm.com>\r\n";
				$header .= "Reply-To: ".$to."\r\n";
				$header .= "MIME-Version: 1.0\r\n";
				$header .= "Content-Type: multipart/mixed; boundary=\"".$uid."\"\r\n\r\n";

				// message & attachment
				$nmessage = "--".$uid."\r\n";
				$nmessage .= "Content-type:text/html; charset=iso-8859-1\r\n";
				$nmessage .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
				$nmessage .= $msg."\r\n\r\n";
				$nmessage .= "--".$uid."\r\n";
				$nmessage .= "Content-Type: application/octet-stream; name=\"$subject.pdf\"\r\n";
				$nmessage .= "Content-Transfer-Encoding: base64\r\n";
				$nmessage .= "Content-Disposition: attachment; filename=\"$subject.pdf\"\r\n\r\n";
				$nmessage .= $content."\r\n\r\n";
				$nmessage .= "--".$uid."--";


				 $sts1=mail($to,$subject,$nmessage,$header);
			//mail('monika@ubitechsolutions.com',$subject,$msg,$headers);
				if($sts1)
				{	
					Utils::Trace("send through mail function with file");
					return true;
				}
				else
				{
						Utils::Trace("not send through mail function with file");
					return false;
				}
			}
			else
			{
				$headers = "MIME-Version: 1.0" . "\r\n";
				$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
				$headers .= "From: $fromName<noreply@ubihrm.com>" . "\r\n";
				
				$sts1=mail($to,$subject,$msg,$headers);
				//mail('monika@ubitechsolutions.com',$subject,$msg,$headers);
				if($sts1)
				{
					Utils::Trace("send through mail function");
					return true;
				}
				else
				{
					Utils::Trace("not send through mail function");
					return false;
				}
			}
		}
		else 
		{ 
			Utils::Trace("send through PHPMAILER");
			return true;
		} */
		
	}
	public static function getOutstandingLoanAmount($empid,$advanceid, $orgid, $db)
	{
		$totalpaid=0; $advanceamout=0; $outstatndingbalance=0;
		
		try{
			$sql = "SELECT AdvanceAmount, ApplyMonth FROM SalaryAdvance WHERE OrganizationId = ? and LeaveStatus=2 and Id=? and LoanSTs=0";
			$query = $db->prepare($sql);
			
			$query->execute(array( $orgid, $advanceid));
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$month = $row->ApplyMonth;
					$advanceamout=$row->AdvanceAmount;
					$sql1 = "SET SQL_BIG_SELECTS=1";
					$query1 = $db->prepare($sql1);
					$query1->execute();

					$sql1 = "SELECT HeadAmount,SalaryMonth FROM SalaryMaster sm, SalaryChild sc WHERE sm.Id=sc.SalaryId and OrganizationId = ? and sm.EmployeeId =? and SalaryMonth in (SELECT InstMonth FROM SalaryAdvanceChild where SalaryAdvanceId=?) and HeadType=2 and HeadId=1";
					$query1 = $db->prepare($sql1);
					$query1->execute(array( $orgid,$empid, $advanceid));
					while($row1 = $query1->fetch())
					{
						$totalpaid += $row1->HeadAmount;
						/* $sql2="SELECT InstAmount FROM `SalaryAdvanceChild` where InstMonth=? and SalaryAdvanceId=?";
						$query2 = $db->prepare($sql2);
						$query2->execute(array( $row1->SalaryMonth, $advanceid));
						if($r1=$query2->fetch())
						{
							$totalpaid += $r1->InstAmount;
						} */
						
					}
				}
			}
			$outstatndingbalance = $advanceamout-$totalpaid;
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		
		return $outstatndingbalance;
	}
	
	public static function getOutstandingLoanAmountsalary($empid,$advanceid, $orgid, $db)
	{
		$totalpaid=0; $advanceamout=0; $outstatndingbalance=0;
		
		try{
			$sql = "SELECT AdvanceAmount, ApplyMonth FROM SalaryAdvanceLoan WHERE OrganizationId = ? and LeaveStatus=2 and Id=? and LoanSTs=0";
			$query = $db->prepare($sql);
			
			$query->execute(array( $orgid, $advanceid));
			$count =  $query->rowCount();
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$month = $row->ApplyMonth;
					$advanceamout=$row->AdvanceAmount;
					$sql1 = "SET SQL_BIG_SELECTS=1";
					$query1 = $db->prepare($sql1);
					$query1->execute();

					$sql1 = "SELECT HeadAmount,SalaryMonth FROM SalaryMaster sm, SalaryChild sc WHERE sm.Id=sc.SalaryId and OrganizationId = ? and sm.EmployeeId =? and SalaryMonth in (SELECT InstMonth FROM SalaryAdvanceChildLoan where SalaryAdvanceId=?) and HeadType=2 and HeadId=35";
					$query1 = $db->prepare($sql1);
					$query1->execute(array( $orgid,$empid, $advanceid));
					while($row1 = $query1->fetch())
					{
						$totalpaid += $row1->HeadAmount;
						/* $sql2="SELECT InstAmount FROM `SalaryAdvanceChild` where InstMonth=? and SalaryAdvanceId=?";
						$query2 = $db->prepare($sql2);
						$query2->execute(array( $row1->SalaryMonth, $advanceid));
						if($r1=$query2->fetch())
						{
							$totalpaid += $r1->InstAmount;
						} */
						
					}
				}
			}
			$outstatndingbalance = $advanceamout-$totalpaid;
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		
		return $outstatndingbalance;
	}
	
	public static function checkseniors($empid, $db)
	{
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$seniorid=Utils::getSeniorId($empid,$db);
		$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and ReportingTo = $empid and  DOL='0000-00-00' ";
		$query1 = $db->prepare($sql1);
		$query1->execute(array($orgid));
		
		while($row1 = $query1->fetch())
		{
			$sql = "Update EmployeeMaster set ReportingTo=? where Id=? ";
			$query = $db->prepare($sql);
			$query->execute(array($seniorid,$row1->Id));
					
		}
				
	}
	
	public static function sendOfficialCommunicationMail($user_email,$user_name, $title, $message)
    {
		require_once(LIBS_PATH."PhpMailer/class.phpmailer.php"); 
        // create PHPMailer object here. This is easily possible as we auto-load the according class(es) via composer
        $mail = new PHPMailer;

        // please look into the config/config.php for much more info on how to use this!
        if (EMAIL_USE_SMTP) {
            // Set mailer to use SMTP
            $mail->IsSMTP();
            //useful for debugging, shows full SMTP errors, config this in config/config.php
            $mail->SMTPDebug = PHPMAILER_DEBUG_MODE;
            // Enable SMTP authentication
            $mail->SMTPAuth = EMAIL_SMTP_AUTH;
            // Enable encryption, usually SSL/TLS
            if (defined('EMAIL_SMTP_ENCRYPTION')) {
                $mail->SMTPSecure = EMAIL_SMTP_ENCRYPTION;
            }
            // Specify host server
            $mail->Host = EMAIL_SMTP_HOST;
            $mail->Username = EMAIL_SMTP_USERNAME;
            $mail->Password = EMAIL_SMTP_PASSWORD;
            $mail->Port = EMAIL_SMTP_PORT;
        } else {
            $mail->IsMail();
        }

        // build the email
        $mail->From = EMAIL_PASSWORD_RESET_FROM_EMAIL;
        $mail->FromName = EMAIL_PASSWORD_RESET_FROM_NAME;
        $mail->AddAddress($user_email);
        $mail->AddBCC('monika@ubitechsolutions.com');
        $mail->Subject = $title;
        //$link = EMAIL_PASSWORD_RESET_URL . '/' . urlencode($user_name) . '/' . urlencode($user_password_reset_hash);
        $mail->Body = $message ;
		$mail->IsHTML(true); 

        // send the mail
        if($mail->Send()) {
            //$_SESSION["feedback_positive"][] = FEEDBACK_PASSWORD_RESET_MAIL_SENDING_SUCCESSFUL;
            return true;
        } else {
            //$_SESSION["feedback_negative"][] = FEEDBACK_PASSWORD_RESET_MAIL_SENDING_ERROR ;
            return false;
        }
    }

	public static function getHR($orgid=1, $db)
	{
		$index=0;
		$orgid=$_SESSION['ubihrm_org_id'];
		$ids=array();
		$sql = "SELECT EmployeeId FROM UserMaster WHERE OrganizationId = ? and HRSts=1 ";
				
		$query = $db->prepare($sql);
		$query->execute(array($orgid));
		$parentid="";
		while($row = $query->fetch())
		{
			$ids[] = $row->EmployeeId;
			/* $sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and Designation=? ";
				
			$query1 = $db->prepare($sql1);
			$query1->execute(array($orgid,$row->Id));
			
			while($row1 = $query1->fetch())
			{
				
				$ids[] = $row1->Id;
								
			} */		
		}
		
		return $ids;
	}
	public static function getHRApproval($orgid=1, $db)
	{
		$index=0;
		$orgid=$_SESSION['ubihrm_org_id'];
		$ids=0;
		$sql = "SELECT EmployeeId FROM UserMaster WHERE OrganizationId = ? and HRSts=1 ";
				
		$query = $db->prepare($sql);
		$query->execute(array($orgid));
		$parentid="";
		while($row = $query->fetch())
		{
			$ids = $row->EmployeeId;
			/* $sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and Designation=? ";
				
			$query1 = $db->prepare($sql1);
			$query1->execute(array($orgid,$row->Id));
			
			while($row1 = $query1->fetch())
			{
				
				$ids[] = $row1->Id;
								
			} */		
		}
		
		return $ids;
	}
	
	///////////////THIS FUNCTIONS IS FOR CHECK PERMISSION FOR ORGANIZATION FOR A PERTICULAR MODULE FOR DASHBOARD/////ON 28 JULY 2017
	
	public static function checkOrgPermission($modid){
		$temp = $_SESSION['org_perm_arr'];
		for($i=0; $i<count($temp); $i++){
			if( $temp[$i]['module']==$modid)
			{
				return ((int)$temp[$i]['view']==1)?true:false;
			}
			
		}
		return false;
	}
	
	  public static function Trace($content)
        {
			try{
					$log_path="public/logs/"; // directory name here like /var/www/html/myfolder/logs/
					if (!file_exists($log_path)) {
					mkdir($log_path, 0777, true);
					}
					$today_date = date("d-M-Y");
					$current_time = date("d-M-Y H:i");
					$filename =  $log_path . str_replace('-','_',$today_date) . "_log.log"; //this is a file name
					$fp = fopen($filename, "a+"); // Open the data file, file points at the end of file
					$fw = fwrite($fp,$current_time . " : " . $content . "\r\n");
					fclose($fp);
			}catch(Exception $e){
			echo $e->getMessage();
			}
        }
		
		public static function averageWorkingDayWeek($shiftid,$db)
		{
			 $orgid=$_SESSION['ubihrm_org_id'];
			 $sql1 = "SELECT * FROM ShiftMasterChild where ShiftId=? and Day in (1,2,3,4,5,6,7)";
			 $query1 = $db->prepare($sql1);
			 $query1->execute(array( $shiftid));		
			 $count=0;
			 while($row1 = $query1->fetch()){
			 $workingday = $row1->WeekOff;
			 $temparr = explode(',',$workingday);
				 foreach($temparr as $value){
					 if($value==0){
						 $count=$count+1;
					 }elseif($value==2){
						 $count=$count+0.5;
					 }
				}
			}
			$count=ceil($count/5);
			return $count;
		}
		
		public static function weekOfMonth($date) {
			//$firstOfMonth = date("Y-m-01", strtotime($date));
			//return intval(date("W", strtotime($date))) - intval(date("W", strtotime($firstOfMonth))) +1;
			 return ceil( date( 'j', strtotime( $date ) ) / 7 );
		}
		
			/*  it returns total no. of employee in an organization */
		public static function getTotalNoEmployee($orgid,$db)
		{
			$total =0;
			//Utils::Trace("Orgid".$orgid);
			$sql = "SELECT count(*) as total FROM EmployeeMaster WHERE OrganizationId = :id";
			$query = $db->prepare($sql);
			try{
				$query->execute(array(':id' => $orgid ));
				while($row = $query->fetch())
				{
					$total = $row->total;
					//Utils::Trace("Total Employee ". $total);
				}
			
			}catch(Exception $e) {
				
			}
			//Utils::Trace($name);
			return $total;
		}
			/*  it returns total no. of employee on job in an organization */
		public static function getTotalOnJobEmployee($orgid,$db)
		{
			$total =0;
			//Utils::Trace("Orgid".$orgid);
			$sql = "SELECT count(*) as total FROM EmployeeMaster WHERE OrganizationId = :id and DOL='0000-00-00'";
			$query = $db->prepare($sql);
			try{
				$query->execute(array(':id' => $orgid ));
				while($row = $query->fetch())
				{
					$total = $row->total;
					//Utils::Trace("Total Employee ". $total);
				}
			
			}catch(Exception $e) {
				
			}
			//Utils::Trace($name);
			return $total;
		}
	public static function checkPermission($modid, $type=1){
	
	$temp = $_SESSION['user_perm_arr'];
	for($i=0; $i<count($temp); $i++){
		if( $temp[$i]['module']==$modid)
		{
			if($type==1)
				return ((int)$temp[$i]['view']==1)?true:false;
			elseif($type==2)
				return ((int)$temp[$i]['edit']==1)?true:false;
			elseif($type==3)
				return ((int)$temp[$i]['delete']==1)?true:false;
			elseif($type==4)
				return ((int)$temp[$i]['add']==1)?true:false;
		}
		
	}
	return false;
}	

	public static function TraceAttendance($content)
        {
			try{
					$log_path="public/AttendanceLogs/"; // directory name here like /var/www/html/myfolder/logs/
					if (!file_exists($log_path)) {
					mkdir($log_path, 0777, true);
					}
					$today_date = date("d-M-Y");
					$current_time = date("d-M-Y H:i");
					$filename =  $log_path . str_replace('-','_',$today_date) . "_log.log"; //this is a file name
					$fp = fopen($filename, "a+"); // Open the data file, file points at the end of file
					$fw = fwrite($fp,$current_time . " : " . $content . "\r\n");
					fclose($fp);
			}catch(Exception $e){
			echo $e->getMessage();
			}
        }
		
		public static function getPreviousyearFiscalId($orgid,$db)
	{
		$id =0;
		//$orgid=$_SESSION['ubihrm_org_id'];
		 $sql = "SELECT * FROM `FiscalMaster` WHERE `OrganizationId`=$orgid and FiscalSts<>1 ORDER BY ID DESC Limit 1";
		//$sql = "SELECT Id FROM FiscalMaster WHERE OrganizationId=$orgid and ( '$month' between StartDate and EndDate) and FiscalSts=1";
        $query = $db->prepare($sql);
		try{
			$query->execute();
			while($row = $query->fetch())
			{
				$id = $row->Id;
			}
		}catch(Exception $e) {
			
		}
		
		return $id;
	}
	
	
}
?>