<?php

/**
 * This is the "base controller class". All other "real" controllers extend this class.
 * Whenever a controller is created, we also
 * 1. initialize a session
 * 2. check if the user is not logged in anymore (session timeout) but has a cookie
 * 3. create a database connection (that will be passed to all models that need a database connection)
 * 4. create a view object
 */
class Alerts
{
	/*Generate action based notifications*/
	public static function generateActionAlerts($sid, $aid, $orgid, $db)
	{
		Utils::Trace("Enter".$sid.$aid);
		
		/*for Task assigned*/	
		  if($sid==19){
			$setdata = Alerts::getSettingData($sid,$orgid,$db);
			if(!$setdata){
				return;
			}
			$hradminarr=Alerts::getAdminHR($orgid,$db);
			$leaddays = $setdata[0]['leaddays'];
			$sWhere = "and DOL='0000-00-00'";
			$sql = "SELECT em.Id, em.Department, tm.assignto, tm.task_title, tm.fromdate as sdate FROM EmployeeMaster em, task_master tm WHERE tm.Id=? and em.Id=tm.assignto and em.OrganizationId=?";
			$query = $db->prepare($sql);
			try{
				$query->execute(array($aid,$orgid));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$alert = $setdata[0]['alert'];
					$mailsend =  $setdata[0]['mailsend'];
					$notifyself = $setdata[0]['notifyself']; 
					$notifysupervisor = $setdata[0]['notifysupervisor'];
					$notifyhradmin = $setdata[0]['notifyhradmin'];
					$notifyteam = $setdata[0]['notifyteam'];
					$notifyjsteam = $setdata[0]['notifyjsteam'];
					$employeeType = $setdata[0]['employeeType'];
					while($row = $query->fetch())
					{
						$ids="";
						if($notifyself==1){
							if($ids=="")
								  $ids = $row->Id;
							 else 
								 $ids.= ",".$row->Id;
						}
						if($notifysupervisor==1){
							 if($ids=="")
								 $ids = Alerts::getSeniorId($row->Id, $orgid, $db);
							 else{
								 $sid= Alerts::getSeniorId($row->Id, $orgid, $db);
								 if($sid)
								 $ids.= ",".Alerts::getSeniorId($row->Id, $orgid, $db);
							 }
						}
						if($notifyhradmin==1){
							 if($ids=="")
								 $ids = implode($hradminarr,",");
							 else{
								 $sid= implode($hradminarr,",");
								 if($sid)
								 $ids.= ",".implode($hradminarr,",");
							 }
						}
						if($notifyteam==1){
							if($ids=="")
								 $ids = implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 else{
								 $sid= implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
								 if($sid)
								$ids.= ",".implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 }
						}
						if($notifyjsteam==1){
							 if($ids=="")
								 $ids = implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
							 else{
									$sid= implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getSeniorIds($row->Id,$orgid, $db),",");
							 }
							 if($ids=="")
								 $ids = implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 else{
								$sid= implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 }
						}
						$emparr = explode(",",$ids);
						$emparr = array_unique($emparr);
						$emparr = array_values($emparr);
						//print_r($emparr);
						 if($employeeType){ 
							$emparr = Alerts::getEmpTypeEmp($employeeType,$emparr,$db);
						  } 
						$cdate=Alerts::staticdateformatter($row->sdate);
						   $msgother = Alerts::getParseMailMessage($setdata[0]['DescOther'],$row->Id,$cdate,$db);
						for($x=0; $x<count($emparr); $x++)
						{	
							$msg="";$title="";
							$title = $setdata[0]['Title'];
							if($emparr[$x]==$row->Id){
								  $msg = Alerts::getParseMailMessage($setdata[0]['DescEmp'],$row->Id,$cdate,$db);
							}else{
								  $msg = $msgother;
							}
							Alerts::CreateNotification($title,$msg,$orgid, $emparr[$x],$db);
							if($alert){
								Alerts::CreateAlert($title,$msg,$orgid, $emparr[$x],$db);
							}
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$db);
								Alerts::CreateMail($title,$msg,$orgid, $emparr[$x],$toemail,$db);
							} 
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		/*for Project assigned*/	
		  else if($sid==20){
			$setdata = Alerts::getSettingData($sid,$orgid,$db);
			if(!$setdata){
				return;
			}
			$hradminarr=Alerts::getAdminHR($orgid,$db);
			$leaddays = $setdata[0]['leaddays'];
			$sWhere = "and  DOL='0000-00-00'";
			$sql = "SELECT em.Id, em.Department, pm.assigned_to, pm.project_title, pm.start_date as sdate FROM EmployeeMaster em, project_master pm WHERE pm.Id=? and FIND_IN_SET(em.Id, pm.assigned_to) and em.OrganizationId=?";
			$query = $db->prepare($sql);
			try{
				$query->execute(array($aid,$orgid));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$alert = $setdata[0]['alert'];
					$mailsend =  $setdata[0]['mailsend'];
					$notifyself = $setdata[0]['notifyself']; 
					$notifysupervisor = $setdata[0]['notifysupervisor'];
					$notifyhradmin = $setdata[0]['notifyhradmin'];
					$notifyteam = $setdata[0]['notifyteam'];
					$notifyjsteam = $setdata[0]['notifyjsteam'];
					$employeeType = $setdata[0]['employeeType'];
					while($row = $query->fetch())
					{
						$ids="";
						if($notifyself==1){
							if($ids=="")
								  $ids = $row->Id;
							 else 
								 $ids.= ",".$row->Id;
						}
						if($notifysupervisor==1){
							 if($ids=="")
								 $ids = Alerts::getSeniorId($row->Id, $orgid, $db);
							 else{
								 $sid= Alerts::getSeniorId($row->Id, $orgid, $db);
								 if($sid)
								 $ids.= ",".Alerts::getSeniorId($row->Id, $orgid, $db);
							 }
						}
						if($notifyhradmin==1){
							 if($ids=="")
								 $ids = implode($hradminarr,",");
							 else{
								 $sid= implode($hradminarr,",");
								 if($sid)
								 $ids.= ",".implode($hradminarr,",");
							 }
						}
						if($notifyteam==1){
							if($ids=="")
								 $ids = implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 else{
								 $sid= implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
								 if($sid)
								$ids.= ",".implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 }
						}
						if($notifyjsteam==1){
							 if($ids=="")
								 $ids = implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
							 else{
									$sid= implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getSeniorIds($row->Id,$orgid, $db),",");
							 }
							 if($ids=="")
								 $ids = implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 else{
								$sid= implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 }
						}
						$emparr = explode(",",$ids);
						$emparr = array_unique($emparr);
						$emparr = array_values($emparr);
						//print_r($emparr);
						 if($employeeType){ 
							$emparr = Alerts::getEmpTypeEmp($employeeType,$emparr,$db);
						  } 
						$cdate=Alerts::staticdateformatter($row->sdate);
						   $msgother = Alerts::getParseMailMessage($setdata[0]['DescOther'],$row->Id,$cdate,$db);
						for($x=0; $x<count($emparr); $x++)
						{	
							$msg="";$title="";
							$title = $setdata[0]['Title'];
							if($emparr[$x]==$row->Id){
								  $msg = Alerts::getParseMailMessage($setdata[0]['DescEmp'],$row->Id,$cdate,$db);
							}else{
								  $msg = $msgother;
							}
							Alerts::CreateNotification($title,$msg,$orgid, $emparr[$x],$db);
							if($alert){
								Alerts::CreateAlert($title,$msg,$orgid, $emparr[$x],$db);
							}
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$db);
								Alerts::CreateMail($title,$msg,$orgid, $emparr[$x],$toemail,$db);
							} 
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		/*for task finished*/	
		  else if($sid==22){
			$setdata = Alerts::getSettingData($sid,$orgid,$db);
			if(!$setdata){
				return;
			}
			$hradminarr=Alerts::getAdminHR($orgid,$db);
			$leaddays = $setdata[0]['leaddays'];
			$sWhere = "and  DOL='0000-00-00'";
			$sql = "SELECT em.Id, em.Department, tm.assignto, tm.task_title, tm.fromdate as sdate FROM EmployeeMaster em, task_master tm WHERE tm.Id=? and em.Id = tm.assignto and em.OrganizationId=?";
			$query = $db->prepare($sql);
			try{
				$query->execute(array($aid,$orgid));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$alert = $setdata[0]['alert'];
					$mailsend =  $setdata[0]['mailsend'];
					$notifyself = $setdata[0]['notifyself']; 
					$notifysupervisor = $setdata[0]['notifysupervisor'];
					$notifyhradmin = $setdata[0]['notifyhradmin'];
					$notifyteam = $setdata[0]['notifyteam'];
					$notifyjsteam = $setdata[0]['notifyjsteam'];
					$employeeType = $setdata[0]['employeeType'];
					while($row = $query->fetch())
					{
						$ids="";
						if($notifyself==1){
							if($ids=="")
								 $ids = $row->Id;
							 else 
								 $ids.= ",".$row->Id;
						}
						if($notifysupervisor==1){
							 if($ids=="")
								 $ids = Alerts::getSeniorId($row->Id, $orgid, $db);
							 else{
								 $sid= Alerts::getSeniorId($row->Id, $orgid, $db);
								 if($sid)
								 $ids.= ",".Alerts::getSeniorId($row->Id, $orgid, $db);
							 }
						}
						if($notifyhradmin==1){
							 if($ids=="")
								 $ids = implode($hradminarr,",");
							 else{
								 $sid= implode($hradminarr,",");
								 if($sid)
								 $ids.= ",".implode($hradminarr,",");
							 }
						}
						if($notifyteam==1){
							if($ids=="")
								 $ids = implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 else{
								 $sid= implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
								 if($sid)
								$ids.= ",".implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 }
						}
						if($notifyjsteam==1){
							 if($ids=="")
								 $ids = implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
							 else{
									$sid= implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getSeniorIds($row->Id,$orgid, $db),",");
							 }
							 if($ids=="")
								 $ids = implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 else{
								$sid= implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 }
						}
						$emparr = explode(",",$ids);
						$emparr = array_unique($emparr);
						$emparr = array_values($emparr);
						//print_r($emparr);
						 if($employeeType){ 
							$emparr = Alerts::getEmpTypeEmp($employeeType,$emparr,$db);
						  } 
						$cdate=Alerts::staticdateformatter($row->sdate);
						   $msgother = Alerts::getParseMailMessage($setdata[0]['DescOther'],$row->Id,$cdate,$db);
						for($x=0; $x<count($emparr); $x++)
						{	
							$msg="";$title="";
							$title = $setdata[0]['Title'];
							if($emparr[$x]==$row->Id){
								  $msg = Alerts::getParseMailMessage($setdata[0]['DescEmp'],$row->Id,$cdate,$db);
							}else{
								  $msg = $msgother;
							}
							Alerts::CreateNotification($title,$msg,$orgid, $emparr[$x],$db);
							if($alert){
								Alerts::CreateAlert($title,$msg,$orgid, $emparr[$x],$db);
							}
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$db);
								Alerts::CreateMail($title,$msg,$orgid, $emparr[$x],$toemail,$db);
							} 
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		/*for salary generated*/	
		  else if($sid==38){
			$setdata = Alerts::getSettingData($sid,$orgid,$db);
			if(!$setdata){
				return;
			}
			$hradminarr=Alerts::getAdminHR($orgid,$db);
			$leaddays = $setdata[0]['leaddays'];
			$sWhere = "and  DOL='0000-00-00'";
			$sql = "SELECT em.Id, em.FirstName, em.Department, sm.SalaryMonth as sdate from EmployeeMaster em, SalaryMaster sm WHERE sm.Id=? and em.Id=sm.EmployeeId and em.OrganizationId=?";
			$query = $db->prepare($sql);
			try{
				$query->execute(array($aid,$orgid));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$alert = $setdata[0]['alert'];
					$mailsend =  $setdata[0]['mailsend'];
					$notifyself = $setdata[0]['notifyself']; 
					$notifysupervisor = $setdata[0]['notifysupervisor'];
					$notifyhradmin = $setdata[0]['notifyhradmin'];
					$notifyteam = $setdata[0]['notifyteam'];
					$notifyjsteam = $setdata[0]['notifyjsteam'];
					$employeeType = $setdata[0]['employeeType'];
					while($row = $query->fetch())
					{
						$ids="";
						if($notifyself==1){
							if($ids=="")
								  $ids = $row->Id;
							 else 
								 $ids.= ",".$row->Id;
						}
						if($notifysupervisor==1){
							 if($ids=="")
								 $ids = Alerts::getSeniorId($row->Id, $orgid, $db);
							 else{
								 $sid= Alerts::getSeniorId($row->Id, $orgid, $db);
								 if($sid)
								 $ids.= ",".Alerts::getSeniorId($row->Id, $orgid, $db);
							 }
						}
						if($notifyhradmin==1){
							 if($ids=="")
								 $ids = implode($hradminarr,",");
							 else{
								 $sid= implode($hradminarr,",");
								 if($sid)
								 $ids.= ",".implode($hradminarr,",");
							 }
						}
						if($notifyteam==1){
							if($ids=="")
								 $ids = implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 else{
								 $sid= implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
								 if($sid)
								$ids.= ",".implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 }
						}
						if($notifyjsteam==1){
							 if($ids=="")
								 $ids = implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
							 else{
									$sid= implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getSeniorIds($row->Id,$orgid, $db),",");
							 }
							 if($ids=="")
								 $ids = implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 else{
								$sid= implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 }
						}
						$emparr = explode(",",$ids);
						$emparr = array_unique($emparr);
						$emparr = array_values($emparr);
						//print_r($emparr);
						 if($employeeType){ 
							$emparr = Alerts::getEmpTypeEmp($employeeType,$emparr,$db);
						  } 
						$cdate=Alerts::staticdateformatter($row->sdate);
						   $msgother = Alerts::getParseMailMessage($setdata[0]['DescOther'],$row->Id,$cdate,$db);
						for($x=0; $x<count($emparr); $x++)
						{	
							$msg="";$title="";
							$title = $setdata[0]['Title'];
							if($emparr[$x]==$row->Id){
								  $msg = Alerts::getParseMailMessage($setdata[0]['DescEmp'],$row->Id,$cdate,$db);
							}else{
								  $msg = $msgother;
							}
							Alerts::CreateNotification($title,$msg,$orgid, $emparr[$x],$db);
							if($alert){
								Alerts::CreateAlert($title,$msg,$orgid, $emparr[$x],$db);
							}
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$db);
								Alerts::CreateMail($title,$msg,$orgid, $emparr[$x],$toemail,$db);
							} 
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		/*for shift change*/	
		  else if($sid==28){
			$setdata = Alerts::getSettingData($sid,$orgid,$db);
			if(!$setdata){
				return;
			}
			$hradminarr=Alerts::getAdminHR($orgid,$db);
			$leaddays = $setdata[0]['leaddays'];
			$sWhere = "and DOL='0000-00-00'";
			$sql = "SELECT em.Id, em.FirstName, em.Department, sm.TimeIn as sdate, sm.TimeOut as tdate from EmployeeMaster em, ShiftMaster sm WHERE em.Id=? and em.Shift=sm.Id and em.OrganizationId=?";
			$query = $db->prepare($sql);
			try{
				$query->execute(array($aid,$orgid));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$alert = $setdata[0]['alert'];
					$mailsend =  $setdata[0]['mailsend'];
					$notifyself = $setdata[0]['notifyself']; 
					$notifysupervisor = $setdata[0]['notifysupervisor'];
					$notifyhradmin = $setdata[0]['notifyhradmin'];
					$notifyteam = $setdata[0]['notifyteam'];
					$notifyjsteam = $setdata[0]['notifyjsteam'];
					$employeeType = $setdata[0]['employeeType'];
					while($row = $query->fetch())
					{
						$ids="";
						if($notifyself==1){
							if($ids=="")
								  $ids = $row->Id;
							 else 
								 $ids.= ",".$row->Id;
						}
						if($notifysupervisor==1){
							 if($ids=="")
								 $ids = Alerts::getSeniorId($row->Id, $orgid, $db);
							 else{
								 $sid= Alerts::getSeniorId($row->Id, $orgid, $db);
								 if($sid)
								 $ids.= ",".Alerts::getSeniorId($row->Id, $orgid, $db);
							 }
						}
						if($notifyhradmin==1){
							 if($ids=="")
								 $ids = implode($hradminarr,",");
							 else{
								 $sid= implode($hradminarr,",");
								 if($sid)
								 $ids.= ",".implode($hradminarr,",");
							 }
						}
						if($notifyteam==1){
							if($ids=="")
								 $ids = implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 else{
								 $sid= implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
								 if($sid)
								$ids.= ",".implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 }
						}
						if($notifyjsteam==1){
							 if($ids=="")
								 $ids = implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
							 else{
									$sid= implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getSeniorIds($row->Id,$orgid, $db),",");
							 }
							 if($ids=="")
								 $ids = implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 else{
								$sid= implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 }
						}
						$emparr = explode(",",$ids);
						$emparr = array_unique($emparr);
						$emparr = array_values($emparr);
						//print_r($emparr);
						 if($employeeType){ 
							$emparr = Alerts::getEmpTypeEmp($employeeType,$emparr,$db);
						  } 
						$cdate=$row->sdate." to ".$row->tdate;
						   $msgother = Alerts::getParseMailMessage($setdata[0]['DescOther'],$row->Id,$cdate,$db);
						for($x=0; $x<count($emparr); $x++)
						{	
							$msg="";$title="";
							$title = $setdata[0]['Title'];
							if($emparr[$x]==$row->Id){
								  $msg = Alerts::getParseMailMessage($setdata[0]['DescEmp'],$row->Id,$cdate,$db);
							}else{
								  $msg = $msgother;
							}
							Alerts::CreateNotification($title,$msg,$orgid, $emparr[$x],$db);
							if($alert){
								Alerts::CreateAlert($title,$msg,$orgid, $emparr[$x],$db);
							}
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$db);
								Alerts::CreateMail($title,$msg,$orgid, $emparr[$x],$toemail,$db);
							} 
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		/*for email change*/	
		  else if($sid==49){
			$setdata = Alerts::getSettingData($sid,$orgid,$db);
			if(!$setdata){
				return;
			}
			$hradminarr=Alerts::getAdminHR($orgid,$db);
			$leaddays = $setdata[0]['leaddays'];
			$sWhere = "and DOL='0000-00-00'";
			$sql = "SELECT Id, FirstName, Department, CURDATE() as sdate from EmployeeMaster WHERE Id=? and OrganizationId=?";
			$query = $db->prepare($sql);
			try{
				$query->execute(array($aid,$orgid));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$alert = $setdata[0]['alert'];
					$mailsend =  $setdata[0]['mailsend'];
					$notifyself = $setdata[0]['notifyself']; 
					$notifysupervisor = $setdata[0]['notifysupervisor'];
					$notifyhradmin = $setdata[0]['notifyhradmin'];
					$notifyteam = $setdata[0]['notifyteam'];
					$notifyjsteam = $setdata[0]['notifyjsteam'];
					$employeeType = $setdata[0]['employeeType'];
					while($row = $query->fetch())
					{
						$ids="";
						if($notifyself==1){
							if($ids=="")
								  $ids = $row->Id;
							 else 
								 $ids.= ",".$row->Id;
						}
						if($notifysupervisor==1){
							 if($ids=="")
								 $ids = Alerts::getSeniorId($row->Id, $orgid, $db);
							 else{
								 $sid= Alerts::getSeniorId($row->Id, $orgid, $db);
								 if($sid)
								 $ids.= ",".Alerts::getSeniorId($row->Id, $orgid, $db);
							 }
						}
						if($notifyhradmin==1){
							 if($ids=="")
								 $ids = implode($hradminarr,",");
							 else{
								 $sid= implode($hradminarr,",");
								 if($sid)
								 $ids.= ",".implode($hradminarr,",");
							 }
						}
						if($notifyteam==1){
							if($ids=="")
								 $ids = implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 else{
								 $sid= implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
								 if($sid)
								$ids.= ",".implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 }
						}
						if($notifyjsteam==1){
							 if($ids=="")
								 $ids = implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
							 else{
									$sid= implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getSeniorIds($row->Id,$orgid, $db),",");
							 }
							 if($ids=="")
								 $ids = implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 else{
								$sid= implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 }
						}
						$emparr = explode(",",$ids);
						$emparr = array_unique($emparr);
						$emparr = array_values($emparr);
						//print_r($emparr);
						 if($employeeType){ 
							$emparr = Alerts::getEmpTypeEmp($employeeType,$emparr,$db);
						  } 
						$cdate=$row->sdate;
						   $msgother = Alerts::getParseMailMessage($setdata[0]['DescOther'],$row->Id,$cdate,$db);
						for($x=0; $x<count($emparr); $x++)
						{	
							$msg="";$title="";
							$title = $setdata[0]['Title'];
							if($emparr[$x]==$row->Id){
								  $msg = Alerts::getParseMailMessage($setdata[0]['DescEmp'],$row->Id,$cdate,$db);
							}else{
								  $msg = $msgother;
							}
							Alerts::CreateNotification($title,$msg,$orgid, $emparr[$x],$db);
							if($alert){
								Alerts::CreateAlert($title,$msg,$orgid, $emparr[$x],$db);
							}
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$db);
								Alerts::CreateMail($title,$msg,$orgid, $emparr[$x],$toemail,$db);
							} 
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		/*for change reporting manager*/	
		  else if($sid==50){
			$setdata = Alerts::getSettingData($sid,$orgid,$db);
			if(!$setdata){
				return;
			}
			$hradminarr=Alerts::getAdminHR($orgid,$db);
			$leaddays = $setdata[0]['leaddays'];
			$sWhere = "and DOL='0000-00-00'";
			$sql = "SELECT Id, FirstName, Department, CURDATE() as sdate from EmployeeMaster WHERE Id=? and OrganizationId=?";
			$query = $db->prepare($sql);
			try{
				$query->execute(array($aid,$orgid));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$alert = $setdata[0]['alert'];
					$mailsend =  $setdata[0]['mailsend'];
					$notifyself = $setdata[0]['notifyself']; 
					$notifysupervisor = $setdata[0]['notifysupervisor'];
					$notifyhradmin = $setdata[0]['notifyhradmin'];
					$notifyteam = $setdata[0]['notifyteam'];
					$notifyjsteam = $setdata[0]['notifyjsteam'];
					$employeeType = $setdata[0]['employeeType'];
					while($row = $query->fetch())
					{
						$ids="";
						if($notifyself==1){
							if($ids=="")
								  $ids = $row->Id;
							 else 
								 $ids.= ",".$row->Id;
						}
						if($notifysupervisor==1){
							 if($ids=="")
								 $ids = Alerts::getSeniorId($row->Id, $orgid, $db);
							 else{
								 $sid= Alerts::getSeniorId($row->Id, $orgid, $db);
								 if($sid)
								 $ids.= ",".Alerts::getSeniorId($row->Id, $orgid, $db);
							 }
						}
						if($notifyhradmin==1){
							 if($ids=="")
								 $ids = implode($hradminarr,",");
							 else{
								 $sid= implode($hradminarr,",");
								 if($sid)
								 $ids.= ",".implode($hradminarr,",");
							 }
						}
						if($notifyteam==1){
							if($ids=="")
								 $ids = implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 else{
								 $sid= implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
								 if($sid)
								$ids.= ",".implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 }
						}
						if($notifyjsteam==1){
							 if($ids=="")
								 $ids = implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
							 else{
									$sid= implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getSeniorIds($row->Id,$orgid, $db),",");
							 }
							 if($ids=="")
								 $ids = implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 else{
								$sid= implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 }
						}
						$emparr = explode(",",$ids);
						$emparr = array_unique($emparr);
						$emparr = array_values($emparr);
						//print_r($emparr);
						 if($employeeType){ 
							$emparr = Alerts::getEmpTypeEmp($employeeType,$emparr,$db);
						  } 
						$cdate=$row->sdate;
						   $msgother = Alerts::getParseMailMessage($setdata[0]['DescOther'],$row->Id,$cdate,$db);
						for($x=0; $x<count($emparr); $x++)
						{	
							$msg="";$title="";
							$title = $setdata[0]['Title'];
							if($emparr[$x]==$row->Id){
								  $msg = Alerts::getParseMailMessage($setdata[0]['DescEmp'],$row->Id,$cdate,$db);
							}else{
								  $msg = $msgother;
							}
							Alerts::CreateNotification($title,$msg,$orgid, $emparr[$x],$db);
							if($alert){
								Alerts::CreateAlert($title,$msg,$orgid, $emparr[$x],$db);
							}
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$db);
								Alerts::CreateMail($title,$msg,$orgid, $emparr[$x],$toemail,$db);
							} 
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		/*for requested leave*/	
		  else if($sid==35){
			$setdata = Alerts::getSettingData($sid,$orgid,$db);
			if(!$setdata){
				return;
			}
			$hradminarr=Alerts::getAdminHR($orgid,$db);
			$leaddays = $setdata[0]['leaddays'];
			$sWhere = "and DOL='0000-00-00'";
			$sql = "SELECT em.Id, em.FirstName, em.Department, el.LeaveFrom as sdate, el.LeaveTo as tdate, (Select Name from LeaveMaster where Id = el.LeaveTypeId) as leavetypename from EmployeeMaster em, EmployeeLeave el WHERE el.Id=? and el.LeaveStatus=3 and em.Id=el.EmployeeId and em.OrganizationId=?";
			$query = $db->prepare($sql);
			try{
				$query->execute(array($aid,$orgid));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$alert = $setdata[0]['alert'];
					$mailsend =  $setdata[0]['mailsend'];
					$notifyself = $setdata[0]['notifyself']; 
					$notifysupervisor = $setdata[0]['notifysupervisor'];
					$notifyhradmin = $setdata[0]['notifyhradmin'];
					$notifyteam = $setdata[0]['notifyteam'];
					$notifyjsteam = $setdata[0]['notifyjsteam'];
					$employeeType = $setdata[0]['employeeType'];
					while($row = $query->fetch())
					{
						$ids="";
						if($notifyself==1){
							if($ids=="")
								  $ids = $row->Id;
							 else 
								 $ids.= ",".$row->Id;
						}
						if($notifysupervisor==1){
							 if($ids=="")
								 $ids = Alerts::getSeniorId($row->Id, $orgid, $db);
							 else{
								 $sid= Alerts::getSeniorId($row->Id, $orgid, $db);
								 if($sid)
								 $ids.= ",".Alerts::getSeniorId($row->Id, $orgid, $db);
							 }
						}
						if($notifyhradmin==1){
							 if($ids=="")
								 $ids = implode($hradminarr,",");
							 else{
								 $sid= implode($hradminarr,",");
								 if($sid)
								 $ids.= ",".implode($hradminarr,",");
							 }
						}
						if($notifyteam==1){
							if($ids=="")
								 $ids = implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 else{
								 $sid= implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
								 if($sid)
								$ids.= ",".implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 }
						}
						if($notifyjsteam==1){
							 if($ids=="")
								 $ids = implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
							 else{
									$sid= implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getSeniorIds($row->Id,$orgid, $db),",");
							 }
							 if($ids=="")
								 $ids = implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 else{
								$sid= implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 }
						}
						$emparr = explode(",",$ids);
						$emparr = array_unique($emparr);
						$emparr = array_values($emparr);
						//print_r($emparr);
						 if($employeeType){ 
							$emparr = Alerts::getEmpTypeEmp($employeeType,$emparr,$db);
						  } 
						  $cdate="";
						  if($row->sdate==$row->tdate){
							  $cdate=Alerts::staticdateformatter($row->sdate);
						  }
						  else{
							  $cdate=Alerts::staticdateformatter($row->sdate)." to ".Alerts::staticdateformatter($row->tdate);
						  }
						   $msgother = Alerts::getParseMailMessage($setdata[0]['DescOther'],$row->Id,$cdate,$db);
						for($x=0; $x<count($emparr); $x++)
						{	
							$msg="";$title="";
							$title = $setdata[0]['Title'];
							if($emparr[$x]==$row->Id){
								  $msg = Alerts::getParseMailMessage($setdata[0]['DescEmp'],$row->Id,$cdate,$db);
							}else{
								  $msg = $msgother;
							}
							$msg =str_replace('{LeaveType}',$row->leavetypename,$msg);
							Alerts::CreateNotification($title,$msg,$orgid, $emparr[$x],$db);
							if($alert){
								Alerts::CreateAlert($title,$msg,$orgid, $emparr[$x],$db);
							}
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$db);
								Alerts::CreateMail($title,$msg,$orgid, $emparr[$x],$toemail,$db);
							} 
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		/*for approved leave*/	
		  else if($sid==52){
			$setdata = Alerts::getSettingData($sid,$orgid,$db);
			if(!$setdata){
				return;
			}
			$hradminarr=Alerts::getAdminHR($orgid,$db);
			$leaddays = $setdata[0]['leaddays'];
			$sWhere = "and DOL='0000-00-00'";
			$sql = "SELECT em.Id, em.FirstName, em.Department, el.LeaveFrom as sdate, el.LeaveTo as tdate, (Select Name from LeaveMaster where Id = el.LeaveTypeId) as leavetypename from EmployeeMaster em, EmployeeLeave el WHERE el.Id=? and el.LeaveStatus=2 and em.Id=el.EmployeeId and em.OrganizationId=?";
			$query = $db->prepare($sql);
			try{
				$query->execute(array($aid,$orgid));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$alert = $setdata[0]['alert'];
					$mailsend =  $setdata[0]['mailsend'];
					$notifyself = $setdata[0]['notifyself']; 
					$notifysupervisor = $setdata[0]['notifysupervisor'];
					$notifyhradmin = $setdata[0]['notifyhradmin'];
					$notifyteam = $setdata[0]['notifyteam'];
					$notifyjsteam = $setdata[0]['notifyjsteam'];
					$employeeType = $setdata[0]['employeeType'];
					while($row = $query->fetch())
					{
						$ids="";
						if($notifyself==1){
							if($ids=="")
								  $ids = $row->Id;
							 else 
								 $ids.= ",".$row->Id;
						}
						if($notifysupervisor==1){
							 if($ids=="")
								 $ids = Alerts::getSeniorId($row->Id, $orgid, $db);
							 else{
								 $sid= Alerts::getSeniorId($row->Id, $orgid, $db);
								 if($sid)
								 $ids.= ",".Alerts::getSeniorId($row->Id, $orgid, $db);
							 }
						}
						if($notifyhradmin==1){
							 if($ids=="")
								 $ids = implode($hradminarr,",");
							 else{
								 $sid= implode($hradminarr,",");
								 if($sid)
								 $ids.= ",".implode($hradminarr,",");
							 }
						}
						if($notifyteam==1){
							if($ids=="")
								 $ids = implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 else{
								 $sid= implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
								 if($sid)
								$ids.= ",".implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 }
						}
						if($notifyjsteam==1){
							 if($ids=="")
								 $ids = implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
							 else{
									$sid= implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getSeniorIds($row->Id,$orgid, $db),",");
							 }
							 if($ids=="")
								 $ids = implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 else{
								$sid= implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 }
						}
						$emparr = explode(",",$ids);
						$emparr = array_unique($emparr);
						$emparr = array_values($emparr);
						//print_r($emparr);
						 if($employeeType){ 
							$emparr = Alerts::getEmpTypeEmp($employeeType,$emparr,$db);
						  } 
						  $cdate="";
						  if($row->sdate==$row->tdate){
							  $cdate=Alerts::staticdateformatter($row->sdate);
						  }
						  else{
							  $cdate=Alerts::staticdateformatter($row->sdate)." to ".Alerts::staticdateformatter($row->tdate);
						  }
						   $msgother = Alerts::getParseMailMessage($setdata[0]['DescOther'],$row->Id,$cdate,$db);
						for($x=0; $x<count($emparr); $x++)
						{	
							$msg="";$title="";
							$title = $setdata[0]['Title'];
							if($emparr[$x]==$row->Id){
								  $msg = Alerts::getParseMailMessage($setdata[0]['DescEmp'],$row->Id,$cdate,$db);
							}else{
								  $msg = $msgother;
							}
							$msg =str_replace('{LeaveType}',$row->leavetypename,$msg);
							Alerts::CreateNotification($title,$msg,$orgid, $emparr[$x],$db);
							if($alert){
								Alerts::CreateAlert($title,$msg,$orgid, $emparr[$x],$db);
							}
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$db);
								Alerts::CreateMail($title,$msg,$orgid, $emparr[$x],$toemail,$db);
							} 
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		/*for requested time off*/	
		  else if($sid==36){
			$setdata = Alerts::getSettingData($sid,$orgid,$db);
			if(!$setdata){
				return;
			}
			$hradminarr=Alerts::getAdminHR($orgid,$db);
			$leaddays = $setdata[0]['leaddays'];
			$sWhere = "and DOL='0000-00-00'";
			$sql = "SELECT em.Id, em.FirstName, em.Department, t.TimeFrom as sdate, t.TimeTo as tdate from EmployeeMaster em, Timeoff t WHERE t.Id=? and em.Id=t.EmployeeId and t.ApprovalSts=3 and em.OrganizationId=?";
			$query = $db->prepare($sql);
			try{
				$query->execute(array($aid,$orgid));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$alert = $setdata[0]['alert'];
					$mailsend =  $setdata[0]['mailsend'];
					$notifyself = $setdata[0]['notifyself']; 
					$notifysupervisor = $setdata[0]['notifysupervisor'];
					$notifyhradmin = $setdata[0]['notifyhradmin'];
					$notifyteam = $setdata[0]['notifyteam'];
					$notifyjsteam = $setdata[0]['notifyjsteam'];
					$employeeType = $setdata[0]['employeeType'];
					while($row = $query->fetch())
					{
						$ids="";
						if($notifyself==1){
							if($ids=="")
								  $ids = $row->Id;
							 else 
								 $ids.= ",".$row->Id;
						}
						if($notifysupervisor==1){
							 if($ids=="")
								 $ids = Alerts::getSeniorId($row->Id, $orgid, $db);
							 else{
								 $sid= Alerts::getSeniorId($row->Id, $orgid, $db);
								 if($sid)
								 $ids.= ",".Alerts::getSeniorId($row->Id, $orgid, $db);
							 }
						}
						if($notifyhradmin==1){
							 if($ids=="")
								 $ids = implode($hradminarr,",");
							 else{
								 $sid= implode($hradminarr,",");
								 if($sid)
								 $ids.= ",".implode($hradminarr,",");
							 }
						}
						if($notifyteam==1){
							if($ids=="")
								
								 $ids = implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 else{
								 $sid= implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
								 if($sid)
								$ids.= ",".implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 }
						}
						if($notifyjsteam==1){
							 if($ids=="")
								 $ids = implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
							 else{
									$sid= implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getSeniorIds($row->Id,$orgid, $db),",");
							 }
							 if($ids=="")
								 $ids = implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 else{
								$sid= implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 }
						}
						$emparr = explode(",",$ids);
						$emparr = array_unique($emparr);
						$emparr = array_values($emparr);
						//print_r($emparr);
						 if($employeeType){ 
							$emparr = Alerts::getEmpTypeEmp($employeeType,$emparr,$db);
						  } 
							$cdate=$row->sdate." to ".$row->tdate;
						   $msgother = Alerts::getParseMailMessage($setdata[0]['DescOther'],$row->Id,$cdate,$db);
						for($x=0; $x<count($emparr); $x++)
						{	
							$msg="";$title="";
							$title = $setdata[0]['Title'];
							if($emparr[$x]==$row->Id){
								  $msg = Alerts::getParseMailMessage($setdata[0]['DescEmp'],$row->Id,$cdate,$db);
							}else{
								  $msg = $msgother;
							}
							Alerts::CreateNotification($title,$msg,$orgid, $emparr[$x],$db);
							if($alert){
								Alerts::CreateAlert($title,$msg,$orgid, $emparr[$x],$db);
							}
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$db);
								Alerts::CreateMail($title,$msg,$orgid, $emparr[$x],$toemail,$db);
							} 
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		/*for approved time off*/	
		  else if($sid==53){
			$setdata = Alerts::getSettingData($sid,$orgid,$db);
			if(!$setdata){
				return;
			}
			$hradminarr=Alerts::getAdminHR($orgid,$db);
			$leaddays = $setdata[0]['leaddays'];
			$sWhere = "and DOL='0000-00-00'";
			$sql = "SELECT em.Id, em.FirstName, em.Department, t.TimeFrom as sdate, t.TimeTo as tdate from EmployeeMaster em, Timeoff t WHERE t.Id=? and em.Id=t.EmployeeId and t.ApprovalSts=2 and em.OrganizationId=?";
			$query = $db->prepare($sql);
			try{
				$query->execute(array($aid,$orgid));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$alert = $setdata[0]['alert'];
					$mailsend =  $setdata[0]['mailsend'];
					$notifyself = $setdata[0]['notifyself']; 
					$notifysupervisor = $setdata[0]['notifysupervisor'];
					$notifyhradmin = $setdata[0]['notifyhradmin'];
					$notifyteam = $setdata[0]['notifyteam'];
					$notifyjsteam = $setdata[0]['notifyjsteam'];
					$employeeType = $setdata[0]['employeeType'];
					while($row = $query->fetch())
					{
						$ids="";
						if($notifyself==1){
							if($ids=="")
								  $ids = $row->Id;
							 else 
								 $ids.= ",".$row->Id;
						}
						if($notifysupervisor==1){
							 if($ids=="")
								 $ids = Alerts::getSeniorId($row->Id, $orgid, $db);
							 else{
								 $sid= Alerts::getSeniorId($row->Id, $orgid, $db);
								 if($sid)
								 $ids.= ",".Alerts::getSeniorId($row->Id, $orgid, $db);
							 }
						}
						if($notifyhradmin==1){
							 if($ids=="")
								 $ids = implode($hradminarr,",");
							 else{
								 $sid= implode($hradminarr,",");
								 if($sid)
								 $ids.= ",".implode($hradminarr,",");
							 }
						}
						if($notifyteam==1){
							if($ids=="")
								 $ids = implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 else{
								 $sid= implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
								 if($sid)
								$ids.= ",".implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 }
						}
						if($notifyjsteam==1){
							 if($ids=="")
								 $ids = implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
							 else{
									$sid= implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getSeniorIds($row->Id,$orgid, $db),",");
							 }
							 if($ids=="")
								 $ids = implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 else{
								$sid= implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 }
						}
						$emparr = explode(",",$ids);
						$emparr = array_unique($emparr);
						$emparr = array_values($emparr);
						//print_r($emparr);
						 if($employeeType){ 
							$emparr = Alerts::getEmpTypeEmp($employeeType,$emparr,$db);
						  } 
							$cdate=$row->sdate." to ".$row->tdate;
						   $msgother = Alerts::getParseMailMessage($setdata[0]['DescOther'],$row->Id,$cdate,$db);
						for($x=0; $x<count($emparr); $x++)
						{	
							$msg="";$title="";
							$title = $setdata[0]['Title'];
							if($emparr[$x]==$row->Id){
								  $msg = Alerts::getParseMailMessage($setdata[0]['DescEmp'],$row->Id,$cdate,$db);
							}else{
								  $msg = $msgother;
							}
							Alerts::CreateNotification($title,$msg,$orgid, $emparr[$x],$db);
							if($alert){
								Alerts::CreateAlert($title,$msg,$orgid, $emparr[$x],$db);
							}
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$db);
								Alerts::CreateMail($title,$msg,$orgid, $emparr[$x],$toemail,$db);
							} 
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		/*for leave request rejected*/	
		  else if($sid==59){
			$setdata = Alerts::getSettingData($sid,$orgid,$db);
			if(!$setdata){
				return;
			}
			$hradminarr=Alerts::getAdminHR($orgid,$db);
			$leaddays = $setdata[0]['leaddays'];
			$sWhere = "and DOL='0000-00-00'";
			$sql = "SELECT em.Id, em.FirstName, em.Department, el.LeaveFrom as sdate, el.LeaveTo as tdate, (Select Name from LeaveMaster where Id = el.LeaveTypeId) as leavetypename from EmployeeMaster em, EmployeeLeave el WHERE el.Id=? and el.LeaveStatus=1 and em.Id=el.EmployeeId and em.OrganizationId=?";
			$query = $db->prepare($sql);
			try{
				$query->execute(array($aid,$orgid));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$alert = $setdata[0]['alert'];
					$mailsend =  $setdata[0]['mailsend'];
					$notifyself = $setdata[0]['notifyself'];
					$notifysupervisor = $setdata[0]['notifysupervisor'];
					$notifyhradmin = $setdata[0]['notifyhradmin'];
					$notifyteam = $setdata[0]['notifyteam'];
					$notifyjsteam = $setdata[0]['notifyjsteam'];
					$employeeType = $setdata[0]['employeeType'];
					while($row = $query->fetch())
					{
						$ids="";
						if($notifyself==1){
							if($ids=="")
								  $ids = $row->Id;
							 else 
								 $ids.= ",".$row->Id;
						}
						if($notifysupervisor==1){
							 if($ids=="")
								 $ids = Alerts::getSeniorId($row->Id, $orgid, $db);
							 else{
								 $sid= Alerts::getSeniorId($row->Id, $orgid, $db);
								 if($sid)
								 $ids.= ",".Alerts::getSeniorId($row->Id, $orgid, $db);
							 }
						}
						if($notifyhradmin==1){
							 if($ids=="")
								 $ids = implode($hradminarr,",");
							 else{
								 $sid= implode($hradminarr,",");
								 if($sid)
								 $ids.= ",".implode($hradminarr,",");
							 }
						}
						if($notifyteam==1){
							if($ids=="")
								 $ids = implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 else{
								 $sid= implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
								 if($sid)
								$ids.= ",".implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 }
						}
						if($notifyjsteam==1){
							 if($ids=="")
								 $ids = implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
							 else{
									$sid= implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getSeniorIds($row->Id,$orgid, $db),",");
							 }
							 if($ids=="")
								 $ids = implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 else{
								$sid= implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 }
						}
						$emparr = explode(",",$ids);
						$emparr = array_unique($emparr);
						$emparr = array_values($emparr);
						//print_r($emparr);
						 if($employeeType){ 
							$emparr = Alerts::getEmpTypeEmp($employeeType,$emparr,$db);
						  } 
						  $cdate="";
						  if($row->sdate==$row->tdate){
							  $cdate=Alerts::staticdateformatter($row->sdate);
						  }
						  else{
							  $cdate=Alerts::staticdateformatter($row->sdate)." to ".Alerts::staticdateformatter($row->tdate);
						  }
						   $msgother = Alerts::getParseMailMessage($setdata[0]['DescOther'],$row->Id,$cdate,$db);
						for($x=0; $x<count($emparr); $x++)
						{	
							$msg="";$title="";
							$title = $setdata[0]['Title'];
							if($emparr[$x]==$row->Id){
								  $msg = Alerts::getParseMailMessage($setdata[0]['DescEmp'],$row->Id,$cdate,$db);
							}else{
								  $msg = $msgother;
							}
							$msg =str_replace('{LeaveType}',$row->leavetypename,$msg);
							Alerts::CreateNotification($title,$msg,$orgid, $emparr[$x],$db);
							if($alert){
								Alerts::CreateAlert($title,$msg,$orgid, $emparr[$x],$db);
							}
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$db);
								Alerts::CreateMail($title,$msg,$orgid, $emparr[$x],$toemail,$db);
							} 
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		/*for time off request rejected*/	
		  else if($sid==60){
			$setdata = Alerts::getSettingData($sid,$orgid,$db);
			if(!$setdata){
				return;
			}
			$hradminarr=Alerts::getAdminHR($orgid,$db);
			$leaddays = $setdata[0]['leaddays'];
			$sWhere = "and DOL='0000-00-00'";
			$sql = "SELECT em.Id, em.FirstName, em.Department, t.TimeFrom as sdate, t.TimeTo as tdate from EmployeeMaster em, Timeoff t WHERE t.Id=? and em.Id=t.EmployeeId and t.ApprovalSts=1 and em.OrganizationId=?";
			$query = $db->prepare($sql);
			try{
				$query->execute(array($aid,$orgid));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$alert = $setdata[0]['alert'];
					$mailsend =  $setdata[0]['mailsend'];
					$notifyself = $setdata[0]['notifyself']; 
					$notifysupervisor = $setdata[0]['notifysupervisor'];
					$notifyhradmin = $setdata[0]['notifyhradmin'];
					$notifyteam = $setdata[0]['notifyteam'];
					$notifyjsteam = $setdata[0]['notifyjsteam'];
					$employeeType = $setdata[0]['employeeType'];
					while($row = $query->fetch())
					{
						$ids="";
						if($notifyself==1){
							if($ids=="")
								  $ids = $row->Id;
							 else 
								 $ids.= ",".$row->Id;
						}
						if($notifysupervisor==1){
							 if($ids=="")
								 $ids = Alerts::getSeniorId($row->Id, $orgid, $db);
							 else{
								 $sid= Alerts::getSeniorId($row->Id, $orgid, $db);
								 if($sid)
								 $ids.= ",".Alerts::getSeniorId($row->Id, $orgid, $db);
							 }
						}
						if($notifyhradmin==1){
							 if($ids=="")
								 $ids = implode($hradminarr,",");
							 else{
								 $sid= implode($hradminarr,",");
								 if($sid)
								 $ids.= ",".implode($hradminarr,",");
							 }
						}
						if($notifyteam==1){
							if($ids=="")
								 $ids = implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 else{
								 $sid= implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
								 if($sid)
								$ids.= ",".implode(Alerts::getDepTeamIds($row->Department, $orgid,$db),",");
							 }
						}
						if($notifyjsteam==1){
							 if($ids=="")
								 $ids = implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
							 else{
									$sid= implode(Alerts::getSeniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getSeniorIds($row->Id,$orgid, $db),",");
							 }
							 if($ids=="")
								 $ids = implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 else{
								$sid= implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
								 if($sid)
									$ids.= ",".implode(Alerts::getJuniorIds($row->Id, $orgid, $db),",");
							 }
						}
						$emparr = explode(",",$ids);
						$emparr = array_unique($emparr);
						$emparr = array_values($emparr);
						//print_r($emparr);
						 if($employeeType){ 
							$emparr = Alerts::getEmpTypeEmp($employeeType,$emparr,$db);
						  } 
							$cdate=$row->sdate." to ".$row->tdate;
						   $msgother = Alerts::getParseMailMessage($setdata[0]['DescOther'],$row->Id,$cdate,$db);
						for($x=0; $x<count($emparr); $x++)
						{	
							$msg="";$title="";
							$title = $setdata[0]['Title'];
							if($emparr[$x]==$row->Id){
								  $msg = Alerts::getParseMailMessage($setdata[0]['DescEmp'],$row->Id,$cdate,$db);
							}else{
								  $msg = $msgother;
							}
							Alerts::CreateNotification($title,$msg,$orgid, $emparr[$x],$db);
							if($alert){
								Alerts::CreateAlert($title,$msg,$orgid, $emparr[$x],$db);
							}
							if($mailsend){
								$toemail=Utils::getName($emparr[$x], 'EmployeeMaster','CompanyEmail',$db);
								Alerts::CreateMail($title,$msg,$orgid, $emparr[$x],$toemail,$db);
							} 
						}
					}
				}
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		}
		
		return true;
	}		
	
	public static function CreateNotification($title,$msg,$orgid, $empid,$db)
	{
		$count=0;
		$mdate= date("Y-m-d H:i:s");
		try{
				$sql1 = "SELECT Id FROM GenerateNotification WHERE  OrganizationId = ? and EmployeeId =? and Title =? and Message =? and NotifyDate=CURDATE()";
				$query1 = $db->prepare($sql1);
				$query1->execute(array( $orgid,$empid,$title,$msg ));
				$count=$query1->rowCount();
				if($count == 0){
					$sql1 = "INSERT INTO GenerateNotification (EmployeeId, Title, Message, NotifyDate, OrganizationId) VALUES (?, ?, ?, ?, ?)";
					$query1 = $db->prepare($sql1);
					$query1->execute(array( $empid,$title,$msg,$mdate,$orgid ));
				}
				
		}
		catch(Exception $e){
		}
	
	}
	
	public static function CreateAlert($title,$msg,$orgid, $empid,$db)
	{
		$count=0;
		$mdate= date("Y-m-d H:i:s");
		try{
				$sql1 = "SELECT Id FROM GenerateNotification WHERE  OrganizationId = ? and EmployeeId =? and Title =? and Message =? and NotifyDate=CURDATE() and AlertSts = 0";
				$query1 = $db->prepare($sql1);
				$query1->execute(array( $orgid,$empid,$title,$msg ));
				$count=$query1->rowCount();
				if($count >= 1){
					$r=$query1->fetch();
					$sql = "Update GenerateNotification set AlertSts = 1 where Id =?";
					$query = $db->prepare($sql);
					$query->execute(array($r->Id));
					return 1;
				}
				return;
		}
		catch(Exception $e){
		}
	}
	
	public static function CreateMail($title,$msg,$orgid, $empid, $to,$db)
	{
		$count=0;
		$mdate= date("Y-m-d H:i:s");
		try{
				$orgname = Utils::getName($orgid,"Organization", "Name", $db);
				$sql1 = "SELECT Id FROM GenerateNotification WHERE  OrganizationId = ? and EmployeeId =? and Title =? and Message =? and NotifyDate=CURDATE() and MailSts = 0 and OrganizationId = $orgid";
				$query1 = $db->prepare($sql1);
				$query1->execute(array( $orgid,$empid,$title,$msg ));
				$count=$query1->rowCount();
				if($count >= 1){
					$r=$query1->fetch();
					$id=$r->Id;
					$smtpuser = Utils::getName($orgid, 'Organization','smtpuser',$db);
					$smtpassword = Utils::getName($orgid, 'Organization','smtppassword',$db);
					$sts = Utils::sendMail(Utils::decode5t($to),$orgname,$title,$msg,'',$smtpuser,$smtpassword); 
					if($sts){
					$sql = "Update GenerateNotification set MailSts = 1 where Id =?";
					$query = $db->prepare($sql);
					$query->execute(array($id));
					return 1;
					}
				}
				return;
		}
		catch(Exception $e){
		}
	}
	
	public static function getAdminHR($orgid,$db)
	{
		$index=0;
		$ids=array();
		$sql = "select EmployeeId from UserMaster where AdminSts = 1 and OrganizationId=? and HRSts=1";
		$query = $db->prepare($sql);
		$query->execute(array($orgid));
		while($r=$query->fetch()){
			$ids[] = $r->EmployeeId;
		}
		return $ids;
	}
	
	public static function getSeniorIds($empid, $orgid,$db)
	{
		$ids = array();
		$index=0;
		$parentid=$empid;
		if($parentid!="0" && $parentid!="")
		{
			while($parentid!="")
			{
				$sql1 = "SELECT ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and Id in ( $parentid ) and  DOL='0000-00-00' ";
				$query1 = $db->prepare($sql1);
				$query1->execute(array($orgid));
				$parentid="";
				while($row1 = $query1->fetch())
				{
					if($parentid==""){
						$parentid = $row1->ReportingTo;
					}else{
						$parentid .= ", ".$row1->ReportingTo;
					}
					
					$ids[] = $row1->ReportingTo;					
					
				}
				
			}
		}
			return $ids;
	}
	
	
	public static function getJuniorIds($empid, $orgid,$db)
	{
		$ids = array();
		
		$parentid=$empid;
		if($parentid!="0" && $parentid!="")
		{
			while($parentid!="")
			{
				$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and ReportingTo in ( $parentid ) and  DOL='0000-00-00' ";
				
				$query1 = $db->prepare($sql1);
				$query1->execute(array($orgid));
				$parentid="";
				while($row1 = $query1->fetch())
				{
					if($parentid==""){
						$parentid = $row1->Id;
					}else{
						$parentid .= ", ".$row1->Id;
					}
						$ids[] = $row1->Id;
				}
				
			}
		}
			return $ids;
	}
	
	
	public static function getSeniorId($empid, $orgid,$db)
	{
		$seniorid = "0";
		$index=0;
		$sql1 = "SELECT ReportingTo FROM EmployeeMaster WHERE OrganizationId = ? and Id = ?  and  DOL='0000-00-00' ";
		$query1 = $db->prepare($sql1);
		$query1->execute(array( $orgid, $empid ));
		$parentid="";
		while($row1 = $query1->fetch())
		{
			$seniorid = $row1->ReportingTo;
				
		}             
		return $seniorid;
	}
	public static function getDepTeamIds($depid, $orgid,$db)
	{
		$teamid = array();
		$sql1 = "SELECT Id FROM EmployeeMaster WHERE OrganizationId = ? and Department = ?  and  DOL='0000-00-00' ";
		$query1 = $db->prepare($sql1);
		$query1->execute(array( $orgid, $depid ));
		while($row1 = $query1->fetch())
		{
			$teamid[] = $row1->Id;
		}
		return $teamid;
	}
	public static function getParseMailMessage($msg,$empid,$date,$db)
	{
		$searcharr=array();$status=false;$errorMsg=""; $successMsg="";
		$data=array();
		$searcharr  = array("{EmployeeName}","{dateofbirth}","{division}","{department}","{designation}","{phone}","{address}","{dateofjoining}","{dateofconfirmation}","{reportingto}","{reportingtodesig}","{organizationname}","{actiondate}");
		$replacearr = array();
		$sql="select * from EmployeeMaster where Id =$empid";
		$query = $db->prepare($sql);
		$query->execute();
		$count =  $query->rowCount();
		if ($count >0){
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$replacearr[0] = ucwords(strtolower($row->FirstName." ".$row->LastName));
				$replacearr[1] = Alerts::staticdateformatter($row->DOB);
				$replacearr[2] = Utils::getName($row->Division,"DivisionMaster", "Name", $db);
				$replacearr[3] = Utils::getName($row->Department,"DepartmentMaster", "Name", $db);
				$replacearr[4] = Utils::getName($row->Designation,"DesignationMaster", "Name", $db);
				$replacearr[5]= Utils::decode5t($row->CurrentContactNumber);
				$replacearr[6] = Utils::decode5t($row->CurrentAddress);
				$replacearr[7] =Alerts::staticdateformatter($row->DOJ);
				$replacearr[8] = Alerts::staticdateformatter($row->DOC);
				$replacearr[9]= Utils::getEmployeeName($row->ReportingTo, $db);
				$replacearr[10] = Alerts::getDesignation($row->ReportingTo, $db);
				$replacearr[11] = Utils::getName($row->OrganizationId,"Organization", "Name", $db);
				$replacearr[12]  = $date;
			}
		}
		$phrase = $msg;
		//$msg = Utils::strip_word_html(html_entity_decode($phrase,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><u>');
		$msg =str_replace($searcharr,$replacearr,$phrase);
		return $msg;
	}	
			
	public static function getEmpTypeEmp($emptype,$emparr, $db)
	{
		$ids = array();
		$emparr=implode($emparr,",");
		$sql = "SELECT Id FROM EmployeeMaster WHERE EmploymentType = :emptype and Id in ($emparr)";
        $query = $db->prepare($sql);
		try{
			$query->execute(array(':emptype' => $emptype ));
			while($row = $query->fetch())
			{
				$ids[] =  $row->Id;
			}
		}catch(Exception $e) {
			
		}
		return $ids;
	}		
	
	public static function getDesignation($id, $db)
	{
		$name ="";
		$sql = "SELECT Designation FROM EmployeeMaster WHERE Id = :id";
        $query = $db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name =  Utils::getName($row->Designation,'DesignationMaster','Name',$db);
				
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}

    public static function getSettingData($sid, $orgid, $db)
	{
		$name ="";
		$data =array();
		$sql = "SELECT * FROM SettingChild WHERE  OrganizationId = ? and Settingsonoff = 1 and (NotifyAlert=1 or SendMail=1) and SettingId = ?";
        $query = $db->prepare($sql);
		try{
			$query->execute(array($orgid, $sid));
			while($row = $query->fetch())
			{
				$res=array();
				$res['leaddays'] = $row->ExecutionValue;
				$res['alert'] = $row->NotifyAlert;
				$res['mailsend'] = $row->SendMail;
				$res['notifyself'] = $row->notifyself;
				$res['notifysupervisor'] = $row->notifysupervisor;
				$res['notifyhradmin'] = $row->notifyhradmin;
				$res['notifyteam'] = $row->notifyteam;
				$res['notifyjsteam'] = $row->notifyjsteam;
				$res['Title'] = $row->Title;
				$res['DescOther'] = $row->DescOther;
				$res['DescEmp'] = $row->DescEmp;
				$res['employeeType'] = $row->employeeType;
				$data[]= $res;
			}
		}catch(Exception $e) {
			
		}
		return $data;
	}

	public static function staticdateformatter($val)
    {
		$result = "-";
		if($val!="0000-00-00" && $val!="")
			$result = date('d/M/Y',strtotime($val));
		return $result;
    }
		
}
