<?php

/**
 * VisaModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class GoalsModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }

    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		try{
			$sql = "SELECT * FROM GoalMaster WHERE OrganizationId = :id";
			$query = $this->db->prepare($sql);
			
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = $row->Id;
					$res['gid'] = Utils::encode5t($row->Id);
					$res['dept'] = Utils::getName($row->DepartmentId,"DepartmentMaster","Name",$this->db);
					$res['emp'] = Utils::getName($row->EmployeeId,"EmployeeMaster","FirstName",$this->db);
					$res['fromdate'] =  date("d M'y",strtotime($row->StartDate));
					$res['todate'] =  date("d M'y",strtotime($row->EndDate));
					$res['goal'] = $row->Goal;
					$res['status'] =$row->Status ;
					$res['weightage'] =  (int)$row->Weightage;
					
					$departmentgoal = array(); $totaltask=0;
					
					$sql1 = "SELECT * FROM TeamGoals WHERE GoalId = :id ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array(':id' =>  $row->Id ));
					while($row1 = $query1->fetch())
					{
						$res1=array();
						$res1['id'] = $row1->Id;
						$res1['empid'] = $row1->EmployeeId;
						$res1['emp'] =  Utils::getName($row1->EmployeeId,"EmployeeMaster","FirstName",$this->db);
						$imgname =  Utils::getName($row1->EmployeeId,"EmployeeMaster","ImageName",$this->db);
						$pic="";
						$color = sprintf('%06X', mt_rand(0, 16777215));
						$name=$res1['emp'];
						$photo="public/uploads/$orgid/".$imgname;
						$res1['empletter'] =""; 
						if($imgname && file_exists($photo)){
							$res1['empimg'] =URL.$photo;
						}
						else{
							if(isset($name[0])){
								$pic='<p data-letters="'.strtoupper($name[0]).'" style="background-color:#'.$color.'"></p>';
								$res1['empletter'] =strtoupper($name[0]);
							}
						}
						//$res1['empimg'] = $pic;
						
						$res1['fromdate'] =  date("d M'y",strtotime($row1->StartDate));
						$res1['todate'] =  date("d M'y",strtotime($row1->EndDate));
						$res1['goal'] = $row1->Goal;
						$res1['desc'] = $row1->Description;
						$res1['weightage'] = (int)$row1->Weightage;
						$res1['quadrant'] = Utils::getName($row1->Quadrant,"Quadrants","Name",$this->db);
						$nooftask=$this->getEmployeeTaskscount($row1->Id,$row1->EmployeeId);
						$res1['achieve'] = $nooftask;
						$totaltask=$totaltask+$nooftask;
						$res1['progress']=0;
						
						/////////////////HOW MANY TASKS AN EMPLOYEE HAS DONE,ACCORDING TO THAT WE ARE FINDING THE  PROGRESS OF GOAL COMPLETION EMPLOYEE WISE ///////////
						
						if($row1->Weightage!=0)
							$res1['progress']=round(($nooftask/$row1->Weightage)*100,2);
						$departmentgoal[]=$res1;
					}
					$res['progress']=0;
					$res['achieve'] = $totaltask;
					
					/////////////////HOW MANY TASKS AN EMPLOYEES HAS DONE,ACCORDING TO THAT WE ARE FINDING THE  PROGRESS OF GOAL COMPLETION DEPARTMENT WISE///////////
					
					if($row->Weightage!=0)
						$res['progress']=round(($totaltask/$row->Weightage)*100,2);
					$res['departmentgoal']=$departmentgoal;
					$data[] = $res;
				}
			}else{
				$status=true;
				$successMsg = OBJECTIVE_MODULE_GETALL;
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }

	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		try{
			$sql = "SELECT * FROM GoalMaster WHERE Id = :id";
			$query = $this->db->prepare($sql);
		
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['dept'] = (int)$row->DepartmentId;
				$res['employeeid'] = $row->EmployeeId;
				$res['fromdate'] =  Utils::dateformatter($row->StartDate);
				$res['todate'] =  Utils::dateformatter($row->EndDate);
				$res['goal'] = $row->Goal;
				$res['weightage'] =  (int)$row->Weightage;
				
				$departmentgoal=array();
				$results=array();
				$sql1 = "SELECT * FROM DepartmentGoals WHERE GoalId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row1 = $query1->fetch())
				{
					$res1=array();
					$res1['id'] = $row1->Id;
					$res1['dept'] = (int)$row1->DepartmentId;
					$res1['fromdate'] = Utils::dateformatter($row1->StartDate);
					$res1['todate'] = Utils::dateformatter($row1->EndDate);
					$res1['goal'] = $row1->Goal;
					$res1['desc'] = $row1->Description;
					$res1['quadrant'] = $row1->Quadrant;
					$res1['weightage'] =  (int)$row1->Weightage;
					$sql2 = "SELECT * FROM TeamGoals WHERE GoalId = :id ";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array(':id' => $id ));
					$teamarr=array();
					while($row2 = $query2->fetch())
					{
						$res2=array();
						$res2['id'] = $row2->Id;
						$res2['employeeid'] = (int)$row2->EmployeeId;
						$res2['fromdate'] = Utils::dateformatter($row2->StartDate);
						$res2['todate'] = Utils::dateformatter($row2->EndDate);
						$res2['goal'] = $row2->Goal;
						$res2['desc'] = $row2->Description;
						$res2['quadrant'] = $row2->Quadrant;
						$res2['weightage'] =  (int)$row2->Weightage;
						$teamarr[]=$res2;
					}
					$res1['goalsarray'] =  $teamarr;
					$departmentgoal[]=$res1;
				}
				
				
				$sql1 = "SELECT * FROM GoalResult WHERE GoalId = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $id ));
				while($row1 = $query1->fetch())
				{
					$res1=array();
					$res1['id'] = $row1->Id;
					$res1['minmarks'] = (int)$row1->MinMarks;
					$res1['maxmarks'] = (int)$row1->MaxMarks;
					$res1['result'] = $row1->Result;
					$res1['rating'] =(int) $row1->Rating;
					
					$results[]=$res1;
				}
				
				$res['result']=$results;
				$res['departmentgoal']=$departmentgoal;
				$data[] = $res;
			}
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if ($count == 1) {
           $status =true;
		   $successMsg = OBJECTIVE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = OBJECTIVE_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
    public function getEmployeeTasks($empid,$goalid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        $sql = "SELECT * FROM task_master WHERE assignto = :id AND GoalId=:gid ";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $empid ,':gid' => $goalid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->id;
				$res['task'] = $row->task_title;
				$res['fromdate'] =  date("d M,y",strtotime($row->fromdate));
				$res['todate'] =  date("d M,y",strtotime($row->todate));
				$res['hours'] = $row->Totalhour;
				$res['desc'] = $row->description;
				$res['status'] = $row->taskstatus;
				$res['goal'] = Utils::getName($row->GoalId,'TeamGoals','Goal',$this->db);
				$res['task_no'] = $row->task_no;
				$data[] = $res;
			}
			
        }else{
			$status=true;
			$successMsg = TASK_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getEmployeeComments($goalid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];	
        $sql = "SELECT * FROM GoalComments WHERE TeamGoalId = :id ";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $goalid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['comments'] = $row->Comments;
				$res['givenby'] =Utils::getName($row->GivenBy,"EmployeeMaster","FirstName",$this->db);
				$res['givenon'] = date("d M'y h:i:s a",strtotime($row->GivenDate));
				$imgname =  Utils::getName($row->GivenBy,"EmployeeMaster","ImageName",$this->db);
				$pic="";
				$color = sprintf('%06X', mt_rand(0, 16777215));
				$name=$res['givenby'] ;
				$photo="public/uploads/$orgid/".$imgname;
				if($imgname && file_exists($photo)){
					$res['empimg'] =URL.$photo;
				}
				else{
					$pic='<p data-letters="'.strtoupper($name[0]).'" style="background-color:#'.$color.'"></p>';
					$res['empletter'] =strtoupper($name[0]);
				}
				$data[] = $res;
			}
			
        }else{
			$status=true;
			$successMsg = TASK_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	
    /**
     * Setter for a GoalMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$mdate = date("Y-m-d H:i:s");
		try{
			$sql1 = "SELECT * FROM GoalMaster WHERE Id!=? and DepartmentId = ? and OrganizationId=? and EmployeeId=? and Weightage=? and  ((? between  StartDate and EndDate )or (? between StartDate and EndDate ))";
			$query1 = $this->db->prepare($sql1);
		
			$query1->execute(array($request[8], $request[2], $orgid,$request[3],$request[9],Utils::getDateformat($request[4]),Utils::getDateformat($request[5]) ));
			$count1 =  $query1->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count1>=1)
		{
			 $status =false;
			 $errorMsg=OBJECTIVE_MODULE_UPDATION_DUPLICATE;
		}else{
		
			$sql = "UPDATE GoalMaster SET DepartmentId =? , EmployeeId =? , StartDate =? , EndDate =? , Goal =? , LastModifiedDate=?, LastModifiedById=?, Weightage=? where Id=?";
			$query = $this->db->prepare($sql);
			
			try{
				
				$query->execute(array($request[2],$request[3],Utils::getDateformat($request[4]),Utils::getDateformat( $request[5]),$request[6], $mdate, $mid, $request[9], $request[8] ));

			
			// INSERTING AND UPDATING OBJECTIVE CHILD IF PASSED AS AN JSON
			$departmentgoal = json_decode($_POST['departmentgoal'], true); 
			$teamgoalsid="0";
			for($i=0; $i<count($departmentgoal); $i++){
				$teamgoalsid .= ",".$departmentgoal[$i]['id'];
			}
			$sqlobjective = " DELETE FROM DepartmentGoals  WHERE GoalId=? AND Id NOT IN ($teamgoalsid)";
			$queryobjective = $this->db->prepare($sqlobjective);
			$queryobjective->execute(array( $request[4]));
			
			for($i=0; $i<count($departmentgoal); $i++)
			{
				if($departmentgoal[$i]['dept']!="" || $departmentgoal[$i]['goal']!=""){
					$record = array();
					$record[0] = $request[8];
					$record[1] = $departmentgoal[$i]['dept'];
					$record[2] = Utils::getDateformat($departmentgoal[$i]['fromdate']);
					$record[3] = Utils::getDateformat($departmentgoal[$i]['todate']);
					$record[4] = $departmentgoal[$i]['goal'];
					$record[5] = $mid;
					$record[6] = $mdate;
					$record[7] = $departmentgoal[$i]['weightage'];
					$record[8] = $departmentgoal[$i]['quadrant'];
					$id = $departmentgoal[$i]['id'];
					
					if($id){
						$sqlobjective = " UPDATE DepartmentGoals SET DepartmentId=?,  StartDate=? , EndDate =?, Goal=?, LastModifiedById =? , LastModifiedDate =?,Weightage=?,Quadrant=? where Id=?";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute(array($departmentgoal[$i]['employeeid'],Utils::getDateformat($departmentgoal[$i]['fromdate']), Utils::getDateformat($departmentgoal[$i]['todate']), $departmentgoal[$i]['goal'],$mid, $mdate,$departmentgoal[$i]['weightage'], $departmentgoal[$i]['quadrant'],  $id));
					}else{
						$sqlobjective = " INSERT INTO DepartmentGoals (GoalId, DepartmentId, StartDate , EndDate, Goal, LastModifiedById, LastModifiedDate,Weightage,Quadrant) values (?,?,?,?,?,?,?,?,?)";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute($record);
					}
					
				}
				
				$tgoal="0";
				$teamgoal=$departmentgoal[$i]['goalsarray'];
				for($ii=0; $ii<count($teamgoal); $ii++){
					$tgoal .= ",".$teamgoal[$ii]['id'];
				}
				$sqlobjective = " DELETE FROM TeamGoals  WHERE GoalId=? AND Id NOT IN ($tgoal)";
				$queryobjective = $this->db->prepare($sqlobjective);
				$queryobjective->execute(array( $request[4]));
				
				for($j=0; $j<count($teamgoal); $j++)
				{
					if($teamgoal[$j]['employeeid']!="" || $teamgoal[$j]['goal']!=""){
						$record = array();
						$record[0] = $request[8];
						$record[1] = $teamgoal[$j]['employeeid'];
						$record[2] = Utils::getDateformat($teamgoal[$j]['fromdate']);
						$record[3] = Utils::getDateformat($teamgoal[$j]['todate']);
						$record[4] = $teamgoal[$j]['goal'];
						$record[5] = $mid;
						$record[6] = $mdate;
						$record[7] = $teamgoal[$j]['weightage'];
						$record[8] = $teamgoal[$j]['quadrant'];
						$record[9] = $departmentgoal[$i]['dept'];
						$id = $teamgoal[$j]['id'];
						
						if($id){
							$sqlobjective = " UPDATE TeamGoals SET EmployeeId=?,  StartDate=? , EndDate =?, Goal=?, LastModifiedById =? , LastModifiedDate =?,Weightage=?,Quadrant=?,DepartmentId=? where Id=?";
							$queryobjective = $this->db->prepare($sqlobjective);
							$queryobjective->execute(array($teamgoal[$j]['employeeid'],Utils::getDateformat($teamgoal[$j]['fromdate']), Utils::getDateformat($teamgoal[$j]['todate']), $teamgoal[$j]['goal'],$mid, $mdate,$teamgoal[$j]['weightage'], $teamgoal[$j]['quadrant'], $departmentgoal[$i]['dept'],  $id));
						}else{
							$sqlobjective = " INSERT INTO TeamGoals (GoalId, EmployeeId, StartDate , EndDate, Goal, LastModifiedById, LastModifiedDate,Weightage,Quadrant,DepartmentId) values (?,?,?,?,?,?,?,?,?,?)";
							$queryobjective = $this->db->prepare($sqlobjective);
							$queryobjective->execute($record);
						}
						
					}
				}
			}
			
			
			
			// INSERTING AND UPDATING ASSESSMENT RESULT IF PASSED AS AN JSON
			$aresult = json_decode($_POST['result'], true); 
			$aresultid="0";
			for($i=0; $i<count($aresult); $i++){
				$aresultid .= ",".$aresult[$i]['id'];
			}
			$sqlaresult = " DELETE FROM GoalResult WHERE GoalId=? AND Id NOT IN ($aresultid)";
			$queryaresult = $this->db->prepare($sqlaresult);
			$queryaresult->execute(array( $request[4]));
			
			for($i=0; $i<count($aresult); $i++)
			{
				if(  $aresult[$i]['result']!=""){
					$record = array();
					$record[0] = $request[8];
					$record[1] = $aresult[$i]['minmarks'];
					$record[2] = $aresult[$i]['maxmarks'];
					$record[3] = $aresult[$i]['result'];
					$record[4] = $aresult[$i]['rating'];
					$id = $aresult[$i]['id'];
					
					if($id){
						$sqlaresult = " UPDATE GoalResult SET GoalId=?, MinMarks=?,MaxMarks=?, Result=?,Rating=? where Id=?";
						$queryaresult = $this->db->prepare($sqlaresult);
						$queryaresult->execute(array($request[4],$aresult[$i]['minmarks'],$aresult[$i]['maxmarks'],$aresult[$i]['result'],$aresult[$i]['rating'], $id));
					}else{
						$sqlaresult = " INSERT INTO GoalResult ( GoalId, MinMarks,MaxMarks, Result,Rating) values (?,?,?,?,?)";
						$queryaresult = $this->db->prepare($sqlaresult);
						$queryaresult->execute($record);
					}
					
				}
			}		
					
				$count =  $query->rowCount();
				
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			    $status =true;
			    $successMsg = "Goal has been configured successfully.";
			 
			} else {
			   $status =false;
			   $errorMsg = "There is some problem while updating record.";
			}
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

   
    /**
     * Setter for a GoalMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
       
		$mdate = date("Y-m-d H:i:s");
		
		
			$sql = "INSERT INTO GoalMaster (DepartmentId , EmployeeId , StartDate , EndDate, Goal, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById,Weightage) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
			
			try{
				
				$query = $this->db->prepare($sql);
				$query->execute(array($request[2],$request[3],Utils::getDateformat($request[4]),Utils::getDateformat($request[5]),$request[6],$orgid, $mdate, $mid, $mdate, $mid,$request[8]));
				$aid=$this->db->lastInsertId();
					// INSERTING OBJECTIVE CHILD IF PASSED AS AN JSON
				$departmentgoal = $request[7]; 
				for($i=0; $i<count($departmentgoal); $i++)
				{
					if($departmentgoal[$i]['employeeid']!="" || $departmentgoal[$i]['goal']!=""){
						$record = array();
						$record[0] = $aid;
						$record[1] = $departmentgoal[$i]['employeeid'];
						$record[2] = $departmentgoal[$i]['goal'];
						$record[3] = Utils::getDateformat($departmentgoal[$i]['fromdate']);
						$record[4] = Utils::getDateformat($departmentgoal[$i]['todate']);
						$record[5] = $mid;
						$record[6] = $mdate;
						$record[7] = $departmentgoal[$i]['weightage'];
						$record[8] = $departmentgoal[$i]['quadrant'];
						
						$sqlobjective = " INSERT INTO TeamGoals (GoalId, EmployeeId,Goal , StartDate , EndDate,  LastModifiedById, LastModifiedDate, Weightage,Quadrant) values (?,?,?,?,?,?,?,?,?)";
						$queryobjective = $this->db->prepare($sqlobjective);
						$queryobjective->execute($record);
					}
				}
				
				$aresult = json_decode($_POST['result'], true); 
							
				for($i=0; $i<count($aresult); $i++)
				{
					if(  $aresult[$i]['result']!=""){
						$record = array();
						$record[0] = $aid;
						$record[1] = $aresult[$i]['minmarks'];
						$record[2] = $aresult[$i]['maxmarks'];
						$record[3] = $aresult[$i]['result'];
						$record[4] = $aresult[$i]['rating'];
										
						$sqlaresult = " INSERT INTO GoalResult ( GoalId, MinMarks,MaxMarks, Result,Rating) values (?,?,?,?,?)";
						$queryaresult = $this->db->prepare($sqlaresult);
						$queryaresult->execute($record);
					}
				}		
				$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Goal has been configured successfully.";
			} else {
			   $status =false;
			   $errorMsg = "There is some problem while configuring performance.";
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	 public function AddTask($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
       try{
			$mdate = date("Y-m-d H:i:s");
			/////////////////////// To Make task number /////////////////////////
			$task_id="";
			$query1 = $this->db->prepare("SELECT max(id)+1 as maxid FROM task_master");
			$query1->execute();
			if ($row1=$query1->fetch()) {
				$num1 =str_pad($row1->maxid, 4, '0', STR_PAD_LEFT);
				$task_id="TSK-".$num1;
			}
		
			$sql = "INSERT INTO task_master (task_title , assignto , fromdate , todate, GoalId, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, taskstatus, Totalhour, task_no,description) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2],$request[3],Utils::getDateformat($request[4]),Utils::getDateformat($request[5]),$request[8],$orgid, $mdate, $mid, $mdate, $mid,4,$request[6],$task_id, $request[7]));
			$aid=$this->db->lastInsertId();
			
			$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Task has been added successfully.";
			} else {
			   $status =false;
			   $errorMsg = "There is some problem while adding the task.";
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  public function AddComments($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
				
       try{
			$mdate = date("Y-m-d H:i:s");
			/////////////////////// To Make task number /////////////////////////
			
			$sql = "INSERT INTO GoalComments (TeamGoalId , Comments , GivenBy , GivenDate) VALUES (?, ?, ?, ?)";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[2],$request[3],$mid,$mdate));
			$aid=$this->db->lastInsertId();
			
			$count =  $query->rowCount();		
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			
			if ($count == 1) {
			   $status =true;
			   $successMsg = "Comments has been given successfully.";
			} else {
			   $status =false;
			   $errorMsg = "There is some problem while giving the comments.";
			}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");
		
		try{
			$sql = "Select * from GoalMaster WHERE Id = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch()){
				$aid=$row->DesignationId;
				$sql2 = "Select * from EmployeeMaster WHERE Designation = :id ";
				$query2 = $this->db->prepare($sql2);
				$query2->execute(array(':id' => $aid));	
				while($row2=$query2->fetch()){
					$eid=$row2->Id;
					$sql3 = "Select * from EmployeeAssessment WHERE EmployeeId = :id ";
					$query3 = $this->db->prepare($sql3);
					$query3->execute(array(':id' => $eid));	
					while($row3=$query3->fetch()){
						$count1++;
					}
				}
				if($count1>=1){
					$status =false;
					$errorMsg = OBJECTIVE_MODULE_DELETE_EXIST;
				
				}else{
						$sql1 = "DELETE FROM GoalMaster WHERE Id = :id ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array(':id' => $did));
						
						$sql1 = "DELETE FROM GoalMasterChild WHERE GoalMasterId = :id ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array(':id' => $did));
					
						$count =  $query1->rowCount();		
					
					
					if ($count == 1) {
					   $status =true;
					   $successMsg = OBJECTIVE_MODULE_DELETE_SUCCESS;
					}else {
					   $status =false;
					   $errorMsg = OBJECTIVE_MODULE_DELETE_FAILED;
					}
				}
			}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	public function getSeniorDesigs($desig)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $level=1;
		$orgid = $_SESSION['ubihrm_org_id'];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$ids = "0";
		$res = array();
		$res['id'] = $desig;
		$res['name'] = $this->getName($desig,'DesignationMaster');
		$res['level'] = $level;
		$data[] = $res;
		$parentid=$desig;
		try{
			if($parentid!="0" && $parentid!="")
			{
				while($parentid!="")
				{
					
					$sql1 = "SELECT * FROM DesignationMaster WHERE OrganizationId = ? and Id in ( $parentid ) ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($orgid));
					$count=$query1->rowCount();
					$parentid="";
					
					while($row1 = $query1->fetch())
					{
						$level++;
						if($parentid==""){
							$parentid = $row1->RoleId;
						}else{
							$parentid .= ", ".$row1->RoleId;
						}
						if($row1->RoleId != 0){
							$res = array();
							$res['id'] = $row1->RoleId;
							$res['name'] = $this->getName($row1->RoleId,'DesignationMaster');
							$res['level'] = $level;
							
							$data[] = $res;
							
						}
					
					}
				
				}
			}
		}catch(Exception $e){
			$status =false;
		   $errorMsg = $e->getMessage();
		}
		if ($count >= 1) {
           $status =true;
		   $successMsg = DESIGNATION_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = DESIGNATION_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
		
			
	}
	
	public function getName($id,$table)
	{
		$name ="";
		$sql = "SELECT * FROM $table WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->Name;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	public function getEmployeeTaskscount($goalid,$empid)
	{
		$count =0;
		$sql = "SELECT count(id) as totalcount FROM task_master WHERE assignto = ? and GoalId=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $empid, $goalid ));
			while($row = $query->fetch())
			{
				$count = $row->totalcount;
			}
		}catch(Exception $e) {
			
		}
		return $count;
	}
	
	
	
	public function getDataTable($editper, $deleteper)
	{
		$sTable = 'GoalMaster';
		$sIndexColumn = "Id";
		$aColumns = array( 'DepartmentId','EmployeeId' ,'Goal','StartDate', 'EndDate','Status','Id','Id');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$mid=$_SESSION['ubihrm_user_id'];
		$desig=Utils::getName($mid,'EmployeeMaster','Designation',$this->db);
		$ids=Utils::getReportingIds($mid,$this->db);
		$desigids=Utils::getJuniorDesigs($desig,$this->db);
		$sWhere = "WHERE OrganizationId= $orgid  and (DesignationId in (select Designation FROM EmployeeMaster where Id in ($ids)) or DesignationId in ($desigids))";
		if($sts==1 || $hrsts==1){
			$sWhere = "WHERE OrganizationId= $orgid ";
		}
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " and  (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="id"){
				continue;
				}
				if($aColumns[$i]=="DesignationId"){
				$sWhere .= "(DesignationId in ( select Id from DesignationMaster where Name "." LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id" )
				{
					$edit =""; $delete=""; $tasks=""; $comments="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'performance/editgoals/'.Utils::encode5t($aRow->$aColumns[$i]).'" ><i class="fa fa-edit"></i></a>';
						
						$tasks = '<a rel="tooltip"  title="Tasks" onclick="angular.element(this).scope().gettasks(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#tasks" href="#" ><i class="fa fa-bars"></i></a>';
						
						$comments = '<a rel="tooltip"  title="Comments" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#comments" href="#" ><i class="fa fa-comments-o"></i></a>';
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" onclick="angular.element(this).scope().getId(\''.$aRow->Id.'\')" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}	
					if($i==6)
						$row[]="";
					else
						$row[] =$comments."&nbsp;&nbsp;|&nbsp;&nbsp;".$tasks ."&nbsp;&nbsp;|&nbsp;&nbsp;".$edit."&nbsp;&nbsp;|&nbsp;&nbsp;".$delete;
				}
				else if($aColumns[$i]=="DepartmentId")
				{
					$row[] = '<a href="'.URL.'performance/viewgoals/'.Utils::encode5t($aRow->Id).'/1">'.$this->getName($aRow->$aColumns[$i],'DepartmentMaster').'</a>';
					
				}
				else if($aColumns[$i]=="EmployeeId")
				{
					$row[] =Utils::getEmployeeName($aRow->$aColumns[$i],$this->db);
					
				}
				else if($aColumns[$i]=="StartDate" || $aColumns[$i]=="EndDate")
				{
					$row[] =Utils::dateformatter($aRow->$aColumns[$i]);
					
				}
				else if($aColumns[$i]=="Status" )
				{
					if($aRow->$aColumns[$i] == 0)
						$row[] ="<label class='badge bg-red'>Not Completed</label>";
					else 
						$row[] ="<label class='badge bg-green'>Completed</label>";
					
				}
				
				else
				{
					$row[] = $aRow->$aColumns[$i];
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
}
