<?php

/**
 * Class Setup
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin();
 */
class Setup extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();

        // this controller should only be visible/usable by logged in users, so we put login-check here
        Auth::handleLogin();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    function index()
    {
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		if($sts==1 || $hrsts==1){
			$this->view->render('setup/index');
		}else{
			$this->view->render('setup/index1');
		}
    }
	
    function company()
    {
		$viewper = $this->CheckPermission(35, 1);  ///////// CHECK FOR VIEW EMPLOYEE PERMISSION  ////////////    	
		$editper = $this->CheckPermission(35, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////    	
		if($viewper){
			$datalist = $this->loadModel('Setup');
			$orgid = $_SESSION['ubihrm_org_id'];
			$this->view->editper = $editper;
			$this->view->data = $datalist->RelatedList('Organization',$orgid);
			$this->view->render('setup/company/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
	
	function uploadCompanyLogo()
	{	
		$editper = $this->CheckPermission(35, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			//$arr[2]=$_POST['emp_id'];			
			$employee = $this->loadModel('Setup');
			$employeearray = $employee->uploadImage($arr);
			echo json_encode($employeearray);
			}catch(Exception $e){}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
    function userdata()
    {
        $this->view->render('setup/users/index1');
    }
	function setup_asset()
    {
    	$viewper = $this->CheckPermission(4, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(4, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/asset/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
	function vendor()
    {
    	
			$this->view->render('setup/asset/vendor_assets');
		
    }
	function alerts()
    {
        $viewper = $this->CheckPermission(49, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(49, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/notifications/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
	function getselfservicepermission(){
		try{
			
			$dept = $this->loadModel('Userprofile');
			$deptarray = $dept->getSelfservicemodules();
			echo json_encode($deptarray);
		}catch(Exception $e){}	
					
	}
    function getNotificationData()
	{
		$editper = $this->CheckPermission(49, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(49, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$notification = $this->loadModel('Notification');
		$notificationarray = $notification->getDataTableAlert($editper, $deleteper);
		echo json_encode($notificationarray);
	}
    function relatedlist()
    {
        $viewper = $this->CheckPermission(38, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(38, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			 $this->view->render('setup/relatedlist/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }	
	
	 /**
	////////////////////////////////  ORGANIZATION CONTROLLER FUNCTION STARTS HERE   ////////////////////////
	
     * Functions for perfom operation on organization table
     * getOrganization function fetching details of logged in organization user
	 * @returning json array of data as result
     */
	function getOrganization()
	{
		$viewper = $this->CheckPermission(35, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$org = $this->loadModel('Setup');
			$orgarray = $org->getOrganization();
			echo json_encode($orgarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}					
	}
	
	
	
	 /**
     * Setter for a organization table to perform INSER AND UPDATE
     * @return json array of data as result
     */
	function updateOrganization()
	{
		$editper = $this->CheckPermission(35, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$org = $this->loadModel('Setup');
			$orgarray = $org->AddUpdateOrganization();
			echo json_encode($orgarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	

	/** 
	 									
	 ////////////////////////////////     ORGANIZATION CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	 */
	 ////////////////////////////////     RELATED LIST CONTROLLER FUNCTION STARTS HERE  //////////////////////////
	 
	function getRelatedList()
	{
		$viewper = $this->CheckPermission(38, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_org_id'];
			$arr[1] = $_POST['table_name'];
			$org = $this->loadModel('Relatedlist');
			$orgarray = $org->getAll($arr);
			echo json_encode($orgarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	
	function relatedList1()
	{
		$viewper = $this->CheckPermission(38, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$orgid = $_SESSION['ubihrm_org_id'];
			//$table = $_POST['table_name'];
			$datalist = $this->loadModel('Setup');
			$this->view->data = $datalist->RelatedList('Organization',$orgid);
			$this->view->render('setup/company/index',$data);
			//echo json_encode($orgarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	} 	 
	
	 function getRelatedlistData()
	{
		$editper = $this->CheckPermission(38, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(38, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$relatedlist = $this->loadModel('Relatedlist');
		$relatedlistarray = $relatedlist->getDataTable($editper, $deleteper);
		echo json_encode($relatedlistarray);
	}
	 
	 
	 function createrelatedlist()
    	{
		$addper = $this->CheckPermission(38, 4);  ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['list_name'];
			$arr[3] = $_POST['parent_name'];
			$arr[4] = $_POST['child_name'];
			//$arr[5] = $_POST['pid'];
			$arr[5] = $_POST['dfields'];
			$arr[6] = $_POST['sts'];
			//$arr[6] = $_POST['relatedlistid'];
			$relatedlist = $this->loadModel('Relatedlist');
			$listarray = $relatedlist->createrelatedlist($arr);
        	echo json_encode($listarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
    	}
    	
    function addrelatedlist()
		{
			$addper = $this->CheckPermission(38, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			if($addper){
				$this->view->relatedlistid =0;
				$this->view->render('setup/relatedlist/addeditrelatedlist');
			}else{
				header('location: ' . URL . 'setup/relatedlist');
			}
		}
    
    function getarelatedlist()
	{
		$viewper = $this->CheckPermission(38, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['relatedlistid'];
			$relatedlist = $this->loadModel('Relatedlist');
			$relatedlistarray = $relatedlist->getDetail($gid);
			echo json_encode($relatedlistarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}			
	}
	
	function editrelatedlist($id)
    {
		$editper = $this->CheckPermission(38, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->relatedlistid = $id; //$dept->getDetail($id);
			$this->view->render('setup/relatedlist/addeditrelatedlist');
		}
		else{
			header('location: ' . URL . 'setup/relatedlist');
		}
    }
    
    function getalllist()
    {
    	$viewper = $this->CheckPermission(38, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$relatedlist = $this->loadModel('Relatedlist');
			$listarr = $relatedlist->getAllList();
			echo json_encode($listarr);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
    }
    
    function getallcolumnname()
    {
    		
		$viewper = $this->CheckPermission(38, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$child_name = $_POST['child_name'];
    		$relatedlist = $this->loadModel('Relatedlist');
		$fieldsarr = $relatedlist->getAllColumnName($child_name);
		echo json_encode($fieldsarr);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
    }
    
    function updatedrelatedlist()
	{
		$editper = $this->CheckPermission(38, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['list_name'];
		$arr[3] = $_POST['parent_name'];
		$arr[4] = $_POST['child_name'];
		$arr[5] = $_POST['dfields'];
		$arr[6] = $_POST['relatedlistid'];
		$arr[7] = $_POST['sts'];
		
		
		$relatedlist = $this->loadModel('Relatedlist');
		$relatedlistarray = $relatedlist->Update($arr);
		echo json_encode($relatedlistarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
    
    
    function deleterelatedlist($did)
	{
		$deleteper = $this->CheckPermission(38, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$list = $this->loadModel('Relatedlist');
			$listarray = $list->Delete($did);
		}	
				
		header('location: ' . URL . 'setup/relatedlist');
		//$this->view->render('setup/relatedlist/index');
	}
    
	 
	  ////////////////////////////////    RELATED LIST CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	 
	 
	 
	 ////////////////////////////////     DIVISION CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perfom operation on division table
     * getall function fetching division list
	 * @returning json array of data as result
     */
	 function division()
    {
    	$viewper = $this->CheckPermission(14, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(14, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/division/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
		
    }
	
	function adddivision()
    {
		$addper = $this->CheckPermission(14, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->divisionid =0;
			$this->view->val =0;
			$this->view->render('setup/division/addeditdivision');
		}else{
			header('location: ' . URL . 'setup/division');
		}
    }
	
	function editdivision($id)
    {
		$editper = $this->CheckPermission(14, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->divisionid = $id; //$dept->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/division/addeditdivision');
		}else{
			header('location: ' . URL . 'setup/division');
		}
    }
	
	function setarchive($id,$val)
    {
		$division = $this->loadModel('Division');
		$divisionarray = $division->SetArchive($id,$val);
		echo json_encode($divisionarray);
    }
	
	
	function getalldivision()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$division = $this->loadModel('Division');
			$divisionarray = $division->getAll($arr);
			echo json_encode($divisionarray);
			
					
	}
	function getallvisa()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$visa = $this->loadModel('Visa');
			$visaarray = $visa->getAll($arr);
			echo json_encode($visaarray);
			
					
	}
	
	function getadivision()
	{
		try{
		$viewper = $this->CheckPermission(14, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['divisionid'];
			$division = $this->loadModel('Division');
			$divisionarray = $division->getDetail($gid);
			echo json_encode($divisionarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}		
	}
	
	////////////////////////////////////////
	
	/*function getcolumns()
	{
		$division = $this->loadModel('Division');
		$divisionarray = $division->getColumns();
		echo json_encode($divisionarray);		
	}*/
	
	////////////////////////////////////////
	
	/** 
     * Functions for perfom operation on division table
     * getall function fetching division list
	 * @returning json array of data as result
     */
	function createdivision()
	{
		$addper = $this->CheckPermission(14, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['divisionname'];
			$arr[3] = $_POST['contactperson'];
			$arr[4] = $_POST['contactnumber'];
			$arr[5] = $_POST['altnumber'];
			$arr[6] = $_POST['emailaddress'];
			$arr[7] = $_POST['address'];
			$arr[8] = $_POST['country'];
			$arr[9] = $_POST['city'];
			$arr[10] = $_POST['zipcode'];
			$arr[11] = $_POST['landmark'];
			$arr[12] = $_POST['currency'];
			$arr[13] = $_POST['dateformat'];
			$arr[14] = $_POST['timeformat'];
			$arr[15] = $_POST['timezone'];
			$arr[16] = $_POST['divisioncode'];
			$arr[17] = $_POST['account'];
			$arr[18] = $_POST['establishment'];
			$dept = $this->loadModel('Division');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on division table
     * delete function from division list
	 * @returning json array of data as result
     */
	 
	function updatededivision()
	{
		$editper = $this->CheckPermission(14, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['divisionname'];
		$arr[3] = $_POST['contactperson'];
		$arr[4] = $_POST['contactnumber'];
		$arr[5] = $_POST['altnumber'];
		$arr[6] = $_POST['emailaddress'];
		$arr[7] = $_POST['address'];
		$arr[8] = $_POST['country'];
		$arr[9] = $_POST['city'];
		$arr[10] = $_POST['zipcode'];
		$arr[11] = $_POST['landmark'];
		$arr[12] = $_POST['currency'];
		$arr[13] = $_POST['dateformat'];
		$arr[14] = $_POST['timeformat'];
		$arr[15] = $_POST['timezone'];
		$arr[16] = $_POST['divisionid'];
		$arr[17] = $_POST['divisioncode'];
		$arr[18] = $_POST['account'];
		$arr[19] = $_POST['establishment'];
		
		$dept = $this->loadModel('Division');
		$deptarray = $dept->Update($arr);
		echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletedivision($did)
	{
		$deleteper = $this->CheckPermission(14, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Division');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}		
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getDivisionData()
	{
		$editper = $this->CheckPermission(14, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(14, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$division = $this->loadModel('Division');
		$divisionarray = $division->getDataTable($editper, $deleteper);
		echo json_encode($divisionarray);
	}
	
	
	function viewdivision($id,$val)
    {
		
		
		$viewper = $this->CheckPermission(14, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			if(isset($id) && isset($val))
			{
				$datalist = $this->loadModel('Setup');
				$orgid = $_SESSION['ubihrm_org_id'];
				$this->view->data = $datalist->RelatedList('DivisionMaster',$orgid);
				$dept = $this->loadModel('Division');
				$this->view->divisionid = $id;
				$this->view->val = $val;
				$this->view->render('setup/division/addeditdivision');
			}else{
				header('location: ' . URL . 'setup/division');
			}
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
    }
	
	
	
	 /** 
	 
	  ////////////////////////////////     DIVISION CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
										
	 ////////////////////////////////     DEPARTMENT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on Department table
     * getall function fetching department list
	 * @returning json array of data as result
     */
	 
	function department()
    {
    	$viewper = $this->CheckPermission(12, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(12, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/department/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
    function adddepartment()
    {
		$addper = $this->CheckPermission(12, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->deptid =0;
			$this->view->data ="";
			$this->view->val =0;
			$this->view->render('setup/department/add_department');
		}else{
			header('location: ' . URL . 'setup/department');
		}
    }
	function editdepartment($id)
    {
		$editper = $this->CheckPermission(12, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$dept = $this->loadModel('Department');
			$this->view->data ="";
			$this->view->deptid = $id; //$dept->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/department/add_department');
		}else{
			header('location: ' . URL . 'setup/department');
		}
    }
    
    
    function viewdepartment($id,$val)
    {
		
		
		$viewper = $this->CheckPermission(12, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			if(isset($id) && isset($val))
			{
				$datalist = $this->loadModel('Setup');
					$orgid = $_SESSION['ubihrm_org_id'];
				$this->view->data = $datalist->RelatedList('DepartmentMaster',$orgid);
				
				$dept = $this->loadModel('Department');
				$this->view->deptid = $id; //$dept->getDetail($id);
				$this->view->val = $val;
				$this->view->render('setup/department/add_department');
			}else{
				header('location: ' . URL . 'setup/department');
			}
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
    }
    
    
	
	function getalldepartment()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Department');
			$deptarray = $dept->getAll($arr);
			echo json_encode($deptarray);	
				
	}
	function getalldepartment1()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Department');
			$deptarray = $dept->getAll1($arr);
			echo json_encode($deptarray);	
				
	}
	function getadepartment()
	{
		$viewper = $this->CheckPermission(12, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$did = $_POST['deptid'];
			$dept = $this->loadModel('Department');
			$deptarray = $dept->getDetail($did);
			echo json_encode($deptarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	 /** 
     * Functions for perfom operation on Department table
     * getall function fetching department list
	 * @returning json array of data as result
     */
	function createdepartment()
	{
		$addper = $this->CheckPermission(12, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['deptname'];
			$arr[3] = $_POST['parentdeptname'];
			$arr[4] = $_POST['deptcode'];
			$dept = $this->loadModel('Department');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	 
	 function updatedepartment()
	{
		$editper = $this->CheckPermission(12, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['deptname'];
			$arr[3] = $_POST['parentdeptname'];
			$arr[4] = $_POST['deptid'];
			$arr[5] = $_POST['deptcode'];
			$dept = $this->loadModel('Department');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletedepartment($did)
	{
		$deleteper = $this->CheckPermission(12, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Department');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getDepartmentData()
	{
		$editper = $this->CheckPermission(12, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(12, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$dept = $this->loadModel('Department');
		$deptarray = $dept->getDataTable($editper, $deleteper);
		echo json_encode($deptarray);
	}
	
	
	
	 /** 
	 
	  ////////////////////////////////     DEPARTMENT CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
										
	 ////////////////////////////////     DESIGNATION CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on Designation table
     * getall function fetching Designation list
	 * @returning json array of data as result
     */
	 
	function designation()
    {
    	$viewper = $this->CheckPermission(13, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(13, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			 $this->view->render('setup/designation/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
    function adddesignation()
    {
		$addper = $this->CheckPermission(13, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->desigid =0;
			$this->view->data ="";
			$this->view->val =0;
			$this->view->render('setup/designation/addeditdesignation');
		}else{
			header('location: ' . URL . 'setup/designation');
		}
    }
	function editdesignation($id)
    {
		$editper = $this->CheckPermission(13, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$dept = $this->loadModel('Designation');
			$this->view->data ="";
			$this->view->desigid = $id; //$dept->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/designation/addeditdesignation');
		}else{
			header('location: ' . URL . 'setup/designation');
		}
    }
	
	function getalldesignation()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Designation');
			$deptarray = $dept->getAll($arr);
			echo json_encode($deptarray);
			
					
	}
	
	function getalldesigforparentdesig()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desigid'];
			$dept = $this->loadModel('Designation');
			$deptarray = $dept->getalldesigforparentdesig($arr);
			echo json_encode($deptarray);
	}
	
	function getCompetencyDesignation()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Designation');
			$deptarray = $dept->getCompetencyDesignation($arr);
			echo json_encode($deptarray);
			
					
	}
	function getSkillGapDesignation()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Designation');
			$deptarray = $dept->getSkillGapDesignation($arr);
			echo json_encode($deptarray);
			
					
	}
	function getsenioremail()
	{
		try{
			$result = array();
			$userid = $_SESSION['ubihrm_user_id'];
			
			$senior = Utils::getApprovalLevelEmp($userid, 1, $this->db);
			$senioremail=Utils::decode5t(Utils::getName($senior,'EmployeeMaster','CompanyEmail',$this->db));
			$result["senioremail"] =$senioremail;
			$result["status"] =true;
			echo json_encode($result);
		}catch(Exception $e){
			
		}
			
					
	}
	
	function getdesignationheirarchy()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Designation');
			$deptarray = $dept->getDesignationHeirarchy($arr);
			echo json_encode($deptarray);
			
					
	}
	
	function getalldesignation1()
	{
		$viewper = $this->CheckPermission(13, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Designation');
			$deptarray = $dept->getAll1($arr);
			echo json_encode($deptarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	
	function getadesignation()
	{
		$viewper = $this->CheckPermission(13, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$did = $_POST['desigid'];
			$dept = $this->loadModel('Designation');
			$deptarray = $dept->getDetail($did);
			echo json_encode($deptarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}			
	}
	 /** 
     * Functions for perfom operation on designation table
     * getall function fetching designation list
	 * @returning json array of data as result
     */
	function createdesignation()
	{
		$addper = $this->CheckPermission(13, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['designame'];
			$arr[3] = $_POST['desigcode'];
			$arr[4] = $_POST['roleid'];
			$arr[5] = $_POST['gradeid'];
			$arr[6] = $_POST['desc'];
			$arr[7] = $_POST['hrsts'];
			
			$dept = $this->loadModel('Designation');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on designation table
     * delete function from designation list
	 * @returning json array of data as result
     */
	 
	 function updatedesignation()
	{
		

$editper = $this->CheckPermission(13, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['designame'];
			$arr[3] = $_POST['desigid'];
			$arr[4] = $_POST['desigcode'];
			$arr[5] = $_POST['roleid'];
			$arr[6] = $_POST['gradeid'];
			$arr[7] = $_POST['desc'];
			$arr[8] = $_POST['hrsts'];
			$dept = $this->loadModel('Designation');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on designation table
     * delete function from designation list
	 * @returning json array of data as result
     */
	function deletedesignation($did)
	{
		$deleteper = $this->CheckPermission(13, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Designation');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}	
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getDesignationData()
	{
		
		
		$editper = $this->CheckPermission(13, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(13, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$dept = $this->loadModel('Designation');
		$deptarray = $dept->getDataTable($editper, $deleteper);
		echo json_encode($deptarray);
	}
	
	
	function viewdesignation($id,$val)
    {
		$viewper = $this->CheckPermission(13, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			if(isset($id) && isset($val))
			{
				$datalist = $this->loadModel('Setup');
    			$orgid = $_SESSION['ubihrm_org_id'];
				$this->view->data = $datalist->RelatedList('DesignationMaster',$orgid);
				$dept = $this->loadModel('Designation');
				$this->view->desigid = $id;
				$this->view->val = $val;
				$this->view->render('setup/designation/addeditdesignation');
			}else{
				header('location: ' . URL . 'setup/designation');
			}
		}
	}
	
	function adddesigstatus($id)
	{
	
		$editper = $this->CheckPermission(46, 2); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($editper && isset($id)){
			$arr=array();
			$arr[0] = $_SESSION['ubihrm_org_id'];
			$arr[1]=$id;
			$user = $this->loadModel('Designation');
			$userarray = $user->AddDesigStatus($arr);
			echo json_encode($userarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}	
	}
	 /** 
	 									
	 ////////////////////////////////     Designation CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	
	 ////////////////////////////////     GRADE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on Grade table
     * getall function fetching Grade list
	 * @returning json array of data as result
     */
	 function grade()
    {
    	$viewper = $this->CheckPermission(27, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(27, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$datalist = $this->loadModel('Setup');
			$orgid = $_SESSION['ubihrm_org_id'];
			$this->view->data = $datalist->RelatedList('GradeMaster',$orgid);
    
        $this->view->render('setup/grade/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}

    }
	
	function addgrade()
    {
        
		$addper = $this->CheckPermission(27, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->gradeid = 0; 
			$this->view->val =0;
			$this->view->render('setup/grade/addeditgrade');;
		}else{
			header('location: ' . URL . 'setup/grade');
		}
    }
	
	function editgrade($id)
    {
		$editper = $this->CheckPermission(27, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->gradeid = $id; 
			$this->view->val =0;//$dept->getDetail($id);
			$this->view->render('setup/grade/addeditgrade');
		}else{
			header('location: ' . URL . 'setup/grade');
		}
    }
	function gradelevelup($id)
    {
		$editper = $this->CheckPermission(27, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$grade = $this->loadModel('Grade');
			$gradearray = $grade->levelUp($id);
			echo json_encode($gradearray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);
		}
    }
	
	function gradeleveldown($id)
    {
		$editper = $this->CheckPermission(27, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$grade = $this->loadModel('Grade');
			$gradearray = $grade->levelDown($id);
			echo json_encode($gradearray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);
		}
    }
	
	
	function getallgrade()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$grade = $this->loadModel('Grade');
			$gradearray = $grade->getAll($arr);
			echo json_encode($gradearray);	
			
				
	}
	
	function getagrade()
	{
		$viewper = $this->CheckPermission(27, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['gradeid'];
			$grade = $this->loadModel('Grade');
			$gradearray = $grade->getDetail($gid);
			echo json_encode($gradearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}			
	}
	
	
	function getgradeid()
	{
		
			$gid = $_POST['desigid'];
			$grade = $this->loadModel('Designation');
			$gradearray = $grade->getGradeid($gid);
			echo json_encode($gradearray);	
			
			
	}
	
	/** 
     * Functions for perfom operation on Grade table
     * getall function fetching Grade list
	 * @returning json array of data as result
     */
	function creategrade()
	{
		$addper = $this->CheckPermission(27, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['gradename'];
			$arr[3] = $_POST['desc'];
			$arr[4] = $_POST['gradecode'];
			$arr[5] = $_POST['nomonths'];
			$arr[6] = $_POST['salincreamentper'];
			$dept = $this->loadModel('Grade');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Grade table
     * delete function from Grade list
	 * @returning json array of data as result
     */
	 
	 function updatedegrade()
	{
		$editper = $this->CheckPermission(27, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['gradename'];
			$arr[3] = $_POST['desc'];
			$arr[4] = $_POST['gradeid'];
			$arr[5] = $_POST['gradecode'];
			$arr[6] = $_POST['nomonths'];
			$arr[7] = $_POST['salincreamentper'];
			$dept = $this->loadModel('Grade');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletegrade($did)
	{
		$deleteper = $this->CheckPermission(27, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Grade');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);				
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getGradeData()
	{
		$editper = $this->CheckPermission(27, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(27, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$grade = $this->loadModel('Grade');
		$gradearray = $grade->getDataTable($editper, $deleteper);
		echo json_encode($gradearray);
	}
	
	/** 
	 									
	 ////////////////////////////////     GRADE CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	
	 ////////////////////////////////     LOCATION CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on location table
     * getall function fetching location list
	 * @returning json array of data as result
     */
	 function location()
    {
    	$viewper = $this->CheckPermission(32, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(32, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/location/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
	
	function addlocation()
    {
		$addper = $this->CheckPermission(32, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->locationid =0;
			$this->view->val =0;
			$this->view->render('setup/location/addeditlocation');
		}else{
			header('location: ' . URL . 'setup/location');
		}
    }
	
	function editlocation($id)
    {
		$editper = $this->CheckPermission(32, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->locationid = $id; //$dept->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/location/addeditlocation');
		}else{
			header('location: ' . URL . 'setup/location');
		}
    }
	
	function getalllocation()
	{
		
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$location = $this->loadModel('Location');
		$locationarray = $location->getAll($arr);
		echo json_encode($locationarray);
			
		
	}
	
	function getalocation()
	{
		$viewper = $this->CheckPermission(32, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['locationid'];
			$location = $this->loadModel('Location');
			$locationarray = $location->getDetail($gid);
			echo json_encode($locationarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}			
	}
	
	/** 
     * Functions for perfom operation on location table
     * getall function fetching location list
	 * @returning json array of data as result
     */
	function createlocation()
	{
		$addper = $this->CheckPermission(32, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['locname'];
			$arr[3] = $_POST['address'];
			$arr[4] = $_POST['landmark'];
			$arr[5] = $_POST['country'];
			$arr[6] = $_POST['city'];
			$arr[7] = $_POST['zipcode'];
			
			$dept = $this->loadModel('Location');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on location table
     * delete function from location list
	 * @returning json array of data as result
     */
	 
	 function updatedelocation()
	{
		$editper = $this->CheckPermission(32, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['locname'];
			$arr[3] = $_POST['address'];
			$arr[4] = $_POST['landmark'];
			$arr[5] = $_POST['country'];
			$arr[6] = $_POST['city'];
			$arr[7] = $_POST['zipcode'];
			$arr[8] = $_POST['locationid'];
			
			$dept = $this->loadModel('Location');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletelocation($did)
	{
		$deleteper = $this->CheckPermission(32, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Location');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getLocationData()
	{
		try{
		
		$editper = $this->CheckPermission(32, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(32, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$location = $this->loadModel('Location');
		$locationarray = $location->getDataTable($editper, $deleteper);
		echo json_encode($locationarray);
		}catch(Exception $e){}
	}
	
	function viewlocation($id,$val)
    {
		$viewper = $this->CheckPermission(41, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
			{
				if(isset($id) && isset($val))
				{
					$datalist = $this->loadModel('Setup');
						$orgid = $_SESSION['ubihrm_org_id'];
					$this->view->data = $datalist->RelatedList('LocationMaster',$orgid);
					
					$dept = $this->loadModel('Location');
					$this->view->locationid = $id;
					$this->view->val = $val;
					$this->view->render('setup/location/addeditlocation');
				}else{
					header('location: ' . URL . 'setup/location');
				}
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
    }
	
	
	/** 
	 									
	 ////////////////////////////////     LOCATION CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	
	 ////////////////////////////////     ROLE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on Role table
     * getall function fetching Role list
	 * @returning json array of data as result
     */
	 function roles()
    {
       	$viewper = $this->CheckPermission(39, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(39, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			 $this->view->render('setup/roles/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}

    }
	
	function addrole()
    {
		$addper = $this->CheckPermission(39, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->roleid =0;
        $this->view->render('setup/roles/addeditrole');
		}else{
			header('location: ' . URL . 'setup/roles');
		}
    }
	
	function editrole($id)
    {
		$editper = $this->CheckPermission(39, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->roleid = $id; //$dept->getDetail($id);
			$this->view->render('setup/roles/addeditrole');
		}else{
			header('location: ' . URL . 'setup/roles');
		}
    }
	
	function getallrole()
	{
		$viewper = $this->CheckPermission(39, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['roleid'];
			$role = $this->loadModel('Role');
			$rolearray = $role->getAll($arr);
			echo json_encode($rolearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	
	//////////////
	
	function getallrole1()
	{
		$viewper = $this->CheckPermission(39, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			//$arr[2] = $_POST['roleid'];
			$role = $this->loadModel('Role');
			$rolearray = $role->getAll1($arr);
			echo json_encode($rolearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		

		
	}
	
	//////////////
	
	function getarole()
	{
		$viewper = $this->CheckPermission(39, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['roleid'];
			$role = $this->loadModel('Role');
			$rolearray = $role->getDetail($gid);
			echo json_encode($rolearray);	
				
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	
	/** 
     * Functions for perfom operation on role table
     * getall function fetching role list
	 * @returning json array of data as result
     */
	function createrole()
	{
		$addper = $this->CheckPermission(39, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['rolename'];
			$arr[3] = $_POST['parentid'];
			$arr[4] = $_POST['desc'];
			$arr[5] = $_POST['cloneid'];
			$dept = $this->loadModel('Role');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on role table
     * delete function from role list
	 * @returning json array of data as result
     */
	 
	 function updatederole()
	{
		$editper = $this->CheckPermission(39, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['rolename'];
			$arr[3] = $_POST['parentid'];
			$arr[4] = $_POST['desc'];
			$arr[5] = $_POST['roleid'];
			$dept = $this->loadModel('Role');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleterole($did)
	{
		$deleteper = $this->CheckPermission(39, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Role');
			$deptarray = $dept->Delete($did);
		}			
		header('location: ' . URL . 'setup/roles');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getRoleData()
	{
		$editper = $this->CheckPermission(39, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(39, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$role = $this->loadModel('Role');
		$rolearray = $role->getDataTable($editper, $deleteper);
		echo json_encode($rolearray);
		
	}
	
	function viewrole($id,$val)
    {
		$viewper = $this->CheckPermission(39, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
			{
				if(isset($id) && isset($val))
			{
				//$datalist = $this->loadModel('Setup');
					//$orgid = $_SESSION['ubihrm_org_id'];
				//$this->view->data = $datalist->RelatedList('LocationMaster',$orgid);
				$dept = $this->loadModel('Role');
				$this->view->roleid = $id;
				$this->view->val = $val;
				$this->view->render('setup/roles/addeditrole');
			}else{
				header('location: ' . URL . 'setup/roles');
			}	
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
    }
	
	
	/** 
	 									
	 ////////////////////////////////     ROLE CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	
	 ////////////////////////////////     HOLIDAY CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on holiday table
     * getall function fetching holiday list
	 * @returning json array of data as result
     */
	 function holiday()
    {
        $viewper = $this->CheckPermission(29, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(29, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/holiday/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
	
	function addholiday()
    {
		$addper = $this->CheckPermission(29, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->holidayid =0;
			$this->view->val =0;
			$this->view->render('setup/holiday/addeditholiday');
		}else{
			header('location: ' . URL . 'setup/holiday');
		}
    }
	
	function editholiday($id)
    {
		$editper = $this->CheckPermission(29, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->holidayid = $id;
			$this->view->val =0;			//$dept->getDetail($id);
			$this->view->render('setup/holiday/addeditholiday');
		}else{
			header('location: ' . URL . 'setup/holiday');
		}
    }
	
	function getallholiday()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$holiday = $this->loadModel('Holiday');
			$holidayarray = $holiday->getAll($arr);
			echo json_encode($holidayarray);	
				
			
	}
	
	function getaholiday()
	{
		$viewper = $this->CheckPermission(29, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['holidayid'];
			$holiday = $this->loadModel('Holiday');
			$holidayarray = $holiday->getDetail($gid);
			echo json_encode($holidayarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	/** 
     * Functions for perfom operation on holiday table
     * getall function fetching holiday list
	 * @returning json array of data as result
     */
	function createholiday()
	{
		$addper = $this->CheckPermission(29, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['holidayname'];
			$arr[3] = $_POST['desc'];
			$arr[4] = $_POST['fromdate'];
			$arr[5] = $_POST['todate'];
			$arr[6] = $_POST['division'];
			$dept = $this->loadModel('Holiday');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on holiday table
     * delete function from holiday list
	 * @returning json array of data as result
     */
	 
	 function updatedeholiday()
	{
		$editper = $this->CheckPermission(29, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['holidayname'];
			$arr[3] = $_POST['desc'];
			$arr[4] = $_POST['fromdate'];
			$arr[5] = $_POST['todate'];
			$arr[6] = $_POST['division'];
			$arr[7] = $_POST['holidayid'];
			$dept = $this->loadModel('Holiday');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteholiday($did)
	{
		$deleteper = $this->CheckPermission(29, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Holiday');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getHolidayData()
	{
		$editper = $this->CheckPermission(29, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(29, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$holiday = $this->loadModel('Holiday');
		$holidayarray = $holiday->getDataTable($editper, $deleteper);
		echo json_encode($holidayarray);
	}
	
	
		/** 
	 									
	 ////////////////////////////////     HOLIDAY CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	
	 ////////////////////////////////     TEMPLATE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on template table
     * getall function fetching template list
	 * @returning json array of data as result
     */
	 function template()
    {
        $viewper = $this->CheckPermission(45, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(45, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/template/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}

    }
	
	function addtemplate()
    {
		$addper = $this->CheckPermission(45, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->templateid =0;
			$this->view->val =0;
			$this->view->render('setup/template/addedittemplate');
		}else{
			header('location: ' . URL . 'setup/template');
		}
    }
	
	function edittemplate($id)
    {
		$editper = $this->CheckPermission(45, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->templateid = $id; //$dept->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/template/addedittemplate');
		}else{
			header('location: ' . URL . 'setup/template');
		}
    }
	function viewtemplate($id,$val)
    {
		$editper = $this->CheckPermission(45, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->templateid = $id; //$dept->getDetail($id);
			$this->view->val =$val;
			$this->view->render('setup/template/addedittemplate');
		}else{
			header('location: ' . URL . 'setup/template');
		}
    }
	
	function getalltemplate()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$template = $this->loadModel('Template');
			$templatearray = $template->getAll($arr);
			echo json_encode($templatearray);	
			
					
	}
	
	function getatemplate()
	{
		$viewper = $this->CheckPermission(45, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['templateid'];
			$template = $this->loadModel('Template');
			$templatearray = $template->getDetail($gid);
			echo json_encode($templatearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	/** 
     * Functions for perfom operation on template table
     * getall function fetching template list
	 * @returning json array of data as result
     */
	function createtemplate()
	{
		$addper = $this->CheckPermission(45, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['templatename'];
			$arr[3] = $_POST['desc'];
			$dept = $this->loadModel('Template');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on template table
     * delete function from template list
	 * @returning json array of data as result
     */
	 
	 function updatedetemplate()
	{
		$editper = $this->CheckPermission(45, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['templatename'];
			$arr[3] = $_POST['desc'];
			$arr[4] = $_POST['templateid'];
			$dept = $this->loadModel('Template');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletetemplate($did)
	{
		$deleteper = $this->CheckPermission(45, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Template');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	
	function getallemployee()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$employee = $this->loadModel('Employee');
			$employeearray = $employee->getAll($arr);
			echo json_encode($employeearray);	
			
					
	}
	
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getTemplateData()
	{
		$editper = $this->CheckPermission(45, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(45, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$template = $this->loadModel('Template');
		$templatearray = $template->getDataTable($editper, $deleteper);
		echo json_encode($templatearray);
	}
	
	/** 
	 									
	 ////////////////////////////////     TEMPLATE CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	
	 ////////////////////////////////     ASSET CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on asset table
     * getall function fetching asset list
	 * @returning json array of data as result
     */
	 function asset()
    {
       $viewper = $this->CheckPermission(4, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(4, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/asset/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
	
	function addasset()
    {
		$addper = $this->CheckPermission(4, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->assetid =0;
			$this->view->val =0;
			$this->view->render('setup/asset/addeditasset');
		}else{
			header('location: ' . URL . 'setup/asset');
		}
    }
	
	function editasset($id)
    {
		$editper = $this->CheckPermission(4, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->assetid = $id; //$dept->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/asset/addeditasset');
		}else{
			header('location: ' . URL . 'setup/asset');
		}
    }
	
	function getallasset()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$asset = $this->loadModel('Asset');
			$assetarray = $asset->getAll($arr);
			echo json_encode($assetarray);	
			
			
	}
	
	function getaasset()
	{
		$viewper = $this->CheckPermission(4, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['assetid'];
			$asset = $this->loadModel('Asset');
			$assetarray = $asset->getDetail($gid);
			echo json_encode($assetarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	/** 
     * Functions for perfom operation on asset table
     * getall function fetching asset list
	 * @returning json array of data as result
     */
	function createasset()
	{
		$addper = $this->CheckPermission(4, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['assetname'];
			$arr[3] = $_POST['desc'];
			$dept = $this->loadModel('Asset');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on asset table
     * delete function from asset list
	 * @returning json array of data as result
     */
	 
	 function updatedeasset()
	{
		
		$editper = $this->CheckPermission(4, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['assetname'];
			$arr[3] = $_POST['desc'];
			$arr[4] = $_POST['assetid'];
			$dept = $this->loadModel('Asset');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteasset($did)
	{
		$deleteper = $this->CheckPermission(4, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Asset');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getAssetData()
	{
		$editper = $this->CheckPermission(4, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(4, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$asset = $this->loadModel('Asset');
		$assetarray = $asset->getDataTable($editper, $deleteper);
		echo json_encode($assetarray);
	}
	
	
	function viewasset($id,$val)
    {
		$viewper = $this->CheckPermission(4, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
			{
				if(isset($id) && isset($val))
				{
					$datalist = $this->loadModel('Setup');
					$orgid = $_SESSION['ubihrm_org_id'];
					$this->view->data = $datalist->RelatedList('AssetsMaster',$orgid);
					
					$dept = $this->loadModel('Asset');
					$this->view->assetid = $id; //$dept->getDetail($id);
					$this->view->val = $val;
					$this->view->render('setup/asset/addeditasset');
				}else{
					header('location: ' . URL . 'setup/asset');
				}
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		
    }
	
	
	/** 
	 									
	 ////////////////////////////////     ASSET CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	
	 ////////////////////////////////    checklist Category CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on category table
     * getall function fetching category list
	 * @returning json array of data as result
     */
	function category()
    {
		$viewper = $this->CheckPermission(8, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(8, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->catid=false;
			$this->view->render('setup/category/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
	
	function addcategory()
    {
		$addper = $this->CheckPermission(8, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->categoryid =0;
			$this->view->val =0;
        $this->view->render('setup/category/addeditcategory');
		}else{
			header('location: ' . URL . 'setup/category');
		}
    }
	
	function editcategory($id)
    {
		$editper = $this->CheckPermission(8, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->categoryid = $id; //$dept->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/category/addeditcategory');
		}else{
			header('location: ' . URL . 'setup/category');
		}
    }
	
	function getallcategory()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['typeid'];
			$category = $this->loadModel('Category');
			$categoryarray = $category->getAll($arr);
			echo json_encode($categoryarray);	
			
					
	}
	function getalltype()
	{
		$viewper = $this->CheckPermission(8, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$category = $this->loadModel('Category');
			$categoryarray = $category->getAllType();
			echo json_encode($categoryarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	function getacategory()
	{
		$viewper = $this->CheckPermission(8, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['categoryid'];
			$category = $this->loadModel('Category');
			$categoryarray = $category->getDetail($gid);
			echo json_encode($categoryarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	
	/** 
     * Functions for perfom operation on category table
     * getall function fetching category list
	 * @returning json array of data as result
     */
	function createcategory()
	{
		$addper = $this->CheckPermission(8, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['categoryname'];
			$arr[3] = $_POST['desc'];
			$arr[4] = $_POST['typeid'];
			$dept = $this->loadModel('Category');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}

		
	}
	
	 /**
     * Functions for perfom operation on category table
     * delete function from category list
	 * @returning json array of data as result
     */
	 
	 function updatedecategory()
	{
		$editper = $this->CheckPermission(8, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['categoryname'];
			$arr[3] = $_POST['desc'];
			$arr[4] = $_POST['typeid'];
			$arr[5] = $_POST['categoryid'];
			$dept = $this->loadModel('Category');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletecategory($did)
	{
		$deleteper = $this->CheckPermission(8, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Category');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCategoryData()
	{
		$editper = $this->CheckPermission(8, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(8, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$category = $this->loadModel('Category');
		$categoryarray = $category->getDataTable($editper, $deleteper);
		echo json_encode($categoryarray);
	}
	
	
	function viewcategory($id,$val)
    {
		$viewper = $this->CheckPermission(8, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
			{
				if(isset($id) && isset($val))
				{
					//$datalist = $this->loadModel('Setup');
						//$orgid = $_SESSION['ubihrm_org_id'];
					//$this->view->data = $datalist->RelatedList('AssetsMaster',$orgid);
					
					$dept = $this->loadModel('Category');
					$this->view->categoryid = $id; //$dept->getDetail($id);
					$this->view->val = $val;
					$this->view->render('setup/category/addeditcategory');
				}else{
					header('location: ' . URL . 'setup/category');
				}
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
    }
	
	/** 
	 									
	 /////////////////////////////     CHECKLIST CATEGORY CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	
	 /////////////////////////////    CHECKLIST CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on checklist table
     * getall function fetching checklist list
	 * @returning json array of data as result
     */
	
	function checklist()
    {
		$viewper = $this->CheckPermission(10, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(10, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->catid=true;
			$this->view->render('setup/checklist/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
	function addchecklist()
    {
		$addper = $this->CheckPermission(10, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->checklistid =0;
			$this->view->val =0;
			$this->view->render('setup/checklist/addeditchecklist');
		}else{
			header('location: ' . URL . 'setup/checklist');
		}
    }
	
	function editchecklist($id)
    {
		$editper = $this->CheckPermission(10, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->checklistid = $id; //$dept->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/checklist/addeditchecklist');
		}else{
			header('location: ' . URL . 'setup/checklist');
		}
    }
	
	function getallchecklist()
	{
		$viewper = $this->CheckPermission(10, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$checklist = $this->loadModel('Checklist');
			$checklistarray = $checklist->getAll($arr);
			echo json_encode($checklistarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}	
	}
	
	function getachecklist()
	{
		$viewper = $this->CheckPermission(10, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['checklistid'];
			$checklist = $this->loadModel('Checklist');
			$checklistarray = $checklist->getDetail($gid);
			echo json_encode($checklistarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}	
	}
	
	/** 
     * Functions for perfom operation on checklist table
     * getall function fetching checklist list
	 * @returning json array of data as result
     */
	function createchecklist()
	{
		$addper = $this->CheckPermission(10, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['checklistname'];
			$arr[3] = $_POST['catid'];
			$dept = $this->loadModel('Checklist');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on checklist table
     * delete function from checklist list
	 * @returning json array of data as result
     */
	 
	 function updatedechecklist()
	{
		$editper = $this->CheckPermission(10, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['checklistname'];
			$arr[3] = $_POST['catid'];
			$arr[4] = $_POST['checklistid'];
			$dept = $this->loadModel('Checklist');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletechecklist($did)
	{
		$deleteper = $this->CheckPermission(10, 3); ///////// CHECK FOR DELETE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Checklist');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getChecklistData()
	{
		$editper = $this->CheckPermission(10, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(10, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$checklist = $this->loadModel('Checklist');
		$checklistarray = $checklist->getDataTable($editper, $deleteper);
		echo json_encode($checklistarray);
	}
	
	function viewdetail($id,$table,$dfields)
	{
		$viewper = $this->CheckPermission(10, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
			{
				if(isset($table) && isset($id) && isset($dfields))
				{
					$datalist = $this->loadModel('Setup');
						$orgid = $_SESSION['ubihrm_org_id'];
						$this->view->table = $table;
					$this->view->id = $id;
					$this->view->data = $datalist->RelatedList($table,$orgid);
					
					$this->view->data1 = $datalist->viewData($table,$id,$dfields);
					$this->view->render('setup/viewdetail');
				}
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	//////////////////////////////////  CHECKLIST CONTROLLER FUNCTION ENDS HERE  ////////////////////////////  
	
	 ////////////////////////////////     USER CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perfom operation on Role table
     * getall function fetching Role list
	 * @returning json array of data as result
     */
	 function users()
    {
        $viewper = $this->CheckPermission(46, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(46, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/users/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
	
	function adduser()
    {
		$addper = $this->CheckPermission(46, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->userid =0;
			$this->view->val =0;
			$this->view->render('setup/users/addedituser');
		}else{
			header('location: ' . URL . 'setup/users');
		}
    }
	
	function edituser($id)
    {
		$editper = $this->CheckPermission(46, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->userid = $id; //$dept->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/users/addedituser');
		}else{
			header('location: ' . URL . 'setup/users');
		}
    }
	
	function getallusers()
	{
		$viewper = $this->CheckPermission(46, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['userid'];
			$user = $this->loadModel('User');
			$userarray = $user->getAll($arr);
			echo json_encode($userarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	
		
	function getauser()
	{
		try{
		$viewper = $this->CheckPermission(46, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['userid'];
			$user = $this->loadModel('User');
			$userarray = $user->getDetail($gid);
			echo json_encode($userarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	
	function getempuser()
	{
		$viewper = $this->CheckPermission(46, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$orgid = $_SESSION['ubihrm_org_id'];
			$user = $this->loadModel('User');
			$userarray = $user->getEmployee($orgid);
			echo json_encode($userarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getroleuser()
	{
		$viewper = $this->CheckPermission(46, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$orgid = $_SESSION['ubihrm_org_id'];
			$user = $this->loadModel('User');
			$userarray = $user->getRole($orgid);
			echo json_encode($userarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	/** 
     * Functions for perfom operation on role table
     * getall function fetching role list
	 * @returning json array of data as result
     */
	function createuser()
	{
		try{
		$addper = $this->CheckPermission(46, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['profilename'];
			$arr[4] = $_POST['username'];
			$arr[5] = $_POST['password'];
			$arr[6] = $_POST['adminsts'];
			$arr[7] = $_POST['hrsts'];
			$arr[8] = $_POST['usermob'];
			$user = $this->loadModel('User');
			$userarray = $user->Create($arr);
			echo json_encode($userarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
			}		
	}
	
	function createalluser()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$user = $this->loadModel('User');
			$userarray = $user->CreateAll($arr);
			echo json_encode($userarray);		
			
	}
	
	 /**
     * Functions for perfom operation on role table
     * delete function from role list
	 * @returning json array of data as result
     */
	 
	 function updatedeuser()
	{
		$editper = $this->CheckPermission(46, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['profilename'];
			$arr[4] = $_POST['username'];
			$arr[5] = $_POST['password'];
			$arr[6] = $_POST['userid'];
			$arr[7] = $_POST['adminsts'];
			$arr[8] = $_POST['hrsts'];
			$arr[9] = $_POST['usermob'];
			$user = $this->loadModel('User');
			$userarray = $user->Update($arr);
			echo json_encode($userarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteuser($did)
	{
		$deleteper = $this->CheckPermission(46, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$duser = $this->loadModel('User');
			$userarray = $duser->Delete($did);
			echo json_encode($userarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}		
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getUserData()
	{
		try{
		$editper = $this->CheckPermission(46, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(46, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$user = $this->loadModel('User');
		$userarray = $user->getDataTable($editper, $deleteper);
		echo json_encode($userarray);
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	function getUserData1()
	{
		try{
		$editper = true;   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = true;  ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$user = $this->loadModel('User');
		$userarray = $user->getDataTable1($editper, $deleteper);
		echo json_encode($userarray);
		}catch(Exception $e)
		{}
	}
	
	function viewuser($id,$val)
    {
		$viewper = $this->CheckPermission(46, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
			{
				if(isset($id) && isset($val))
				{
					
					$user = $this->loadModel('User');
					$this->view->userid = $id;
					$this->view->val = $val;
					$this->view->render('setup/users/addedituser');
				}else{
					header('location: ' . URL . 'setup/users');
				}
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
    }
	
	function adduserstatus($id)
	{
	
		$editper = $this->CheckPermission(46, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper && isset($id)){
			$arr=array();
			$arr[0] = $_SESSION['ubihrm_org_id'];
			$arr[1]=$id;
			$user = $this->loadModel('User');
			$userarray = $user->AddUserStatus($arr);
			echo json_encode($userarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'setup/users');
	}
	function OnChangeUserSts($id)
	{
	
		$editper = $this->CheckPermission(46, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper && isset($id)){
			$arr=array();
			$arr[0] = $_SESSION['ubihrm_org_id'];
			$arr[1]=$id;
			$user = $this->loadModel('User');
			$userarray = $user->OnChangeUserSts($arr);
			echo json_encode($userarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'setup/users');
	}
	function adduserhrstatus($id)
	{
	
		$editper = $this->CheckPermission(46, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper && isset($id)){
			$arr=array();
			$arr[0] = $_SESSION['ubihrm_org_id'];
			$arr[1]=$id;
			$user = $this->loadModel('User');
			$userarray = $user->adduserhrstatus($arr);
			echo json_encode($userarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'setup/users');
	}
	
	
	 									
	 ////////////////////////////////     USER CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	
	
	 ////////////////////////////////     PERMISSION CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
	function permission()
    {
        $viewper = $this->CheckPermission(47, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(47, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/permission/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
	
	function addpermission()
    {
		$addper = $this->CheckPermission(47, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->permissionid =0;
			$this->view->val =0;
			$this->view->render('setup/permission/addeditpermission');
		}else{
			header('location: ' . URL . 'setup/permission');
		}
    }
	
	function editpermission($id)
    {
		$editper = $this->CheckPermission(47, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->permissionid = $id; //$dept->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/permission/addeditpermission');
		}else{
			header('location: ' . URL . 'setup/permission');
		}
    }
	
	function getallpermission()
	{
		$viewper = $this->CheckPermission(47, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['permissionid'];
			$permission = $this->loadModel('Permission');
			$perarray = $permission->getAll($arr);
			echo json_encode($perarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}			
	}
	
		
	function getapermission()
	{
		$viewper = $this->CheckPermission(47, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['permissionid'];
			$orgid = $_SESSION['ubihrm_org_id'];
			$permission = $this->loadModel('Permission');
			$perarray = $permission->getDetail($gid, $orgid);
			echo json_encode($perarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}			
	}
	
	function getmodulepermission()
	{
		//$orgid = $_SESSION['ubihrm_org_id'];
		$permissions = $this->loadModel('Permission');
		$perarray = $permissions->getModules();
		echo json_encode($perarray);	
		
	}
	
	/** 
     * Functions for perfom operation on role table
     * getall function fetching role list
	 * @returning json array of data as result
     */
	function createpermission()
	{
		$addper = $this->CheckPermission(47, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['jsonarr'];
			$arr[3] = $_POST['rolename'];
			$permission = $this->loadModel('Permission');
			$perarray = $permission->Create($arr);
			echo json_encode($perarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on role table
     * delete function from role list
	 * @returning json array of data as result
     */
	 
	 function updatedepermission()
	{
		$editper = $this->CheckPermission(47, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['jsonarr'];
			$arr[3] = $_POST['permissionid'];
			$permission = $this->loadModel('Permission');
			$perarray = $permission->Update($arr);
			echo json_encode($perarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletepermission($did)
	{
		$deleteper = $this->CheckPermission(47, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dpermission = $this->loadModel('Permission');
			$perarray = $dpermission->Delete($did);
		}			
		header('location: ' . URL . 'setup/permission');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getPermissionData()
	{
		$editper = $this->CheckPermission(47, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(47, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$permission = $this->loadModel('Permission');
		$perarray = $permission->getDataTable($editper, $deleteper);
		echo json_encode($perarray);
	}
	
	function viewpermission($id,$val)
    {
		$viewper = $this->CheckPermission(47, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			if(isset($id) && isset($val))
			{
				
				$permission = $this->loadModel('Permission');
				$this->view->permissionid = $id;
				$this->view->val = $val;
				$this->view->render('setup/permission/addeditpermission');
			}else{
				header('location: ' . URL . 'setup/permission');
			}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
    }
    
    ////////////////////////////////     PERMISSION CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
		//////////////User Profile Permission CONTROLLER FUNCTION Start HERE  /////////
	function UserProfile(){
		try{
			$viewper = $this->CheckPermission(47, 1); /////CHECK FOR VIEW PERMISSION////
			if($viewper){
				$addper = $this->CheckPermission(47, 4); ///CHECK FOR ADD EMPLOYEE PERMISSION  /////
				$this->view->addper =$addper;
				$this->view->render('setup/userprofile/index');
			}else{
				header('location: ' . URL . 'setup/index');
			}
		}catch(Exception $e){}
    }
	function getUserProfileData(){
		try{
			$editper = $this->CheckPermission(47, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$deleteper = $this->CheckPermission(47, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
			$permission = $this->loadModel('Userprofile');
			$perarray = $permission->getDataTable($editper, $deleteper);
			echo json_encode($perarray);
		}catch(Exception $e){}
	}
	function addUserProfile(){
		try{
			$addper = $this->CheckPermission(47, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			if($addper){
				$this->view->permissionid =0;
				$this->view->val =0;
				$this->view->render('setup/userprofile/addedituserprofile');
			}else{
				header('location: ' . URL . 'setup/permission');
			}
		}catch(Exception $e){}
    }
	function createUserProfile(){
		try{
			$addper = $this->CheckPermission(47, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
			if($addper)
			{
				$arr = array();
				$arr[0] = $_SESSION['ubihrm_user_id'];
				$arr[1] = $_SESSION['ubihrm_org_id'];
				$arr[2] = $_POST['jsonarr'];
				$arr[3] = $_POST['profilename'];
				$permission = $this->loadModel('Userprofile');
				$perarray = $permission->Create($arr);
				echo json_encode($perarray);	
			}else{
				$result = array();
				$result['status']=false;
				$result['errorMsg']="You don't have data add permission";
				echo json_encode($result);		
			}
		}catch(Exception $e){}
	}
	function editUserProfile($id){
		try{
			$editper = $this->CheckPermission(47, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
			if(isset($id) && ($editper))
			{
				$this->view->permissionid = Utils::decode5t($id); //$dept->getDetail($id);
				$this->view->val =0;
				$this->view->render('setup/userprofile/addedituserprofile');
			}else{
				header('location: ' . URL . 'setup/permission');
			}
		}catch(Exception $e){}
    }
	function getaUserProfilepermission(){
		try{
			$viewper = $this->CheckPermission(47, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
			if($viewper)
			{
				$gid = $_POST['permissionid'];
				$orgid = $_SESSION['ubihrm_org_id'];
				$permission = $this->loadModel('Userprofile');
				$perarray = $permission->getDetail($gid, $orgid);
				echo json_encode($perarray);	
				
			}else{
				$result = array();
				$result['status']=false;
				$result['errorMsg']="You don't have data view permission";
				echo json_encode($result);		
			}
		}catch(Exception $e){}		
	}
	function updatedeUserProfilepermission(){
		try{
		$editper = $this->CheckPermission(47, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['jsonarr'];
			$arr[3] = $_POST['profilename'];
			$arr[4] = $_POST['permissionid'];
			$permission = $this->loadModel('Userprofile');
			$perarray = $permission->Update($arr);
			echo json_encode($perarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}		
	}
	function getallUserProfile(){
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Userprofile');
			$deptarray = $dept->getAll($arr);
			echo json_encode($deptarray);
		}catch(Exception $e){}	
					
	}
	////////User Profile Permission CONTROLLER FUNCTION ENDS HERE///////////
	
	 ////////////////////////////////     POLICY CONTROLLER FUNCTION STARTS HERE  //////////////////////////
	 
	function policy()
	{
    	$viewper = $this->CheckPermission(54, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(54, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			 $this->view->render('setup/policy/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
	}	 
	
	function getPolicyData()
		{
		$editper = $this->CheckPermission(54, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(54, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$relatedlist = $this->loadModel('Policy');
		$relatedlistarray = $relatedlist->getDataTable($editper, $deleteper);
		echo json_encode($relatedlistarray);
		}
	 
	 
	function createpolicy()
    	{
		$addper = $this->CheckPermission(54, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['categoryid'];
			$arr[3] = $_POST['policyname'];
			$arr[4] = $_POST['applydate'];
			$policy = $this->loadModel('Policy');
			$listarray = $policy->create($arr);
			echo json_encode($listarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
    	}
    	
    function addpolicy()
		{
			$addper = $this->CheckPermission(54, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			if($addper){
				$this->view->policyid =0;
				$this->view->val =0;
				$this->view->render('setup/policy/addeditpolicy');
			}else{
				header('location: ' . URL . 'setup/policy');
			}
		}
    
    function getpolicy()
	{
		$viewper = $this->CheckPermission(54, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['policyid'];
			$relatedlist = $this->loadModel('Policy');
			$relatedlistarray = $relatedlist->getDetail($gid);
			echo json_encode($relatedlistarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	
	function editpolicy($id)
    {
		$editper = $this->CheckPermission(54, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->policyid = $id; 
			$this->view->val =0;
			$this->view->render('setup/policy/addeditpolicy');
		}else{
			header('location: ' . URL . 'setup/policy');
		}
    }
    
    function getallpolicy()
    {
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$Policy = $this->loadModel('Policy');
			$listarr = $Policy->getAll($arr);
			echo json_encode($listarr);
			
			
    }
          
    function updatedpolicy()
	{
		$editper = $this->CheckPermission(54, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['categoryid'];
			$arr[3] = $_POST['policyname'];
			$arr[4] = $_POST['applydate'];
			$arr[5] = $_POST['policyid'];
			$policy = $this->loadModel('Policy');
			$policyarray = $policy->Update($arr);
			echo json_encode($policyarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
    
    
    function deletepolicy($did)
	{
		$deleteper = $this->CheckPermission(54, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$list = $this->loadModel('Policy');
			$listarray = $list->Delete($did);
			echo json_encode($listarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
    
	 
	  ////////////////////////////////    POLICY CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	
	 ////////////////////////////////     FISCAL CONTROLLER FUNCTION STARTS HERE  //////////////////////////
	 
	function fiscal()
	{	
        $viewper = $this->CheckPermission(55, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(55, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/fiscal/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
	}	 
	
	function createfiscal()
    {
		$addper = $this->CheckPermission(55, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['fiscalname'];
			$arr[3] = $_POST['startdate'];
			$arr[4] = $_POST['enddate'];
			$fiscal = $this->loadModel('Fiscal');
			$listarray = $fiscal->create($arr);
			echo json_encode($listarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
    }
    	
    function addfiscal()
		{		
		$addper = $this->CheckPermission(55, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->fiscalid =0;
			$this->view->val =0;
        $this->view->render('setup/fiscal/addeditfiscal');
		}else{
			header('location: ' . URL . 'setup/fiscal');
		}
		}
    
    function getafiscal()
	{
		$viewper = $this->CheckPermission(55, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['fiscalid'];
			$relatedlist = $this->loadModel('Fiscal');
			$relatedlistarray = $relatedlist->getDetail($gid);
			echo json_encode($relatedlistarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}	
	}
	
	function editfiscal($id)
    {
		$editper = $this->CheckPermission(55, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->fiscalid = $id; 
			$this->view->val =0;
			$this->view->render('setup/fiscal/addeditfiscal');
		}else{
			header('location: ' . URL . 'setup/fiscal');
		}
    }
    
    function updatedfiscal()
	{
		$editper = $this->CheckPermission(55, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['fiscalname'];
			$arr[3] = $_POST['startdate'];
			$arr[4] = $_POST['enddate'];
			//$arr[5] = $_POST['fiscalsts'];
			$arr[6] = $_POST['fiscalid'];
			$fiscal = $this->loadModel('Fiscal');
			$fiscalarray = $fiscal->Update($arr);
			echo json_encode($fiscalarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
    
    
    function deletefiscal($did)
	{
		$deleteper = $this->CheckPermission(55, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$list = $this->loadModel('Fiscal');
			$listarray = $list->Delete($did);
		}	
				
		header('location: ' . URL . 'setup/fiscal');
		//$this->view->render('setup/fiscal/index');
	}
	
    function getallfiscal()
    {
		$viewper = $this->CheckPermission(55, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$fiscal = $this->loadModel('Fiscal');
			$listarr = $fiscal->getAll($arr);
			echo json_encode($listarr);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}	
    }
	
	function getFiscalData()
	{
		$editper = $this->CheckPermission(55, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(55, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$relatedlist = $this->loadModel('Fiscal');
		$relatedlistarray = $relatedlist->getDataTable($editper, $deleteper);
		echo json_encode($relatedlistarray);
	}
	  ////////////////////////////////    FISCAL CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	
	
	 ////////////////////////////////     ROOTFARE CONTROLLER FUNCTION STARTS HERE  //////////////////////////
	 
	function rootfare()
	{	
        $viewper = $this->CheckPermission(61, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(61, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/rootfare/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
	}	 
	
	function importrootfare()
	{		
		$addper = $this->CheckPermission(61, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->rootfareid =0;
			$this->view->render('setup/rootfare/import');
		}else{
			header('location: ' . URL . 'setup/rootfare');
		}
	}
	
	function importrootfaredata()
	{		
		$addper = $this->CheckPermission(61, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['dpcity'];
			$arr[3] = $_POST['arcity'];
			$arr[4] = $_POST['adultfare'];
			$arr[5] = $_POST['infantfare'];
			$arr[6] = $_POST['childfare'];
			$arr[7] = $_POST['tickettype'];
			
			$rootfare = $this->loadModel('Rootfare');
			$rootfarearray = $rootfare->insertFileHeaders($arr);
			echo json_encode($rootfarearray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);
		}
	}
    	
    function addrootfare()
	{		
		$addper = $this->CheckPermission(61, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->rootfareid =0;
			$this->view->val =0;
        $this->view->render('setup/rootfare/addeditrootfare');
		}else{
			header('location: ' . URL . 'setup/rootfare');
		}
	}
    
    function getarootfare()
	{
		$viewper = $this->CheckPermission(61, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['rootfareid'];
			$relatedlist = $this->loadModel('Rootfare');
			$relatedlistarray = $relatedlist->getDetail($gid);
			echo json_encode($relatedlistarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}	
	}
	function getrootfare()
	{
			$arr=array();
			$arr[0] = $_POST['fromcity'];
			$arr[1] = $_POST['tocity'];
			$arr[2] = $_POST['ticketclass'];
			$relatedlist = $this->loadModel('Rootfare');
			$relatedlistarray = $relatedlist->getFare($arr);
			echo json_encode($relatedlistarray);
			
		
	}
	
	function editrootfare($id)
    {
		$editper = $this->CheckPermission(61, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->rootfareid = $id; 
			$this->view->val =0;
			$this->view->render('setup/rootfare/addeditrootfare');
		}else{
			header('location: ' . URL . 'setup/rootfare');
		}
    }
    
    function updatedrootfare()
	{
		$editper = $this->CheckPermission(61, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['fromcity'];
			$arr[3] = $_POST['tocity'];
			$arr[4] = $_POST['fromcountry'];
			$arr[5] = $_POST['tocountry'];
			$arr[6] = $_POST['rootfare'];
			$arr[7] = $_POST['tickettype'];
			$arr[8] = $_POST['rootfareid'];
			$arr[9] = $_POST['childticketfare'];
			$arr[10] = $_POST['infantticketfare'];
			
			$rootfare = $this->loadModel('Rootfare');
			$rootfarearray = $rootfare->Update($arr);
			echo json_encode($rootfarearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
    
    function createrootfare()
    {
		$addper = $this->CheckPermission(61, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['fromcity'];
			$arr[3] = $_POST['tocity'];
			$arr[4] = $_POST['fromcountry'];
			$arr[5] = $_POST['tocountry'];
			$arr[6] = $_POST['rootfare'];
			$arr[7] = $_POST['tickettype'];
			$arr[8] = $_POST['childticketfare'];
			$arr[9] = $_POST['infantticketfare'];
			
			$rootfare = $this->loadModel('Rootfare');
			$listarray = $rootfare->create($arr);
			echo json_encode($listarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
    }
	
    function deleterootfare($did)
	{
		$deleteper = $this->CheckPermission(61, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$list = $this->loadModel('Rootfare');
			$listarray = $list->Delete($did);
			echo json_encode($listarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
    function getallrootfare()
    {
		$viewper = $this->CheckPermission(61, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$rootfare = $this->loadModel('Rootfare');
			$listarr = $rootfare->getAll($arr);
			echo json_encode($listarr);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}	
    }
	
	function getRootfareData()
	{
		$editper = $this->CheckPermission(61, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(61, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$relatedlist = $this->loadModel('Rootfare');
		$relatedlistarray = $relatedlist->getDataTable($editper, $deleteper);
		echo json_encode($relatedlistarray);
	}
	
	
	  ////////////////////////////////    ROOTFARE CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	
	
	
	/** 
	 
	  ////////////////////////////////     DIVISION CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
										
	 ////////////////////////////////     WORKFLOW RULES CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on Workflow table
     * getall function fetching department list
	 * @returning json array of data as result
     */
	 
	function workflow()
    {
    	$viewper = $this->CheckPermission(63, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(63, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/workflow/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
	
	function getchildname()
    {
    	$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['tablename'];
			
			$dept = $this->loadModel('Workflow');
			$deptarray = $dept->getChildModuleData($arr);
			echo json_encode($deptarray);
    }
	
	function getselectedcolumndata()
    {
    	$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['tablename'];
			
			$dept = $this->loadModel('Workflow');
			$deptarray = $dept->getSelectedColumnTableData($arr);
			echo json_encode($deptarray);
    }
	
    function addworkflow()
    {
		//$dept = $this->loadModel('ImportExport');
		//$dept->UpdateModuleChildTable();
		
		$addper = $this->CheckPermission(63, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->deptid =0;
			$this->view->data ="";
			$this->view->val =0;
			$this->view->render('setup/workflow/addeditworkflow');
		}else{
			header('location: ' . URL . 'setup/workflow');
		}
    }
	function editworkflow($id)
    {
		$editper = $this->CheckPermission(63, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$dept = $this->loadModel('Workflow');
			$this->view->data ="";
			$this->view->deptid = $id; //$dept->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/workflow/add_workflow');
		}else{
			header('location: ' . URL . 'setup/workflow');
		}
    }
    
    
    function viewworkflow($id,$val)
    {
		
		
		$viewper = $this->CheckPermission(63, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			if(isset($id) && isset($val))
			{
				$datalist = $this->loadModel('Setup');
					$orgid = $_SESSION['ubihrm_org_id'];
				$this->view->data = $datalist->RelatedList('WorkflowMaster',$orgid);
				
				$dept = $this->loadModel('Workflow');
				$this->view->deptid = $id; //$dept->getDetail($id);
				$this->view->val = $val;
				$this->view->render('setup/workflow/add_workflow');
			}else{
				header('location: ' . URL . 'setup/workflow');
			}
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
    }
    
    
	
	function getallworkflow()
	{
		$viewper = $this->CheckPermission(63, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Workflow');
			$deptarray = $dept->getAll($arr);
			echo json_encode($deptarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}			
	}
	
	function getaworkflow()
	{
		$viewper = $this->CheckPermission(63, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$did = $_POST['deptid'];
			$dept = $this->loadModel('Workflow');
			$deptarray = $dept->getDetail($did);
			echo json_encode($deptarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	 /** 
     * Functions for perfom operation on Workflow table
     * getall function fetching workflow list
	 * @returning json array of data as result
     */
	function createworkflow()
	{
		$addper = $this->CheckPermission(63, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['deptname'];
			$arr[3] = $_POST['parentdeptname'];
			$arr[4] = $_POST['deptcode'];
			$dept = $this->loadModel('Workflow');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Workflow table
     * delete function from workflow list
	 * @returning json array of data as result
     */
	 
	 function updateworkflow()
	{
		$editper = $this->CheckPermission(63, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['deptname'];
			$arr[3] = $_POST['parentdeptname'];
			$arr[4] = $_POST['deptid'];
			$arr[5] = $_POST['deptcode'];
			$dept = $this->loadModel('Workflow');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Workflow table
     * delete function from workflow list
	 * @returning json array of data as result
     */
	function deleteworkflow($did)
	{
		$deleteper = $this->CheckPermission(63, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Workflow');
			$deptarray = $dept->Delete($did);
		}			
		header('location: ' . URL . 'setup/workflow');
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getWorkflowData()
	{
		$editper = $this->CheckPermission(63, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(63, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$dept = $this->loadModel('Workflow');
		$deptarray = $dept->getDataTable($editper, $deleteper);
		echo json_encode($deptarray);
	}
	
	
	
	 /** 
	 
	  ////////////////////////////////     WORKFLOW RULES CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
										
	
     */
	
	 ////////////////////////////////     SETTINGS CONTROLLER FUNCTION STARTS HERE  //////////////////////////
	 
function notifications($tabid=5)
	{	
        $viewper = $this->CheckPermission(73, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(73, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->permissionid =1;
			$this->view->val =0;
			$this->view->tabid =$tabid;
			$this->view->render('setup/notifications');
		}else{
			header('location: ' . URL . 'setup/index');
		}
	}	 
	
	function overtime()
	{	
        $viewper = $this->CheckPermission(144, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(144, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/overtime');
		}else{
			header('location: ' . URL . 'salary/index');
		}
	}
	function penalty()
	{	
        $viewper = $this->CheckPermission(310, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(310, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->penaltyid=0;
			$this->view->render('salary/settings/penalty');
		}else{
			header('location: ' . URL . 'salary/index');
		}
	}	
	
	function noticeperiod()
	{	
        $viewper = $this->CheckPermission(147, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(147, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			
			$this->view->render('setup/noticeperiod');
		}else{
			header('location: ' . URL . 'salary/index');
		}
	}	
	function salarydate()
	{	
        $viewper = $this->CheckPermission(147, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(147, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/salarydate');
		}else{
			header('location: ' . URL . 'salary/index');
		}
	}	
	
	function updatesettings()
    {
		$editper = $this->CheckPermission(147, 2);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$settings = $this->loadModel('Setting');
			$listarray = $settings->Update($arr);
			echo json_encode($listarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
    }
  
   function getasettings()
	{
		$per=($_POST['type']==1)?73:147;
		$viewper = $this->CheckPermission($per, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		try{
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['type'];
			$relatedlist = $this->loadModel('Setting');
			$relatedlistarray = $relatedlist->getTabsEvent($arr);
			echo json_encode($relatedlistarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	
    function getEventDetail()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['setid'];
			$relatedlist = $this->loadModel('Setting');
			$relatedlistarray = $relatedlist->getEventDetail($arr);
			echo json_encode($relatedlistarray);
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	function createupdatesettings()
    {
		try{
		$editper = $this->CheckPermission(147, 2);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$settings = $this->loadModel('Setting');
			$listarray = $settings->createupdatesettings($arr);
			echo json_encode($listarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
    }
  
	function enableSettings()
    {
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$settings = $this->loadModel('Setting');
			$listarray = $settings->enableSettings($arr);
			echo json_encode($listarray);
		
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
    }
	
	
	function getasettingsofnotice()
	{
		$per=($_POST['type']==1)?73:147;
		$viewper = $this->CheckPermission($per, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		try{
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['type'];
			$relatedlist = $this->loadModel('Setting');
			$relatedlistarray = $relatedlist->getNoticePeriod($arr);
			echo json_encode($relatedlistarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	
	  ////////////////////////////////    SETTINGS CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	
	  ////////////////////////////////    DASHBOARD CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
	
	function getDashboardData1()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$relatedlist = $this->loadModel('Dashboard');
		$relatedlistarray = $relatedlist->getSetupDashboard1($arr);
		echo json_encode($relatedlistarray);
	}
	
	function getDashboardData2()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_SESSION['user_empdivision'];
		$relatedlist = $this->loadModel('Dashboard');
		$relatedlistarray = $relatedlist->getSetupDashboard2($arr);
		echo json_encode($relatedlistarray);
	}
	function getDashboardData3()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$relatedlist = $this->loadModel('Dashboard');
		$relatedlistarray = $relatedlist->getSetupDashboard3($arr);
		echo json_encode($relatedlistarray);
	}
	
	
///////////////////////////////REPORT CONTROLLER STARTS HERE/////////////////////
	
	function report()
    {
		$viewper = $this->CheckPermission(110, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(110, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/reports/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
	function addreport()
    {
		$addper = $this->CheckPermission(110, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->reportid =0;
			$this->view->val = 0; 
			$this->view->render('setup/reports/addeditreport');
		}else{
			header('location: ' . URL . 'setup/report');
		}
    }
	
	function editreport($id)
    {
		$editper = $this->CheckPermission(110, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->reportid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('setup/reports/addeditreport');
		}else{
			header('location: ' . URL . 'setup/report');
		}
		
    }
	
	function viewreport1($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->reportid = Utils::decode5t($id); 
			$this->view->val = $val; 
			$this->view->render('setup/reports/addeditreport');
		}else{
			header('location: ' . URL . 'setup/report');
		}
		
    }
	function viewreport($id)
    {
		
		if(isset($id) )
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->render('setup/reports/viewreport');
		}else{
			header('location: ' . URL . 'setup/report');
		}
		
    }
	
	function deletereport($did)
	{
		$deleteper = $this->CheckPermission(110, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Report');
			$deptarray = $dept->Delete($did);
		}	
		header('location: ' . URL . 'setup/report');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getReportData()
	{
		$editper = $this->CheckPermission(110, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(110, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$tabid=5;
		$report = $this->loadModel('Report');
		$reportarray = $report->getDataTable($editper, $deleteper,$tabid);
		echo json_encode($reportarray);
	}
	
	
	//////////////////  APPROVAL PROCESS FUNCTION  ////////////////

	 function approval()
    {
    	$viewper = $this->CheckPermission(2, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(2, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			
        $this->view->render('setup/approvals/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}

    }
	
	function addapproval()
    {
        
		$addper = $this->CheckPermission(2, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->approvalid =0;
			$this->view->val =0;
			$this->view->render('setup/approvals/addeditapproval');;
		}else{
			header('location: ' . URL . 'setup/approval');
		}
    }
	
	function editapproval($id)
    {
		$editper = $this->CheckPermission(2, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->approvalid = $id; //$dept->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/approvals/addeditapproval');
		}else{
			header('location: ' . URL . 'setup/approval');
		}
    }
	
	
	function getallapproval()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$approval = $this->loadModel('Approval');
			$approvalarray = $approval->getAll($arr);
			echo json_encode($approvalarray);	
			
				
	}
	
	function getaapproval()
	{
		$viewper = $this->CheckPermission(2, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		try{
		if($viewper)
		{
			$gid = $_POST['approvalid'];
			$approval = $this->loadModel('Approval');
			$approvalarray = $approval->getDetail($gid);
			echo json_encode($approvalarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}		
	}
	
	
	function createapproval()
	{
		$addper = $this->CheckPermission(2, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['approvaltype'];
			$arr[3] = $_POST['period'];
			$arr[4] = $_POST['jsondata'];
			$arr[5] = $_POST['approvalfor'];
			$arr[6] = $_POST['hrapproval'];
			$arr[7] = $_POST['approvalupto'];
			$dept = $this->loadModel('Approval');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Approval table
     * delete function from Approval list
	 * @returning json array of data as result
     */
	 
	 function updatedeapproval()
	{
		$editper = $this->CheckPermission(2, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['approvaltype'];
			$arr[3] = $_POST['period'];
			$arr[4] = $_POST['jsondata'];
			$arr[5] = $_POST['approvalfor'];
			$arr[6] = $_POST['approvalid'];
			$arr[7] = $_POST['hrapproval'];
			$arr[8] = $_POST['approvalupto'];
			$dept = $this->loadModel('Approval');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteapproval($did)
	{
		$deleteper = $this->CheckPermission(2, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Approval');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getApprovalData()
	{
		$editper = $this->CheckPermission(2, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(2, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$approval = $this->loadModel('Approval');
		$approvalarray = $approval->getDataTable($editper, $deleteper);
		echo json_encode($approvalarray);
	}
	
	function getseniordesig()
	{
		$desig = $_POST['designationid'];
		$objective = $this->loadModel('Approval');
		$objectivearray = $objective->getSeniorDesigids($desig);
		echo json_encode($objectivearray);	
	}
	
	function hierarchy()
    	{
    		$viewper = $this->CheckPermission(145, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(145, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/hierarchy/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
		
    	}
	
	function gethierarchy()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['division'];
			$arr[3] = $_POST['department'];
			$role = $this->loadModel('Dashboard');
			$rolearray = $role->getHierarchy($arr);
			echo json_encode($rolearray);	
	}
	function getdepartmentdivisionwise($div)
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $div;
			
			$role = $this->loadModel('Dashboard');
			$rolearray = $role->getDepartments($arr);
			echo json_encode($rolearray);	
	}
	
	 ////////////////////////////////     PERSONNEL REQUISITION CONTROLLER FUNCTION STARTS HERE  //////////////////////////
	 
	function personnel_requisition()
	{
    	$viewper = $this->CheckPermission(168, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(168, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			 $this->view->render('setup/personnel_requisition/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
	}	 
	
	function getPersonnelRequisitionData()
		{
		$editper = $this->CheckPermission(168, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(168, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$relatedlist = $this->loadModel('Personnel_requisition');
		$relatedlistarray = $relatedlist->getDataTable($editper, $deleteper);
		echo json_encode($relatedlistarray);
		}
	 
	 
	function createpersonnel_requisition()
    	{
		$addper = $this->CheckPermission(168, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['designationid'];
			$arr[3] = $_POST['totalvacancy'];
			$arr[4] = $_POST['salaryrange'];
			$arr[5] = $_POST['nationality'];
			$arr[6] = $_POST['gender'];
			$arr[7] = $_POST['agelimit'];
			$arr[8] = $_POST['position'];
			$arr[9] = $_POST['emptype'];
			$arr[10] = $_POST['qualification'];
			$arr[11] = $_POST['experience'];
			$arr[12] = $_POST['budgetapp'];
			$arr[13] = $_POST['deadline'];
			$arr[14] = $_POST['jobdesc'];
			$personnel_requisition = $this->loadModel('Personnel_requisition');
			$listarray = $personnel_requisition->create($arr);
			echo json_encode($listarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
    	}
    	
    function addpersonnel_requisition()
		{
			$addper = $this->CheckPermission(168, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			if($addper){
				$this->view->perid =0;
				$this->view->val =0;
				$this->view->render('setup/personnel_requisition/addeditpersonnal_requisition');
			}else{
				header('location: ' . URL . 'setup/personnel_requisition');
			}
		}
    
    function getpersonnel_requisition()
	{
		$viewper = $this->CheckPermission(168, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['perid'];
			$relatedlist = $this->loadModel('Personnel_requisition');
			$relatedlistarray = $relatedlist->getDetail($gid);
			echo json_encode($relatedlistarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	
	function editpersonnel_requisition($id)
    {
		$editper = $this->CheckPermission(168, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->perid = $id; 
			$this->view->val =0;
			$this->view->render('setup/personnel_requisition/addeditpersonnal_requisition');
		}else{
			header('location: ' . URL . 'setup/personnel_requisition');
		}
    }
	
	function viewpersonnel_requisition($id,$val)
    {
		$editper = $this->CheckPermission(168, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->perid = $id; 
			$this->view->val =$val;
			$this->view->render('setup/personnel_requisition/addeditpersonnal_requisition');
		}else{
			header('location: ' . URL . 'setup/personnel_requisition');
		}
    }
    
    function getallpersonnel_requisition()
    {
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$Personnel_requisition = $this->loadModel('Personnel_requisition');
			$listarr = $Personnel_requisition->getAll($arr);
			echo json_encode($listarr);
			
			
    }
      
	function approvepersonnel_requisition()
	{
		$addper = $this->CheckPermission(168, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['perid'];
			$arr[3] = $_POST['approverresult'];
			$arr[4] = $_POST['comment'];
			
			$dept = $this->loadModel('Personnel_requisition');
			$deptarray = $dept->Approve($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
		
    function updatedpersonnel_requisition()
	{
		$editper = $this->CheckPermission(168, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['designationid'];
			$arr[3] = $_POST['totalvacancy'];
			$arr[4] = $_POST['salaryrange'];
			$arr[5] = $_POST['nationality'];
			$arr[6] = $_POST['gender'];
			$arr[7] = $_POST['agelimit'];
			$arr[8] = $_POST['position'];
			$arr[9] = $_POST['emptype'];
			$arr[10] = $_POST['qualification'];
			$arr[11] = $_POST['experience'];
			$arr[12] = $_POST['budgetapp'];
			$arr[13] = $_POST['deadline'];
			$arr[14] = $_POST['jobdesc'];
			$arr[15] = $_POST['perid'];
			$personnel_requisition = $this->loadModel('Personnel_requisition');
			$personnel_requisitionarray = $personnel_requisition->Update($arr);
			echo json_encode($personnel_requisitionarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
    
    
    function deletepersonnel_requisition($did)
	{
		$deleteper = $this->CheckPermission(168, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$list = $this->loadModel('Personnel_requisition');
			$listarray = $list->Delete($did);
			echo json_encode($listarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
    
	 
	  ////////////////////////////////    POLICY CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	  
	  
	  ////////////////////////////////    Channel CONTROLLER FUNCTION START HERE  ////////////////////////////
	 
	function channels()
    {
    	$viewper = $this->CheckPermission(202, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(202, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/channel/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
    function addchannel()
    {
		$addper = $this->CheckPermission(202, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->deptid =0;
			$this->view->data ="";
			$this->view->val =0;
			$this->view->render('setup/channel/add_channel');
		}else{
			header('location: ' . URL . 'setup/channel');
		}
    }
	function editchannel($id)
    {
		$editper = $this->CheckPermission(202, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$dept = $this->loadModel('channel');
			$this->view->data ="";
			$this->view->deptid = $id; //$dept->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/channel/add_channel');
		}else{
			header('location: ' . URL . 'setup/channel');
		}
    }
    
    
    function viewchannel($id,$val)
    {
		
		
		$viewper = $this->CheckPermission(202, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			if(isset($id) && isset($val))
			{
				$datalist = $this->loadModel('Setup');
					$orgid = $_SESSION['ubihrm_org_id'];
				$this->view->data = $datalist->RelatedList('DepartmentMaster',$orgid);
				
				$dept = $this->loadModel('Channel');
				$this->view->deptid = $id; //$dept->getDetail($id);
				$this->view->val = $val;
				$this->view->render('setup/channel/add_channel');
			}else{
				header('location: ' . URL . 'setup/channel');
			}
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
    }
    
    
	
	function getallchannel()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Channel');
			$deptarray = $dept->getAll($arr);
			echo json_encode($deptarray);	
			
				
	}
	
	function getachannel()
	{
		$viewper = $this->CheckPermission(202, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$did = $_POST['deptid'];
			$dept = $this->loadModel('Channel');
			$deptarray = $dept->getDetail($did);
			echo json_encode($deptarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	 /** 
     * Functions for perfom operation on Department table
     * getall function fetching department list
	 * @returning json array of data as result
     */
	function createchannel()
	{
		$addper = $this->CheckPermission(202, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['deptname'];
			$arr[3] = $_POST['parentdeptname'];
			$arr[4] = $_POST['deptcode'];
			$dept = $this->loadModel('Channel');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	 
	 function updatechannel()
	{
		$editper = $this->CheckPermission(202, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['deptname'];
			$arr[3] = $_POST['parentdeptname'];
			$arr[4] = $_POST['deptid'];
			$arr[5] = $_POST['deptcode'];
			$dept = $this->loadModel('Channel');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletechannel($did)
	{
		$deleteper = $this->CheckPermission(202, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Channel');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getChannelData()
	{
		$editper = $this->CheckPermission(202, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(202, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$dept = $this->loadModel('Channel');
		$deptarray = $dept->getDataTable($editper, $deleteper);
		echo json_encode($deptarray);
	}
	
	
	 
	  ////////////////////////////////     channel CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
	  
	   ////////////////////////////////     COSTCENTRE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perfom operation on Department table
     * getall function fetching department list
	 * @returning json array of data as result
     */
	 
	function costcentre()
    {
    	$viewper = $this->CheckPermission(204, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(204, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/costcentre/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
    function addcostcentre()
    {
		$addper = $this->CheckPermission(204, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->costcentreid =0;
			$this->view->data ="";
			$this->view->val =0;
			$this->view->render('setup/costcentre/addeditcostcentre');
		}else{
			header('location: ' . URL . 'setup/costcentre');
		}
    }
	function editcostcentre($id)
    {
		$editper = $this->CheckPermission(204, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$costcentre = $this->loadModel('Costcentre');
			$this->view->data ="";
			$this->view->costcentreid = $id; //$costcentre->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/costcentre/addeditcostcentre');
		}else{
			header('location: ' . URL . 'setup/costcentre');
		}
    }
    
    
    function viewcostcentre($id,$val)
    {
		
		
		$viewper = $this->CheckPermission(204, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			if(isset($id) && isset($val))
			{
				
				$orgid = $_SESSION['ubihrm_org_id'];
				
				$costcentre = $this->loadModel('Costcentre');
				$this->view->costcentreid = $id; //$costcentre->getDetail($id);
				$this->view->val = $val;
				$this->view->render('setup/costcentre/addeditcostcentre');
			}else{
				header('location: ' . URL . 'setup/costcentre');
			}
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
    }
    
    
	
	function getallcostcentre()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$costcentre = $this->loadModel('Costcentre');
			$costcentrearray = $costcentre->getAll($arr);
			echo json_encode($costcentrearray);	
			
				
	}
	
	function getacostcentre()
	{
		$viewper = $this->CheckPermission(204, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$did = $_POST['costcentreid'];
			$costcentre = $this->loadModel('Costcentre');
			$costcentrearray = $costcentre->getDetail($did);
			echo json_encode($costcentrearray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	 /** 
     * Functions for perfom operation on Costcentre table
     * getall function fetching costcentre list
	 * @returning json array of data as result
     */
	function createcostcentre()
	{
		$addper = $this->CheckPermission(204, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['costcentrename'];
			$arr[3] = $_POST['parentcostcentrename'];
			$arr[4] = $_POST['costcentrecode'];
			$costcentre = $this->loadModel('Costcentre');
			$costcentrearray = $costcentre->Create($arr);
			echo json_encode($costcentrearray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Costcentre table
     * delete function from costcentre list
	 * @returning json array of data as result
     */
	 
	 function updatecostcentre()
	{
		$editper = $this->CheckPermission(204, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['costcentrename'];
			$arr[3] = $_POST['parentcostcentrename'];
			$arr[4] = $_POST['costcentreid'];
			$arr[5] = $_POST['costcentrecode'];
			$costcentre = $this->loadModel('Costcentre');
			$costcentrearray = $costcentre->Update($arr);
			echo json_encode($costcentrearray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Costcentre table
     * delete function from costcentre list
	 * @returning json array of data as result
     */
	function deletecostcentre($did)
	{
		$deleteper = $this->CheckPermission(204, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$costcentre = $this->loadModel('Costcentre');
			$costcentrearray = $costcentre->Delete($did);
			echo json_encode($costcentrearray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCostcentreData()
	{
		try{
		$editper = $this->CheckPermission(204, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(204, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$costcentre = $this->loadModel('Costcentre');
		$costcentrearray = $costcentre->getDataTable($editper, $deleteper);
		echo json_encode($costcentrearray);
		}catch(Exception $e)
		{
			
		}
	}
	
	//////////////////////////////// COCENTRE CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
										
		////get salary checklist///								
	
	function getsalarychecklist()
	{
		$role = $this->loadModel('Setup');
		$rolearray = $role->getsalarychecklist();
		echo json_encode($rolearray);	
	}
	  ////////////////////////////////     COSTCENTRE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perfom operation on Department table
     * getall function fetching department list
	 * @returning json array of data as result
     */
	 
	function cocentre()
    {
    	$viewper = $this->CheckPermission(261, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(261, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('setup/CoCentre/index');
		}else{
			header('location: ' . URL . 'setup/index');
		}
    }
    function addcocentre()
    {
		$addper = $this->CheckPermission(261, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->costcentreid =0;
			$this->view->data ="";
			$this->view->val =0;
			$this->view->render('setup/CoCentre/add_costcentre');
		}else{
			header('location: ' . URL . 'setup/CoCentre');
		}
    }
	function editcocentre($id)
    {
		$editper = $this->CheckPermission(261, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$costcentre = $this->loadModel('Cocentre');
			$this->view->data ="";
			$this->view->costcentreid = $id; //$costcentre->getDetail($id);
			$this->view->val =0;
			$this->view->render('setup/CoCentre/add_costcentre');
		}else{
			header('location: ' . URL . 'setup/CoCentre');
		}
    }
    
    
    function viewcocentre($id,$val)
    {
		$viewper = $this->CheckPermission(261, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			if(isset($id) && isset($val))
			{
				$orgid = $_SESSION['ubihrm_org_id'];
				$this->view->costcentreid = $id; //$costcentre->getDetail($id);
				$this->view->val = $val;
				$this->view->render('setup/CoCentre/add_costcentre');
			}else{
				header('location: ' . URL . 'setup/CoCentre');
			}
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
    }

	function getallcocentre()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$costcentre = $this->loadModel('Cocentre');
			$costcentrearray = $costcentre->getAll($arr);
			echo json_encode($costcentrearray);	
	}
	
	function getacocentre()
	{
		$viewper = $this->CheckPermission(261, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$did = $_POST['costcentreid'];
			$costcentre = $this->loadModel('Cocentre');
			$costcentrearray = $costcentre->getDetail($did);
			echo json_encode($costcentrearray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	 /** 
     * Functions for perfom operation on Costcentre table
     * getall function fetching costcentre list
	 * @returning json array of data as result
     */
	function createcocentre()
	{
		$addper = $this->CheckPermission(261, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['ccname'];
			$arr[3] = $_POST['cccode'];
			$costcentre = $this->loadModel('Cocentre');
			$costcentrearray = $costcentre->Create($arr);
			echo json_encode($costcentrearray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Costcentre table
     * delete function from costcentre list
	 * @returning json array of data as result
     */
	 
	 function updatecocentre()
	{
		$editper = $this->CheckPermission(261, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['ccname'];
			$arr[3] = $_POST['costcentreid'];
			$arr[4] = $_POST['cccode'];
			$costcentre = $this->loadModel('Cocentre');
			$costcentrearray = $costcentre->Update($arr);
			echo json_encode($costcentrearray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Costcentre table
     * delete function from costcentre list
	 * @returning json array of data as result
     */
	function deletecocentre($did)
	{
		$deleteper = $this->CheckPermission(261, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
			if(isset($did) && $deleteper )
			{
				$costcentre = $this->loadModel('Cocentre');
				$costcentrearray = $costcentre->Delete($did);
				echo json_encode($costcentrearray);	
			}else{
				$result = array();
				$result['status']=false;
				$result['errorMsg']="You don't have delete permission";
				echo json_encode($result);		
			}
		}catch(Exception $ex){}
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCocentreData()
	{
		try{
		$editper = $this->CheckPermission(261, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(261, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$costcentre = $this->loadModel('Cocentre');
		$costcentrearray = $costcentre->getDataTable($editper, $deleteper);
		echo json_encode($costcentrearray);
		}catch(Exception $e)
		{
			
		}
	}
	
	//////////////////////////////// COCENTRE CONTROLLER FUNCTION ENDS HERE  ////////////////////////////
}
