<?php

/**
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class Salaryadvanceloan extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();

        // this controller should only be visible/usable by logged in users, so we put login-check here
        Auth::handleLogin();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
	function salaryadvance() {
		$viewper = $this->CheckPermission(292, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(292, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/salaryadvanceloan/index');
		}else{
			header('location: ' . URL . 'salaryadvanceloan/index');
		}
    }
	function addsalaryadvance() {
		$addper = $this->CheckPermission(292, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->salaryadvanceid =0;
			$this->view->val = 0; 
			$this->view->render('salary/salaryadvanceloan/addeditsalaryadvance');
		}else{
			header('location: ' . URL . 'salaryadvanceloan/salaryadvance');
		}
    }
	function editsalaryadvance($id){
		$editper = $this->CheckPermission(292, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->salaryadvanceid = Utils::decode5t($id); 
			$this->view->val = 0; 
			$this->view->render('salary/salaryadvanceloan/addeditsalaryadvance');
		}else{
			header('location: ' . URL . 'salary/salaryadvance');
		}
    }
	
	function viewsalaryadvance($id,$val) {
		if(isset($id)  && isset($val)){
			$this->view->val = $val; 
			$this->view->salaryadvanceid = Utils::decode5t($id); 
			$this->view->render('salary/salaryadvanceloan/addeditsalaryadvance');
		}else{
			header('location: ' . URL . 'salaryadvanceloan/salaryadvance');
		}
		
    }
	
	function getallsalaryadvance(){
		$viewper = $this->CheckPermission(292, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$salaryadvance = $this->loadModel('Salaryadvanceloan');
			$salaryadvancearray = $salaryadvance->getAll($arr);
			echo json_encode($salaryadvancearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	function getallEmployeename(){
		$viewper = $this->CheckPermission(292, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$salaryadvance = $this->loadModel('Salaryadvanceloan');
			$salaryadvancearray = $salaryadvance->getAllemp($arr);
			echo json_encode($salaryadvancearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	function getasalaryadvance(){
		$gid = $_POST['salaryadvanceid'];
		$salaryadvance = $this->loadModel('Salaryadvanceloan');
		$salaryadvancearray = $salaryadvance->getDetail($gid);
		echo json_encode($salaryadvancearray);	
	}
	function getempgratuity(){
		$gid = $_POST['employeeid'];
		$salaryadvance = $this->loadModel('Salaryadvanceloan');
		$salaryadvancearray = $salaryadvance->getempGratuity($gid);
		echo json_encode($salaryadvancearray);	
	}
	/** 
     * Functions for perfom operation on salaryhead table
     * getall function fetching salaryhead list
	 * @returning json array of data as result
     */
	function createsalaryadvance(){
		$addper = $this->CheckPermission(292, 4);  ///////// CHECK FOR VIEW PERMISSION  ///
		if($addper){
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['advanceamount'];
			$arr[4] = $_POST['installmentamt'];
			$arr[5] = $_POST['approvedby'];	
			$arr[6] = $_POST['remarks'];	
			$arr[7] = $_POST['applymonth'];	
			$arr[8] = $_POST['applysts'];	
			
			$salaryadvance = $this->loadModel('Salaryadvanceloan');
			$salaryadvancearray = $salaryadvance->Create($arr);
			echo json_encode($salaryadvancearray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	 /**
     * Functions for perfom operation on salaryhead table
     * delete function from salaryhead list
	 * @returning json array of data as result
     */
	 
	function updatedesalaryadvance(){
		$editper = $this->CheckPermission(292, 2);   ////// CHECK FOR EDIT  PERMISSION  ////////
		if($editper){
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['advanceamount'];
			$arr[4] = $_POST['installmentamt'];
			$arr[5] = $_POST['approvedby'];
			$arr[6] = $_POST['remarks'];
			$arr[7] = $_POST['salaryadvanceid'];
			$arr[8] = $_POST['applymonth'];	
			$arr[9] = $_POST['applysts'];
			$arr[10] = $_POST['closedate'];
			$arr[11] = $_POST['outstanding'];
			$arr[12] = $_POST['closests'];
			
			$salaryhead = $this->loadModel('Salaryadvanceloan');
			$salaryheadarray = $salaryhead->Update($arr);
			echo json_encode($salaryheadarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	function deletesalaryadvance($did){
		$deleteper = $this->CheckPermission(292, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper ){
			$dept = $this->loadModel('Salaryadvanceloan');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getSalaryadvanceData(){	
		try{
		$editper = $this->CheckPermission(292, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(292, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$salaryadvance = $this->loadModel('Salaryadvanceloan');
		$salaryarray = $salaryadvance->getDataTable($editper, $deleteper);
		echo json_encode($salaryarray);
		}catch(Exception $e){}
	}
	
	function changestatus(){
		$editper = $this->CheckPermission(293, 2);  ///////// CHECK FOR EDIT PERMISSION  ////
		if($editper){
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salaryadvanceid'];
			$arr[3] = $_POST['approverresult'];
			$arr[4] = $_POST['comment'];
			
			$dept = $this->loadModel('Salaryapprovalloan');
			$deptarray = $dept->Approve($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	function salaryadvanceapproval()
    {
		$viewper = $this->CheckPermission(293, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(293, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/salaryadvanceapprovalloan/index');
		}else{
			header('location: ' . URL . 'salaryadvanceloan/index');
		}
    }
	
	function getasalaryadvanceapproval(){
		try{
		$viewper = $this->CheckPermission(293, 1);  ///////// CHECK FOR VIEW PERMISSION  ///////
		if($viewper){
			$gid = $_POST['salaryadvanceid'];
			$leaveapproval = $this->loadModel('Salaryapprovalloan');
			$leaveapprovalarray = $leaveapproval->getDetail($gid);
			echo json_encode($leaveapprovalarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getallsalaryadvanceapprover(){
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['salaryadvanceid'];
		
		$leaveapproval = $this->loadModel('Salaryapprovalloan');
		$leaveapprovalarray = $leaveapproval->getAllApprover($arr);
		echo json_encode($leaveapprovalarray);	
	}
	function viewsalaryadvanceapproval($id,$val){
		$viewper = $this->CheckPermission(293, 1); ///////// CHECK FOR VIEW PERMISSION  ////////
		if(isset($id) && isset($val) && ($viewper) ){			
			$this->view->val = $val; 
			$this->view->salaryadvanceid = $id; //$dept->getDetail($id);
			$this->view->render('salary/salaryadvanceapprovalloan/addeditsalaryapproval');
		}else{
			header('location: ' . URL . 'salaryadvanceloan/salaryadvanceapproval');
		}		
    }
	
	function getSalaryAdvanceApprovalData(){
		try{
		$editper = $this->CheckPermission(293, 2);   ///////// CHECK FOR EDIT  PERMISSION  /////
		$deleteper = $this->CheckPermission(293, 3); ///////// CHECK FOR DELETE  PERMISSION  ////
		$salary = $this->loadModel('Salaryapprovalloan');
		$salaryarray = $salary->getDataTable($editper, $deleteper);
		echo json_encode($salaryarray);
		}catch(Exception $e){}
	}
	
}	

