<?php

/**
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class Salary extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();

        // this controller should only be visible/usable by logged in users, so we put login-check here
        Auth::handleLogin();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    function index()
    {
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		if($sts==1 || $hrsts==1){
			$this->view->render('salary/index');
		}else{
			$this->view->render('salary/index1');
		}
        
    }
	function show_reports()
    {
        $this->view->render('salary/reports_list');
    }
	function show_heads()
    {
        $this->view->render('salary/settings/salary_head');
    }
	function show_addition_deduction()
    {
        $this->view->render('salary/settings/salary_add_deduct');
    }
	function show_advance_salary()
    {
        $this->view->render('salary/settings/salary_advance');
    }
	function show_expense()
    {
        $this->view->render('salary/settings/expense_type');
    }
	function show_gratuity()
    {
        $this->view->render('salary/settings/gratuity');
    }
	
	function generatebulksalary($val)
    {
		$this->view->val=$val;
        $this->view->render('salary/generatesalary/addeditbulksalary');
    }
	
	function generatebatchsalary($val,$batch)
    {
		$this->view->val=$val;
		$this->view->batch=$batch;
        $this->view->render('salary/generatesalary/addeditbatchsalary');
    }
	
	function addlta($val)
    {
		$this->view->val=$val;
        $this->view->render('salary/generatesalary/addeditlta');
    }
	
	/////////////////Salary tracking controller starts from here//////////////
	
	
	function salarytrack()
    {
        $this->view->render('salary/salarytrack/index');
    }
	
	function getSalarytrackData()
	{
		$employee = $this->loadModel('Salary');
		
		$employeearray = $employee->getSalarytrackDataTable();
		echo json_encode($employeearray);
	}
	
	function viewsalarytrack($id)
    {	
		$addper = $this->CheckPermission(166, 1); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->empid =Utils::decode5t($id);
			//$this->view->val = 0; 
			$this->view->render('salary/salarytrack/viewsalary');
		}else{
			header('location: ' . URL . 'salary/salarytrack');
		}
    }
	function getsalarytrack()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['empid'];
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->getEmployeeSalarytrackDetails($arr);
			echo json_encode($salaryarray);
		}catch(Exception $e){
			$result = array();
			$result['status']=false;
			$result['errorMsg']=$e->getMessage();;
			echo json_encode($result);
		}
	}
	
	
	
	
	////////////////overtime pay controller starts from here////////////////
	
	function overtimepay()
    {
		$viewper = $this->CheckPermission(165, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(165, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/overtimepay/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
		
    }
	
	function getOvertimepayData()
	{
		$editper = $this->CheckPermission(165, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(165, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
			$employee = $this->loadModel('Employeeovertime');
			$employeearray = $employee->getDataTable($editper,$deleteper);
			echo json_encode($employeearray);
		}catch(Exception $e){ echo $e->getMessage();}
		
	}
	
		function addovertimepay()
    {
		$addper = $this->CheckPermission(165, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->overtimepayid =0;
			$this->view->val = 0;
			$this->view->render('salary/overtimepay/addeditovertime');
		}else{
			header('location: ' . URL . 'salary/overtimepay');
		}
    }
	
	function importovertime()
    {
		$addper = $this->CheckPermission(165, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->overtimepayid =0;
			$this->view->val = 0;
			$this->view->render('salary/overtimepay/importincentive');
		}else{
			header('location: ' . URL . 'salary/overtimepay');
		}
    }
	
	function importovertimeheadersfile()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Employeeovertime');
			$deptarray = $dept->getFileHeaders($arr);
			echo json_encode($deptarray);	
		}catch(Exception $e){ echo $e->getMessage();}
		
	}
	function insertovertimeheaders()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['emp'];
			$arr[3] = $_POST['atdate'];
			$arr[4] = $_POST['amount'];
			$arr[5] = $_POST['desc'];
			$arr[6] = $_POST['overtime'];
			$arr[7] = $_POST['hourlyrate'];
			$arr[8] = $_POST['overtimemonth'];
								
			$dept = $this->loadModel('Employeeovertime');
			$deptarray = $dept->insertFileHeaders($arr);
			echo json_encode($deptarray);	
		}catch(Exception $e){ echo $e->getMessage();}
		
	}
	function editovertimepay($id)
    {
		$editper = $this->CheckPermission(165, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->val = 0; 
			$this->view->overtimepayid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('salary/overtimepay/addeditovertime');
		}else{
			header('location: ' . URL . 'salary/overtimepay');
		}
    }
	
	function viewovertimepay($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->overtimepayid = Utils::decode5t($id);//$dept->getDetail($id);
			$this->view->render('salary/overtimepay/addeditovertime');
		}else{
			header('location: ' . URL . 'salary/overtimepay');
		}
		
    }
	
	function getallovertimepay()
	{
		$viewper = $this->CheckPermission(165, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$overtimepay = $this->loadModel('Employeeovertime');
			$overtimepayarray = $overtimepay->getAll($arr);
			echo json_encode($overtimepayarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getovertimepay()
	{
		
		$viewper = $this->CheckPermission(165, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['overtimepayid'];
			$overtimepay = $this->loadModel('Employeeovertime');
			$overtimepayarray = $overtimepay->getDetail($gid);
			echo json_encode($overtimepayarray);	
				
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	/** 
     * Functions for perfom operation on gratuity table
     * getall function fetching gratuity list
	 * @returning json array of data as result
     */
	function createovertimepay()
	{
		
		
		$addper = $this->CheckPermission(165, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['applydate'];
			$dept = $this->loadModel('Employeeovertime');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on gratuity table
     * delete function from gratuity list
	 * @returning json array of data as result
     */
	 
	 function updatedeovertimepay()
	{
		$editper = $this->CheckPermission(165, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$arr[2] = $_POST['applydate'];
			
			$dept = $this->loadModel('Employeeovertime');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteovertimepay($did)
	{
		$deleteper = $this->CheckPermission(165, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Employeeovertime');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}
	
	
	
	//////////////////  FETCH DASHBOARD DATA TO DISPLAY ON SALARY TAB /////////////////////
	function dashboard1($val,$type="")
	{
		
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];
		$dash = $this->loadModel('Dashboard');
		if($val==1)
		$dasharr = $dash->getSalaryDashboard1($arr);
		else
		$dasharr = $dash->getSalaryReportingDashboard($arr,$val);
		echo json_encode($dasharr);		
		}catch(Exception $e){ echo $e->getMessage(); }
	}
	
	function dashboard2($val,$type="")
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];	
		$dash = $this->loadModel('Dashboard');
		if($val==1)
		$dasharr = $dash->getSalaryDashboard2($arr);
		else
		$dasharr = $dash->getSalaryReportingDashboard($arr,$val);
		echo json_encode($dasharr);		
		}catch(Exception $e){ echo $e->getMessage(); }
	}
	
	function dashboard3($val,$type="")
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];	
		$dash = $this->loadModel('Dashboard');
		if($val==1)
		$dasharr = $dash->getSalaryDashboard3($arr);
		else
		$dasharr = $dash->getSalaryReportingDashboard($arr,$val);
		echo json_encode($dasharr);		
		}catch(Exception $e){ echo $e->getMessage(); }
	}
	
	function dashboard4($val,$type="")
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];	
		$dash = $this->loadModel('Dashboard');
		if($val==1)
		$dasharr = $dash->getSalaryDashboard4($arr);
		else
		$dasharr = $dash->getSalaryReportingDashboard($arr,$val);
		echo json_encode($dasharr);		
		}catch(Exception $e){ echo $e->getMessage(); }
	}
	
	function dashboard5($val,$type="")
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];	
		$dash = $this->loadModel('Dashboard');
		if($val==1)
		$dasharr = $dash->getSalaryDashboard5($arr);
		else
		$dasharr = $dash->getSalaryReportingDashboard($arr,$val);
		echo json_encode($dasharr);		
		}catch(Exception $e){ echo $e->getMessage(); }
	}
	
	function dashboard6($val,$type="")
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];	
		$dash = $this->loadModel('Dashboard');
		if($val==1)
		$dasharr = $dash->getSalaryDashboard6($arr);
		else
		$dasharr = $dash->getSalaryReportingDashboard($arr,$val);
		echo json_encode($dasharr);		
		}catch(Exception $e){ echo $e->getMessage(); }
	}
	
	function dashboard7($val,$type="")
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];	
		$dash = $this->loadModel('Dashboard');
		if($val==1)
		$dasharr = $dash->getSalaryDashboard7($arr);
		else
		$dasharr = $dash->getSalaryReportingDashboard($arr,$val);
		echo json_encode($dasharr);		
		}catch(Exception $e){ echo $e->getMessage(); }
	}
	
	function dashboard8($val,$type="")
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];	
		$dash = $this->loadModel('Dashboard');
		if($val==1)
		$dasharr = $dash->getSalaryDashboard8($arr);
		else
		$dasharr = $dash->getSalaryReportingDashboard($arr,$val);
		echo json_encode($dasharr);		
		}catch(Exception $e){ echo $e->getMessage(); }
	}
	
	function dashboard9($val,$type="")
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];
		$dash = $this->loadModel('Dashboard');
		if($val==1)
		$dasharr = $dash->getSalaryDashboard9($arr);
		else
		$dasharr = $dash->getSalaryReportingDashboard($arr,$val);
		echo json_encode($dasharr);		
		}catch(Exception $e){ echo $e->getMessage(); }
	}
	
	function compandbenefit()
    {
        $viewper = $this->CheckPermission(164, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(164, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/compandbenefit/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	
	function addcompandbenefit()
    {	
		$addper = $this->CheckPermission(164, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->salaryheadid =0;
			$this->view->val = 0; 
        $this->view->render('salary/compandbenefit/addeditcompandbenefit');
		}else{
			header('location: ' . URL . 'salary/compandbenefit');
		}
    }
	function viewcompandbenefit($id)
    {	
		$addper = $this->CheckPermission(164, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->salaryheadid =Utils::decode5t($id);
			$this->view->val = 0; 
        $this->view->render('salary/compandbenefit/viewsalary');
		}else{
			header('location: ' . URL . 'salary/compandbenefit');
		}
    }
	function viewmonthcompandbenefit()
    {	
		$addper = $this->CheckPermission(164, 1); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->salaryheadid =0;
			$this->view->val = 0; 
        $this->view->render('salary/compandbenefit/viewmonthpayroll');
		}else{
			header('location: ' . URL . 'salary/compandbenefit');
		}
    }
	function deletecompandbenefit($did)
	{
		$deleteper = $this->CheckPermission(164, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did)  )
		{
			$dept = $this->loadModel('Compandbenefit');
			$deptarray = $dept->Delete($did);
			header('location: ' . URL . 'salary/compandbenefit');
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			return json_encode($result);		
		}	
	}
	
	
	function getcompandbenefitDetials()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarymonth'];
			$salary = $this->loadModel('Compandbenefit');
			$salaryarray = $salary->getMonthCompandBenefitDetail($arr);
			echo json_encode($salaryarray);
		}catch(Exception $e){
			$result = array();
			$result['status']=false;
			$result['errorMsg']=$e->getMessage();;
			echo json_encode($result);
		}
	}
	function getacompandbens()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salaryid'];
			$salary = $this->loadModel('Compandbenefit');
			$salaryarray = $salary->getDetail($arr);
			echo json_encode($salaryarray);
		}catch(Exception $e){
			$result = array();
			$result['status']=false;
			$result['errorMsg']=$e->getMessage();;
			echo json_encode($result);
		}
	}
	
	function createcomandbenefit()
	{
		$addper = $this->CheckPermission(164, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarys'];
			$salary = $this->loadModel('Compandbenefit');
			$salaryarray = $salary->CreateCompandBenefit($arr);
			echo json_encode($salaryarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	function updatecomandbenefit()
	{
		$addper = $this->CheckPermission(164, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarys'];
			$salary = $this->loadModel('Compandbenefit');
			$salaryarray = $salary->Update($arr);
			echo json_encode($salaryarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	function getemployeecompandbenefitdetail()
	{
		$viewper = $this->CheckPermission(164, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarymonth'];
			
			$employee = $this->loadModel('Compandbenefit');
			$employeearray = $employee->getEmployeeCompAndBenefitDetail($arr);
			echo json_encode($employeearray);	
			}catch(Exception $e){
			
			}
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}					
	}
	function getCompAndBenefitData()
	{
		$editper = $this->CheckPermission(164, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(164, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
		$salaryhead = $this->loadModel('Compandbenefit');
		$salaryheadarray = $salaryhead->getDataTable($editper, $deleteper);
		echo json_encode($salaryheadarray);
		}catch(Exception $e){ echo $e->getMessage();}
	}
	
	/** 
	 ///////////////////////////// SALARY HEAD CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on salaryhead table
     * getall function fetching salaryhead list
	 * @returning json array of data as result
     */
	
	function salaryhead()
    {
        $viewper = $this->CheckPermission(41, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(41, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/salaryhead/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	function addsalaryhead()
    {	
		$addper = $this->CheckPermission(41, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->salaryheadid =0;
			$this->view->val = 0; 
        $this->view->render('salary/salaryhead/addeditsalaryhead');
		}else{
			header('location: ' . URL . 'salary/salaryhead');
		}
    }
	
	function changeheadstatus($id)
	{
	
		$editper = $this->CheckPermission(41, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper && isset($id)){
			$arr=array();
			$arr[0] = $_SESSION['ubihrm_org_id'];
			$arr[1]=$id;
			$user = $this->loadModel('Salaryhead');
			$userarray = $user->ChangeStatus($arr);
			echo json_encode($userarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'setup/users');
	}
	
		function pf_esi_settings()
    {	
		$addper = $this->CheckPermission(212, 4); ///////// CHECK FOR Add provident fund settings PERMISSION  ////////////
		if($addper){
			$this->view->salaryheadid =0;
			$this->view->val = 0; 
        $this->view->render('salary/settings/pf_esi_settings');
		}else{
			header('location: ' . URL . 'salary/settings/');
		}
    }
	
		function esi_settings()
    {	
		$addper = $this->CheckPermission(216, 4); ////////// CHECK FOR Add provident fund settings PERMISSION  ////////////
		if($addper){
			$this->view->salaryheadid =0;
			$this->view->val = 0; 
        $this->view->render('salary/settings/esi_settings');
		}else{
			header('location: ' . URL . 'salary/settings/');
		}
    }
	
	function tdsSlabs()
    {
		$addper = $this->CheckPermission(217, 4); ////////// CHECK FOR Add provident fund settings PERMISSION  ////////////
		if($addper){
        $this->view->render('salary/settings/tds_with_surcharge');
		}else{
			header('location: ' . URL . 'salary/settings/');
		}
    }
	
	
	function editsalaryhead($id)
    {
		$editper = $this->CheckPermission(41, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->salaryheadid = $id; //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('salary/salaryhead/addeditsalaryhead');
		}else{
			header('location: ' . URL . 'salary/salaryhead');
		}
    }
	
	function viewsalaryhead($id,$val)
    {
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->salaryheadid = $id; //$dept->getDetail($id);
			$this->view->render('salary/salaryhead/addeditsalaryhead');
		}else{
			header('location: ' . URL . 'salary/salaryhead');
		}		
    }
	
	function getallsalaryhead()
	{
		$viewper = $this->CheckPermission(41, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$salaryhead = $this->loadModel('Salaryhead');
			$salaryheadarray = $salaryhead->getAll($arr);
			echo json_encode($salaryheadarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getalladditionsalaryhead()
	{
		$viewper = $this->CheckPermission(41, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			//$arr[2] = $_POST['headtype'];
			$salaryhead = $this->loadModel('Salaryhead');
			$salaryheadarray = $salaryhead->getAllAdditionHead($arr);
			echo json_encode($salaryheadarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getasalaryhead()
	{
		$viewper = $this->CheckPermission(41, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['salaryheadid'];
			$salaryhead = $this->loadModel('Salaryhead');
			$salaryheadarray = $salaryhead->getDetail($gid);
			echo json_encode($salaryheadarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getaotherhead()
	{
		$viewper = $this->CheckPermission(41, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['salaryheadid'];
			$salaryhead = $this->loadModel('Salaryhead');
			$salaryheadarray = $salaryhead->getOtherDetail($gid);
			echo json_encode($salaryheadarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on salaryhead table
     * getall function fetching salaryhead list
	 * @returning json array of data as result
     */
	function createsalaryhead()
	{
		$addper = $this->CheckPermission(41, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salaryheadname'];
			$arr[3] = $_POST['headtype'];
			$arr[4] = $_POST['headcategoryid'];
			$arr[5] = $_POST['applieddate'];
			$arr[6] = $_POST['headcode'];
			$arr[7] = $_POST['main'];
			$arr[8] = $_POST['sub'];
			$arr[9] = $_POST['description'];
			$salaryhead = $this->loadModel('Salaryhead');
			$salaryheadarray = $salaryhead->Create($arr);
			echo json_encode($salaryheadarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on salaryhead table
     * delete function from salaryhead list
	 * @returning json array of data as result
     */
	 
	 function updatedesalaryhead()
	{
		$editper = $this->CheckPermission(41, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salaryheadname'];
			$arr[3] = $_POST['headcategoryid'];
			$arr[4] = $_POST['headtype'];
			$arr[5] = $_POST['applieddate'];
			$arr[6] = $_POST['salaryheadid'];
			$arr[7] = $_POST['headcode'];
			$arr[8] = $_POST['main'];
			$arr[9] = $_POST['sub'];
			$arr[10] = $_POST['description'];
			$salaryhead = $this->loadModel('Salaryhead');
			$salaryheadarray = $salaryhead->Update($arr);
			echo json_encode($salaryheadarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 function updatedesalaryotherhead()
	{
		$editper = $this->CheckPermission(41, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salaryheadname'];
			$arr[3] = $_POST['salaryheadcode'];
			$arr[4] = $_POST['salaryheadid'];
			$arr[5] = $_POST['sub'];
		
			$salaryhead = $this->loadModel('Salaryhead');
			$salaryheadarray = $salaryhead->UpdateOtherHead($arr);
			echo json_encode($salaryheadarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletesalaryhead($did)
	{		
		$deleteper = $this->CheckPermission(41, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Salaryhead');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getSalaryheadData()
	{
		$editper = $this->CheckPermission(41, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(41, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
		$salaryhead = $this->loadModel('Salaryhead');
		$salaryheadarray = $salaryhead->getDataTable($editper, $deleteper);
		echo json_encode($salaryheadarray);
		}catch(Exception $e){ echo $e->getMessage();}
	}
	
	function getSalaryOtherheadData()
	{
		try{
			$salaryhead = $this->loadModel('Salaryhead');
			$salaryheadarray = $salaryhead->getSalaryOtherHeadDataTable();
			echo json_encode($salaryheadarray);
		}catch(Exception $e){ echo $e->getMessage();}
	}
	/**
	///////////////////////////// SALARY ADVANCE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on salaryhead table
     * getall function fetching salaryhead list
	 * @returning json array of data as result
     */
	
	function salaryadvance()
    {
		$viewper = $this->CheckPermission(40, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(40, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/salaryadvance/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	function addsalaryadvance()
    {
		$addper = $this->CheckPermission(40, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->salaryadvanceid =0;
			$this->view->val = 0; 
			$this->view->render('salary/salaryadvance/addeditsalaryadvance');
		}else{
			header('location: ' . URL . 'salary/salaryadvance');
		}
    }
	
	function editsalaryadvance($id)
    {
		$editper = $this->CheckPermission(40, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->salaryadvanceid = Utils::decode5t($id); 
			$this->view->val = 0; 
			$this->view->render('salary/salaryadvance/addeditsalaryadvance');
		}else{
			header('location: ' . URL . 'salary/salaryadvance');
		}
    }
	
	function viewsalaryadvance($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->salaryadvanceid = Utils::decode5t($id); 
			$this->view->render('salary/salaryadvance/addeditsalaryadvance');
		}else{
			header('location: ' . URL . 'salary/salaryadvance');
		}
		
    }
	
	function getallsalaryadvance()
	{
		$viewper = $this->CheckPermission(40, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$salaryadvance = $this->loadModel('Salaryadvance');
			$salaryadvancearray = $salaryadvance->getAll($arr);
			echo json_encode($salaryadvancearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	function getallEmployeename()
	{
		$viewper = $this->CheckPermission(40, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$salaryadvance = $this->loadModel('Salaryadvance');
			$salaryadvancearray = $salaryadvance->getAllemp($arr);
			echo json_encode($salaryadvancearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getasalaryadvance()
	{
		
		
			$gid = $_POST['salaryadvanceid'];
			$salaryadvance = $this->loadModel('Salaryadvance');
			$salaryadvancearray = $salaryadvance->getDetail($gid);
			echo json_encode($salaryadvancearray);	
				
					
	}
	
	
	function getempgratuity()
	{
		$gid = $_POST['employeeid'];
		$salaryadvance = $this->loadModel('Salaryadvance');
		$salaryadvancearray = $salaryadvance->getempGratuity($gid);
		echo json_encode($salaryadvancearray);	
	}
	/** 
     * Functions for perfom operation on salaryhead table
     * getall function fetching salaryhead list
	 * @returning json array of data as result
     */
	function createsalaryadvance()
	{
		$addper = $this->CheckPermission(40, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['advanceamount'];
			$arr[4] = $_POST['installmentamt'];
			$arr[5] = $_POST['approvedby'];	
			$arr[6] = $_POST['remarks'];	
			$arr[7] = $_POST['applymonth'];	
			$arr[8] = $_POST['applysts'];	
			
			$salaryadvance = $this->loadModel('Salaryadvance');
			$salaryadvancearray = $salaryadvance->Create($arr);
			echo json_encode($salaryadvancearray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on salaryhead table
     * delete function from salaryhead list
	 * @returning json array of data as result
     */
	 
	 function updatedesalaryadvance()
	{
		$editper = $this->CheckPermission(40, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['advanceamount'];
			$arr[4] = $_POST['installmentamt'];
			$arr[5] = $_POST['approvedby'];
			$arr[6] = $_POST['remarks'];
			$arr[7] = $_POST['salaryadvanceid'];
			$arr[8] = $_POST['applymonth'];	
			$arr[9] = $_POST['applysts'];
			$arr[10] = $_POST['closedate'];
			$arr[11] = $_POST['outstanding'];
			$arr[12] = $_POST['closests'];
			
			$salaryhead = $this->loadModel('Salaryadvance');
			$salaryheadarray = $salaryhead->Update($arr);
			echo json_encode($salaryheadarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	function deletesalaryadvance($did)
	{
		$deleteper = $this->CheckPermission(40, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Salaryadvance');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getSalaryadvanceData()
	{		
		$editper = $this->CheckPermission(40, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(40, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$salaryadvance = $this->loadModel('Salaryadvance');
		$salaryarray = $salaryadvance->getDataTable($editper, $deleteper);
		echo json_encode($salaryarray);
	}
	
	/** 
	 									
	 ///////////////////////////// SALARY ADVANCE CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	
	 ///////////////////////////// GRATUITY CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on gratuity table
     * getall function fetching gratuity list
	 * @returning json array of data as result
     */
	
	function gratuity()
    {
		$viewper = $this->CheckPermission(28, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(28, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/gratuity/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	function addgratuity()
    {
		$addper = $this->CheckPermission(28, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->gratuityid =0;
			$this->view->val = 0; 
        $this->view->render('salary/gratuity/addeditgratuity');
		}else{
			header('location: ' . URL . 'salary/gratuity');
		}
    }
	
	function editgratuity($id)
    {
		$editper = $this->CheckPermission(28, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->gratuityid = $id; //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('salary/gratuity/addeditgratuity');
		}else{
			header('location: ' . URL . 'salary/gratuity');
		}
    }
	
	function viewgratuity($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->gratuityid = $id; //$dept->getDetail($id);
			$this->view->render('salary/gratuity/addeditgratuity');
		}else{
			header('location: ' . URL . 'salary/gratuity');
		}
		
    }
	
	function getallgratuity()
	{
		$viewper = $this->CheckPermission(28, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$gratuity = $this->loadModel('Gratuity');
			$gratuityarray = $gratuity->getAll($arr);
			echo json_encode($gratuityarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	
	function getagratuity()
	{
		$viewper = $this->CheckPermission(28, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['gratuityid'];
			$gratuity = $this->loadModel('Gratuity');
			$gratuityarray = $gratuity->getDetail($gid);
			echo json_encode($gratuityarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	
	/** 
     * Functions for perfom operation on gratuity table
     * getall function fetching gratuity list
	 * @returning json array of data as result
     */
	function creategratuity()
	{
		$addper = $this->CheckPermission(28, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['gratuityname'];
			$arr[3] = $_POST['empstatus'];
			$arr[4] = $_POST['minexp'];
			$arr[5] = $_POST['maxexp'];
			$arr[6] = $_POST['payday'];
			$arr[7] = $_POST['appdate'];
			$dept = $this->loadModel('Gratuity');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on gratuity table
     * delete function from gratuity list
	 * @returning json array of data as result
     */
	 
	 function updatedegratuity()
	{
		$editper = $this->CheckPermission(28, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['gratuityname'];
			$arr[3] = $_POST['empstatus'];
			$arr[4] = $_POST['minexp'];
			$arr[5] = $_POST['maxexp'];
			$arr[6] = $_POST['payday'];
			$arr[7] = $_POST['appdate'];
			$arr[8] = $_POST['gratuityid'];
			$dept = $this->loadModel('Gratuity');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletegratuity($did)
	{
		$deleteper = $this->CheckPermission(41, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Gratuity');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getGratuityData()
	{
		$editper = $this->CheckPermission(28, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(28, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$gratuity = $this->loadModel('Gratuity');
		$gratuityarray = $gratuity->getDataTable($editper, $deleteper);
		echo json_encode($gratuityarray);
		
	}
	
	
	/** 
	 									
	 ///////////////////////////// GRATUITY CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	
	 ///////////////////////////// EMPLOYEE INCENTIVE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on gratuity table
     * getall function fetching gratuity list
	 * @returning json array of data as result
     */
	
	function employeeincentive()
    {
        $viewper = $this->CheckPermission(17, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(17, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/employeeincentive/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	function addemployeeincentive()
    {
		$addper = $this->CheckPermission(17, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->empincentiveid =0;
			$this->view->val = 0;
			$this->view->render('salary/employeeincentive/addeditempincentive');
		}else{
			header('location: ' . URL . 'salary/employeeincentive');
		}
    }
	
	function importincentive()
    {
		$addper = $this->CheckPermission(17, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->empincentiveid =0;
			$this->view->val = 0;
			$this->view->render('salary/employeeincentive/importincentive');
		}else{
			header('location: ' . URL . 'salary/employeeincentive');
		}
    }
	
	function importheadersfile()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Employeeincentive');
			$deptarray = $dept->getFileHeaders($arr);
			echo json_encode($deptarray);	
		}catch(Exception $e){ echo $e->getMessage();}
		
	}
	function insertincentiveheaders()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['emp'];
			$arr[3] = $_POST['atdate'];
			$arr[4] = $_POST['amount'];
			$arr[5] = $_POST['desc'];
						
			$dept = $this->loadModel('Employeeincentive');
			$deptarray = $dept->insertFileHeaders($arr);
			echo json_encode($deptarray);	
		}catch(Exception $e){ echo $e->getMessage();}
		
	}
	function editemployeeincentive($id)
    {
		$editper = $this->CheckPermission(17, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->val = 0; 
			$this->view->empincentiveid = $id; //$dept->getDetail($id);
			$this->view->render('salary/employeeincentive/addeditempincentive');
		}else{
			header('location: ' . URL . 'salary/employeeincentive');
		}
    }
	
	function viewincentive($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->empincentiveid = $id; //$dept->getDetail($id);
			$this->view->render('salary/employeeincentive/addeditempincentive');
		}else{
			header('location: ' . URL . 'salary/employeeincentive');
		}
		
    }
	
	function getallemployeeincentive()
	{
		$viewper = $this->CheckPermission(17, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$employeeincentive = $this->loadModel('Employeeincentive');
			$employeeincentivearray = $employeeincentive->getAll($arr);
			echo json_encode($employeeincentivearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getemployeeincentive()
	{
			
		
		$viewper = $this->CheckPermission(17, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['empincentiveid'];
			$employeeincentive = $this->loadModel('Employeeincentive');
			$employeeincentivearray = $employeeincentive->getDetail($gid);
			echo json_encode($employeeincentivearray);	
				
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	/** 
     * Functions for perfom operation on gratuity table
     * getall function fetching gratuity list
	 * @returning json array of data as result
     */
	function createemployeeincentive()
	{
		
		
		$addper = $this->CheckPermission(17, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['applydate'];
			$dept = $this->loadModel('Employeeincentive');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on gratuity table
     * delete function from gratuity list
	 * @returning json array of data as result
     */
	 
	 function updatedeemployeeincentive()
	{
		$editper = $this->CheckPermission(17, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$arr[2] = $_POST['applydate'];
			
			$dept = $this->loadModel('Employeeincentive');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteemployeeincentive($did)
	{
		$deleteper = $this->CheckPermission(17, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Employeeincentive');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getEmployeeincentiveData()
	{
		$editper = $this->CheckPermission(17, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(17, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$employeeincentive = $this->loadModel('Employeeincentive');
		$employeeincentivearray = $employeeincentive->getDataTable($editper, $deleteper);
		echo json_encode($employeeincentivearray);
	}

	///////////employee incentive controller ends here////////////////

	///////////////////////////// EMPLOYEE BENEFIT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perfom operation on BENEFIT table
     * getall function fetching gratuity list
	 * @returning json array of data as result
     */
	
	function benefit()
    {
        $viewper = $this->CheckPermission(6, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(6, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/benefit/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	function addbenefit()
    {
		$addper = $this->CheckPermission(6, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->benefitid =0;
			$this->view->val = 0; 
        $this->view->render('salary/benefit/addeditbenefit');
		}else{
			header('location: ' . URL . 'salary/benefit');
		}
    }
	
	function editbenefit($id)
    {
		$editper = $this->CheckPermission(6, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->benefitid = $id; 
			$this->view->val = 0; 
			$this->view->render('salary/benefit/addeditbenefit');
		}else{
			header('location: ' . URL . 'salary/benefit');
		}
    }
	
	function viewbenefit($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->benefitid = $id; 
			$this->view->render('salary/benefit/addeditbenefit');
		}else{
			header('location: ' . URL . 'salary/benefit');
		}
		
    }
	function getallbenefit()
	{
		$viewper = $this->CheckPermission(6, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$benefit = $this->loadModel('Benefit');
			$benefitarray = $benefit->getAll($arr);
			echo json_encode($benefitarray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	
	function getbenefit()
	{
		$viewper = $this->CheckPermission(6, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['benefitid'];
			$benefit = $this->loadModel('Benefit');
			$array = $benefit->getDetail($gid);
			echo json_encode($array);		
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	/** 
     * Functions for perfom operation on gratuity table
     * getall function fetching gratuity list
	 * @returning json array of data as result
     */
	function createbenefit()
	{
		$addper = $this->CheckPermission(6, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['name'];
			$dept = $this->loadModel('Benefit');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);				
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on gratuity table
     * delete function from gratuity list
	 * @returning json array of data as result
     */
	 
	 function updatedebenefit()
	{
		$editper = $this->CheckPermission(6, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['name'];
			$arr[3] = $_POST['benefitid'];
			$dept = $this->loadModel('Benefit');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletebenefit($did)
	{	
		$deleteper = $this->CheckPermission(6, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Benefit');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getBenefitData()
	{
		$editper = $this->CheckPermission(6, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(6, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$employeeincentive = $this->loadModel('Benefit');
		$employeeincentivearray = $employeeincentive->getDataTable($editper, $deleteper);
		echo json_encode($employeeincentivearray);
	}


	///////////EMPLOYEE INCENTIVE CONTROLLER ENDS HERE////////////////

	///////////////////////////// SALARY TYPE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perfom operation on SALARY TYPE table
     * getall function fetching gratuity list
	 * @returning json array of data as result
     */
	
	function salarytype()
    {
        $viewper = $this->CheckPermission(67, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(67, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/salarytype/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	function addsalarytype()
    {
		$addper = $this->CheckPermission(67, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->salarytypeid =0;
			$this->view->val = 0; 
			$this->view->render('salary/salarytype/addeditsalarytype');
		}else{
			header('location: ' . URL . 'salary/salarytype');
		}
    }
	
	function editsalarytype($id)
    {
		$editper = $this->CheckPermission(67, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->salarytypeid = $id; 
			$this->view->val = 0; 
			$this->view->render('salary/salarytype/addeditsalarytype');
		}else{
			header('location: ' . URL . 'salary/salarytype');
		}
    }
	
	function viewsalarytype($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->salarytypeid = $id; 
			$this->view->render('salary/salarytype/addeditsalarytype');
		}else{
			header('location: ' . URL . 'salary/salarytype');
		}
		
    }
	
	
	function getallsalarytype()
	{
		$viewper = $this->CheckPermission(67, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$salarytype = $this->loadModel('Salarytype');
		$salarytypearray = $salarytype->getAll($arr);
		echo json_encode($salarytypearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getsalarytype()
	{
		$viewper = $this->CheckPermission(67, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['salarytypeid'];
			$salarytype = $this->loadModel('Salarytype');
			$array = $salarytype->getDetail($gid);
			echo json_encode($array);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	/** 
     * Functions for perfom operation on gratuity table
     * getall function fetching gratuity list
	 * @returning json array of data as result
     */
	function createsalarytype()
	{
		try{
		$addper = $this->CheckPermission(67, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarytype'];
			$arr[3] = $_POST['salaryapply'];
			$arr[4] = $_POST['desc'];
			$arr[5] = $_POST['division'];
			$arr[6] = $_POST['grade'];
			$arr[7] = $_POST['departmentids'];
			$arr[8] = $_POST['designationids'];
			$arr[9] = $_POST['employeeexperience']; 
			$arr[10] = $_POST['salarys'];
			$arr[11] = $_POST['salaryamt'];
			$arr[12] = $_POST['exptype'];
			$arr[13] = $_POST['salaryrangemin'];
			$arr[14] = $_POST['salaryrangemax'];
			$arr[15] = $_POST['employeeid'];
			
			$dept = $this->loadModel('Salarytype');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	 /**
     * Functions for perfom operation on gratuity table
     * delete function from gratuity list
	 * @returning json array of data as result
     */
	 
	 function updatedesalarytype()
	{
		$editper = $this->CheckPermission(67, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarytypeid'];
			$arr[3] = $_POST['salarytype'];
			$arr[4] = $_POST['salaryapply'];
			$arr[5] = $_POST['desc'];
			$arr[6] = $_POST['division'];
			$arr[7] = $_POST['grade'];
			$arr[8] = $_POST['departmentids'];
			$arr[9] = $_POST['designationids'];
			$arr[10] = $_POST['employeeexperience'];
			$arr[11] = $_POST['salarys'];	
			$arr[12] = $_POST['salaryamt'];	
			$arr[13] = $_POST['exptype'];	
			$arr[14] = $_POST['salaryrangemin'];
			$arr[15] = $_POST['salaryrangemax'];
			$arr[16] = $_POST['employeeid'];
			$dept = $this->loadModel('Salarytype');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletesalarytype($did)
	{
		$deleteper = $this->CheckPermission(67, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Salarytype');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getSalarytypeData()
	{
		$editper = $this->CheckPermission(67, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(67, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$salarytype = $this->loadModel('Salarytype');
		$salarytypearray = $salarytype->getDataTable($editper, $deleteper);
		echo json_encode($salarytypearray);
	}
	///////////////////////// SALARY TYPE CONTROLLER ENDS HERE//////////////
	/////////////////////////// MODE PAYMENT CONTROLLER START HERE////////////////
	function getallModePayment() {
		$viewper = $this->CheckPermission(240, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper) {
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$modepayment = $this->loadModel('ModePayment');
			$modepayarray = $modepayment->getAll($arr);
			echo json_encode($modepayarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	function modePayment() {
		$viewper = $this->CheckPermission(240, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(240, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/modepayment/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	function getModePaymentData() {
		$editper = $this->CheckPermission(240, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(240, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$modepayment = $this->loadModel('ModePayment');
		$modepayarray = $modepayment->getDataTable($editper, $deleteper);
		echo json_encode($modepayarray);
	}
	function addmodepayment()  {
		$addper = $this->CheckPermission(240, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->modepayid =0;
			$this->view->val = 0; 
			$this->view->render('salary/modepayment/addmodepayment');
		}else{
			header('location: ' . URL . 'salary/modePayment');
		}
    }
	function deleteModePayment($did) {
		$deleteper = $this->CheckPermission(240, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('ModePayment');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/bank');
	}
	function getaModePayment() {
		$viewper = $this->CheckPermission(240, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper) {
			$gid = $_POST['modepayid'];
			$bank = $this->loadModel('ModePayment');
			$modearray = $bank->getDetail($gid);
			echo json_encode($modearray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	function editModePayment($id) {
		$editper = $this->CheckPermission(240, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper)) {
			$this->view->modepayid = Utils::decode5t($id); 
			$this->view->val = 0; 
			$this->view->render('salary/modepayment/addmodepayment');
		}else{
			header('location: ' . URL . 'salary/modePayment');
		}
    }

	function viewModePayment($id,$val) {
		if(isset($id)  && isset($val)) {
			$this->view->val = $val; 
			$this->view->modepayid = Utils::decode5t($id); 
			$this->view->render('salary/modepayment/addmodepayment');
		}else{
			header('location: ' . URL . 'salary/modePayment');
		}
	}
	
	function createModePayment() {	
		$addper = $this->CheckPermission(240, 4);  ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper) {
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['modepay'];
			$dept = $this->loadModel('ModePayment');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}
	function updateModePayment() {
		$editper = $this->CheckPermission(240, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper) {
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['modepay'];
			$arr[3] = $_POST['modepayid'];		
			$dept = $this->loadModel('ModePayment');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	///////////////////////// MODE PAYMENT CONTROLLER ENDS HERE//////////////
	///////////////////////////// SALARY DISTRIBUTION CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perfom operation on SALARY DISTRIBUTION table
     * getall function fetching gratuity list
	 * @returning json array of data as result
     */
	
	function salarydistribution()
    {
        
		$viewper = $this->CheckPermission(53, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(53, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/salarydistribution/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	function addsalarydistribution()
    {
		$addper = $this->CheckPermission(53, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->salarydistributionid =0;
			$this->view->val = 0; 
			$this->view->render('salary/salarydistribution/addeditsalarydistribution');
		}else{
			header('location: ' . URL . 'salary/salarydistribution');
		}
    }
	
	function editsalarydistribution($id)
    {
		$editper = $this->CheckPermission(53, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->salarydistributionid =Utils::decode5t($id); 
			$this->view->val = 0; 
			$this->view->render('salary/salarydistribution/addeditsalarydistribution');
		}else{
			header('location: ' . URL . 'salary/salarydistribution');
		}
    }
	
	function viewsalarydistribution($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->salarydistributionid = Utils::decode5t($id); 
			$this->view->render('salary/salarydistribution/addeditsalarydistribution');
		}else{
			header('location: ' . URL . 'salary/salarydistribution');
		}
		
    }
	
	function getallsalarydistribution()
	{
		$viewper = $this->CheckPermission(53, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$salarydistribution = $this->loadModel('Salarydistribution');
			$salarydistributionarray = $salarydistribution->getAll($arr);
			echo json_encode($salarydistributionarray);			
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getsalarydistribution()
	{
		$viewper = $this->CheckPermission(53, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['salarydistributionid'];
			$salarydistribution = $this->loadModel('Salarydistribution');
			$array = $salarydistribution->getDetail($gid);
			echo json_encode($array);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}			
	}
	
	/** 
     * Functions for perfom operation on gratuity table
     * getall function fetching gratuity list
	 * @returning json array of data as result
     */
	function createsalarydistribution()
	{
		$addper = $this->CheckPermission(53, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarys'];
			$dept = $this->loadModel('Salarydistribution');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);				
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on gratuity table
     * delete function from gratuity list
	 * @returning json array of data as result
     */
	 
	 function updatedesalarydistribution()
	{
		$editper = $this->CheckPermission(53, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarys'];
			$dept = $this->loadModel('Salarydistribution');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}				
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletesalarydistribution($did)
	{
		$deleteper = $this->CheckPermission(53, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Salarydistribution');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getSalarydistributionData()
	{
		$editper = $this->CheckPermission(53, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(53, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$salarydistribution = $this->loadModel('Salarydistribution');
		$salarydistributionarray = $salarydistribution->getDataTable($editper, $deleteper);
		echo json_encode($salarydistributionarray);
	}
	
	/** 
	 ///////////////////////////// SALARY CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on salary table
     * getall function fetching salaryhead list
	 * @returning json array of data as result
     */
	
	
	function pastsalary()
    {
        $viewper = $this->CheckPermission(66, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(66, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$salary = $this->loadModel('Salary');
			$this->view->salarymonth = $salary->getCurrentSalaryMonth();
			$this->view->addper =$addper;
			$this->view->render('salary/generatesalary/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	
	function holdsalary()
    {
        $viewper = $this->CheckPermission(66, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(66, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$salary = $this->loadModel('Salary');
			$this->view->salarymonth = $salary->getCurrentSalaryMonth();
			$this->view->addper =$addper;
			$this->view->render('salary/generatesalary/holdsalary');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	function generatesalary()
    {
        $viewper = $this->CheckPermission(66, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(66, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->hrsts =$_SESSION['ubihrm_hr_sts'];
			$salary = $this->loadModel('Salary');
			$this->view->salarymonth = $salary->getCurrentSalaryMonth();
			$this->view->render('salary/generatesalary/generatesalary');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	function finalsettlement()
    {
        $viewper = $this->CheckPermission(143, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(143, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/finalsettlement/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	
	function finalsettlementhistory()
    {
        $viewper = $this->CheckPermission(143, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(143, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/finalsettlement/finalsettlementhistory');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	
	function createfinalsettlementsalary()
	{
		$addper = $this->CheckPermission(143, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['empid'];
			$arr[3] = $_POST['netsalary'];
			$arr[4] = $_POST['paiddays'];
			$arr[5] = $_POST['salarys'];
			$arr[6] = $_POST['monthdate'];
			$arr[7] = $_POST['lastdate'];
			$arr[8] = $_POST['checklist'];
			$arr[9] = $_POST['bankname'];
			$arr[10] = $_POST['bankcode'];
			$arr[11] = $_POST['bankacct'];
			
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->CreateFinalSettlement($arr);
			echo json_encode($salaryarray);		
			}catch(Exception $e){ echo $e->getMessage();}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	function addfinalsettlement($id)
    {
		
		$addper = $this->CheckPermission(143, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper && isset($id)){
			$this->view->salaryid = $id;
			$this->view->val = 0; 
			$this->view->render('salary/finalsettlement/addeditsalary');
		}else{
			header('location: ' . URL . 'salary/finalsettlement');
		}
    }
	
	function getfinalsalarydetail()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['emp_id'];
			$arr[3] = $_POST['lastdate'];
			$arr[4] = $_POST['empsts'];
			$employee = $this->loadModel('Salary');
			$employeearray = $employee->getFinalSettlementSalaryDetail($arr);
			echo json_encode($employeearray);				
		}catch(Exception $e){$e->getMessage();}
	}
	function getfinalsalarydatatable()
	{
		try{
		$employee = $this->loadModel('Salary');
		$employeearray = $employee->getFinalSettlementDataTable();
		echo json_encode($employeearray);				
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	function getfinalSettlementHistoryTable()
	{
		try{
		$employee = $this->loadModel('Salary');
		$employeearray = $employee->getFinalSettlementHistoryData();
		echo json_encode($employeearray);				
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	function getchecklist()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['severanid'];
			$employee = $this->loadModel('Salary');
			$employeearray = $employee->getAllChecklist($arr );
			echo json_encode($employeearray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	
	function getsalarymonth()
	{
		$viewper = $this->CheckPermission(66, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$employee = $this->loadModel('Salary');
			$employeearray = $employee->getSalaryMonth($arr );
			echo json_encode($employeearray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	
	function getemployeesalarydetail()
	{
		$viewper = $this->CheckPermission(66, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['emp_id'];
			$employee = $this->loadModel('Salary');
			$employeearray = $employee->getEmployeeSalaryDetail($arr);
			echo json_encode($employeearray);	
			}catch(Exception $e){ echo $e->getMessage();}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	
	function getemployeebulksalarydetail($val,$batch=0)
	{
		$viewper = $this->CheckPermission(66, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarymonth'];
			$arr[3] = isset($_POST['division'])?$_POST['division']:0;
			$arr[4] = isset($_POST['dept'])?$_POST['dept']:0;
			$arr[5] = $_POST['modepayment'];
			$arr[6] = isset($_POST['designation'])?$_POST['designation']:0;
			$arr[7] = isset($_POST['employeeids'])?$_POST['employeeids']:0;
			$arr[8] = isset($_POST['shift'])?$_POST['shift']:0;
			$employee = $this->loadModel('Salary');
			if($val==3)
				$employeearray = $employee->getRemainingEmployeeBulkSalary($arr,$val);
			else
				$employeearray = $employee->getEmployeeBulkSalaryDetail($arr,$val,$batch);
			echo json_encode($employeearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}					
	}
	function getemployeebulkltadetail($val)
	{
		$viewper = $this->CheckPermission(66, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarymonth'];
			$arr[3] = $_POST['division'];
			$arr[4] = $_POST['department'];
			$arr[5] = $_POST['designation'];
			$arr[6] = $_POST['grade'];
			$employee = $this->loadModel('Salary');
			
			$employeearray = $employee->getEmployeeBulkLTA($arr,$val);
			echo json_encode($employeearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}					
	}
	function savebulklta()
	{
		$addper = $this->CheckPermission(66, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarys'];
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->SaveBulkLTA($arr);
			echo json_encode($salaryarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	function addsalary()
    {
		
		$addper = $this->CheckPermission(66, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->salaryid =0;
			$this->view->val = 0; 
			$this->view->render('salary/generatesalary/addeditsalary');
		}else{
			header('location: ' . URL . 'salary/generatesalary');
		}
    }
	
	function editsalary($id,$val=0)
    {
		$editper = $this->CheckPermission(66, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->salaryid = $id; //$dept->getDetail($id);
			$this->view->val = $val; 
			$this->view->render('salary/generatesalary/addeditsalary');
		}else{
			header('location: ' . URL . 'salary/generatesalary');
		}
    }
	
	function viewpayslip($id,$val)
    {
		
		if(isset($id) && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->salaryid = $id; //$dept->getDetail($id);
			$this->view->render('salary/generatesalary/printsalary');
		}else{
			header('location: ' . URL . 'salary/pastsalary');
		}
		
    }
	
	function viewsalarycertificate($id,$val)
    {
		
		if(isset($id) && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->salaryid = $id; //$dept->getDetail($id);
			$this->view->render('salary/generatesalary/printsalarycertificate');
		}else{
			header('location: ' . URL . 'salary/pastsalary');
		}
		
    }
	
	function viewsalarytransfercertificate($id,$val)
    {
		
		if(isset($id) && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->salaryid = $id; //$dept->getDetail($id);
			$this->view->render('salary/generatesalary/printsalarytransfercertificate');
		}else{
			header('location: ' . URL . 'salary/pastsalary');
		}
		
    }
	function getPayrollDetials()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarymonth'];
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->getMonthPayrollDetail($arr);
			//echo json_encode($salaryarray);
			$this->view->salarydetails=$salaryarray;
		}catch(Exception $e){
			$result = array();
			$result['status']=false;
			$result['errorMsg']=$e->getMessage();;
			echo json_encode($result);
		}
	}
	
	function viewmonthpayroll($month)
    {
		try{		
			$this->view->message = ""; 
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $month;
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->getMonthPayrollDetail($arr);
			//echo json_encode($salaryarray);
			$this->view->salarydetails=$salaryarray;
			$this->view->render('salary/generatesalary/viewmonthpayroll');
			
		}catch(Exception $e){
			echo $e->getMessage();
			//header('location: ' . URL . 'salary/pastsalary');
		}
		
    }
	
	function viewsalary($id,$val)
    {
		
		if(isset($id) && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->salaryid = $id; //$dept->getDetail($id);
			$this->view->render('salary/generatesalary/viewsalary');
		}else{
			header('location: ' . URL . 'salary/pastsalary');
		}
		
    }
	function getallsalary()
	{
		$viewper = $this->CheckPermission(66, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->getAll($arr);
			echo json_encode($salaryarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}					
	}
	
	function getalladditionsalary()
	{
		$viewper = $this->CheckPermission(66, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['headtype'];
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->getAllAdditionHead($arr);
			echo json_encode($salaryarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}				
	}
	
	function getasalary()
	{
		$viewper = $this->CheckPermission(66, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		
		if($viewper)
		{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salaryid'];
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->getDetail($arr);
			echo json_encode($salaryarray);		
			}catch(Exception $e){ echo $e->getMessage();}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}			
	}
	function getasalaryforprint()
	{
		
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salaryid'];
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->getDetail($arr);
			echo json_encode($salaryarray);		
			}catch(Exception $e){ echo $e->getMessage();}
				
	}
	
	function getAlertsforSalarygenerate()
	{
		$viewper = $this->CheckPermission(66, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->getAlerts($arr);
			echo json_encode($salaryarray);		
			}catch(Exception $e){ echo $e->getMessage();}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}			
	}
	
	function getasalaryforupdate()
	{
		$viewper = $this->CheckPermission(66, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salaryid'];
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->getDetail($arr);
			echo json_encode($salaryarray);		
			}catch(Exception $e){ echo $e->getMessage();}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}			
	}
	
	/** 
     * Functions for perfom operation on salary table
     * getall function fetching salary list
	 * @returning json array of data as result
     */
	function createsalary()
	{
		$addper = $this->CheckPermission(66, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['empid'];
			$arr[3] = $_POST['empctc'];
			$arr[4] = $_POST['paiddays'];
			$arr[5] = $_POST['salarys'];
			$arr[6] = $_POST['monthdate'];
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->Create($arr);
			echo json_encode($salaryarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	function createbulksalary()
	{
		$addper = $this->CheckPermission(66, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarys'];
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->CreateBulkSalary($arr);
			echo json_encode($salaryarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	
	
	 /**
     * Functions for perfom operation on salary table
     * delete function from salary list
	 * @returning json array of data as result
     */
	 
	 function updatedesalary()
	{
		$editper = $this->CheckPermission(66, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarys'];
			$arr[3] = $_POST['salaryid'];
			$arr[4] = $_POST['bankname'];
			$arr[5] = $_POST['bankcode'];
			$arr[6] = $_POST['bankacct'];
			$arr[7] = $_POST['netsalary'];
			$arr[8] = $_POST['desc'];
			$arr[9] = $_POST['agentid'];
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->Update($arr);
			echo json_encode($salaryarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}			
	}
	
	function updatesalary()
	{
		$addper = $this->CheckPermission(66, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salarys'];
			$arr[3] = isset($_POST['holdsts'])?$_POST['holdsts']:0;
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->UpdateSalary($arr);
			echo json_encode($salaryarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	function deletesalary($did)
	{
		$deleteper = $this->CheckPermission(66, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Salary');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getPastSalaryData()
	{
		try{
		$editper = $this->CheckPermission(66, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(66, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$salary = $this->loadModel('Salary');
		$salaryarray = $salary->getPastSalaryDataTable($editper, $deleteper);
		echo json_encode($salaryarray);
		}catch(Exception $e){echo $e->getMessage();}
	}
	
	function getHoldSalaryData()
	{
		try{
		$editper = $this->CheckPermission(66, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(66, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$salary = $this->loadModel('Salary');
		$salaryarray = $salary->getHoldSalaryDataTable($editper, $deleteper);
		echo json_encode($salaryarray);
		}catch(Exception $e){echo $e->getMessage();}
	}
	
	function getSalaryData()
	{
		$editper = $this->CheckPermission(66, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(66, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$salary = $this->loadModel('Salary');
		$salaryarray = $salary->getDataTable($editper, $deleteper);
		echo json_encode($salaryarray);
	}
	
	function getFinalSalaryData()
	{
		$editper = $this->CheckPermission(66, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(66, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$salary = $this->loadModel('Salary');
		$salaryarray = $salary->getFinalSalaryDataTable($editper, $deleteper);
		echo json_encode($salaryarray);
	}
	
	 ////////////////////////////  REPORT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perfom operation on report table
     * getall function fetching report list
	 * @returning json array of data as result
     */
	
	function report()
    {
		$viewper = $this->CheckPermission(70, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(70, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/reports/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	function addreport()
    {
		$addper = $this->CheckPermission(70, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->reportid =0;
			$this->view->val = 0; 
			$this->view->render('salary/reports/addeditreport');
		}else{
			header('location: ' . URL . 'salary/report');
		}
    }
	
	function editreport($id)
    {
		$editper = $this->CheckPermission(70, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->reportid = Utils::decode5t($id);//$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('salary/reports/addeditreport');
		}else{
			header('location: ' . URL . 'salary/report');
		}
		
    }
	
	function viewreport1($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->val = $val; 
			$this->view->render('salary/reports/addeditreport');
		}else{
			header('location: ' . URL . 'salary/report');
		}
		
    }
	function viewreport($id)
    {
		
		if(isset($id) )
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->render('salary/reports/viewreport');
		}else{
			header('location: ' . URL . 'salary/report');
		}
		
    }
	
	function daterangereport($val)
	{
		try{
			$deptarray=array();
			$dept = $this->loadModel('Report');
			if($val==1){
				$id=$_POST['reportid'];
				$salaryarray = $dept->getDetail($id);
				//echo json_encode($salaryarray);
				$this->view->salarydetails=$salaryarray;
				$arr=array();
				$arr[0] = $_SESSION['ubihrm_user_id'];
				$arr[1] = $_SESSION['ubihrm_org_id'];
				$salary = $this->loadModel('Division');
				$this->view->divisions=$salary->getAll($arr);
				$salary = $this->loadModel('Department');
				$this->view->department=$salary->getAll($arr);
				$salary = $this->loadModel('Channel');
				$this->view->costcentre=$salary->getAll($arr);
				
				$this->view->render('salary/reports/salarydistribution');
			}
			else if($val==57){
				$id=$_POST['reportid'];
				$salaryarray = $dept->getDetail($id);
				//echo json_encode($salaryarray);
				$this->view->salarydetails=$salaryarray;
				$arr=array();
				$arr[0] = $_SESSION['ubihrm_user_id'];
				$arr[1] = $_SESSION['ubihrm_org_id'];
				$salary = $this->loadModel('Division');
				$this->view->divisions=$salary->getAll($arr);
				$salary = $this->loadModel('Shift');
				$this->view->shifts=$salary->getAll($arr);
				
				$this->view->render('salary/reports/payroll');
			}elseif($val==29){
				$id=$_POST['reportid'];
				
				$salaryarray = $dept->getDetail($id);
				$this->view->salarydetails=$salaryarray;
				
				$arr=array();
				$arr[0] = $_SESSION['ubihrm_user_id'];
				$arr[1] = $_SESSION['ubihrm_org_id'];
				
				$salary = $this->loadModel('Division');
				$this->view->divisions=$salary->getAll($arr);
				$salary = $this->loadModel('Department');
				$this->view->department=$salary->getAll($arr);
				$salary = $this->loadModel('Channel');
				$this->view->costcentre=$salary->getAll($arr);
				$this->view->val=$val;
				$this->view->render('salary/reports/grandtotal');
			}
			if($val==2){
				$deptarray = $dept->getEmployeeAdditionDeduction();
			}
			if($val==16){
				$deptarray = $dept->EmployeeGratuity();
			}
			if($val==30){
				$deptarray = $dept->getMonthPayrollDetail(3);////WPS
			}
			else if($val==31){
				$deptarray = $dept->getMonthPayrollDetail(1); ////LBT
			}
			else if($val==33){
				$deptarray = $dept->getMonthPayrollDetail(2);////BT
			}elseif($val==55){
				$deptarray = $dept->getMonthPayrollDetailSIF();
			}elseif($val==58){
				$deptarray = $dept->getMonthDubaiSIFDetail();
			}
			else if($val==38){
				$id=$_POST['reportid'];
				
				$salaryarray = $dept->getDetail($id);
				$this->view->salarydetails=$salaryarray;
				
				$arr=array();
				$arr[0] = $_SESSION['ubihrm_user_id'];
				$arr[1] = $_SESSION['ubihrm_org_id'];
				$salary = $this->loadModel('Division');
				$this->view->divisiondata=$salary->getAll($arr);
				$salary = $this->loadModel('Costcentre');
				$this->view->divisions=$salary->getAll($arr);
				$salary = $this->loadModel('Department');
				$this->view->department=$salary->getAll($arr);
				$salary = $this->loadModel('Channel');
				$this->view->channels=$salary->getAll($arr);
				
				$this->view->val=$val;
				$this->view->render('salary/reports/njvreport');
			}
			
			echo json_encode($deptarray);
		}catch(Exception $e) {
			echo $e->getMessage();
		}
	}
	
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletereport($did)
	{
		$deleteper = $this->CheckPermission(69, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Report');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getReportData()
	{
		$editper = $this->CheckPermission(70, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(70, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$tabid=4;
		$report = $this->loadModel('Report');
		$reportarray = $report->getDataTable($editper, $deleteper,$tabid);
		echo json_encode($reportarray);
	}
	
	function changestatus()
	{
		$editper = $this->CheckPermission(119, 2);  ///////// CHECK FOR EDIT PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salaryadvanceid'];
			$arr[3] = $_POST['approverresult'];
			$arr[4] = $_POST['comment'];
			
			$dept = $this->loadModel('Salaryapproval');
			$deptarray = $dept->Approve($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	function salaryadvanceapproval()
    {
		$viewper = $this->CheckPermission(119, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(119, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/salaryadvanceapproval/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	
	function getasalaryadvanceapproval()
	{
		$viewper = $this->CheckPermission(119, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['salaryadvanceid'];
			$leaveapproval = $this->loadModel('Salaryapproval');
			$leaveapprovalarray = $leaveapproval->getDetail($gid);
			echo json_encode($leaveapprovalarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getallsalaryadvanceapprover()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['salaryadvanceid'];
			
			$leaveapproval = $this->loadModel('Salaryapproval');
			$leaveapprovalarray = $leaveapproval->getAllApprover($arr);
			echo json_encode($leaveapprovalarray);	
			
		
	}
	function getallClaimapprover()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['claimid'];
			
			$leaveapproval = $this->loadModel('Salaryapproval');
			$leaveapprovalarray = $leaveapproval->getAllClaimApprover($arr);
			echo json_encode($leaveapprovalarray);	
			
		
	}
	function viewsalaryadvanceapproval($id,$val)
    {
		$viewper = $this->CheckPermission(119, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		
		if(isset($id) && isset($val) && ($viewper) )
		{			
			$this->view->val = $val; 
			$this->view->salaryadvanceid = $id; //$dept->getDetail($id);
			$this->view->render('salary/salaryadvanceapproval/addeditsalaryapproval');
		}else{
			header('location: ' . URL . 'salary/salaryadvanceapproval');
		}		
    }
	
	function getSalaryAdvanceApprovalData()
	{
		$editper = $this->CheckPermission(119, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(119, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$salary = $this->loadModel('Salaryapproval');
		$salaryarray = $salary->getDataTable($editper, $deleteper);
		echo json_encode($salaryarray);
	}
	
	/** 
	 ///////////////////////////// CLAIM HEAD CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on salaryhead table
     * getall function fetching salaryhead list
	 * @returning json array of data as result
     */
	
	function claimhead()
    {
        $viewper = $this->CheckPermission(169, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(169, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('salary/claimhead/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
    }
	function addclaimhead()
    {	
		$addper = $this->CheckPermission(169, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->claimheadid =0;
			$this->view->val = 0; 
        $this->view->render('salary/claimhead/addeditclaimhead');
		}else{
			header('location: ' . URL . 'salary/claimhead');
		}
    }
	
	function editclaimhead($id)
    {
		$editper = $this->CheckPermission(169, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->claimheadid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('salary/claimhead/addeditclaimhead');
		}else{
			header('location: ' . URL . 'salary/claimhead');
		}
    }
	
	function viewclaimhead($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->claimheadid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('salary/claimhead/addeditclaimhead');
		}else{
			header('location: ' . URL . 'salary/claimhead');
		}
		
    }
	
	function getallclaimhead()
	{
		$viewper = $this->CheckPermission(169, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$claimhead = $this->loadModel('Claimhead');
			$claimheadarray = $claimhead->getAll($arr);
			echo json_encode($claimheadarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	
	function getaclaimhead()
	{
		$viewper = $this->CheckPermission(169, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['claimheadid'];
			$claimhead = $this->loadModel('Claimhead');
			$claimheadarray = $claimhead->getDetail($gid);
			echo json_encode($claimheadarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on claimhead table
     * getall function fetching claimhead list
	 * @returning json array of data as result
     */
	function createclaimhead()
	{
		$addper = $this->CheckPermission(169, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['headname'];
			
			$claimhead = $this->loadModel('Claimhead');
			$claimheadarray = $claimhead->Create($arr);
			echo json_encode($claimheadarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on claimhead table
     * delete function from claimhead list
	 * @returning json array of data as result
     */
	 
	 function updatedeclaimhead()
	{
		$editper = $this->CheckPermission(169, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['headname'];
			$arr[3] = $_POST['claimheadid'];
			$claimhead = $this->loadModel('Claimhead');
			$claimheadarray = $claimhead->Update($arr);
			echo json_encode($claimheadarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deleteclaimhead($did)
	{		
		$deleteper = $this->CheckPermission(169, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Claimhead');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getClaimheadData()
	{
		$editper = $this->CheckPermission(169, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(169, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
		$claimhead = $this->loadModel('Claimhead');
		$claimheadarray = $claimhead->getDataTable($editper, $deleteper);
		echo json_encode($claimheadarray);
		}catch(Exception $e){ echo $e->getMessage();}
	}
	//////////////////Claim request controller starts from here//////////
	
	function claims()
    {try{
		$viewper = $this->CheckPermission(170, 1); ///////// CHECK FOR VIEW PERMISSION  //////////
		if($viewper){

			$this->view->render('salary/claimapproval/index');
		}else{
			header('location: ' . URL . 'salary/index');
		}
	}catch(Exception $e){}
    }
	
	function getClaimApprovalData()
	{	try{
			$editper = $this->CheckPermission(170, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
			$deleteper = $this->CheckPermission(170, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
			$employeeleave = $this->loadModel('Claim');
			$employeeleavearray = $employeeleave->getDataTable($editper, $deleteper);
			echo json_encode($employeeleavearray);
		}catch(Exception $e){}
	}
		
	function getaclaimapproval()
	{
		$viewper = $this->CheckPermission(170, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['claimid'];
			$leaveapproval = $this->loadModel('Salaryapproval');
			$leaveapprovalarray = $leaveapproval->getDetail($gid);
			echo json_encode($leaveapprovalarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/* function getallclaimapprover()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['claimid'];
			
			$leaveapproval = $this->loadModel('Salaryapproval');
			$leaveapprovalarray = $leaveapproval->getAllApprover($arr);
			echo json_encode($leaveapprovalarray);	
			
		
	} */
	function viewclaimapproval($id,$val)
    {
		$viewper = $this->CheckPermission(170, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		
		if(isset($id) && isset($val) && ($viewper) )
		{			
			$this->view->val = $val; 
			$this->view->claimid =  Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('salary/claimapproval/addeditclaimapproval');
		}else{
			header('location: ' . URL . 'salary/claims');
		}		
    }
	function editclaimapproval($id)
    {
		$viewper = $this->CheckPermission(170, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		
		if(isset($id)  && ($viewper) )
		{			
			$this->view->val = 0; 
			$this->view->claimid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('salary/claimapproval/addeditclaimapproval');
		}else{
			header('location: ' . URL . 'salary/claims');
		}		
    }
	function claimapprove()
	{try{
		$editper = $this->CheckPermission(119, 2);  ///////// CHECK FOR EDIT PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['claimid'];
			$arr[3] = $_POST['approverresult'];
			$arr[4] = $_POST['comment'];
			$arr[5] = $_POST['applymonth'];
			$arr[6] = $_POST['financeby'];
			
			$dept = $this->loadModel('Claim');
			$deptarray = $dept->Approve($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}
	}
	function releaseclaim($id)
		{try{
			$viewper = $this->CheckPermission(119, 1);
			if($viewper){
				$this->view->val = 0;
				$this->view->claimid = Utils::decode5t($id);
				$this->view->render('salary/claimapproval/releaseclaim');
			}else{
				header('location: ' . URL . 'employee/index');
			}
		}catch(Exception $e){}
    }
	function deleteclaims($did)
	{	try{	
		$deleteper = $this->CheckPermission(119, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Claim');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}	
	}catch(Exception $e){}
	}
	
	function setProvidentFund()
	{
		try{
		$addper = $this->CheckPermission(212, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['minsalary'];
			$arr[3] = $_POST['minemployee'];
			$arr[4] = $_POST['pfsts'];
			$arr[5] = $_POST['employeepercent'];
			$arr[6] = $_POST['employeesalarytype'];
			$arr[7] = $_POST['employerpercent'];
			$arr[8] = $_POST['employersalarytype'];
			$arr[9] = $_POST['rate'];
			$arr[10] = $_POST['period'];
			$arr[11] = $_POST['salarytype'];
			$arr[12] = $_POST['maxamount'];
			$arr[13] = isset($_POST['division'])?$_POST['division']:0;
			$arr[14] = isset($_POST['department'])?$_POST['department']:0;
			$arr[15] =  isset($_POST['grade'])?$_POST['grade']:0;
			$arr[16] = $_POST['minyear'];
			$arr[17] = $_POST['maxyear'];
			$arr[18] =isset($_POST['employees'])?$_POST['employees']:0;
			$arr[19] = $_POST['empchk'];
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->setProvidentFund($arr);
			echo json_encode($salaryarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function setPenalty()
	{
		try{
		$addper = $this->CheckPermission(310, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['latecomingsts'];
			$arr[3] = $_POST['noofdayslate'];
			$arr[4] = $_POST['latededuct'];
			$arr[5] = $_POST['latesalarytype'];
			$arr[6] = $_POST['earlyleaveing'];
			$arr[7] = $_POST['noofdayearly'];
			$arr[8] = $_POST['earlydeduct'];
			$arr[9] = $_POST['earlysalarytype'];
			$arr[10] = $_POST['absentunautho'];
			$arr[11] = $_POST['absentdeduct'];
			$arr[12] = $_POST['absentsalarytype'];
			$arr[13] = $_POST['penaltyid'];
			$arr[14] = $_POST['empchk'];
			$arr[15] =isset($_POST['division'])?$_POST['division']:0;
			$arr[16] = isset($_POST['department'])?$_POST['department']:0;
			$arr[17] =  isset($_POST['employees'])?$_POST['employees']:0;
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->setPenalty($arr);
			echo json_encode($salaryarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
		function setESI()
	{
		try{
		$addper = $this->CheckPermission(216, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['minsalary'];
			$arr[3] = $_POST['esists'];
			$arr[4] = $_POST['employeepercent'];
			$arr[5] = $_POST['employeesalarytype'];
			$arr[6] = $_POST['employerpercent'];
			$arr[7] = $_POST['employersalarytype'];
			$arr[8] = $_POST['salarytype'];
			$arr[9] = $_POST['allempsts'];
			$arr[10] = isset($_POST['division'])?$_POST['division']:0;
			$arr[11] = isset($_POST['department'])?$_POST['department']:0;
			$arr[12] =  isset($_POST['grade'])?$_POST['grade']:0;
			$arr[13] = $_POST['minyear'];
			$arr[14] = $_POST['maxyear'];
			$arr[15] = isset($_POST['employees'])?$_POST['employees']:0;
			$arr[16] = $_POST['empchk'];
			$arr[17] = isset($_POST['location'])?$_POST['location']:0;
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->setESI($arr);
			echo json_encode($salaryarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function setTDS()
	{
		try{
		$addper = $this->CheckPermission(217, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['tds'];
			$arr[3] = $_POST['tds_sts'];
			$arr[4] =  isset($_POST['division'])?$_POST['division']:0;
			$arr[5] =  isset($_POST['department'])?$_POST['department']:0;
			$arr[6] = isset($_POST['grade'])?$_POST['grade']:0;
			$arr[7] = $_POST['minyear'];
			$arr[8] = $_POST['maxyear'];
			$arr[9] =isset($_POST['employees'])?$_POST['employees']:0;
			$arr[10] = $_POST['empchk'];
			$arr[11] = $_POST['surcharge'];
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->setTDS($arr);
			echo json_encode($salaryarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getTDS()
	{
		try{
		$addper = $this->CheckPermission(217, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$salaryhead = $this->loadModel('Salary');
			$salaryheadarray = $salaryhead->getTDS($arr);
			echo json_encode($salaryheadarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	
	function getProvidentFund()
	{
		try{
		$addper = $this->CheckPermission(212, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$salaryhead = $this->loadModel('Salary');
			$salaryheadarray = $salaryhead->getProvidentFund($arr);
			echo json_encode($salaryheadarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getPenalty()
	{
		try{
		$addper = $this->CheckPermission(310, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper){
			$salaryhead = $this->loadModel('Salary');
			$salaryheadarray = $salaryhead->getPenalty();
			echo json_encode($salaryheadarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	
		function getESI()
	{
		try{
		$addper = $this->CheckPermission(216, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$salaryhead = $this->loadModel('Salary');
			$salaryheadarray = $salaryhead->getESI($arr);
			echo json_encode($salaryheadarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function showProvident($date="")
    {
		$viewper = $this->CheckPermission(214, 4); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if ($viewper)
		{
			if($date=="")
				$date=date("Y-m-d");		
			$this->view->valdate=$date;
			$this->view->render('salary/settings/showprovidentfund');
		}else{
			header('location: ' . URL . 'salary');
		}
    }
	
	function getEmployeeProvidentFundDataTable($date="")
    {
		try{
		$viewper = $this->CheckPermission(214,4); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if ($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $date;
			$role = $this->loadModel('Salary');
			$rolearray = $role->getEmployeeProvidentFundDataTable($arr);
			echo json_encode($rolearray);	
		}else{
			header('location: ' . URL . 'salary');
		}
		}catch(Exception $e){
			
		}
    }
	
	
	function salarysetup()
    {
		
        $this->view->render('salary/salaryperiod');
    }
	
	function getsalarysetup()
	{
		/*	$gid = $_POST['salarysetupid'];
			$benefit = $this->loadModel('Salary');
			$array = $benefit->getDetail($gid);
			echo json_encode($array);	*/	
		try{
		$addper = $this->CheckPermission(212, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$salaryhead = $this->loadModel('Salary');
			$salaryheadarray = $salaryhead->getsalarysetup($arr);
			echo json_encode($salaryheadarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}	
			
	}
	
	
	
	 /**
     * Functions for perfom operation on gratuity table
     * delete function from gratuity list
	 * @returning json array of data as result
     */
	 
	 function updatedesalarysetup()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['name'];
			$arr[3] = $_POST['salarysetupid'];
			$dept = $this->loadModel('Salary');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
			
	}
	
	
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getSalarySetupData()
	{
		
		$employeeincentive = $this->loadModel('Salary');
		$employeeincentivearray = $employeeincentive->getDataTable();
		echo json_encode($employeeincentivearray);
	}
	
	
	
	/*Create salary paid*/
	/*function salaryPaidDaysSetup()
	{
		try{
			/* $addper=$this->checkPermission(170, 4);
			if($addper){ */
			/*	$salary = $this->loadModel('Salary');
				$salaryArr =$salary->salaryPaidDaysSetup();
				echo json_encode($salaryArr);
			/* }else{
				$result = array();
				$result['status']=false;
				$result['errorMsg']="You don't have add salary permission";
				echo json_encode($result);	
		} */
	/*	}catch(Exception $e){
			Trace($e->getMessage());
		}
	} */
	function salaryPaidDaysSetup()
	{
		try{
			$addper=$this->checkPermission(212, 4);
			if($addper){ 
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['paydays'];
			$arr[3] = $_POST['weekoff'];
			$arr[4] = $_POST['holiday'];
			$arr[5] = date('Y-m-d H:i:s');
			
				$salary = $this->loadModel('Salary');
				$salaryArr =$salary->salaryPaidDaysSetup($arr);
				echo json_encode($salaryArr);
				
				
		  }else{
				$result = array();
				$result['status']=false;
				$result['errorMsg']="You don't have add salary permission";
				echo json_encode($result);	
		}
		
		}catch(Exception $e){
			Trace($e->getMessage());
		}
	}
	
	
	/*function createclaimhead()
	{
		$addper = $this->CheckPermission(169, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['headname'];
			
			$claimhead = $this->loadModel('Claimhead');
			$claimheadarray = $claimhead->Create($arr);
			echo json_encode($claimheadarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}*/
	
	function professionaltax()
    {
		$addper = $this->CheckPermission(262, 4); ////////// CHECK FOR Add provident fund settings PERMISSION  ////////////
		if($addper){
        $this->view->render('salary/settings/professional_tax');
		}else{
			header('location: ' . URL . 'salary/settings/');
		}
    }
	
	function setprofessionaltax()
	{
		try{
		$addper = $this->CheckPermission(217, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['professionaltax'];
			$arr[3] = $_POST['tds_sts'];
			
			$salary = $this->loadModel('Salary');
			$salaryarray = $salary->setProfessionalTax($arr);
			echo json_encode($salaryarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getprofessionaltax()
	{
		try{
		$addper = $this->CheckPermission(217, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$salaryhead = $this->loadModel('Salary');
			$salaryheadarray = $salaryhead->getProfessionaltax($arr);
			echo json_encode($salaryheadarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
}	

