<?php

/**
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class Profile extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();
        // this controller should only be visible/usable by logged in users, so we put login-check here
        Auth::handleLogin();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    function index()
    {
        $this->view->render('profile/index');
    }
	
	function createproject()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_SESSION['ubihrm_user_id'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['desc'];
			$arr[6] = $_POST['title'];
			$arr[7] = $_POST['assignempid'];
			$arr[8] = $_POST['projectstatus'];
			$dept = $this->loadModel('Projects');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);
		}catch(Exception $e){}
	
	}
	
	function updateproject()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_SESSION['ubihrm_user_id'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['desc'];
			$arr[6] = $_POST['title'];
			$arr[7] = $_POST['assignempid'];
			$arr[8] = $_POST['project_id'];
			$arr[9] = $_POST['projectstatus'];
			$dept = $this->loadModel('Projects');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}catch(Exception $e){}
	}
	
	function getatask(){
			$gid = $_POST['taskid'];
			$Tasks = $this->loadModel('Tasks');
			$Tasksarray = $Tasks->getDetail($gid);
			echo json_encode($Tasksarray);		
	}
	
	function updatetimesheet()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_SESSION['ubihrm_user_id'];
			$arr[3] = $_POST['project_id'];
			$dept = $this->loadModel('Projects');
			$deptarray = $dept->UpdateTimesheet($arr);
			echo json_encode($deptarray);		
		
	}
	
	function personal_detail()
    {
		$this->view->employeeid =Utils::encode5t($_SESSION['ubihrm_user_id']);
        $this->view->render('profile/personal_details');
    }
	
	function attendance()
    {
        $this->view->render('profile/attendance');
    }
	
	function leaves()
    {
        $this->view->render('profile/leave/leave');
    }
	function getAttendanceData()
	{
		try{
		$attendance = $this->loadModel('Profile');
		$attendancearray = $attendance->getAttendanceDataTable();
		echo json_encode($attendancearray);
	}catch(Exception $e){}
		
	}
	/////////////////// Added by Abhinav for Time Off/////// on 16 june 2017

	function time_off()
    {
		try{
		$employeeleave = $this->loadModel('Profile');
		$employeetimeoff = $employeeleave->getTimeOffTable();
		$this->view->timeoff=$employeetimeoff;
      $this->view->render('profile/time_off/time_off');
		}catch(Exception $e){ echo $e->getMessage();}
    }

	/////////////////// End Time Off ////////////////////
    
	function documentrequest()
    {
        $this->view->render('profile/documentrequest/index');
    }
	
	function salary()
    {
        $this->view->render('profile/salary');
    }
	
	function change_password()
    {
        $this->view->render('profile/change_password');
    }
	function faq()
    {
        $this->view->render('profile/faq');
    }
	function timeline()
    {
        $this->view->render('profile/timeline');
    }
	
	function issuedassets()
    {
        $this->view->render('profile/issuedassets');
    }
	// dummy view for request assets
	function requestassets()
    {
        $this->view->render('setup/asset/moveassets');
    }
	function grievances()
    {
        $this->view->render('profile/grievances/grievances');
    }
	function salaryadvance()
    {
        $this->view->render('profile/salaryadvance/salaryadvance');
    }function salaryadvanceloan()
    {
        $this->view->render('profile/salaryadvanceloan/salaryadvance');
    }
    function severance()
    {
        $this->view->render('profile/resignation');
    }
	function pending_notification()
    {
        $this->view->render('profile/pending_notifications');
    }
	function certificaterequest()
    {
        $this->view->render('profile/certificaterequest/index');
    }
	function personnel_requisition()
    {
        $this->view->render('profile/personnel_requisition/index');
    }
	
	function addpersonnel_requisition()
	{
		
			$this->view->claimid =0;
			$this->view->val = 0; 
			$this->view->render('profile/personnel_requisition/addeditpersonnel_requisition');
		
    }
	function fetchlastworkingdate()
	{	try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['noticeday'];
		
		$dept = $this->loadModel('Profile');
		$deptarray = $dept->getLastWorkingDate($arr);
		echo json_encode($deptarray);	
		}catch(Exception $e){}
	}
	
	function claims()
    {	try{
			$this->view->render('profile/claim/index');
		}catch(Exception $e){}
    }
	
	function getClaimData()
	{    try{
			$employeeleave = $this->loadModel('Profile');
			$employeeleavearray = $employeeleave->getClaimData();
			echo json_encode($employeeleavearray);
		}catch(Exception $e){}
	}
	
	function addclaim()
	{
		
			$this->view->claimid =0;
			$this->view->val = 0; 
			$this->view->render('profile/claim/addeditclaim');
		
    }
	function editclaim($id)
    {		
		if(isset($id))
		{
			$this->view->claimid =Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('profile/claim/addeditclaim');
		}else{
			header('location: ' . URL . 'profile/claim');
		}
    }
	function createclaim()
	{
	
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['fromdate'];
			$arr[3] = $_POST['todate'];
			$arr[4] = $_POST['purpose'];	
			$arr[5] = $_POST['claimamt'];	
			$arr[6] = $_SESSION['ubihrm_user_id'];
			$arr[7] = 0;
					
			$claim = $this->loadModel('Claim');
			$claimarray = $claim->Create($arr);
			echo json_encode($claimarray);	
			
	}
	
	function updatedeclaim()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['fromdate'];
			$arr[3] = $_POST['todate'];
			$arr[4] = $_POST['purpose'];	
			$arr[5] = $_POST['claimamt'];	
			$arr[6] = $_SESSION['ubihrm_user_id'];
			$arr[7] = $_POST['claimid'];
			$salaryhead = $this->loadModel('Claim');
			$salaryheadarray = $salaryhead->Update($arr);
			echo json_encode($salaryheadarray);	
	}
	
	function uploadClaimDoc()
	{	
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]=$_POST['emp_id'];	
			$arr[3]=$_POST['doc_id'];	
			$arr[4]=$_POST['claimid'];	
							
			$employee = $this->loadModel('Claim');
			$employeearray = $employee->uploadDocument($arr);
			echo json_encode($employeearray);
			
		
	}
	function getallclaimhead()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$claimhead = $this->loadModel('Claimhead');
		$claimheadarray = $claimhead->getAll($arr);
		echo json_encode($claimheadarray);	
				
	}
	
	
	function getaclaim()
	{
		
		$id = $_POST['claimid'];
		$salaryhead = $this->loadModel('Claim');
		$salaryheadarray = $salaryhead->getDetail($id);
		echo json_encode($salaryheadarray);	
	}
	
	function deleteclaim($did)
	{
		
		if(isset($did) )
		{
			$dept = $this->loadModel('Claim');
			$deptarray = $dept->Delete($did);
		}	
		header('location: ' . URL . 'profile/documentrequest');
	}
	
	function checkfiscalyearexit()
	{
		$eid = $_SESSION['ubihrm_user_id'];
		$employee = $this->loadModel('Profile');
		$employeearray = $employee->getempDetail($eid);
		echo json_encode($employeearray);		
	}
	
	function getnotifications()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		
		$dept = $this->loadModel('Dashboard');
		$deptarray = $dept->getNotifications($arr);
		echo json_encode($deptarray);		
	}
	
	function getallnotifications()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$dept = $this->loadModel('Dashboard');
		$deptarray = $dept->getAllNotifications($arr);
		echo json_encode($deptarray);		
	}
	
	function getNotifyData()
	{
		
		$dept = $this->loadModel('Profile');
		$deptarray = $dept->getPendingNotificationTable();
		echo json_encode($deptarray);		
	}
	
	function setnotificationsts($id,$sts)
	{
		$dept = $this->loadModel('Dashboard');
		$deptarray = $dept->setNotifySts($id,$sts);
		//echo json_encode($deptarray);	
		if($sts==0){
		header('location: ' . URL . 'profile/pending_notification');	
		}		
	}
	function deletenotify($did)
	{
		if(isset($did) )
		{
			$dept = $this->loadModel('Profile');
			$deptarray = $dept->DeleteNotify($did);
		}	
		header('location: ' . URL . 'profile/pending_notification');
	}
	function gettimeline()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		
		$dept = $this->loadModel('Dashboard');
		$deptarray = $dept->getTimeLine($arr);
		echo json_encode($deptarray);		
	}
	
    function getallevents()
    {
    	$arr = array();
	$arr[0] = $_SESSION['ubihrm_user_id'];
	$arr[1] = $_SESSION['ubihrm_org_id'];
    	$events = $this->loadModel('Profile');
	$eventarray = $events->getEvents($arr);
	echo json_encode($eventarray);
        //$this->view->render('profile/attendance');
    }
	
	////////////////update profile/////////
	
	function updateemployeeprofile()
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$dept = $this->loadModel('Profile');
		$deptarray = $dept->ProfileUpdate($arr);
		echo json_encode($deptarray);
		}catch(Exception $e){}
	}
	
	function getaemployeedata()
	{
		$eid = $_SESSION['ubihrm_user_id'];
		$employee = $this->loadModel('Profile');
		$employeearray = $employee->getempDetail($eid);
		echo json_encode($employeearray);		
	}
	
	function viewemployee($id=0)
	{
	
		if(isset($id)){
		$this->view->employeeid = $id;
		//$this->view->employeeid =Utils::encode5t($_SESSION['ubihrm_user_id']);
		$this->view->render('profile/viewemployee');	
		}
		else{
			header('location: ' . URL . 'index');
		}
	}
	function getaemployee()
	{
		try{
		$eid =$_POST['employeeid'];
		$employee = $this->loadModel('Profile');
		$employeearray = $employee->getempDetail($eid);
		echo json_encode($employeearray);		
		}catch(Exception $e){}
	}
	function employeechangepassword()
	{	
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2]=$_POST['old_pwd'];
		$arr[3]=$_POST['new_pwd'];
		
		
		$employee = $this->loadModel('Profile');
		$employeearray = $employee->changepwd($arr);
		echo json_encode($employeearray);
	}
	function getIssuedassetsData()
	{
		$issueasset = $this->loadModel('Profile');
		$issueassetarray = $issueasset->getIssuedDataTable();
		echo json_encode($issueassetarray);
	}
	
	function getselfservicedashboard()
	{
		try{
		Utils::Trace("this is getselfservicedashboard");
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		//Utils::Trace($arr[0]." ".$arr[1]);
		$attendance = $this->loadModel('Dashboard');
		$attendancearray = $attendance->getSelfServiceDashboard($arr);
		
		echo json_encode($attendancearray);
		}catch(Exception $e)
		{
			Utils::Trace("this is getselfservicedashboard ".$e->getMessage());
		}
	}
	
	function getprofileleave()
	{
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$attendance = $this->loadModel('Dashboard');
		$attendancearray = $attendance->getleavedashboard($arr);
		echo json_encode($attendancearray);
	}
	function viewpayslip($id,$val)
    {
		
		if(isset($id) && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->salaryid = $id; //$dept->getDetail($id);
			$this->view->render('profile/printsalary');
		}else{
			header('location: ' . URL . 'profile');
		}
		
    }
	function getasalary()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$salary = $this->loadModel('Profile');
		$salaryarray = $salary->getEmployeeSalaryDetail($arr);
		echo json_encode($salaryarray);		
	}
	
	
    function getLeaveData()
	{    
		try{
			$employeeleave = $this->loadModel('Profile');
			$employeeleavearray = $employeeleave->getLeaveTable();
			echo json_encode($employeeleavearray);
		}catch(Exception $e)
		{
			
		}	
	}
	
	function getTimeOffData()
	{    
		
		echo json_encode($employeeleavearray);
	}
	function getDepartmentEmployeeData()
	{   
		$id =$_SESSION['ubihrm_user_id'];
		$employeeleave = $this->loadModel('Profile');
		$employeeleavearray = $employeeleave->getDepartmentEmployee($id);
		echo json_encode($employeeleavearray);
	}
	
	function getLeaveDaysDiff()
	{
		try{
		$id =$_SESSION['ubihrm_user_id'];
		$employeeleave = $this->loadModel('Profile');
		$employeeleavearray = $employeeleave->getLeaveDaysDifference($id );
		echo json_encode($employeeleavearray);
		}catch(Exception $e)
		{
		}
		
	}
	function addleave()
	{
			$this->view->val = 0; 
			$this->view->leaveid  =0;
			$this->view->render('profile/leave/addeditleave');
		
    }
	
function addtimeoff()
	{
			$this->view->val = 0; 
			$this->view->Id  =0;
			$this->view->render('profile/time_off/addtimeoff');
		
    }	
	
	function leavehistory()
	{
		$this->view->render('profile/leave/leavehistory');
		
    }
	
	function editleave($id)
    {		
		if(isset($id))
		{
			$this->view->leaveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('profile/leave/addeditleave');
		}else{
			header('location: ' . URL . 'profile/leaves');
		}
    }
	
	function edittimeoff($id)
    {		
   
		if(isset($id))
		{
			$this->view->Id = $id; //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('profile/time_off/addtimeoff');
		}else{
			header('location: ' . URL . 'profile/time_off');
		}
    }
	
	function viewLeave($id,$val)
    {		
		if(isset($id) && isset($val))
		{
			$this->view->leaveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = $val; 
			$this->view->render('profile/leave/addeditleave');
		}else{
			header('location: ' . URL . 'profile/leaves');
		}
    }
	
	function viewnotification($id,$val)
    {		
		if(isset($id) && isset($val))
		{
			$this->view->notificationid =$id; //$dept->getDetail($id);
			$this->view->val = $val; 
			$this->view->render('profile/viewnotification');
		}else{
			header('location: ' . URL . 'profile');
		}
    }
	
	function activitylogs()
    {		
		$this->view->render('profile/activitylogs');
		
    }
	
	function getActivityLogData()
	{
		
		$objective = $this->loadModel('Profile');
		$objectivearray = $objective->getActivityLogData();
		echo json_encode($objectivearray);
	}
	
	function viewtime_off($id,$val)
    {		
		if(isset($id))
		{
			$this->view->Id = $id; //$dept->getDetail($id);
			$this->view->val = $val; 
			$this->view->render('profile/time_off/addtimeoff');
		}else{
			header('location: ' . URL . 'profile/time_off');
		}
    }
	function getanotification()
	{
		$gid = $_POST['notificationid'];
		$notification = $this->loadModel('Notification');
		$notificationarray = $notification->getDetail($gid);
		echo json_encode($notificationarray);	
	}
	
	function viewSalaryAdvance($id,$val)
    {		
		if(isset($id) && isset($val))
		{
			$this->view->salaryadvanceid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = $val; 
			$this->view->render('profile/salaryadvance/addeditsalaryadvance');
		}else{
			header('location: ' . URL . 'profile/salaryadvance/salaryadvance');
		}
    }
	function viewSalaryAdvanceloan($id,$val)
    {		
		if(isset($id) && isset($val))
		{
			$this->view->salaryadvanceid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = $val; 
			$this->view->render('profile/salaryadvanceloan/addeditsalaryadvance');
		}else{
			header('location: ' . URL . 'profile/salaryadvance/salaryadvance');
		}
    }
	
	function viewDocumentRequest($id,$val)
    {		
		if(isset($id) && isset($val))
		{
			$this->view->documentrequestid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = $val; 
			$this->view->render('profile/documentrequest/addeditdocumentrequest');
		}else{
			header('location: ' . URL . 'profile/documentrequest');
		}
    }
	function viewcertificaterequest($id,$val)
    {		
		if(isset($id) && isset($val))
		{
			$this->view->certificaterequestid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = $val; 
			$this->view->render('profile/certificaterequest/addeditcertificaterequest');
		}else{
			header('location: ' . URL . 'profile/certificaterequest');
		}
    }
	
	function getemployeeleave()
	{		
			$gid = $_POST['employeeleaveid'];
			$employeeleave = $this->loadModel('Employeeleave');
			$employeeleavearray = $employeeleave->getDetail($gid);
			echo json_encode($employeeleavearray);	
	}
	
	function getemployeetimeoff()
	{		
	try{
			$gid = $_POST['timeoffid'];
			$employeeleave = $this->loadModel('Employeeleave');
			$employeeleavearray = $employeeleave->getTimeOffDetail($gid);
			echo json_encode($employeeleavearray);
	}catch(Exception $e){
		
	echo  'Message: ' .$e->getMessage();
	
	}
			
			
	}
	
	
	function createleave()
	{
		$dept = $this->loadModel('Profile');
		$deptarray = $dept->CreateLeave();
		echo json_encode($deptarray);	
	}
	
	function createtimeoff()
	{
		$dept = $this->loadModel('Profile');
		$deptarray = $dept->Createtimeoff();
		echo json_encode($deptarray);	
	}
	
	function updatedeleave()
	{
			$dept = $this->loadModel('Profile');
			$deptarray = $dept->UpdateLeave();
			echo json_encode($deptarray);	
	}
	
	function updatedtimeoff()
	{
		try{
			$dept = $this->loadModel('Profile');
			$deptarray = $dept->UpdateTimeoff();
			echo json_encode($deptarray);	
			}catch(Exception $e) {
			echo  'Message: ' .$e->getMessage();
		}	
	}
	
	function changeleavests($id,$val)
    {		
		if(isset($id))
		{
			$dept = $this->loadModel('Profile');
			$deptarray = $dept->UpdateLeaveSts($id,$val);
			echo json_encode($deptarray);	
			
		}else{
			header('location: ' . URL . 'profile/leaves');
		}
		
    }
	
function changetimeoffsts($id)
    {		
		if(isset($id))
		{
			$dept = $this->loadModel('Profile');
			$deptarray = $dept->UpdateTimeoffSts($id);
			echo json_encode($deptarray);	
			
		}else{
			header('location: ' . URL . 'profile/time_off');
		}
		
    }	
	
	function getselectedemployeeleave()
	{
		try{
			$leavetype = $this->loadModel('Profile');
			$leavetypearray = $leavetype->getEmployeeAllLeaveType();
			echo json_encode($leavetypearray);	
			
		}catch(Exception $e) {
			echo  'Message: ' .$e->getMessage();
		}	
		
	}
	
	function uploadLeaveAttachment()
	{	
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]=$_POST['leave_id'];			
			$employee = $this->loadModel('Profile');
			$employeearray = $employee->uploadLeaveImage($arr);
			echo json_encode($employeearray);
			
		
	}
	
	function getGrievanceData()
	{    
	try{
		$employeeleave = $this->loadModel('Profile');
		$employeeleavearray = $employeeleave->getGrievanceTable();
		echo json_encode($employeeleavearray);
		}catch(Exception $e)
		{
			echo $e->getMessage();
		}
	}
	
	function addgrievance()
	{
		
			$this->view->notificationid =0;
			$this->view->val = 0;
			$this->view->render('profile/grievances/addeditgrievances');
		
    }
	function editgrievance($id)
    {		
		if(isset($id))
		{
			$this->view->notificationid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0;
			$this->view->render('profile/grievances/addeditgrievances');
		}else{
			header('location: ' . URL . 'profile/grievances');
		}
    }
		function notification()
    {	
		$this->view->render('profile/notificationindex');
    }
	function viewGrievance($id,$val)
    {		
		if(isset($id) && isset($val))
		{
			$this->view->notificationid =Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = $val; 
			$this->view->render('profile/grievances/preview');
		}else{
			header('location: ' . URL . 'profile/grievances');
		}
    }
	function deletegrievance($did)
	{
		
		if(isset($did) )
		{
			$dept = $this->loadModel('Grievance');
			$deptarray = $dept->Delete($did);
		}	
		header('location: ' . URL . 'profile/grievances');
	}
	function creategrievance()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['notificationname'];
			$arr[3] = $_POST['message'];
			$arr[4] = $_POST['employeeids'];
			$arr[5] = $_POST['priority'];
			
			$dept = $this->loadModel('Grievance');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
			
			
	}
	
	 /**
     * Functions for perfom operation on notification table
     * delete function from notification list
	 * @returning json array of data as result
     */
	 
	 function updatedgrievance()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['notificationname'];
			$arr[3] = $_POST['message'];
			$arr[4] = $_POST['priority'];
			$arr[5] = $_POST['employeeids'];
			
			$arr[6] = $_POST['notificationid'];
			$dept = $this->loadModel('Grievance');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);				
		
	}
	
	
	
	
	 /**
     * Functions for perfom operation on notification table
     * delete function from notification list
	 * @returning json array of data as result
     */
	 
	function getSalaryadvanceData()
	{    
		$employeeleave = $this->loadModel('Profile');
		$employeeleavearray = $employeeleave->getSalaryadvanceTable();
		echo json_encode($employeeleavearray);
	}function getSalaryadvanceloanData()
	{    
		$employeeleave = $this->loadModel('Profile');
		$employeeleavearray = $employeeleave->getSalaryadvanceloanTable();
		echo json_encode($employeeleavearray);
	}
	
	function addsalaryadvance()
	{
		
			$this->view->salaryadvanceid =0;
			$this->view->val = 0; 
			$this->view->render('profile/salaryadvance/addeditsalaryadvance');
		
    }
	function addsalaryadvanceloan()
	{
		
			$this->view->salaryadvanceid =0;
			$this->view->val = 0; 
			$this->view->render('profile/salaryadvanceloan/addeditsalaryadvance');
		
    }
	function editsalaryadvance($id)
    {		
		if(isset($id))
		{
			$this->view->salaryadvanceid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('profile/salaryadvance/addeditsalaryadvance');
		}else{
			header('location: ' . URL . 'profile/salaryadvance/salaryadvance');
		}
    }function editsalaryadvanceloan($id)
    {		
		if(isset($id))
		{
			$this->view->salaryadvanceid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('profile/salaryadvanceloan/addeditsalaryadvance');
		}else{
			header('location: ' . URL . 'profile/salaryadvance/salaryadvance');
		}
    }
	
	function createsalaryadvance()
	{
		try{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_SESSION['ubihrm_user_id'];
			$arr[3] = $_POST['advanceamount'];
			$arr[4] = $_POST['installmentamt'];
			$arr[5] = $_POST['approvedby'];	
			$arr[6] = $_POST['remarks'];	
			$arr[7] = $_POST['applymonth'];		
			$arr[8] = $_POST['applysts'];			
			$salaryadvance = $this->loadModel('Salaryadvance');
			$salaryadvancearray = $salaryadvance->Create($arr);
			echo json_encode($salaryadvancearray);		
		}catch(Exception $e){ echo $e->getMessage();}
	}
	function createsalaryadvanceloan()
	{
		try{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_SESSION['ubihrm_user_id'];
			$arr[3] = $_POST['advanceamount'];
			$arr[4] = $_POST['installmentamt'];
			$arr[5] = $_POST['approvedby'];	
			$arr[6] = $_POST['remarks'];	
			$arr[7] = $_POST['applymonth'];		
			$arr[8] = $_POST['applysts'];			
			$salaryadvance = $this->loadModel('Salaryadvanceloan');
			$salaryadvancearray = $salaryadvance->Create($arr);
			echo json_encode($salaryadvancearray);		
		}catch(Exception $e){ echo $e->getMessage();}
	}
	
	function updatedesalaryadvance()
	{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_SESSION['ubihrm_user_id'];
			$arr[3] = $_POST['advanceamount'];
			$arr[4] = $_POST['installmentamt'];
			$arr[5] = $_POST['approvedby'];
			$arr[6] = $_POST['remarks'];
			$arr[7] = $_POST['salaryadvanceid'];
			$arr[8] = $_POST['applymonth'];	
			$arr[9] = $_POST['applysts'];
			$salaryhead = $this->loadModel('Salaryadvance');
			$salaryheadarray = $salaryhead->Update($arr);
			echo json_encode($salaryheadarray);	
	}
	function updatedesalaryadvanceloan()
	{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_SESSION['ubihrm_user_id'];
			$arr[3] = $_POST['advanceamount'];
			$arr[4] = $_POST['installmentamt'];
			$arr[5] = $_POST['approvedby'];
			$arr[6] = $_POST['remarks'];
			$arr[7] = $_POST['salaryadvanceid'];
			$arr[8] = $_POST['applymonth'];	
			$arr[9] = $_POST['applysts'];
			$salaryhead = $this->loadModel('Salaryadvanceloan');
			$salaryheadarray = $salaryhead->Update($arr);
			echo json_encode($salaryheadarray);	
	}
	
	function deletesalaryadvance($did)
	{
		
		if(isset($did) )
		{
			$dept = $this->loadModel('Salaryadvance');
			$deptarray = $dept->Delete($did);
		}	
		header('location: ' . URL . 'profile/salaryadvance/salaryadvance');
	}
	function deletesalaryadvanceloan($did)
	{
		
		if(isset($did) )
		{
			$dept = $this->loadModel('Salaryadvanceloan');
			$deptarray = $dept->Delete($did);
		}	
		header('location: ' . URL . 'profile/salaryadvanceloan/salaryadvance');
	}
	
	
	 /**
     * Functions for perfom operation on notification table
     * delete function from notification list
	 * @returning json array of data as result
     */
	 
	function getDocumentRequestData()
	{    
		$employeeleave = $this->loadModel('Profile');
		$employeeleavearray = $employeeleave->getDocumentRequestTableData();
		echo json_encode($employeeleavearray);
	}
	
	function adddocumentrequest()
	{
		
			$this->view->documentrequestid =0;
			$this->view->val = 0; 
			$this->view->render('profile/documentrequest/addeditdocumentrequest');
		
    }
	function editdocumentrequest($id)
    {		
		if(isset($id))
		{
			$this->view->documentrequestid =Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('profile/documentrequest/addeditdocumentrequest');
		}else{
			header('location: ' . URL . 'profile/documentrequest');
		}
    }
	function createdocumentrequest()
	{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['releasefrom'];
			$arr[3] = $_POST['releaseto'];
			$arr[4] = $_POST['reason'];	
			$arr[5] = $_POST['requestdocid'];	
			$arr[6] = $_SESSION['ubihrm_user_id'];
			$arr[7] = " ";			
			$documentrequest = $this->loadModel('Documentrequest');
			$documentrequestarray = $documentrequest->Create($arr);
			echo json_encode($documentrequestarray);		
	}
	
	function updatededocumentrequest()
	{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['releasefrom'];
			$arr[3] = $_POST['releaseto'];
			$arr[4] = $_POST['reason'];	
			$arr[5] = $_POST['documentrequestid'];
			$arr[6] = $_POST['requestdocid'];	
			$arr[7] = $_POST['appsts'];
			$salaryhead = $this->loadModel('Documentrequest');
			$salaryheadarray = $salaryhead->Update($arr);
			echo json_encode($salaryheadarray);	
	}
	
	function getdocumentlist()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$salaryhead = $this->loadModel('Documentrequest');
		$salaryheadarray = $salaryhead->getEmployeeDocument($arr);
		echo json_encode($salaryheadarray);	
	}
	
	function getadocumentrequest()
	{
		
		$id = $_POST['documentrequestid'];
		$salaryhead = $this->loadModel('Documentrequest');
		$salaryheadarray = $salaryhead->getDetail($id);
		echo json_encode($salaryheadarray);	
	}
	
	function deletedocumentrequest($did)
	{
		
		if(isset($did) )
		{
			$dept = $this->loadModel('Documentrequest');
			$deptarray = $dept->Delete($did);
		}	
		header('location: ' . URL . 'profile/documentrequest');
	}
	function officialcommunication()
    {
		$this->view->render('profile/officialcommunication/index');
	}
	function viewofficialcommunication($id,$val)
    {
		
		if(isset($id) && isset($val))
		{
			$this->view->officialcommunicationid = $id; 
			$this->view->val = $val; 
			$this->view->render('profile/officialcommunication/addeditofficialcommunication');
		}else{
			header('location: ' . URL . 'profile/officialcommunication');
		}
		
    }
	function getempofficialcommunication()
	{
		
		$gid = $_POST['officialcommunicationid'];
		$officialcommunication = $this->loadModel('OfficialCommunication');
		$officialcommunicationarray = $officialcommunication->getLetter($gid);
		echo json_encode($officialcommunicationarray);		
	
		
	}
	
	function getOfficialCommunicationData()
	{
		
		$officialcommunication = $this->loadModel('Profile');
		$officialcommunicationarray = $officialcommunication->getOfficialCommunicationTable();
		echo json_encode($officialcommunicationarray);
	}
	//////////Continuous Feedback Here //////////
	function getemployeehierarchy()
	{
		try{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
		
			$role = $this->loadModel('Employee');
			$rolearray = $role->getAllHierarchyEmployee1($arr);
			echo json_encode($rolearray);	
		}catch(Exception $e){}
	}
	function feedback()
    {
        $this->view->render('profile/feedback/continuousfeedback');
	}
	function createfeedback()
	{try{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$arr[2] = $_POST['emp_subs'];
			$arr[3] = $_POST['catid'];
			$arr[4] = $_POST['rating'];
			$arr[5] = $_POST['msg'];
			
			$dept = $this->loadModel('Feedback');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);
		
		
	}catch(Exception $e){}
	}
	function getsendmsg()
	{
		try{
			$dept = $this->loadModel('Feedback');
			$deptarray = $dept->getsendmsg();
			echo json_encode($deptarray);
		}catch(Exception $e){}
	}
	function getreceivemsg()
	{
		try{
			$dept = $this->loadModel('Feedback');
			$deptarray = $dept->getreceivemsg();
			echo json_encode($deptarray);
		}catch(Exception $e){}
	}
	
	function getfeedbacktemplate()
	{
		$claimhead = $this->loadModel('Template');
		$claimheadarray = $claimhead->getFeedbackTemplate();
		echo json_encode($claimheadarray);	
				
	}
	
	function getexternalfeedback()
	{
		$claimhead = $this->loadModel('Feedback');
		$claimheadarray = $claimhead->getexternalfeedback();
		echo json_encode($claimheadarray);	
				
	}
	function getexternalfeedbackDetails($fid)
	{try{
		$this->view->fid = Utils::decode5t($fid);
		$this->view->appSts =3;
        $this->view->render('profile/feedback/externalfeedbackdetails');
	}catch(Exception $e){}		
	}
	function sendfeedbackrequest()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$arr[2] = $_POST['email'];
		$arr[3] = $_POST['name'];
		$arr[4] = $_POST['desig'];
		$arr[5] = $_POST['company'];
		$arr[6] = $_POST['feedbacksubject'];
		$arr[7] = $_POST['feedbackmsg'];
		$arr[8] = $_POST['datefrom'];
		$arr[9] = $_POST['dateto'];
		$arr[10] = $_POST['skills'];
		
		$claimhead = $this->loadModel('Feedback');
		$claimheadarray = $claimhead->sendFeedback($arr);
		echo json_encode($claimheadarray);	
				
	}
	
	
		/** 
	 ///////////////////////////// APPRAISAL CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/

	function myappraisal()
    {
        $this->view->render('profile/myappraisal/index');
	}
	/** 
	 ///////////////////////////// ASSESSMENT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	 
	 
	function assessment()
    {
        $this->view->render('profile/employeeassessment/index');
	}
	function goals()
    {
		$this->view->employeeid =$_SESSION['ubihrm_user_id'];
		$this->view->val = 0;
        $this->view->render('profile/employeeassessment/goals');
	}
	function getGoalsData()
	{
		$objective = $this->loadModel('Goals');
		$objectivearray = $objective->getAllEmployeeGoals();
		echo json_encode($objectivearray);
	}
	function getEmpPerformancedubai()
	{
		$objective = $this->loadModel('Assessmentdubai');	
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2]=  $objective->getassessmentId();
		$objectivearray = $objective->getassessmentDetail($arr);
		echo json_encode($objectivearray);	
	}
	function getEmpSkillgap()
	{
		$objective = $this->loadModel('Skillgapassessment');	
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2]= $objective->getassessmentId();
		try{
		
		$objectivearray = $objective->getassessmentDetail($arr);
		echo json_encode($objectivearray);			
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	function viewassessment($empid,$val)
    {	
		if( isset($empid)  && isset($val)){
			$this->view->employeeid =$empid;
			$this->view->val = $val; 
			$this->view->render('profile/employeeassessment/addassessment');
		}else{
			header('location: ' . URL . 'profile/assessment');
		}
    }
	function viewassessmentkpi($empid,$val)
    {	
		if( isset($empid)  && isset($val)){
			$this->view->employeeid =$empid;
			$this->view->val = $val; 
			$this->view->render('profile/employeeassessmentkpi/addassessment');
		}else{
			header('location: ' . URL . 'profile/assessmentkpi');
		}
    }
	//start fetch dubai self performance//
	function getempassessmentold()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['assessmentid'];
			$objective = $this->loadModel('Assessmentdubai');
			$objectivearray = $objective->getassessmentDetail($arr);
			echo json_encode($objectivearray);			
		}
		catch(Exception $e)
		{
			
		}
	}
	//end fetch dubai self performance//
	function getempassessment()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['assessmentid'];
			try{
			$objective = $this->loadModel('Assessment');
			$objectivearray = $objective->getassessmentDetail($arr);
			echo json_encode($objectivearray);			
	}catch(Exception $e){
			echo $e->getMessage();
			}
	}
	//start create dubai self performance//
	function createassessmentold()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['assessmenttype'];
			$arr[6] = $_POST['achievements'];
			$arr[7] = $_POST['issues'];
			$arr[8] = $_POST['assessmentid'];
			$arr[9] = $_POST['potentials'];
			$arr[10] = "";
			$arr[11] = "";
			$objective = $this->loadModel('Assessmentdubai');
			$objectivearray = $objective->Create($arr);
			echo json_encode($objectivearray);		
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	//end create dubai self performance//
	
	function createassessment()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['assessmenttype'];
			$arr[6] = $_POST['totalmarks'];
			$arr[7] = $_POST['totalamt'];
			$arr[8] = $_POST['assessmentid'];
			$arr[9] = $_POST['rating'];
			$arr[10] = $_POST['result'];
			$arr[11] = $_POST['desc'];
			$arr[12] = $_POST['improvements'];
			
			$objective = $this->loadModel('Assessment');
			$objectivearray = $objective->Create($arr);
			echo json_encode($objectivearray);	
						
		
	}
	
	function getAssessmentData()
	{
		
		$objective = $this->loadModel('Profile');
		$objectivearray = $objective->getAssessmentTable();
		echo json_encode($objectivearray);
	}
	
	
	/** 
	 ///////////////////////////// ASSESSMENT KEY PERFORMACE ATTRIBUTE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	function assessmentkpi()
    {
        $this->view->render('profile/employeeassessmentkpi/index');
	}
	
	
	function getempassessmentkpi()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['assessmentid'];
			$objective = $this->loadModel('Assessment');
			$objectivearray = $objective->getassessmentDetail($arr);
			echo json_encode($objectivearray);			
	
		
	}
	
	
  
	
	function createassessmentkpi()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['assessmenttype'];
			$arr[6] = $_POST['totalmarks'];
			$arr[7] = $_POST['totalamt'];
			$arr[8] = $_POST['assessmentid'];
			$arr[9] = $_POST['rating'];
			$arr[10] = $_POST['result'];
			$arr[11] = $_POST['desc'];
			
			$objective = $this->loadModel('Assessment');
			$objectivearray = $objective->Create($arr);
			echo json_encode($objectivearray);	
		}
		catch(Exception $e)
		{
			
		}		
		
	}
	function getAssessmentkpiData()
	{
		
		$objective = $this->loadModel('Profile');
		$objectivearray = $objective->getAssessmentkpiTable();
		echo json_encode($objectivearray);
	}
	
	function getSkillGapData()
	{
		try{
		$objective = $this->loadModel('Profile');
		$objectivearray = $objective->getSkillgapTable();
		echo json_encode($objectivearray);
		}catch(Exception $e){}
	}
	function viewskillgapassessment($aid,$val)
    {	
		if( isset($val)  && isset($aid)){
			$this->view->assessmentid =$aid;
			$this->view->val = $val; 
			$this->view->render('profile/skillgapassessment/addskillgapassessment');
		}else{
			header('location: ' . URL . 'profile/myappraisal');
		}
    }
	
	function getskillgapassessment()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['assessmentid'];
			try{
			$objective = $this->loadModel('Skillgapassessment');
			$objectivearray = $objective->getassessmentDetail($arr);
			echo json_encode($objectivearray);			
			}catch(Exception $e){
				echo $e->getMessage();
			}
	
	}
	
	////////////////////////////////////////////////////////////////////////////////////////
	
	function getResignationreasons()
	{
		$employee = $this->loadModel('Profile');
		$emparray = $employee->getEmployeeResignationreason();
		echo json_encode($emparray);
	}
	function getnoticeperiod()
	{
		$employee = $this->loadModel('Profile');
		$emparray = $employee->getNoticePeriod();
		echo json_encode($emparray);
	}
	function getemployeeresignation()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$employee = $this->loadModel('Profile');
		$emparray = $employee->getEmployeeResignation($arr);
		echo json_encode($emparray);
	}
	
	function employeeresignation()
	{	
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2]=$_POST['subject'];
		$arr[3]=$_POST['msg'];
		$arr[4]=$_POST['noticeperiod'];
		
		
		$employee = $this->loadModel('Profile');
		$employeearray = $employee->EmployeeResignation($arr);
		echo json_encode($employeearray);
	}
	function changeresignsts($id)
    {		
		if(isset($id))
		{
			$dept = $this->loadModel('Resignation');
			$deptarray = $dept->UpdateResignationSts($id);
			echo json_encode($deptarray);	
			
		}else{
			header('location: ' . URL . 'profile/resignation');
		}
		
    }
	///////////////certificate request controller////////////////////////
	
	/**
     * Functions for perfom operation on notification table
     * delete function from notification list
	 * @returning json array of data as result
     */
	function addcertificaterequest()
	{
		
			$this->view->certificaterequestid =0;
			$this->view->val = 0; 
			$this->view->render('profile/certificaterequest/addeditcertificaterequest');
		
    }
	function editcertificaterequest($id)
    {		
		if(isset($id))
		{
			$this->view->certificaterequestid =Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('profile/certificaterequest/addeditcertificaterequest');
		}else{
			header('location: ' . URL . 'profile/certificaterequest');
		}
    }
	function createcertificaterequest()
	{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['reason'];	
			$arr[3] = $_POST['requestdocid'];	
			$arr[4] = $_SESSION['ubihrm_user_id'];
			$arr[5] = $_POST['address'];				
			$certificaterequest = $this->loadModel('Certificaterequest');
			$certificaterequestarray = $certificaterequest->Create($arr);
			echo json_encode($certificaterequestarray);		
	}
	
	function updatedecertificaterequest()
	{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['reason'];	
			$arr[6] = $_POST['address'];	
			$arr[3] = $_POST['requestdocid'];	
			$arr[4] = $_SESSION['ubihrm_user_id'];
			$arr[5] = $_POST['certificaterequestid'];
			
			$salaryhead = $this->loadModel('Certificaterequest');
			$salaryheadarray = $salaryhead->Update($arr);
			echo json_encode($salaryheadarray);	
	}
	
	function getcertificatelist()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$salaryhead = $this->loadModel('Certificaterequest');
		$salaryheadarray = $salaryhead->getEmployeeDocument($arr);
		echo json_encode($salaryheadarray);	
	}
	
	function getacertificaterequest()
	{
		
		$id = $_POST['certificaterequestid'];
		$salaryhead = $this->loadModel('Certificaterequest');
		$salaryheadarray = $salaryhead->getDetail($id);
		echo json_encode($salaryheadarray);	
	}
	
	function deletecertificaterequest($did)
	{
		
		if(isset($did) )
		{
			$dept = $this->loadModel('Certificaterequest');
			$deptarray = $dept->Delete($did);
		}	
		header('location: ' . URL . 'profile/certificaterequest');
	}
	function getCertificateRequestTable()
	{    
		$employeeleave = $this->loadModel('Profile');
		$employeeleavearray = $employeeleave->getCertificateRequestTable();
		echo json_encode($employeeleavearray);
	}
	function timesheet()
    {
        $this->view->render('profile/timesheet/index');
    }
	function unassigntimesheet()
    {
        $this->view->render('profile/timesheet/addtimesheet');
    }
	function tasks($type)
    {try{
		$this->view->type =$type;
			$this->view->render('profile/tasks/index');
	}catch(Exception $e){
		
	}
    }
	
	function viewtask($id,$val,$type=0)
    {try{
		
		if(isset($id) && isset($val))
		{
			$this->view->taskid = Utils::decode5t($id); 
			$this->view->val = $val; 
			$this->view->type = $type; 
			$this->view->render('profile/tasks/addedittask');
		}else{
			header('location: ' . URL . 'employee/skill');
		}
	}catch(Exception $e){}
    }
	function Addtask($type)
    { try{
		$this->view->taskid =0;
			$this->view->type = $type; 
			$this->view->val = 0; 
			$this->view->render('profile/tasks/addedittask');
			
		}catch(Exception $e){	}
    }
	function createtask()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['projectid'];
			$arr[3] = $_POST['milestoneid'];
			$arr[4] = $_SESSION['ubihrm_user_id'];
			$arr[5] = $_POST['desc'];
			$arr[6] = $_POST['title'];
			$arr[7] = $_POST['fromdate'];
			$arr[8] = $_POST['todate'];
			$arr[9] = $_POST['priority'];
			$arr[10] = $_POST['durationhours'];
			$arr[11] = $_POST['durationminutes'];
		
			$Tasks = $this->loadModel('Tasks');
			$Tasksarray = $Tasks->CreateProfileTask($arr);
			echo json_encode($Tasksarray);
		}catch(Exception $e){}
	}
	
	function getTimesheetData()
	{ 
		try{
		$employeeleave = $this->loadModel('Profile');
		$employeeleavearray = $employeeleave->getTimesheetData();
		echo json_encode($employeeleavearray);
		}catch(Exception $e){}
	}
	
	function getprofiletaskdatatable($type)
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		
		
		$Tasks = $this->loadModel('Tasks');
		$Tasksarray = $Tasks->getProfileTaskDataTable($arr);
		echo json_encode($Tasksarray);	
		}catch(Exception $e){}
	}
	
	function addtimesheet()
	{
		
			$this->view->timesheetid =0;
			$this->view->val = 0; 
			$this->view->render('profile/timesheet/addedittimesheet');
		
    }
	function edittimesheet($id)
    {		
		if(isset($id))
		{
			$this->view->timesheetid =Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('profile/timesheet/addedittimesheet');
		}else{
			header('location: ' . URL . 'profile/timesheet');
		}
    }
	function createtimesheet()
	{
	
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['fromdate'];
			$arr[3] = $_POST['todate'];
			$arr[4] = $_POST['purpose'];	
			$arr[5] = $_POST['timesheetamt'];	
			$arr[6] = $_SESSION['ubihrm_user_id'];
			$arr[7] = 0;
					
			$timesheet = $this->loadModel('Claim');
			$timesheetarray = $timesheet->Create($arr);
			echo json_encode($timesheetarray);	
			
	}
	
	function updatedetimesheet()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['fromdate'];
			$arr[3] = $_POST['todate'];
			$arr[4] = $_POST['purpose'];	
			$arr[5] = $_POST['timesheetamt'];	
			$arr[6] = $_SESSION['ubihrm_user_id'];
			$arr[7] = $_POST['timesheetid'];
			$salaryhead = $this->loadModel('Claim');
			$salaryheadarray = $salaryhead->Update($arr);
			echo json_encode($salaryheadarray);	
	}
	
	function getatimesheet()
	{
		
		$id = $_POST['timesheetid'];
		$salaryhead = $this->loadModel('Claim');
		$salaryheadarray = $salaryhead->getDetail($id);
		echo json_encode($salaryheadarray);	
	}
	
	function deletetimesheet($did)
	{
		try{
		if(isset($did) )
		{
			$dept = $this->loadModel('profile');
			$deptarray = $dept->DeleteTimeSheet($did);
			echo json_encode($deptarray);
		}	
	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	function getallproject()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$timesheet = $this->loadModel('Projects');
		$timesheetarray = $timesheet->getUserprojects($arr);
		echo json_encode($timesheetarray);	
	}
	function getallproject1()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$timesheet = $this->loadModel('Projects');
			$timesheetarray = $timesheet->getAllProject($arr);
			echo json_encode($timesheetarray);	
			
		
	}
	function getalltask()
	{
		$arr=array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$timesheet = $this->loadModel('Tasks');
		$timesheetarray = $timesheet->getAll($arr);
		echo json_encode($timesheetarray);	
		
	}
	
	function gettaskbyproject()
	{
		$arr=array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['projectid'];
		
		$timesheet = $this->loadModel('Tasks');
		$timesheetarray = $timesheet->gettaskbyproject($arr);
		echo json_encode($timesheetarray);	
		
	}
	
	function project()
    {
        $this->view->render('profile/project/index');
    }
	
	function getProjectData()
	{ 
		try{
			$employeeleave = $this->loadModel('Profile');
			$employeeleavearray = $employeeleave->getProjectData();
			echo json_encode($employeeleavearray);
		}catch(Exception $e){}
	}
	
	function addproject()
	{
		
			$this->view->projectid =0;
			$this->view->val = 0; 
			$this->view->render('profile/project/addeditproject');
		
    }
	function editproject($id)
    {		
		if(isset($id))
		{
			$this->view->projectid =Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('profile/project/addeditproject');
		}else{
			header('location: ' . URL . 'profile/project');
		}
    }
	function ViewTimesheet($id, $val)
    {		
		if(isset($id) && isset($val))
		{
			$this->view->projectid =Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = $val; 
			$this->view->render('profile/project/addedittimesheet');
		}else{
			header('location: ' . URL . 'profile/project');
		}
    }
	function viewproject($id,$val)
    {		

		if(isset($id) && isset($val))
		{
			$this->view->projectid =Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val =$val; 
			$this->view->render('profile/project/addeditproject');
		}else{
			header('location: ' . URL . 'profile/project');
		}
    }
	 function getprojectdetail()
	{
		try{
		
			$gid = $_POST['projectid'];
			$Projects = $this->loadModel('Projects');
			$Projectsarray = $Projects->getDetail($gid);
			echo json_encode($Projectsarray);			
		
	}catch(Exception $e){}
	}
	function gettimesheetdetail()
	{
		try{
		
			$gid = $_POST['projectid'];
			$Projects = $this->loadModel('Projects');
			$Projectsarray = $Projects->gettimesheetDetail($gid);
			echo json_encode($Projectsarray);			
		
	}catch(Exception $e){}
	}
	////////////////Task timesheet///////////////////
	function getAlltimesheet($type="")
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $type;
			$arr[3]= $_POST['date'];
			$timesheet = $this->loadModel('profile');
			$timesheetarray = $timesheet->getAlltask($arr);
		echo json_encode($timesheetarray);
		}catch(Exception $e){}
	}
	////////////////Unassign Task timesheet///////////////////
	function getunassigntimesheet()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$timesheet = $this->loadModel('profile');
			$timesheetarray = $timesheet->getUnassigntask($arr);
			echo json_encode($timesheetarray);
		}catch(Exception $e){}
	}
	
	function updatetimesheet1()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('profile');
			$deptarray = $dept->UpdateTimesheet($arr);
			echo json_encode($deptarray);		
		
	}
	function addselftimesheet()
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$dept = $this->loadModel('profile');
		$deptarray = $dept->AddSelfTimesheet($arr);
		echo json_encode($deptarray);		
		}catch(Exception $e){}
		
	}
	function getEmpLimit()
	{
		try{
		$dept = $this->loadModel('profile');
		$deptarray = $dept->getEmpLimit();
		echo json_encode($deptarray);		
		}catch(Exception $e){}
	}
	/*Medical Insurance*/
	function medicalclaim()
    {
        $this->view->render('profile/medicalclaim/index');
    }
	function addmedicalclaim()
    {
		$this->view->claimid = 0;
        $this->view->render('profile/medicalclaim/addmedicalclaim');
    }
	function editmedicalclaim($id)
    {
		$this->view->claimid = Utils::decode5t($id);
        $this->view->render('profile/medicalclaim/addmedicalclaim');
    }
	function approvemedclaim($id)
    {
		$this->view->claimid = Utils::decode5t($id);
        $this->view->render('profile/requestmedinsurance');
    }
	
	function financemedclaim()
    {
        $this->view->render('profile/financemedinsurance');
    }
	
	function getselfdata()
	{
		try{
		$eid = $_SESSION['ubihrm_user_id'];
		$employee = $this->loadModel('Profile');
		$employeearray = $employee->getselfdata($eid);
		echo json_encode($employeearray);
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	function getFamilyMembers($eid)
	{
		try{
		//$eid = $_SESSION['ubihrm_user_id'];
		$employee = $this->loadModel('Profile');
		$employeearray = $employee->getFamilyMembers($eid);
		echo json_encode($employeearray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	function getFamilyDetails($fid)
	{
		try{
		$employee = $this->loadModel('Profile');
		$employeearray = $employee->getFamilyDetails($fid);
		echo json_encode($employeearray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	
	function createMedicalClaim()
	{
		try{
		$employee = $this->loadModel('Profile');
		$employeearray = $employee->createMedicalClaim();
		echo json_encode($employeearray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	
	function updateMedicalClaim()
	{
		try{
		$employee = $this->loadModel('Profile');
		$employeearray = $employee->updateMedicalClaim();
		echo json_encode($employeearray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	
	function getMedicalClaimTable()
	{
		try{
		$employee = $this->loadModel('Profile');
		$employeearray = $employee->getMedicalClaimTable();
		echo json_encode($employeearray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	function getmedicalclaimdata($id)
	{
		try{
		$employee = $this->loadModel('Profile');
		$employeearray = $employee->getmedicalclaimdata($id);
		echo json_encode($employeearray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	
	function uploadMedicalDocument()
	{
		try{
		$employee = $this->loadModel('Profile');
		$employeearray = $employee->uploadMedicalDocument();
		echo json_encode($employeearray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	/////////////get new Compleave data////////////////
	function getCompLeaveData()
	{    
		try{
			$employeeleave = $this->loadModel('Profile');
			$employeeleavearray = $employeeleave->getCompLeaveTable();
			echo json_encode($employeeleavearray);
		}catch(Exception $e)
		{
			
		}	
	}
	//////////////////////////////////////////view new leave data////////////////////////
	function viewCompLeave($id,$val)
    {		
		if(isset($id) && isset($val))
		{
			$this->view->leaveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = $val; 
			$this->view->render('profile/leave/addeditcompoffleave');
		}else{
			header('location: ' . URL . 'profile/leaves');
		}
    }
	function addCompleave()
	{
			$this->view->val = 0; 
			$this->view->leaveid  =0;
			$this->view->render('profile/leave/addeditcompoffleave');
		
    }
	///////////////////edit new leave of employee///////////////////////////////////////
	function editcompoffleave($id)
    {		
		if(isset($id))
		{
			$this->view->leaveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('profile/leave/addeditcompoffleave');
		}else{
			header('location: ' . URL . 'profile/leaves');
		}
    }
	function getLeaveCalendar($type="")
	{   try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];
		$employeeleave = $this->loadModel('Profile');
		$employeeleavearray = $employeeleave->getLeaveCalendar($arr);
		echo json_encode($employeeleavearray);
		}
		catch(Exception $ex){}
    }
	///////////////////////////////////////change comp leave status///////////////////////////////////////////
	function changecompleavests($id,$days,$val)
    {		
		if(isset($id))
		{
			$dept = $this->loadModel('Profile');
			$deptarray = $dept->UpdatecompLeaveSts($id,$days,$val);
			echo json_encode($deptarray);	
			
		}else{
			header('location: ' . URL . 'profile/leaves');
		}
		
    }
	///////////////////// ///////////get employee new leave///////////////////////////////////
	
	function getemployeeCompleave()
	{		
			$gid = $_POST['employeeleaveid'];
			$employeeleave = $this->loadModel('Employeeleave');
			$employeeleavearray = $employeeleave->getDetailCompoff($gid);
			echo json_encode($employeeleavearray);	
	}
	////////////to get compoff data////////
	function getCompleaveType($val)
	{
		try{
			$compleavetype = $this->loadModel('Profile');
			$compleavearray = $compleavetype->getCompleaveType($val);
			echo json_encode($compleavearray);
		}catch(Exception $e){}
		
	}
	function getweekoff()
	{
		try{
		$id =$_SESSION['ubihrm_user_id'];
		$employeeleave = $this->loadModel('Profile');
		$employeeleavearray = $employeeleave->getweekoff($id );
		echo json_encode($employeeleavearray);
		}catch(Exception $e)
		{
		}
		
	}
	function createCompleave()
	{
		$dept = $this->loadModel('Profile');
		$deptarray = $dept->CreateCompLeave();
		echo json_encode($deptarray);	
	}
	
	//////////////////// for update compoff leave////////////
	function updatecompleave()
	{try{
		
			$dept = $this->loadModel('Profile');
			$deptarray = $dept->UpdatecompLeave();
	echo json_encode($deptarray);	}
	catch(Exception $e){}
	}
	
///////Fetching all substitute emp means all seniors and juniors of logined person/////
	function getleavesubstituteemp()
	{
			try{
				
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$leavetype = $this->loadModel('Employee');
			$leavetypearray = $leavetype->getleavesubstituteemp($arr);
			echo json_encode($leavetypearray);	
			}catch(Exception $e){
				
			}
	}
	
	function getleavetypehistory()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = date('Y-m-d');
			$arr[3] = $_POST['leavetypename'];
			$arr[4] = $_POST['empleaveid'];
			
				$leavetype = $this->loadModel('profile');
				$leavetypearray = $leavetype->getselectedempleave($arr);
				echo json_encode($leavetypearray);	
			
		}catch(Exception $e) {
			echo  'Message: ' .$e->getMessage();
		}	
	}
	
	
	
	
}
