<?php

/**
 * Class Timesheet
 * The index controller
 */
class Milestone extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
	function __construct()
	{
		parent::__construct();
		Auth::handleLogin();
	}

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
	public function index()
	{
		try{
			if($this->CheckPermission(187,1))
			{
				$this->view->render('timesheet/index');
			}
			else
			{
				header('location: ' . URL . 'profile');
			}
		}catch(Exception $e)
		{}
	}
	/////milestonedata
	function getMilestonData($type)
	{
		try
		{
		$editper = $this->CheckPermission(186, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(186, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////		
		$timesheet = $this->loadModel('Milestone');
		$milestonearray= $timesheet->getDataMTable($editper, $deleteper,$type);
		echo json_encode($milestonearray);
		} catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	///addmilestone
	function addmilestone($projectid=0)
    {
		$addper = $this->CheckPermission(186, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->milestoneid =0;
			$this->view->projectid = $projectid;
			$this->view->val = 0; 
			$this->view->render('timesheet/milestone/addmilestone');
		}else{
			header('location: ' . URL . 'timesheet');
		}
    }
	function editmilestone($id,$projectid)
    {
		$editper = $this->CheckPermission(185, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->milestoneid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->projectid = $projectid;
			$this->view->render('timesheet/milestone/addmilestone');
		}else{
			header('location: ' . URL . 'timesheet');
		}
    }
	
	////milestonelist
	public function milestonelist($type)
	{
		
		
		$viewper = $this->CheckPermission(186, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(186, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->type =$type;
			$this->view->render('timesheet/milestone/index');
		}else{
			header('location: ' . URL . 'profile');
		}
		
	}
	
	function createmilestone() {
		try	{
		$addper = $this->CheckPermission(186, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			/* $arr[2] = $_POST['projectid'];			
			$arr[3] = $_POST['desc'];
			$arr[4] = $_POST['title'];	
			$arr[5] = $_POST['fromdate'];
			$arr[6] = $_POST['todate'];		 */
			$dept = $this->loadModel('milestone');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);
		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}
	}
	
	 /**
     * Functions for perfom operation on timesheet table
     * delete function from timesheet list
	 * @returning json array of data as result
     */
	 function getmilestonedetail()
	{
		try{
		$viewper = $this->CheckPermission(186, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['milestoneid'];
			$Projects = $this->loadModel('Milestone');
			$milestonearray = $Projects->getDetail($gid);
			echo json_encode($milestonearray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}
	}
	
	function getDefaultMilestone()
	{
		try{
		
			$viewper = $this->CheckPermission(186, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
			if($viewper){
			$addper = $this->CheckPermission(186, 4); ///////// CHECK FOR ADD MILESTONE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('timesheet/SettingMilestone/index');
		
		}else{
			header('location: ' . URL . 'profile');
		}
	}catch(Exception $e){}
	}
	
	//////// get DataTable of Default Milestone ///////////////
	
	
	function getDefaultMilestoneData()
	{
		try
		{
			$editper = $this->CheckPermission(186, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(186, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$timesheet = $this->loadModel('Milestone');
		$milestonearray= $timesheet->getDefaultMilestoneData($editper, $deleteper);
		echo json_encode($milestonearray);
		} 
			catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
			
		}
	}
	
	
	////////// end getting DataTable of Default Milestone ////////
	
	
	/////////////////// save dafault milestone data /////////////////////////
	
		function saveDefaultMilestone()
	{
		try
		{
		$addper = $this->CheckPermission(186, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['milestone'];			
			$arr[3] = $_POST['description'];
			
			$dept = $this->loadModel('milestone');
			$deptarray = $dept->saveDefaultMilestone($arr);
			echo json_encode($deptarray);
		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}
	}
	
	/////////////////// end saving default milestone data //////////////////
	
	////////////////// update default milestone ///////////////////////////////////
	 function updatedefaultmilestone()
	{
		$editper = $this->CheckPermission(186, 4);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['description'];
			$arr[3] = $_POST['name'];
			$arr[4] = $_POST['milestoneid'];
			$dept = $this->loadModel('Milestone');
			$deptarray = $dept->UpdateDefaultMilestone($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	///////////////// ending update default milestone
	
	
	
	//////////////////// fetching default milestone data for fetching //////////
	
		 function getdefaultmilestonebyid()
	{
		try{
		$viewper = $this->CheckPermission(186, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['milestoneid'];
			$Projects = $this->loadModel('Milestone');
			$milestonearray = $Projects->getdefaultmilestonebyid($gid);
			echo json_encode($milestonearray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}
	}
	
	//////////////////// end fetching default milestone data for fetching /////////////////
	
	
	//////////////////// fetching all default milestones //////////////////////////////////////////////
	
		function getalldefaultmilestone($projecttypeid)
	{
		try{
		$arr=array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $projecttypeid;
		$timesheet = $this->loadModel('Milestone');
		$timesheetarray = $timesheet->getAllDefaultMileStone($arr);
		echo json_encode($timesheetarray);	
		}catch(Exception $ex){
			
			
		}
		
	}
	
	//////////////////// end fetching default milestones ////////////////////////////////////////////////////
	
	/////////////////////////// getting all default milestones by project /////////////////////////
	
		 function getDefaultMilestoneByProject()
		{
		try{
		$viewper = $this->CheckPermission(186, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr=array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['projectid'];
			$Projects = $this->loadModel('Milestone');
			$milestonearray = $Projects->getDefaultMilestoneByProject($arr);
			echo json_encode($milestonearray);		
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}
	}
	
	////////////////////////////// ending getting all default milestones by project ////////////////////
	
	public function timesheetlist()
	{
		
		
		$viewper = $this->CheckPermission(187, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(187, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('timesheet/timesheetlist/index');
		}else{
			header('location: ' . URL . 'profile');
		}
		
	}
	public function timesheetshow()
	{
		$viewper = $this->CheckPermission(187, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(187, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('timesheet/timesheet/index');
		}else{
			header('location: ' . URL . 'profile');
		}
		
	}
	function addtimesheet()
    {
			
		$addper = $this->CheckPermission(187, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$sheet_model = $this->loadModel('Projects');
			$this->view->timesheetid =0;
			$this->view->sheetdata ="";
			$this->view->sheet = $sheet_model->getAll();
			$this->view->render('timesheet/timesheetlist/addtime');
		}else{
			header('location: ' . URL . 'timesheet');
		}
			
    }
	
	function edittimesheet($id)
    {
		$editper = $this->CheckPermission(187, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->timesheetid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('timesheet/timesheetlist/addtime');
		}else{
			header('location: ' . URL . 'timesheet');
		}
		
    }
	function viewtimesheet($id,$val)
    {
		
		if(isset($id) && isset($val))
		{
			$this->view->timesheetid = Utils::decode5t($id); 
			$this->view->val = $val; 
			$this->view->render('timesheet/timesheetlist/addtime');
		}else{
			header('location: ' . URL . 'timesheet');
		}
		
    }
	function getalltimesheet()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$timesheet = $this->loadModel('Timesheet');
			$timesheetarray = $timesheet->getAll($arr);
			echo json_encode($timesheetarray);	
			
		
	}
	
	function getatimesheet()
	{
		$viewper = $this->CheckPermission(187, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['timesheetid'];
			$timesheet = $this->loadModel('Timesheet');
			$timesheetarray = $timesheet->getDetail($gid);
			echo json_encode($timesheetarray);		
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on timesheet table
     * getall function fetching timesheet list
	 * @returning json array of data as result
     */
	public function savetimesheetdata()
	{
		$sheet_model = $this->loadModel('Timesheet');
        	$sheet = $sheet_model->create();
		$this->view->sheetdata ="";
		//$this->view->render('timesheet/index');
		header('location: ' . URL . 'timesheet/timesheetlist');
		//echo  json_encode($sheet);
	}
	public function editsavetimesheetdata()
	{
		$sheet_model = $this->loadModel('Timesheet');
        	$sheet = $sheet_model->editSave();
		//$this->view->render('timesheet/index');
		header('location: ' . URL . 'timesheet');
		//echo  json_encode($sheet);
	}
	 /**
     * Functions for perfom operation on timesheet table
     * delete function from timesheet list
	 * @returning json array of data as result
     */
	 
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletetimesheet($did)
	{
		$deleteper = $this->CheckPermission(187, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Timesheet');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'timesheet');
	}
	

	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getTimesheetData()
	{
		$editper = $this->CheckPermission(187, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(187, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$timesheet = $this->loadModel('Timesheet');
		$timesheetarray = $timesheet->getDataTable($editper, $deleteper);
		echo json_encode($timesheetarray);
	}
	////////////////////////////project controller///////////
	
	public function projectlist()
	{
		
		
		$viewper = $this->CheckPermission(185, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(185, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('timesheet/projects/index');
		}else{
			header('location: ' . URL . 'profile');
		}
		
	}
	

	function addproject()
    {
		
		$addper = $this->CheckPermission(185, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->projectid =0;
			$this->view->val = 0; 
			
			$this->view->render('timesheet/projects/newProject');
		}else{
			header('location: ' . URL . 'timesheet');
		}
			
    }
	
	
	function editproject($id)
    {
		$editper = $this->CheckPermission(185, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->projectid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('timesheet/projects/newProject');
		}else{
			header('location: ' . URL . 'timesheet');
		}
		
    }
	
	function viewproject($id,$val)
    {
		
		if(isset($id) && isset($val))
		{
			$this->view->timesheetid = Utils::decode5t($id); 
			$this->view->val = $val; 
			$this->view->render('timesheet/projects/addedittimesheet');
		}else{
			header('location: ' . URL . 'timesheet');
		}
		
    }
	
	function getallproject()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$timesheet = $this->loadModel('Projects');
			$timesheetarray = $timesheet->getAll($arr);
			echo json_encode($timesheetarray);	
	}
	
	function getAllRunningProject()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$timesheet = $this->loadModel('Projects');
			$timesheetarray = $timesheet->getAllRunningProject($arr);
			echo json_encode($timesheetarray);	
	}
	
	function getaproject()
	{
		$viewper = $this->CheckPermission(185, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['timesheetid'];
			$timesheet = $this->loadModel('Projects');
			$timesheetarray = $timesheet->getProjectDetail($gid);
			echo json_encode($timesheetarray);		
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on timesheet table
     * getall function fetching timesheet list
	 * @returning json array of data as result
     */
	function createproject()
	{try{
		$addper = $this->CheckPermission(185, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['ownerid'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['desc'];
			$arr[6] = $_POST['title'];
			$arr[7] = $_POST['assignempid'];
			$arr[8] = $_POST['projectstatus'];
			$dept = $this->loadModel('Projects');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);
		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}
	}
	
	 /**
     * Functions for perfom operation on timesheet table
     * delete function from timesheet list
	 * @returning json array of data as result
     */
	 function getprojectdetail()
	{
		try{
		$viewper = $this->CheckPermission(185, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['projectid'];
			$Projects = $this->loadModel('Projects');
			$Projectsarray = $Projects->getDetail($gid);
			echo json_encode($Projectsarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}
	}
	 function updateproject()
	{
		$editper = $this->CheckPermission(185, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['ownerid'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['desc'];
			$arr[6] = $_POST['title'];
			$arr[7] = $_POST['assignempid'];
			$arr[8] = $_POST['project_id'];
			$arr[9] = $_POST['projectstatus'];
			$dept = $this->loadModel('Projects');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	 function updatemilestone()
	{try{
		$editper = $this->CheckPermission(186, 4);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			/* $arr[2] = $_POST['projectid'];
			$arr[3] = $_POST['startdate'];
			$arr[4] = $_POST['enddate'];
			$arr[5] = $_POST['desc'];
			$arr[6] = $_POST['title']; */
			$arr[3] = $_POST['milestoneid'];
			$dept = $this->loadModel('Milestone');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){
		
	}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteproject($did)
	{
		$deleteper = $this->CheckPermission(185, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Projects');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'timesheet');
	}
	
	function deletemilestone($did)
	{
		$deleteper = $this->CheckPermission(186, 4); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Milestone');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'timesheet');
	}

	///////////////////////////////delete default milestone //////////////////////////////////////////////////////
	
	function deletedefaultmilestone($did)
	{
		$deleteper = $this->CheckPermission(186, 4); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Milestone');
			$deptarray = $dept->deletedefaultmilestone($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'timesheet');
	}

	
	
	//////////////////////////////// end deleting default milestone /////////////////////////////////////////////
	
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getProjectData()
	{
		$editper = $this->CheckPermission(185, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(185, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$timesheet = $this->loadModel('Projects');
		$timesheetarray = $timesheet->getDataTable($editper, $deleteper);
		echo json_encode($timesheetarray);
	}
	
	
	/* function getMilestonData()
	{
		try
		{
			$editper = $this->CheckPermission(186, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(186, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$timesheet = $this->loadModel('milestone');
		$milestonearray= $timesheet->getDataMTable($editper, $deleteper);
		echo json_encode($milestonearray);
		} 
			catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
			
		}
	}
	
	// *////
	
	////////////////////////////  REPORT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perfom operation on report table
     * getall function fetching report list
	 * @returning json array of data as result
     */
	
	function report()
    {
		$viewper = $this->CheckPermission(188, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(188, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('timesheet/reports/index');
		}else{
			header('location: ' . URL . 'timesheet/index');
		}
    }
	function addreport()
    {
		$addper = $this->CheckPermission(188, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->reportid =0;
			$this->view->val = 0; 
			$this->view->render('timesheet/reports/addeditreport');
		}else{
			header('location: ' . URL . 'timesheet/report');
		}
    }
	
	function editreport($id)
    {
		$editper = $this->CheckPermission(188, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->reportid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('timesheet/reports/addeditreport');
		}else{
			header('location: ' . URL . 'timesheet/report');
		}
		
    }
	
	function viewreport1($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->val = $val; 
			$this->view->render('timesheet/reports/addeditreport');
		}else{
			header('location: ' . URL . 'timesheet/report');
		}
		
    }
	function viewreport($id)
    {
		
		if(isset($id) )
		{
			$this->view->reportid = Utils::decode5t($id); 
			$this->view->render('timesheet/reports/viewreport');
		}else{
			header('location: ' . URL . 'timesheet/report');
		}
		
    }
	
	
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletereport($did)
	{
		$deleteper = $this->CheckPermission(188, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Report');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}	
		else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getReportData()
	{
		$editper = $this->CheckPermission(188, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(188, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$tabid=7;
		try{
		$report = $this->loadModel('Report');
		$reportarray = $report->getDataTable($editper, $deleteper,$tabid);
		echo json_encode($reportarray);
		}catch(Exception $e){}
	}
	
	function getReportData1($id)
	{
		$editper = $this->CheckPermission(188, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(188, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$report = $this->loadModel('Report');
		$reportarray = $report->createDataTable($editper, $deleteper,$id);
		echo json_encode($reportarray);
	}
	
	function createReportDataTable()
	{
		$editper = $this->CheckPermission(188, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(188, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$report = $this->loadModel('Report');
		$reportarray = $report->createDataTable($editper, $deleteper);
		echo json_encode($reportarray);
	}
	
	function getmodules()
	{
		$permission = $this->loadModel('Permission');
		$perarray = $permission->getModules();
		echo json_encode($perarray);	
	}
	
	
	
	
	function getcolumnvalues()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['tablename'];
			$arr[3] = $_POST['columnname'];
			$dept = $this->loadModel('Report');
			$deptarray = $dept->getAllColumnValue($arr);
			echo json_encode($deptarray);	
		
		
	}
	
	function getreportingmodule()
    {
		$tabid=$_POST['tabid'];
        $relation = $this->loadModel('Permission');
		$relationarr = $relation->getReportingModules($tabid);
		echo json_encode($relationarr);
    }
	
	function gettimesheetDashboard()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['fiscalid'];
		$arr[3] = $_POST['type'];
		$attendancetype = $this->loadModel('Dashboard');
		$attendancetypearray = $attendancetype->gettimesheetDashboard($arr);
		echo json_encode($attendancetypearray);
	}
	function getunassigntimesheet($type="")
	{
		try{
			$timesheet = $this->loadModel('timesheet');
			$timesheetarray = $timesheet->getunassigntimesheet($type);
		echo json_encode($timesheetarray);
		}catch(Exception $e){}
	}
}
