<?php
/**
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class Employee extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();
        // this controller should only be visible/usable by logged in users, so we put login-check here
        Auth::handleLogin();
    }
	
	
	function updateemployeecode()
	{
		try{
			$skill = $this->loadModel('Employee');
			$skillarray = $skill->employeecode();
			}catch(Exception $e){
				echo $e->getMessage();
			}
	}
	
	function sendonboardlink()
	{
		try{
			$arr=array();
			$arr[0]=$_POST['mailto'];
			$arr[1]=$_POST['msg'];
			$arr[2]=$_POST['subject'];
			$skill = $this->loadModel('Employee');
			$skillarray = $skill->SendOnboardlink($arr);
			echo json_encode($skillarray);
			}catch(Exception $e){
				echo $e->getMessage();
			}
	}
    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    function index()
    {
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		if($sts==1 || $hrsts==1){
			$this->view->render('employee/index');
		}else{
			$this->view->render('employee/index');
		}
    }
	
	function continuousfeedback()
    {
        $this->view->render('employee/continuousfeedback/index');
    }
	
	function employmenthistory()
    {
        $this->view->render('employee/employmenthistory/index');
    }
	
	function getallfeedback()
	{
		try{
			
			$dept = $this->loadModel('Feedback');
			$deptarray = $dept->getallfeedback();
			echo json_encode($deptarray);
		}catch(Exception $e){}
	}
	
	
	
	function getexternalfeedback()
	{
		$claimhead = $this->loadModel('Feedback');
		$claimheadarray = $claimhead->getexternalfeedback();
		echo json_encode($claimheadarray);	
				
	}
	
	function getallexternalfeedback()
	{
		$claimhead = $this->loadModel('Feedback');
		$claimheadarray = $claimhead->getallexternalfeedback();
		echo json_encode($claimheadarray);	
				
	}
	function sendfeedbackrequest()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$arr[2] = $_POST['email'];
		$arr[3] = $_POST['name'];
		$arr[4] = $_POST['desig'];
		$arr[5] = $_POST['company'];
		$arr[6] = $_POST['feedbacksubject'];
		$arr[7] = $_POST['feedbackmsg'];
		$arr[8] = $_POST['datefrom'];
		$arr[9] = $_POST['dateto'];
		$arr[10] = $_POST['skills'];
		
		
		$claimhead = $this->loadModel('Feedback');
		$claimheadarray = $claimhead->sendFeedback($arr);
		echo json_encode($claimheadarray);	
				
	}
	function getEmployeeHistoryData()
	{
		try{
		$skill = $this->loadModel('Employmenthistory');
		$skillarray = $skill->getDataTable();
		echo json_encode($skillarray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	function deleteemployeehistory($did)
	{
		
		if(isset($did) )
		{
			$dept = $this->loadModel('Employmenthistory');
			$deptarray = $dept->Delete($did);
			//echo json_encode($deptarray);	
		}	
		header('location: ' . URL . 'employee/employmenthistory');
	}
	function confirmemployee()
    {
        $this->view->render('employee/confirmation/index');
    }
	function viewconfirmemployee($id)
    {
		try{
		if(isset($id)){
			$this->view->employeeid = $id;
			$this->view->val=0;
			$this->view->render('employee/confirmation/viewconfirmation');
		}else{
			header('location: ' . URL . 'error/index');
		}
		}catch(Exception $e){ echo $e->getMessage(); }
    }
	function getConfirmData()
	{
		try{
		$skill = $this->loadModel('Employee');
		$skillarray = $skill->getConfirmDataTable();
		echo json_encode($skillarray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	function getConfirmDetails()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['employeeid'];
		$skill = $this->loadModel('Employee');
		$skillarray = $skill->getConfirmDetail($arr);
		echo json_encode($skillarray);
	}
	
	function updatemodelfield()
	{
		try
		{
		$skill = $this->loadModel('ImportExport');
		$skillarray = $skill->UpdateModuleChildTable();
		echo json_encode($skillarray);
		}catch(Exception $e){ echo $e->getMessage();}
	}
	
	function updateConfirmDetails()
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['employeeid'];
		$arr[3] = $_POST['confirm'];
		$arr[4] = $_POST['confirmdate'];
		$skill = $this->loadModel('Employee');
		$skillarray = $skill->updateConfirmDetail($arr);
		echo json_encode($skillarray);
		}catch(Exception $e){ echo $e->getMessage();}
		
	}
	
	function edit_profile()
    {
        $this->view->render('employee/employeelist/edit_profile');
    }

	function onboard_employee_list($val=0)
    {
		$viewper = $this->CheckPermission(64, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(64, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->val =$val;
			$this->view->addper =$addper;
			$this->view->render('employee/onboard_employee_list');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	
	function probation_employee_list()
    {
        $this->view->render('employee/probation_employee_list');
    }
	
	function report_list()
    {
        $this->view->render('employee/reports_list');
    }
	function importemployee()
    {
        $this->view->render('employee/importemployeelist');
    }
	
	function importdata()
    {
        $this->view->render('employee/import');
    }
	
	function gratuitydata($date="")
    {
		$viewper = $this->CheckPermission(142, 1); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if ($viewper)
		{
			if($date=="")
				$date=date("Y-m-d");		
			$this->view->valdate=$date;
			$this->view->render('salary/gratuity');
		}else{
			header('location: ' . URL . 'salary');
		}
    }
	function getemployeegratuity($edate="")
	{
		try{
		$viewper = $this->CheckPermission(142, 1); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if ($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $edate;
			$role = $this->loadModel('Employee');
			$rolearray = $role->getGratuityDataTable($arr);
			echo json_encode($rolearray);	
		}else{
			header('location: ' . URL . 'salary');
		}
		}catch(Exception $e){
			
		}
	}

	function getchecklist($id)
    {
		
		if(isset($id)){
			$this->view->empid = Utils::decode5t($id); 
			$this->view->render('employee/employeelist/checklist');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	
	function getemployeechecklist()
	{
		$empid= $_POST['employeeid'];
		$role = $this->loadModel('Employee');
		$rolearray = $role->getEmployeeChecklist($empid);
		echo json_encode($rolearray);	
	}
	
	function saveChecklist()
	{
		$editper = $this->CheckPermission(19, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$emp = $_POST['employeeid'];
			$role = $this->loadModel('Employee');
			$rolearray = $role->saveEmpChecklist($emp);
			echo json_encode($rolearray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}	
		
	}

	
	function hierarchy($id,$val)
    {
		if(isset($id)){
			$this->view->empid = Utils::decode5t($id); 
			$this->view->val =$val; 
			$this->view->render('employee/employeelist/hierarchy');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	
	function getemployeehierarchy()
	{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['empid'];
			$role = $this->loadModel('Dashboard');
			$rolearray = $role->getEmployeeHierarchy($arr);
			echo json_encode($rolearray);	
	}
	
	function getEmployeeListbyreport()
	{try{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] =  $_SESSION['ubihrm_user_id'];
			$role = $this->loadModel('Dashboard');
			$rolearray = $role->getEmployeeListbyreport($arr);
			echo json_encode($rolearray);	
	}catch(Exception $e){
		
	}
	}
	function getEmployeeListbyreportproject()
	{try{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] =  $_SESSION['ubihrm_user_id'];
			$role = $this->loadModel('Dashboard');
			$rolearray = $role->getEmployeeListbyreportproject($arr);
			echo json_encode($rolearray);	
	}catch(Exception $e){
		
	}
	}
	
	function getemployeehierarchydata()
	{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$role = $this->loadModel('Employee');
			$rolearray = $role->getAllHierarchyEmployeeWithData($arr);
			echo json_encode($rolearray);	
	}
	function timeline($id,$val)
    {
		if(isset($id)){
			$this->view->empid = Utils::decode5t($id); 
			$this->view->val =$val; 
			$this->view->render('employee/employeelist/timeline');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	
	function gettimeline()
	{
		$arr = array();
		$arr[0] = $_POST['empid'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		
		$dept = $this->loadModel('Dashboard');
		$deptarray = $dept->getTimeLine($arr);
		echo json_encode($deptarray);		
	}
	
	function getbirthdaydashboard($val,$type="")
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];
		try{
		$dash = $this->loadModel('Dashboard');
		if($val==1){
			$dasharray = $dash->getEmployeeDashboard1($arr);
		}else{
			$dasharray = $dash->getEmployeeDashboard1($arr);
		}
		echo json_encode($dasharray);	
			}catch(Exception $e){
				echo $e->getMessage();
			}
	}
	
	function getnewjoiningdashboard()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$dash = $this->loadModel('Dashboard');
		$dasharray = $dash->getEmployeeDashboard2($arr);
		echo json_encode($dasharray);		
	}
	
	/** 
	 									
	 /////////////////////////////  ////////////////////////////
	
	 /////////////////////////////    SKILL CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on skill table
     * getall function fetching skill list
	 * @returning json array of data as result
     */
	
	function skill()
    {
		$viewper = $this->CheckPermission(43, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(43, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/skill/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addskill()
    {
		$addper = $this->CheckPermission(43, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->skillid =0;
			$this->view->val = 0; 
			$this->view->render('employee/skill/addeditskill');
		}else{
			header('location: ' . URL . 'employee/skill');
		}
    }
	
	function editskill($id)
    {
		$editper = $this->CheckPermission(43, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->skillid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/skill/addeditskill');
		}else{
			header('location: ' . URL . 'employee/skill');
		}
		
    }
	function viewskill($id,$val)
    {
		
		if(isset($id) && isset($val))
		{
			$this->view->skillid = Utils::decode5t($id); 
			$this->view->val = $val; 
			$this->view->render('employee/skill/addeditskill');
		}else{
			header('location: ' . URL . 'employee/skill');
		}
		
    }
	function getallskill()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$skill = $this->loadModel('Skill');
			$skillarray = $skill->getAll($arr);
			echo json_encode($skillarray);	
			
		
	}
	
	function getaskill()
	{
		$viewper = $this->CheckPermission(43, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['skillid'];
			$skill = $this->loadModel('Skill');
			$skillarray = $skill->getDetail($gid);
			echo json_encode($skillarray);		
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on skill table
     * getall function fetching skill list
	 * @returning json array of data as result
     */
	function createskill()
	{
		$addper = $this->CheckPermission(43, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['skillname'];
			$arr[3] = $_POST['catid'];
			$arr[4] = $_POST['skillcode'];
			
			$dept = $this->loadModel('Skill');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);
		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on skill table
     * delete function from skill list
	 * @returning json array of data as result
     */
	 
	 function updatedeskill()
	{
		$editper = $this->CheckPermission(43, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['skillname'];
			$arr[3] = $_POST['catid'];
			$arr[4] = $_POST['skillid'];
			$arr[5] = $_POST['skillcode'];
			$dept = $this->loadModel('Skill');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteskill($did)
	{
		$deleteper = $this->CheckPermission(43, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Skill');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'employee/skill');
	}
	

	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getSkillData()
	{
		$editper = $this->CheckPermission(43, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(43, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$skill = $this->loadModel('Skill');
		$skillarray = $skill->getDataTable($editper, $deleteper);
		echo json_encode($skillarray);
	}
	
	/** 
	 									
	 ///////////////////////////// SKILL CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	
	 ///////////////////////////// EMPSTATUS CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on empstatus table
     * getall function fetching empstatus list
	 * @returning json array of data as result
     */
	
	function empstatus()
    {
		$viewper = $this->CheckPermission(23, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(23, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/empstatus/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addempstatus()
    {
		$addper = $this->CheckPermission(23, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->empstatusid =0;
			$this->view->val = 0; 
        $this->view->render('employee/empstatus/addeditempstatus');
		}else{
			header('location: ' . URL . 'employee/empstatus');
		}
    }
	
	function editempstatus($id)
    {
		$editper = $this->CheckPermission(23, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->empstatusid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/empstatus/addeditempstatus');
		}else{
			header('location: ' . URL . 'employee/empstatus');
		}
    }
	
	function viewempsts($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->empstatusid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/empstatus/addeditempstatus');
		}else{
			header('location: ' . URL . 'employee/empstatus');
		}
		
    }
	
	function getallempstatus()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$empstatus = $this->loadModel('Empstatus');
			$empstatusarray = $empstatus->getAll($arr);
			echo json_encode($empstatusarray);	
			
		
	}
	
	
	function getaempstatus()
	{
		$viewper = $this->CheckPermission(23, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['empstatusid'];
			$empstatus = $this->loadModel('Empstatus');
			$empstatusarray = $empstatus->getDetail($gid);
			echo json_encode($empstatusarray);	
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on empstatus table
     * getall function fetching empstatus list
	 * @returning json array of data as result
     */
	function createempstatus()
	{
		$addper = $this->CheckPermission(23, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['empstatusname'];
			$arr[3] = $_POST['empstatuscode'];
			
			$dept = $this->loadModel('Empstatus');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on empstatus table
     * delete function from empstatus list
	 * @returning json array of data as result
     */
	 
	function updatedeempstatus()
	{
		$editper = $this->CheckPermission(23, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['empstatusname'];
			$arr[3] = $_POST['empstatusid'];
			$arr[4] = $_POST['empstatuscode'];
			
			$dept = $this->loadModel('Empstatus');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteempstatus($did)
	{
		$deleteper = $this->CheckPermission(23, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Emptype');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'employee/empstatus');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getEmpstatusData()
	{
		$editper = $this->CheckPermission(23, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(23, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		try{
		$empstatus = $this->loadModel('Empstatus');
		$empstatusarray = $empstatus->getDataTable($editper, $deleteper);
		echo json_encode($empstatusarray);
		}catch(Exception $e){
		
		}
	}
	
		/** 
	 									
	 /////////////////////////////  EMPSTATUS CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	
	 /////////////////////////////  QUALIFICATION CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on qualification table
     * getall function fetching qualification list
	 * @returning json array of data as result
     */
	
	function qualification()
    {
		$viewper = $this->CheckPermission(37, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(37, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/qualification/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	
	function addqualification()
    {
		
		$addper = $this->CheckPermission(37, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->qualificationid =0;
			$this->view->val = 0; 
			$this->view->render('employee/qualification/addeditqualification');
		}else{
			header('location: ' . URL . 'employee/qualification');
		}
    }
	
	function editqualification($id)
    {
		$editper = $this->CheckPermission(37, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->qualificationid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/qualification/addeditqualification');
		}else{
			header('location: ' . URL . 'employee/qualification');
		}
    }
	function viewqualification($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->qualificationid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/qualification/addeditqualification');
		}else{
			header('location: ' . URL . 'employee/qualification');
		}
		
    }
	
	function getallqualification()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$qualification = $this->loadModel('Qualification');
			$qualificationarray = $qualification->getAll($arr);
			echo json_encode($qualificationarray);		
			
		
	}
	
	function getaqualification()
	{
				
		$viewper = $this->CheckPermission(37, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['qualificationid'];
			$qualification = $this->loadModel('Qualification');
			$qualificationarray = $qualification->getDetail($gid);
			echo json_encode($qualificationarray);
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on qualification table
     * getall function fetching qualification list
	 * @returning json array of data as result
     */
	function createqualification()
	{	
		$addper = $this->CheckPermission(37, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['qualificationname'];
			$arr[3] = $_POST['catid'];
			$arr[4] = $_POST['qualificationcode'];			
			
			$dept = $this->loadModel('Qualification');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);
		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}			
	}
	
	 /**
     * Functions for perfom operation on qualification table
     * delete function from qualification list
	 * @returning json array of data as result
     */
	 
	 function updatedequalification()
	{
		$editper = $this->CheckPermission(37, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['qualificationname'];
			$arr[3] = $_POST['catid'];
			$arr[4] = $_POST['qualificationid'];
			$arr[5] = $_POST['qualificationcode'];	
			
			$dept = $this->loadModel('Qualification');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletequalification($did)
	{
		$deleteper = $this->CheckPermission(37, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Qualification');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/qualification');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getQualificationData()
	{
		$editper = $this->CheckPermission(37, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(37, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$qualification = $this->loadModel('Qualification');
		$qualificationarray = $qualification->getDataTable($editper, $deleteper);
		echo json_encode($qualificationarray);
		
	}
	
		/** 
	 									
	 ///////////////////////////// QUALIFICATION CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	
	 ///////////////////////////// BLOOD GROUP CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on bloodgroup table
     * getall function fetching bloodgroup list
	 * @returning json array of data as result
     */
	
	function bloodgroup()
    {
        $this->view->render('employee/bloodgroup/index');
    }
	function addbloodgroup()
    {
		$this->view->bloodgroupid =0;
        $this->view->render('employee/bloodgroup/addeditbloodgroup');
    }
	
	function editbloodgroup($id)
    {
		if(isset($id))
		{
			//$bloodgroup = $this->loadModel('Bloodgroup');
			$this->view->bloodgroupid = $id; //$dept->getDetail($id);
			$this->view->render('employee/bloodgroup/addeditbloodgroup');
		}else{
			header('location: ' . URL . 'employee/bloodgroup');
		}
    }
	
	function getallbloodgroup()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$bloodgroup = $this->loadModel('Bloodgroup');
		$bloodgrouparray = $bloodgroup->getAll($arr);
		echo json_encode($bloodgrouparray);		
	}
	
	function getabloodgroup()
	{
		$gid = $_POST['bloodgroupid'];
		$bloodgroup = $this->loadModel('Bloodgroup');
		$bloodgrouparray = $bloodgroup->getDetail($gid);
		echo json_encode($bloodgrouparray);		
	}
	
	/** 
     * Functions for perfom operation on bloodgroup table
     * getall function fetching bloodgroup list
	 * @returning json array of data as result
     */
	function createbloodgroup()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['bloodgroupname'];
				
		$dept = $this->loadModel('Bloodgroup');
		$deptarray = $dept->Create($arr);
		echo json_encode($deptarray);		
	}
	
	 /**
     * Functions for perfom operation on bloodgroup table
     * delete function from bloodgroup list
	 * @returning json array of data as result
     */
	 
	 function updatedebloodgroup()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['bloodgroupname'];
		$arr[3] = $_POST['bloodgroupid'];
		
		$dept = $this->loadModel('Bloodgroup');
		$deptarray = $dept->Update($arr);
		echo json_encode($deptarray);		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletebloodgroup($did)
	{
		if(isset($did))
		{
			$dept = $this->loadModel('Bloodgroup');
			$deptarray = $dept->Delete($did);
			//echo json_encode($deptarray);		
			
		}		
		header('location: ' . URL . 'employee/bloodgroup');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getBloodgroupData()
	{
		$bloodgroup = $this->loadModel('Bloodgroup');
		$bloodgrouparray = $bloodgroup->getDataTable();
		echo json_encode($bloodgrouparray);
	}
	
	
	/** 
	 									
	 ///////////////////////////// BLOOD GROUP CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	
	 ///////////////////////////// DOCUMENT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on document table
     * getall function fetching document list
	 * @returning json array of data as result
     */
	
	function document()
    {
		$viewper = $this->CheckPermission(15, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(15, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/document/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function adddocument()
    {
		$addper = $this->CheckPermission(15, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->documentid =0;
			$this->view->val = 0; 
			$this->view->render('employee/document/addeditdocument');
		}else{
			header('location: ' . URL . 'employee/document');
		}
    }
	
	function editdocument($id,$doctype)
    {
		$editper = $this->CheckPermission(15, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->documentid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			if($doctype==1)
			$this->view->render('employee/document/addeditdocument');
			else
			$this->view->render('employee/doclibrary/addeditdoclibrary');
		}else{
			header('location: ' . URL . 'employee/document');
		}
		
    }
	function viewdocument($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->documentid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/document/addeditdocument');
		}else{
			header('location: ' . URL . 'employee/document');
		}
		
    }
	function getalldocument()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$document = $this->loadModel('Document');
			$documentarray = $document->getAll($arr);
			echo json_encode($documentarray);		
			
		
	}
	
	function getadocument()
	{try{
		$viewper = $this->CheckPermission(15, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['documentid'];
			$document = $this->loadModel('Document');
			$documentarray = $document->getDetail($gid);
			echo json_encode($documentarray);	
		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}		
	}
	
	/** 
     * Functions for perfom operation on document table
     * getall function fetching document list
	 * @returning json array of data as result
     */
	function createdocument()
	{
		$addper = $this->CheckPermission(15, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['documentname'];
			$arr[3] = $_POST['documentcode'];
			$arr[4] = $_POST['doctype'];
			$arr[5] = $_POST['issuedate'];
			$arr[6] = $_POST['expiredate'];
			$dept = $this->loadModel('Document');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on document table
     * delete function from document list
	 * @returning json array of data as result
     */
	 
	 function updatededocumentemp()
	{
		$editper = $this->CheckPermission(15, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['documentname'];
			$arr[3] = $_POST['documentid'];
			$arr[4] = $_POST['documentcode'];
			$arr[5] = $_POST['doctype'];
			
			$dept = $this->loadModel('Document');
			$deptarray = $dept->Updateemp($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 function updatededocument()
	{
		$editper = $this->CheckPermission(15, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['documentname'];
			$arr[3] = $_POST['documentid'];
			$arr[4] = $_POST['documentcode'];
			$arr[5] = $_POST['doctype'];
			$arr[6] = $_POST['issuedate'];
			$arr[7] = $_POST['expiredate'];
			
			$dept = $this->loadModel('Document');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletedocument($did)
	{try{
		$deleteper = $this->CheckPermission(15, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Document');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}
		//header('location: ' . URL . 'employee/document');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getDocumentData($docIdenty)
	{
		try{
		$editper = $this->CheckPermission(15, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(15, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$document = $this->loadModel('Document');
		$documentarray = $document->getDataTable($editper, $deleteper,$docIdenty);
		echo json_encode($documentarray);
		}catch(Exception $e){}
	}
	
	/** 
	 									
	 ///////////////////////////// DOCUMENT CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	 
	
	 ///////////////////////////// VISA CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on visa table
     * getall function fetching visa list
	 * @returning json array of data as result
     */
	
	function visa()
    {
		$viewper = $this->CheckPermission(48, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(48, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/visa/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
    function visaCategory(){
		$viewper = $this->CheckPermission(48, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(48, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/visa/Visacat');
		}else{
			header('location: ' . URL . 'employee/index');
		}
	}
	function getVisaCategory(){
		
		$editper = $this->CheckPermission(48, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(48, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$visa = $this->loadModel('Visa');
		$visaarray = $visa->getVisaCategory($editper, $deleteper);
		echo json_encode($visaarray);
	}
	function addvisa()
    {
		$addper = $this->CheckPermission(48, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->visaid =0;
			$this->view->val = 0; 
			$this->view->render('employee/visa/addeditvisa');
		}else{
			header('location: ' . URL . 'employee/visa');
		}
    }
    
	function addvisacat()
    {
		$addper = $this->CheckPermission(48, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->visaid =0;
			$this->view->val = 0; 
			$this->view->render('employee/visa/addVisacat');
		}else{
			header('location: ' . URL . 'employee/visa');
		}
    }
	function editvisa($id)
    {
		$editper = $this->CheckPermission(48, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->val = 0; 
			$this->view->visaid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/visa/addeditvisa');
		}else{
			header('location: ' . URL . 'employee/visa');
		}
    }
    function editvisacat($id)
    {
		$editper = $this->CheckPermission(48, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->val = 0; 
			$this->view->visaid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/visa/addVisacat');
		}else{
			header('location: ' . URL . 'employee/visa');
		}
    }
	
	function viewvisa($id,$val)
    {
		if(isset($id)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->visaid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/visa/addeditvisa');
		}else{
			header('location: ' . URL . 'employee/visa');
		}
		
    }
    function viewvisacat($id,$val)
    {
		if(isset($id)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->visaid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/visa/addVisacat');
		}else{
			header('location: ' . URL . 'employee/visa');
		}
		
    }
	function getallvisa()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$visa = $this->loadModel('Visa');
			$visaarray = $visa->getAll($arr);
			echo json_encode($visaarray);
	
		
	}
	function allvisacat(){
		 $arr = array();
		 $arr[0] = $_SESSION['ubihrm_org_id'];
		 $arr[1] = $_SESSION['ubihrm_user_id'];
		  $visa = $this->loadModel('Visa');
		  $visacatarray = $visa->allvisacat($arr);
		  echo json_encode($visacatarray);
	}
	
	function getavisa()
	{
		$viewper = $this->CheckPermission(48, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['visaid'];
			$visa = $this->loadModel('Visa');
			$visaarray = $visa->getDetail($gid);
			echo json_encode($visaarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	function getvisacat()
	{
		$viewper = $this->CheckPermission(48, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['visaid'];
			$visa = $this->loadModel('Visa');
			$visaarray = $visa->getvisacat($gid);
			echo json_encode($visaarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on visa table
     * getall function fetching visa list
	 * @returning json array of data as result
     */
	function createvisa()
	{	
		$addper = $this->CheckPermission(48, 4);  ///////// CHECK FOR ADD PERMISSION  //////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['visaname'];	
			$dept = $this->loadModel('Visa');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}
	function createvisacat()
	{	
		$addper = $this->CheckPermission(48, 4);  ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['visaname'];
					
			$dept = $this->loadModel('Visa');
			$deptarray = $dept->CreateVisacat($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}
	 /**
     * Functions for perfom operation on visa table
     * delete function from visa list
	 * @returning json array of data as result
     */
	 
	 function updatedevisa()
	{
		$editper = $this->CheckPermission(48, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['visaname'];
			$arr[3] = $_POST['visaid'];
			
			$dept = $this->loadModel('Visa');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}function updatevisacat()
	{
		$editper = $this->CheckPermission(48, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['visaname'];
			$arr[3] = $_POST['visaid'];
			
			$dept = $this->loadModel('Visa');
			$deptarray = $dept->editvisacat($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletevisa($did)
	{
		$deleteper = $this->CheckPermission(48, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Visa');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/visa');
	}
	function deletevisacat($did)
	{
		$deleteper = $this->CheckPermission(48, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Visa');
			$deptarray = $dept->Deletecat($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/visa');
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getVisaData()
	{
		$editper = $this->CheckPermission(48, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(48, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$visa = $this->loadModel('Visa');
		$visaarray = $visa->getDataTable($editper, $deleteper);
		echo json_encode($visaarray);
	}
	
	
	/** 
	 									
	 ///////////////////////////// VISA CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	
	 ///////////////////////////// FUNCTIONAL AREA CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on functionalarea table
     * getall function fetching functionalarea list
	 * @returning json array of data as result
     */
	
	function functionalarea()
    {
		$viewper = $this->CheckPermission(26, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(26, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/functionalarea/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addfunctionalarea()
    {
		$addper = $this->CheckPermission(26, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->functionalareaid =0;
			$this->view->val = 0; 
			$this->view->render('employee/functionalarea/addeditfunctionalarea');
		}else{
			header('location: ' . URL . 'employee/functionalarea');
		}
    }
	
	function editfunctionalarea($id)
    {	
		$editper = $this->CheckPermission(26, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->functionalareaid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/functionalarea/addeditfunctionalarea');
		}else{
			header('location: ' . URL . 'employee/functionalarea');
		}
    }
	
	function viewfunctionalarea($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->functionalareaid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/functionalarea/addeditfunctionalarea');
		}else{
			header('location: ' . URL . 'employee/functionalarea');
		}		
    }
	function getallfunctionalarea()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$functionalarea = $this->loadModel('Functionalarea');
			$functionalareaarray = $functionalarea->getAll($arr);
			echo json_encode($functionalareaarray);			
		
	}
	
	function getafunctionalarea()
	{
		$viewper = $this->CheckPermission(26, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['functionalareaid'];
			$functionalarea = $this->loadModel('Functionalarea');
			$functionalareaarray = $functionalarea->getDetail($gid);
			echo json_encode($functionalareaarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	/** 
     * Functions for perfom operation on functionalarea table
     * getall function fetching functionalarea list
	 * @returning json array of data as result
     */
	function createfunctionalarea()
	{
		$addper = $this->CheckPermission(26, 4);   ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['functionalareaname'];
					
			$dept = $this->loadModel('Functionalarea');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on functionalarea table
     * delete function from functionalarea list
	 * @returning json array of data as result
     */
	 
	function updatedefunctionalarea()
	{
		$editper = $this->CheckPermission(26, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['functionalareaname'];
			$arr[3] = $_POST['functionalareaid'];
			
			$dept = $this->loadModel('Functionalarea');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletefunctionalarea($did)
	{
		$deleteper = $this->CheckPermission(26, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Functionalarea');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/functionalarea');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getFunctionalareaData()
	{
		$editper = $this->CheckPermission(26, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(26, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$functionalarea = $this->loadModel('Functionalarea');
		$functionalareaarray = $functionalarea->getDataTable($editper, $deleteper);
		echo json_encode($functionalareaarray);
	}
	
	/** 	
	 ///////////////////////////// FUNCTIONAL AREA CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	
	 ///////////////////////////// EMPLOYEE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on employee table
     * getall function fetching employee list
	 * @returning json array of data as result
     */
	
	function employeelist()
    {
		//$employee = $this->loadModel('Employee');
		//$employee->DecryptAllEmp();
		//$employee->DecryptAllUser();
		//$employee->DecryptEmpDetails(); 
		//$employee->DecryptAllNewEmp(); 
		//$employee->DecryptNewEmpDetails(); 
		$viewper = $this->CheckPermission(19, 1);
		///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(19, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/employeelist/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function ex_employeelist()
    {
		$viewper = $this->CheckPermission(141, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(141, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/employeelist/exemployee');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function deleteEmpList()
    {
		try{
		$viewper = $this->CheckPermission(141, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(141, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/employeelist/deleteemplist');
		}else{
			header('location: ' . URL . 'employee/index');
		}
	}catch(Exception $e){}
    }
	function under_severance()
    {
		$viewper = $this->CheckPermission(141, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(141, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/employeelist/underseverance');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	
	function addemployee()
    {
		$addper = $this->CheckPermission(19, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->employeeid =0;
			$this->view->val = 0; 
			$this->view->render('employee/employeelist/addeditemployee');
		}else{
			header('location: ' . URL . 'employee/employeelist');
		}
    }
	
	function editemployee($id)
    {
		$editper = $this->CheckPermission(19, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			//$employee = $this->loadModel('Employee');
			$this->view->employeeid = Utils::decode5t($id); 
			$this->view->val = 0; 
			$this->view->render('employee/employeelist/addeditemployee');
		}else{
			header('location: ' . URL . 'employee/employeelist');
		}
    }
	
	function viewemployee($id,$val)
    {
		$viewper = $this->CheckPermission(19, 1); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($viewper)  && isset($val))
		{
			//$employee = $this->loadModel('Employee');
			$this->view->employeeid =Utils::decode5t($id); 
			$this->view->val = $val; 
			$this->view->render('employee/employeelist/viewemployee');
		}else{
			header('location: ' . URL . 'employee/employeelist');
		}
    }
	
	
	function getallemployee()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$employee = $this->loadModel('Employee');
			$employeearray = $employee->getAllHierarchyEmployee($arr);
			echo json_encode($employeearray);		
		
	}
	function getallemployee1()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$employee = $this->loadModel('Employee');
			$employeearray = $employee->getAllHierarchyEmployee2($arr); 
			echo json_encode($employeearray);		
		}catch(Exception $ex){}
	}
	
	function getorganizationemployee()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$employee = $this->loadModel('Employee');
			$employeearray = $employee->getAllOrganizationEmployeegetAllOrganizationEmployee($arr);
			echo json_encode($employeearray);		
		
	}
	
/*	function getnotterminateemployee()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$employee = $this->loadModel('Employee');
			$employeearray = $employee->getAllNotTerminateEmployee($arr);
			echo json_encode($employeearray);		
		
	} */
	
	function getallsenioremployee()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$employee = $this->loadModel('Employee');
			$employeearray = $employee->getSeniorEmployeeList($arr);
			echo json_encode($employeearray);		
		
	}
	
	
	
	function getreportingto($desig,$empid)
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $desig;
			$arr[3] = $empid;
			
			$employee = $this->loadModel('Employee');
			$employeearray = $employee->getAllReportingEmp($arr);
			echo json_encode($employeearray);		
		
	}

	function getaemployee()
	{
		try{
		$viewper = $this->CheckPermission(19, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['employeeid'];
			$employee = $this->loadModel('Employee');
			$employeearray = $employee->getDetail($gid);
			//print_r($employeearray);
			echo json_encode($employeearray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	
	
	/** 
     * Functions for perfom operation on employee table
     * getall function fetching employee list
	 * @returning json array of data as result
     */
	function createemployee()
	{
		$addper = $this->CheckPermission(19, 4);   ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper)
		{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Employee');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);
			}catch(Exception $e)
			{}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on employee table
     * delete function from employee list
	 * @returning json array of data as result
     */
	 
	function updatedeemployee()
	{
		$editper = $this->CheckPermission(19, 2);  
		///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Employee');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);	
			}catch(Exception $e){}
			
		}
		else{try{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}catch(Exception $e){
			
		}
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteemployee($did)
	{
		$deleteper = $this->CheckPermission(19, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		/*if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Employee');
			$deptarray = $dept->Delete($did);
		}
		header('location: ' . URL . 'employee/employeelist');*/
		if(isset($did) && $deleteper)
		{
			$dept = $this->loadModel('Employee');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
	}
	
	 function empDeletePermanent($did)
	{
		$deleteper = $this->CheckPermission(19, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper)
		{
			$dept = $this->loadModel('Employee');
			$deptarray = $dept->empDeletePermanent($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
	}
	
	//////////////restore employee//////
	function restoreemployee($did)
	{
		$deleteper = $this->CheckPermission(19, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		//if(isset($did) && $deleteper )
		//{
			//$dept = $this->loadModel('Employee');
			//$deptarray = $dept->restoreemployee($did);
		//}
		//header('location: ' . URL . 'employee/deleteEmpList');
		if(isset($did) && $deleteper)
		{
			$dept = $this->loadModel('Employee');
			$deptarray = $dept->restoreemployee($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
	}
	
	
	 /**
     * Functions for perfom operation on employeeMaster table
     * delete function
	 * 
     */
	 
	 function deleteBulkEmployee()
	 {
 		 $deleteper = $this->Checkpermission(19, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
	     $ids = $_POST["ids"];
 	   
       	if($deleteper){
	      $deletes = $this->loadModel('Employee');
	      $deletearray = $deletes->Bulkdelete($ids);
	    }	
	 }
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getEmployeeData()
	{
		try{
		$employee = $this->loadModel('Employee');
		$editper = $this->CheckPermission(19, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(19, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  //////////
		$viewper = $this->CheckPermission(19, 1); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$employeearray = $employee->getDataTable($editper, $deleteper,$viewper);
		echo json_encode($employeearray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	function getExEmployeeData()
	{
		$employee = $this->loadModel('Employee');
		
		$editper = $this->CheckPermission(19, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(19, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		try{
		$employeearray = $employee->getExEmployeeTable($editper, $deleteper);
		echo json_encode($employeearray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	function getDeleteEmployeeData()
	{
		try{
		$employee = $this->loadModel('Employee');
		$editper = $this->CheckPermission(19, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(19, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  //////////
		$viewper = $this->CheckPermission(19, 1); ///////// CHECK FOR VIEW EMPLOYEE PERMISSION  ////////////
	
		$employeearray = $employee->getDeleteEmployeeTable($editper, $deleteper,$viewper);
		echo json_encode($employeearray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	function getUnderSeveranceData()
	{
		$employee = $this->loadModel('Employee');
		
		$editper = $this->CheckPermission(19, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(19, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		try{
		$employeearray = $employee->getUnderSeveranceTable($editper, $deleteper);
		echo json_encode($employeearray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	function viewsalarycertificate($id,$val)
    {
		
		if(isset($id) && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->empid = Utils::decode5t($id);  //$dept->getDetail($id);
			$this->view->render('employee/employeelist/printsalarycertificate');
		}else{
			header('location: ' . URL . 'employee/index');
		}
		
    }
	
	
	function getasalary()
	{
		$viewper = $this->CheckPermission(19, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		
		if($viewper)
		{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['empid'];
			$salary = $this->loadModel('Employee');
			$salaryarray = $salary->getDetailEmp($arr);
			echo json_encode($salaryarray);		
			}catch(Exception $e){ echo $e->getMessage();}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}			
	}
	function getemployeesalary()
	{
		$employee = $this->loadModel('Employee');
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]=$_POST['employeeid'];
			$arr[3]=$_POST['gradeid'];	
			$arr[4]=$_POST['grossalary'];	
			$arr[5]=$_POST['incentive'];	
			$arr[6]=$_POST['experience'];			
			$arr[7]=isset($_POST['division'])?$_POST['division']:"0";			
			$arr[8]=isset($_POST['department'])?$_POST['department']:"0";
			$arr[9]=isset($_POST['preexp'])?$_POST['preexp']:"0";			
		$employeearray = $employee->getEmployeeSalaryDetails($arr);
		echo json_encode($employeearray);
	}
	
	function getemployeesalarytype()
	{
		$employee = $this->loadModel('Employee');
		$arr = array();
			$arr[0]= $_SESSION['ubihrm_user_id'];
			$arr[1]= $_SESSION['ubihrm_org_id'];
			$arr[2]=$_POST['division'];
			$arr[3]=$_POST['gradeid'];	
			$arr[4]=$_POST['designation'];	
			$arr[5]=$_POST['department'];	
			$arr[6]=$_POST['experience'];
            $arr[7]=$_POST['channel'];			
		$employeearray = $employee->getEmployeeSalaryType($arr);
		echo json_encode($employeearray);
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	 function uploadEmployeeImage()
	{	
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]=$_POST['emp_id'];			
			$employee = $this->loadModel('Employee');
			$employeearray = $employee->uploadImage($arr);
			echo json_encode($employeearray);
		}catch(Exception $e)
		{}		
		
	}
	
	function uploadEmployeeDocument($doctype)
	{	
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]=$_POST['emp_id'];	
			//$arr[3]=$_POST['doc_id'];	
			$arr[4]=$doctype;				
			$employee = $this->loadModel('Employee');
			$employeearray = $employee->uploadDocument($arr);
			echo json_encode($employeearray);
			
		
	}

	///////////////////////////// EMPLOYEE CONTROLLER FUNCTION ENDS HERE  ////////////////////////////

	///////////////////////////// NOTIFICATION CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	/*
     * Functions for perfom operation on notification table
     * getall function fetching notification list
	 * @returning json array of data as result
     */
	
	function notification()
    {
		$viewper = $this->CheckPermission(49, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(49, 4); ///////// CHECK FOR ADD PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/notifications/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addnotification()
    {
		$addper = $this->CheckPermission(49, 4); ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper){
			$this->view->notificationid =0;
			$this->view->val = 0; 
			$this->view->render('employee/notifications/addeditnotification');
		}else{
			header('location: ' . URL . 'employee/notification');
		}
		
    }
	
	function editnotification($id)
    {
		$editper = $this->CheckPermission(49, 2); ///////// CHECK FOR EDIT PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			//$employee = $this->loadModel('Employee');
			$this->view->notificationid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/notifications/addeditnotification');
		}else{
			header('location: ' . URL . 'employee/notification');
		}
    }
	function viewnotification($id,$val)
    {
		$viewper = $this->CheckPermission(49, 1); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($viewper)  && isset($val))
		{
			//$employee = $this->loadModel('Employee');
			$this->view->notificationid = Utils::decode5t($id); 
			$this->view->val = $val; 
			$this->view->render('employee/notifications/addeditnotification');
		}else{
			header('location: ' . URL . 'employee/notification');
		}
    }
	function getallnotification()
	{	
		$viewper = $this->CheckPermission(49, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$notification = $this->loadModel('Notification');
			$notificationarray = $notification->getAll($arr);
			echo json_encode($notificationarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getanotification()
	{
		$viewper = $this->CheckPermission(49, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['notificationid'];
			$notification = $this->loadModel('Notification');
			$notificationarray = $notification->getDetail($gid);
			echo json_encode($notificationarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	/** 
     * Functions for perfom operation on notification table
     * getall function fetching notification list
	 * @returning json array of data as result
     */
	function createnotification()
	{
		$addper = $this->CheckPermission(49, 4);   ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper)
		{
			try
			{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['notificationname'];
			$arr[3] = $_POST['message'];
			$arr[4] = $_POST['division'];
			$arr[5] = $_POST['department'];
			$arr[6] = $_POST['designation'];
			$arr[7] = $_POST['empid'];
			$arr[8] = $_POST['startdate'];
			$arr[9] = $_POST['enddate'];
			$arr[10] = $_POST['priority'];
			$arr[11] = $_POST['toggle'];
			$arr[12] = $_POST['sendmailsts'];
		//	$arr[13] = $_POST['fileattach'];
			$dept = $this->loadModel('Notification');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);
			}catch(Exception $e){echo $e->getMessage();}

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}
	
	 /**
     * Functions for perfom operation on notification table
     * delete function from notification list
	 * @returning json array of data as result
     */
	 function getNotificationDataForEmployee()
	{
		$editper = $this->CheckPermission(49, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(49, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$notification = $this->loadModel('Notification');
		$notificationarray = $notification->getDataTableForEmployee();
		echo json_encode($notificationarray);
	}
	
	 function updatednotification()
	{
		$editper = $this->CheckPermission(49, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			try
			{
				$arr = array();
				$arr[0] = $_SESSION['ubihrm_user_id'];
				$arr[1] = $_SESSION['ubihrm_org_id'];
				$arr[2] = $_POST['notificationname'];
				$arr[3] = $_POST['notificationid'];
				$arr[4] = $_POST['message'];
				$arr[5] = $_POST['division'];
				$arr[6] = $_POST['department'];
				$arr[7] = $_POST['designation'];
				$arr[8] = $_POST['empid'];
				$arr[9] = $_POST['startdate'];
				$arr[10] = $_POST['enddate'];
				$arr[11] = $_POST['priority'];
				$arr[12] = $_POST['toggle'];
				$arr[13] = $_POST['sendmailsts'];

			//	$arr[13] = $_FILES['fileattach'];

				
				$dept = $this->loadModel('Notification');
				$deptarray = $dept->Update($arr);
				echo json_encode($deptarray);
			}catch(Exception $e){echo $e->getMessage();}
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletenotification($did)
	{
		$deleteper = $this->CheckPermission(49, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Notification');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'employee/notification');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getNotificationData()
	{
		$editper = $this->CheckPermission(49, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(49, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$notification = $this->loadModel('Notification');
		$notificationarray = $notification->getDataTable($editper, $deleteper);
		echo json_encode($notificationarray);
	}
	
	
 
	 									
	 ///////////////////////////// NOTIFICATION CONTROLLER FUNCTION ENDS HERE ////////////////////////////	
	 
	 ///////////////////////////// Asset Issue CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	/*
     * Functions for perfom operation on asset table
     * getall function fetching notification list
	 * @returning json array of data as result
     */
	
	function issueasset()
    {
		$viewper = $this->CheckPermission(50, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(50, 4); ///////// CHECK FOR ADD PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/issueassets/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addissueasset()
    {
		$addper = $this->CheckPermission(50, 4); ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper){
			$this->view->issueassetid =0;
			$this->view->val = 0;
			$this->view->render('employee/issueassets/addeditissueasset');
		}else{
			header('location: ' . URL . 'employee/issueasset');
		}
		
    }
	
	function editissueasset($id)
    {
		$editper = $this->CheckPermission(50, 2); ///////// CHECK FOR EDIT PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->issueassetid = Utils::decode5t($id); 
			$this->view->val = 0;
			$this->view->render('employee/issueassets/addeditissueasset');
		}else{
			header('location: ' . URL . 'employee/issueasset');
		}
    }
	
	function getallissueasset()
	{
		$viewper = $this->CheckPermission(50, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$issueasset = $this->loadModel('Issueasset');
			$issueassetarray = $issueasset->getAll($arr);
			echo json_encode($issueassetarray);				
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}	
	}
	
	function getaissueasset()
	{
		
		$viewper = $this->CheckPermission(50, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['issueassetid'];
			$issueasset = $this->loadModel('Issueasset');
			$issueassetarray = $issueasset->getDetail($gid);
			echo json_encode($issueassetarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}			
	}
	
	/** 
     * Functions for perfom operation on issueasset table
     * getall function fetching issueasset list
	 * @returning json array of data as result
     */
	function createissueasset()
	{
		$addper = $this->CheckPermission(50, 4);   ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['emp_id'];
			$arr[3] = $_POST['assetid'];
			$arr[4] = $_POST['issue_date'];
			$arr[5] = $_POST['return_date'];
			$arr[6] = $_POST['desc'];
					
			$dept = $this->loadModel('Issueasset');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on issueasset table
     * delete function from issueasset list
	 * @returning json array of data as result
     */
	 
	 function updatedissueasset()
	 {
		$editper = $this->CheckPermission(50, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['return_date'];
			$arr[3] = $_POST['issueassetid'];
			$dept = $this->loadModel('Issueasset');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteissueasset($did)
	{
		$deleteper = $this->CheckPermission(50, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Issueasset');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}		
		//header('location: ' . URL . 'employee/issueasset');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getIssueassetData()
	{
		$editper = $this->CheckPermission(50, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(50, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$issueasset = $this->loadModel('Issueasset');
		$issueassetarray = $issueasset->getDataTable($editper, $deleteper);
		echo json_encode($issueassetarray);
	}
	function viewissueasset($id,$val)
    {
		$viewper = $this->CheckPermission(19, 1); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($viewper)  && isset($val))
		{
			//$employee = $this->loadModel('Employee');
			$this->view->issueassetid = Utils::decode5t($id); 
			$this->view->val = $val; 
			$this->view->render('employee/issueassets/addeditissueasset');
		}else{
			header('location: ' . URL . 'employee/issueasset');
		}
    }
//////////////////////////// ISSUEASSET CONTROLLER FUNCTION ENDS HERE////////////////////////////

/////////////////////////////GRIEVANCE CONTROLLER FUNCTION STARTS HERE////////////////////////////
	 function grievance()
    {
		$viewper = $this->CheckPermission(51, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(51, 4); ///////// CHECK FOR ADD PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/grievance/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
       
    }
	function addgrievance()
    {
		$addper = $this->CheckPermission(51, 4); ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper){
			$this->view->notificationid =0;
			$this->view->val = 0; 
        $this->view->render('employee/grievance/addeditnotification');
		}else{
			header('location: ' . URL . 'employee/grievance');
		}
    }
	function editgrievance($id)
    {		
		$editper = $this->CheckPermission(51, 2); ///////// CHECK FOR EDIT PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->notificationid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/grievance/viewgrievance');
		}else{
			header('location: ' . URL . 'employee/grievance');
		}
    }
	
	function viewgrievance($id,$val)
    {
		$viewper = $this->CheckPermission(19, 1); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($viewper)  && ($val==1) || ($val==2) || ($val==3) )
		{
			//$employee = $this->loadModel('Employee');
			$this->view->notificationid = Utils::decode5t($id); 
			$this->view->val = $val; 
			$this->view->render('employee/grievance/viewgrievance');
		}else{
			header('location: ' . URL . 'employee/grievance');
		}
    }
	
	function getagrievance()
	{
		
			$gid = $_POST['notificationid'];
			$notification = $this->loadModel('Grievance');
			$notificationarray = $notification->getDetail($gid);
			echo json_encode($notificationarray);
			
	}
	function creategrievance()
	{
			

		$addper = $this->CheckPermission(51, 4);   ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['notificationname'];
			$arr[3] = $_POST['message'];
			$arr[4] = $_POST['employeeids'];
			$arr[5] = $_POST['priority'];
			$arr[6] = $_POST['appsts'];
			
					
			$dept = $this->loadModel('Grievance');
			$deptarray = $dept->CreateGrievance($arr);
			echo json_encode($deptarray);		
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}
	
	 /**
     * Functions for perfom operation on notification table
     * delete function from notification list
	 * @returning json array of data as result
     */
	 
	 function updatedgrievance()
	{
		$editper = $this->CheckPermission(51, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['notificationname'];
			$arr[3] = $_POST['message'];
			$arr[4] = $_POST['priority'];
			$arr[5] = $_POST['employeeids'];
			$arr[7] = $_POST['appsts'];
			$arr[6] = $_POST['notificationid'];
			$dept = $this->loadModel('Grievance');
			$deptarray = $dept->UpdateGrievance($arr);
			echo json_encode($deptarray);				
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}	
	}
	
	function grievanceapproval()
	{
		$editper = $this->CheckPermission(51, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['notificationid'];
			$arr[3] = $_POST['comments'];
			$arr[4] = $_POST['forwardto'];
			$arr[5] = $_POST['type'];
			
			$dept = $this->loadModel('Grievance');
			$deptarray = $dept->UpdateGrievanceApproval($arr);
			echo json_encode($deptarray);				
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}	
	}
	
	
	function getGrievanceData()
	{
		$editper = $this->CheckPermission(51, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(51, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$notification = $this->loadModel('Grievance');
		$notificationarray = $notification->getGrievanceTable($editper, $deleteper);
		echo json_encode($notificationarray);
		
	}
	function deletegrievance($did)
	{
		$deleteper = $this->CheckPermission(51, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Grievance');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'employee/grievance');
	}
	//////////////////////////GRIEVANCE CONTROLLER FUNCTION ENDS HERE///////////////////////
	
	
	//////////////////////////NEW JOINING CONTROLLER FUNCTION ENDS HERE///////////////////////
	//////////////////////////////for importing new  employee list//////////
	
	function importheadersfile()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Employee');
			$deptarray = $dept->getFileHeaders($arr);
			echo json_encode($deptarray);	
		
		
	}
	function insertheaders()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['emp_fname'];
			$arr[3] = $_POST['emp_lname'];
			$arr[4] = $_POST['emp_dob'];
			$arr[5] = $_POST['emp_nationality'];
			$arr[6] = $_POST['emp_maritalstatus'];
			$arr[7] = $_POST['emp_religion'];
			$arr[8] = $_POST['emp_bloodgroup'];
			$arr[9] = $_POST['emp_doj'];
			$arr[10] = $_POST['emp_doc'];
			$arr[11] = $_POST['emp_gender'];
			$arr[12] = $_POST['emp_contact_no'];
			$arr[13] = $_POST['emp_email'];
			$arr[14]= $_POST['emp_address'];
			$arr[15] = $_POST['emp_city'];
			$arr[16] = $_POST['emp_country'];
			$arr[17] = $_POST['emp_zipcode'];
			$arr[18] = $_POST['emp_mname'];
			$arr[19] = $_POST['emp_ctc'];
			
			$dept = $this->loadModel('Employee');
			$deptarray = $dept->insertFileHeaders($arr);
			echo json_encode($deptarray);	
		
		
	}
	function onboard_company_details($emp)
    {	
		//$emp=$_POST['employeeid'];
		if(isset($emp)){
			$this->view->employeeid = Utils::decode5t($emp);
			$this->view->render('employee/onboard_company_details');
		}else{
			header('location: ' . URL . 'employee/onboard_employee_list');
		}
    }
	
	function onboard_company_details1($emp)
    {	
		//$emp=$_POST['employeeid'];
		if(($emp !=0)){
			$this->view->employeeid = $emp;
			$this->view->render('employee/onboard_company_details');
		}else{
			header('location: ' . URL . 'employee/onboard_employee_list');
		}
    }
	
	
	function getallnewemployee()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$employee = $this->loadModel('Employee');
			$employeearray = $employee->getAllNewEmployee($arr);
			echo json_encode($employeearray);		
		
	}
	
	function getnewjoineechecklist()
	{
		$empid= 0;
		$role = $this->loadModel('Employee');
		$rolearray = $role->getEmployeeChecklist($empid);
		echo json_encode($rolearray);
	}
	
	function getNewEmployeeData()
	{
		$editper = $this->CheckPermission(19, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(19, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$employee = $this->loadModel('Employee');
		$employeearray = $employee->getNewEmployeeDataTable($editper, $deleteper);
		echo json_encode($employeearray);
	}
	function createNewemployee()
	{
		$addper = $this->CheckPermission(19, 4);   ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper)
		{
			
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['emp_report_to'];
			$arr[3] = $_POST['emp_division'];
			$arr[4] = $_POST['emp_depart'];
			$arr[5] = $_POST['emp_desig'];
			$arr[6] = $_POST['emp_location'];
			$arr[7] = $_POST['emp_shift'];
			$arr[8] = $_POST['emp_sts'];
			$arr[9] = $_POST['emp_grade'];
			$arr[10] = $_POST['emp_workdays'];
			$arr[11] = $_POST['salaryctc'];
			$arr[12] = $_POST['employeeid'];
			$arr[13] = $_POST['emp_type'];
			$arr[14] = $_POST['emp_doj'];
			$arr[15] = $_POST['emp_role'];
			$arr[16] = $_POST['probation'];
			try{
			$dept = $this->loadModel('Employee');
			$deptarray = $dept->CreateNew($arr);
			echo json_encode($deptarray);
			}catch(Exception $e){
				echo $e->getMessage();
			}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	function deletenewemployee($did)
	{
		$deleteper = $this->CheckPermission(19, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Employee');
			$deptarray = $dept->DeletenewEmp($did);
		}
		header('location: ' . URL . 'employee/onboard_employee_list');
	}
		
	
	
	 /**
     * Functions for perfom operation on employee table
     * delete function from employee list
	 * @returning json array of data as result
     */
	 
	 
	 
	
	
///////////////////////////// Employment Type CONTROLLER FUNCTION STARTS HERE////////////////
	
     /* Functions for perfom operation on visa table
     * getall function fetching visa list
	 * @returning json array of data as result
     */
	
	function creditcard()
    {
		$viewper = $this->CheckPermission(59, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(59, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/creditcard/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addcreditcard()
    {
		$addper = $this->CheckPermission(59, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->creditcardid =0;
			$this->view->val = 0; 
			$this->view->render('employee/creditcard/addeditcreditcard');
		}else{
			header('location: ' . URL . 'employee/creditcard');
		}
    }
	
	function editcreditcard($id)
    {
		$editper = $this->CheckPermission(59, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->creditcardid = $id; //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/creditcard/addeditcreditcard');
		}else{
			header('location: ' . URL . 'employee/creditcard');
		}
    }
	
	function getallcreditcard()
	{
		
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$creditcard = $this->loadModel('Creditcard');
			$creditcardarray = $creditcard->getAll($arr);
			echo json_encode($creditcardarray);
	
		
	}
	
	function getacreditcard()
	{
		$viewper = $this->CheckPermission(59, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['creditcardid'];
			$creditcard = $this->loadModel('Creditcard');
			$creditcardarray = $creditcard->getDetail($gid);
			echo json_encode($creditcardarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on creditcard table
     * getall function fetching creditcard list
	 * @returning json array of data as result
     */
	function createcreditcard()
	{	
		$addper = $this->CheckPermission(59, 4);  ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['creditcardname'];
					
			$dept = $this->loadModel('Creditcard');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}
	
	 /**
     * Functions for perfom operation on creditcard table
     * delete function from creditcard list
	 * @returning json array of data as result
     */
	 
	 function updatedecreditcard()
	{
		$editper = $this->CheckPermission(59, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['creditcardname'];
			$arr[3] = $_POST['creditcardid'];
			
			$dept = $this->loadModel('Creditcard');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletecreditcard($did)
	{
		$deleteper = $this->CheckPermission(59, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Creditcard');
			$deptarray = $dept->Delete($did);
		}
		header('location: ' . URL . 'employee/creditcard');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCreditcardData()
	{
		$editper = $this->CheckPermission(59, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(59, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$creditcard = $this->loadModel('Creditcard');
		$creditcardarray = $creditcard->getDataTable($editper, $deleteper);
		echo json_encode($creditcardarray);
	}
	
	
	
	 									
	 ///////////////////////////// CREDITCARD CONTROLLER FUNCTION ENDS HERE ////////////////////////////	
	
	///////////////////////////// RELATION  CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
    /* Functions for perfom operation on visa table
     * getall function fetching visa list
	 * @returning json array of data as result
     */
	
	function relation()
    {
		$viewper = $this->CheckPermission(56, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(56, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/relation/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addrelation()
    {
		$addper = $this->CheckPermission(56, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->relationid =0;
			$this->view->val = 0; 
			$this->view->render('employee/relation/addeditrelation');
		}else{
			header('location: ' . URL . 'employee/relation');
		}
    }
	
	function editrelation($id)
    {
		$editper = $this->CheckPermission(56, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->relationid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/relation/addeditrelation');
		}else{
			header('location: ' . URL . 'employee/relation');
		}
    }
	
	function viewrelation($id,$val)
    {
		
		if(isset($id)  && isset($val) )
		{
			
			$this->view->val = $val; 
			$this->view->relationid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/relation/addeditrelation');
		}else{
			header('location: ' . URL . 'employee/relation');
		}
		
    }
	function getallrelation()
	{
		
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$relation = $this->loadModel('Relation');
			$relationarray = $relation->getAll($arr);
			echo json_encode($relationarray);
	
		
	}
	
	function getarelation()
	{
		$viewper = $this->CheckPermission(56, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['relationid'];
			$relation = $this->loadModel('Relation');
			$relationarray = $relation->getDetail($gid);
			echo json_encode($relationarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on relation table
     * getall function fetching relation list
	 * @returning json array of data as result
     */
	function createrelation()
	{	
		$addper = $this->CheckPermission(56, 4);  ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['relationname'];
					
			$dept = $this->loadModel('Relation');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}
	
	 /**
     * Functions for perfom operation on relation table
     * delete function from relation list
	 * @returning json array of data as result
     */
	 
	 function updatederelation()
	{
		$editper = $this->CheckPermission(56, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['relationname'];
			$arr[3] = $_POST['relationid'];
			
			$dept = $this->loadModel('Relation');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleterelation($did)
	{
		$deleteper = $this->CheckPermission(56, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Relation');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/relation');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getRelationData()
	{
		$editper = $this->CheckPermission(56, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(56, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$relation = $this->loadModel('Relation');
		$relationarray = $relation->getDataTable($editper, $deleteper);
		echo json_encode($relationarray);
	}
	
	
	
	 									
	 ///////////////////////////// BANK CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	function bank()
    {
		$viewper = $this->CheckPermission(57, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(57, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/bank/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addbank()
    {
		$addper = $this->CheckPermission(57, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->bankid =0;
			$this->view->val = 0; 
			$this->view->render('employee/bank/addeditbank');
		}else{
			header('location: ' . URL . 'employee/bank');
		}
    }
	
	function editbank($id)
    {
		$editper = $this->CheckPermission(57, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->bankid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/bank/addeditbank');
		}else{
			header('location: ' . URL . 'employee/bank');
		}
    }
	
	function viewbank($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->bankid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/bank/addeditbank');
		}else{
			header('location: ' . URL . 'employee/bank');
		}
		
    }
	
	function getallbank()
	{
		
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$bank = $this->loadModel('Bank');
			$bankarray = $bank->getAll($arr);
			echo json_encode($bankarray);
	
		
	}
	
	function getabank()
	{
		$viewper = $this->CheckPermission(57, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['bankid'];
			$bank = $this->loadModel('Bank');
			$bankarray = $bank->getDetail($gid);
			echo json_encode($bankarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on bank table
     * getall function fetching bank list
	 * @returning json array of data as result
     */
	function createbank()
	{	
		$addper = $this->CheckPermission(57, 4);  ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['bankname'];
			$arr[3] = $_POST['bank_desc'];
			$arr[4] = $_POST['bankcode'];		
			$arr[5] = $_POST['agent_id'];		
			$dept = $this->loadModel('Bank');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}
	
	 /**
     * Functions for perfom operation on bank table
     * delete function from bank list
	 * @returning json array of data as result
     */
	 
	 function updatedebank()
	{
		$editper = $this->CheckPermission(57, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['bankname'];
			$arr[3] = $_POST['bankid'];
			$arr[4] = $_POST['bank_desc'];
			$arr[5] = $_POST['bankcode'];	
			$arr[6] = $_POST['agent_id'];		
			$dept = $this->loadModel('Bank');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletebank($did)
	{
		$deleteper = $this->CheckPermission(57, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Bank');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/bank');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getBankData()
	{
		$editper = $this->CheckPermission(57, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(57, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$bank = $this->loadModel('Bank');
		$bankarray = $bank->getDataTable($editper, $deleteper);
		echo json_encode($bankarray);
	}
	////////////////////////////BANK CONTROLLER ENDS HERE///////////////
	
	 ///////////////////////////// INSURANCE CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	function insurance()
    {
		$viewper = $this->CheckPermission(58, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(58, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/insurance/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addinsurance()
    {
		$addper = $this->CheckPermission(58, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->insuranceid =0;
			$this->view->val = 0; 
			$this->view->render('employee/insurance/addeditinsurance');
		}else{
			header('location: ' . URL . 'employee/insurance');
		}
    }
	
	function editinsurance($id)
    {
		$editper = $this->CheckPermission(58, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->insuranceid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/insurance/addeditinsurance');
		}else{
			header('location: ' . URL . 'employee/insurance');
		}
    }
	
	function viewinsurance($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->insuranceid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/insurance/addeditinsurance');
		}else{
			header('location: ' . URL . 'employee/insurance');
		}
		
    }
	
	function getallinsurance()
	{
		
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$insurance = $this->loadModel('Insurance');
			$insurancearray = $insurance->getAll($arr);
			echo json_encode($insurancearray);
	
		
	}
	
	function getainsurance()
	{
		$viewper = $this->CheckPermission(58, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['insuranceid'];
			$insurance = $this->loadModel('Insurance');
			$insurancearray = $insurance->getDetail($gid);
			echo json_encode($insurancearray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on insurance table
     * getall function fetching insurance list
	 * @returning json array of data as result
     */
	function createinsurance()
	{	
		$addper = $this->CheckPermission(58, 4);  ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['insurancename'];
			$arr[3] = $_POST['insurance_desc'];
					
			$dept = $this->loadModel('Insurance');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}
	
	 /**
     * Functions for perfom operation on insurance table
     * delete function from insurance list
	 * @returning json array of data as result
     */
	 
	 function updatedeinsurance()
	{
		$editper = $this->CheckPermission(58, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['insurancename'];
			$arr[3] = $_POST['insuranceid'];
			$arr[4] = $_POST['insurance_desc'];
			
			$dept = $this->loadModel('Insurance');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteinsurance($did)
	{
		$deleteper = $this->CheckPermission(58, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Insurance');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/insurance');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getInsuranceData()
	{
		$editper = $this->CheckPermission(58, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(58, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$insurance = $this->loadModel('Insurance');
		$insurancearray = $insurance->getDataTable($editper, $deleteper);
		echo json_encode($insurancearray);
	}
	
	
	/** 
	 									
	 ////////////////////////////  INSURANCE CONTROLLER ENDS HERE///////////////
	
	 ////////////////////////////  REPORT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on report table
     * getall function fetching report list
	 * @returning json array of data as result
     */
	
	function report()
    {
		$viewper = $this->CheckPermission(60, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(60, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/reports/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addreport()
    {
		$addper = $this->CheckPermission(60, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->reportid =0;
			$this->view->val = 0; 
			$this->view->render('employee/reports/addeditreport');
		}else{
			header('location: ' . URL . 'employee/report');
		}
    }
	
	function editreport($id)
    {
		$editper = $this->CheckPermission(60, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->reportid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/reports/addeditreport');
		}else{
			header('location: ' . URL . 'employee/report');
		}
		
    }
	
	function viewreport1($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->val = $val; 
			$this->view->render('employee/reports/addeditreport');
		}else{
			header('location: ' . URL . 'employee/report');
		}
		
    }
	function viewreport($id)
    {
		
		if(isset($id) )
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->render('employee/reports/viewreport');
		}else{
			header('location: ' . URL . 'employee/report');
		}
		
    }
	function divisionwisereport($val)
	{
		try{
			$deptarray=array();
			$dept = $this->loadModel('Report');
			
			$deptarray = $dept->JobModificationReport($val);
			
			echo json_encode($deptarray);
		}catch(Exception $e) {
			echo $e->getMessage();
		}
	}
	function viewcustomreport($id,$val)
    {
		
		if(isset($id) && isset($val))
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->val = $val;
			$this->view->render('employee/reports/jobmodificationreport');
		}else{
			header('location: ' . URL . 'employee/report');
		}
		
    }
	
	function deletereport($did)
	{
		$deleteper = $this->CheckPermission(69, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Report');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'employee/report');
	}
	
	
	function getReportData()
	{
		$editper = $this->CheckPermission(60, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(60, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$tabid=1;
		$report = $this->loadModel('Report');
		$reportarray = $report->getDataTable($editper, $deleteper,$tabid);
		echo json_encode($reportarray);
	}
	
	function getmodules()
	{
		$permission = $this->loadModel('Permission');
		$perarray = $permission->getModules();
		echo json_encode($perarray);	
	}
	
	function getcolumnname()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['tablename'];
		$dept = $this->loadModel('Report');
		$deptarray = $dept->getAllColumnName($arr);
		echo json_encode($deptarray);	
	}
	
	
	function importfiledata()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['tablename'];
		//$dept = $this->loadModel('Employee');
		$dept = $this->loadModel('ImportExport');
		$deptarray = $dept->importfiledata($arr);
		echo json_encode($deptarray);	
	}
	
	function getcolumnvalues()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['tablename'];
			$arr[3] = $_POST['columnname'];
			$dept = $this->loadModel('Report');
			$deptarray = $dept->getAllColumnValue($arr);
			echo json_encode($deptarray);	
		
		
	}
	
	function setdefaultbank()
	{
		
			$arr = array();
			$arr[0] = $_POST['empbankid'];
			$arr[1] = $_POST['emp_id'];
			$dept = $this->loadModel('Employee');
			$deptarray = $dept->setdefaultbank($arr);
			echo json_encode($deptarray);	
	}
	
	
	/** 
	
	 ////////////////////////////  OFFICE LETTER CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on report table
     * getall function fetching report list
	 * @returning json array of data as result
     */
	
	function officialcommunication()
    {
		$viewper = $this->CheckPermission(71, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(71, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/officialcommunication/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	
	function previewofficialcommunication()
    {
		$viewper = $this->CheckPermission(71, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			
			$this->view->addper =$addper;
			$this->view->render('employee/officialcommunication/preview');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addofficialcommunication()
    {
		$addper = $this->CheckPermission(71, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->officialcommunicationid =0;
			$this->view->val = 0; 
			$this->view->render('employee/officialcommunication/addeditofficialcommunication');
		}else{
			header('location: ' . URL . 'employee/officialcommunication');
		}
    }
	
	function editofficialcommunication($id)
    {
		$editper = $this->CheckPermission(71, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->officialcommunicationid = $id; //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/officialcommunication/addeditofficialcommunication');
		}else{
			header('location: ' . URL . 'employee/officialcommunication');
		}
		
    }
	
	
	function viewofficialcommunication($id)
    {
		
		if(isset($id) )
		{
			$this->view->officialcommunicationid = $id; 
			$this->view->val = 0; 
			$this->view->render('employee/officialcommunication/preview');
		}else{
			header('location: ' . URL . 'employee/officialcommunication');
		}
		
    }
	
	function getallofficialcommunication()
	{
		$viewper = $this->CheckPermission(71, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$officialcommunication = $this->loadModel('OfficialCommunication');
			$officialcommunicationarray = $officialcommunication->getAll($arr);
			echo json_encode($officialcommunicationarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getaofficialcommunication()
	{
		$viewper = $this->CheckPermission(71, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['officialcommunicationid'];
			$officialcommunication = $this->loadModel('OfficialCommunication');
			$officialcommunicationarray = $officialcommunication->getDetail($gid);
			echo json_encode($officialcommunicationarray);		
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	function getempofficialcommunication()
	{
		$viewper = $this->CheckPermission(71, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['officialcommunicationid'];
			$officialcommunication = $this->loadModel('OfficialCommunication');
			$officialcommunicationarray = $officialcommunication->getLetter($gid);
			echo json_encode($officialcommunicationarray);		
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getemployeecertificatedata()
	{
		
			$gid = $_POST['empid'];
			$officialcommunication = $this->loadModel('OfficialCommunication');
			$officialcommunicationarray = $officialcommunication->getEmployeeData($gid);
			echo json_encode($officialcommunicationarray);		
	
		
	}
	
	/** 
     * Functions for perfom operation on officialcommunication table
     * getall function fetching officialcommunication list
	 * @returning json array of data as result
     */
		function createofficialcommunication()
	{
		$addper = $this->CheckPermission(71, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['officialcommunicationname'];
			$arr[3] = $_POST['desc'];
			$arr[4] = is_array($_POST['employeeid'])?implode(",",$_POST['employeeid']):$_POST['employeeid'];
			$arr[5] = $_POST['seniorsts'];
			$arr[6] = $_POST['certificateid'];
			$arr[7] = $_POST['mailsts'];
			$arr[8] = $_POST['emp_mail'];
		//	$arr[8] = $_POST['attachfile'];
			
			$dept = $this->loadModel('OfficialCommunication');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);
			}
			catch(Exception $ex)
			{}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on officialcommunication table
     * delete function from officialcommunication list
	 * @returning json array of data as result
     */
	 function uploadofficialcommunicationfile()
	{	
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]=$_POST['emp_id'];	
		//	$arr[3]=$_POST['letterid'];	
			//$arr[3]=$_POST['doc_id'];	
			//$arr[4]=$doctype;				
			$employee = $this->loadModel('officialcommunication');
			$employeearray = $employee->uploadDocument($arr);
			echo json_encode($employeearray);
		}catch(Exception $ex)
			{}
		
	}
	function updatedofficialcommunication()
	{
		$editper = $this->CheckPermission(71, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['officialcommunicationname'];
			$arr[3] = $_POST['desc'];
			$arr[4] = is_array($_POST['employeeid'])?implode(",",$_POST['employeeid']):$_POST['employeeid'];
			$arr[5] = $_POST['officialcommunicationid'];
			$arr[6] = $_POST['seniorsts'];
			$arr[7] = $_POST['attachfile'];
			$dept = $this->loadModel('OfficialCommunication');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteofficialcommunication($did)
	{
		$deleteper = $this->CheckPermission(71, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('OfficialCommunication');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);
		}	
		//header('location: ' . URL . 'employee/officialcommunication');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getOfficialCommunicationData()
	{
		$editper = $this->CheckPermission(71, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(71, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		try{
		$officialcommunication = $this->loadModel('OfficialCommunication');
		$officialcommunicationarray = $officialcommunication->getDataTable($editper, $deleteper);
		echo json_encode($officialcommunicationarray);
		}catch(Exception $e){
			
		}
	}
	 ///////////////////////////// SEVERANCE CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	function severance()
    {
		$viewper = $this->CheckPermission(126, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(126, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/severance/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addseverance($empid=0)
    {
		$addper = $this->CheckPermission(126, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->severanceid =0;
			$this->view->val = 0; 
			$this->view->empid =$empid; 
			$this->view->render('employee/severance/addeditseverance');
		}else{
			header('location: ' . URL . 'employee/severance');
		}
    }
	
	function editseverance($id)
    {
		$editper = $this->CheckPermission(126, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->severanceid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->empid =0; 
			$this->view->render('employee/severance/addeditseverance');
		}else{
			header('location: ' . URL . 'employee/severance');
		}
    }
	
	function viewseverance($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->severanceid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/severance/viewseverance');
		}else{
			header('location: ' . URL . 'employee/severance');
		}
		
    }
	
	
	function editseveranceapproval($id)
    {
		
		if(isset($id) )
		{
			
			$this->view->val = 0; 
			$this->view->severanceid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/severance/viewseverance');
		}else{
			header('location: ' . URL . 'employee/severance');
		}
		
    }
	
	function getTurnoverreasons()
	{
		$employee = $this->loadModel('Severance');
		$emparray = $employee->getTurnoverreason();
		echo json_encode($emparray);
	}
	
	function getallseverance()
	{
		
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$severance = $this->loadModel('Severance');
			$severancearray = $severance->getAll($arr);
			echo json_encode($severancearray);
	
		
	}
	
	function getaseverance()
	{
		$viewper = $this->CheckPermission(126, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['severanceid'];
			$severance = $this->loadModel('Severance');
			$severancearray = $severance->getDetail($gid);
			echo json_encode($severancearray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getseveranceempstatus()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$empstatus = $this->loadModel('Severance');
			$empstatusarray = $empstatus->getSeverancests($arr);
			echo json_encode($empstatusarray);	
			
		
	}
	function getresignationdetails()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$empstatus = $this->loadModel('Severance');
			$empstatusarray = $empstatus->getResignationDetail($arr);
			echo json_encode($empstatusarray);	
			
		
	}
	 function uploadEmployeeLetter()
	{	
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]=$_POST['emp_id'];			
			$employee = $this->loadModel('Severance');
			$employeearray = $employee->uploadImage($arr);
			echo json_encode($employeearray);
			
		
	}
	/** 
     * Functions for perfom operation on severance table
     * getall function fetching severance list
	 * @returning json array of data as result
     */
	function createseverance()
	{	
		$addper = $this->CheckPermission(126, 4);  ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['empid'];
			$arr[3] = $_POST['applyfrom'];
			$arr[4] = $_POST['noticeperiod'];	
			$arr[5] = $_POST['subject'];	
			$arr[6] = $_POST['message'];	
			$arr[7] = $_POST['empstatus'];	
			$arr[8] = $_POST['turnoverreason'];	
			try{
			$dept = $this->loadModel('Severance');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
}catch(Exception $e) {
				
				echo $e->getMessage();
			}		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}
	
	function createresigned()
	{	
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['message'];	
		$arr[3] = $_POST['noticeperiod'];	
		$arr[4] = $_POST['lastworkday'];	
		$arr[5] = $_POST['reason'];	
		
		$dept = $this->loadModel('Severance');
		$deptarray = $dept->CreateResigned($arr);
		echo json_encode($deptarray);	

	}
	
	function createterminated()
	{	
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['message'];
		$arr[3] = $_POST['empid'];
		$arr[4] = $_POST['terminatedate'];
		
		$dept = $this->loadModel('Severance');
		$deptarray = $dept->CreateTerminated($arr);
		echo json_encode($deptarray);	

	}
	
	function withdrawresignation()
	{	
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['severanid'];
		
		$dept = $this->loadModel('Severance');
		$deptarray = $dept->WithdrawResignation($arr);
		echo json_encode($deptarray);	

	}
	
	function fetchlastworkingdate()
	{	
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['severandate'];
		$arr[3] = $_POST['type'];
		
		$dept = $this->loadModel('Severance');
		$deptarray = $dept->getLastWorkingDate($arr);
		echo json_encode($deptarray);	

	}
	
	function changeseverancests()
	{	
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['severanceid'];
		$arr[3] = $_POST['severansts'];
		$arr[4] = $_POST['comments'];
		$arr[5] = $_POST['empid'];
		$arr[6] = $_POST['lastworkingday'];
		
		$dept = $this->loadModel('Severance');
		$deptarray = $dept->ChangeStatus($arr);
		echo json_encode($deptarray);	
		}catch(Exception $e){echo $e->getMessage();}

	}
	
	 /**
     * Functions for perfom operation on severance table
     * delete function from severance list
	 * @returning json array of data as result
     */
	 
	 function updatedeseverance()
	{
		$editper = $this->CheckPermission(126, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['empid'];
			$arr[3] = $_POST['applyfrom'];
			$arr[4] = $_POST['noticeperiod'];	
			$arr[5] = $_POST['subject'];	
			$arr[6] = $_POST['message'];
			$arr[7] = $_POST['severanceid'];
			$arr[8] = $_POST['empstatus'];
			$arr[9] = $_POST['turnoverreason'];	
			$dept = $this->loadModel('Severance');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteseverance($did)
	{
		$deleteper = $this->CheckPermission(126, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Severance');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/severance');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getSeveranceData()
	{
		$editper = $this->CheckPermission(126, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(126, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		try{
		$severance = $this->loadModel('Severance');
		$severancearray = $severance->getDataTable($editper, $deleteper);
		echo json_encode($severancearray);
		}catch(Exception $e){
		
		echo $e->getMessage();}
	}
	////////////////////////////SEVERANCE CONTROLLER ENDS HERE///////////////
	
	 ///////////////////////////// JOB MODIFICATION CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	function jobmodification($id)
    {
		$per=($id==2)?114:(($id==3)?115:116);
		$viewper = $this->CheckPermission($per, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper && isset($id) && $id>=2 && $id<=4){
			$addper = $this->CheckPermission($per, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->modtype =$id;
			$this->view->render('employee/jobmodification/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	
	function addjobmodification($id)
    {
		$per=($id==2)?114:(($id==3)?115:116);
		$addper = $this->CheckPermission($per, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper && isset($id)  && $id>=2 && $id<=4){
			$this->view->jobmodificationid =0;
			$this->view->val = 0; 
			$this->view->modtype =$id;
			$this->view->render('employee/jobmodification/addeditjobmodification');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	
	function editjobmodification($id, $type,$newval=0)
    {
		$per=($type==2)?114:(($type==3)?115:116);
		$editper = $this->CheckPermission($per, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper) && isset($type) && $type>=2 && $type<=4)
		{
			$this->view->jobmodificationid =Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->newval = $newval;
			$this->view->modtype =$type;
			$this->view->render('employee/jobmodification/viewjobmodification');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function getalljobmodificationapprover()
	{try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['jobmodificationid'];
			$leavetype = $this->loadModel('Leaveapproval');
			$leavetypearray = $leavetype->getAlljobmodificationApprover($arr);
			
			echo json_encode($leavetypearray);	
	}catch(Exception $e){}
	}
	function approvejobmodiapproval()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['jobmodificationid'];
			$arr[3] = $_POST['approverresult'];
			$arr[4] = $_POST['comment'];
			$dept = $this->loadModel('Leaveapproval');
			$deptarray = $dept->ApproveJobmodification($arr);
			echo json_encode($deptarray);	
		
	}
	
	function viewjobmodification($id,$val)
    {try{
		$per=($val==2)?114:(($val==3)?115:116);
		$viewper = $this->CheckPermission($per, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if(isset($id)  && isset($val) && $viewper)
		{
			$this->view->val = $val; 
			$this->view->jobmodificationid = Utils::decode5t($id); //$dept->getDetail($id);
			//$this->view->modtype =$type;
			$this->view->render('employee/jobmodification/viewjobmodification');
		}else{
			header('location: ' . URL . 'employee/index');
		}
	}catch(Exception $e){}
    }
	
	function getalljobmodification()
	{
		
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$jobmodification = $this->loadModel('Jobmodification');
			$jobmodificationarray = $jobmodification->getAll($arr);
			echo json_encode($jobmodificationarray);
	
		
	}
	
	function getajobmodification()
	{
		$per=(($_POST['modtype'])==2)?114:((($_POST['modtype'])==3)?115:116);
		$viewper = $this->CheckPermission($per, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['jobmodificationid'];
			$jobmodification = $this->loadModel('Jobmodification');
			$jobmodificationarray = $jobmodification->getDetail($gid);
			echo json_encode($jobmodificationarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on jobmodification table
     * getall function fetching jobmodification list
	 * @returning json array of data as result
     */
	function createjobmodification()
	{	
		$per=(($_POST['modtype'])==2)?114:((($_POST['modtype'])==3)?115:116);
		$addper = $this->CheckPermission($per, 4);  ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['empid'];
			$arr[3] = $_POST['modtype'];
			$arr[4] = $_POST['applyfrom'];		
			$arr[5] = $_POST['remarks'];		
			$arr[6] = $_POST['promotiontype'];		
			$dept = $this->loadModel('Jobmodification');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}
	
	 /**
     * Functions for perfom operation on jobmodification table
     * delete function from jobmodification list
	 * @returning json array of data as result
     */
	 
	 function updatedejobmodification()
	{
		$per=(($_POST['modtype'])==2)?114:((($_POST['modtype'])==3)?115:116);
		$editper = $this->CheckPermission($per, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['empid'];
			$arr[3] = $_POST['modtype'];
			$arr[4] = $_POST['applyfrom'];
			$arr[5] = $_POST['jobmodificationid'];
			$arr[6] = $_POST['remarks'];		
			$dept = $this->loadModel('Jobmodification');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletejobmodification($did,$val=0)
	{
		$per=($val==2)?114:(($val==3)?115:116);
		$deleteper = $this->CheckPermission($per, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Jobmodification');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/jobmodification');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getJobmodificationData($id)
	{
		try{
		$per=($id==2)?114:(($id==3)?115:116);
		$editper = $this->CheckPermission($per, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission($per, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$jobmodification = $this->loadModel('Jobmodification');
		$jobmodificationarray = $jobmodification->getDataTable($editper, $deleteper, $id);
		echo json_encode($jobmodificationarray);
}
		catch(Exception $ex){}
			}
	////////////////////////////BANK CONTROLLER ENDS HERE///////////////
	/////////////////////document request controller///////////////
	function documentrequest($val)
    {
		
		$per=($val==1)?139:140;
		$viewper = $this->CheckPermission($per, 1); ///////// CHECK FOR VIEW PERMISSION FOR DOCUMNET RELEASE AND RETURN  ////////////
		if($viewper && isset($val)){
			$this->view->doctype =$val;
			$this->view->render('employee/documentrequest/index');
		}else{
			header('location: ' . URL . 'employee');
		}
    }
	
	function documentapproval()
    {
		$viewper = $this->CheckPermission(78, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		
		if($viewper )
		{
			$this->view->render('employee/documentapproval/index');
		}else{
			header('location: ' . URL . 'employee');
		}
    }
	function getDocumentRequestData($doctype)
	{  
		$per=($doctype==1)?139:140;
		
		$editper = $this->CheckPermission($per, 2);  ///////// CHECK FOR ADD PERMISSION  ////////////
		$deleteper = $this->CheckPermission($per, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$employeeleave = $this->loadModel('Documentrequest');
		$employeeleavearray = $employeeleave->getTableData($editper, $deleteper,$doctype);
		echo json_encode($employeeleavearray);
	}
	
	function documentrelease()
	{
		$per=(($_POST['val'])==1)?139:140;
		$editper = $this->CheckPermission($per, 2);  ///////// CHECK FOR ADD PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['documentrequestid'];
			$arr[3] = $_POST['approverresult'];
			$arr[4] = $_POST['releasedate'];
			$arr[5] = $_POST['val'];
			
			$dept = $this->loadModel('Documentrequest');
			$deptarray = $dept->Release($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	function getDocumentApprovalData()
	{    
		$editper = $this->CheckPermission(78, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(78, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$employeeleave = $this->loadModel('Documentrequest');
		$employeeleavearray = $employeeleave->getDataTable($editper, $deleteper);
		echo json_encode($employeeleavearray);
	}
	
	
	function adddocumentrequest()
	{
			$this->view->val =0; 
			$this->view->documentrequestid =0;
			$this->view->render('employee/documentrequest/addeditdocumentrequest');
		
    }
	function editdocumentrequest($id,$val)
    {	
		$per=($val==1)?139:140;
		$editper = $this->CheckPermission($per, 2);  ///////// CHECK FOR ADD PERMISSION  ////////////
		
		if(isset($id) && $editper)
		{
			$this->view->val = $val; 
			$this->view->val1 = 0; 
			$this->view->documentrequestid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/documentrequest/viewdocumentrequest');
		}else{
			header('location: ' . URL . 'employee/documentrequest');
		}
    }
	
	function editdocumentapproval($id)
    {	
		$editper = $this->CheckPermission(78, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
			
		if(isset($id) && $editper)
		{
			
			$this->view->val =0; 
			$this->view->documentapprovalid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/documentapproval/addeditdocumentapproval');
		}else{
			header('location: ' . URL . 'employee/documentapproval');
		}
    }
	
	function viewdocumentapproval($id, $val)
    {	
		$editper = $this->CheckPermission(78, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
			
		if(isset($id) && $editper && $val==1)
		{
			$this->view->val =$val; 
			$this->view->documentapprovalid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/documentapproval/addeditdocumentapproval');
		}else{
			header('location: ' . URL . 'employee/documentapproval');
		}
    }
	
	function documentapprovalresult()
	{
		$editper = $this->CheckPermission(78, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['documentapprovalid'];
			$arr[3] = $_POST['approverresult'];
			$arr[4] = $_POST['comment'];
			
			$dept = $this->loadModel('Documentrequest');
			$deptarray = $dept->Approve($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	function createdocumentrequest()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['releasefrom'];
			$arr[3] = $_POST['releaseto'];
			$arr[4] = $_POST['reason'];	
			$arr[5] = $_POST['requestdocid'];	
			$arr[6] = $_POST['employeeid'];
			$arr[7] = $_POST['appsts'];
			
						
			$documentrequest = $this->loadModel('Documentrequest');
			$documentrequestarray = $documentrequest->Create($arr);
			echo json_encode($documentrequestarray);		
	}
	function updatededocumentrequest()
	{
			$editper = $this->CheckPermission(78, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
			if($editper)
			{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['releasefrom'];
			$arr[3] = $_POST['releaseto'];
			$arr[4] = $_POST['reason'];	
			$arr[5] = $_POST['documentrequestid'];
			$arr[6] = $_POST['requestdocid'];
			$arr[7] = $_POST['appsts'];			
			$salaryhead = $this->loadModel('Documentrequest');
			$salaryheadarray = $salaryhead->Update($arr);
			echo json_encode($salaryheadarray);	
			}
			else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}	
	}
	
	function getalldocumentapprover()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['documentapprovalid'];
		$salaryhead = $this->loadModel('Documentrequest');
		$salaryheadarray = $salaryhead->getAllApprover($arr);
		echo json_encode($salaryheadarray);	
	}
	
	function getdocumentlist()
	{
		$arr = array();
		$arr[0] = $_POST['employeeid'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$salaryhead = $this->loadModel('Documentrequest');
		$salaryheadarray = $salaryhead->getEmployeeDocument($arr);
		echo json_encode($salaryheadarray);	
	}
	
	function viewdocumentrequest($id,$val1,$val)
    {
		try{
		$per=($val==1)?139:140;
		$viewper = $this->CheckPermission($per, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		
		if($viewper && isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->val1 = $val1; 
			$this->view->documentrequestid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/documentrequest/viewdocumentrequest');
		}else{
			header('location: ' . URL . 'employee');
		}
		}catch(Exception $e){
			echo $e->getMessage();
		}
		
    }
	
	function getadocumentrequest()
	{
		
		$id = $_POST['documentrequestid'];
		$salaryhead = $this->loadModel('Documentrequest');
		$salaryheadarray = $salaryhead->getDetail($id);
		echo json_encode($salaryheadarray);	
		
		
	}
	
	function deletedocumentrequest($did)
	{
		
		if(isset($did) )
		{
			$dept = $this->loadModel('Documentrequest');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'employee/documentrequest');
	}
	
	
	/** 
	 									
	 ///////////////////////////// DOCUMENT LIBRARY CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on document tracking table
     * getall function fetching visa list
	 * @returning json array of data as result
     */
	
	function companydoclibrary()
    {
		
		$viewper = $this->CheckPermission(15, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(15, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/doclibrary/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function empdoclibrary()
    {
		
		$viewper = $this->CheckPermission(16, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(16, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/doclibrary/empdoclib');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	
	function adddoclibrary()
    {
		$addper = $this->CheckPermission(15, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->documentid =0;
			$this->view->val = 0; 
			$this->view->render('employee/doclibrary/addeditdoclibrary');
		}else{
			header('location: ' . URL . 'employee/doclibrary');
		}
    }
	
	function editdoclibrary($id)
    {
		$editper = $this->CheckPermission(109, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->val = 0; 
			$this->view->doclibraryid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/doclibrary/addeditdoclibrary');
		}else{
			header('location: ' . URL . 'employee/doclibrary');
		}
    }
	
	function viewdoclibrary($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->doclibraryid =Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/doclibrary/addeditdoclibrary');
		}else{
			header('location: ' . URL . 'employee/doclibrary');
		}
		
    }
	function getalldoclibrary()
	{
		
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$doclibrary = $this->loadModel('DocLibrary');
			$doclibraryarray = $doclibrary->getAll($arr);
			echo json_encode($doclibraryarray);
	
		
	}
	
	function getadoclibrary()
	{
		$viewper = $this->CheckPermission(109, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['doclibraryid'];
			$doclibrary = $this->loadModel('DocLibrary');
			$doclibraryarray = $doclibrary->getDetail($gid);
			echo json_encode($doclibraryarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on doclibrary table
     * getall function fetching doclibrary list
	 * @returning json array of data as result
     */
	function createdoclibrary()
	{	
		$addper = $this->CheckPermission(109, 4);  ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['doclibraryname'];
			$arr[3] = $_POST['empid'];
			
			$dept = $this->loadModel('DocLibrary');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}
	
	 /**
     * Functions for perfom operation on doclibrary table
     * delete function from doclibrary list
	 * @returning json array of data as result
     */
	 
	 function updatededoclibrary()
	{
		$editper = $this->CheckPermission(109, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['doclibraryname'];
			$arr[3] = $_POST['doclibraryid'];
			$arr[4] = $_POST['empid'];
			
			$dept = $this->loadModel('DocLibrary');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletedoclibrary($did)
	{
		$deleteper = $this->CheckPermission(109, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('DocLibrary');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/doclibrary');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getDocLibraryData()
	{
		$editper = $this->CheckPermission(109, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(109, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$doclibrary = $this->loadModel('DocLibrary');
		$doclibraryarray = $doclibrary->getDataTable($editper, $deleteper);
		echo json_encode($doclibraryarray);
	}
	function getDocLibraryData1()
	{
		$editper = $this->CheckPermission(109, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(109, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$doclibrary = $this->loadModel('DocLibrary');
		$doclibraryarray = $doclibrary->getDataTable1($editper, $deleteper);
		echo json_encode($doclibraryarray);
	}
	
	
	 ///////////////////////////// RESIGNATION CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	function resignation()
    {
		$viewper = $this->CheckPermission(117, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(117, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/resignation/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	
	function addresignation()
    {
		$addper = $this->CheckPermission(117, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->resignationid =0;
			$this->view->val = 0; 
			$this->view->render('employee/resignation/addeditresignation');
		}else{
			header('location: ' . URL . 'employee/resignation');
		}
    }
	
	function editresignation($id)
    {
		$editper = $this->CheckPermission(117, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->resignationid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/resignation/addeditresignation');
		}else{
			header('location: ' . URL . 'employee/resignation');
		}
    }
	
	function viewresignation($id, $val)
    {
		$viewper = $this->CheckPermission(117, 1);
		if(isset($id) && isset($val) && $viewper)
		{
			$this->view->val = $val; 
			$this->view->resignationid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/resignation/addeditresignation');
		}else{
			header('location: ' . URL . 'employee/resignation');
		}
		
    }
	
	function getallresignation()
	{
		
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$resignation = $this->loadModel('Resignation');
			$resignationarray = $resignation->getAll($arr);
			echo json_encode($resignationarray);
	
		
	}
	
	function getaresignation()
	{
		$viewper = $this->CheckPermission(117, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['resignationid'];
			$resignation = $this->loadModel('Resignation');
			$resignationarray = $resignation->getDetail($gid);
			echo json_encode($resignationarray);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on jobmodification table
     * getall function fetching jobmodification list

	 * @returning json array of data as result
     */
	function createresignation()
	{	
		$addper = $this->CheckPermission(117, 4);  ///////// CHECK FOR ADD PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['empid'];
			$arr[3] = $_POST['modtype'];
			$arr[4] = $_POST['applyfrom'];		
			$arr[5] = $_POST['remarks'];		
			$dept = $this->loadModel('Resignation');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}
	
	 /**
     * Functions for perfom operation on jobmodification table
     * delete function from jobmodification list

	 * @returning json array of data as result
     */
	 
	 function updatedresignation()
	{
		$editper = $this->CheckPermission(117, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['startdate'];
			$arr[3] = $_POST['enddate'];
			$arr[4] = $_POST['sts'];
			$arr[5] = $_POST['resignationid'];
			$arr[6] = $_POST['comment'];
			$dept = $this->loadModel('Resignation');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}		
	}
	
	 /**

     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteresignation($did)
	{
		$deleteper = $this->CheckPermission(117, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Resignation');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/jobmodification');
	}
	
	
	/////////change status of employee resignation//////////
	
	function changeresignsts($id)
    {		
		if(isset($id))
		{
			$dept = $this->loadModel('Resignation');
			$deptarray = $dept->UpdateResignationSts($id);
			echo json_encode($deptarray);	
			
		}else{
			header('location: ' . URL . 'employee/resignation');
		}
		
    }
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result

     */
	function getResignationData()
	{
		$editper = $this->CheckPermission(117, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(117, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$resignation = $this->loadModel('Resignation');
		$resignationarray = $resignation->getDataTable($editper, $deleteper);
		echo json_encode($resignationarray);
	}
	
	/////////////////////////////////
	
	 ///////////////////////////// CERTIFICATE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perfom operation on document table
     * getall function fetching document list
	 * @returning json array of data as result
     */
	
	function certificate()
    {
		$viewper = $this->CheckPermission(135, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(135, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/certificate/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addcertificate()
    {
		$addper = $this->CheckPermission(135, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->certificateid =0;
			$this->view->val = 0; 
			$this->view->render('employee/certificate/addeditdocument');
		}else{
			header('location: ' . URL . 'employee/certificate');
		}
    }
	
	function editcertificate($id)
    {
		$editper = $this->CheckPermission(135, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->certificateid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/certificate/addeditdocument');
		}else{
			header('location: ' . URL . 'employee/certificate');
		}
		
    }
	function viewcertificate($id,$val)
    {
		$viewper = $this->CheckPermission(135, 1); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		
		if(isset($id)  && isset($val) && ($viewper))
		{
			
			$this->view->val = $val; 
			$this->view->certificateid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/certificate/addeditdocument');
		}else{
			header('location: ' . URL . 'employee/certificate');
		}
		
    }
	function getallcertificate()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$certificate = $this->loadModel('Certificate');
			$certificatearray = $certificate->getAll($arr);
			echo json_encode($certificatearray);		
			
		
	}
	
	function getacertificate()
	{
		
			$gid = $_POST['certificateid'];
			$certificate = $this->loadModel('Certificate');
			$certificatearray = $certificate->getDetail($gid);
			echo json_encode($certificatearray);	
		
			
	}
	
	/** 
     * Functions for perfom operation on certificate table
     * getall function fetching certificate list
	 * @returning json array of data as result
     */
	function createcertificate()
	{
		$addper = $this->CheckPermission(135, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['documentname'];
			$arr[3] = $_POST['documentcode'];
			$arr[4] = $_POST['desc'];
					
			$dept = $this->loadModel('Certificate');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}		
	}
	
	 /**
     * Functions for perfom operation on certificate table
     * delete function from certificate list
	 * @returning json array of data as result
     */
	 
	 function updatedecertificate()
	{
		$editper = $this->CheckPermission(135, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['documentname'];
			$arr[3] = $_POST['certificateid'];
			$arr[4] = $_POST['documentcode'];
			$arr[5] = $_POST['desc'];
			$arr[6] = $_POST['templateid'];
			$dept = $this->loadModel('Certificate');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletecertificate($did)
	{
		$deleteper = $this->CheckPermission(135, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Certificate');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/certificate');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCertificateData()
	{
		$editper = $this->CheckPermission(135, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(135, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$certificate = $this->loadModel('Certificate');
		$certificatearray = $certificate->getDataTable($editper, $deleteper);
		echo json_encode($certificatearray);
	}
	
	
	 									
	 ///////////////////////////// CERTIFICATE CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	 
	 ///////////////////////////// CERTIFICATE APPROVSL CONTROLLER FUNCTION STARTS HERE ////////////////////////////
	 
	function certificateapproval()
    {
		$viewper = $this->CheckPermission(137, 1);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($viewper){
			$this->view->render('employee/certificateapproval/index');
		}else{
			header('location: ' . URL . 'employee');
		}
    }
	
	function certificaterelease()
    {
		$viewper = $this->CheckPermission(146, 1);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($viewper){
			$this->view->render('employee/certificateapproval/certificaterelease');
		}else{
			header('location: ' . URL . 'employee');
		}
    }
	
	function getCertificateApprovalData()
	{    
		$editper = $this->CheckPermission(137, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(137, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		try{
		$employeeleave = $this->loadModel('Certificateapproval');
		$employeeleavearray = $employeeleave->getDataTable($editper, $deleteper);
		echo json_encode($employeeleavearray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	
	function getCertificateReleaseData()
	{    
		$editper = $this->CheckPermission(146, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(146, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		try{
		$employeeleave = $this->loadModel('Certificateapproval');
		$employeeleavearray = $employeeleave->getReleaseTable($editper, $deleteper);
		echo json_encode($employeeleavearray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	function editcertificateapproval($id)
    {	
		$editper = $this->CheckPermission(137, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
			
		if(isset($id) && $editper)
		{
			
			$this->view->val =0; 
			$this->view->certificateapprovalid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/certificateapproval/addeditcertificateapproval');
		}else{
			header('location: ' . URL . 'employee/certificateapproval');
		}
    }
	
	
	
	function viewcertificateapproval($id, $val)
    {	
		$viewper = $this->CheckPermission(137, 1);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
			
		if(isset($id) && $viewper && isset($val))
		{
			
			$this->view->val =$val; 
			$this->view->certificateapprovalid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/certificateapproval/addeditcertificateapproval');
		}else{
			header('location: ' . URL . 'employee/certificateapproval');
		}
    }
	
	function sendcertificateapproval($id)
    {	
		$editper = $this->CheckPermission(146, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
			
		if(isset($id) && $editper)
		{
			
			$this->view->val =0; 
			$this->view->certificateapprovalid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/certificateapproval/sendcertificate');
		}else{
			header('location: ' . URL . 'employee/certificateapproval');
		}
    }
	
	
	function certificateapprovalresult()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['certificateapprovalid'];
			$arr[3] = $_POST['approverresult'];
			$arr[4] = $_POST['comment'];
			
			$dept = $this->loadModel('Certificateapproval');
			$deptarray = $dept->Approve($arr);
			echo json_encode($deptarray);	
		
	}
	
	
	function getallcertificateapprover()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['certificateapprovalid'];
		$salaryhead = $this->loadModel('Certificateapproval');
		$salaryheadarray = $salaryhead->getAllApprover($arr);
		echo json_encode($salaryheadarray);	
	}
	
	function getacertificaterequest()
	{
		
		$id = $_POST['certificaterequestid'];
		$salaryhead = $this->loadModel('Certificateapproval');
		$salaryheadarray = $salaryhead->getDetail($id);
		echo json_encode($salaryheadarray);	
	}
	function deletecertificaterequest($did)
	{
		$deleteper = $this->CheckPermission(135, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Certificateapproval');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
		//header('location: ' . URL . 'employee/certificate');
	}
	function getcertificatedetails()
	{
		try{
		$id = $_POST['certificaterequestid'];
		$salaryhead = $this->loadModel('Certificateapproval');
		$salaryheadarray = $salaryhead->getCertificate($id);
		echo json_encode($salaryheadarray);	
		}catch(Exception $e) {
			echo 'Message: ' .$e->getMessage();
		}
	}
	
	
	///////////////////////////// EMPLYMENT TYPE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perfom operation on empstatus table
     * getall function fetching empstatus list
	 * @returning json array of data as result
     */
	
	function emptype()
    {
		$viewper = $this->CheckPermission(138, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(138, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/emptype/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function addemptype()
    {
		$addper = $this->CheckPermission(138, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->emptypeid =0;
			$this->view->val = 0; 
        $this->view->render('employee/emptype/addeditemptype');
		}else{
			header('location: ' . URL . 'employee/emptype');
		}
    }
	
	function editemptype($id)
    {
		$editper = $this->CheckPermission(138, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->emptypeid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/emptype/addeditemptype');
		}else{
			header('location: ' . URL . 'employee/emptype');
		}
    }
	
	function viewemptype($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->emptypeid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('employee/emptype/addeditemptype');
		}else{
			header('location: ' . URL . 'employee/emptype');
		}
		
    }
	
	function getallemptype()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$emptype = $this->loadModel('Emptype');
			$emptypearray = $emptype->getAll($arr);
			echo json_encode($emptypearray);	
			
		
	}
	
	function getaemptype()
	{
		$viewper = $this->CheckPermission(138, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['emptypeid'];
			$emptype = $this->loadModel('Emptype');
			$emptypearray = $emptype->getDetail($gid);
			echo json_encode($emptypearray);	
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on emptype table
     * getall function fetching emptype list
	 * @returning json array of data as result
     */
	function createemptype()
	{
		$addper = $this->CheckPermission(138, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['emptypename'];
			$arr[3] = $_POST['emptypecode'];
			
			$dept = $this->loadModel('Emptype');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on emptype table
     * delete function from emptype list
	 * @returning json array of data as result
     */
	 
	function updatedeemptype()
	{
		$editper = $this->CheckPermission(138, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['emptypename'];
			$arr[3] = $_POST['emptypeid'];
			$arr[4] = $_POST['emptypecode'];
			
			$dept = $this->loadModel('Emptype');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteemptype($did)
	{
		$deleteper = $this->CheckPermission(138, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Emptype');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'employee/emptype');
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getEmptypeData()
	{
		$editper = $this->CheckPermission(138, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(138, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$emptype = $this->loadModel('Emptype');
		$emptypearray = $emptype->getDataTable($editper, $deleteper);
		echo json_encode($emptypearray);
	}
	
		
	 									
	 /////////////////////////////  EMPLYMENT TYPE CONTROLLER FUNCTION ENDS HERE ////////////////////////////
	 
	 ////////////////////////////  DASHBOARD CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perform operation on report table
     * getall function fetching report list
	 * @returning json array of data as result
     */
	
	function dashboard()
    {
		$viewper = $this->CheckPermission(60, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(60, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('employee/dashboards/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function adddashboard()
    {
		$addper = $this->CheckPermission(60, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->dashboardid =0;
			$this->view->val = 0; 
			$this->view->render('employee/dashboards/addeditdashboard');
		}else{
			header('location: ' . URL . 'employee/dashboard');
		}
    }
	
	function editdashboard($id)
    {
		$editper = $this->CheckPermission(60, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->dashboardid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/dashboards/addeditdashboard');
		}else{
			header('location: ' . URL . 'employee/dashboard');
		}
		
    }
	
	function viewdashboard1($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->dashboardid = Utils::decode5t($id);
			$this->view->val = $val; 
			$this->view->render('employee/dashboards/addeditdashboard');
		}else{
			header('location: ' . URL . 'employee/dashboard');
		}
		
    }
	function viewdashboard($id)
    {
		
		if(isset($id) )
		{
			$this->view->dashboardid = Utils::decode5t($id);
			$this->view->render('employee/dashboards/viewdashboard');
		}else{
			header('location: ' . URL . 'employee/dashboard');
		}
		
    }
	
	
	function deletedashboard($did)
	{
		$deleteper = $this->CheckPermission(69, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Dashboard');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'employee/dashboard');
	}
	
	
	function getDashboardData()
	{
		$editper = $this->CheckPermission(60, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(60, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$tabid=1;
		$dashboard = $this->loadModel('Report');
		$dashboardarray = $dashboard->getDataTable($editper, $deleteper,$tabid);
		echo json_encode($dashboardarray);
	}
	
	function getDocType()
	{
		$viewper = $this->CheckPermission(57, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$doc = $this->loadModel('Other');
			$docarr = $doc->getAllOtherData();
			echo json_encode($docarr);			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
		
/*Start contoller for medical claim*/	
	function medicalclaim()
    {
		$viewper = $this->CheckPermission(276, 1);
		if($viewper)
		{
        $this->view->render('employee/medicalclaim/index');
		}else{
			header('location: ' . URL . 'employee/index');
		}
    }
	
	function approvemedicalclaim($id)
    {
		$viewper = $this->CheckPermission(276, 1);
		if($viewper)
		{
		$this->view->claimid = Utils::decode5t($id);
        $this->view->render('employee/medicalclaim/approvemedclaim');
		}
		else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function releasemedicalclaim($id)
    {
		$viewper = $this->CheckPermission(276, 1);
		if($viewper)
		{
		$this->view->claimid = Utils::decode5t($id);
        $this->view->render('employee/medicalclaim/releasemedclaim');
		}
		else{
			header('location: ' . URL . 'employee/index');
		}
    }
	function getMedicalClaimData()
	{
		try{
		$employee = $this->loadModel('Employee');
		$employeearray = $employee->getMedicalClaimData();
		echo json_encode($employeearray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	
	function getmedclaimdetails($id)
	{
		try{
		$employee = $this->loadModel('Employee');
		$employeearray = $employee->getmedclaimdetails($id);
		echo json_encode($employeearray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	function getFinanceDeptEmp()
	{
		try{
		$employee = $this->loadModel('Employee');
		$employeearray = $employee->getFinanceDeptEmp();
		echo json_encode($employeearray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	function updateApproveClaim()
	{
		try{
		$employee = $this->loadModel('Employee');
		$employeearray = $employee->updateApproveClaim();
		echo json_encode($employeearray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	function updateReleaseClaim()
	{
		try{
		$employee = $this->loadModel('Employee');
		$employeearray = $employee->updateReleaseClaim();
		echo json_encode($employeearray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	function rejectClaim()
	{
		try{
		$employee = $this->loadModel('Employee');
		$employeearray = $employee->rejectClaim();
		echo json_encode($employeearray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
/*end contoller for medical claim*/	
		
}

?>