<?php

/**
 * Login Controller
 * Controls the login processes
 */

class Client extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
   function __construct()
	{
		parent::__construct();
		Auth::handleLogin();
	}
    /**
     * Index, default action (shows the login form), when you do login/index
     */
	 function index() {
		 try{
    	$viewper = $this->CheckPermission(250, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$this->view->addper= $this->CheckPermission(250, 4);
			$this->view->clientid=0;
			$this->view->val=0;
			$this->view->render('timesheet/client/index');
		} else {
			header('location: ' . URL . 'setup/index');
		}
		 }catch(Exception $e){
			 
		 }
	}
	function getClientData()
	{
		 try{
		$editper = $this->CheckPermission(250, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
    	$deleteper = $this->CheckPermission(250, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$client_model = $this->loadModel('Client');
		$clientarray = $client_model->getDataTable($editper,$deleteper);
		echo json_encode($clientarray);
		//$id= Utils::decode5t('=UlVKdFVYBnUidkRINVb');
		//	Utils::Trace($id);
		}catch(Exception $e){
			
		}
	}
	function addclient(){
    	try{
		$addper = $this->CheckPermission(250, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->clientid =0;
			$this->view->val =0;
			$this->view->render('timesheet/client/newClient');
		}else{
			header('location: ' . URL . 'timesheet');
		}
	}catch(Exception $e){
		
	}
    }
	function editclient($id)  {
		$editper = $this->CheckPermission(250, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->clientid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('timesheet/client/newClient');
		}else{
			header('location: ' . URL . 'timesheet');
		}
		
    }
	/**
     * The login action, when you do login/login
     */
	function createclient()
	{try{
		$addper = $this->CheckPermission(250, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			//$arr[0] = $_SESSION['redhot_user_id'];
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employername'];
			$arr[3] = $_POST['contactperson'];
			$arr[4] = $_POST['contactnumber'];
			$arr[5] = $_POST['clientmanager'];
			$arr[6] = $_POST['emailaddress'];
			$arr[7] = $_POST['currency'];
			$arr[8] = $_POST['country'];
			$arr[9] = $_POST['city'];
			//$arr[10] = $_POST['zipcode'];
			//$arr[11] = $_POST['landmark'];
			$arr[17] = $_POST['website'];
		
			
			$dept = $this->loadModel('Client');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}catch(Exception $e){
		
	}		
	}
	
	function updatedeclient()
	{
		try{
		$editper = $this->CheckPermission(250, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			//$arr[0] = $_SESSION['redhot_user_id'];
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employername'];
			$arr[3] = $_POST['contactperson'];
			$arr[4] = $_POST['contactnumber'];
			$arr[5] = $_POST['clientmanager'];
			$arr[6] = $_POST['emailaddress'];
			$arr[7] = $_POST['currency'];
			$arr[8] = $_POST['country'];
			$arr[9] = $_POST['city'];
			//$arr[10] = $_POST['zipcode'];
			//$arr[11] = $_POST['landmark'];
			$arr[17] = $_POST['website'];
			$arr[19] = $_POST['clientid'];
		$dept = $this->loadModel('Client');
		$deptarray = $dept->Update($arr);
		echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){
			
		}
	}
	function getaclient() {
		try{
		$viewper = $this->CheckPermission(250, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)	{
			$gid = $_POST['clientid'];
			$employer = $this->loadModel('Client');
			$employerarray = $employer->getDetail($gid);
			echo json_encode($employerarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
		}catch(Exception $e){}		
	}

	function ViewClientDetail($id ,$val=0) {
		try{
		if(isset($id) ) {
			$this->view->clientid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val =$val; 
		 
			$clientarr= $this->loadModel('Client');
			$this->view->getTeam=$clientarr->getProjectTeamData(Utils::decode5t($id)); 
			$this->view->render('timesheet/client/viewClientDetail');
		}else{
			header('location: ' . URL . 'timesheet');
		}
		}catch(Exception $e){}		
	}
	
	function GetClientDashboard() {
		try{
		
			$gid = $_POST['clientid'];
			$employer = $this->loadModel('Client');
			$employerarray = $employer->getClientDashboard($gid);
			echo json_encode($employerarray);
		
		}catch(Exception $e){}		
	}
	 
	 function getdata($id){
	 try{
		 	//$gid = $_POST['clientid'];
		 	$dept = $this->loadModel('Client');
		 	$client = $dept->getClientDashboard($id);
		 	echo json_encode($client);
		 } catch (Exception $e) {}
		
	 }
	 
	function getallclients() {
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];	
			$employer = $this->loadModel('Client');
			$employerarray = $employer->getAll($arr);
			echo json_encode($employerarray);
		}catch(Exception $e){}		
	}
	
	function deleteclient($did)	{
		$deleteper = $this->CheckPermission(250, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper)
		{
			$user_model = $this->loadModel('Client');
			$userarray = $user_model->DeleteClient($did);
			echo json_encode($userarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}		
	}
	function changeclientstatus($did)	{
		
		$editper = $this->CheckPermission(250, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$emp = $this->loadModel('Client');
			$emparray = $emp->ChangeClientStatus($did);
			echo json_encode($emparray);	
		}
	
	}
	
	function getClientProject($clientid)
	{
		try{
		$timesheet = $this->loadModel('Client');
		$timesheetarray = $timesheet->getClientprojectDataTable($clientid);
		echo json_encode($timesheetarray);
		}catch(Exception $e){
			
		}
	}
	function ViewEmpTaskDetail($projectid ,$empid,$clientid=0)
	 {
		 try{
			 if($projectid!="" && $empid!=""){
				$this->view->projectid = Utils::decode5t($projectid); //$dept->getDetail($id);
				$this->view->empid =Utils::decode5t($empid); 
				$this->view->clientid =Utils::decode5t($clientid); 
				$clientarr= $this->loadModel('Client');
				$this->view->getEmpTask=$clientarr->ViewEmpTaskDetail(Utils::decode5t($projectid),Utils::decode5t($empid)); 
				$this->view->render('timesheet/client/employeetasklist');
			}else{
			header('location: ' . URL . 'timesheet');
		}
		}catch(Exception $e){
		}
	}
	////////////Import Client///////////
	function importClient()
    {
        $this->view->render('timesheet/client/importclient');
    }
    function insertclient(){
    	try{
		$addper = $this->CheckPermission(250, 4);  ///////// CHECK FOR VIEW PERMISSION  /////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employername'];
			$arr[3] = $_POST['contactperson'];
			$arr[4] = $_POST['contactnumber'];
			$arr[5] = $_POST['emailaddress'];
			$arr[6] = $_POST['country'];
			$arr[7] = $_POST['city'];
			$arr[8] = $_POST['website'];
			$dept = $this->loadModel('Client');
			$deptarray = $dept->importClient($arr);
			echo json_encode($deptarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}	
	}catch(Exception $e){
		
	}
}
function importheadersfile()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('client');
			$deptarray = $dept->getFileHeaders($arr);
			echo json_encode($deptarray);	
		
		
	}
}