<?php
class Timesheet extends Controller{
   
	function __construct() {
		parent::__construct();
		Auth::handleLogin();
	}
	/**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
	public function index(){
		try{
			if(true){
				$this->view->render('timesheet/index');
			}else{
				header('location: ' . URL . 'profile');
			}
		}catch(Exception $e){ }
	}
	
	public function timesheetlist(){
		$viewper = $this->CheckPermission(187, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(187, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('timesheet/timesheetlist/index');
		}else{
			header('location: ' . URL . 'profile');
		}
	}
	
	public function timesheetshow($type){
		$viewper = $this->CheckPermission(187, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(187, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->type =$type;
			$this->view->render('timesheet/timesheet/index');
		}else{
			header('location: ' . URL . 'profile');
		}
	}
	
	function addtimesheet()   {
		$addper = $this->CheckPermission(187, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$sheet_model = $this->loadModel('Projects');
			$this->view->timesheetid =0;
			$this->view->sheetdata ="";
			$this->view->sheet = $sheet_model->getAll();
			$this->view->render('timesheet/timesheetlist/addtime');
		}else{
			header('location: ' . URL . 'timesheet');
		}
	}
	
	function edittimesheet($id) {
		$editper = $this->CheckPermission(187, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper)) {
			$this->view->timesheetid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('timesheet/timesheetlist/addtime');
		}else{
			header('location: ' . URL . 'timesheet');
		}
	}

	function viewtimesheet($id,$val)  {
		if(isset($id) && isset($val)){
			$this->view->timesheetid = Utils::decode5t($id); 
			$this->view->val = $val; 
			$this->view->render('timesheet/timesheetlist/addtime');
		}else{
			header('location: ' . URL . 'timesheet');
		}
	}
	
	function viewtimesheet1($id,$val) {
		if(isset($id) && isset($val)) {
			$this->view->timesheetid = Utils::decode5t($id); 
			$this->view->val = $val; 
			$this->view->render('timesheet/timesheetlist/addedittimesheet');
		}else{
			header('location: ' . URL . 'timesheet');
		}
	}
	
	function getalltimesheet()	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$timesheet = $this->loadModel('Timesheet');
		$timesheetarray = $timesheet->getAll($arr);
		echo json_encode($timesheetarray);	
	}
	
	function getatimesheet(){
		try{
			$viewper = $this->CheckPermission(187, 1);  ///////// CHECK FOR VIEW PERMISSION  //
			if($viewper)	{
				$gid = $_POST['timesheetid'];
				$timesheet = $this->loadModel('Timesheet');
				$timesheetarray = $timesheet->getDetail($gid);
				echo json_encode($timesheetarray);		
			}else{
				$result = array();
				$result['status']=false;
				$result['errorMsg']="You don't have data view permission";
				echo json_encode($result);		
			}
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	/** 
     * Functions for perfom operation on timesheet table
     * getall function fetching timesheet list
	 * @returning json array of data as result
     */
	public function savetimesheetdata(){
		$sheet_model = $this->loadModel('Timesheet');
        $sheet = $sheet_model->create();
		$this->view->sheetdata ="";
		//$this->view->render('timesheet/index');
		header('location: ' . URL . 'timesheet/timesheetlist');
		//echo  json_encode($sheet);
	}
	
	public function editsavetimesheetdata(){
		$sheet_model = $this->loadModel('Timesheet');
        	$sheet = $sheet_model->editSave();
		//$this->view->render('timesheet/index');
		header('location: ' . URL . 'timesheet');
		//echo  json_encode($sheet);
	}
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletetimesheet($did) {
		$deleteper = $this->CheckPermission(187, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper ) {
			$dept = $this->loadModel('Timesheet');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'timesheet');
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getTimesheetData(){
		$editper = $this->CheckPermission(187, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(187, 3); ////////CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$timesheet = $this->loadModel('Timesheet');
		$timesheetarray = $timesheet->getDataTable($editper, $deleteper);
		echo json_encode($timesheetarray);
	}
	////////////////////////////project controller///////////
	public function projectlist($type=1) {
		$viewper = $this->CheckPermission(185, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(185, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->type =$type;
			$this->view->render('timesheet/projects/index');
		}else{
			header('location: ' . URL . 'profile');
		}	
	}
	
	function addproject($clientid=0,$valclient=0) {
		$addper = $this->CheckPermission(185, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->projectid =0;
			$this->view->clientid =Utils::decode5t($clientid);
			$this->view->val = 0; 
			$this->view->valclient = $valclient;
			$this->view->render('timesheet/projects/newProject');
		}else{
			header('location: ' . URL . 'timesheet');
		}
	}
	
	function editproject($id,$clientid=0,$valclient=0) {
		try{
			$editper = $this->CheckPermission(185, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
			if(isset($id) && ($editper)) {
				$this->view->projectid = Utils::decode5t($id); //$dept->getDetail($id);
				$this->view->val = 0;
				$this->view->valclient = $valclient;
				$this->view->clientid =Utils::decode5t($clientid);
				$this->view->render('timesheet/projects/newProject');
			}else{
				header('location: ' . URL . 'timesheet');
			}
		}catch(Exception $e){ }
    }
	
	function viewproject($id,$val) {
		try{
		if(isset($id) && isset($val)) {
			$this->view->projectid = Utils::decode5t($id); 
			$this->view->val = $val; 
			$clientarr= $this->loadModel('Projects');
			$this->view->getTeam=$clientarr->getProjectTeamData(Utils::decode5t($id)); 	
			$this->view->getMilestone=$clientarr->getProjectMilestoneData(Utils::decode5t($id)); 
			$this->view->projectemployee=$clientarr->projectemployeeDashboard(Utils::decode5t($id)); 
			$this->view->render('timesheet/projects/viewprojectdetail');
		}else{
			header('location: ' . URL . 'timesheet');
		}
		}catch(Exception $e){}
	}
	
	function getallproject()	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$timesheet = $this->loadModel('Projects');
		$timesheetarray = $timesheet->getAll($arr);
		echo json_encode($timesheetarray);	
	}
	
	function getaproject(){
		$viewper = $this->CheckPermission(185, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$gid = $_POST['timesheetid'];
			$timesheet = $this->loadModel('Projects');
			$timesheetarray = $timesheet->getProjectDetail($gid);
			echo json_encode($timesheetarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	/** 
     * Functions for perfom operation on timesheet table
     * getall function fetching timesheet list
	 * @returning json array of data as result
     */
	function createproject() {
		try{
			$addper = $this->CheckPermission(185, 4);  ///////// CHECK FOR VIEW PERMISSION  //////////
			if($addper) {
				$arr = array();
				$arr[0] = $_SESSION['ubihrm_user_id'];
				$arr[1] = $_SESSION['ubihrm_org_id'];
				$arr[2] = $_POST['company'];
				$arr[3] = $_POST['title'];
				$arr[4] = $_POST['projecttypeid'];
				$arr[5] = $_POST['milestoneids'];
				$arr[6] = $_POST['fromdate'];
				$arr[7] = $_POST['todate'];
				$arr[8] = $_POST['desc'];
				$arr[9] = $_POST['projectstatus'];
				$arr[10] = $_POST['billablests'];
				$arr[11] = $_POST['ownerid'];
				$arr[12] = $_POST['employeeid'];
				$arr[13] = $_POST['billingmethod'];
				$arr[14] = $_POST['costproject'];
				$arr[15] = $_POST['clientmanager'];
				$arr[16] = $_POST['budget'];
			
				$dept = $this->loadModel('Projects');
				$deptarray = $dept->Create($arr);
				echo json_encode($deptarray);
			}else{
				$result = array();
				$result['status']=false;
				$result['errorMsg']="You don't have data add permission";
				echo json_encode($result);		
			}
		}catch(Exception $e){ }
	}
	
	function uploadprojectdocs(){	
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2]=$_POST['projectid'];			
		$employee = $this->loadModel('Projects');
		$employeearray = $employee->uploadprojectdocs($arr);
		echo json_encode($employeearray);
	}
	 /**
     * Functions for perfom operation on timesheet table
     * delete function from timesheet list
	 * @returning json array of data as result
     */
	function getprojectdetail() {
		try{
			$viewper = $this->CheckPermission(185, 1);  ///////// CHECK FOR VIEW PERMISSION  //////////
			if($viewper)	{
				$gid = $_POST['projectid'];
				$Projects = $this->loadModel('Projects');
				$Projectsarray = $Projects->getDetail($gid);
				echo json_encode($Projectsarray);			
			}else{
				$result = array();
				$result['status']=false;
				$result['errorMsg']="You don't have data view permission";
				echo json_encode($result);		
			}
		}catch(Exception $e){}
	}
	
	function updateproject() {
		try{
			$editper = $this->CheckPermission(185, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
			if($editper)	{
				$arr = array();
				$arr[0] = $_SESSION['ubihrm_user_id'];
				$arr[1] = $_SESSION['ubihrm_org_id'];
				$arr[2] = $_POST['company'];
				$arr[3] = $_POST['title'];
				$arr[4] = $_POST['projecttypeid'];
				$arr[5] = $_POST['milestoneids'];
				$arr[6] = $_POST['fromdate'];
				$arr[7] = $_POST['todate'];
				$arr[8] = $_POST['desc'];
				$arr[9] = $_POST['projectstatus'];
				$arr[10] = $_POST['billablests'];
				$arr[11] = $_POST['ownerid'];
				$arr[12] = $_POST['employeeid'];
				$arr[13] = $_POST['billingmethod'];
				$arr[14] = $_POST['costproject'];
				$arr[15] = $_POST['project_id'];
				$arr[16] = $_POST['clientmanager'];
				$arr[17] = $_POST['budget'];
				
				$dept = $this->loadModel('Projects');
				$deptarray = $dept->Update($arr);
				echo json_encode($deptarray);		
						
			}else{
				$result = array();
				$result['status']=false;
				$result['errorMsg']="You don't have data edit permission";
				echo json_encode($result);		
			}
		}catch(Exception $e){}
	}
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteproject($did) {
		$deleteper = $this->CheckPermission(185, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper ){
			$dept = $this->loadModel('Projects');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'timesheet');
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getProjectData($type) {
		$editper = $this->CheckPermission(185, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(185, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$timesheet = $this->loadModel('Projects');
		$timesheetarray = $timesheet->getDataTable($editper, $deleteper,$type);
		echo json_encode($timesheetarray);
	}
	////////////////////////////  REPORT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	/* Functions for perfom operation on report table
     * getall function fetching report list
	 * @returning json array of data as result
     */
	function report() {
		$viewper = $this->CheckPermission(188, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(188, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('timesheet/reports/index');
		}else{
			header('location: ' . URL . 'timesheet/index');
		}
    }
	function addreport() {
		$addper = $this->CheckPermission(188, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->reportid =0;
			$this->view->val = 0; 
			$this->view->render('timesheet/reports/addeditreport');
		}else{
			header('location: ' . URL . 'timesheet/report');
		}
    }
	function editreport($id) {
		$editper = $this->CheckPermission(188, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper)) {
			$this->view->reportid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('timesheet/reports/addeditreport');
		}else{
			header('location: ' . URL . 'timesheet/report');
		}
	}
	function viewreport1($id,$val){
		if(isset($id)  && isset($val)) {
			$this->view->reportid = Utils::decode5t($id);
			$this->view->val = $val; 
			$this->view->render('timesheet/reports/addeditreport');
		}else{
			header('location: ' . URL . 'timesheet/report');
		}
	}
	function viewreport($id) {
		if(isset($id) ) {
			$this->view->reportid = Utils::decode5t($id); 
			$this->view->render('timesheet/reports/viewreport');
		}else{
			header('location: ' . URL . 'timesheet/report');
		}
	}
	/**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletereport($did) {
		$deleteper = $this->CheckPermission(188, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper ) {
			$dept = $this->loadModel('Report');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}	else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getReportData() {
		$editper = $this->CheckPermission(188, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(188, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$tabid=7;
		try{
			$report = $this->loadModel('Report');
			$reportarray = $report->getDataTable($editper, $deleteper,$tabid);
			echo json_encode($reportarray);
		}catch(Exception $e){}
	}
	
	function getReportData1($id){
		$editper = $this->CheckPermission(188, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(188, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$report = $this->loadModel('Report');
		$reportarray = $report->createDataTable($editper, $deleteper,$id);
		echo json_encode($reportarray);
	}
	
	function createReportDataTable(){
		$editper = $this->CheckPermission(188, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(188, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$report = $this->loadModel('Report');
		$reportarray = $report->createDataTable($editper, $deleteper);
		echo json_encode($reportarray);
	}
	
	function getmodules(){
		$permission = $this->loadModel('Permission');
		$perarray = $permission->getModules();
		echo json_encode($perarray);	
	}
	
	function getcolumnvalues(){
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['tablename'];
		$arr[3] = $_POST['columnname'];
		$dept = $this->loadModel('Report');
		$deptarray = $dept->getAllColumnValue($arr);
		echo json_encode($deptarray);	
	}
	
	function getreportingmodule()  {
		$tabid=$_POST['tabid'];
        $relation = $this->loadModel('Permission');
		$relationarr = $relation->getReportingModules($tabid);
		echo json_encode($relationarr);
    }
	
	function gettimesheetDashboard() {
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			/* $arr[0] = 4252;
			$arr[1] = 10; */
			//Utils::Trace($arr[0]." ".$arr[1]);
			$arr[2] = $_POST['fiscalid'];
			$arr[3] = $_POST['type'];
			$arr[4] = $_POST['date'];
			$attendancetype = $this->loadModel('Dashboard');
			$attendancetypearray = $attendancetype->gettimesheetDashboard($arr);
			echo json_encode($attendancetypearray);
		}catch(Exception $e){}
	}
	function getunassigntimesheet($type="") {
		try{
			$timesheet = $this->loadModel('timesheet');
			$timesheetarray = $timesheet->getunassigntimesheet($type);
			echo json_encode($timesheetarray);
		}catch(Exception $e){}
	}
	
	function addeditprojecttype(){
		$addper = $this->CheckPermission(187, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$sheet_model = $this->loadModel('Projects');
			$this->view->projecttypeid =0;
			
			$this->view->render('timesheet/settings/projecttype/addeditprojecttype');
		}else{
			header('location: ' . URL . 'timesheet');
		}
	}
	/** 
     * Functions for perfom operation on timesheet table
     * getall function fetching timesheet list
	 * @returning json array of data as result
     */
	function createProjectType() {
		try{
			$addper = $this->CheckPermission(220, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////
			if($addper) {
				$arr = array();
				$arr[0] = $_SESSION['ubihrm_user_id'];
				$arr[1] = $_SESSION['ubihrm_org_id'];
				$arr[2] = $_POST['milestone'];
				$arr[3] = $_POST['projecttypename'];
				$arr[4] = $_POST['projecttypedescription'];
				$dept = $this->loadModel('Projects');
				$deptarray = $dept->createProjectType($arr);
				echo json_encode($deptarray);
			}else{
				$result = array();
				$result['status']=false;
				$result['errorMsg']="You don't have data add permission";
				echo json_encode($result);		
			}
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	function getProjectTypeData() {
		$editper = $this->CheckPermission(220, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(220, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$timesheet = $this->loadModel('Projects');
		$timesheetarray = $timesheet->getProjectTypeData($editper, $deleteper);
		echo json_encode($timesheetarray);
	}
	
	public function projecttypelist()	{
		$viewper = $this->CheckPermission(220, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(220, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('timesheet/settings/projecttype/index');
		}else{
			header('location: ' . URL . 'profile');
		}
	}
	
	function editprojecttype($id)   {
		$editper = $this->CheckPermission(220, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper)) {
			$this->view->projecttypeid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('timesheet/settings/projecttype/addeditprojecttype');
		}else{
			header('location: ' . URL . 'timesheet');
		}
    }
	
	function getaProjectType($projecttypeid) {
		try{
			$viewper = $this->CheckPermission(220, 1);  ///////// CHECK FOR VIEW PERMISSION  //////////
			if($viewper)	{
				$gid = $projecttypeid;
				$timesheet = $this->loadModel('Projects');
				$timesheetarray = $timesheet->getaProjectType($gid);
				echo json_encode($timesheetarray);		
			}else{
				$result = array();
				$result['status']=false;
				$result['errorMsg']="You don't have data view permission";
				echo json_encode($result);		
			}
		}catch(Exception $e){}
	}
	
	function updateprojecttype() {
		$editper = $this->CheckPermission(220, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['milestone'];
			$arr[3] = $_POST['projecttypename'];
			$arr[4] = $_POST['projecttypedescription'];
			$arr[5] = $_POST['projecttypeid'];
			$dept = $this->loadModel('Projects');		
			$deptarray = $dept->UpdateProjectType($arr);
			echo json_encode($deptarray);								
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
		
	function deleteDefaultMilestone($did,$pid) {
		$deleteper = $this->CheckPermission(220, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper ) {
			$dept = $this->loadModel('Projects');
			$deptarray = $dept->deleteDefaultMilestone($did,$pid);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'timesheet');
	}
		
	function getallprojecttype(){
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];				
		$timesheet = $this->loadModel('Projects');
		$timesheetarray = $timesheet->getAllProjectType($arr);
		echo json_encode($timesheetarray);	
	}
	
}
