<?php

/**
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class Projects extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();
        // this controller should only be visible/usable by logged in users, so we put login-check here
        Auth::handleLogin();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    public function index()
    {
    	if($this->CheckPermission(2))
		{
			//$projects_model = $this->loadModel('Projects');
				//$this->view->projects = $projects_model->projects();
			$this->view->render('projects/index');	
    	}
    	else
    	{
    		header('location: ' . URL . 'dashboard');
    	}
    }
	
	public function details($id)
    	{
    		if($this->CheckPermission(2))
			{
				if(isset($id))
				{
					$_SESSION['sprojectid']=$id;			
					//$projects_model = $this->loadModel('Projects');
						//$this->view->project = $projects_model->getProjectDetail($id);
					$this->view->projectid=$id;
					$this->view->render('projects/details');
				}else{
					header('location: ' . URL . 'projects');
				}
			}
			else
			{
				header('location: ' . URL . 'dashboard');
			}
    	}
	
	public function getProjectDetail($id)
    	{
		$projects_model = $this->loadModel('Projects');
        	$project = $projects_model->getProjectDetail($id);
		echo json_encode($project);
    	}
	
	public function getallprojects()
	{
		$projects_model = $this->loadModel('Projects');
        	$projects = $projects_model->getAll($_SESSION['request']);
		echo  json_encode($projects);
	}
	
	public function newProject()
    	{
    		if($this->CheckPermission(2))
			{
				$this->view->pid=0;
				$this->view->project ="";
				$this->view->assigned_to ="";
				
				$sheet_model = $this->loadModel('Projects');
				$this->view->users = $sheet_model->getUserData($_SESSION['user_id']);
				$this->view->allprefix = $sheet_model->getAllProjectPrefix();
				//$sheet_model = $this->loadModel('Setting');
			   		//$this->view->users = $sheet_model->getUserData($_SESSION['user_id']);
				//$this->view->allmilestones = $sheet_model->getAllMilestones();
				
				//Working for Assigned TO in New Project
				$project_model = $this->loadModel('Tasks');
				$this->view->allusers = $project_model->getAllUsers();
			 	//Working for Assigned TO in New Project
				
				$bug_model = $this->loadModel('Bug');
				$this->view->status = $bug_model->getComboOtherData("STATUS");
				$this->view->render('projects/newProject');
		
    		}
    		else
    		{
    			header('location: ' . URL . 'dashboard');
    		}
    	}

    public function editProject($id)
    {
		if($this->CheckPermission(2))
		{		
			$this->view->pid=$id;
			$projects_model = $this->loadModel('Projects');    
			$this->view->project = $projects_model->edit($id);
			$this->view->assigned_to = "some value";
		
			$this->view->users = $projects_model->getUserData($_SESSION['user_id']);
			//$this->view->allmilestones = $sheet_model->getAllMilestones();
			$this->view->allprefix = $projects_model->getAllProjectPrefix();
	
			$project1_model = $this->loadModel('Tasks');
			$this->view->allusers = $project1_model->getAllUsers();
		
			//$project2_model = $this->loadModel('Projects');
			//$this->view->susers = $project2_model->getAllSelectedUsers($id);
	
			$bug_model = $this->loadModel('Bug');
			$this->view->status = $bug_model->getComboOtherData("STATUS");
	
			//$this->view->render('projects/editProject');
			$this->view->render('projects/newProject');
		}
		else
		{
			header('location: ' . URL . 'dashboard');
		}
    }


    public function addProject()
    {			
		$projects_model = $this->loadModel('Projects');
		$projects_model->addProject();
		//$this->view->projects = $projects_model->projects($_SESSION['user_id']);
		//$this->view->render('projects/index');
		header('location: ' . URL . 'projects');
    }


	public function updateProject($id)
    	{
		$projects_model = $this->loadModel('Projects');
    		$projects_model->updateProject($id);
		//$this->view->projects = $projects_model->projects($_SESSION['user_id']);
		//$this->view->render('projects/index');
		header('location: ' . URL . 'projects');
    	}
	
	public function editprojectstatus()
	{
		$sheet_model = $this->loadModel('Projects');
       		 $sheet = $sheet_model->updatestatus($_SESSION['user_id']);
		echo json_encode($sheet);
	}

	public function editprojectstatus1()
	{
		$sheet_model = $this->loadModel('Projects');
       		 $sheet = $sheet_model->updatestatus1($_SESSION['user_id']);
		echo json_encode($sheet);
	}

///////////////////////////////Project Milestone//////////////////////////////////////

	public function GetProgressProjectData()
    	{
		$id=isset($_POST['id'])?$_POST['id']:"0";
		$project_model = $this->loadModel('Projects');
		$project = $project_model->GetProgressProjectData($id);
		echo json_encode($project);
	}

///////////////////////////////////Project Milestone/////////////////////////////////
	public function getaprojectreferences()
   	{
		$arr=array();
	    	$arr[0]=$_POST['projectid'];
	    	$arr[1]=$_SESSION['user_id'];
	    	
		$project_model = $this->loadModel('Projects');
		$projectarray = $project_model->getaProjectReferences($arr);
		echo json_encode($projectarray);
    	}
	
	public function createprojectreference()
    	{
        	$arr = array();
		$arr[0] = $_POST['projectid'];
		$arr[1] = $_POST['referencelinkname'];
		$arr[2] = $_SESSION['user_id'];
		
		$project_model = $this->loadModel('Projects');
		$projectarray = $project_model->CreateProjectReferenceLink($arr);
		echo json_encode($projectarray);
    	}
    
    public function updateprojectreference()
    {
		$arr = array();
		$arr[0] = $_POST['refid'];
		$arr[1] = $_POST['referencelinkname'];

		$project_model = $this->loadModel('Projects');
		$projectarray = $project_model->UpdateProjectReferenceLink($arr);
		echo json_encode($projectarray);
    }
    
    public function deleteprojectreference()
    {
        	
		$refid = $_POST['refid'];
				
		$project_model = $this->loadModel('Projects');
		$projectarray = $project_model->DeleteProjectReference($refid);
		echo json_encode($projectarray);
    }
    
    public function getareference()
    {
        $arr=array();
    	$arr[0]=$_POST['refid'];
    	    	
        $project_model = $this->loadModel('Projects');
	$projectarray = $project_model->getaReference($arr);
	echo json_encode($projectarray);
    }
	
    public function getaprojectdocuments()
    {
        $arr=array();
    	$arr[0]=$_POST['projectid'];
    	$arr[1]=$_SESSION['user_id'];
    	
        $project_model = $this->loadModel('Projects');
	$projectarray = $project_model->getaProjectDocuments($arr);
	echo json_encode($projectarray);
    }
    
	function uploadProjectDocument()
	{	
		$arr = array();
		$arr[0]=$_POST['project_id'];
		$arr[1]=$_SESSION['user_id'];			
		$project = $this->loadModel('Projects');
		$projectarray = $project->uploadDocument($arr);
		echo json_encode($projectarray);
	}
	
	function deletedocument()
	{	
		$did=$_POST['refid'];			
		$project = $this->loadModel('Projects');
		$projectarray = $project->deleteDocument($did);
		echo json_encode($projectarray);
	}

	public function getprojectcalendar()
    {
		$id = $_POST['id'];
		$project_model = $this->loadModel('Projects');
		$projectarray = $project_model->getProjectCalendar($id);
		echo json_encode($projectarray);
    	}
    
	public function milestonelist($projectid=0)
	{
		try{
		$viewper = $this->CheckPermission(186, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(186, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->projectid= $projectid;
			$this->view->render('timesheet/projects/viewmilestone');
		}else{
			header('location: ' . URL . 'profile');
		}
		}catch(Exception $e){
			
		}
	}
	/////milestonedata
	function getMilestonData($projectid=0)
	{
		try
		{
		$editper = $this->CheckPermission(186, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(186, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////		
		$timesheet = $this->loadModel('projects');
		$milestonearray= $timesheet->getDataMTable($editper, $deleteper, $projectid);
		echo json_encode($milestonearray);
		} catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}	
}
