<?php

/** 
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class Precurement extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    	function __construct()
    	{
        	parent::__construct();
        	// this controller should only be visible/usable by logged in users, so we put login-check here
        	Auth::handleLogin();
		}

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    function index()
    {
		
			$this->view->render('timesheet/tasks/index');
	
    }
	 function requestMaterial()
    {
		
			$this->view->render('precurement/requestMaterial');
	
    } 
	function ViewMaterial()
    {
		
			$this->view->render('precurement/materialview');
	
    }
	function ViewMaterial1()
    {
		
			$this->view->render('precurement/track');
	
    }
	function TrackOrder()
    {
		
			$this->view->render('precurement/trackorder');
	
    }
		function manageTransport()
    {
		
			$this->view->render('precurement/manageTransport');
	
    }
	
		function adddriver()
    {
		
			$this->view->render('precurement/drive');
	
    }
	function trackdriver()
    {
		
			$this->view->render('precurement/trackdriver');
	
    }
	
	function addtask()
    {
		$addper = $this->CheckPermission(186, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->taskid =0;
			$this->view->val = 0; 
			$this->view->render('timesheet/tasks/addedittask');
		}else{
			header('location: ' . URL . 'employee/skill');
		}
    }
	
	function edittask($id)
    {
		$editper = $this->CheckPermission(186, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->taskid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('timesheet/tasks/addedittask');
		}else{
			header('location: ' . URL . 'employee/skill');
		}
		
    }
	function viewtask($id,$val)
    {
		
		if(isset($id) && isset($val))
		{
			$this->view->taskid = Utils::decode5t($id); 
			$this->view->val = $val; 
			$this->view->render('timesheet/tasks/addedittask');
		}else{
			header('location: ' . URL . 'employee/skill');
		}
		
    }
	function getalltask()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$Tasks = $this->loadModel('Tasks');
		$Tasksarray = $Tasks->getAll($arr);
		echo json_encode($Tasksarray);	
	}
	
	function getcomment()
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['taskid'];
		$Tasks = $this->loadModel('Tasks');
		$Tasksarray = $Tasks->getComment($arr);
		echo json_encode($Tasksarray);	
		}catch(Exception $e){}
	}
	
	function getallmilestone()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['projectid'];
		$Tasks = $this->loadModel('Tasks');
		$Tasksarray = $Tasks->getAllMilestone($arr);
		echo json_encode($Tasksarray);	
	}
	
	function getallemployee()
	{
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['projectid'];
		$Tasks = $this->loadModel('Tasks');
		$Tasksarray = $Tasks->getAllEmployee($arr);
		echo json_encode($Tasksarray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	
		function getother()
	{
		try{
		 $city = $this->loadModel('Other');
		$cityarr = $city->getAllOtherData();
			echo json_encode($cityarr);
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	
	function getatask()
	{
		$viewper = $this->CheckPermission(186, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['taskid'];
			$Tasks = $this->loadModel('Tasks');
			$Tasksarray = $Tasks->getDetail($gid);
			echo json_encode($Tasksarray);		
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on skill table
     * getall function fetching skill list
	 * @returning json array of data as result
     */
	function createtask()
	{
		$addper = $this->CheckPermission(186, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$Tasks = $this->loadModel('Tasks');
			$Tasksarray = $Tasks->Create($arr);
			echo json_encode($Tasksarray);
		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on skill table
     * delete function from skill list
	 * @returning json array of data as result
     */
	 
	 function updatedtask()
	{
		try{$editper = $this->CheckPermission(186, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['projectid'];
			$arr[3] = $_POST['milestoneid'];
			$arr[4] = $_POST['assignto'];
			$arr[5] = $_POST['desc'];
			$arr[6] = $_POST['title'];
			$arr[7] = $_POST['fromdate'];
			$arr[8] = $_POST['todate'];
			$arr[9] = $_POST['priority'];
			$arr[10] = $_POST['taskstatus'];
			$arr[11] = $_POST['miscunduct'];
			$arr[12] = $_POST['taskid'];
			$arr[13] = $_POST['comment'];
			$arr[14] = $_POST['rating'];
	
			$Tasks = $this->loadModel('Tasks');
			$Tasksarray = $Tasks->Update($arr);
			echo json_encode($Tasksarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	
	////////Uploaded updated task files////////////
	function updatetaskfile()
	{
		try{$editper = $this->CheckPermission(186, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			
	
			$Tasks = $this->loadModel('Tasks');
			$Tasksarray = $Tasks->UpdateTaskFile($arr);
			echo json_encode($Tasksarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	//////// End Uploaded updated task files ////////////
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletetask($did)
	{
		$deleteper = $this->CheckPermission(43, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$Tasks = $this->loadModel('Tasks');
			$Tasksarray = $Tasks->Delete($did);
			echo json_encode($Tasksarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);
		}	
		//header('location: ' . URL . 'employee/skill');
	}
	

	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getTaskData()
	{
		try{
		$editper = $this->CheckPermission(186, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(186, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$Tasks = $this->loadModel('Tasks');
		$Tasksarray = $Tasks->getDataTable($editper, $deleteper);
		echo json_encode($Tasksarray);
		}catch(Exception $e){}
	}
	
	
	function getprojectdate()
	{
		try{
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['projectid'];
		$Tasks = $this->loadModel('Tasks');
		$Tasksarray = $Tasks->getProjectDate($arr);
		echo json_encode($Tasksarray);
		}catch(Exception $e){}
	}
	
	
	function addtaskstatus($id)
	{
		try{
			$arr=array();
			$arr[0] = $_SESSION['ubihrm_org_id'];
			$arr[1]=$id;
			$Tasks = $this->loadModel('Tasks');
			$Tasksarray = $Tasks->AddTasksStatus($arr);
			echo json_encode($Tasksarray);	
			}catch(Exception $e){}
		//header('location: ' . URL . 'setup/users');
	}	
	
	function uploadfile(){
		try{
		$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Tasks');
			$deptarray = $dept->uploadFile($arr);
			echo json_encode($deptarray);	
		}catch(Exception $e){}
	}
	
	
}
