<?php

/**
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class Performanceold extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();

        // this controller should only be visible/usable by logged in users, so we put login-check here
        Auth::handleLogin();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    function index()
    {
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		if($sts==1 || $hrsts==1){
			$this->view->render('performanceold/index');
		}else{
			$this->view->render('performanceold/index1');
		}
        
    }
	
	function assessmentcomparision()
    {
        $viewper = $this->CheckPermission(111, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(111, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performanceold/assessmentcomparision/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
    }
	
	function getemployeedata()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['designationid'];
			
			$objective = $this->loadModel('Assessmentold');
			$objectivearray = $objective->getAllEmployeeAtDesignation($arr);
			echo json_encode($objectivearray);			
			
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	function getemployeedesignationdata()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$objective = $this->loadModel('Assessmentold');
			$objectivearray = $objective->getAllEmployeeDesignation($arr);
			echo json_encode($objectivearray);			
			
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	function getcomparisiondata()
	{
		try{
		$viewper = $this->CheckPermission(111, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['employeeid'];
			$arr[3]= $_POST['dtfrom'];
			$arr[4]= $_POST['dtto'];
			
			$objective = $this->loadModel('Assessmentold');
			$objectivearray = $objective->getComparisionData($arr);
			echo json_encode($objectivearray);			
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){
			echo $e->getMessage();
			}
	}
	/** 
	 ///////////////////////////// ASSESSMENT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	function assessment()
    {
        $viewper = $this->CheckPermission(111, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(111, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performanceold/employeeassessment/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
    }
	
	
	function viewassessment($empid,$val)
    {	
		$viewper = $this->CheckPermission(111, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper  && isset($val)  && isset($empid)){
			$this->view->employeeid =$empid;
			$this->view->val = $val; 
			$this->view->render('performanceold/employeeassessment/addassessment');
		}else{
			header('location: ' . URL . 'performanceold/assessment');
		}
    }
	function editassessment($empid)
    {	
		$editper = $this->CheckPermission(111, 2); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($editper   && isset($empid)){
			$this->view->employeeid =$empid;
			$this->view->val = 0; 
			$this->view->render('performanceold/employeeassessment/addassessment');
		}else{
			header('location: ' . URL . 'performanceold/assessment');
		}
    }
	function getempassessment()
	{
		$viewper = $this->CheckPermission(111, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['assessmentid'];
			try{
			$objective = $this->loadModel('Assessmentold');
			$objectivearray = $objective->getassessmentDetail($arr);
			echo json_encode($objectivearray);			
	}catch(Exception $e){
			echo $e->getMessage();
			}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	function getaassessment()
	{
		$viewper = $this->CheckPermission(111, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			
			$id= $_POST['empid'];
			$objective = $this->loadModel('Assessmentold');
			$objectivearray = $objective->getDetail($id);
			echo json_encode($objectivearray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function createassessment()
	{
		$editper = $this->CheckPermission(111, 2);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['assessmenttype'];
			$arr[6] = $_POST['achievements'];
			$arr[7] = $_POST['issues'];
			$arr[8] = $_POST['assessmentid'];
			$arr[9] = $_POST['potentials'];
			$arr[10] = $_POST['variablepay'];
			$arr[11] = $_POST['desc'];
			
			$objective = $this->loadModel('Assessmentold');
			$objectivearray = $objective->Create($arr);
			echo json_encode($objectivearray);	
						
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	
	 /**
     * Functions for perfom operation on objective table
     * delete function from objective list
	 * @returning json array of data as result
     */
	 
	 
	
	function getAssessmentData()
	{
		$editper = $this->CheckPermission(111, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(111, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$objective = $this->loadModel('Assessmentold');
		$objectivearray = $objective->getDataTable($editper, $deleteper);
		echo json_encode($objectivearray);
	}
	
	
	/** 
	 ///////////////////////////// ASSESSMENT CONTROLLER FUNCTION ENDS HERE  ////////////////////////////**/
	 
	 /** 
	 ///////////////////////////// ASSESSMENT RESULT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	
	function assessmentresult()
    {
        $viewper = $this->CheckPermission(111, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(111, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performanceold/assessmentresult/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
    }
	
	function viewassessmentresult($empid,$val)
    {	
		$viewper = $this->CheckPermission(111, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper  && isset($val)  && isset($empid)){
			$this->view->employeeid =$empid;
			$this->view->val = $val; 
			$this->view->render('performanceold/assessmentresult/assessmentresult');
		}else{
			header('location: ' . URL . 'performanceold/assessment');
		}
    }
	function deleteassessment($id)
	{		
		
			$dept = $this->loadModel('Assessmentold');
			$deptarray = $dept->Delete($id);
			echo json_encode($deptarray);	

		
		
	}
	function getAssessmentresultData()
	{
		$editper = $this->CheckPermission(111, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(111, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$objective = $this->loadModel('Assessmentold');
		$objectivearray = $objective->getAssessmentresultTable($editper, $deleteper);
		echo json_encode($objectivearray);
	}
	////////////////upload employee assessment document/////////////
	
	 function uploadAssessmentDoc()
	{	
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]=$_POST['emp_id'];			
			$employee = $this->loadModel('Assessmentold');
			$employeearray = $employee->uploadDocument($arr);
			echo json_encode($employeearray);
			
		
	}
	
	/** 
	 ///////////////////////////// Objective CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function objective()
    {
        $viewper = $this->CheckPermission(113, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(113, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performanceold/objective/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
    }
	function addobjective()
    {	
		$addper = $this->CheckPermission(113, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->objectiveid =0;
			$this->view->val = 0; 
        $this->view->render('performanceold/objective/addeditobjective');
		}else{
			header('location: ' . URL . 'performanceold/objective');
		}
    }
	
	function editobjective($id)
    {
		$editper = $this->CheckPermission(113, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->objectiveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performanceold/objective/addeditobjective');
		}else{
			header('location: ' . URL . 'performanceold/objective');
		}
    }
	
	function viewobjective($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->objectiveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performanceold/objective/addeditobjective');
		}else{
			header('location: ' . URL . 'performanceold/objective');
		}
		
    }
	
	function getallobjective()
	{
		$viewper = $this->CheckPermission(113, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$objective = $this->loadModel('AssessmentObjectiveold');
			$objectivearray = $objective->getAll($arr);
			echo json_encode($objectivearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	/*//to fetch the senior desigs id and self desig id//*/
	function getseniordesig()
	{
		$desig = $_POST['designationid'];
		$objective = $this->loadModel('AssessmentObjectiveold');
		$objectivearray = $objective->getSeniorDesigs($desig);
		echo json_encode($objectivearray);	
	}
	/*//to fetch only the senior desigs id//*/
	function getonlyseniordesig()
	{
		$desig = $_POST['designationid'];
		$objective = $this->loadModel('AssessmentObjectiveold');
		$objectivearray = $objective->getOnlySeniorDesigs($desig);
		echo json_encode($objectivearray);	
	}
	
	function getaobjective()
	{
		$viewper = $this->CheckPermission(113, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			try{
			$gid = $_POST['objectiveid'];
			$objective = $this->loadModel('AssessmentObjectiveold');
			$objectivearray = $objective->getDetail($gid);
			echo json_encode($objectivearray);			
			}catch(Exception $e){
				Utils::Trace($e->getMessage());
			}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	function createobjective()
	{
		try{
		$addper = $this->CheckPermission(113, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[4] = json_decode($_POST['desiglevel'], true); 
			$arr[5] = $_POST['threshholdscore'];
			$arr[6] = $_POST['achieveingamt'];
			$arr[7] = $_POST['variablepaysts'];
			$arr[8] = $_POST['jobdesc'];
			//$arr[9] = $_POST['traineecriteria'];
			$objective = $this->loadModel('AssessmentObjectiveold');
			$objectivearray = $objective->Create($arr);
			echo json_encode($objectivearray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	
	 /**
     * Functions for perfom operation on objective table
     * delete function from objective list
	 * @returning json array of data as result
     */
	 
	 function updateobjective()
	{
		$editper = $this->CheckPermission(113, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		try{
		if($editper)
		{
			
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[4] = $_POST['objectiveid'];
			$arr[5] = json_decode($_POST['desiglevel'], true); 
			$arr[6] = $_POST['threshholdscore'];
			$arr[7] = $_POST['achieveingamt'];
			$arr[8] = $_POST['variablepaysts'];
			$arr[9] = $_POST['jobdesc'];
			//$arr[10] = $_POST['traineecriteria'];
			$objective = $this->loadModel('AssessmentObjectiveold');
			$objectivearray = $objective->Update($arr);
			echo json_encode($objectivearray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		}
		catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	function deleteobjective($did)
	{		
		$deleteper = $this->CheckPermission(113, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('AssessmentObjectiveold');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getObjectiveData()
	{
		$editper = $this->CheckPermission(113, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(113, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$objective = $this->loadModel('AssessmentObjectiveold');
		$objectivearray = $objective->getDataTable($editper, $deleteper);
		echo json_encode($objectivearray);
	}
	
	/** 
	 ///////////////////////////// Quadrant CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function quadrant()
    {
        $viewper = $this->CheckPermission(112, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(112, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performanceold/quadrant/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
    }
	function addquadrant()
    {	
		$addper = $this->CheckPermission(112, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->quadrantid =0;
			$this->view->val = 0; 
        $this->view->render('performanceold/quadrant/addeditquadrant');
		}else{
			header('location: ' . URL . 'performanceold/quadrant');
		}
    }
	
	function editquadrant($id)
    {
		$editper = $this->CheckPermission(112, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->quadrantid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performanceold/quadrant/addeditquadrant');
		}else{
			header('location: ' . URL . 'performanceold/quadrant');
		}
    }
	
	function viewquadrant($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->quadrantid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performanceold/quadrant/addeditquadrant');
		}else{
			header('location: ' . URL . 'performanceold/quadrant');
		}
		
    }
	
	function getallquadrant()
	{
		$viewper = $this->CheckPermission(112, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$quadrant = $this->loadModel('Quadrant');
			$quadrantarray = $quadrant->getAll($arr);
			echo json_encode($quadrantarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	function getfunctionalQuadrant($desig=0)
	{
		try{
		$viewper = $this->CheckPermission(112, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $desig;
			
			$quadrant = $this->loadModel('Quadrant');
			$quadrantarray = $quadrant->getCompTypeQuadrant($arr,2);
			echo json_encode($quadrantarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}		
	}
	function getBehaviouralQuadrant()
	{
		$viewper = $this->CheckPermission(112, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$quadrant = $this->loadModel('Quadrant');
			$quadrantarray = $quadrant->getCompTypeQuadrant($arr,1);
			echo json_encode($quadrantarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	
	
	function getaquadrant()
	{
		$viewper = $this->CheckPermission(112, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['quadrantid'];
			$quadrant = $this->loadModel('Quadrant');
			$quadrantarray = $quadrant->getDetail($gid);
			echo json_encode($quadrantarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on quadrant table
     * getall function fetching quadrant list
	 * @returning json array of data as result
     */
	function createquadrant()
	{
		$addper = $this->CheckPermission(112, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['quadrantname'];
			$arr[3] = $_POST['color'];
			
			$quadrant = $this->loadModel('Quadrant');
			$quadrantarray = $quadrant->Create($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	
	
	 /**
     * Functions for perfom operation on quadrant table
     * delete function from quadrant list
	 * @returning json array of data as result
     */
	 
	 function updatequadrant()
	{
		$editper = $this->CheckPermission(112, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['quadrantname'];
			$arr[3] = $_POST['quadrantid'];
			$arr[4] = $_POST['color'];
			$quadrant = $this->loadModel('Quadrant');
			$quadrantarray = $quadrant->Update($arr);
			echo json_encode($quadrantarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletequadrant($did)
	{		
		$deleteper = $this->CheckPermission(112, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Quadrant');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	function getperformanceoldDashboard($val,$type="")
	{        	
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];
		
		$empperformanceold = $this->loadModel('Dashboard');
		if($val==1)
		$empperformanceoldarray = $empperformanceold->getperformanceoldDashboard1($arr);
		else
		$empperformanceoldarray = $empperformanceold->getperformanceoldReportingDashboard($arr);
		echo json_encode($empperformanceoldarray);
                     		
		
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getQuadrantData()
	{
		$editper = $this->CheckPermission(112, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(112, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$quadrant = $this->loadModel('Quadrant');
		$quadrantarray = $quadrant->getDataTable($editper, $deleteper);
		echo json_encode($quadrantarray);
	}
	
	
	/** 
	 ///////////////////////////// Competency type CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function competencytype()
    {
		
        $viewper = $this->CheckPermission(127, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(127, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performanceold/competencytype/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
    }
	function addcompetencytype()
    {	
		$addper = $this->CheckPermission(127, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->competencytypeid =0;
			$this->view->val = 0; 
        $this->view->render('performanceold/competencytype/addeditcompetencytype');
		}else{
			header('location: ' . URL . 'performanceold/competencytype');
		}
    }
	
	function editcompetencytype($id)
    {
		$editper = $this->CheckPermission(127, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->competencytypeid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performanceold/competencytype/addeditcompetencytype');
		}else{
			header('location: ' . URL . 'performanceold/competencytype');
		}
    }
	
	function viewcompetencytype($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->competencytypeid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performanceold/competencytype/addeditcompetencytype');
		}else{
			header('location: ' . URL . 'performanceold/competencytype');
		}
		
    }
	
	function getallcompetencytype()
	{
		$viewper = $this->CheckPermission(127, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$competencytype = $this->loadModel('Competencytype');
			$competencytypearray = $competencytype->getAll($arr);
			echo json_encode($competencytypearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	
	
	function getacompetencytype()
	{
		$viewper = $this->CheckPermission(127, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['competencytypeid'];
			$competencytype = $this->loadModel('Competencytype');
			$competencytypearray = $competencytype->getDetail($gid);
			echo json_encode($competencytypearray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on competencytype table
     * getall function fetching competencytype list
	 * @returning json array of data as result
     */
	function createcompetencytype()
	{
		$addper = $this->CheckPermission(127, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['comptype'];
			$arr[3] = $_POST['compcolor'];
			
			$competencytype = $this->loadModel('Competencytype');
			$competencytypearray = $competencytype->Create($arr);
			echo json_encode($competencytypearray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on competencytype table
     * delete function from competencytype list
	 * @returning json array of data as result
     */
	 
	 function updatecompetencytype()
	{
		$editper = $this->CheckPermission(127, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['comptype'];
			$arr[3] = $_POST['compcolor'];
			$arr[4] = $_POST['competencytypeid'];
			
			$competencytype = $this->loadModel('Competencytype');
			$competencytypearray = $competencytype->Update($arr);
			echo json_encode($competencytypearray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletecompetencytype($did)
	{		
		$deleteper = $this->CheckPermission(127, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Competencytype');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCompetencytypeData()
	{
		$editper = $this->CheckPermission(127, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(127, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
		$competencytype = $this->loadModel('Competencytype');
		$competencytypearray = $competencytype->getDataTable($editper, $deleteper);
		echo json_encode($competencytypearray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	/** 
	 ///////////////////////////// Competency CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function competency()
    {
        $viewper = $this->CheckPermission(128, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(128, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performanceold/competency/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
    }
	function addcompetency()
    {	
		$addper = $this->CheckPermission(128, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->competencyid =0;
			$this->view->val = 0; 
        $this->view->render('performanceold/competency/addeditcompetency');
		}else{
			header('location: ' . URL . 'performanceold/competency');
		}
    }
	
	function editcompetency($id)
    {
		$editper = $this->CheckPermission(128, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->competencyid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performanceold/competency/addeditcompetency');
		}else{
			header('location: ' . URL . 'performanceold/competency');
		}
    }
	
	function viewcompetency($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->competencyid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performanceold/competency/addeditcompetency');
		}else{
			header('location: ' . URL . 'performanceold/competency');
		}
		
    }
	
	function getallcompetency()
	{
		$viewper = $this->CheckPermission(128, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->getAll($arr);
			echo json_encode($competencyarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getcompetency()
	{
		$viewper = $this->CheckPermission(128, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['competencytypeid'];
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->getCompetency($arr);
			echo json_encode($competencyarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getacompetency()
	{
		$viewper = $this->CheckPermission(128, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['competencyid'];
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->getDetail($gid);
			echo json_encode($competencyarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on competency table
     * getall function fetching competency list
	 * @returning json array of data as result
     */
	function createcompetency()
	{
		$addper = $this->CheckPermission(128, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['name'];
			$arr[3] = $_POST['ctype'];
			
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->Create($arr);
			echo json_encode($competencyarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on competency table
     * delete function from competency list
	 * @returning json array of data as result
     */
	 
	 function updatecompetency()
	{
		$editper = $this->CheckPermission(128, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['name'];
			$arr[3] = $_POST['ctype'];
			$arr[4] = $_POST['competencyid'];
			
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->Update($arr);
			echo json_encode($competencyarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletecompetency($did)
	{		
		$deleteper = $this->CheckPermission(128, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Competency');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCompetencyData()
	{
		$editper = $this->CheckPermission(128, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(128, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$competency = $this->loadModel('Competency');
		$competencyarray = $competency->getDataTable($editper, $deleteper);
		echo json_encode($competencyarray);
	}
	
	/** 
	 ///////////////////////////// Competency analysis CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function competencyanalysis()
    {
		
        $viewper = $this->CheckPermission(130, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(130, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performanceold/competencyanalysis/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
    }
	function addcompetencyanalysis()
    {	
		$addper = $this->CheckPermission(130, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->competencyanalysisid =0;
			$this->view->val = 0; 
        $this->view->render('performanceold/competencyanalysis/addeditanalysis');
		}else{
			header('location: ' . URL . 'performanceold/competencyanalysis');
		}
    }
	
	function editcompetencyanalysis($id)
    {
		$editper = $this->CheckPermission(130, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->competencyanalysisid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performanceold/competencyanalysis/addeditanalysis');
		}else{
			header('location: ' . URL . 'performanceold/competencyanalysis');
		}
    }
	
	function viewcompetencyanalysis($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->competencyanalysisid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performanceold/competencyanalysis/addeditanalysis');
		}else{
			header('location: ' . URL . 'performanceold/competencyanalysis');
		}
		
    }
	
	function getallcompetencyanalysis()
	{
		$viewper = $this->CheckPermission(130, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$competencyanalysis = $this->loadModel('Competencyanalysis');
			$competencyanalysisarray = $competencyanalysis->getAll($arr);
			echo json_encode($competencyanalysisarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	
	
	function getacompetencyanalysis()
	{
		$viewper = $this->CheckPermission(130, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['competencyanalysisid'];
			$competencyanalysis = $this->loadModel('Competencyanalysis');
			$competencyanalysisarray = $competencyanalysis->getDetail($gid);
			echo json_encode($competencyanalysisarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	
	function getcombodata($field,$val)
	{
		$competencyanalysis = $this->loadModel('Competencyanalysis');
		$competencyanalysisarray = $competencyanalysis->getCombo($field,$val);
		echo json_encode($competencyanalysisarray);			
	}
	
	/** 
     * Functions for perfom operation on competencyanalysis table
     * getall function fetching competencyanalysis list
	 * @returning json array of data as result
     */
	function createcompetencyanalysis()
	{
		$addper = $this->CheckPermission(130, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[4] = json_decode($_POST['desiglevel'], true); 
			
			$competencyanalysis = $this->loadModel('Competencyanalysis');
			$competencyanalysisarray = $competencyanalysis->Create($arr);
			echo json_encode($competencyanalysisarray);		
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on competencyanalysis table
     * delete function from competencyanalysis list
	 * @returning json array of data as result
     */
	 
	 function updatecompetencyanalysis()
	{
		$editper = $this->CheckPermission(130, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[4] = json_decode($_POST['desiglevel'], true); 
			$arr[5] = $_POST['competencyanalysisid'];
			
			$competencyanalysis = $this->loadModel('Competencyanalysis');
			$competencyanalysisarray = $competencyanalysis->Update($arr);
			echo json_encode($competencyanalysisarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletecompetencyanalysis($did)
	{		
		$deleteper = $this->CheckPermission(130, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Competencyanalysis');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCompetencyAnalysisData()
	{
		$editper = $this->CheckPermission(130, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(130, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
		$competencyanalysis = $this->loadModel('Competencyanalysis');
		$competencyanalysisarray = $competencyanalysis->getDataTable($editper, $deleteper);
		echo json_encode($competencyanalysisarray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	/** 
	 ///////////////////////////// SKILL GAP ASSESSMENT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	function skillgapassessment()
    {
        $viewper = $this->CheckPermission(132, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(132, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performanceold/skillgapassessment/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
    }
	
	
	function viewskillgapassessment($aid,$val)
    {	
		$viewper = $this->CheckPermission(132, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper  && isset($val)  && isset($aid)){
			$this->view->assessmentid =$aid;
			$this->view->val = $val; 
			$this->view->render('performanceold/skillgapassessment/addassessment');
		}else{
			header('location: ' . URL . 'performanceold/skillgapassessment');
		}
    }
	
	function editskillgapassessment($aid)
    {	
		$editper = $this->CheckPermission(132, 2); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($editper  && isset($aid)){
			$this->view->assessmentid =$aid;
			$this->view->val = 0; 
			$this->view->render('performanceold/skillgapassessment/addassessment');
		}else{
			header('location: ' . URL . 'performanceold/skillgapassessment');
		}
    }
	function getskillgapassessment()
	{
		$viewper = $this->CheckPermission(132, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['assessmentid'];
			try{
			$objective = $this->loadModel('Skillgapassessment');
			$objectivearray = $objective->getassessmentDetail($arr);
			echo json_encode($objectivearray);			
			}catch(Exception $e){
				echo $e->getMessage();
			}
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getskillgapresult()
	{
		$viewper = $this->CheckPermission(132, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['assessmentid'];
			try{
			$objective = $this->loadModel('Skillgapassessment');
			$objectivearray = $objective->getassessmentResult($arr);
			echo json_encode($objectivearray);			
			}catch(Exception $e){
				echo $e->getMessage();
			}
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getaskillgapassessment()
	{
		$viewper = $this->CheckPermission(132, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			
			$id= $_POST['empid'];
			$objective = $this->loadModel('Skillgapassessment');
			$objectivearray = $objective->getDetail($id);
			echo json_encode($objectivearray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function createskillgapassessment()
	{
		$edit = $this->CheckPermission(132, 2);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($edit)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['assessmenttype'];
			$arr[6] = $_POST['assessmentid'];
			$objective = $this->loadModel('Skillgapassessment');
			$objectivearray = $objective->Create($arr);
			echo json_encode($objectivearray);	
						
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	
	 /**
     * Functions for perfom operation on objective table
     * delete function from objective list
	 * @returning json array of data as result
     */
	 
	 
	
	function getSkillgapassessmentData()
	{
		$editper = $this->CheckPermission(132, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(132, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
		$objective = $this->loadModel('Skillgapassessment');
		$objectivearray = $objective->getDataTable($editper, $deleteper);
		echo json_encode($objectivearray);
		}catch(Exception $e){
				echo $e->getMessage();
			}	
	}
	
	
	/** 
	 ///////////////////////////// ASSESSMENT CONTROLLER FUNCTION ENDS HERE  ////////////////////////////**/
	  /** 
	 ///////////////////////////// SKILL GAP ASSESSMENT RESULT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	
	function skillgapresult()
    {
        $viewper = $this->CheckPermission(132, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(132, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performanceold/skillgapresult/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
    }
	
	function viewskillgapresult($empid,$val)
    {	
		$viewper = $this->CheckPermission(132, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper  && isset($val)  && isset($empid)){
			$this->view->assessmentid =$empid;
			$this->view->val = $val; 
			$this->view->render('performanceold/skillgapresult/skillgapresult');
		}else{
			header('location: ' . URL . 'performanceold/skillgapassessment');
		}
    }
	
	function getSkillgapresultData()
	{
		$editper = $this->CheckPermission(132, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(132, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$objective = $this->loadModel('Skillgapassessment');
		$objectivearray = $objective->getAssessmentresultTable($editper, $deleteper);
		echo json_encode($objectivearray);
	}
	
	 ////////////////////////////  REPORT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
    /* Functions for perfom operation on report table
     * getall function fetching report list
	 * @returning json array of data as result
     */
	
	function report()
    {
		$viewper = $this->CheckPermission(167, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(167, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performanceold/reports/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
    }
	function addreport()
    {
		$addper = $this->CheckPermission(167, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->reportid =0;
			$this->view->val = 0; 
			$this->view->render('performanceold/reports/addeditreport');
		}else{
			header('location: ' . URL . 'performanceold/report');
		}
    }
	
	function editreport($id)
    {
		$editper = $this->CheckPermission(167, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->reportid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performanceold/reports/addeditreport');
		}else{
			header('location: ' . URL . 'performanceold/report');
		}
		
    }
	
	function viewreport1($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->val = $val; 
			$this->view->render('performanceold/reports/addeditreport');
		}else{
			header('location: ' . URL . 'performanceold/report');
		}
		
    }
	function viewreport($id)
    {
		
		if(isset($id) )
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->render('performanceold/reports/viewreport');
		}else{
			header('location: ' . URL . 'performanceold/report');
		}
		
    }
	
	function daterangereport($val)
	{
		try{
			$deptarray=array();
			$dept = $this->loadModel('Report');
			if($val==15){
				$deptarray = $dept->EmployeeAssessmentReport();
			}
			elseif($val==13){
				$deptarray = $dept->EmployeeAssessmentCompleteReport();
			}
			
			echo json_encode($deptarray);
		}catch(Exception $e) {
			echo $e->getMessage();
		}
	}	
	function deletereport($did)
	{
		$deleteper = $this->CheckPermission(167, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Report');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'performanceold/report');
	}
	
	
	function getReportData()
	{
		$editper = $this->CheckPermission(167, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(167, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$tabid=6;
		$report = $this->loadModel('Report');
		$reportarray = $report->getDataTable($editper, $deleteper,$tabid);
		echo json_encode($reportarray);
	}
	//////////Performace Indicator////
	function indicatorattribute()
	{
		$viewper = $this->CheckPermission(171, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(171, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->indicateid=0;
			$this->view->render('performanceold/indicator/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
	}
	function getIndicatorAttributeData()
	{
		$editper = $this->CheckPermission(171, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(171, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$indicator = $this->loadModel('performanceoldindicator');
		$indicatorarray = $indicator->getIndicatorAttributeTable($editper, $deleteper);
		echo json_encode($indicatorarray);
	}
	
	function gettraining()
	{
		try{
		$editper = $this->CheckPermission(171, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(171, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$indicator = $this->loadModel('performanceoldindicator');
		$indicatorarray = $indicator->getTraining($editper, $deleteper);
		echo json_encode($indicatorarray);
		}catch(Exception $e) {
		echo $errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	function gettrainer()
	{
		try{
		$editper = $this->CheckPermission(171, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(171, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$indicator = $this->loadModel('performanceoldindicator');
		$indicatorarray = $indicator->getTrainer($editper, $deleteper);
		echo json_encode($indicatorarray);
		}catch(Exception $e) {
		echo $errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	function editTraining($id,$val)
    {
		try{
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid =$id;
			$this->view->val =$val;
			$this->view->render('performanceold/training/addtrainee');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
	}catch(Exception $e){}
    }
	
	function editTrainer($id,$val)
    {
		try{
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainerid =$id;
			$this->view->val =$val;
			$this->view->render('performanceold/trainer/addtrainer');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
	}catch(Exception $e){}
    }
	
	function createindicator()
	{
		try{$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['attributes'];
		$arr[3] = $_POST['marks'];
			
		$indicator = $this->loadModel('performanceoldindicator');
		$indicatorarray = $indicator->Create($arr);
		echo json_encode($indicatorarray);	
		}catch(Exception $e){}
		
	}
	function updateindicator()
	{
		try{$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['attributes'];
		$arr[3] = $_POST['marks'];
		$arr[4] = $_POST['indicateid'];
			
		$indicator = $this->loadModel('performanceoldindicator');
		$indicatorarray = $indicator->Update($arr);
		echo json_encode($indicatorarray);	
		}catch(Exception $e){}
		
	}
	function deleteindicator($did)
	{		
		$deleteper = $this->CheckPermission(171, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$indicator = $this->loadModel('performanceoldindicator');
			$indicatorarray = $indicator->Delete($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	function getindicator()
	{try{
		$viewper = $this->CheckPermission(171, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			
			$id= $_POST['indicateid'];
			$indicator = $this->loadModel('performanceoldindicator');
			$indicatorarray = $indicator->getDetail($id);
			echo json_encode($indicatorarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}
	}
	//////////Performace Assess Indicator////
	function assessindicator()
	{
		$viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			
			$this->view->render('performanceold/assessindicator/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
	}
	
	function trainer()
	{
		$viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainerid=0;
			
			$this->view->render('performanceold/trainer/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
	}
	
	function training()
	{
		$viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid=0;
			$this->view->render('performanceold/training/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
	}
	
	function createtraining()
	{
		try{
		$addper = $this->CheckPermission(112, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['competencyid'];
			$arr[3] = $_POST['trainee'];
			$arr[4] = $_POST['trainerid'];
			$arr[5] = $_POST['startdate'];
			$arr[6] = $_POST['enddate'];
			$arr[7] = $_POST['timefrom'];
			$arr[8] = $_POST['timeto'];
			$quadrant = $this->loadModel('performanceoldindicator');
			$quadrantarray = $quadrant->CreateTraining($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	function createtrainer()
	{
		try{
		$addper = $this->CheckPermission(112, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['trainer_name'];
			$arr[3] = $_POST['trainer_email'];
			$arr[4] = $_POST['trainer_address'];
			$arr[5] = $_POST['trainer_mobile'];
			$arr[6] = $_POST['trainer_experience'];
			$arr[7] = $_POST['trainer_qualification'];
			$arr[8] = $_POST['trainer_specialization'];
			$quadrant = $this->loadModel('performanceoldindicator');
			$quadrantarray = $quadrant->CreateTrainer($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	
function updatetrainer()
	{
		try{
		$addper = $this->CheckPermission(112, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['trainer_name'];
			$arr[3] = $_POST['trainer_email'];
			$arr[4] = $_POST['trainer_address'];
			$arr[5] = $_POST['trainer_mobile'];
			$arr[6] = $_POST['trainer_experience'];
			$arr[7] = $_POST['trainer_qualification'];
			$arr[8] = $_POST['trainer_specialization'];
			$arr[9] = $_POST['trainerid'];
			$quadrant = $this->loadModel('performanceoldindicator');
			$quadrantarray = $quadrant->updateTrainer($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	
	function updatetraining()
	{
		$addper = $this->CheckPermission(112, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['competencyid'];
			$arr[3] = $_POST['trainee'];
			$arr[4] = $_POST['trainerid'];
			$arr[5] = $_POST['startdate'];
			$arr[6] = $_POST['enddate'];
			$arr[7] = $_POST['timefrom'];
			$arr[8] = $_POST['timeto'];
			$arr[9] = $_POST['trainingid'];
			$quadrant = $this->loadModel('performanceoldindicator');
			$quadrantarray = $quadrant->updateTraining($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	function deleteTraining($did)
	{
		$deleteper = $this->CheckPermission(113, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('performanceoldindicator');
			$deptarray = $dept->DeleteTraining($did);
			echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	function deleteTrainer($did)
	{
		$deleteper = $this->CheckPermission(113, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('performanceoldindicator');
			$deptarray = $dept->DeleteTrainer($did);
			echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	function addTrainer()
    {
		try{
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainerid =0;
			$this->view->val = 0; 
			$this->view->render('performanceold/trainer/addtrainer');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
	}catch(Exception $e){}
    }
	
	function getcompetencyemployee()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['competencyid'];
			$indicator = $this->loadModel('performanceoldindicator');
			$employeearray = $indicator->getCompetencyEmployee($arr);
			echo json_encode($employeearray);		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	function addTrainee()
    {
		try{
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid =0;
			$this->view->val = 0; 
			$this->view->render('performanceold/training/addtrainee');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
	}catch(Exception $e){}
    }
	function getAssignIndicatorData()
	{
		$editper = $this->CheckPermission(184, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(184, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$indicator = $this->loadModel('Pimaster');
		$indicatorarray = $indicator->getAssignIndicatorData($editper, $deleteper);
		echo json_encode($indicatorarray);
	}
	function addAssignIndicator()
    {try{
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->assignid =0;
			$this->view->val = 0; 
			$this->view->render('performanceold/assessindicator/assignindicator');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
	}catch(Exception $e){}
    }
	
	function getAllindicator()
	{
		$indicator = $this->loadModel('Pimaster');
		$indicatorarray = $indicator->getAllindicator();
		echo json_encode($indicatorarray);
	}
	function createAssignindicator()
	{
		try{$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['emp_id'];
		$arr[3] = $_POST['month'];
		$arr[4] = $_POST['totalmarks'];
		$arr[5] = $_POST['totalamt'];
		$arr[6] = $_POST['remark'];
			
		$indicator = $this->loadModel('Pimaster');
		$indicatorarray = $indicator->Create($arr);
		echo json_encode($indicatorarray);	
		}catch(Exception $e){}
		
	}
	function deleteAssignindicator($did)
	{		
		try{$deleteper = $this->CheckPermission(184, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$indicator = $this->loadModel('Pimaster');
			$indicatorarray = $indicator->Delete($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getAllassessdata($did)
	{		
		try{
		if(isset($did))
		{
			$indicator = $this->loadModel('Pimaster');
			$indicatorarray = $indicator->GetAssessdata($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getAlltrainingdata($did)
	{		
		try{
		if(isset($did))
		{
			$indicator = $this->loadModel('performanceoldindicator');
			$indicatorarray = $indicator->getAlltrainingdata($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getAlltrainerdata($did)
	{		
		try{
		if(isset($did))
		{
			$indicator = $this->loadModel('performanceoldindicator');
			$indicatorarray = $indicator->getAlltrainerdata($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function editAssessindicator($id,$val)
    {try{
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->assignid =$id;
			$this->view->val =$val;
			$this->view->render('performanceold/assessindicator/assignindicator');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
	}catch(Exception $e){}
    }
	function updateAssignindicator()
	{
		try{$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['assignid'];
		$arr[3] = $_POST['totalamt'];
		$arr[4] = $_POST['remark'];
			
		$indicator = $this->loadModel('Pimaster');
		$indicatorarray = $indicator->Update($arr);
		echo json_encode($indicatorarray);	
		}catch(Exception $e){}
		
	}
	
	/** 
	 ///////////////////////////// Skill Gap Objective CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function skillObjective()
    {
        $viewper = $this->CheckPermission(229, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(229, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performanceold/skillobjective/index');
		}else{
			header('location: ' . URL . 'performanceold/index');
		}
    }
	function addSkillObjective()
    {	
		$addper = $this->CheckPermission(229, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->objectiveid =0;
			$this->view->val = 0; 
        $this->view->render('performanceold/skillobjective/addeditskillobjective');
		}else{
			header('location: ' . URL . 'performanceold/skillObjective');
		}
    }
	
	function editSkillObjective($id)
    {
		$editper = $this->CheckPermission(229, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->objectiveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performanceold/skillobjective/addeditskillobjective');
		}else{
			header('location: ' . URL . 'performanceold/skillObjective');
		}
    }
	
	function viewSkillObjective($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{	
			$this->view->val = $val; 
			$this->view->objectiveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performanceold/skillobjective/addeditskillobjective');
		}else{
			header('location: ' . URL . 'performanceold/skillObjective');
		}
		
    }
	
	function getAllSkillObjective()
	{
		$viewper = $this->CheckPermission(229, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$objective = $this->loadModel('AssessmentObjectiveold');
			$objectivearray = $objective->getAll($arr);
			echo json_encode($objectivearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	/* function getseniordesig()
	{
		$desig = $_POST['designationid'];
		$objective = $this->loadModel('AssessmentObjectiveold');
		$objectivearray = $objective->getSeniorDesigs($desig);
		echo json_encode($objectivearray);	
	}
	 */
	function getaSkillObjective()
	{
		$viewper = $this->CheckPermission(229, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			try{
			$gid = $_POST['objectiveid'];
			$objective = $this->loadModel('Skillgap');
			$objectivearray = $objective->getDetail($gid);
			echo json_encode($objectivearray);			
			}catch(Exception $e){
				Utils::Trace($e->getMessage());
			}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	/** 
     * Functions for perfom operation on Skill gap objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	function createSkillObjective()
	{
		try{
		$addper = $this->CheckPermission(229, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[4] = json_decode($_POST['desiglevel'], true); 
			$arr[5] = $_POST['threshholdscore'];
			$arr[6] = $_POST['achieveingamt'];
			$arr[7] = $_POST['variablepaysts'];
			$arr[8] = $_POST['jobdesc'];
			//$arr[9] = $_POST['traineecriteria'];
			$objective = $this->loadModel('Skillgap');
			$objectivearray = $objective->createSkillObjective($arr);
			echo json_encode($objectivearray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	 /**
     * Functions for perfom operation on objective table
     * delete function from objective list
	 * @returning json array of data as result
     */
	 
	 function updateSkillObjective()
	{
		$editper = $this->CheckPermission(229, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		try{
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[4] = $_POST['objectiveid'];
			$arr[5] = json_decode($_POST['desiglevel'], true); 
			$arr[6] = $_POST['threshholdscore'];
			$arr[7] = $_POST['achieveingamt'];
			$arr[8] = $_POST['variablepaysts'];
			$arr[9] = $_POST['jobdesc'];
			//$arr[10] = $_POST['traineecriteria'];
			$objective = $this->loadModel('Skillgap');
			$objectivearray = $objective->updateSkillObjective($arr);
			echo json_encode($objectivearray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		}
		catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	
	function getAllDesiredlevels()
	{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$competency = $this->loadModel('Desiredlevel');
			$competencyarray = $competency->getAllDesiredlevels($arr);
			echo json_encode($competencyarray);	
				
	}
	
	function deleteSkillObjective($did)
	{		
		$deleteper = $this->CheckPermission(229, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Skillgap');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getSkillObjectiveData()
	{
		$editper = $this->CheckPermission(229, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(229, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		$objective = $this->loadModel('Skillgap');
		$objectivearray = $objective->getDataTable($editper, $deleteper);
		echo json_encode($objectivearray);
	}
	/***
	*Desired Level functions start from here
	*Created by Deeksha *on 29 march2018
	***/
	function desiredlevel()
    {	
		$addper = $this->CheckPermission(235, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->competencyid =0;
			$this->view->val = 0; 
        $this->view->render('performanceold/desiredlevel/addeditdesiredlevel');
		}else{
			header('location: ' . URL . 'performanceold/competency');
		}
    }
	
	function getDesiredLevel()
	{
		$viewper = $this->CheckPermission(235, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$competency = $this->loadModel('Desiredlevel');
			$competencyarray = $competency->getDesiredLevel();
			echo json_encode($competencyarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	 function updateDesiredLevel()
	{
		$editper = $this->CheckPermission(235, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$competency = $this->loadModel('Desiredlevel');
			$competencyarray = $competency->updateDesiredLevel($arr);
			echo json_encode($competencyarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
}	

