<?php

/**
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class performancedubai extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();

        // this controller should only be visible/usable by logged in users, so we put login-check here
        Auth::handleLogin();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    function index()
    {
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		if($sts==1 || $hrsts==1){
			$this->view->render('performancedubai/index');
		}else{
			$this->view->render('performancedubai/index1');
		}
        
    }
	
	function Assessmentcomparision()
    {
        $viewper = $this->CheckPermission(111, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(111, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performancedubai/Assessmentcomparision/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
    }
	
	function getemployeedata()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['designationid'];
			
			$objective = $this->loadModel('Assessmentdubai');
			$objectivearray = $objective->getAllEmployeeAtDesignation($arr);
			echo json_encode($objectivearray);			
			
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	function getemployeedesignationdata()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$objective = $this->loadModel('Assessmentdubai');
			$objectivearray = $objective->getAllEmployeeDesignation($arr);
			echo json_encode($objectivearray);			
			
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	function getcomparisiondata()
	{
		try{
		$viewper = $this->CheckPermission(111, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['employeeid'];
			$arr[3]= $_POST['dtfrom'];
			$arr[4]= $_POST['dtto'];
			
			$objective = $this->loadModel('Assessmentdubai');
			$objectivearray = $objective->getComparisionData($arr);
			echo json_encode($objectivearray);			
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){
			echo $e->getMessage();
			}
	}
	/** 
	 ///////////////////////////// Assessmentdubai CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	function Assessment()
    {
        $viewper = $this->CheckPermission(223, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(223, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performancedubai/employeeassessment/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
    }
	
	
	function viewAssessment($empid,$val)
    {	
		$viewper = $this->CheckPermission(223, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper  && isset($val)  && isset($empid)){
			$this->view->employeeid =$empid;
			$this->view->val = $val; 
			$this->view->render('performancedubai/employeeassessment/addassessment');
		}else{
			header('location: ' . URL . 'performancedubai/Assessment');
		}
    }
	function editAssessment($empid)
    {	
		$editper = $this->CheckPermission(223, 2); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($editper   && isset($empid)){
			$this->view->employeeid =$empid;
			$this->view->val = 0; 
			$this->view->render('performancedubai/employeeassessment/addassessment');
		}else{
			header('location: ' . URL . 'performancedubai/Assessment');
		}
    }
	function getempAssessment()
	{
		$viewper = $this->CheckPermission(223, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['assessmentid'];
			
			$objective = $this->loadModel('Assessmentdubai');
			$objectivearray = $objective->getAssessmentDetail($arr);
			echo json_encode($objectivearray);			
			}catch(Exception $e){
			echo $e->getMessage();
			}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	function getaAssessment()
	{
		$viewper = $this->CheckPermission(223, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			
			$id= $_POST['empid'];
			$objective = $this->loadModel('Assessmentdubai');
			$objectivearray = $objective->getDetail($id);
			echo json_encode($objectivearray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function createAssessment()
	{
		$editper = $this->CheckPermission(223, 2);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['assessmenttype'];
			$arr[6] = $_POST['achievements'];
			$arr[7] = $_POST['issues'];
			$arr[8] = $_POST['assessmentid'];
			$arr[9] = $_POST['potentials'];
			$arr[10] = $_POST['variablepay'];
			$arr[11] = $_POST['desc'];
			
			$objective = $this->loadModel('Assessmentdubai');
			$objectivearray = $objective->Create($arr);
			echo json_encode($objectivearray);	
						
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	
	 /**
     * Functions for perfom operation on objective table
     * delete function from objective list
	 * @returning json array of data as result
     */
	 
	 
	
	function getAssessmentData()
	{
		$editper = $this->CheckPermission(223, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(223, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$objective = $this->loadModel('Assessmentdubai');
		$objectivearray = $objective->getDataTable($editper, $deleteper);
		echo json_encode($objectivearray);
	}
	
	
	/** 
	 ///////////////////////////// Assessmentdubai CONTROLLER FUNCTION ENDS HERE  ////////////////////////////**/
	 
	 /** 
	 ///////////////////////////// Assessmentdubai RESULT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	
	function Assessmentresult()
    {
        $viewper = $this->CheckPermission(223, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(223, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performancedubai/Assessmentresult/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
    }
	
	function viewAssessmentresult($empid,$val)
    {	
		$viewper = $this->CheckPermission(223, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper  && isset($val)  && isset($empid)){
			$this->view->employeeid =$empid;
			$this->view->val = $val; 
			$this->view->render('performancedubai/Assessmentresult/Assessmentresult');
		}else{
			header('location: ' . URL . 'performancedubai/Assessment');
		}
    }
	function deleteAssessment($id)
	{		
		
			$dept = $this->loadModel('Assessmentdubai');
			$deptarray = $dept->Delete($id);
			echo json_encode($deptarray);	

		
		
	}
	function getAssessmentresultData()
	{
		$editper = $this->CheckPermission(223, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(223, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$objective = $this->loadModel('Assessmentdubai');
		$objectivearray = $objective->getAssessmentresultTable($editper, $deleteper);
		echo json_encode($objectivearray);
	}
	////////////////upload employee Assessmentdubai document/////////////
	
	 function uploadAssessmentDoc()
	{	
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]=$_POST['emp_id'];			
			$employee = $this->loadModel('Assessmentdubai');
			$employeearray = $employee->uploadDocument($arr);
			echo json_encode($employeearray);
			
		
	}
	
	/** 
	 ///////////////////////////// Objective CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function objective()
    {
        $viewper = $this->CheckPermission(222, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(222, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performancedubai/objective/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
    }
	function addobjective()
    {	
		$addper = $this->CheckPermission(222, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->objectiveid =0;
			$this->view->val = 0; 
        $this->view->render('performancedubai/objective/addeditobjective');
		}else{
			header('location: ' . URL . 'performancedubai/objective');
		}
    }
	
	function editobjective($id)
    {
		$editper = $this->CheckPermission(222, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->objectiveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performancedubai/objective/addeditobjective');
		}else{
			header('location: ' . URL . 'performancedubai/objective');
		}
    }
	
	function viewobjective($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->objectiveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performancedubai/objective/addeditobjective');
		}else{
			header('location: ' . URL . 'performancedubai/objective');
		}
		
    }
	
	function getallobjective()
	{
		$viewper = $this->CheckPermission(222, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$objective = $this->loadModel('AssessmentObjectivedubai');
			$objectivearray = $objective->getAll($arr);
			echo json_encode($objectivearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getseniordesig()
	{
		$desig = $_POST['designationid'];
		$objective = $this->loadModel('AssessmentObjectivedubai');
		$objectivearray = $objective->getSeniorDesigs($desig);
		echo json_encode($objectivearray);	
	}
	
	function getaobjective()
	{
		$viewper = $this->CheckPermission(222, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['objectiveid'];
			$objective = $this->loadModel('AssessmentObjectivedubai');
			$objectivearray = $objective->getDetail($gid);
			echo json_encode($objectivearray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	function createobjective()
	{
		$addper = $this->CheckPermission(222, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[4] = json_decode($_POST['desiglevel'], true); 
			$arr[5] = $_POST['threshholdscore'];
			$arr[6] = $_POST['achieveingamt'];
			$arr[7] = $_POST['variablepaysts'];
			
			$objective = $this->loadModel('AssessmentObjectivedubai');
			$objectivearray = $objective->Create($arr);
			echo json_encode($objectivearray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on objective table
     * delete function from objective list
	 * @returning json array of data as result
     */
	 
	 function updateobjective()
	{
		$editper = $this->CheckPermission(222, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[4] = $_POST['objectiveid'];
			$arr[5] = json_decode($_POST['desiglevel'], true); 
			$arr[6] = $_POST['threshholdscore'];
			$arr[7] = $_POST['achieveingamt'];
			$arr[8] = $_POST['variablepaysts'];
			
			$objective = $this->loadModel('AssessmentObjectivedubai');
			$objectivearray = $objective->Update($arr);
			echo json_encode($objectivearray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deleteobjective($did)
	{		
		$deleteper = $this->CheckPermission(222, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('AssessmentObjectivedubai');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getObjectiveData()
	{
		$editper = $this->CheckPermission(222, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(222, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$objective = $this->loadModel('AssessmentObjectivedubai');
		$objectivearray = $objective->getDataTable($editper, $deleteper);
		echo json_encode($objectivearray);
	}
	
	/** 
	 ///////////////////////////// Quadrant CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function quadrant()
    {
        $viewper = $this->CheckPermission(221, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(221, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performancedubai/quadrant/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
    }
	function addquadrant()
    {	
		$addper = $this->CheckPermission(221, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->quadrantid =0;
			$this->view->val = 0; 
        $this->view->render('performancedubai/quadrant/addeditquadrant');
		}else{
			header('location: ' . URL . 'performancedubai/quadrant');
		}
    }
	
	function editquadrant($id)
    {
		$editper = $this->CheckPermission(221, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->quadrantid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performancedubai/quadrant/addeditquadrant');
		}else{
			header('location: ' . URL . 'performancedubai/quadrant');
		}
    }
	
	function viewquadrant($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->quadrantid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performancedubai/quadrant/addeditquadrant');
		}else{
			header('location: ' . URL . 'performancedubai/quadrant');
		}
		
    }
	
	function getallquadrant()
	{
		$viewper = $this->CheckPermission(221, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$quadrant = $this->loadModel('Quadrantdubai');
			$quadrantarray = $quadrant->getAll($arr);
			echo json_encode($quadrantarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	
	
	function getaquadrant()
	{
		$viewper = $this->CheckPermission(221, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['quadrantid'];
			$quadrant = $this->loadModel('Quadrantdubai');
			$quadrantarray = $quadrant->getDetail($gid);
			echo json_encode($quadrantarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on quadrant table
     * getall function fetching quadrant list
	 * @returning json array of data as result
     */
	function createquadrant()
	{
		$addper = $this->CheckPermission(221, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['quadrantname'];
			$arr[3] = $_POST['color'];
			
			$quadrant = $this->loadModel('Quadrantdubai');
			$quadrantarray = $quadrant->Create($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	
	
	 /**
     * Functions for perfom operation on quadrant table
     * delete function from quadrant list
	 * @returning json array of data as result
     */
	 
	 function updatequadrant()
	{
		$editper = $this->CheckPermission(221, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['quadrantname'];
			$arr[3] = $_POST['quadrantid'];
			$arr[4] = $_POST['color'];
			$quadrant = $this->loadModel('Quadrantdubai');
			$quadrantarray = $quadrant->Update($arr);
			echo json_encode($quadrantarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletequadrant($did)
	{		
		$deleteper = $this->CheckPermission(221, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Quadrantdubai');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	function getperformanceDashboard($val,$type="")
	{        	
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];
		
		$empperformance = $this->loadModel('Dashboard');
		if($val==1)
		$empperformancearray = $empperformance->getperformanceDashboard1($arr);
		else
		$empperformancearray = $empperformance->getperformanceReportingDashboard($arr);
		echo json_encode($empperformancearray);
                     		
		
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getQuadrantData()
	{
		$editper = $this->CheckPermission(221, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(221, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$quadrant = $this->loadModel('Quadrantdubai');
		$quadrantarray = $quadrant->getDataTable($editper, $deleteper);
		echo json_encode($quadrantarray);
	}
	
	
	/** 
	 ///////////////////////////// Competency type CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function competencytype()
    {
		
        $viewper = $this->CheckPermission(127, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(127, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performancedubai/competencytype/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
    }
	function addcompetencytype()
    {	
		$addper = $this->CheckPermission(127, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->competencytypeid =0;
			$this->view->val = 0; 
        $this->view->render('performancedubai/competencytype/addeditcompetencytype');
		}else{
			header('location: ' . URL . 'performancedubai/competencytype');
		}
    }
	
	function editcompetencytype($id)
    {
		$editper = $this->CheckPermission(127, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->competencytypeid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performancedubai/competencytype/addeditcompetencytype');
		}else{
			header('location: ' . URL . 'performancedubai/competencytype');
		}
    }
	
	function viewcompetencytype($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->competencytypeid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performancedubai/competencytype/addeditcompetencytype');
		}else{
			header('location: ' . URL . 'performancedubai/competencytype');
		}
		
    }
	
	function getallcompetencytype()
	{
		$viewper = $this->CheckPermission(127, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$competencytype = $this->loadModel('Competencytype');
			$competencytypearray = $competencytype->getAll($arr);
			echo json_encode($competencytypearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	
	
	function getacompetencytype()
	{
		$viewper = $this->CheckPermission(127, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['competencytypeid'];
			$competencytype = $this->loadModel('Competencytype');
			$competencytypearray = $competencytype->getDetail($gid);
			echo json_encode($competencytypearray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on competencytype table
     * getall function fetching competencytype list
	 * @returning json array of data as result
     */
	function createcompetencytype()
	{
		$addper = $this->CheckPermission(127, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['comptype'];
			$arr[3] = $_POST['compcolor'];
			
			$competencytype = $this->loadModel('Competencytype');
			$competencytypearray = $competencytype->Create($arr);
			echo json_encode($competencytypearray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on competencytype table
     * delete function from competencytype list
	 * @returning json array of data as result
     */
	 
	 function updatecompetencytype()
	{
		$editper = $this->CheckPermission(127, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['comptype'];
			$arr[3] = $_POST['compcolor'];
			$arr[4] = $_POST['competencytypeid'];
			
			$competencytype = $this->loadModel('Competencytype');
			$competencytypearray = $competencytype->Update($arr);
			echo json_encode($competencytypearray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletecompetencytype($did)
	{		
		$deleteper = $this->CheckPermission(127, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Competencytype');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCompetencytypeData()
	{
		$editper = $this->CheckPermission(127, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(127, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
		$competencytype = $this->loadModel('Competencytype');
		$competencytypearray = $competencytype->getDataTable($editper, $deleteper);
		echo json_encode($competencytypearray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	/** 
	 ///////////////////////////// Competency CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function competency()
    {
        $viewper = $this->CheckPermission(128, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(128, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performancedubai/competency/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
    }
	function addcompetency()
    {	
		$addper = $this->CheckPermission(128, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->competencyid =0;
			$this->view->val = 0; 
        $this->view->render('performancedubai/competency/addeditcompetency');
		}else{
			header('location: ' . URL . 'performancedubai/competency');
		}
    }
	
	function editcompetency($id)
    {
		$editper = $this->CheckPermission(128, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->competencyid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performancedubai/competency/addeditcompetency');
		}else{
			header('location: ' . URL . 'performancedubai/competency');
		}
    }
	
	function viewcompetency($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->competencyid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performancedubai/competency/addeditcompetency');
		}else{
			header('location: ' . URL . 'performancedubai/competency');
		}
		
    }
	
	function getallcompetency()
	{
		$viewper = $this->CheckPermission(128, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->getAll($arr);
			echo json_encode($competencyarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getcompetency()
	{
		$viewper = $this->CheckPermission(128, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['competencytypeid'];
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->getCompetency($arr);
			echo json_encode($competencyarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getacompetency()
	{
		$viewper = $this->CheckPermission(128, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['competencyid'];
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->getDetail($gid);
			echo json_encode($competencyarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on competency table
     * getall function fetching competency list
	 * @returning json array of data as result
     */
	function createcompetency()
	{
		$addper = $this->CheckPermission(128, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['name'];
			$arr[3] = $_POST['ctype'];
			
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->Create($arr);
			echo json_encode($competencyarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on competency table
     * delete function from competency list
	 * @returning json array of data as result
     */
	 
	 function updatecompetency()
	{
		$editper = $this->CheckPermission(128, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['name'];
			$arr[3] = $_POST['ctype'];
			$arr[4] = $_POST['competencyid'];
			
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->Update($arr);
			echo json_encode($competencyarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletecompetency($did)
	{		
		$deleteper = $this->CheckPermission(128, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Competency');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCompetencyData()
	{
		$editper = $this->CheckPermission(128, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(128, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$competency = $this->loadModel('Competency');
		$competencyarray = $competency->getDataTable($editper, $deleteper);
		echo json_encode($competencyarray);
	}
	
	/** 
	 ///////////////////////////// Competency analysis CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function competencyanalysis()
    {
		
        $viewper = $this->CheckPermission(130, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(130, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performancedubai/competencyanalysis/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
    }
	function addcompetencyanalysis()
    {	
		$addper = $this->CheckPermission(130, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->competencyanalysisid =0;
			$this->view->val = 0; 
        $this->view->render('performancedubai/competencyanalysis/addeditanalysis');
		}else{
			header('location: ' . URL . 'performancedubai/competencyanalysis');
		}
    }
	
	function editcompetencyanalysis($id)
    {
		$editper = $this->CheckPermission(130, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->competencyanalysisid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performancedubai/competencyanalysis/addeditanalysis');
		}else{
			header('location: ' . URL . 'performancedubai/competencyanalysis');
		}
    }
	
	function viewcompetencyanalysis($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->competencyanalysisid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performancedubai/competencyanalysis/addeditanalysis');
		}else{
			header('location: ' . URL . 'performancedubai/competencyanalysis');
		}
		
    }
	
	function getallcompetencyanalysis()
	{
		$viewper = $this->CheckPermission(130, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$competencyanalysis = $this->loadModel('Competencyanalysis');
			$competencyanalysisarray = $competencyanalysis->getAll($arr);
			echo json_encode($competencyanalysisarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	
	
	function getacompetencyanalysis()
	{
		$viewper = $this->CheckPermission(130, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['competencyanalysisid'];
			$competencyanalysis = $this->loadModel('Competencyanalysis');
			$competencyanalysisarray = $competencyanalysis->getDetail($gid);
			echo json_encode($competencyanalysisarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	
	function getcombodata($field,$val)
	{
		$competencyanalysis = $this->loadModel('Competencyanalysis');
		$competencyanalysisarray = $competencyanalysis->getCombo($field,$val);
		echo json_encode($competencyanalysisarray);			
	}
	
	/** 
     * Functions for perfom operation on competencyanalysis table
     * getall function fetching competencyanalysis list
	 * @returning json array of data as result
     */
	function createcompetencyanalysis()
	{
		$addper = $this->CheckPermission(130, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[4] = json_decode($_POST['desiglevel'], true); 
			
			$competencyanalysis = $this->loadModel('Competencyanalysis');
			$competencyanalysisarray = $competencyanalysis->Create($arr);
			echo json_encode($competencyanalysisarray);		
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on competencyanalysis table
     * delete function from competencyanalysis list
	 * @returning json array of data as result
     */
	 
	 function updatecompetencyanalysis()
	{
		$editper = $this->CheckPermission(130, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[4] = json_decode($_POST['desiglevel'], true); 
			$arr[5] = $_POST['competencyanalysisid'];
			
			$competencyanalysis = $this->loadModel('Competencyanalysis');
			$competencyanalysisarray = $competencyanalysis->Update($arr);
			echo json_encode($competencyanalysisarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletecompetencyanalysis($did)
	{		
		$deleteper = $this->CheckPermission(130, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Competencyanalysis');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCompetencyAnalysisData()
	{
		$editper = $this->CheckPermission(130, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(130, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
		$competencyanalysis = $this->loadModel('Competencyanalysis');
		$competencyanalysisarray = $competencyanalysis->getDataTable($editper, $deleteper);
		echo json_encode($competencyanalysisarray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	/** 
	 ///////////////////////////// SKILL GAP Assessmentdubai CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	function skillgapAssessment()
    {
        $viewper = $this->CheckPermission(132, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(132, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performancedubai/skillgapAssessment/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
    }
	
	
	function viewskillgapAssessment($aid,$val)
    {	
		$viewper = $this->CheckPermission(132, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper  && isset($val)  && isset($aid)){
			$this->view->Assessmentid =$aid;
			$this->view->val = $val; 
			$this->view->render('performancedubai/skillgapAssessment/addAssessment');
		}else{
			header('location: ' . URL . 'performancedubai/skillgapAssessment');
		}
    }
	
	function editskillgapAssessment($aid)
    {	
		$editper = $this->CheckPermission(132, 2); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($editper  && isset($aid)){
			$this->view->Assessmentid =$aid;
			$this->view->val = 0; 
			$this->view->render('performancedubai/skillgapAssessment/addAssessment');
		}else{
			header('location: ' . URL . 'performancedubai/skillgapAssessment');
		}
    }
	function getskillgapAssessment()
	{
		$viewper = $this->CheckPermission(132, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['Assessmentid'];
			try{
			$objective = $this->loadModel('SkillgapAssessment');
			$objectivearray = $objective->getAssessmentDetail($arr);
			echo json_encode($objectivearray);			
			}catch(Exception $e){
				echo $e->getMessage();
			}
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getskillgapresult()
	{
		$viewper = $this->CheckPermission(132, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['Assessmentid'];
			try{
			$objective = $this->loadModel('SkillgapAssessment');
			$objectivearray = $objective->getAssessmentResult($arr);
			echo json_encode($objectivearray);			
			}catch(Exception $e){
				echo $e->getMessage();
			}
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getaskillgapAssessment()
	{
		$viewper = $this->CheckPermission(132, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			
			$id= $_POST['empid'];
			$objective = $this->loadModel('SkillgapAssessment');
			$objectivearray = $objective->getDetail($id);
			echo json_encode($objectivearray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function createskillgapAssessment()
	{
		$edit = $this->CheckPermission(132, 2);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($edit)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['Assessmenttype'];
			$arr[6] = $_POST['Assessmentid'];
			$objective = $this->loadModel('SkillgapAssessment');
			$objectivearray = $objective->Create($arr);
			echo json_encode($objectivearray);	
						
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	
	 /**
     * Functions for perfom operation on objective table
     * delete function from objective list
	 * @returning json array of data as result
     */
	 
	 
	
	function getSkillgapAssessmentData()
	{
		$editper = $this->CheckPermission(132, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(132, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
		$objective = $this->loadModel('SkillgapAssessment');
		$objectivearray = $objective->getDataTable($editper, $deleteper);
		echo json_encode($objectivearray);
		}catch(Exception $e){
				echo $e->getMessage();
			}	
	}
	
	
	/** 
	 ///////////////////////////// Assessmentdubai CONTROLLER FUNCTION ENDS HERE  ////////////////////////////**/
	  /** 
	 ///////////////////////////// SKILL GAP Assessmentdubai RESULT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	
	function skillgapresult()
    {
        $viewper = $this->CheckPermission(132, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(132, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performancedubai/skillgapresult/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
    }
	
	function viewskillgapresult($empid,$val)
    {	
		$viewper = $this->CheckPermission(132, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper  && isset($val)  && isset($empid)){
			$this->view->Assessmentid =$empid;
			$this->view->val = $val; 
			$this->view->render('performancedubai/skillgapresult/skillgapresult');
		}else{
			header('location: ' . URL . 'performancedubai/skillgapAssessment');
		}
    }
	
	function getSkillgapresultData()
	{
		$editper = $this->CheckPermission(132, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(132, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$objective = $this->loadModel('SkillgapAssessment');
		$objectivearray = $objective->getAssessmentresultTable($editper, $deleteper);
		echo json_encode($objectivearray);
	}
	
	 ////////////////////////////  REPORT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
    /* Functions for perfom operation on report table
     * getall function fetching report list
	 * @returning json array of data as result
     */
	
	function report()
    {
		$viewper = $this->CheckPermission(167, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(167, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performancedubai/reports/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
    }
	function addreport()
    {
		$addper = $this->CheckPermission(167, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->reportid =0;
			$this->view->val = 0; 
			$this->view->render('performancedubai/reports/addeditreport');
		}else{
			header('location: ' . URL . 'performancedubai/report');
		}
    }
	
	function editreport($id)
    {
		$editper = $this->CheckPermission(167, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->reportid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performancedubai/reports/addeditreport');
		}else{
			header('location: ' . URL . 'performancedubai/report');
		}
		
    }
	
	function viewreport1($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->val = $val; 
			$this->view->render('performancedubai/reports/addeditreport');
		}else{
			header('location: ' . URL . 'performancedubai/report');
		}
		
    }
	function viewreport($id)
    {
		
		if(isset($id) )
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->render('performancedubai/reports/viewreport');
		}else{
			header('location: ' . URL . 'performancedubai/report');
		}
		
    }
	
	function daterangereport($val)
	{
		try{
			$deptarray=array();
			$dept = $this->loadModel('Report');
			if($val==15){
				$deptarray = $dept->EmployeeAssessmentReport();
			}
			elseif($val==13){
				$deptarray = $dept->EmployeeAssessmentCompleteReport();
			}
			
			echo json_encode($deptarray);
		}catch(Exception $e) {
			echo $e->getMessage();
		}
	}	
	function deletereport($did)
	{
		$deleteper = $this->CheckPermission(167, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Report');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'performancedubai/report');
	}
	
	
	function getReportData()
	{
		$editper = $this->CheckPermission(167, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(167, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$tabid=6;
		$report = $this->loadModel('Report');
		$reportarray = $report->getDataTable($editper, $deleteper,$tabid);
		echo json_encode($reportarray);
	}
	//////////Performace Indicator////
	function indicatorattribute()
	{
		$viewper = $this->CheckPermission(171, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(171, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->indicateid=0;
			$this->view->render('performancedubai/indicator/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
	}
	function getIndicatorAttributeData()
	{
		$editper = $this->CheckPermission(171, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(171, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$indicator = $this->loadModel('performancedubaiindicator');
		$indicatorarray = $indicator->getIndicatorAttributeTable($editper, $deleteper);
		echo json_encode($indicatorarray);
	}
	
	function gettraining()
	{
		try{
		$editper = $this->CheckPermission(171, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(171, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$indicator = $this->loadModel('performancedubaiindicator');
		$indicatorarray = $indicator->getTraining($editper, $deleteper);
		echo json_encode($indicatorarray);
		}catch(Exception $e) {
		echo $errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	function gettrainer()
	{
		try{
		$editper = $this->CheckPermission(171, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(171, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$indicator = $this->loadModel('performancedubaiindicator');
		$indicatorarray = $indicator->getTrainer($editper, $deleteper);
		echo json_encode($indicatorarray);
		}catch(Exception $e) {
		echo $errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	function editTraining($id,$val)
    {
		try{
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid =$id;
			$this->view->val =$val;
			$this->view->render('performancedubai/training/addtrainee');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
	}catch(Exception $e){}
    }
	
	function editTrainer($id,$val)
    {
		try{
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainerid =$id;
			$this->view->val =$val;
			$this->view->render('performancedubai/trainer/addtrainer');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
	}catch(Exception $e){}
    }
	
	function createindicator()
	{
		try{$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['attributes'];
		$arr[3] = $_POST['marks'];
			
		$indicator = $this->loadModel('performancedubaiindicator');
		$indicatorarray = $indicator->Create($arr);
		echo json_encode($indicatorarray);	
		}catch(Exception $e){}
		
	}
	function updateindicator()
	{
		try{$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['attributes'];
		$arr[3] = $_POST['marks'];
		$arr[4] = $_POST['indicateid'];
			
		$indicator = $this->loadModel('performancedubaiindicator');
		$indicatorarray = $indicator->Update($arr);
		echo json_encode($indicatorarray);	
		}catch(Exception $e){}
		
	}
	function deleteindicator($did)
	{		
		$deleteper = $this->CheckPermission(171, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$indicator = $this->loadModel('performancedubaiindicator');
			$indicatorarray = $indicator->Delete($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	function getindicator()
	{try{
		$viewper = $this->CheckPermission(171, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			
			$id= $_POST['indicateid'];
			$indicator = $this->loadModel('performancedubaiindicator');
			$indicatorarray = $indicator->getDetail($id);
			echo json_encode($indicatorarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}
	}
	//////////Performace Assess Indicator////
	function assessindicator()
	{
		$viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			
			$this->view->render('performancedubai/assessindicator/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
	}
	
	function trainer()
	{
		$viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainerid=0;
			
			$this->view->render('performancedubai/trainer/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
	}
	
	function training()
	{
		$viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid=0;
			$this->view->render('performancedubai/training/index');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
	}
	
	function createtraining()
	{
		try{
		$addper = $this->CheckPermission(112, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['competencyid'];
			$arr[3] = $_POST['trainee'];
			$arr[4] = $_POST['trainerid'];
			$arr[5] = $_POST['startdate'];
			$arr[6] = $_POST['enddate'];
			$arr[7] = $_POST['timefrom'];
			$arr[8] = $_POST['timeto'];
			$quadrant = $this->loadModel('performancedubaiindicator');
			$quadrantarray = $quadrant->CreateTraining($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	function createtrainer()
	{
		try{
		$addper = $this->CheckPermission(112, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['trainer_name'];
			$arr[3] = $_POST['trainer_email'];
			$arr[4] = $_POST['trainer_address'];
			$arr[5] = $_POST['trainer_mobile'];
			$arr[6] = $_POST['trainer_experience'];
			$arr[7] = $_POST['trainer_qualification'];
			$arr[8] = $_POST['trainer_specialization'];
			$quadrant = $this->loadModel('performancedubaiindicator');
			$quadrantarray = $quadrant->CreateTrainer($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	
function updatetrainer()
	{
		try{
		$addper = $this->CheckPermission(112, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['trainer_name'];
			$arr[3] = $_POST['trainer_email'];
			$arr[4] = $_POST['trainer_address'];
			$arr[5] = $_POST['trainer_mobile'];
			$arr[6] = $_POST['trainer_experience'];
			$arr[7] = $_POST['trainer_qualification'];
			$arr[8] = $_POST['trainer_specialization'];
			$arr[9] = $_POST['trainerid'];
			$quadrant = $this->loadModel('performancedubaiindicator');
			$quadrantarray = $quadrant->updateTrainer($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	
	function updatetraining()
	{
		$addper = $this->CheckPermission(112, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['competencyid'];
			$arr[3] = $_POST['trainee'];
			$arr[4] = $_POST['trainerid'];
			$arr[5] = $_POST['startdate'];
			$arr[6] = $_POST['enddate'];
			$arr[7] = $_POST['timefrom'];
			$arr[8] = $_POST['timeto'];
			$arr[9] = $_POST['trainingid'];
			$quadrant = $this->loadModel('performancedubaiindicator');
			$quadrantarray = $quadrant->updateTraining($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	function deleteTraining($did)
	{
		$deleteper = $this->CheckPermission(113, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('performancedubaiindicator');
			$deptarray = $dept->DeleteTraining($did);
			echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	function deleteTrainer($did)
	{
		$deleteper = $this->CheckPermission(113, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('performancedubaiindicator');
			$deptarray = $dept->DeleteTrainer($did);
			echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	function addTrainer()
    {
		try{
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainerid =0;
			$this->view->val = 0; 
			$this->view->render('performancedubai/trainer/addtrainer');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
	}catch(Exception $e){}
    }
	
	function getcompetencyemployee()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['competencyid'];
			$indicator = $this->loadModel('performancedubaiindicator');
			$employeearray = $indicator->getCompetencyEmployee($arr);
			echo json_encode($employeearray);		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	function addTrainee()
    {
		try{
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid =0;
			$this->view->val = 0; 
			$this->view->render('performancedubai/training/addtrainee');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
	}catch(Exception $e){}
    }
	function getAssignIndicatorData()
	{
		$editper = $this->CheckPermission(184, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(184, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$indicator = $this->loadModel('Pimaster');
		$indicatorarray = $indicator->getAssignIndicatorData($editper, $deleteper);
		echo json_encode($indicatorarray);
	}
	function addAssignIndicator()
    {try{
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->assignid =0;
			$this->view->val = 0; 
			$this->view->render('performancedubai/assessindicator/assignindicator');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
	}catch(Exception $e){}
    }
	
	function getAllindicator()
	{
		$indicator = $this->loadModel('Pimaster');
		$indicatorarray = $indicator->getAllindicator();
		echo json_encode($indicatorarray);
	}
	function createAssignindicator()
	{
		try{$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['emp_id'];
		$arr[3] = $_POST['month'];
		$arr[4] = $_POST['totalmarks'];
		$arr[5] = $_POST['totalamt'];
		$arr[6] = $_POST['remark'];
			
		$indicator = $this->loadModel('Pimaster');
		$indicatorarray = $indicator->Create($arr);
		echo json_encode($indicatorarray);	
		}catch(Exception $e){}
		
	}
	function deleteAssignindicator($did)
	{		
		try{$deleteper = $this->CheckPermission(184, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$indicator = $this->loadModel('Pimaster');
			$indicatorarray = $indicator->Delete($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getAllassessdata($did)
	{		
		try{
		if(isset($did))
		{
			$indicator = $this->loadModel('Pimaster');
			$indicatorarray = $indicator->GetAssessdata($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getAlltrainingdata($did)
	{		
		try{
		if(isset($did))
		{
			$indicator = $this->loadModel('performancedubaiindicator');
			$indicatorarray = $indicator->getAlltrainingdata($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getAlltrainerdata($did)
	{		
		try{
		if(isset($did))
		{
			$indicator = $this->loadModel('performancedubaiindicator');
			$indicatorarray = $indicator->getAlltrainerdata($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function editAssessindicator($id,$val)
    {try{
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->assignid =$id;
			$this->view->val =$val;
			$this->view->render('performancedubai/assessindicator/assignindicator');
		}else{
			header('location: ' . URL . 'performancedubai/index');
		}
	}catch(Exception $e){}
    }
	function updateAssignindicator()
	{
		try{$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['assignid'];
		$arr[3] = $_POST['totalamt'];
		$arr[4] = $_POST['remark'];
			
		$indicator = $this->loadModel('Pimaster');
		$indicatorarray = $indicator->Update($arr);
		echo json_encode($indicatorarray);	
		}catch(Exception $e){}
		
	}
}	

