<?php

/**
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class Performance extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();

        // this controller should only be visible/usable by logged in users, so we put login-check here
        Auth::handleLogin();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    function index(){
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		if($sts==1 || $hrsts==1){
			$this->view->render('performance/index');
		}else{
			$this->view->render('performance/index');
		}
    }
	
	    function trainingcalendar(){
	
			$this->view->render('performance/training/training_calendar');
		
    }
	
	function assessmentcomparision(){
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/assessmentcomparision/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	
	function getemployeedata(){
		try{
			
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['designationid'];
			$objective = $this->loadModel('Assessment');
			$objectivearray = $objective->getAllEmployeeAtDesignation($arr);
			echo json_encode($objectivearray);	
			
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	function getemployeedesignationdata()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$objective = $this->loadModel('Assessment');
			$objectivearray = $objective->getAllEmployeeDesignation($arr);
			echo json_encode($objectivearray);			
			
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	function getcomparisiondata()
	{
		try{
		$viewper = $this->CheckPermission(184, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['employeeid'];
			$arr[3]= $_POST['dtfrom'];
			$arr[4]= $_POST['dtto'];
			
			$objective = $this->loadModel('Assessment');
			$objectivearray = $objective->getComparisionData($arr);
			echo json_encode($objectivearray);			
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){
			echo $e->getMessage();
			}
	}
	/** 
	 ///////////////////////////// ASSESSMENT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	function assessment()
    {
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/employeeassessment/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	
	/* function assessmentresult()
    {
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/employeeassessment/assessmentresult');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    } */
	
	
	function viewassessment($empid,$val)
    {	
		$viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper  && isset($val)  && isset($empid)){
			$this->view->employeeid =$empid;
			$this->view->val = $val; 
			$this->view->render('performance/employeeassessment/addassessment');
		}else{
			header('location: ' . URL . 'performance/assessment');
		}
    }
	function editassessment($empid)
    {	
		$editper = $this->CheckPermission(184, 2); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($editper   && isset($empid)){
			$this->view->employeeid =$empid;
			$this->view->val = 0; 
			$this->view->render('performance/employeeassessment/addassessment');
		}else{
			header('location: ' . URL . 'performance/assessment');
		}
    }
	function getempassessment()
	{
		 $viewper = $this->CheckPermission(184, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{ 
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['assessmentid'];
			try{
			$objective = $this->loadModel('Assessment');
			$objectivearray = $objective->getassessmentDetail($arr);
			echo json_encode($objectivearray);			
	}catch(Exception $e){
			echo $e->getMessage();
			}
		 }else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		} 
	}
	function getaassessment()
	{
		$viewper = $this->CheckPermission(184, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$id= $_POST['empid'];
			$arr[2]= $_POST['assessmentid'];
			$objective = $this->loadModel('Assessment');
			$objectivearray = $objective->getDetail($id);
			echo json_encode($objectivearray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function createassessment()
	{
		 $editper = $this->CheckPermission(184, 2);  ///////// CHECK FOR VIEW PERMISSION //////
		if($editper)
		{ 
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['assessmenttype'];
			$arr[6] = $_POST['totalmarks'];
			$arr[7] = $_POST['totalamt'];
			$arr[8] = $_POST['assessmentid'];
			$arr[9] = $_POST['rating'];
			$arr[10] = $_POST['result'];
			$arr[11] = $_POST['desc'];
			$arr[12] = $_POST['improvements'];
			
			$objective = $this->loadModel('Assessment');
			$objectivearray = $objective->Create($arr);
			echo json_encode($objectivearray);	
						
		 }else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		} 
	}
	
	
	 /**
     * Functions for perfom operation on objective table
     * delete function from objective list
	 * @returning json array of data as result
     */
	 
	 
	
	function getAssessmentData()
	{
		try{
		$editper = $this->CheckPermission(184, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(184, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$objective = $this->loadModel('Assessment');
		$objectivearray = $objective->getDataTable($editper, $deleteper);
		echo json_encode($objectivearray);
		}
		catch(Exception $e){}
	}
	
	
	/** 
	 ///////////////////////////// ASSESSMENT CONTROLLER FUNCTION ENDS HERE  ////////////////////////////**/
	 
	 /** 
	 ///////////////////////////// ASSESSMENT RESULT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	
	function assessmentresult()
    {
        $viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(184, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/assessmentresult/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	
	function viewassessmentresult($empid,$val)
    {	
		$viewper = $this->CheckPermission(184, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper  && isset($val)  && isset($empid)){
			$this->view->employeeid =$empid;
			$this->view->val = $val; 
			$this->view->render('performance/assessmentresult/assessmentresult');
		}else{
			header('location: ' . URL . 'performance/assessment');
		}
    }
	function deleteassessment($id)
	{	
		$dept = $this->loadModel('Assessment');
		$deptarray = $dept->Delete($id);
		echo json_encode($deptarray);	
	}
	function getAssessmentresultData()
	{
		$editper = $this->CheckPermission(184, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(184, 3); ///////// CHECK FOR DELETE PERMISSION  ///	
		$objective = $this->loadModel('Assessment');
		$objectivearray = $objective->getAssessmentresultTable($editper, $deleteper);
		echo json_encode($objectivearray);
	}
	////////////////upload employee assessment document/////////////
	
	 function uploadAssessmentDoc()
	{	
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]=$_POST['emp_id'];			
			$employee = $this->loadModel('Assessment');
			$employeearray = $employee->uploadDocument($arr);
			echo json_encode($employeearray);
	}
	
	/** 
	 ///////////////////////////// Objective CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function objective()
    {
        $viewper = $this->CheckPermission(171, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(171, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/objective/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	function addobjective()
    {	
		$addper = $this->CheckPermission(171, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->objectiveid =0;
			$this->view->val = 0; 
        $this->view->render('performance/objective/addeditobjective');
		}else{
			header('location: ' . URL . 'performance/objective');
		}
    }
	
	function editobjective($id)
    {
		$editper = $this->CheckPermission(171, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->objectiveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performance/objective/addeditobjective');
		}else{
			header('location: ' . URL . 'performance/objective');
		}
    }
	
	function viewobjective($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->objectiveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performance/objective/addeditobjective');
		}else{
			header('location: ' . URL . 'performance/objective');
		}
		
    }
	
	function getallobjective()
	{
		$viewper = $this->CheckPermission(171, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$objective = $this->loadModel('AssessmentObjective');
			$objectivearray = $objective->getAll($arr);
			echo json_encode($objectivearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getseniordesig()
	{
		$desig = $_POST['designationid'];
		$objective = $this->loadModel('AssessmentObjective');
		$objectivearray = $objective->getSeniorDesigs($desig);
		echo json_encode($objectivearray);	
	}
	
	function getaobjective()
	{
		$viewper = $this->CheckPermission(171, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['objectiveid'];
			$objective = $this->loadModel('AssessmentObjective');
			$objectivearray = $objective->getDetail($gid);
			echo json_encode($objectivearray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	function createobjective()
	{
		$addper = $this->CheckPermission(171, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[5] = $_POST['object'];
			$arr[4] = json_decode($_POST['desiglevel'], true); 
			
			$objective = $this->loadModel('AssessmentObjective');
			$objectivearray = $objective->Create($arr);
			echo json_encode($objectivearray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on objective table
     * delete function from objective list
	 * @returning json array of data as result
     */
	 
	 function updateobjective()
	{
		$editper = $this->CheckPermission(171, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[4] = $_POST['objectiveid'];
			$arr[5] = json_decode($_POST['desiglevel'], true); 
			$arr[6] = $_POST['object'];
			$objective = $this->loadModel('AssessmentObjective');
			$objectivearray = $objective->Update($arr);
			echo json_encode($objectivearray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deleteobjective($did)
	{		
		$deleteper = $this->CheckPermission(171, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('AssessmentObjective');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getObjectiveData()
	{
		$editper = $this->CheckPermission(171, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(171, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$objective = $this->loadModel('AssessmentObjective');
		$objectivearray = $objective->getDataTable($editper, $deleteper);
		echo json_encode($objectivearray);
	}
	
	/** 
	 ///////////////////////////// Quadrant CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function quadrant()
    {
        $viewper = $this->CheckPermission(112, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(112, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/quadrant/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	function skills()
    {
        $viewper = $this->CheckPermission(112, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(112, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/quadrant/Skills');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	function addquadrant($ctype)
    {	
		$addper = $this->CheckPermission(112, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->quadrantid =0;
			$this->view->val = 0; 
			$this->view->ctype = $ctype; 
        $this->view->render('performance/quadrant/addeditquadrant');
		}else{
			header('location: ' . URL . 'performance/quadrant');
		}
    }
	
	function editquadrant($id)
    {
		$editper = $this->CheckPermission(112, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->quadrantid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->ctype = 1; 
			$this->view->render('performance/quadrant/addeditquadrant');
		}else{
			header('location: ' . URL . 'performance/quadrant');
		}
    }
	
	function editSkillArea($id)
    {
		$editper = $this->CheckPermission(112, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->quadrantid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->ctype = 2; 
			$this->view->render('performance/quadrant/addeditquadrant');
		}else{
			header('location: ' . URL . 'performance/quadrant');
		}
    }
	
	function viewquadrant($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->quadrantid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performance/quadrant/addeditquadrant');
		}else{
			header('location: ' . URL . 'performance/quadrant');
		}
		
    }
	
	function getallquadrant()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$quadrant = $this->loadModel('Quadrant');
			$quadrantarray = $quadrant->getAll($arr);
			echo json_encode($quadrantarray);	
			
			
	}
	
	
	
	function getaquadrant()
	{
		$viewper = $this->CheckPermission(112, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['quadrantid'];
			$quadrant = $this->loadModel('Quadrant');
			$quadrantarray = $quadrant->getDetail($gid);
			echo json_encode($quadrantarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on quadrant table
     * getall function fetching quadrant list
	 * @returning json array of data as result
     */
	function createquadrant()
	{
		$addper = $this->CheckPermission(112, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['quadrantname'];
			$arr[3] = $_POST['color'];
			$arr[4] = $_POST['desc'];
			$arr[5] = $_POST['ctype'];
			$arr[6] = $_POST['desig'];
			
			$quadrant = $this->loadModel('Quadrant');
			$quadrantarray = $quadrant->Create($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	
	
	 /**
     * Functions for perfom operation on quadrant table
     * delete function from quadrant list
	 * @returning json array of data as result
     */
	 
	 function updatequadrant()
	{
		$editper = $this->CheckPermission(112, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['quadrantname'];
			$arr[3] = $_POST['quadrantid'];
			$arr[4] = $_POST['color'];
			$arr[5] = $_POST['desc'];
			$arr[6] = $_POST['ctype'];
			$arr[7] = $_POST['desig'];
			$quadrant = $this->loadModel('Quadrant');
			$quadrantarray = $quadrant->Update($arr);
			echo json_encode($quadrantarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletequadrant($did)
	{		
		$deleteper = $this->CheckPermission(112, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Quadrant');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	function getPerformanceDashboard($val,$type="")
	{        
		try{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];
		
		$empperformance = $this->loadModel('Dashboard');
		if($val==1)
		$empperformancearray = $empperformance->getPerformanceDashboard1($arr);
		else
		$empperformancearray = $empperformance->getPerformanceDashboard1($arr);
		echo json_encode($empperformancearray);
		}
		catch(Exception $e)
		{
			
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getQuadrantData()
	{
		$editper = $this->CheckPermission(112, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(112, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$quadrant = $this->loadModel('Quadrant');
		$quadrantarray = $quadrant->getDataTable($editper, $deleteper);
		echo json_encode($quadrantarray);
	}
	//for functional competencies//
	function getFuncQuadrantData()
	{
		try{
		$editper = $this->CheckPermission(112, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(112, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$quadrant = $this->loadModel('Quadrant');
		$quadrantarray = $quadrant->getFuncDataTable($editper, $deleteper);
		echo json_encode($quadrantarray);
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	
	 function onUpdateSkill()
	{
		$editper = $this->CheckPermission(112, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['skillname'];
			$arr[3] = $_POST['skillId'];
			$arr[4] = $_POST['QuadrantId'];
			$quadrant = $this->loadModel('Quadrant');
			$quadrantarray = $quadrant->onUpdateSkill($arr);
			echo json_encode($quadrantarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	/** 
	 ///////////////////////////// Competency type CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function competencytype()
    {
		
        $viewper = $this->CheckPermission(127, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(127, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/competencytype/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	function addcompetencytype()
    {	
		$addper = $this->CheckPermission(127, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->competencytypeid =0;
			$this->view->val = 0; 
        $this->view->render('performance/competencytype/addeditcompetencytype');
		}else{
			header('location: ' . URL . 'performance/competencytype');
		}
    }
	
	function editcompetencytype($id)
    {
		$editper = $this->CheckPermission(127, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->competencytypeid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performance/competencytype/addeditcompetencytype');
		}else{
			header('location: ' . URL . 'performance/competencytype');
		}
    }
	
	function viewcompetencytype($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->competencytypeid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performance/competencytype/addeditcompetencytype');
		}else{
			header('location: ' . URL . 'performance/competencytype');
		}
		
    }
	
	function getallcompetencytype()
	{
		$viewper = $this->CheckPermission(127, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$competencytype = $this->loadModel('Competencytype');
			$competencytypearray = $competencytype->getAll($arr);
			echo json_encode($competencytypearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	
	
	function getacompetencytype()
	{
		$viewper = $this->CheckPermission(127, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['competencytypeid'];
			$competencytype = $this->loadModel('Competencytype');
			$competencytypearray = $competencytype->getDetail($gid);
			echo json_encode($competencytypearray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on competencytype table
     * getall function fetching competencytype list
	 * @returning json array of data as result
     */
	function createcompetencytype()
	{
		$addper = $this->CheckPermission(127, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['comptype'];
			$arr[3] = $_POST['compcolor'];
			
			$competencytype = $this->loadModel('Competencytype');
			$competencytypearray = $competencytype->Create($arr);
			echo json_encode($competencytypearray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on competencytype table
     * delete function from competencytype list
	 * @returning json array of data as result
     */
	 
	 function updatecompetencytype()
	{
		$editper = $this->CheckPermission(127, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['comptype'];
			$arr[3] = $_POST['compcolor'];
			$arr[4] = $_POST['competencytypeid'];
			
			$competencytype = $this->loadModel('Competencytype');
			$competencytypearray = $competencytype->Update($arr);
			echo json_encode($competencytypearray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletecompetencytype($did)
	{		
		$deleteper = $this->CheckPermission(127, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Competencytype');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCompetencytypeData()
	{
		$editper = $this->CheckPermission(127, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(127, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
		$competencytype = $this->loadModel('Competencytype');
		$competencytypearray = $competencytype->getDataTable($editper, $deleteper);
		echo json_encode($competencytypearray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	/** 
	 ///////////////////////////// Competency CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function competency()
    {
        $viewper = $this->CheckPermission(128, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(128, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/competency/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	function addcompetency()
    {	
		$addper = $this->CheckPermission(128, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->competencyid =0;
			$this->view->val = 0; 
        $this->view->render('performance/competency/addeditcompetency');
		}else{
			header('location: ' . URL . 'performance/competency');
		}
    }
	
	function editcompetency($id)
    {
		$editper = $this->CheckPermission(128, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->competencyid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performance/competency/addeditcompetency');
		}else{
			header('location: ' . URL . 'performance/competency');
		}
    }
	
	function viewcompetency($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->competencyid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performance/competency/addeditcompetency');
		}else{
			header('location: ' . URL . 'performance/competency');
		}
		
    }
	
	function getallcompetency()
	{
		$viewper = $this->CheckPermission(128, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->getAll($arr);
			echo json_encode($competencyarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getcompetency()
	{
		$viewper = $this->CheckPermission(128, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['competencytypeid'];
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->getCompetency($arr);
			echo json_encode($competencyarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	function getacompetency()
	{
		$viewper = $this->CheckPermission(128, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['competencyid'];
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->getDetail($gid);
			echo json_encode($competencyarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on competency table
     * getall function fetching competency list
	 * @returning json array of data as result
     */
	function createcompetency()
	{
		$addper = $this->CheckPermission(128, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['name'];
			$arr[3] = $_POST['ctype'];
			
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->Create($arr);
			echo json_encode($competencyarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on competency table
     * delete function from competency list
	 * @returning json array of data as result
     */
	 
	 function updatecompetency()
	{
		$editper = $this->CheckPermission(128, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['name'];
			$arr[3] = $_POST['ctype'];
			$arr[4] = $_POST['competencyid'];
			
			$competency = $this->loadModel('Competency');
			$competencyarray = $competency->Update($arr);
			echo json_encode($competencyarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletecompetency($did)
	{		
		$deleteper = $this->CheckPermission(128, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Competency');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCompetencyData()
	{
		$editper = $this->CheckPermission(128, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(128, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$competency = $this->loadModel('Competency');
		$competencyarray = $competency->getDataTable($editper, $deleteper);
		echo json_encode($competencyarray);
	}
	
	/** 
	 ///////////////////////////// Competency analysis CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching objective list
	 * @returning json array of data as result
     */
	
	function competencyanalysis()
    {
		
        $viewper = $this->CheckPermission(130, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(130, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/competencyanalysis/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	function assessmentfrequency()
    {
		
        $viewper = $this->CheckPermission(171, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(171, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/competencyanalysis/index1');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	function addcompetencyanalysis1()
    {	
		$addper = $this->CheckPermission(171, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->competencyanalysisid =0;
			$this->view->val = 0; 
        $this->view->render('performance/competencyanalysis/addeditanalysis');
		}else{
			header('location: ' . URL . 'performance/competencyanalysis');
		}
    }
	function addcompetencyanalysis()
    {	
		$addper = $this->CheckPermission(130, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->competencyanalysisid =0;
			$this->view->val = 0; 
        $this->view->render('performance/competencyanalysis/addeditanalysis');
		}else{
			header('location: ' . URL . 'performance/competencyanalysis');
		}
    }
	
	function editcompetencyanalysis($id)
    {
		$editper = $this->CheckPermission(130, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->competencyanalysisid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performance/competencyanalysis/addeditanalysis');
		}else{
			header('location: ' . URL . 'performance/competencyanalysis');
		}
    }
	
	function viewcompetencyanalysis($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->competencyanalysisid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performance/competencyanalysis/addeditanalysis');
		}else{
			header('location: ' . URL . 'performance/competencyanalysis');
		}
		
    }
	
	function getallcompetencyanalysis()
	{
		$viewper = $this->CheckPermission(130, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$competencyanalysis = $this->loadModel('Competencyanalysis');
			$competencyanalysisarray = $competencyanalysis->getAll($arr);
			echo json_encode($competencyanalysisarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	
	
	
	function getacompetencyanalysis()
	{
		$viewper = $this->CheckPermission(130, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['competencyanalysisid'];
			$competencyanalysis = $this->loadModel('Competencyanalysis');
			$competencyanalysisarray = $competencyanalysis->getDetail($gid);
			echo json_encode($competencyanalysisarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	
	function getcombodata($field,$val)
	{
		$competencyanalysis = $this->loadModel('Competencyanalysis');
		$competencyanalysisarray = $competencyanalysis->getCombo($field,$val);
		echo json_encode($competencyanalysisarray);			
	}
	
	/** 
     * Functions for perfom operation on competencyanalysis table
     * getall function fetching competencyanalysis list
	 * @returning json array of data as result
     */
	function createcompetencyanalysis()
	{
		$addper = $this->CheckPermission(130, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[4] = json_decode($_POST['desiglevel'], true); 
			
			$competencyanalysis = $this->loadModel('Competencyanalysis');
			$competencyanalysisarray = $competencyanalysis->Create($arr);
			echo json_encode($competencyanalysisarray);		
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on competencyanalysis table
     * delete function from competencyanalysis list
	 * @returning json array of data as result
     */
	 
	 function updatecompetencyanalysis()
	{
		$editper = $this->CheckPermission(130, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['desig'];
			$arr[3] = $_POST['period'];
			$arr[4] = json_decode($_POST['desiglevel'], true); 
			$arr[5] = $_POST['competencyanalysisid'];
			
			$competencyanalysis = $this->loadModel('Competencyanalysis');
			$competencyanalysisarray = $competencyanalysis->Update($arr);
			echo json_encode($competencyanalysisarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletecompetencyanalysis($did)
	{		
		$deleteper = $this->CheckPermission(130, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Competencyanalysis');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getCompetencyAnalysisData()
	{
		$editper = $this->CheckPermission(130, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(130, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
		$competencyanalysis = $this->loadModel('Competencyanalysis');
		$competencyanalysisarray = $competencyanalysis->getDataTable($editper, $deleteper);
		echo json_encode($competencyanalysisarray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	/** 
	 ///////////////////////////// SKILL GAP ASSESSMENT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	function skillgapassessment()
    {
        $viewper = $this->CheckPermission(132, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(132, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/skillgapassessment/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	
	
	function viewskillgapassessment($aid,$val)
    {	
		$viewper = $this->CheckPermission(132, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper  && isset($val)  && isset($aid)){
			$this->view->assessmentid =$aid;
			$this->view->val = $val; 
			$this->view->render('performance/skillgapassessment/addassessment');
		}else{
			header('location: ' . URL . 'performance/skillgapassessment');
		}
    }
	
	function editskillgapassessment($aid)
    {	
		$editper = $this->CheckPermission(132, 2); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($editper  && isset($aid)){
			$this->view->assessmentid =$aid;
			$this->view->val = 0; 
			$this->view->render('performance/skillgapassessment/addassessment');
		}else{
			header('location: ' . URL . 'performance/skillgapassessment');
		}
    }
	function getskillgapassessment()
	{
		$viewper = $this->CheckPermission(132, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['assessmentid'];
			try{
			$objective = $this->loadModel('Skillgapassessment');
			$objectivearray = $objective->getassessmentDetail($arr);
			echo json_encode($objectivearray);			
			}catch(Exception $e){
				echo $e->getMessage();
			}
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getskillgapresult()
	{
		$viewper = $this->CheckPermission(132, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['assessmentid'];
			try{
			$objective = $this->loadModel('Skillgapassessment');
			$objectivearray = $objective->getassessmentResult($arr);
			echo json_encode($objectivearray);			
			}catch(Exception $e){
				echo $e->getMessage();
			}
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getaskillgapassessment()
	{
		$viewper = $this->CheckPermission(132, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			
			$id= $_POST['empid'];
			$objective = $this->loadModel('Skillgapassessment');
			$objectivearray = $objective->getDetail($id);
			echo json_encode($objectivearray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function createskillgapassessment()
	{
		$edit = $this->CheckPermission(132, 2);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($edit)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['assessmenttype'];
			$arr[6] = $_POST['assessmentid'];
			$objective = $this->loadModel('Skillgapassessment');
			$objectivearray = $objective->Create($arr);
			echo json_encode($objectivearray);	
						
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	
	 /**
     * Functions for perfom operation on objective table
     * delete function from objective list
	 * @returning json array of data as result
     */
	 
	 
	
	function getSkillgapassessmentData()
	{
		$editper = $this->CheckPermission(132, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(132, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		try{
		$objective = $this->loadModel('Skillgapassessment');
		$objectivearray = $objective->getDataTable($editper, $deleteper);
		echo json_encode($objectivearray);
		}catch(Exception $e){
				echo $e->getMessage();
			}	
	}
	
	
	/** 
	 ///////////////////////////// ASSESSMENT CONTROLLER FUNCTION ENDS HERE  ////////////////////////////**/
	  /** 
	 ///////////////////////////// SKILL GAP ASSESSMENT RESULT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	
	function skillgapresult()
    {
        $viewper = $this->CheckPermission(132, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(132, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/skillgapresult/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	
	function viewskillgapresult($empid,$val)
    {	
		$viewper = $this->CheckPermission(132, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper  && isset($val)  && isset($empid)){
			$this->view->assessmentid =$empid;
			$this->view->val = $val; 
			$this->view->render('performance/skillgapresult/skillgapresult');
		}else{
			header('location: ' . URL . 'performance/skillgapassessment');
		}
    }
	
	function getSkillgapresultData()
	{
		$editper = $this->CheckPermission(132, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(132, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$objective = $this->loadModel('Skillgapassessment');
		$objectivearray = $objective->getAssessmentresultTable($editper, $deleteper);
		echo json_encode($objectivearray);
	}
	
	 ////////////////////////////  REPORT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
    /* Functions for perfom operation on report table
     * getall function fetching report list
	 * @returning json array of data as result
     */
	
	function report()
    {
		$viewper = $this->CheckPermission(167, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(167, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/reports/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	function addreport()
    {
		$addper = $this->CheckPermission(167, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->reportid =0;
			$this->view->val = 0; 
			$this->view->render('performance/reports/addeditreport');
		}else{
			header('location: ' . URL . 'performance/report');
		}
    }
	
	function editreport($id)
    {
		$editper = $this->CheckPermission(167, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->reportid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performance/reports/addeditreport');
		}else{
			header('location: ' . URL . 'performance/report');
		}
		
    }
	
	function viewreport1($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->val = $val; 
			$this->view->render('performance/reports/addeditreport');
		}else{
			header('location: ' . URL . 'performance/report');
		}
		
    }
	function viewreport($id)
    {
		
		if(isset($id) )
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->render('performance/reports/viewreport');
		}else{
			header('location: ' . URL . 'performance/report');
		}
		
    }
	
	function getareport()
	{
		$viewper = $this->CheckPermission(60, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['reportid'];
			$report = $this->loadModel('Reportskill');
			$reportarray = $report->getDetail($gid);
			echo json_encode($reportarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function daterangereport($val)
	{
		try{
			$deptarray=array();
			$dept = $this->loadModel('Report');
			if($val==15){
				$deptarray = $dept->EmployeeAssessmentReport();
			}
			elseif($val==13){
				$deptarray = $dept->EmployeeAssessmentCompleteReport();
			}
			elseif($val==29){
				$deptarray = $dept->EmployeeAssessmentCompleteSummaryReport();
			}
			elseif($val==43){
				$deptarray = $dept->EmployeeSkillGapReport();
			}
			echo json_encode($deptarray);
		}catch(Exception $e) {
			echo $e->getMessage();
		}
	}	
	
	
	function daterangereportskill($val)
	{
		try{
			$deptarray=array();
			$dept = $this->loadModel('Reportskill');
			if($val==15){
				$deptarray = $dept->EmployeeAssessmentReport();
			}
			elseif($val==13){
				$deptarray = $dept->EmployeeAssessmentCompleteReport();
			}
			elseif($val==29){
				$deptarray = $dept->EmployeeAssessmentCompleteSummaryReport();
			}
			elseif($val==43){
				$deptarray = $dept->EmployeeSkillGapReport();
			}
			echo json_encode($deptarray);
		}catch(Exception $e) {
			echo $e->getMessage();
		}
	}	
	
	function deletereport($did)
	{
		$deleteper = $this->CheckPermission(167, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Report');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}	
		//header('location: ' . URL . 'performance/report');
	}
	
	
	function getReportData()
	{
		$editper = $this->CheckPermission(167, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(167, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$tabid=6;
		$report = $this->loadModel('Report');
		$reportarray = $report->getDataTable($editper, $deleteper,$tabid);
		echo json_encode($reportarray);
	}
	//////////Performace Indicator////
	function indicatorattribute()
	{
		$viewper = $this->CheckPermission(171, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(171, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->indicateid=0;
			$this->view->render('performance/indicator/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	}
	
	
	function getIndicatorAttributeData()
	{
		$editper = $this->CheckPermission(171, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(171, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$indicator = $this->loadModel('Performanceindicator');
		$indicatorarray = $indicator->getIndicatorAttributeTable($editper, $deleteper);
		echo json_encode($indicatorarray);
	}
	
	function gettraining()
	{
		try{
		$editper = $this->CheckPermission(190, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(190, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$indicator = $this->loadModel('Performanceindicator');
		$indicatorarray = $indicator->getTraining($editper, $deleteper);
		echo json_encode($indicatorarray);
		}catch(Exception $e) {
		echo $errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	function gettrainerbysorting()
	{
		try{
		$editper = $this->CheckPermission(190, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(190, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$indicator = $this->loadModel('Performanceindicator');
		$indicatorarray = $indicator->gettrainerbysorting($editper, $deleteper);
		echo json_encode($indicatorarray);
		}catch(Exception $e) {
		echo $errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	function gettrainer()
	{
		try{
		$editper = $this->CheckPermission(192, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(192, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$indicator = $this->loadModel('Performanceindicator');
		$indicatorarray = $indicator->getTrainer($editper, $deleteper);
		echo json_encode($indicatorarray);
		}catch(Exception $e) {
		echo $errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	function editTraining($id,$val)
    {
		try{
        $viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid =$id;
			$this->view->val =$val;
			$this->view->render('performance/training/addtrainee');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	}catch(Exception $e){}
    }
	
	function editTrainer($id,$val)
    {
		try{
        $viewper = $this->CheckPermission(192 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(192 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainerid =$id;
			$this->view->val =$val;
			$this->view->render('performance/trainer/addtrainer');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	}catch(Exception $e){}
    }
	
	function createindicator()
	{
		try{$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['attributes'];
		$arr[3] = $_POST['marks'];
			
		$indicator = $this->loadModel('Performanceindicator');
		$indicatorarray = $indicator->Create($arr);
		echo json_encode($indicatorarray);	
		}catch(Exception $e){}
		
	}
	function updateindicator()
	{
		try{$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['attributes'];
		$arr[3] = $_POST['marks'];
		$arr[4] = $_POST['indicateid'];
			
		$indicator = $this->loadModel('Performanceindicator');
		$indicatorarray = $indicator->Update($arr);
		echo json_encode($indicatorarray);	
		}catch(Exception $e){}
		
	}
	function deleteindicator($did)
	{		
		$deleteper = $this->CheckPermission(171, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$indicator = $this->loadModel('Performanceindicator');
			$indicatorarray = $indicator->Delete($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	function getindicator()
	{try{
		$viewper = $this->CheckPermission(171, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			
			$id= $_POST['indicateid'];
			$indicator = $this->loadModel('Performanceindicator');
			$indicatorarray = $indicator->getDetail($id);
			echo json_encode($indicatorarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}
	}
	//////////Performace Assess Indicator////
	function assessindicator()
	{
		$viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			
			$this->view->render('performance/assessindicator/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	}
	
	function trainer()
	{
		$viewper = $this->CheckPermission(192, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(192 , 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainerid=0;
			
			$this->view->render('performance/trainer/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	}
	 function training()
	{
		$viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid=0;
			$this->view->render('performance/training/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	} 
	
	function training1()
	{
		$viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid=0;
			$this->view->render('performance/training/new_index');
		}else{
			header('location: ' . URL . 'performance/new_index');
		}
	}
	function trainee()
	{
		$viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid=0;
			$this->view->render('performance/trainee/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	}
	function traineeFeedback()
	{
		$viewper = $this->CheckPermission(190 , 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(190 , 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid=0;
			$this->view->render('performance/trainingfeedback/new_index');
		}else{
			header('location: ' . URL . 'performance/new_index');
		}
	}
	function module()
	{
		$viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid=0;
			$this->view->render('performance/module/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	}
	function addModule()
	{
		$viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid=0;
			$this->view->render('performance/module/addmodule');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	}

		 function addTrainingSets()
    {
		try{
			$viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
			if($viewper){
				$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
				$this->view->addper =$addper;
				$this->view->trainingid =0;
				$this->view->val = 0; 
				$this->view->render('performance/trainingsets/addtrainingsets');
			}else{
				header('location: ' . URL . 'performance/index');
			}
		}catch(Exception $e){}
	}  
	function trainingsets()
	{
		$viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainingid=0;
			$this->view->render('performance/trainingsets/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	}
	function createtraining()
	{
		try{
		$addper = $this->CheckPermission(190, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['kpi_id'];
			$arr[3] = $_POST['trainee'];
			$arr[4] = $_POST['trainerid'];
			$arr[5] = $_POST['startdate'];
			$arr[6] = $_POST['enddate'];
			$arr[7] = $_POST['timefrom'];
			$arr[8] = $_POST['timeto'];
			$arr[9] = $_POST['designation'];
			$quadrant = $this->loadModel('Performanceindicator');
			$quadrantarray = $quadrant->CreateTraining($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	function createtrainer()
	{
		try{
		$addper = $this->CheckPermission(192, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['trainer_name'];
			$arr[3] = $_POST['trainer_email'];
			$arr[4] = $_POST['trainer_address'];
			$arr[5] = $_POST['trainer_mobile'];
			$arr[6] = $_POST['trainer_experience'];
			$arr[7] = $_POST['trainer_qualification'];
			$arr[8] = $_POST['trainer_specialization'];
			$quadrant = $this->loadModel('Performanceindicator');
			$quadrantarray = $quadrant->CreateTrainer($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	
function updatetrainer()
	{
		try{
		$addper = $this->CheckPermission(192, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['trainer_name'];
			$arr[3] = $_POST['trainer_email'];
			$arr[4] = $_POST['trainer_address'];
			$arr[5] = $_POST['trainer_mobile'];
			$arr[6] = $_POST['trainer_experience'];
			$arr[7] = $_POST['trainer_qualification'];
			$arr[8] = $_POST['trainer_specialization'];
			$arr[9] = $_POST['trainerid'];
			$quadrant = $this->loadModel('Performanceindicator');
			$quadrantarray = $quadrant->updateTrainer($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	
	function updatetraining()
	{
		$addper = $this->CheckPermission(190, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['kpi_id'];
			$arr[3] = $_POST['trainee'];
			$arr[4] = $_POST['trainerid'];
			$arr[5] = $_POST['startdate'];
			$arr[6] = $_POST['enddate'];
			$arr[7] = $_POST['timefrom'];
			$arr[8] = $_POST['timeto'];
			$arr[9] = $_POST['designation'];
			$arr[10] = $_POST['trainingid'];
			$quadrant = $this->loadModel('Performanceindicator');
			$quadrantarray = $quadrant->updateTraining($arr);
			echo json_encode($quadrantarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	function deleteTraining($did)
	{
		$deleteper = $this->CheckPermission(190, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Performanceindicator');
			$deptarray = $dept->DeleteTraining($did);
			echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	function deleteTrainer($did)
	{
		$deleteper = $this->CheckPermission(192, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Performanceindicator');
			$deptarray = $dept->DeleteTrainer($did);
			echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	function addTrainer()
    {
		try{
        $viewper = $this->CheckPermission(192 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(192	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->trainerid =0;
			$this->view->val = 0; 
			$this->view->render('performance/trainer/addtrainer');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	}catch(Exception $e){}
    }
	
	function getcompetencyemployee($designationid)
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $designationid;
			//$arr[2] = $_POST['competencyid'];
			$indicator = $this->loadModel('Performanceindicator');
			$employeearray = $indicator->getCompetencyEmployee($arr);
			echo json_encode($employeearray);		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
	}
	
	 function addTrainee()
    {
		try{
			$viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
			if($viewper){
				$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
				$this->view->addper =$addper;
				$this->view->trainingid =0;
				$this->view->val = 0; 
				$this->view->render('performance/training/addtrainee');
			}else{
				header('location: ' . URL . 'performance/index');
			}
		}catch(Exception $e){}
	}  
	
	 function addTrainee2()
    {
		try{
			$viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
			if($viewper){
				$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
				$this->view->addper =$addper;
				$this->view->trainingid =0;
				$this->view->val = 0; 
				$this->view->render('performance/trainee/addtrainee');
			}else{
				header('location: ' . URL . 'performance/index');
			}
		}catch(Exception $e){}
	}  
	
	
	function addTrainee1()
    {
		try{
			$viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
			if($viewper){
				$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
				$this->view->addper =$addper;
				$this->view->trainingid =0;
				$this->view->val = 0; 
				$this->view->render('performance/training/newaddtrainee');
			}else{
				header('location: ' . URL . 'performance/new_index');
			}
		}catch(Exception $e){}
	}
	function addTraineeFeedback()
    {
		try{
			$viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
			if($viewper){
				$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
				$this->view->addper =$addper;
				$this->view->trainingid =0;
				$this->view->val = 0; 
				$this->view->render('performance/trainingfeedback/addtraineefeedback');
			}else{
				header('location: ' . URL . 'performance/new_index');
			}
		}catch(Exception $e){}
	}
	function viewresult()
	{
		try{
			$viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
			if($viewper){
				$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
				$this->view->addper =$addper;
				$this->view->trainingid =0;
				$this->view->val = 0; 
		
				$this->view->render('performance/trainingfeedback/viewresult');
			}else{
				header('location: ' . URL . 'performance/new_index');
			}
		}catch(Exception $e){}
	}
	function getAssignIndicatorData()
	{
		$editper = $this->CheckPermission(190 	, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(190 	, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$indicator = $this->loadModel('Pimaster');
		$indicatorarray = $indicator->getAssignIndicatorData($editper, $deleteper);
		echo json_encode($indicatorarray);
	}
	
	function addAssignIndicator()
	{
		try{
        $viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->assignid =0;
			$this->view->val = 0; 
			$this->view->render('performance/assessindicator/assignindicator');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	}catch(Exception $e){}
    }
	
	function getAllindicator($designationid)
	{
		try{
		$indicator = $this->loadModel('Pimaster');
		$indicatorarray = $indicator->getAllindicator($designationid);
		echo json_encode($indicatorarray);
		}catch(Exception $e){}
	}
	function createAssignindicator()
	{
		try{$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['emp_id'];
		$arr[3] = $_POST['month'];
		$arr[4] = $_POST['totalmarks'];
		$arr[5] = $_POST['totalamt'];
		$arr[6] = $_POST['remark'];
		$arr[7] = $_POST['ratings'];
		$arr[8] = $_POST['totalper'];
		$arr[9] = $_POST['summary'];
			
		$indicator = $this->loadModel('Pimaster');
		$indicatorarray = $indicator->Create($arr);
		echo json_encode($indicatorarray);	
		}catch(Exception $e){}
		
	}
	function deleteAssignindicator($did)
	{		
		try{$deleteper = $this->CheckPermission(190 	, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$indicator = $this->loadModel('Pimaster');
			$indicatorarray = $indicator->Delete($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getAllassessdata($did)
	{		
		try{
		if(isset($did))
		{
			$indicator = $this->loadModel('Pimaster');
			$indicatorarray = $indicator->GetAssessdata($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getAlltrainingdata($did)
	{		
		try{
		if(isset($did))
		{
			$indicator = $this->loadModel('Performanceindicator');
			$indicatorarray = $indicator->getAlltrainingdata($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getAlltrainerdata($did)
	{		
		try{
		if(isset($did))
		{
			$indicator = $this->loadModel('Performanceindicator');
			$indicatorarray = $indicator->getAlltrainerdata($did);
			echo json_encode($indicatorarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	function getAlltrainers()
	{		
		try{
		
			$indicator = $this->loadModel('Performanceindicator');
			$indicatorarray = $indicator->getAlltrainer();
			echo json_encode($indicatorarray);	

		
		}catch(Exception $e){}
	}
	function editAssessindicator($id,$val)
    {try{
        $viewper = $this->CheckPermission(190 	, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(190 	, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->assignid =$id;
			$this->view->val =$val;
			$this->view->render('performance/assessindicator/assignindicator');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	}catch(Exception $e){}
    }
	function updateAssignindicator()
	{
		try{$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['assignid'];
		$arr[3] = $_POST['totalamt'];
		$arr[4] = $_POST['remark'];
		$arr[5] = $_POST['ratings'];
		$arr[6] = $_POST['totalper'];
		$arr[7] = $_POST['summary'];
			
		$indicator = $this->loadModel('Pimaster');
		$indicatorarray = $indicator->Update($arr);
		echo json_encode($indicatorarray);	
		}catch(Exception $e){}
		
	}
	//////performance Rating///////
	function performancecriteria()
	{
		$viewper = $this->CheckPermission(171, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(171, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->indicateid=0;
			$this->view->render('performance/performancecriteria/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
	}
	
	public function getperformancecriteria()
    {
		
		$ratingcriteria_model = $this->loadModel('Performanceindicator');
        $arr= $ratingcriteria_model->getAllRatingcriterias();
		echo json_encode($arr);
      
    }
    public function saveperformancecriteria()
    {
        $ratingcriteria_model = $this->loadModel('Performanceindicator');
        $cate= $ratingcriteria_model->saveAllRatingcriterias();
		
		echo json_encode($cate);
	}
	
	function getallKpi()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$quadrant = $this->loadModel('Quadrant');
			$quadrantarray = $quadrant->getAllKpi($arr);
			echo json_encode($quadrantarray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}			
	}
	function getallFuncKpi()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$quadrant = $this->loadModel('Quadrant');
			$quadrantarray = $quadrant->getallFuncKpi($arr);
			echo json_encode($quadrantarray);	
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}			
	}
	
	/** 
	 ///////////////////////////// SKILL ASSESSMENT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////**/
	function skillAssessment()
    {
        $viewper = $this->CheckPermission(236, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(236, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/employeeskillassessment/index');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	
	function viewSkillAssessment($empid,$val)
    {	
		$viewper = $this->CheckPermission(236, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper  && isset($val)  && isset($empid)){
			$this->view->employeeid =$empid;
			$this->view->val = $val; 
			$this->view->render('performance/employeeskillassessment/addassessment');
		}else{
			header('location: ' . URL . 'performance/assessment');
		}
    }
	function editSkillAssessment($empid)
    {	
		$editper = $this->CheckPermission(236, 2); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($editper   && isset($empid)){
			$this->view->employeeid =$empid;
			$this->view->val = 0; 
			$this->view->render('performance/employeeskillassessment/addassessment');
		}else{
			header('location: ' . URL . 'performance/assessment');
		}
    }
	function getEmpSkillAssessment()
	{
		$viewper = $this->CheckPermission(236, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2]= $_POST['assessmentid'];
			try{
			$objective = $this->loadModel('Skillassessment');
			$objectivearray = $objective->getassessmentDetail($arr);
			echo json_encode($objectivearray);			
	}catch(Exception $e){
			echo $e->getMessage();
			}
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	function getaskillassessment()
	{
		$viewper = $this->CheckPermission(236, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$id= $_POST['empid'];
			$arr[2]= $_POST['assessmentid'];
			$objective = $this->loadModel('Assessment');
			$objectivearray = $objective->getDetail($id);
			echo json_encode($objectivearray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function createskillassessment()
	{
		try{
		$editper = $this->CheckPermission(236, 2);  ///////// CHECK FOR VIEW PERMISSION //////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['fromdate'];
			$arr[4] = $_POST['todate'];
			$arr[5] = $_POST['assessmenttype'];
			$arr[6] = $_POST['totalmarks'];
			$arr[7] = $_POST['totalamt'];
			$arr[8] = $_POST['assessmentid'];
			$arr[9] = $_POST['rating'];
			$arr[10] = $_POST['result'];
			$arr[11] = $_POST['desc'];
			$arr[12] = $_POST['improvements'];
			
			$objective = $this->loadModel('Skillassessment');
			$objectivearray = $objective->Create($arr);
			echo json_encode($objectivearray);	
						
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){
		Utils::Trace($e->getMessage());
	}
	}
	
	
	 /**
     * Functions for perfom operation on objective table
     * delete function from objective list
	 * @returning json array of data as result
     */
	 
	 
	
	function getSkillAssessmentData()
	{
		try{
		$editper = $this->CheckPermission(236, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(236, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$objective = $this->loadModel('Skillassessment');
		$objectivearray = $objective->getDataTable($editper, $deleteper);
		echo json_encode($objectivearray);
		}
		catch(Exception $e){}
	}
	
	/** 
	 ///////////////////////////// GOALS CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on objective table
     * getall function fetching goals list
	 * @returning json array of data as result
     */
	
	function goals()
    {
        $viewper = $this->CheckPermission(253, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(253, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			//$this->view->render('performance/goals/index');
			$this->view->render('performance/goals/indexnew');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	
	function goals1()
    {
        $viewper = $this->CheckPermission(253, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(253, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('performance/goals/index');
			//$this->view->render('performance/goals/indexnew');
		}else{
			header('location: ' . URL . 'performance/index');
		}
    }
	function addgoals()
    {	
		$addper = $this->CheckPermission(253, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->goalsid =0;
			$this->view->val = 0; 
        $this->view->render('performance/goals/addeditgoals');
		}else{
			header('location: ' . URL . 'performance/goals');
		}
    }
	
	function editgoals($id)
    {
		$editper = $this->CheckPermission(253, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->goalsid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('performance/goals/addeditgoals');
		}else{
			header('location: ' . URL . 'performance/goals');
		}
    }
	
	function viewgoals($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->goalsid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('performance/goals/addeditgoals');
		}else{
			header('location: ' . URL . 'performance/goals');
		}
		
    }
	
	function getallgoals()
	{
		$viewper = $this->CheckPermission(253, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$goals = $this->loadModel('Goals');
			$goalsarray = $goals->getAll($arr);
			echo json_encode($goalsarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	

	function getagoals()
	{
		$viewper = $this->CheckPermission(253, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['goalsid'];
			$goals = $this->loadModel('Goals');
			$goalsarray = $goals->getDetail($gid);
			echo json_encode($goalsarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getemptasks()
	{
		
			$gid = $_POST['employeeid'];
			$goalid = $_POST['goalid'];
			$goals = $this->loadModel('Goals');
			$goalsarray = $goals->getEmployeeTasks($gid,$goalid );
			echo json_encode($goalsarray);			
	
		
	}
	
	function getempcomments()
	{
		
			$goalid = $_POST['goalid'];
			$goals = $this->loadModel('Goals');
			$goalsarray = $goals->getEmployeeComments($goalid );
			echo json_encode($goalsarray);			
	
		
	}
	
	function getempbydepartment()
	{
		
			$gid = $_POST['departmentid'];
			$goals = $this->loadModel('Department');
			$goalsarray = $goals->getEmployee($gid);
			echo json_encode($goalsarray);			
	
		
	}
	
	function getempteam()
	{
		$arr = array();
		$arr[0] =  $_POST['employeeid'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
	
		$goals = $this->loadModel('Employee');
		$goalsarray = $goals->getOnlyHierarchyEmployee($arr);
		echo json_encode($goalsarray);			
		
	}
	
	/** 
     * Functions for perfom operation on goals table
     * getall function fetching goals list
	 * @returning json array of data as result
     */
	function creategoals()
	{
		$addper = $this->CheckPermission(253, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['dept'];
			$arr[3] = $_POST['employeeid'];
			$arr[4] = $_POST['fromdate'];
			$arr[5] = $_POST['todate'];
			$arr[6] = $_POST['goal'];
			$arr[7] = json_decode($_POST['teamgoals'], true); 
			$arr[8] = $_POST['weightage'];
			$arr[9] = $_POST['quadrant'];
			$arr[10] = $_POST['tasknumber'];
			
			
			$goals = $this->loadModel('Goals');
			$goalsarray = $goals->Create($arr);
			echo json_encode($goalsarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	function addtask()
	{
		$addper = $this->CheckPermission(253, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['task'];
			$arr[3] = $_POST['employeeid'];
			$arr[4] = $_POST['fromdate'];
			$arr[5] = $_POST['todate'];
			$arr[6] = $_POST['hours'];
			$arr[7] = $_POST['jobdesc'];
			$arr[8] = $_POST['goalid'];
			$arr[9] = $_POST['givenwt'];
			
			
			$goals = $this->loadModel('Goals');
			$goalsarray = $goals->AddTask($arr);
			echo json_encode($goalsarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	function addcomment()
	{
		$addper = $this->CheckPermission(253, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['goalid'];
			$arr[3] = $_POST['comments'];
			
			$goals = $this->loadModel('Goals');
			$goalsarray = $goals->AddComments($arr);
			echo json_encode($goalsarray);		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on goals table
     * delete function from goals list
	 * @returning json array of data as result
     */
	 
	 function updategoals()
	{
		$editper = $this->CheckPermission(253, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['dept'];
			$arr[3] = $_POST['employeeid'];
			$arr[4] = $_POST['fromdate'];
			$arr[5] = $_POST['todate'];
			$arr[6] = $_POST['goal'];
			$arr[7] = json_decode($_POST['teamgoal'], true); 
			$arr[8] = $_POST['goalsid'];
			$arr[9] = $_POST['weightage'];
			$arr[10] = $_POST['quadrant'];
			$arr[11] = $_POST['tasknumber'];
			
			$goals = $this->loadModel('Goals');
			$goalsarray = $goals->Update($arr);
			echo json_encode($goalsarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	function deletegoals($did)
	{		
		$deleteper = $this->CheckPermission(253, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Goals');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getGoalsData()
	{
		$editper = $this->CheckPermission(253, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		$deleteper = $this->CheckPermission(253, 3); ///////// CHECK FOR DELETE  PERMISSION  ////////////
		
		$goals = $this->loadModel('Goals');
		$goalsarray = $goals->getDataTable($editper, $deleteper);
		echo json_encode($goalsarray);
	}
	
	
}	

