<?php

/**
 * Class City
 * The City controller
 */
class City extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
            parent::__construct();
			 // this controller should only be visible/usable by logged in users, so we put login-check here
			Auth::handleLogin();
    }

    /**
     * Handles what happens when user moves to URL/index/index, which is the same like URL/index or in this
     * case even URL (without any controller/action) as this is the default controller-action when user gives no input.
     */
    function index()
    {
		$id = $_POST['countryid'];
        $city = $this->loadModel('City');
		$cityarr = $city->getCountryCity($id);
		echo json_encode($cityarr);
    }
	
	// country wise city selection same as above
	function getallcity($id)
    {
		if(isset($id))
		{
			$city = $this->loadModel('City');
			$cityarr = $city->getAll($id);
			echo json_encode($cityarr);
		}
    }
	
	function city()
    {
		
		$this->view->render('employee/city/index');
	}
	function addcity()
    {
		$this->view->cityid =0;
		$this->view->val = 0; 
		$this->view->render('employee/city/addeditcity');
	}
	
	function editcity($id)
    {
		
			$this->view->cityid = $id; //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('employee/city/addeditcity');
		
		
    }
	function getacity()
	{
		
			$gid = $_POST['cityid'];
			$resignation = $this->loadModel('City');
			$resignationarray = $resignation->getDetail($gid);
			echo json_encode($resignationarray);			
			
	}
	function deletecity($id)
	{
		
			
			$resignation = $this->loadModel('City');
			$resignationarray = $resignation->Delete($id);
			//echo json_encode($resignationarray);			
		$this->view->render('employee/city/index');
	}
	function createcity()
	{	
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['city'];
			$arr[3] = $_POST['country'];
			
			
			$dept = $this->loadModel('City');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);		
		
	}
	
	 /**
     * Functions for perfom operation on city table
     * delete function from city list
	 * @returning json array of data as result
     */
	 
	 function updatedecity()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['city'];
			$arr[3] = $_POST['cityid'];
			$arr[4] = $_POST['country'];
			
			$dept = $this->loadModel('City');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
		
	}
	
	function getCityData()
	{
		
		$skill = $this->loadModel('City');
		$skillarray = $skill->getCityTable();
		echo json_encode($skillarray);
	}
}
