<?php

/**
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class Attendance extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();

        // this controller should only be visible/usable by logged in users, so we put login-check here
        Auth::handleLogin();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    function index()
    {
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		if($sts==1 || $hrsts==1){
			$this->view->render('attendance/index');
		}else{
			$this->view->render('attendance/index1');
		}
    }
	
	function attend_list()
    {
        $this->view->render('attendance/attendance_list');
    }
	
	function weeklyoff()
    {
        $this->view->render('attendance/weeklyoff');
    }
	
	function update_attend()
    {
        $this->view->render('attendance/update_attendance');
    }
	
	/** 
	 									
	 ///////////////////////////// SHIFT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on shift table
     * getall function fetching shift list
	 * @returning json array of data as result
     */
	
	function shift()
    {
        $viewper = $this->CheckPermission(42, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(42, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('attendance/shift/index');
		}else{
			header('location: ' . URL . 'attendance/index');
		}
		
    }
	function addshift()
    {
		$addper = $this->CheckPermission(42, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->shiftid =0;
			$this->view->render('attendance/shift/addeditshift');
		}else{
			header('location: ' . URL . 'attendance/shift');
		}
    }
	
	function editshift($id)
    {
		$editper = $this->CheckPermission(42, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->shiftid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('attendance/shift/addeditshift');
		}else{
			header('location: ' . URL . 'attendance/shift');
		}
    }
	
	function getallshift()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$shift = $this->loadModel('Shift');
			$shiftarray = $shift->getAll($arr);
			echo json_encode($shiftarray);	
			
		
	}
	
	function getashift()
	{
		$viewper = $this->CheckPermission(42, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['shiftid'];
			$shift = $this->loadModel('Shift');
			$shiftarray = $shift->getDetail($gid);
			echo json_encode($shiftarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on shift table
     * getall function fetching shift list
	 * @returning json array of data as result
     */
	function createshift()
	{
		try{
		$addper = $this->CheckPermission(42, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['shiftname'];
			$arr[3] = $_POST['timein'];
			$arr[4] = $_POST['timeout'];
			$arr[5] = $_POST['timeingrace'];
			$arr[6] = $_POST['timeoutgrace'];
			$arr[7] = $_POST['timeinbreak'];
			$arr[8] = $_POST['timeoutbreak'];
			$arr[9] = $_POST['breaktimeingrace'];
			$arr[10] = $_POST['breaktimeoutgrace'];
			$arr[11] = $_POST['jsonSunday'];
			$arr[12] = $_POST['jsonMonday'];
			$arr[13] = $_POST['jsonTuesday'];
			$arr[14] = $_POST['jsonWednesday'];
			$arr[15] = $_POST['jsonThursday'];
			$arr[16] = $_POST['jsonFriday'];
			$arr[17] = $_POST['jsonSaturday'];
			$dept = $this->loadModel('Shift');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
		}catch(Exception $e){}
	}
	
	 /**
     * Save Weekly of for organization
     */
	 
		function saveWeeklyOff()
		{
			try{
			$addper = $this->CheckPermission(42, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
			if($addper)
			{
				$arr = array();
				$arr[0] = $_SESSION['ubihrm_user_id'];
				$arr[1] = $_SESSION['ubihrm_org_id'];
				$arr[2] = $_POST['jsonSunday'];
				$arr[3] = $_POST['jsonMonday'];
				$arr[4] = $_POST['jsonTuesday'];
				$arr[5] = $_POST['jsonWednesday'];
				$arr[6] = $_POST['jsonThursday'];
				$arr[7] = $_POST['jsonFriday'];
				$arr[8] = $_POST['jsonSaturday'];
				$dept = $this->loadModel('Attendance');
				$deptarray = $dept->saveWeeklyOff($arr);
				echo json_encode($deptarray);	
			}else{
				$result = array();
				$result['status']=false;
				$result['errorMsg']="You don't have data add permission";
				echo json_encode($result);		
			}
			}catch(Exception $e){}
		}
	
	
	 /**
     * Functions for perfom operation on shift table
     * delete function from shift list
	 * @returning json array of data as result
     */
	 
	 function updatedeshift()
	{
		$editper = $this->CheckPermission(42, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['shiftname'];
			$arr[3] = $_POST['timein'];
			$arr[4] = $_POST['timeout'];
			$arr[5] = $_POST['timeingrace'];
			$arr[6] = $_POST['timeoutgrace'];
			$arr[7] = $_POST['timeinbreak'];
			$arr[8] = $_POST['timeoutbreak'];
			$arr[9] = $_POST['shiftid'];
			$arr[10] = $_POST['breaktimeingrace'];
			$arr[11] = $_POST['breaktimeoutgrace'];
			$arr[12] = $_POST['jsonSunday'];
			$arr[13] = $_POST['jsonMonday'];
			$arr[14] = $_POST['jsonTuesday'];
			$arr[15] = $_POST['jsonWednesday'];
			$arr[16] = $_POST['jsonThursday'];
			$arr[17] = $_POST['jsonFriday'];
			$arr[18] = $_POST['jsonSaturday'];
			$dept = $this->loadModel('Shift');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteshift($did)
	{
		$deleteper = $this->CheckPermission(42, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Shift');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}	
		else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getShiftData()
	{
		$editper = $this->CheckPermission(42, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(42, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$shift = $this->loadModel('Shift');
		$shiftarray = $shift->getDataTable($editper, $deleteper);
		echo json_encode($shiftarray);
	}
	
	/** 
	 ///////////////////////////// SHIFT CONTROLLER FUNCTION ENDS HERE /////////////////////////// 
	 ///////////////////////////// ATTENDANCE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on attendance table
     * getall function fetching attendance list
	 * @returning json array of data as result
     */
	
	function attendance()
    {
		$viewper = $this->CheckPermission(5, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(5, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$delper = $this->CheckPermission(5, 3); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->delper =$delper;
			 $this->view->render('attendance/attendancelist/index');
		}else{
			header('location: ' . URL . 'attendance/index');
		}
    }
	
	function deletebulkattendance()
    {
       
		$viewper = $this->CheckPermission(5, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(5, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$delper = $this->CheckPermission(5, 3); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->delper =$delper;
			 $this->view->render('attendance/attendancelist/indexdelete');
		}else{
			header('location: ' . URL . 'attendance/index');
		}
    }
   
	function importattendance()
    {
       		$addper = $this->CheckPermission(5, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			if($addper){
			$this->view->render('attendance/attendancelist/importattendance');
			}else{
				header('location: ' . URL . 'attendance/attendance');
			}
    }
	function addattendance()
    {
		
		$addper = $this->CheckPermission(5, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->attendanceid =0;
			$this->view->render('attendance/attendancelist/addeditattendance');
		}else{
			header('location: ' . URL . 'attendance/attendance');
		}
    }
	
	function editattendance($id)
    { 
	try{
		$editper = $this->CheckPermission(5, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->attendanceid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('attendance/attendancelist/addeditattendance');
		}else{
			header('location: ' . URL . 'attendance/attendance');
		}
	}catch(Exception $e){}
    }
	
	function getallemployeebycondition()

	{
		$viewper = $this->CheckPermission(5, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['deptid'];
			$arr[3] = $_POST['degid'];
			$arr[4] = $_POST['shiftid'];
			$arr[5] = $_POST['divisionid'];
			$arr[6] = $_POST['empname'];
			
			$attendance = $this->loadModel('Attendance');
			$employeearray = $attendance->getAllByCondition($arr);
			echo json_encode($employeearray);
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getallattendance()
	{
		$viewper = $this->CheckPermission(5, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$attendance = $this->loadModel('Attendance');
			$attendancearray = $attendance->getAll($arr);
			echo json_encode($attendancearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getaattendance()
	{
		$viewper = $this->CheckPermission(5, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['attendanceid'];
			$attendance = $this->loadModel('Attendance');
			$attendancearray = $attendance->getDetail($gid);
			echo json_encode($attendancearray);		
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on attendance table
     * getall function fetching attendance list
	 * @returning json array of data as result
     */
	function createattendance()
	{try{
		$addper = $this->CheckPermission(5, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['jsonarr'];
			$arr[3] = $_POST['atdate'];
			$arr[4] = $_POST['shift'];
			
			$dept = $this->loadModel('Attendance');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}catch(Exception $e){}
	}
	
	 /**
     * Functions for perfom operation on attendance table
     * delete function from attendance list
	 * @returning json array of data as result
     */
	 
	 function updatedeattendance()
	{
		$editper = $this->CheckPermission(5, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['jsonarr'];
			$arr[3] = $_POST['attendanceid'];
			
			$dept = $this->loadModel('Attendance');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteattendance($did)
	{
		$deleteper = $this->CheckPermission(5, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Attendance');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}	
		else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
	}
	 ///for deleting bulk attendance by clicking checkboxes
    function delattendance()
    {
    	if(isset($_POST['checklist']))
		{
			$attendance = $this->loadModel('Attendance');
			$attendancearr = $attendance->delBulkAttendance();
			header('location: ' . URL . 'attendance/deletebulkattendance');
		}	
		else{
			header('location: ' . URL . 'attendance/attendance');
		}
       		
    }

	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getAttendanceData()
	{
		try{
			$editper = $this->CheckPermission(5, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
			$deleteper = $this->CheckPermission(5, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////		
			$attendance = $this->loadModel('Attendance');
			$attendancearray = $attendance->getDataTable($editper, $deleteper);
			echo json_encode($attendancearray);
		}catch(Exception $e){ }
	}
	
	function getAttendanceDataDelete()
	{
		$editper = $this->CheckPermission(5, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(5, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$attendance = $this->loadModel('Attendance');
		$attendancearray = $attendance->getDataTableDelete($editper, $deleteper);
		echo json_encode($attendancearray);
	}

	function importheadersfile()
	{
		try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$dept = $this->loadModel('Attendance');
			$deptarray = $dept->getFileHeaders($arr);
			echo json_encode($deptarray);	
		}catch(Exception $e){ echo $e->getMessage();}
		
	}
	function insertheaders()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['emp'];
			$arr[3] = $_POST['atdate'];
			$arr[4] = $_POST['timein'];
			$arr[5] = $_POST['timeout'];
			$arr[6] = $_POST['attsts'];
			
			
			$dept = $this->loadModel('Attendance');
			$deptarray = $dept->insertFileHeaders($arr);
			echo json_encode($deptarray);	
		
		
	}
	
/** 
	 ///////////////////////////// ATTENDANCE CONTROLLER FUNCTION ENDS HERE /////////////////////////// 
	 ///////////////////////////// ATTENDANCE TYPE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on attendance table
     * getall function fetching attendance list
	 * @returning json array of data as result

     */
	
	function attendancetype()
    {
        
		$viewper = $this->CheckPermission(52, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(52, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('attendance/attendancetype/index');
		}else{
			header('location: ' . URL . 'attendance/index');
		}
		
    }
	function addattendancetype()
    {
		$addper = $this->CheckPermission(52, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->attendancetypeid =0;
			$this->view->render('attendance/attendancetype/addeditattendancetype');
		}else{
			header('location: ' . URL . 'attendance/attendancetype');
		}
    }
	
	function editattendancetype($id)
    {
		$editper = $this->CheckPermission(52, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->attendancetypeid = $id; //$dept->getDetail($id);
			$this->view->render('attendance/attendancetype/addeditattendancetype');
		}else{
			header('location: ' . URL . 'attendance/attendancetype/');
		}
    }
	
	function getallattendancetype()
	{
		$viewper = $this->CheckPermission(52, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$attendancetype = $this->loadModel('Attendancetype');
			$attendancetypearray = $attendancetype->getAll($arr);
			echo json_encode($attendancetypearray);		
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getaattendancetype()
	{
		$viewper = $this->CheckPermission(52, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['attendancetypeid'];
			$attendancetype = $this->loadModel('Attendancetype');
			$attendancetypearray = $attendancetype->getDetail($gid);
			echo json_encode($attendancetypearray);		
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on attendance table

     * getall function fetching attendance list
	 * @returning json array of data as result
     */
	function createattendancetype()
	{
		$addper = $this->CheckPermission(52, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['name'];
			$arr[3] = $_POST['typecolor'];
			
			$dept = $this->loadModel('Attendancetype');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	
		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on attendance table
     * delete function from attendance list
	 * @returning json array of data as result

     */
	 
	function updatedeattendancetype()
	{
		$editper = $this->CheckPermission(52, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['name'];
			$arr[3] = $_POST['typecolor'];
			$arr[4] = $_POST['attendancetypeid'];
			
			$dept = $this->loadModel('Attendancetype');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);			
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result

     */

	function deleteattendancetype($did)
	{ 
		$deleteper = $this->CheckPermission(52, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Attendancetype');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	
		}	
		else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getAttendancetypeData()
	{
		$editper = $this->CheckPermission(52, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(52, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$attendancetype = $this->loadModel('Attendancetype');
		$attendancetypearray = $attendancetype->getDataTable($editper, $deleteper);
		echo json_encode($attendancetypearray);
	}
	
	/**
     * Functions specific for ATTENDANCE DASHBOARD
     * @returning json array of data as result
     */
	function getAttendanceDashboard1($val)
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $_POST['fiscalid'];
		$arr[3] = $_POST['type'];
		
		$attendancetype = $this->loadModel('Dashboard');
		if($val==1){
			$attendancetypearray = $attendancetype->getAttendanceDashboard($arr);
		}
		else{
			$attendancetypearray = $attendancetype->getAttendanceReportingDashboard($arr);
		}
		echo json_encode($attendancetypearray);
	}
	
	/**
     * Functions specific for ATTENDANCE DASHBOARD
     * @returning json array of data as result
     */
	function getAttendanceDashboard3()
	{
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		
		$attendancetype = $this->loadModel('Dashboard');
		$attendancetypearray = $attendancetype->getAttendanceDashboard3($arr);
		echo json_encode($attendancetypearray);
	}
	
	////////////////////////////  REPORT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perfom operation on report table
     * getall function fetching report list
	 * @returning json array of data as result
     */
	
	function report()
    {
		$viewper = $this->CheckPermission(68, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(68, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('attendance/reports/index');
		}else{
			header('location: ' . URL . 'attendance/index');
		}
    }
	function addreport()
    {
		$addper = $this->CheckPermission(68, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->reportid =0;
			$this->view->val = 0; 
			$this->view->render('attendance/reports/addeditreport');
		}else{
			header('location: ' . URL . 'attendance/report');
		}
    }
	
	function editreport($id)
    {
		$editper = $this->CheckPermission(68, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->reportid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('attendance/reports/addeditreport');
		}else{
			header('location: ' . URL . 'attendance/report');
		}
		
    }
	
	function viewreport1($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->val = $val; 
			$this->view->render('attendance/reports/addeditreport');
		}else{
			header('location: ' . URL . 'attendance/report');
		}
		
    }
	function viewreport($id)
    {
		
		if(isset($id) )
		{
			$this->view->reportid = Utils::decode5t($id); 
			$this->view->render('attendance/reports/viewreport');
		}else{
			header('location: ' . URL . 'attendance/report');
		}
		
    }
	function htmltopdf($rportid)
    {try{
		$attendancetype = $this->loadModel('Attendance');
		$attendancetypearray = $attendancetype->htmltopdf($rportid);
		//echo json_encode($attendancetypearray);
	}catch(Exception $e){
		
	}
	}
	
	
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletereport($did)
	{
		$deleteper = $this->CheckPermission(68, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Report');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	
		}	
		else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getReportData()
	{
		try{
		$editper = $this->CheckPermission(68, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(68, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$tabid=2;
		$report = $this->loadModel('Report');
		$reportarray = $report->getDataTable($editper, $deleteper,$tabid);
		echo json_encode($reportarray);
		}catch(Exception $e){}
	}
	
	function getReportData1($id)
	{
		$editper = $this->CheckPermission(68, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(68, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$report = $this->loadModel('Report');
		$reportarray = $report->createDataTable($editper, $deleteper,$id);
		echo json_encode($reportarray);
	}
	
	function createReportDataTable()
	{
		$editper = $this->CheckPermission(68, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(68, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$report = $this->loadModel('Report');
		$reportarray = $report->createDataTable($editper, $deleteper);
		echo json_encode($reportarray);
	}
	
	function getmodules()
	{
		$permission = $this->loadModel('Permission');
		$perarray = $permission->getModules();
		echo json_encode($perarray);	
	}
	
	
	
	
	function getcolumnvalues()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['tablename'];
			$arr[3] = $_POST['columnname'];
			$dept = $this->loadModel('Report');
			$deptarray = $dept->getAllColumnValue($arr);
			echo json_encode($deptarray);	
		
		
	}
	
	function getreportingmodule()
    {
		$tabid=$_POST['tabid'];
        $relation = $this->loadModel('Permission');
		$relationarr = $relation->getReportingModules($tabid);
		echo json_encode($relationarr);
    }
	
	function getOrganizationWeekOff()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$shift = $this->loadModel('Attendance');
			$shiftarray = $shift->getOrganizationWeekOff($arr);
			echo json_encode($shiftarray);	
			
		
	}
	
}
