<?php

/**
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class Approvalbymail extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();

        // this controller should only be visible/usable by logged in users, so we put login-check here
       // Auth::handleLogin();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */


	function approveleaveapproval()
	{
		try{
			$arr = array();
			$arr[0] = $_POST["userid"];
			$arr[1] = $_POST["org_id"];
			$arr[2] = $_POST["employeeleaveid"];
			$arr[3] = $_POST["approverresult"];
			$arr[4] =  $_POST["comment"];
			$arr[5] = "";
			$dept = $this->loadModel('Leaveapproval');
			$deptarray = $dept->Approve($arr);
			//echo json_encode($deptarray);	
			//echo $deptarray['successMsg'];
			echo json_encode($deptarray);
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	
	function viewapproveleaveapproval($user_id=1,$org_id=1,$employeeleaveid=1,$approverresult=0)
	{
		try{
			$arr = array();
			$this->view->userid = $arr[0] = $user_id;
			$this->view->org_id = $arr[1] = $org_id;
			$this->view->employeeleaveid = $arr[2] = $employeeleaveid;
			$this->view->approverresult = $arr[3] = $approverresult;
			$arr[4] = "";
			$arr[5] = "";
			$dept = $this->loadModel('Leaveapproval');
			$this->view->appSts = $dept->getpreviousApprovalSts($user_id,$org_id,$employeeleaveid);
			//$this->view->appSts = true;
			$this->view->render('leave/leaveapproval/approvebymail');
			//echo json_encode($deptarray);	
			//echo $deptarray['successMsg'];
			//echo "<h3>" .$deptarray['successMsg']. "</h3>";
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	
	function approvetimeoffapproval()
	{
		try{
			$arr = array();
			$arr[0] = $_POST["userid"];
			$arr[1] = $_POST["org_id"];
			$arr[2] = $_POST["employeetimeoffid"];
			$arr[3] = $_POST["approverresult"];
			$arr[4] =  $_POST["comment"];
			$dept = $this->loadModel('Leaveapproval');
			$deptarray = $dept->ApproveTimeoff($arr);
			echo json_encode($deptarray);
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	
	function approveseveranceapproval()
	{
		try{
			$arr = array();
			$arr[0] = $_POST["userid"];
			$arr[1] = $_POST["org_id"];
			$arr[2] = $_POST["employeeseveranceid"];
			$arr[3] = $_POST["approverresult"];
			$arr[4] =  $_POST["comment"];
			$dept = $this->loadModel('Severance');
			$deptarray = $dept->ChangeStatus($arr);
			echo json_encode($deptarray);
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	
	function viewapprovetimeoffapproval($user_id=1,$org_id=1,$employeetimeoffid=1,$approverresult=0)
	{
		try{
			$arr = array();
			$this->view->userid = $arr[0] = $user_id;
			$this->view->org_id = $arr[1] = $org_id;
			$this->view->employeetimeoffid = $arr[2] = $employeetimeoffid;
			$this->view->approverresult = $arr[3] = $approverresult;
			$arr[4] = "";
			$arr[5] = "";
			$dept = $this->loadModel('Leaveapproval');
			$this->view->appSts = $dept->getpreviousTimeOffApprovalSts($user_id,$org_id,$employeetimeoffid);
			//$this->view->appSts = true;
			$this->view->render('leave/timeoff/approvetimeoffbymail');
			//echo json_encode($deptarray);	
			//echo $deptarray['successMsg'];
			//echo "<h3>" .$deptarray['successMsg']. "</h3>";
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	function viewapproveseveranceapproval($user_id=1,$org_id=1,$employeeseveranceid=1,$approverresult=0)
	{
			try{
				$arr = array();
				$this->view->userid = $arr[0] = $user_id;
				$this->view->org_id = $arr[1] = $org_id;
				$this->view->employeeseveranceid = $arr[2] = $employeeseveranceid;
				$this->view->approverresult = $arr[3] = $approverresult;
				$arr[4] = "";
				$arr[5] = "";
				$dept = $this->loadModel('Severance');
				$this->view->appSts = $dept->getpreviousSeveranceApprovalSts($user_id,$org_id,$employeeseveranceid);
				//$this->view->appSts = 3;
				$this->view->render('employee/severance/approveseverancebymail');
				//echo json_encode($deptarray);	
				//echo $deptarray['successMsg'];
				//echo "<h3>" .$deptarray['successMsg']. "</h3>";
			}catch(Exception $e){
				Utils::Trace($e->getMessage());
			}
		}
	 /**
     * Functions for perfom operation on leaveapproval table
     * delete function from leaveapproval list
	 * @returning json array of data as result
     */
	 
	 function forwardleaveapproval()
	{
		$editper = $this->CheckPermission(124, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
			{
				$arr = array();
				$arr[0] = $_SESSION['ubihrm_user_id'];
				$arr[1] = $_SESSION['ubihrm_org_id'];
				$arr[2] = $_POST['employeeleaveid'];
				$arr[3] = $_POST['approverid'];
				$dept = $this->loadModel('Leaveapproval');
				$deptarray = $dept->Forward($arr);
				echo json_encode($deptarray);
			}else{
				$result = array();
				$result['status']=false;
				$result['errorMsg']="You don't have data edit permission";
				echo json_encode($result);		
			}
	}
	
	function rejectleaveapproval()
	{
				
		
		$editper = $this->CheckPermission(124, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeleaveid'];
			
			
			
			$dept = $this->loadModel('Leaveapproval');
			$deptarray = $dept->Reject($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function taskcompeleteapproval($task_id=0,$user_id=1,$org_id=1,$approverresult=0)
	{
		
		try{
			$arr = array();
			$this->view->userid = $arr[0] = $user_id;
			$this->view->org_id = $arr[1] = $org_id;
			//$this->view->employeeleaveid = $arr[2] = $employeeleaveid;
			$this->view->approverresult = $arr[3] = $approverresult;
			$this->view->taskid = $arr[4] = $task_id;
			$arr[5] = "";
			$arr[6] = "";
			$dept = $this->loadModel('Tasks');
			$this->view->appSts = $dept->getpreviousTaskApprovalSts($task_id, $org_id);
		//	$this->view->taskdata= $dept->getDetail($task_id);
			//$this->view->appSts = true;
			$this->view->render('timesheet/tasks/taskapprovebymail');
			
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
	function getatask()
	{try{
			$gid = $_POST['taskid'];
			$Tasks = $this->loadModel('Tasks');
			$Tasksarray = $Tasks->getDetail($gid);
			echo json_encode($Tasksarray);		
		}catch(Exception $e){}
	}
	function taskapproval()
	{
		try{
			$arr = array();
			$arr[0] = $_POST["userid"];
			$arr[1] = $_POST["org_id"];
			$arr[2] = $_POST["employeeleaveid"];
			$arr[3] = $_POST["approverresult"];
			$arr[4] =  $_POST["comment"];
			$arr[5] = "";
			$dept = $this->loadModel('Task');
			$deptarray = $dept->TaskApprove($arr);
			//echo json_encode($deptarray);	
			//echo $deptarray['successMsg'];
			echo json_encode($deptarray);
		}catch(Exception $e){
			Utils::Trace($e->getMessage());
		}
	}
}
