
<?php

/**
 * Configuration for: Error reporting
 * Useful to show every little problem during development, but only show hard errors in production
 */
error_reporting(E_ALL);
ini_set("display_errors", 1);

/**
 * Configuration for: Base URL
 * This is the base url of our app. if you go live with your app, put your full domain name here.
 * if you are using a (different) port, then put this in here, like http://mydomain:8888/subfolder/
 * Note: The trailing slash is important!
 */
//define('URL', 'http://red.ubihrm.com/');
define('URL', 'https://ubiattendance.xyz/DUBAI/');
 $servername = $_SERVER['SERVER_NAME'];
 	
//$servername = ($servername).'/UBIHRM/DUBAI/'; 	
define('IMGURL',"http://".$servername."public/attendance/");
//define('LOCATION','online');
//define('S3PATH','/var/www/html/UBIHRM/DUBAI/application/s3.php');


/**
 * Configuration for: Folders
 * Here you define where your folders are. Unless you have renamed them, there's no need to change this.
 */
define('LIBS_PATH', 'application/libs/');
define('CONTROLLER_PATH', 'application/controllers/');
define('MODELS_PATH', 'application/models/');
define('VIEWS_PATH', 'application/views/');
// don't forget to make this folder writable via chmod 775 or 777 (?)
// the slash at the end is VERY important!
define('AVATAR_PATH', 'public/avatars/');

/**
 * Configuration for: Additional login providers: Facebook
 * Self-explaining. The FACEBOOK_LOGIN_PATH is the controller-action where the user is redirected to after getting
 * authenticated via Facebook. Leave it like that unless you know exactly what you do.
 */
define('FACEBOOK_LOGIN', false);
define('FACEBOOK_LOGIN_APP_ID', 'XXX');
define('FACEBOOK_LOGIN_APP_SECRET', 'XXX');
define('FACEBOOK_LOGIN_PATH', 'login/loginWithFacebook');
define('FACEBOOK_REGISTER_PATH', 'login/registerWithFacebook');

/**
 * Configuration for: Avatars/Gravatar support
 * Set to true if you want to use "Gravatar(s)", a service that automatically gets avatar pictures via using email
 * addresses of users by requesting images from the gravatar.com API. Set to false to use own locally saved avatars.
 * AVATAR_SIZE set the pixel size of avatars/gravatars (will be 44x44 by default). Avatars are always squares.
 * AVATAR_DEFAULT_IMAGE is the default image in public/avatars/
 */
define('USE_GRAVATAR', false);
define('AVATAR_SIZE', 44);
define('AVATAR_JPEG_QUALITY', 85);
define('AVATAR_DEFAULT_IMAGE', 'logo.jpg');

/**
 * Configuration for: Cookies
 * Please note: The COOKIE_DOMAIN needs the domain where your app is,
 * in a format like this: .mydomain.com
 * Note the . in front of the domain. No www, no http, no slash here!
 * For local development .127.0.0.1 is fine, but when deploying you should
 * change this to your real domain, like '.mydomain.com' ! The leading dot makes the cookie available for
 * sub-domains too.
 * @see http://stackoverflow.com/q/9618217/1114320
 * @see php.net/manual/en/function.setcookie.php
 */
// 1209600 seconds = 2 weeks
define('COOKIE_RUNTIME', 1209600);
// the domain where the cookie is valid for, for local development ".127.0.0.1" and ".localhost" will work
// IMPORTANT: always put a dot in front of the domain, like ".mydomain.com" !
define('COOKIE_DOMAIN', '.192.168.0.200');

/**
 * Configuration for: Database
 * This is the place where you define your database credentials, type etc.
 *
 * database type
 * define('DB_TYPE', 'mysql');
 * database host, usually it's "127.0.0.1" or "localhost", some servers also need port info, like "127.0.0.1:8080"
 * define('DB_HOST', '127.0.0.1');
 * name of the database. please note: database and database table are not the same thing!
 * define('DB_NAME', 'login');
 * user for your database. the user needs to have rights for SELECT, UPDATE, DELETE and INSERT
 * By the way, it's bad style to use "root", but for development it will work
 * define('DB_USER', 'root');
 * The password of the above user
 * define('DB_PASS', 'xxx');
 */
// define('DB_TYPE', 'mysql');
// define('DB_HOST', 'localhost');
// define('DB_NAME', 'ubitechdb01');
define('DB_TYPE', 'mysql');
define('DB_HOST', 'ubitech-prodb.chplckxijr27.ap-south-1.rds.amazonaws.com');
define('DB_NAME', 'ubitechdb01');
/* define('DB_USER', 'ubitechuser01');
define('DB_PASS', 'U3!tech@13'); 
 */
// define('DB_USER', 'root');
// define('DB_PASS', 'Admin#123456'); 
define('DB_USER', 'dbadmin');
define('DB_PASS', 'Admin20221110'); 

/**
 * Configuration for: Email server credentials
 *
 * Here you can define how you want to send emails.
 * If you have successfully set up a mail server on your linux server and you know
 * what you do, then you can skip this section. Otherwise please set EMAIL_USE_SMTP to true
 * and fill in your SMTP provider account data.
 *
 * An example setup for using gmail.com [Google Mail] as email sending service,
 * works perfectly in August 2013. Change the "xxx" to your needs.
 * Please note that there are several issues with gmail, like gmail will block your server
 * for "spam" reasons or you'll have a daily sending limit. See the readme.md for more info.
 *
 * define("PHPMAILER_DEBUG_MODE", 0);
 * define("EMAIL_USE_SMTP", true);
 * define("EMAIL_SMTP_HOST", 'ssl://smtp.gmail.com');
 * define("EMAIL_SMTP_AUTH", true);
 * define("EMAIL_SMTP_USERNAME", 'xxxxxxxxxx@gmail.com');
 * define("EMAIL_SMTP_PASSWORD", 'xxxxxxxxxxxxxxxxxxxx');
 * define("EMAIL_SMTP_PORT", 465);
 * define("EMAIL_SMTP_ENCRYPTION", 'ssl');
 *
 * It's really recommended to use SMTP!
 */
// Options: 0 = off, 1 = commands, 2 = commands and data, perfect to see SMTP errors, see the PHPMailer manual for more
define("PHPMAILER_DEBUG_MODE", 0);
// use SMTP or basic mail() ? SMTP is strongly recommended
define("EMAIL_USE_SMTP", false);
// name of your host
define("EMAIL_SMTP_HOST", 'yourhost');
// leave this true until your SMTP can be used without login
define("EMAIL_SMTP_AUTH", true);
// SMTP provider username
define("EMAIL_SMTP_USERNAME", 'yourusername');
// SMTP provider password
define("EMAIL_SMTP_PASSWORD", 'yourpassword');
// SMTP provider port
define("EMAIL_SMTP_PORT", 465);
// SMTP encryption, usually SMTP providers use "tls" or "ssl", for details see the PHPMailer manual
define("EMAIL_SMTP_ENCRYPTION", 'ssl');

/**
 * Configuration for: Email content data
 *
 * php-login uses the PHPMailer library, please have a look here if you want to add more
 * config stuff: @see https://github.com/PHPMailer/PHPMailer
 *
 * As email sending within your project needs some setting, you can do this here:
 *
 * Absolute URL to password reset action, necessary for email password reset links
 * define("EMAIL_PASSWORD_RESET_URL", "http://127.0.0.1/php-login/4-full-mvc-framework/login/passwordReset");
 * define("EMAIL_PASSWORD_RESET_FROM_EMAIL", "noreply@example.com");
 * define("EMAIL_PASSWORD_RESET_FROM_NAME", "My Project");
 * define("EMAIL_PASSWORD_RESET_SUBJECT", "Password reset for PROJECT XY");
 * define("EMAIL_PASSWORD_RESET_CONTENT", "Please click on this link to reset your password:");
 *
 * absolute URL to verification action, necessary for email verification links
 * define("EMAIL_VERIFICATION_URL", "http://127.0.0.1/php-login/4-full-mvc-framework/login/verify/");
 * define("EMAIL_VERIFICATION_FROM_EMAIL", "noreply@example.com");
 * define("EMAIL_VERIFICATION_FROM_NAME", "My Project");
 * define("EMAIL_VERIFICATION_SUBJECT", "Account Activation for PROJECT XY");
 * define("EMAIL_VERIFICATION_CONTENT", "Please click on this link to activate your account:");
 */
define("EMAIL_PASSWORD_RESET_URL", URL . "login/verifypasswordreset");
define("EMAIL_PASSWORD_RESET_FROM_EMAIL", "no-reply@example.com");
define("EMAIL_PASSWORD_RESET_FROM_NAME", "My Project");
define("EMAIL_PASSWORD_RESET_SUBJECT", "Password reset for PROJECT XY");
define("EMAIL_PASSWORD_RESET_CONTENT", "Please click on this link to reset your password: ");

define("EMAIL_VERIFICATION_URL", URL . "login/verify");
define("EMAIL_VERIFICATION_FROM_EMAIL", "no-reply@example.com");
define("EMAIL_VERIFICATION_FROM_NAME", "My Project");
define("EMAIL_VERIFICATION_SUBJECT", "Account activation for PROJECT XY");
define("EMAIL_VERIFICATION_CONTENT", "Please click on this link to activate your account: ");

/**
 * Configuration for: Error messages and notices
 *
 * In this project, the error messages, notices etc are all-together called "feedback".
 */
define("FEEDBACK_UNKNOWN_ERROR", "Unknown error occurred!");
define("FEEDBACK_PASSWORD_WRONG_3_TIMES", "You have typed in a wrong password 3 or more times already. Please wait 30 seconds to try again.");
define("FEEDBACK_ACCOUNT_NOT_ACTIVATED_YET", "Your account is not activated yet. Please click on the confirm link in the mail.");
define("FEEDBACK_PASSWORD_WRONG", "Password was wrong.");
define("FEEDBACK_USER_DOES_NOT_exists", "This user does not exists.");
// The "login failed"-message is a security improved feedback that doesn't show a potential attacker if the user existss or not
define("FEEDBACK_LOGIN_FAILED", "Login failed.");
define("FEEDBACK_USERNAME_FIELD_EMPTY", "Username field was empty.");
define("FEEDBACK_PASSWORD_FIELD_EMPTY", "Password field was empty.");
define("FEEDBACK_EMAIL_FIELD_EMPTY", "Email and passwords fields were empty.");
define("FEEDBACK_EMAIL_AND_PASSWORD_FIELDS_EMPTY", "Email field was empty.");
define("FEEDBACK_USERNAME_SAME_AS_OLD_ONE", "Sorry, that username is the same as your current one. Please choose another one.");
define("FEEDBACK_USERNAME_ALREADY_TAKEN", "Sorry, that username is already taken. Please choose another one.");
define("FEEDBACK_USER_EMAIL_ALREADY_TAKEN", "Sorry, that email is already in use. Please choose another one.");
define("FEEDBACK_USERNAME_CHANGE_SUCCESSFUL", "Your username has been changed successfully.");
define("FEEDBACK_USERNAME_AND_PASSWORD_FIELD_EMPTY", "Username and password fields were empty.");
define("FEEDBACK_USERNAME_DOES_NOT_FIT_PATTERN", "Username does not fit the name scheme: only a-Z and numbers are allowed, 2 to 64 characters.");
define("FEEDBACK_EMAIL_DOES_NOT_FIT_PATTERN", "Sorry, your chosen email does not fit into the email naming pattern.");
define("FEEDBACK_EMAIL_SAME_AS_OLD_ONE", "Sorry, that email address is the same as your current one. Please choose another one.");
define("FEEDBACK_EMAIL_CHANGE_SUCCESSFUL", "Your email address has been changed successfully.");
define("FEEDBACK_CAPTCHA_WRONG", "The entered captcha security characters were wrong.");
define("FEEDBACK_PASSWORD_REPEAT_WRONG", "Password and password repeat are not the same.");
define("FEEDBACK_PASSWORD_TOO_SHORT", "Password has a minimum length of 6 characters.");
define("FEEDBACK_USERNAME_TOO_SHORT_OR_TOO_LONG", "Username cannot be shorter than 2 or longer than 64 characters.");
define("FEEDBACK_EMAIL_TOO_LONG", "Email cannot be longer than 64 characters.");
define("FEEDBACK_ACCOUNT_SUCCESSFULLY_CREATED", "Your account has been created successfully. We have sent you an email. Please click the verification link in that mail.");
define("FEEDBACK_VERIFICATION_MAIL_SENDING_FAILED", "Sorry, we could not send you the verification mail. Your account could not be created.");
define("FEEDBACK_ACCOUNT_CREATION_FAILED", "Sorry, your registration failed. Please go back and try again.");
define("FEEDBACK_VERIFICATION_MAIL_SENDING_ERROR", "Verification mail could not be sent due to: ");
define("FEEDBACK_VERIFICATION_MAIL_SENDING_SUCCESSFUL", "Verification mail has been sent successfully.");
define("FEEDBACK_ACCOUNT_ACTIVATION_SUCCESSFUL", "Activation was successful! You can now log in.");
define("FEEDBACK_ACCOUNT_ACTIVATION_FAILED", "Sorry, no such id/verification code combination existss...");
define("FEEDBACK_AVATAR_UPLOAD_SUCCESSFUL", "Avatar upload was successful.");
define("FEEDBACK_AVATAR_UPLOAD_WRONG_TYPE", "Only JPEG and PNG files are supported.");
define("FEEDBACK_AVATAR_UPLOAD_TOO_SMALL", "Avatar source file's width/height is too small. Needs to be 100x100 pixel minimum.");
define("FEEDBACK_AVATAR_UPLOAD_TOO_BIG", "Avatar source file is too big. Max size should be less than 5 Mb .");
define("FEEDBACK_AVATAR_FOLDER_DOES_NOT_exists_OR_NOT_WRITABLE", "Avatar folder does not exists or is not writable. Please change this via chmod 775 or 777.");
define("FEEDBACK_AVATAR_IMAGE_UPLOAD_FAILED", "Something went wrong with the image upload.");
define("FEEDBACK_PASSWORD_RESET_TOKEN_FAIL", "Could not write token to database.");
define("FEEDBACK_PASSWORD_RESET_TOKEN_MISSING", "No password reset token.");
define("FEEDBACK_PASSWORD_RESET_MAIL_SENDING_ERROR", "Password reset mail could not be sent due to: ");
define("FEEDBACK_PASSWORD_RESET_MAIL_SENDING_SUCCESSFUL", "A password reset mail has been sent successfully.");
define("FEEDBACK_PASSWORD_RESET_LINK_EXPIRED", "Your reset link has expired. Please use the reset link within one hour.");
define("FEEDBACK_PASSWORD_RESET_COMBINATION_DOES_NOT_exists", "Username/Verification code combination does not exists.");
define("FEEDBACK_PASSWORD_RESET_LINK_VALID", "Password reset validation link is valid. Please change the password now.");
define("FEEDBACK_PASSWORD_CHANGE_SUCCESSFUL", "Password successfully changed.");
define("FEEDBACK_PASSWORD_CHANGE_FAILED", "Sorry, your password changing failed.");
define("FEEDBACK_ACCOUNT_UPGRADE_SUCCESSFUL", "Account upgrade was successful.");
define("FEEDBACK_ACCOUNT_UPGRADE_FAILED", "Account upgrade failed.");
define("FEEDBACK_ACCOUNT_DOWNGRADE_SUCCESSFUL", "Account downgrade was successful.");
define("FEEDBACK_ACCOUNT_DOWNGRADE_FAILED", "Account downgrade failed.");
define("FEEDBACK_NOTE_CREATION_FAILED", "Note creation failed.");
define("FEEDBACK_NOTE_EDITING_FAILED", "Note editing failed.");
define("FEEDBACK_NOTE_DELETION_FAILED", "Note deletion failed.");
define("FEEDBACK_COOKIE_INVALID", "Your remember-me-cookie is invalid.");
define("FEEDBACK_COOKIE_LOGIN_SUCCESSFUL", "You were successfully logged in via the remember-me-cookie.");
define("FEEDBACK_FACEBOOK_LOGIN_NOT_REGISTERED", "Sorry, you don't have an account here. Please register first.");
define("FEEDBACK_FACEBOOK_EMAIL_NEEDED", "Sorry, but you need to allow us to see your email address to register.");
define("FEEDBACK_FACEBOOK_UID_ALREADY_existsS", "Sorry, but you have already registered here (your Facebook ID existss in our database).");
define("FEEDBACK_FACEBOOK_EMAIL_ALREADY_existsS", "Sorry, but you have already registered here (your Facebook email existss in our database).");
define("FEEDBACK_FACEBOOK_USERNAME_ALREADY_existsS", "Sorry, but you have already registered here (your Facebook username existss in our database).");
define("FEEDBACK_FACEBOOK_REGISTER_SUCCESSFUL", "You have been successfully registered with Facebook.");
define("FEEDBACK_FACEBOOK_OFFLINE", "We could not reach the Facebook servers. Maybe Facebook is offline (that really happens sometimes).");

////////////////////////// DIVISION MODULE MESSAGES   ///////////////////////////////

define("DIVISION_MODULE_GETALL", "No record found.");
define("DIVISION_MODULE_GETDETAIL_SUCCESS", "Location fetched successfully!");
define("DIVISION_MODULE_GETDETAIL_FAILED", " Problem in updating this record.");
define("DIVISION_MODULE_UPDATION_SUCCESS", "Location updated successfully!");
define("DIVISION_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("DIVISION_MODULE_UPDATION_DUPLICATE", "Location name or code already exists.");
define("DIVISION_MODULE_CREATION_SUCCESS", "Location created successfully!");
define("DIVISION_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("DIVISION_MODULE_CREATION_DUPLICATE", "Location name or code already exists.");
define("DIVISION_MODULE_DELETE_SUCCESS", "Location deleted successfully!");
define("DIVISION_MODULE_DELETE_FAILED", "There is some problem while deleting this record.");
define("DIVISION_MODULE_DELETE_exists", "Location containing employees cannot be deleted.");

////////////////////////// RELATED LIST MODULE MESSAGES   ///////////////////////////////

define("RELATEDLIST_MODULE_GETALL", "No record found.");
define("RELATEDLIST_MODULE_GETDETAIL_SUCCESS", "Related list fetched successfully!");
define("RELATEDLIST_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("RELATEDLIST_MODULE_UPDATION_SUCCESS", "Related list updated successfully!");
define("RELATEDLIST_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("RELATEDLIST_MODULE_UPDATION_DUPLICATE", "Related list already exists.");
define("RELATEDLIST_MODULE_CREATION_SUCCESS", "Related list created successfully!");
define("RELATEDLIST_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("RELATEDLIST_MODULE_CREATION_DUPLICATE", "Related list already exists.");
define("RELATEDLIST_MODULE_DELETE_SUCCESS", "Related list deleted successfully!");
define("RELATEDLIST_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("RELATEDLIST_MODULE_DELETE_exists", "Related list containing child list cannot be deleted.");

////////////////////////// DEPARTMENT MODULE MESSAGES   ///////////////////////////////

define("DEPARTMENT_MODULE_GETALL", "No record found.");
define("DEPARTMENT_MODULE_GETDETAIL_SUCCESS", "Department fetched successfully!");
define("DEPARTMENT_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("DEPARTMENT_MODULE_UPDATION_SUCCESS", "Department updated successfully!");
define("DEPARTMENT_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("DEPARTMENT_MODULE_UPDATION_DUPLICATE", "Department name or code already exists.");
define("DEPARTMENT_MODULE_CREATION_SUCCESS", "Department created successfully!");
define("DEPARTMENT_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("DEPARTMENT_MODULE_CREATION_DUPLICATE", "Department name or code already exists.");
define("DEPARTMENT_MODULE_DELETE_SUCCESS", "Department deleted successfully!");
define("DEPARTMENT_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("DEPARTMENT_MODULE_DELETE_exists", "Department containing Employees cannot be deleted.");

////////////////////////// DESIGNATION MODULE MESSAGES   ///////////////////////////////

define("DESIGNATION_MODULE_GETALL", "No record found.");
define("DESIGNATION_MODULE_STATUSCHANGE", "Status changed successfully.");
define("DESIGNATION_MODULE_GETDETAIL_SUCCESS", "Designation fetched successfully!");
define("DESIGNATION_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("DESIGNATION_MODULE_UPDATION_SUCCESS", "Designation updated successfully!");
define("DESIGNATION_MODULE_UPDATION_FAILED", "There is some problem in updating record.");
define("DESIGNATION_MODULE_UPDATION_DUPLICATE", "Designation name or code  already exists.");
define("DESIGNATION_MODULE_CREATION_SUCCESS", "Designation created successfully!");
define("DESIGNATION_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("DESIGNATION_MODULE_CREATION_DUPLICATE", "Designation name or code already exists.");
define("DESIGNATION_MODULE_DELETE_SUCCESS", "Designation deleted successfully!");
define("DESIGNATION_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("DESIGNATION_MODULE_DELETE_exists", "Designation assigned to  an employee cannot be deleted.");

////////////////////////// GRADE MODULE MESSAGES   ///////////////////////////////

define("GRADE_MODULE_GETALL", "No record found.");
define("GRADE_MODULE_LEVELDOWN", "Level has been moved down successfully");
define("GRADE_MODULE_LEVELUP", "Level has been moved up successfully.");
define("GRADE_MODULE_GETDETAIL_SUCCESS", "Grade fetched successfully!");
define("GRADE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("GRADE_MODULE_UPDATION_SUCCESS", "Grade updated successfully!");
define("GRADE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("GRADE_MODULE_UPDATION_DUPLICATE", "Grade name or code already exists.");
define("GRADE_MODULE_CREATION_SUCCESS", "Grade created successfully!");
define("GRADE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("GRADE_MODULE_CREATION_DUPLICATE", "Grade name or code already exists.");
define("GRADE_MODULE_DELETE_SUCCESS", "Grade deleted successfully!");
define("GRADE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("GRADE_MODULE_DELETE_exists", "Grade containing employees cannot be deleted.");

////////////////////////// LOCATION MODULE MESSAGES   ///////////////////////////////

define("LOCATION_MODULE_GETALL", "No record found.");
define("LOCATION_MODULE_GETDETAIL_SUCCESS", "Location fetched successfully!");
define("LOCATION_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("LOCATION_MODULE_UPDATION_SUCCESS", "Location updated successfully!");
define("LOCATION_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("LOCATION_MODULE_UPDATION_DUPLICATE", "Location name already exists.");
define("LOCATION_MODULE_CREATION_SUCCESS", "Location created successfully!");
define("LOCATION_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("LOCATION_MODULE_CREATION_DUPLICATE", "Location name already exists.");
define("LOCATION_MODULE_DELETE_SUCCESS", "Location deleted successfully!");
define("LOCATION_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("LOCATION_MODULE_DELETE_exists", "Location containing employee cannot be deleted.");

////////////////////////// ROLE MODULE MESSAGES   ///////////////////////////////

define("ROLE_MODULE_GETALL", "No record found.");
define("ROLE_MODULE_GETDETAIL_SUCCESS", "Role fetched successfully!");
define("ROLE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("ROLE_MODULE_UPDATION_SUCCESS", "Role updated successfully!");
define("ROLE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("ROLE_MODULE_UPDATION_DUPLICATE", "Role name already exists.");
define("ROLE_MODULE_CREATION_SUCCESS", "Role created successfully!");
define("ROLE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("ROLE_MODULE_CREATION_DUPLICATE", "Role name already exists.");
define("ROLE_MODULE_DELETE_SUCCESS", "Role deleted successfully!");
define("ROLE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("ROLE_MODULE_DELETE_exists", "Role containing employee cannot be deleted.");


////////////////////////// HOLIDAY MODULE MESSAGES   ///////////////////////////////

define("HOLIDAY_MODULE_GETALL", "No record found.");
define("HOLIDAY_MODULE_GETDETAIL_SUCCESS", "Holiday fetched successfully!");
define("HOLIDAY_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("HOLIDAY_MODULE_UPDATION_SUCCESS", "Holiday updated successfully!");
define("HOLIDAY_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("HOLIDAY_MODULE_UPDATION_DUPLICATE", "Holiday dates already exists.");
define("HOLIDAY_MODULE_CREATION_SUCCESS", "Holiday created successfully!");
define("HOLIDAY_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("HOLIDAY_MODULE_CREATION_DUPLICATE", "Holiday already exists.");
define("HOLIDAY_MODULE_DELETE_SUCCESS", "Holiday deleted successfully!");
define("HOLIDAY_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("HOLIDAY_MODULE_DELETE_exists", "Holiday assigned to employee cannot be deleted.");

////////////////////////// ASSET MODULE MESSAGES   ///////////////////////////////

define("ASSET_MODULE_GETALL", "No record found.");
define("ASSET_MODULE_GETDETAIL_SUCCESS", "Asset fetched successfully!");
define("ASSET_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("ASSET_MODULE_UPDATION_SUCCESS", "Asset updated successfully!");
define("ASSET_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("ASSET_MODULE_UPDATION_DUPLICATE", "Asset already exists.");
define("ASSET_MODULE_CREATION_SUCCESS", "Asset created successfully!");
define("ASSET_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("ASSET_MODULE_CREATION_DUPLICATE", "Asset already exists.");
define("ASSET_MODULE_DELETE_SUCCESS", "Asset deleted successfully!");
define("ASSET_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("ASSET_MODULE_DELETE_exists", "Asset issued to an employee cannot be deleted.");


////////////////////////// CATEGORY MODULE MESSAGES   ///////////////////////////////

define("CATEGORY_MODULE_GETALL", "No record found.");
define("CATEGORY_MODULE_GETDETAIL_SUCCESS", "Category fetched successfully!");
define("CATEGORY_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("CATEGORY_MODULE_UPDATION_SUCCESS", "Category updated successfully!");
define("CATEGORY_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("CATEGORY_MODULE_UPDATION_DUPLICATE", "Category already exists.");
define("CATEGORY_MODULE_CREATION_SUCCESS", "Category created successfully!");
define("CATEGORY_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("CATEGORY_MODULE_CREATION_DUPLICATE", "Category already exists.");
define("CATEGORY_MODULE_DELETE_SUCCESS", "Category deleted successfully!");
define("CATEGORY_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("CATEGORY_MODULE_DELETE_exists", "Category containing employee data cannot be deleted.");


////////////////////////// CHECKLIST MODULE MESSAGES   ///////////////////////////////

define("CHECKLIST_MODULE_GETALL", "No record found.");
define("CHECKLIST_MODULE_GETDETAIL_SUCCESS", "Checklist fetched successfully!");
define("CHECKLIST_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("CHECKLIST_MODULE_UPDATION_SUCCESS", "Checklist updated successfully!");
define("CHECKLIST_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("CHECKLIST_MODULE_UPDATION_DUPLICATE", "Checklist already exists.");
define("CHECKLIST_MODULE_CREATION_SUCCESS", "Checklist created successfully!");
define("CHECKLIST_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("CHECKLIST_MODULE_CREATION_DUPLICATE", "Checklist already exists.");
define("CHECKLIST_MODULE_DELETE_SUCCESS", "Checklist deleted successfully!");
define("CHECKLIST_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("CHECKLIST_MODULE_DELETE_exists", "Checklist assigned to an  employee cannot be deleted.");


////////////////////////// TEMPLATE MODULE MESSAGES   ///////////////////////////////

define("TEMPLATE_MODULE_GETALL", "No record found.");
define("TEMPLATE_MODULE_GETDETAIL_SUCCESS", "Template fetched successfully!");
define("TEMPLATE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("TEMPLATE_MODULE_UPDATION_SUCCESS", "Template updated successfully!");
define("TEMPLATE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("TEMPLATE_MODULE_UPDATION_DUPLICATE", "Template already exists.");
define("TEMPLATE_MODULE_CREATION_SUCCESS", "Template created successfully!");
define("TEMPLATE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("TEMPLATE_MODULE_CREATION_DUPLICATE", "Template already exists.");
define("TEMPLATE_MODULE_DELETE_SUCCESS", "Template deleted successfully!");
define("TEMPLATE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("TEMPLATE_MODULE_DELETE_exists", "Template containing employee cannot be deleted.");


////////////////////////// SKILL MODULE MESSAGES   ///////////////////////////////

define("SKILL_MODULE_GETALL", "No record found.");
define("SKILL_MODULE_GETDETAIL_SUCCESS", "Skill fetched successfully!");
define("SKILL_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("SKILL_MODULE_UPDATION_SUCCESS", "Skill updated successfully!");
define("SKILL_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("SKILL_MODULE_UPDATION_DUPLICATE", "Skill code or name already exists.");
define("SKILL_MODULE_CREATION_SUCCESS", "Skill created successfully!");
define("SKILL_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("SKILL_MODULE_CREATION_DUPLICATE", "Skill code or name already exists.");
define("SKILL_MODULE_DELETE_SUCCESS", "Skill deleted successfully!");
define("SKILL_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("SKILL_MODULE_DELETE_exists", "Skill containing employee cannot be deleted.");


////////////////////////// EMPSTATUS MODULE MESSAGES   ///////////////////////////////

define("EMPSTATUS_MODULE_GETALL", "No record found.");
define("EMPSTATUS_MODULE_GETDETAIL_SUCCESS", "Status fetched successfully!");
define("EMPSTATUS_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("EMPSTATUS_MODULE_UPDATION_SUCCESS", "Status updated successfully!");
define("EMPSTATUS_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("EMPSTATUS_MODULE_UPDATION_DUPLICATE", "Status code already exists.");
define("EMPSTATUS_MODULE_CREATION_SUCCESS", "Status created successfully!");
define("EMPSTATUS_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("EMPSTATUS_MODULE_CREATION_DUPLICATE", "Status code already exists.");
define("EMPSTATUS_MODULE_DELETE_SUCCESS", "Status deleted successfully!");
define("EMPSTATUS_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("EMPSTATUS_MODULE_DELETE_exists", "Status containing employee cannot be deleted.");


////////////////////////// QUALIFICATION MODULE MESSAGES   ///////////////////////////////

define("QUALIFICATION_MODULE_GETALL", "No record found.");
define("QUALIFICATION_MODULE_GETDETAIL_SUCCESS", "Qualification fetched successfully!");
define("QUALIFICATION_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("QUALIFICATION_MODULE_UPDATION_SUCCESS", "Qualification updated successfully!");
define("QUALIFICATION_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("QUALIFICATION_MODULE_UPDATION_DUPLICATE", "Qualification code or name already exists.");
define("QUALIFICATION_MODULE_CREATION_SUCCESS", "Qualification added!");
define("QUALIFICATION_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("QUALIFICATION_MODULE_CREATION_DUPLICATE", "Qualification code or name already exists.");
define("QUALIFICATION_MODULE_DELETE_SUCCESS", "Qualification deleted successfully!");
define("QUALIFICATION_MODULE_DELETE_FAILED", "There is some problem while deleting this record.");
define("QUALIFICATION_MODULE_DELETE_exists", "Qualification assigned to an employee cannot be deleted.");


////////////////////////// BLOODGROUP MODULE MESSAGES   ///////////////////////////////

define("BLOODGROUP_MODULE_GETALL", "No record found.");
define("BLOODGROUP_MODULE_GETDETAIL_SUCCESS", "Blood Group fetched successfully!");
define("BLOODGROUP_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("BLOODGROUP_MODULE_UPDATION_SUCCESS", "Blood Group updated successfully!");
define("BLOODGROUP_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("BLOODGROUP_MODULE_UPDATION_DUPLICATE", "Blood Group name or code already exists.");
define("BLOODGROUP_MODULE_CREATION_SUCCESS", "Blood Group created successfully!");
define("BLOODGROUP_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("BLOODGROUP_MODULE_CREATION_DUPLICATE", "Blood Group name or code already exists.");
define("BLOODGROUP_MODULE_DELETE_SUCCESS", "Blood Group deleted successfully!");
define("BLOODGROUP_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("BLOODGROUP_MODULE_DELETE_exists", "Blood Group containing employee cannot be deleted.");

////////////////////////// DOCUMENT MODULE MESSAGES   ///////////////////////////////

define("DOCUMENT_MODULE_GETALL", "No record found.");
define("DOCUMENT_MODULE_GETDETAIL_SUCCESS", "Document fetched successfully!");
define("DOCUMENT_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("DOCUMENT_MODULE_UPDATION_SUCCESS", "Document updated successfully!");
define("DOCUMENT_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("DOCUMENT_MODULE_UPDATION_DUPLICATE", "Document code or name already exists.");
define("DOCUMENT_MODULE_CREATION_SUCCESS", "Document type added!");
define("DOCUMENT_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("DOCUMENT_MODULE_CREATION_DUPLICATE", "Document code or name already exists.");
define("DOCUMENT_MODULE_DELETE_SUCCESS", "Document deleted successfully!");
define("DOCUMENT_MODULE_DELETE_FAILED", "There is some problem while deleting this  record.");
define("DOCUMENT_MODULE_DELETE_EXIST", "This document  has been used by  an employee and  cannot be deleted.");

////////////////////////// VISA MODULE MESSAGES   ///////////////////////////////

define("VISA_MODULE_GETALL", "No record found.");
define("VISA_MODULE_GETDETAIL_SUCCESS", "Visa fetched successfully!");
define("VISA_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("VISA_MODULE_UPDATION_SUCCESS", "Visa type updated successfully!");
define("VISA_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("VISA_MODULE_UPDATION_DUPLICATE", "Visa type already exists.");
define("VISA_MODULE_CREATION_SUCCESS", "Visa type created successfully!");
define("VISA_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("VISA_MODULE_CREATION_DUPLICATE", "Visa type already exists.");
define("VISA_MODULE_DELETE_SUCCESS", "Visa type deleted successfully!");
define("VISA_MODULE_DELETE_FAILED", "There is some problem while deleting this record.");
define("VISA_MODULE_DELETE_exists", "Visa type has been used for an employee and cannot be deleted.");

////////////////////////// FUNCAREA MODULE MESSAGES   ///////////////////////////////

define("FUNCAREA_MODULE_GETALL", "No record found.");
define("FUNCAREA_MODULE_GETDETAIL_SUCCESS", "Functional Area fetched successfully!");
define("FUNCAREA_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("FUNCAREA_MODULE_UPDATION_SUCCESS", "Functional Area updated successfully!");
define("FUNCAREA_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("FUNCAREA_MODULE_UPDATION_DUPLICATE", "Functional Area already exists.");
define("FUNCAREA_MODULE_CREATION_SUCCESS", "Functional Area created successfully!");
define("FUNCAREA_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("FUNCAREA_MODULE_CREATION_DUPLICATE", "Functional Area already exists.");
define("FUNCAREA_MODULE_DELETE_SUCCESS", "Functional Area deleted successfully!");
define("FUNCAREA_MODULE_DELETE_FAILED", "There is some problem while deleting this record.");
define("FUNCAREA_MODULE_DELETE_exists", "Functional Area assigned to an employee cannot be deleted.");

////////////////////////// EMPLOYEE MODULE MESSAGES   ///////////////////////////////

define("EMPLOYEE_MODULE_IMAGEIMPORT", "Choose Only Image Format.");
define("EMPLOYEE_MODULE_INSERT", "record inserted successfully.");
define("EMPLOYEE_MODULE_INSERT_FAIL", "record not inserted.");
define("EMPLOYEE_MODULE_EMPIMPORT", " Employees imported successfully");
define("EMPLOYEE_MODULE_EMPIMPORT_FAIL", " Employee could not be imported.");
define("EMPLOYEE_MODULE_DOCUPLOAD", "Employee Document uploaded successfully.");
define("EMPLOYEE_MODULE_DOCUPLOAD_FAILED", "Employee Documents could not be uploaded");
define("EMPLOYEE_MODULE_PROFILEIMAGE", "Profile picture uploaded successfully..");
define("EMPLOYEE_MODULE_GETALL", "Employee not found.");
define("EMPLOYEE_MODULE_GETDETAIL_SUCCESS", "Employee fetched successfully!");
define("EMPLOYEE_MODULE_GETDETAIL_FAILED", "There is some problem in fetching records");
define("EMPLOYEE_MODULE_UPDATION_SUCCESS", "Employee details updated ");
define("EMPLOYEE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("EMPLOYEE_MODULE_UPDATION_DUPLICATE", "Employee already exists.");
define("EMPLOYEE_MODULE_CREATION_SUCCESS", "Employee has been added successfully!");
define("EMPLOYEE_MODULE_CREATION_FAILED", "There is some problem while creating record.");
define("EMPLOYEE_MODULE_CREATION_DUPLICATE", "Employee name already exists.");
define("EMPLOYEE_MODULE_DELETE_SUCCESS", "Employee deleted successfully!");
define("EMPLOYEE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("EMPLOYEE_MODULE_DELETE_exists", "Employee cannot be deleted - contains associated information .");

////////////////////////// PASSWORD MODULE MESSAGES   ///////////////////////////////


define("PASSWORD_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("PASSWORD_MODULE_UPDATION_SUCCESS", "Password Changed successfully!");


////////////////////////// SHIFT MODULE MESSAGES   ///////////////////////////////

define("SHIFT_MODULE_GETALL", "No record found.");
define("SHIFT_MODULE_GETDETAIL_SUCCESS", "Shift fetched successfully!");
define("SHIFT_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("SHIFT_MODULE_UPDATION_SUCCESS", "Shift updated successfully!");
define("SHIFT_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("SHIFT_MODULE_UPDATION_DUPLICATE", "Shift already exists.");
define("SHIFT_MODULE_CREATION_SUCCESS", "Shift created successfully!");
define("SHIFT_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("SHIFT_MODULE_CREATION_DUPLICATE", "Shift already exists.");
define("SHIFT_MODULE_DELETE_SUCCESS", "Shift deleted successfully!");
define("SHIFT_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("SHIFT_MODULE_DELETE_exists", "Shift containing employee cannot be deleted.");

////////////////////////// ATTENDANCE MODULE MESSAGES   ///////////////////////////////

define("ATTENDANCE_MODULE_RECORDSKIP", "record skipped.");

define("ATTENDANCE_MODULE_MARKEDALREADY", "Attendance already marked.");
 define("ATTENDANCE_MODULE_IMPORT", "Attendance imported.");
 define("ATTENDANCE_MODULE_NOTIMPORT", "Attendance not imported.");
define("ATTENDANCE_MODULE_FILTER", "No Employee found for this filter.");
define("ATTENDANCE_MODULE_GETALL", "No record found.");
define("ATTENDANCE_MODULE_GETDETAIL_SUCCESS", "Attendance fetched successfully!");
define("ATTENDANCE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("ATTENDANCE_MODULE_UPDATION_SUCCESS", "Attendance has been updated successfully!");
define("ATTENDANCE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("ATTENDANCE_MODULE_UPDATION_DUPLICATE", "Attendance already exists.");
define("ATTENDANCE_MODULE_CREATION_SUCCESS", "Attendance has been added successfully!");
define("ATTENDANCE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("ATTENDANCE_MODULE_CREATION_DUPLICATE", "Attendance already exists.");
define("ATTENDANCE_MODULE_DELETE_SUCCESS", "Attendance deleted successfully!");
define("ATTENDANCE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("ATTENDANCE_MODULE_DELETE_exists", "Attendance containing employee cannot be deleted.");


////////////////////////// SALARY HEAD MODULE MESSAGES   ///////////////////////////////

define("SALARYHEAD_MODULE_GETALL", "No record found.");
define("SALARYHEAD_MODULE_GETDETAIL_SUCCESS", "Salary Head fetched successfully!");
define("SALARYHEAD_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("SALARYHEAD_MODULE_UPDATION_SUCCESS", "Salary Head updated successfully!");
define("SALARYHEAD_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("SALARYHEAD_MODULE_UPDATION_DUPLICATE", "Salary Head already exists.");
define("SALARYHEAD_MODULE_CREATION_SUCCESS", "Salary Head created successfully!");
define("SALARYHEAD_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("SALARYHEAD_MODULE_CREATION_DUPLICATE", "Salary Head name already exists.");
define("SALARYHEAD_MODULE_DELETE_SUCCESS", "Salary Head deleted successfully!");
define("SALARYHEAD_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("SALARYHEAD_MODULE_DELETE_exists", "Salary Head containing employee cannot be deleted.");

////////////////////////// GRATUITY MODULE MESSAGES   ///////////////////////////////

define("GRATUITY_MODULE_GETALL", "No record found.");
define("GRATUITY_MODULE_GETDETAIL_SUCCESS", "Gratuity fetched successfully!");
define("GRATUITY_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("GRATUITY_MODULE_UPDATION_SUCCESS", "Gratuity updated successfully!");
define("GRATUITY_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("GRATUITY_MODULE_UPDATION_DUPLICATE", "Gratuity already exists.");
define("GRATUITY_MODULE_CREATION_SUCCESS", "Gratuity created successfully!");
define("GRATUITY_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("GRATUITY_MODULE_CREATION_DUPLICATE", "Gratuity name already exists.");
define("GRATUITY_MODULE_DELETE_SUCCESS", "Gratuity deleted successfully!");
define("GRATUITY_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("GRATUITY_MODULE_DELETE_exists", "Gratuity containing employee cannot be deleted.");

////////////////////// INCENTIVE MODULE MESSAGES ///////////

define("INCENTIVE_MODULE_GETALL", "No record found.");
define("INCENTIVE_MODULE_GETDETAIL_SUCCESS", "Incentive fetched successfully!");
define("INCENTIVE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("INCENTIVE_MODULE_UPDATION_SUCCESS", "Incentive updated successfully!");
define("INCENTIVE_MODULE_UPDATION_FAILED", "Please add the incentive");
define("INCENTIVE_MODULE_UPDATION_DUPLICATE", "Incentive already exists.");
define("INCENTIVE_MODULE_CREATION_SUCCESS", "Incentive  added !");
define("INCENTIVE_MODULE_CREATION_FAILED", "Please add the incentive");
define("INCENTIVE_MODULE_CREATION_DUPLICATE", "Incentive already exists.");
define("INCENTIVE_MODULE_DELETE_SUCCESS", "Incentive deleted successfully!");
define("INCENTIVE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("INCENTIVE_MODULE_DELETE_exists", "Incentive containing employee cannot be deleted.");

////////////////////////// BENEFIT MODULE MESSAGES   ///////////////////////////////

define("BENEFIT_MODULE_GETALL", "No record found.");
define("BENEFIT_MODULE_GETDETAIL_SUCCESS", "Benefit fetched successfully!");
define("BENEFIT_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("BENEFIT_MODULE_UPDATION_SUCCESS", "Benefit updated successfully!");
define("BENEFIT_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("BENEFIT_MODULE_UPDATION_DUPLICATE", "Benefit already exists.");
define("BENEFIT_MODULE_CREATION_SUCCESS", "Benefit created successfully!");
define("BENEFIT_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("BENEFIT_MODULE_CREATION_DUPLICATE", "Benefit already exists.");
define("BENEFIT_MODULE_DELETE_SUCCESS", "Benefit deleted successfully!");
define("BENEFIT_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("BENEFIT_MODULE_DELETE_exists", "Benefit containing employee cannot be deleted.");

////////////////////////// LEAVETYPE MODULE MESSAGES   ///////////////////////////////

define("LEAVETYPE_MODULE_GETALL", "No record found.");
define("LEAVETYPE_MODULE_WORKINGDAY_DUPLICATE", "Leave type criteria already existss.");
define("LEAVETYPE_MODULE_GETDETAIL_SUCCESS", "Leave type fetched successfully!");
define("LEAVETYPE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("LEAVETYPE_MODULE_UPDATION_SUCCESS", "Leave type updated successfully!");
define("LEAVETYPE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("LEAVETYPE_MODULE_UPDATION_DUPLICATE", "Leave type already exists.");
define("LEAVETYPE_MODULE_CREATION_SUCCESS", "Leave type created successfully!");
define("LEAVETYPE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("LEAVETYPE_MODULE_CREATION_DUPLICATE", "Leave type already exists.");
define("LEAVETYPE_MODULE_DELETE_SUCCESS", "Leave type deleted successfully!");
define("LEAVETYPE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("LEAVETYPE_MODULE_DELETE_exists", "Leave type containing employee cannot be deleted.");


////////////////////////// USER MODULE MESSAGES   ///////////////////////////////

define("USER_MODULE_GETALL", "No record found.");
define("USER_MODULE_GETDETAIL_SUCCESS", "User fetched successfully!");
define("USER_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("USER_MODULE_UPDATION_SUCCESS", "User updated successfully!");
define("USER_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("USER_MODULE_UPDATION_DUPLICATE", "User name already exists.");
define("USER_MODULE_CREATION_SUCCESS", "User created successfully!");
define("USER_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("USER_MODULE_CREATION_DUPLICATE", "User name already exists.");
define("USER_MODULE_DELETE_SUCCESS", "User deleted successfully!");
define("USER_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("USER_MODULE_DELETE_exists", "User containing employee cannot be deleted.");


////////////////////////// PERMISSION MODULE MESSAGES   ///////////////////////////////

define("PERMISSION_MODULE_GETALL", "No record found.");
define("PERMISSION_MODULE_GETDETAIL_SUCCESS", "Permission fetched successfully!");
define("PERMISSION_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("PERMISSION_MODULE_UPDATION_SUCCESS", "Permission updated successfully!");
define("PERMISSION_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("PERMISSION_MODULE_UPDATION_DUPLICATE", "User name already exists.");
define("PERMISSION_MODULE_CREATION_SUCCESS", "Permission created successfully!");
define("PERMISSION_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("PERMISSION_MODULE_CREATION_DUPLICATE", "User name already exists.");
define("PERMISSION_MODULE_DELETE_SUCCESS", "Permission deleted successfully!");
define("PERMISSION_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("PERMISSION_MODULE_DELETE_exists", "User containing employee cannot be deleted.");


////////////////////////// EMPLOYEE LEAVE MODULE MESSAGES   ///////////////////////////////

define("EMPLOYEELEAVE_MODULE_GETALL", "No record found.");
define("EMPLOYEELEAVE_MODULE_WITHDRAW", "Leave withdraw sucessfully...");
define("EMPLOYEELEAVE_MODULE_CANCEL", "Leave cancel sucessfully...");
define("EMPLOYEELEAVE_LEAVE_REJECT", "Leave has been rejected.");
define("EMPLOYEELEAVE_LEAVE_APPROVE", "Leave has been approved.");
define("EMPLOYEELEAVE_LEAVE_FORWARD", "Leave Application forwarded");
define("EMPLOYEELEAVE_LEAVE_FORWARDALREADY", "Already Forwarded !!");
define("EMPLOYEELEAVE_MODULE_SUCCESS", "Leave updated successfully.");
define("EMPLOYEELEAVE_MODULE_FAILED", "Leave updation failed, due to no change in data.");
define("EMPLOYEELEAVE_MODULE_GETDETAIL_SUCCESS", "Leave fetched successfully!");
define("EMPLOYEELEAVE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("EMPLOYEELEAVE_MODULE_UPDATION_SUCCESS", "Leave has been updated successfully!");
define("EMPLOYEELEAVE_MODULE_UPDATION_FAILED", "There is some problem while leave Update.");
define("EMPLOYEELEAVE_MODULE_UPDATION_DUPLICATE", "Leave already exists.");
define("EMPLOYEELEAVE_MODULE_CREATION_SUCCESS", "Leave has been applied successfully!");
define("EMPLOYEELEAVE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("EMPLOYEELEAVE_MODULE_CREATION_DUPLICATE", "Leave already exists.");
define("EMPLOYEELEAVE_MODULE_DELETE_SUCCESS", "Leave deleted successfully!");
define("EMPLOYEELEAVE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("EMPLOYEELEAVE_MODULE_DELETE_exists", "Leave containing employee cannot be deleted.");
define("EMPLOYEELEAVE_MODULE_REJECT_SUCCESS", "Leave Reject successfully!");
define("EMPLOYEELEAVE_MODULE_REJECT_FAILED", "There is some problem while leave Reject.");
////////////////////////// POLICY MODULE MESSAGES   ///////////////////////////////

define("POLICY_MODULE_GETALL", "No record found.");
define("POLICY_MODULE_GETDETAIL_SUCCESS", "Policy fetched successfully!");
define("POLICY_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("POLICY_MODULE_UPDATION_SUCCESS", "Policy updated successfully!");
define("POLICY_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("POLICY_MODULE_UPDATION_DUPLICATE", "Policy already exists.");
define("POLICY_MODULE_CREATION_SUCCESS", "Policy created successfully!");
define("POLICY_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("POLICY_MODULE_CREATION_DUPLICATE", "Policy already exists.");
define("POLICY_MODULE_DELETE_SUCCESS", "Policy deleted successfully!");
define("POLICY_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("POLICY_MODULE_DELETE_exists", "Policy containing employee cannot be deleted.");


////////////////////////// ATTENDANCETYPE MODULE MESSAGES   ///////////////////////////////

define("ATTENDANCETYPE_MODULE_GETALL", "No record found.");
define("ATTENDANCETYPE_MODULE_GETDETAIL_SUCCESS", "Attendance fetched successfully!");
define("ATTENDANCETYPE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("ATTENDANCETYPE_MODULE_UPDATION_SUCCESS", "Attendance updated successfully!");
define("ATTENDANCETYPE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("ATTENDANCETYPE_MODULE_UPDATION_DUPLICATE", "Attendance name already exists.");
define("ATTENDANCETYPE_MODULE_CREATION_SUCCESS", "Attendance created successfully!");
define("ATTENDANCETYPE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("ATTENDANCETYPE_MODULE_CREATION_DUPLICATE", "Attendance name already exists.");
define("ATTENDANCETYPE_MODULE_DELETE_SUCCESS", "Attendance deleted successfully!");
define("ATTENDANCETYPE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("ATTENDANCETYPE_MODULE_DELETE_exists", "Attendance containing employee cannot be deleted.");


////////////////////////// SALARYTYPE MODULE MESSAGES   ///////////////////////////////

define("SALARYTYPE_MODULE_GETALL", "No record found.");
define("SALARYTYPE_MODULE_GETDETAIL_SUCCESS", "Salary Type fetched successfully!");
define("SALARYTYPE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("SALARYTYPE_MODULE_UPDATION_SUCCESS", "Salary Type updated successfully!");
define("SALARYTYPE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("SALARYTYPE_MODULE_UPDATION_DUPLICATE", "Salary Type already exists.");
define("SALARYTYPE_MODULE_CREATION_SUCCESS", "Salary Type created successfully!");
define("SALARYTYPE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("SALARYTYPE_MODULE_CREATION_DUPLICATE", "Salary Type already exists.");
define("SALARYTYPE_MODULE_DELETE_SUCCESS", "Salary Type deleted successfully!");
define("SALARYTYPE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("SALARYTYPE_MODULE_DELETE_exists", "Salary Type containing employee cannot be deleted.");



////////////////////////// SALARYDISTRIBUTION MODULE MESSAGES   ///////////////////////////////

define("SALARYDISTRIBUTION_MODULE_GETALL", "No record found.");
define("SALARYDISTRIBUTION_MODULE_GETDETAIL_SUCCESS", "Salary Distribution fetched successfully!");
define("SALARYDISTRIBUTION_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("SALARYDISTRIBUTION_MODULE_UPDATION_SUCCESS", "Salary Distribution updated successfully!");
define("SALARYDISTRIBUTION_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("SALARYDISTRIBUTION_MODULE_UPDATION_DUPLICATE", "Salary Distribution name already exists.");
define("SALARYDISTRIBUTION_MODULE_CREATION_SUCCESS", "Salary Distribution created successfully!");
define("SALARYDISTRIBUTION_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("SALARYDISTRIBUTION_MODULE_CREATION_DUPLICATE", "Salary Distribution name already exists.");
define("SALARYDISTRIBUTION_MODULE_DELETE_SUCCESS", "Salary Distribution deleted successfully!");
define("SALARYDISTRIBUTION_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("SALARYDISTRIBUTION_MODULE_DELETE_exists", "Salary Distribution containing employee cannot be deleted.");


////////////////////////// FISCAL MODULE MESSAGES   ///////////////////////////////

define("FISCAL_MODULE_GETALL", "Fiscal year not found");
define("FISCAL_MODULE_GETDETAIL_SUCCESS", "Fiscal year fetched successfully!");
define("FISCAL_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("FISCAL_MODULE_UPDATION_SUCCESS", "Fiscal year updated successfully!");
define("FISCAL_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("FISCAL_MODULE_UPDATION_DUPLICATE", "Fiscal year name already exists.");
define("FISCAL_MODULE_CREATION_SUCCESS", "Fiscal year created successfully!");
define("FISCAL_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("FISCAL_MODULE_CREATION_DUPLICATE", "Fiscal year name already exists.");
define("FISCAL_MODULE_DELETE_SUCCESS", "Fiscal year deleted successfully!");
define("FISCAL_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("FISCAL_MODULE_DELETE_exists", "Fiscal year containing employee cannot be deleted.");

////////////////////////// NOTIFICATION MODULE MESSAGES   ///////////////////////////////

define("NOTIFICATION_MODULE_GETALL", "No record found.");
define("NOTIFICATION_MODULE_GETDETAIL_SUCCESS", "Circular  fetched successfully!");
define("NOTIFICATION_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("NOTIFICATION_MODULE_UPDATION_SUCCESS", "Circular  updated successfully!");
define("NOTIFICATION_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("NOTIFICATION_MODULE_UPDATION_DUPLICATE", "Circular  already exists.");
define("NOTIFICATION_MODULE_CREATION_SUCCESS", "Circular  created successfully!");
define("NOTIFICATION_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("NOTIFICATION_MODULE_CREATION_DUPLICATE", "Circular already exists .");
define("NOTIFICATION_MODULE_DELETE_SUCCESS", "Circular  deleted successfully!");
define("NOTIFICATION_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("NOTIFICATION_MODULE_DELETE_exists", "Circular  containing employee cannot be deleted.");

////////////////////////// ISSUEASSET MODULE MESSAGES   ///////////////////////////////

define("ISSUEASSET_MODULE_GETALL", "No record found.");
define("ISSUEASSET_MODULE_GETDETAIL_SUCCESS", "Issue Asset fetched successfully!");
define("ISSUEASSET_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("ISSUEASSET_MODULE_UPDATION_SUCCESS", "Issue Asset updated successfully!");
define("ISSUEASSET_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("ISSUEASSET_MODULE_UPDATION_DUPLICATE", "Issue Asset already exists.");
define("ISSUEASSET_MODULE_CREATION_SUCCESS", "Issue Asset created successfully!");
define("ISSUEASSET_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("ISSUEASSET_MODULE_CREATION_DUPLICATE", "Issue Asset already exists.");
define("ISSUEASSET_MODULE_DELETE_SUCCESS", "Issue Asset deleted successfully!");
define("ISSUEASSET_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("ISSUEASSET_MODULE_DELETE_exists", "Issue Asset containing employee cannot be deleted.");


////////////////////////// SALARYMASTER MODULE MESSAGES   ///////////////////////////////

define("SALARYMASTER_MODULE_GETALL", "No record found.");
define("SALARYMASTER_MODULE_GETDETAIL_SUCCESS", "Salary  fetched successfully!");
define("SALARYMASTER_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("SALARYMASTER_MODULE_UPDATION_SUCCESS", "Salary  updated successfully!");
define("SALARYMASTER_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("SALARYMASTER_MODULE_UPDATION_DUPLICATE", "Salary  already exists.");
define("SALARYMASTER_MODULE_CREATION_SUCCESS", "Salary generated successfully!");
define("SALARYMASTER_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("SALARYMASTER_MODULE_CREATION_DUPLICATE", "Salary  already exists.");
define("SALARYMASTER_MODULE_DELETE_SUCCESS", "Salary  deleted successfully!");
define("SALARYMASTER_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("SALARYMASTER_MODULE_DELETE_exists", "Salary  containing employee cannot be deleted.");

////////////////////////// GRIEVANCE MODULE MESSAGES   ///////////////////////////////

define("GRIEVANCE_MODULE_GETALL", "No record found.");
define("GRIEVANCE_MODULE_GETDETAIL_SUCCESS", "Grievance  fetched successfully!");
define("GRIEVANCE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("GRIEVANCE_MODULE_UPDATION_SUCCESS", "Your grievance has been lodged!");
define("GRIEVANCE_MODULE_ESCALATE_SUCCESS", "Grievance has been escalated!");
define("GRIEVANCE_MODULE_RESOLVE_SUCCESS", "Grievance has been resolved!");
define("GRIEVANCE_MODULE_DISMISS_SUCCESS", "Grievance has been dismissed!");
define("GRIEVANCE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("GRIEVANCE_MODULE_UPDATION_DUPLICATE", "Grievance  already exists.");
define("GRIEVANCE_MODULE_CREATION_SUCCESS", "Your grievance has been lodged!");
define("GRIEVANCE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("GRIEVANCE_MODULE_CREATION_DUPLICATE", "Grievance already exists.");
define("GRIEVANCE_MODULE_DELETE_SUCCESS", "Grievance  deleted successfully!");
define("GRIEVANCE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("GRIEVANCE_MODULE_DELETE_exists", "Grievance  containing employee cannot be deleted.");


////////////////////////// SALARYADVANCE MODULE MESSAGES   ///////////////////////////////

define("SALARYADVANCE_MODULE_GETALL", "No record found.");
define("SALARYADVANCE_MODULE_APPROVE", "Personal loan application has been approved..");
define("SALARYADVANCE_MODULE_REJECT", "Personal loan application has been Rejected..");
define("SALARYADVANCE_MODULE_FORWARD", "Personal loan application has been Forwarded..");
define("SALARYADVANCE_MODULE_FORWARDALREADY", "Already Forwarded..");
define("SALARYADVANCE_MODULE_AMOUNTUNEQUAL", "Installment / Amount  is unequal");

define("SALARYADVANCE_MODULE_GETDETAIL_SUCCESS", "Personal Loan details fetched successfully!");
define("SALARYADVANCE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("SALARYADVANCE_MODULE_UPDATION_SUCCESS", "Request for personal loan has been updated!");
define("SALARYADVANCE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("SALARYADVANCE_MODULE_UPDATION_DUPLICATE", "Personal Loan already exists.");
define("SALARYADVANCE_MODULE_CREATION_SUCCESS", "Request for personal loan has been sent!");
define("SALARYADVANCE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("SALARYADVANCE_MODULE_CREATION_DUPLICATE", "Personal Loan  already exists.");
define("SALARYADVANCE_MODULE_DELETE_SUCCESS", "Personal Loan  deleted successfully!");
define("SALARYADVANCE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("SALARYADVANCE_MODULE_DELETE_exists", "Personal Loan  containing employee cannot be deleted.");
////////////////////////// RELATION MODULE MESSAGES   ///////////////////////////////

define("RELATION_MODULE_GETALL", "No record found.");
define("RELATION_MODULE_GETDETAIL_SUCCESS", "Relation  fetched successfully!");
define("RELATION_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("RELATION_MODULE_UPDATION_SUCCESS", "Relation  updated successfully!");
define("RELATION_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("RELATION_MODULE_UPDATION_DUPLICATE", "Relation  already exists.");
define("RELATION_MODULE_CREATION_SUCCESS", "Relation  created successfully!");
define("RELATION_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("RELATION_MODULE_CREATION_DUPLICATE", "Relation  already exists.");
define("RELATION_MODULE_DELETE_SUCCESS", "Relation deleted successfully!");
define("RELATION_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("RELATION_MODULE_DELETE_exists", "Relation  containing employee cannot be deleted.");

////////////////////////// CREDITCARD MODULE MESSAGES   ///////////////////////////////

define("CREDITCARD_MODULE_GETALL", "No record found.");
define("CREDITCARD_MODULE_GETDETAIL_SUCCESS", "Credit card  fetched successfully!");
define("CREDITCARD_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("CREDITCARD_MODULE_UPDATION_SUCCESS", "Credit card type updated successfully!");
define("CREDITCARD_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("CREDITCARD_MODULE_UPDATION_DUPLICATE", "Credit card  already exists.");
define("CREDITCARD_MODULE_CREATION_SUCCESS", "Credit card type  created successfully!");
define("CREDITCARD_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("CREDITCARD_MODULE_CREATION_DUPLICATE", "Credit card  already exists.");
define("CREDITCARD_MODULE_DELETE_SUCCESS", "Credit card deleted successfully!");
define("CREDITCARD_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("CREDITCARD_MODULE_DELETE_exists", "Credit card  containing employee cannot be deleted.");

////////////////////////// BANK MODULE MESSAGES   ///////////////////////////////

define("BANK_MODULE_GETALL", "No record found.");
define("BANK_MODULE_GETDETAIL_SUCCESS", "Bank  fetched successfully!");
define("BANK_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("BANK_MODULE_UPDATION_SUCCESS", "Bank  updated successfully!");
define("BANK_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("BANK_MODULE_UPDATION_DUPLICATE", "Bank  code or name already exists.");
define("BANK_MODULE_CREATION_SUCCESS", "Bank  created successfully!");
define("BANK_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("BANK_MODULE_CREATION_DUPLICATE", "Bank  code or name already exists.");
define("BANK_MODULE_DELETE_SUCCESS", "Bank deleted successfully!");
define("BANK_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("BANK_MODULE_DELETE_exists", "Bank  containing employee cannot be deleted.");

////////////////////////// INSURANCE MODULE MESSAGES   ///////////////////////////////

define("INSURANCE_MODULE_GETALL", "No record found.");
define("INSURANCE_MODULE_GETDETAIL_SUCCESS", "Insurance  fetched successfully!");
define("INSURANCE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("INSURANCE_MODULE_UPDATION_SUCCESS", "Insurance  updated successfully!");
define("INSURANCE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("INSURANCE_MODULE_UPDATION_DUPLICATE", "Insurance  name already exists.");
define("INSURANCE_MODULE_CREATION_SUCCESS", "Insurance  created successfully!");
define("INSURANCE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("INSURANCE_MODULE_CREATION_DUPLICATE", "Insurance  name already exists.");
define("INSURANCE_MODULE_DELETE_SUCCESS", "Insurance deleted successfully!");
define("INSURANCE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("INSURANCE_MODULE_DELETE_exists", "Insurance  containing employee cannot be deleted.");

////////////////////////// LEAVEELIGIBILITY MODULE MESSAGES   ///////////////////////////////

define("LEAVEELIGIBILITY_MODULE_GETALL", "No record found.");
define("LEAVEELIGIBILITY_MODULE_GETDETAIL_SUCCESS", "Leave Eligibility  fetched successfully!");
define("LEAVEELIGIBILITY_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("LEAVEELIGIBILITY_MODULE_UPDATION_SUCCESS", "Leave Eligibility  updated successfully!");
define("LEAVEELIGIBILITY_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("LEAVEELIGIBILITY_MODULE_UPDATION_DUPLICATE", "Leave Eligibility  name already exists.");
define("LEAVEELIGIBILITY_MODULE_CREATION_SUCCESS", "Leave Eligibility  created successfully!");
define("LEAVEELIGIBILITY_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("LEAVEELIGIBILITY_MODULE_CREATION_DUPLICATE", "Leave Eligibility  name already exists.");
define("LEAVEELIGIBILITY_MODULE_DELETE_SUCCESS", "Leave Eligibility deleted successfully!");
define("LEAVEELIGIBILITY_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("LEAVEELIGIBILITY_MODULE_DELETE_exists", "Leave Eligibility  containing employee cannot be deleted.");


////////////////////////// REPORT MODULE MESSAGES   ///////////////////////////////

define("REPORT_MODULE_GETALL", "No record found.");
define("REPORT_MODULE_GETDETAIL_SUCCESS", "Report  fetched successfully!");
define("REPORT_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("REPORT_MODULE_UPDATION_SUCCESS", "Report  updated successfully!");
define("REPORT_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("REPORT_MODULE_UPDATION_DUPLICATE", "Report  already exists.");
define("REPORT_MODULE_CREATION_SUCCESS", "Report  created successfully!");
define("REPORT_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("REPORT_MODULE_CREATION_DUPLICATE", "Report already exists.");
define("REPORT_MODULE_DELETE_SUCCESS", "Report deleted successfully!");
define("REPORT_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("REPORT_MODULE_DELETE_exists", "Report  containing employee cannot be deleted.");


////////////////////////// ROOTFARE MODULE MESSAGES   ///////////////////////////////

define("ROOTFARE_MODULE_GETALL", "No record found.");
define("ROOTFARE_MODULE_GETDETAIL_SUCCESS", "Root Fare  fetched successfully!");
define("ROOTFARE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("ROOTFARE_MODULE_UPDATION_SUCCESS", "Root Fare  updated successfully!");
define("ROOTFARE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("ROOTFARE_MODULE_UPDATION_DUPLICATE", "Root Fare already exists with the entered detail.");
define("ROOTFARE_MODULE_CREATION_SUCCESS", "Root Fare  created successfully!");
define("ROOTFARE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("ROOTFARE_MODULE_CREATION_DUPLICATE", "Root Fare already exists with the entered detail.");
define("ROOTFARE_MODULE_DELETE_SUCCESS", "Root Fare deleted successfully!");
define("ROOTFARE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("ROOTFARE_MODULE_DELETE_exists", "Root Fare  containing employee cannot be deleted.");
define("ROOTFARE_MODULE_FISCAL_NOT_FOUND", "Fiscal year not found, for this entry.");

////////////////////////// JOBMODIFICATION MODULE MESSAGES   ///////////////////////////////

define("JOBMODIFICATION_MODULE_GETALL", "No record found.");
define("JOBMODIFICATION_MODULE_GETDETAIL_SUCCESS", "Job fetched successfully!");
define("JOBMODIFICATION_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("JOBMODIFICATION_MODULE_UPDATION_SUCCESS", "Job updated successfully!");
define("JOBMODIFICATION_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("JOBMODIFICATION_MODULE_UPDATION_DUPLICATE", "Job name already exists.");
define("JOBMODIFICATION_MODULE_CREATION_SUCCESS", "Job created successfully!");
define("TRANSFER_MODULE_CREATION_SUCCESS", "Location / Department / Location / Designation was changed!");
define("PROMOTION_MODULE_CREATION_SUCCESS", "Designation / Grade/ Gross Salary was upgraded!");
define("TERMINATION_MODULE_CREATION_SUCCESS", "Confirmation was upgraded!");
define("JOBMODIFICATION_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("JOBMODIFICATION_MODULE_CREATION_DUPLICATE", "Record already exists.");
define("JOBMODIFICATION_MODULE_DELETE_SUCCESS", "Record deleted successfully!");
define("JOBMODIFICATION_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("JOBMODIFICATION_MODULE_DELETE_exists", "Record containing employee cannot be deleted.");


////////////////////////// OFFICELETTER MODULE MESSAGES   ///////////////////////////////

define("OFFICELETTER_MODULE_GETALL", "No record found.");
define("OFFICELETTER_MODULE_GETDETAIL_SUCCESS", "Office Letter fetched successfully!");
define("OFFICELETTER_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("OFFICELETTER_MODULE_UPDATION_SUCCESS", "Office Letter updated successfully!");
define("OFFICELETTER_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("OFFICELETTER_MODULE_UPDATION_DUPLICATE", "Office Letter name already exists.");
define("OFFICELETTER_MODULE_CREATION_SUCCESS", "Office Letter Issued successfully!");
define("OFFICELETTER_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("OFFICELETTER_MODULE_CREATION_DUPLICATE", "Office Letter name already exists.");
define("OFFICELETTER_MODULE_DELETE_SUCCESS", "Office LetterDeleted successfully!");
define("OFFICELETTER_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("OFFICELETTER_MODULE_DELETE_exists", "Office Letter containing employee cannot be deleted.");

////////////////////////// SETTINGS MODULE MESSAGES   ///////////////////////////////

define("SETTINGS_MODULE_GETALL", "No record found.");
define("SETTINGS_MODULE_GETDETAIL_SUCCESS", "Settings fetched successfully!");
define("SETTINGS_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("SETTINGS_MODULE_UPDATION_SUCCESS", "Settings updated successfully!");
define("SETTINGS_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("SETTINGS_MODULE_UPDATION_DUPLICATE", "Settings name already exists.");
define("SETTINGS_MODULE_CREATION_SUCCESS", "Settings created successfully!");
define("SETTINGS_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("SETTINGS_MODULE_CREATION_DUPLICATE", "Settings name already exists.");
define("SETTINGS_MODULE_DELETE_SUCCESS", "SettingsDeleted successfully!");
define("SETTINGS_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("SETTINGS_MODULE_DELETE_exists", "Settings containing employee cannot be deleted.");

////////////////////////// DOCUMENT LIBRARY MODULE MESSAGES   ///////////////////////////////

define("DOCLIBRARY_MODULE_GETALL", "No record found.");
define("DOCLIBRARY_MODULE_GETDETAIL_SUCCESS", "Document Library fetched successfully!");
define("DOCLIBRARY_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("DOCLIBRARY_MODULE_UPDATION_SUCCESS", "Document Library updated successfully!");
define("DOCLIBRARY_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("DOCLIBRARY_MODULE_UPDATION_DUPLICATE", "Document Library name already exists.");
define("DOCLIBRARY_MODULE_CREATION_SUCCESS", "Document Library created successfully!");
define("DOCLIBRARY_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("DOCLIBRARY_MODULE_CREATION_DUPLICATE", "Document Library name already exists.");
define("DOCLIBRARY_MODULE_DELETE_SUCCESS", "Document LibraryDeleted successfully!");
define("DOCLIBRARY_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("DOCLIBRARY_MODULE_DELETE_exists", "Document Library containing employee cannot be deleted.");
////////////////////////// DOCUMENT REQUEST MODULE MESSAGES   ///////////////////////////////

define("DOCUMENT_REQUEST_MODULE_GETALL", "No record found.");
define("DOCUMENT_REQUEST_APPROVED", "Document request has been approved.");
define("DOCUMENT_REQUEST_REJECTED", "Document request has been rejected.");
define("DOCUMENT_REQUEST_MODULE_GETDETAIL_SUCCESS", "Document fetched successfully!");
define("DOCUMENT_REQUEST_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("DOCUMENT_REQUEST_MODULE_UPDATION_SUCCESS", "Your request for documents has been updated!");
define("DOCUMENT_REQUEST_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("DOCUMENT_REQUEST_MODULE_UPDATION_DUPLICATE", "Document code already exists.");
define("DOCUMENT_REQUEST_MODULE_CREATION_SUCCESS", "Your request for documents has been sent!");
define("DOCUMENT_REQUEST_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("DOCUMENT_REQUEST_MODULE_CREATION_DUPLICATE", "Document code already exists.");
define("DOCUMENT_REQUEST_MODULE_DELETE_SUCCESS", "Document deleted successfully!");
define("DOCUMENT_REQUEST_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("DOCUMENT_REQUEST_MODULE_DELETE_exists", "Document containing employee cannot be deleted.");

////////////////////////// QUADRANT MODULE MESSAGES   ///////////////////////////////

define("QUADRANT_MODULE_GETALL", "No record found.");
define("QUADRANT_MODULE_DELETE_exists", "This Competency used in objectives so can't be delete...");
define("QUADRANT_MODULE_GETDETAIL_SUCCESS", "Competency fetched successfully!");
define("QUADRANT_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("QUADRANT_MODULE_UPDATION_SUCCESS", "Competency updated successfully!");
define("QUADRANT_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("QUADRANT_MODULE_UPDATION_DUPLICATE", "Competency already exists.");
define("QUADRANT_MODULE_CREATION_SUCCESS", "Competency created successfully!");
define("QUADRANT_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("QUADRANT_MODULE_CREATION_DUPLICATE", "Competency already exists.");
define("QUADRANT_MODULE_DELETE_SUCCESS", "Competency deleted successfully!");
define("QUADRANT_MODULE_DELETE_FAILED", "There is some problem while deleting Competency.");


////////////////////////// OBJECTIVE MODULE MESSAGES   ///////////////////////////////

define("OBJECTIVE_MODULE_GETALL", "No record found.");
define("OBJECTIVE_MODULE_GETDETAIL_SUCCESS", "Performance Configuration fetched successfully!");
define("OBJECTIVE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("OBJECTIVE_MODULE_UPDATION_SUCCESS", "Performance configuration updated successfully!");
define("OBJECTIVE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("OBJECTIVE_MODULE_UPDATION_DUPLICATE", "Performance for this Designation already configured.");
define("OBJECTIVE_MODULE_CREATION_SUCCESS", "Performance configured successfully!");
define("OBJECTIVE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("OBJECTIVE_MODULE_CREATION_DUPLICATE", "Performance for this Designation already configured.");
define("OBJECTIVE_MODULE_DELETE_SUCCESS", "Performance configuration deleted successfully!");
define("OBJECTIVE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("OBJECTIVE_MODULE_DELETE_exists", "Can't delete because this configuration used in Assessment...");

////////////////////////// ASSESSMENT MODULE MESSAGES   ///////////////////////////////

define("ASSESSMENT_MODULE_GETALL", "No record found.");
define("ASSESSMENT_MODULE_GETDETAIL_SUCCESS", "Assessment fetched successfully!");
define("ASSESSMENT_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("ASSESSMENT_MODULE_UPDATION_SUCCESS", "Assessment updated successfully!");
define("ASSESSMENT_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("ASSESSMENT_MODULE_UPDATION_DUPLICATE", "Assessment for this Designation already exists.");
define("ASSESSMENT_MODULE_CREATION_SUCCESS", "Assessment created successfully!");
define("ASSESSMENT_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("ASSESSMENT_MODULE_CREATION_DUPLICATE", "Assessment for this Designation already exists.");
define("ASSESSMENT_MODULE_DELETE_SUCCESS", "Assessment deleted successfully!");
define("ASSESSMENT_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("ASSESSMENT_MODULE_DELETE_exists", "Assessment containing employee cannot be deleted.");

////////////////////////// APPROVALPROCESS MODULE MESSAGES   ///////////////////////////////

define("APPROVALPROCESS_MODULE_GETALL", "No record found.");
define("APPROVALPROCESS_MODULE_GETDETAIL_SUCCESS", "Approval fetched successfully!");
define("APPROVALPROCESS_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("APPROVALPROCESS_MODULE_UPDATION_SUCCESS", "Approval updated successfully!");
define("APPROVALPROCESS_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("APPROVALPROCESS_MODULE_UPDATION_DUPLICATE", "Approval Name already exists.");
define("APPROVALPROCESS_MODULE_CREATION_SUCCESS", "Approval created successfully!");
define("APPROVALPROCESS_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("APPROVALPROCESS_MODULE_CREATION_DUPLICATE", "Approval Name already exists.");
define("APPROVALPROCESS_MODULE_DELETE_SUCCESS", "Approval deleted successfully!");
define("APPROVALPROCESS_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("APPROVALPROCESS_MODULE_DELETE_exists", "Approval containing employee cannot be deleted.");

////////////////////////// RESIGNATION MODULE MESSAGES   ///////////////////////////////

define("RESIGNATION_MODULE_GETALL", "No record found.");
define("RESIGNATION_MODULE_SENT", "Your Resignation has been sent successfully.");
define("RESIGNATION_MODULE_CANCEL", "Resignation Cancel sucessfully..");
define("RESIGNATION_MODULE_WITHDRAW", "Resignation Withdraw sucessfully..");
define("RESIGNATION_MODULE_REAPPLY", "Re-apply again for Resignation..");
define("RESIGNATION_MODULE_GETDETAIL_SUCCESS", "Resignation fetched successfully!");
define("RESIGNATION_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("RESIGNATION_MODULE_UPDATION_SUCCESS", "Resignation updated successfully!");
define("RESIGNATION_MODULE_UPDATION_FAILED", "There is some problem while sending resignation !");
define("RESIGNATION_MODULE_UPDATION_DUPLICATE", "Resignation Name already exists.");
define("RESIGNATION_MODULE_CREATION_SUCCESS", "Resignation created successfully!");
define("RESIGNATION_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("RESIGNATION_MODULE_CREATION_DUPLICATE", "Resignation Name already exists.");
define("RESIGNATION_MODULE_DELETE_SUCCESS", "Resignation deleted successfully!");
define("RESIGNATION_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("RESIGNATION_MODULE_DELETE_exists", "Resignation containing employee cannot be deleted.");

////////////////////////// CITY MODULE MESSAGES   ///////////////////////////////

define("CITY_MODULE_GETALL", "No record found.");
define("CITY_MODULE_GETDETAIL_SUCCESS", "City  fetched successfully!");
define("CITY_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("CITY_MODULE_UPDATION_SUCCESS", "City  updated successfully!");
define("CITY_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("CITY_MODULE_UPDATION_DUPLICATE", "City already exists.");
define("CITY_MODULE_CREATION_SUCCESS", "City  created successfully!");
define("CITY_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("CITY_MODULE_CREATION_DUPLICATE", "City  already exists.");
define("CITY_MODULE_DELETE_SUCCESS", "City deleted successfully!");
define("CITY_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("CITY_MODULE_DELETE_exists", "City  containing employee cannot be deleted.");

////////////////////////// SEVERANCE MODULE MESSAGES   ///////////////////////////////

define("SEVERANCE_MODULE_GETALL", "No record found.");
define("SEVERANCE_MODULE_GETDETAIL_SUCCESS", "Severance  fetched successfully!");
define("SEVERANCE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("SEVERANCE_MODULE_UPDATION_SUCCESS", "Severance updated successfully!");
define("SEVERANCE_MODULE_UPDATION_FAILED", "Updation failed, due to no change found.");
define("SEVERANCE_MODULE_UPDATION_DUPLICATE", "Severance already exists with the entered details.");
define("SEVERANCE_MODULE_SELF_CREATION_SUCCESS", "Your resignation request has been sent for approval!");
define("SEVERANCE_MODULE_CREATION_ABSCOND", "Employee has been Absconded!");
define("SEVERANCE_MODULE_CREATION_SUCCESS", "Severance in process!");
define("SEVERANCE_MODULE_APPROVAL_SUCCESS", "Severance request has been sent to HR for sending acceptance letter!");
define("SEVERANCE_MODULE_WITHDRAW_SUCCESS", "Your resignation has been withdrawn!");
define("SEVERANCE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("SEVERANCE_MODULE_CREATION_DUPLICATE", "Severance already exists with the entered details.");
define("SEVERANCE_MODULE_DELETE_SUCCESS", "Severance deleted successfully!");
define("SEVERANCE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("SEVERANCE_MODULE_DELETE_exists", "Severance  containing employee cannot be deleted.");

////////////////////////// COMPETENCYTYPE MODULE MESSAGES   ///////////////////////////////

define("COMPETENCYTYPE_MODULE_GETALL", "No record found.");
define("COMPETENCYTYPE_MODULE_GETDETAIL_SUCCESS", "Competency type  fetched successfully!");
define("COMPETENCYTYPE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("COMPETENCYTYPE_MODULE_UPDATION_SUCCESS", "Competency type updated successfully!");
define("COMPETENCYTYPE_MODULE_UPDATION_FAILED", "Updation failed, due to no change found.");
define("COMPETENCYTYPE_MODULE_UPDATION_DUPLICATE", "Competency type already exists with the entered details.");
define("COMPETENCYTYPE_MODULE_CREATION_SUCCESS", "Competency type created successfully!");
define("COMPETENCYTYPE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("COMPETENCYTYPE_MODULE_CREATION_DUPLICATE", "Competency type already exists with the entered details.");
define("COMPETENCYTYPE_MODULE_DELETE_SUCCESS", "Competency type deleted successfully!");
define("COMPETENCYTYPE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("COMPETENCYTYPE_MODULE_DELETE_exists", "Competency type  containing employee cannot be deleted.");

////////////////////////// COMPETENCY MODULE MESSAGES   ///////////////////////////////

define("COMPETENCY_MODULE_GETALL", "No record found.");
define("COMPETENCY_MODULE_GETDETAIL_SUCCESS", "Competency fetched successfully!");
define("COMPETENCY_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("COMPETENCY_MODULE_UPDATION_SUCCESS", "Competency updated successfully!");
define("COMPETENCY_MODULE_UPDATION_FAILED", "Updation failed, due to no change found.");
define("COMPETENCY_MODULE_UPDATION_DUPLICATE", "Competency already exists with the entered details.");
define("COMPETENCY_MODULE_CREATION_SUCCESS", "Competency created successfully!");
define("COMPETENCY_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("COMPETENCY_MODULE_CREATION_DUPLICATE", "Competency already exists with the entered details.");
define("COMPETENCY_MODULE_DELETE_SUCCESS", "Competency deleted successfully!");
define("COMPETENCY_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("COMPETENCY_MODULE_DELETE_exists", "Competency containing employee cannot be deleted.");

////////////////////////// COMPETENCYANALYSIS MODULE MESSAGES   ///////////////////////////////

define("COMPETENCYANALYSIS_MODULE_GETALL", "No record found.");
define("COMPETENCYANALYSIS_MODULE_GETDETAIL_SUCCESS", "Competency Analysis fetched successfully!");
define("COMPETENCYANALYSIS_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("COMPETENCYANALYSIS_MODULE_UPDATION_SUCCESS", "Competency Analysis updated successfully!");
define("COMPETENCYANALYSIS_MODULE_UPDATION_FAILED", "Updation failed, due to no change found.");
define("COMPETENCYANALYSIS_MODULE_UPDATION_DUPLICATE", "Competency Analysis already exists with the entered details.");
define("COMPETENCYANALYSIS_MODULE_CREATION_SUCCESS", "Competency Analysis created successfully!");
define("COMPETENCYANALYSIS_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("COMPETENCYANALYSIS_MODULE_CREATION_DUPLICATE", "Competency Analysis already exists with the entered details.");
define("COMPETENCYANALYSIS_MODULE_DELETE_SUCCESS", "Competency Analysis deleted successfully!");
define("COMPETENCYANALYSIS_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("COMPETENCYANALYSIS_MODULE_DELETE_exists", "Can't delete because it is used in Analysis..");

////////////////////////// CERTIFICATE MODULE MESSAGES   ///////////////////////////////

define("CERTIFICATE_MODULE_GETALL", "No record found.");
define("CERTIFICATE_MODULE_GETDETAIL_SUCCESS", "Certificate fetched successfully!");
define("CERTIFICATE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("CERTIFICATE_MODULE_UPDATION_SUCCESS", "Certificate updated successfully!");
define("CERTIFICATE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("CERTIFICATE_MODULE_UPDATION_DUPLICATE", "Certificate code already exists.");
define("CERTIFICATE_MODULE_CREATION_SUCCESS", "Certificate type added!");
define("CERTIFICATE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("CERTIFICATE_MODULE_CREATION_DUPLICATE", "Certificate code already exists.");
define("CERTIFICATE_MODULE_DELETE_SUCCESS", "Certificate deleted successfully!");
define("CERTIFICATE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("CERTIFICATE_MODULE_DELETE_exists", "Certificate containing employee cannot be deleted.");

////////////////////////// CERTIFICATE REQUEST MODULE MESSAGES   ///////////////////////////////

define("CERTIFICATE_REQUEST_MODULE_GETALL", "No record found.");
define("CERTIFICATE_REQUEST_APPROVED", "Certificate request has been approved.");
define("CERTIFICATE_REQUEST_REJECTED", "Certificate request has been rejected.");
define("CERTIFICATE_REQUEST_MODULE_GETDETAIL_SUCCESS", "Certificate fetched successfully!");
define("CERTIFICATE_REQUEST_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("CERTIFICATE_REQUEST_MODULE_UPDATION_SUCCESS", "Your request foo issue certificate has been updated!");
define("CERTIFICATE_REQUEST_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("CERTIFICATE_REQUEST_MODULE_UPDATION_DUPLICATE", "Certificate request already exists with the entered details.");
define("CERTIFICATE_REQUEST_MODULE_CREATION_SUCCESS", "Your request for issue certificate has been sent!");
define("CERTIFICATE_REQUEST_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("CERTIFICATE_REQUEST_MODULE_CREATION_DUPLICATE", "Certificate request already exists with the entered details.");
define("CERTIFICATE_REQUEST_MODULE_DELETE_SUCCESS", "Certificate deleted successfully!");
define("CERTIFICATE_REQUEST_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("CERTIFICATE_REQUEST_MODULE_DELETE_exists", "Certificate containing employee cannot be deleted.");

////////////////////////// EMPTYPE MODULE MESSAGES   ///////////////////////////////

define("EMPTYPE_MODULE_GETALL", "No record found.");
define("EMPTYPE_MODULE_GETDETAIL_SUCCESS", "Type fetched successfully!");
define("EMPTYPE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("EMPTYPE_MODULE_UPDATION_SUCCESS", "Type updated successfully!");
define("EMPTYPE_MODULE_UPDATION_FAILED", "Problem in updating this record.");
define("EMPTYPE_MODULE_UPDATION_DUPLICATE", "Type code already exists.");
define("EMPTYPE_MODULE_CREATION_SUCCESS", "Type created successfully!");
define("EMPTYPE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("EMPTYPE_MODULE_CREATION_DUPLICATE", "Type code already exists.");
define("EMPTYPE_MODULE_DELETE_SUCCESS", "Type deleted successfully!");
define("EMPTYPE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("EMPTYPE_MODULE_DELETE_exists", "Type containing employee cannot be deleted.");
////////////////////////// Performance Indicator MODULE MESSAGES   ///////////////////////////////

define("PERFORMANCE_INDICATOR_MODULE_GETALL", "No record found.");
define("PERFORMANCE_INDICATOR_MODULE_GETDETAIL_SUCCESS", "Performance indicator attribute fetched successfully!");
define("PERFORMANCE_INDICATOR_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("PERFORMANCE_INDICATOR_MODULE_UPDATION_SUCCESS", "Performance indicator attribute updated successfully!");
define("PERFORMANCE_INDICATOR_MODULE_UPDATION_FAILED", "Problem in updating this record.");

define("PERFORMANCE_INDICATOR_MODULE_CREATION_SUCCESS", "Performance indicator attribute created successfully!");
define("PERFORMANCE_INDICATOR_MODULE_CREATION_FAILED", "Problem in updating this record.");

define("PERFORMANCE_INDICATOR_MODULE_DELETE_SUCCESS", "Performance indicator attribute deleted successfully!");
define("PERFORMANCE_INDICATOR_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
////////////////////////// Performance Assess Indicator MODULE MESSAGES   ///////////////////////////////

define("PERFORMANCE_ASSESS_INDICATOR_MODULE_GETALL", "No record found.");
define("PERFORMANCE_ASSESS_INDICATOR_MODULE_GETDETAIL_SUCCESS", "Performance Assessment fetched successfully!");
define("PERFORMANCE_ASSESS_INDICATOR_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("PERFORMANCE_ASSESS_INDICATOR_MODULE_UPDATION_SUCCESS", "Performance Assessment updated successfully!");
define("PERFORMANCE_ASSESS_INDICATOR_MODULE_UPDATION_FAILED", "Problem in updating this record.");

define("PERFORMANCE_ASSESS_INDICATOR_MODULE_CREATION_SUCCESS", "Performance Assessment created successfully!");
define("PERFORMANCE_ASSESS_INDICATOR_MODULE_CREATION_FAILED", "Problem in updating this record.");

define("PERFORMANCE_ASSESS_INDICATOR_MODULE_DELETE_SUCCESS", "Performance Assessment deleted successfully!");
define("PERFORMANCE_ASSESS_INDICATOR_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("TRAINING_MODULE_CREATE_SUCCESS", "Training Scheduled successfully!");
define("TRAINING_MODULE_DELETE_SUCCESS", "Training Schedule  deleted successfully!");
define("TRAINING_MODULE_UPDATE_SUCCESS", "Training Schedule  updated successfully!");
////////////////////////// TASKS MODULE MESSAGES   ///////////////////////////////

define("TASK_MODULE_GETALL", "No record found.");
define("TASK_MODULE_GETDETAIL_SUCCESS", "Task fetched successfully!");
define("TASK_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("TASK_MODULE_UPDATION_SUCCESS", "Task updated successfully!");
define("TASK_MODULE_UPDATION_FAILED", "Problem in updating this record.");

define("TASK_MODULE_CREATION_SUCCESS", "Task created successfully!");
define("TASK_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("TASK_MODULE_CREATION_DUPLICATE", "Task code already exists.");
define("TASK_MODULE_DELETE_SUCCESS", "Task deleted successfully!");
define("TASK_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("TASK_MODULE_DELETE_exists", "Task containing employee cannot be deleted.");


///////////////////////// COSTCENTRE MODULE MESSAGES   ///////////////////////////////

define("COSTCENTRE_MODULE_GETALL", "No record found.");
define("COSTCENTRE_MODULE_GETDETAIL_SUCCESS", "Costcentre fetched successfully!");
define("COSTCENTRE_MODULE_GETDETAIL_FAILED", "Problem in updating this record.");
define("COSTCENTRE_MODULE_UPDATION_SUCCESS", "Costcentre updated successfully!");
define("COSTCENTRE_MODULE_UPDATION_FAILED", "Problem in updating this record.");

define("COSTCENTRE_MODULE_CREATION_SUCCESS", "Costcentre created successfully!");
define("COSTCENTRE_MODULE_CREATION_FAILED", "Problem in updating this record.");
define("COSTCENTRE_MODULE_CREATION_DUPLICATE", "Costcentre code already exists.");
define("COSTCENTRE_MODULE_DELETE_SUCCESS", "Costcentre deleted successfully!");
define("COSTCENTRE_MODULE_DELETE_FAILED", "There is some problem while deleting record.");
define("COSTCENTRE_MODULE_DELETE_exists", "Costcentre containing employee cannot be deleted.");
